/*
* @category    Carta Dental
* @package     OfiClinic Web
* @author      Jorge Ancizar Galeano Ruiz<desarrollo@ofisalud.com>
* @copyright   2010 Jorge Ancizar GAleano Ruiz
* @version     OfiClinic Web 1.0
* @license     COMERCIAL
* @link        http://www.ofisalud.com
* @country     Colombia
* @telephone   3016398114
*/

                                    
CartaDental001Ui = Ext.extend(Ext.Panel, {
    anchor: '100%',
    autoHeight: true,
    initComponent: function() {
        var stGridOdontogramasxPaciente = new StoreGridOdontogramasxPaciente();
        stGridOdontogramasxPaciente.load({
            params: {
                pPaciente: wPaciente
            }
        });
        
        function VerInfoOdontograma(value, metaData, record, rowIndex, colIndex, store){  
            metaData.attr = 'style="white-space:normal"';  
            return value + '</br>' + record.get('Profesional') + '</br>Tipo Odontograma:' + record.get('TipoOdontograma') + '</br>Tipo Denticion:' + record.get('TipoDenticion');
        }
        
        var OdontogramaInical = new Ext.Panel({ 
            autoLoad:{
                url:'../../../app/frm/odontograma/odontograma002.php?pPaciente=' + wPaciente + '&pCAS=' + wCAS,
                scripts:true,
                scope:this
            },
            id:'OdontogramaInical',
            height: 480,
            autoScroll:true,
            closable:false
        });
        
        //Store Locales
        var dataTipoDenticion = [
            ['TEMPORAL'],
            ['PERMANENTE'],
            ['MIXTA']
        ];
        var stTipoDenticion = new Ext.data.ArrayStore({
            fields: [
                {name: 'Descripcion'}
            ]
        });
        stTipoDenticion.loadData(dataTipoDenticion);
        
        this.tbar = [
            {
                html: 'Tipo Denticion:'
            },
            {
                xtype: 'combo',
                width: 110,
                allowBlank: true,
                store: stTipoDenticion,
                valueField: 'Descripcion',
                displayField: 'Descripcion',
                mode: 'local',
                forceSelection: true,
                typeAhead: true,
                typeAheadDelay: 10,
                triggerAction: 'all',
                id: 'sysBtnTipoDenticion'
            },
            {
                xtype: 'tbseparator'
            },
            {
                xtype: 'button',
                text: 'Crear Odontograma',
                iconCls: 'btnDiente',
                id: 'btnCrearOdontograma',
                listeners:{
                    click : function(){
                        if (parseInt(Ext.getCmp('sysYaGuardoHC').getValue()) === 0){
                            Ext.Msg.show({
                                title: 'eOfiClinic',
                                msg: 'Debe guardar la evolucion antes de gererar el odontograma',
                                buttons: Ext.Msg.OK,
                                icon: Ext.Msg.ERROR
                            });
                        }else{
                            if(Ext.getCmp('sysBtnTipoDenticion').getValue() === "" || Ext.getCmp('sysBtnTipoDenticion').getValue() === null){
                                Ext.Msg.show({
                                    title: 'eOfiClinic',
                                    msg: 'Debe seleccionar el tipo de denticion',
                                    buttons: Ext.Msg.OK,
                                    icon: Ext.Msg.ERROR
                                });
                            }else{
                                Ext.Ajax.request({
                                    url: '../../controlador/odontograma/controlador_odontograma.php',
                                    params:{
                                        task: 'OBTENER_ULTIMO_ODONTOGRAMA',
                                        pPaciente: wPaciente
                                    },
                                    success: function(response,options)
                                    {
                                        var Respuesta = response.responseText;
                                        var Contenido = Respuesta.split('^');
                                        if(Contenido[0] === "" || Contenido[0] === "{success:false}" || Contenido[0] === null){
                                            Ext.MessageBox.show({
                                                title: 'eOfiClinic',
                                                msg: 'Ocurrio un error al validar el odontograma del paciente.',
                                                buttons: Ext.MessageBox.OK,
                                                icon: Ext.MessageBox.ERROR
                                            });
                                        } else {
                                            var idOdontograma = parseInt(Contenido[0]);
                                            var tipoOdontograma = "Inicial";
                                            if(idOdontograma !== 0){
                                                tipoOdontograma = "Control";
                                            }
                                            Ext.Ajax.request({
                                                url: '../../controlador/odontograma/controlador_odontograma.php',
                                                params:{
                                                    task: 'CREAR_ODONTOGRAMA',
                                                    pPaciente: wPaciente,
                                                    pIdOdontograma: idOdontograma,
                                                    pTipoOdontograma: tipoOdontograma,
                                                    pFechaAtencion: Ext.getCmp('sysFechaHC').getValue(),
                                                    pProfesional:  Ext.getCmp('sysProfesionalHC').getValue(),
                                                    pCAS: wCAS,
                                                    pCliente: Ext.getCmp('sysIdClienteHC').getValue(),
                                                    pTipoDenticion: Ext.getCmp('sysBtnTipoDenticion').getValue(),
                                                    pUsuario: ID_USUARIO
                                                },
                                                success: function(response,options)
                                                {
                                                    var Respuesta = response.responseText;
                                                    var Contenido = Respuesta.split('^');
                                                    if(Contenido[0] === "" || Contenido[0] === "{success:false}" || Contenido[0] === null){
                                                        Ext.MessageBox.show({
                                                            title: 'eOfiClinic',
                                                            msg: 'Ocurrio un error al crear el odontograma del paciente.',
                                                            buttons: Ext.MessageBox.OK,
                                                            icon: Ext.MessageBox.ERROR
                                                        });
                                                    } else {
                                                        Ext.getCmp('gridOdontogramasxPaciente').store.reload();
                                                        var updater = Ext.getCmp('OdontogramaInical').getUpdater();
                                                        updater.setDefaultUrl('../../../app/frm/odontograma/odontograma002.php?pPaciente=' + wPaciente + '&pCAS=' + wCAS + '&pOdontograma=0');
                                                        updater.refresh();
                                                    }
                                                },
                                                failure: function(response,options){
                                                    Ext.MessageBox.show({
                                                        title: 'eOfiClinic',
                                                        msg: 'No podemos crear el odontograma y/o No se pudo establecer conexión con el servidor',
                                                        buttons: Ext.MessageBox.OK,
                                                        icon: Ext.MessageBox.ERROR
                                                    });
                                                },
                                                scope:this 
                                            });
                                        }
                                    },
                                    failure: function(response,options){
                                        Ext.MessageBox.show({
                                            title: 'Error Conexión',
                                            msg: 'No podemos crear el odontograma y/o No se pudo establecer conexión con el servidor',
                                            buttons: Ext.MessageBox.OK,
                                            icon: Ext.MessageBox.ERROR
                                        });
                                    },
                                    scope:this 
                                });
                            }
                        }
                    }
                }
            },
            {
                xtype: 'tbseparator'
            },
            {
                xtype: 'tbfill'
            },
            {
                xtype: 'tbseparator'
            },
            {
                xtype: 'button',
                text: 'Ver Convenciones Odontograma',
                iconCls: 'btnDiente',
                listeners:{
                    click : function(){
                        Ext.getCmp('winConvencionesOdontograma').show();
                    }
                }
            },
            {
                xtype: 'tbseparator'
            }
        ];
        this.items = [
            {
                xtype: 'panel',
                border: false, 
                autoHeight: true,
                layout: {
                    columns: 2,
                    type: 'table'
                },
                items:[
                    {
                        xtype: 'panel',
                        //title: 'Odontogramas',
                        //autoHeight: true,
                        autoScroll: true,
                        width: 215,
                        height: 470,
                        frame: true,
                        border: false,
                        tbar:{
                            items: [
                                {
                                    xtype: 'button',
                                    text: 'Editar',
                                    iconCls: 'btnEditRow',
                                    id: 'btnEditOdontograma',
                                    listeners:{
                                        click : function(){
                                            if(Ext.getCmp('gridOdontogramasxPaciente').selModel.getCount() === 1){
                                                var selections = Ext.getCmp('gridOdontogramasxPaciente').selModel.getSelections();
                                                if(selections[0].json.CAS === wCAS){
                                                    var oGridOdontograma = new GridEditOdontogramaUi();
                                                    Ext.getCmp('gridEditOdontogramaHC').title = "CAS: " + selections[0].json.CAS + " Fecha: " + selections[0].json.FecReporte + " -Denticion: " + selections[0].json.TipoDenticion;
                                                    Ext.getCmp('sysIdOdontogramaItemOdontograma').setValue(selections[0].json.IdConsecutivoOdontograma);
                                                    Ext.getCmp('sysTipoDenticionItemOdontograma').setValue(selections[0].json.TipoDenticion);
                                                    Ext.getCmp('gridEditOdontogramaHC').store.load({
                                                        params: {
                                                            task: 'LOAD_DETALLEODONTOGRAMA',
                                                            pOdontograma: Ext.getCmp('sysIdOdontogramaItemOdontograma').getValue()
                                                        }
                                                    });
                                                    oGridOdontograma.show();
                                                }else{
                                                    Ext.MessageBox.show({
                                                    title: 'Odontograma',
                                                    msg: 'Este Odontograma no se puede editar en estos momentos, porque pertenece a otra atencion ya realizada',
                                                    buttons: Ext.MessageBox.OK,
                                                    icon: Ext.MessageBox.ERROR
                                                });
                                                }
                                            }else{
                                                Ext.MessageBox.show({
                                                    title: 'Error',
                                                    msg: 'Debe seleccionar un registro',
                                                    buttons: Ext.MessageBox.OK,
                                                    icon: Ext.MessageBox.ERROR
                                                });
                                            }
                                        }
                                    }
                                },
                                {
                                    xtype: 'tbseparator'
                                },
                                {
                                    xtype: 'button',
                                    text: 'Borrar',
                                    iconCls: 'btnDelRow',
                                    id: 'btnDelOdontograma',
                                    listeners:{
                                        click : function(){
                                            if(Ext.getCmp('gridOdontogramasxPaciente').selModel.getCount() === 1){
                                                var selections = Ext.getCmp('gridOdontogramasxPaciente').selModel.getSelections();
                                                if(selections[0].json.CAS === wCAS){
                                                    Ext.Msg.show({
                                                        title: 'eOfiClinic',
                                                        msg: 'Esta seguro que eliminar el odontograma seleccionado?',
                                                        buttons: Ext.Msg.YESNO,
                                                        icon: Ext.Msg.QUESTION,
                                                        fn: function(btn){
                                                            if(btn === "yes"){
                                                                fnEliminarOdontograma("../../controlador/odontograma/controlador_odontograma.php",{task: "ELIMINAR_ODONTOGRAMA", pIdOdontograma: selections[0].json.IdConsecutivoOdontograma}, 'gridOdontogramasxPaciente');
                                                            }
                                                        }
                                                    });
                                                }else{
                                                    Ext.MessageBox.show({
                                                    title: 'Odontograma',
                                                    msg: 'Este Odontograma no se puede borrar en estos momentos, porque pertenece a otra atencion ya realizada',
                                                    buttons: Ext.MessageBox.OK,
                                                    icon: Ext.MessageBox.ERROR
                                                });
                                                }
                                            }else{
                                                Ext.MessageBox.show({
                                                    title: 'Error',
                                                    msg: 'Debe seleccionar un registro',
                                                    buttons: Ext.MessageBox.OK,
                                                    icon: Ext.MessageBox.ERROR
                                                });
                                            }
                                        }
                                    }
                                },
                                {
                                    xtype: 'tbseparator'
                                }
                            ]
                        },
                        items: [
                            {
                                xtype: 'grid',
                                layout: 'fit',
                                id: 'gridOdontogramasxPaciente',
                                store: stGridOdontogramasxPaciente,
                                anchor: "98%",
                                height: 390,
                                border: false,
                                frame: true,
                                loadMask: true,
                                colModel: new Ext.ux.grid.LockingColumnModel([
                                    {
                                        xtype: 'gridcolumn',
                                        header: 'Id',
                                        sortable: false,
                                        width: 100,
                                        hidden: true,
                                        hideable: false,
                                        dataIndex: 'CAS',
                                        id: 'CAS'
                                    },
                                    {
                                        xtype: 'gridcolumn',
                                        header: 'Fecha',
                                        sortable: true,
                                        width: 205,
                                        dataIndex: 'FecReporte',
                                        renderer: VerInfoOdontograma,
                                        id: 'FecReporte'
                                    }
                                ]),
                                selModel: new Ext.grid.RowSelectionModel({singleSelect:true}),
                                listeners:{
                                    rowclick : function(grid, fila, e){
                                        var selections = grid.selModel.getSelections();
                                        try {
                                            var updater = Ext.getCmp('OdontogramaInical').getUpdater();
                                            updater.setDefaultUrl('../../../app/frm/odontograma/odontograma002.php?pPaciente=' + wPaciente + '&pCAS=' + selections[0].json.CAS + '&pOdontograma=' + selections[0].json.IdConsecutivoOdontograma);
                                            updater.refresh();
                                        }catch(ex){
                                        //    alert("NO");
                                        }
                                        if(selections[0].json.TipoDenticion === "PERMANENTE"){
                                            CalcularCOP(Ext.getCmp('sysIdPacienteHC').getValue(),"SI");
                                        }else{
                                            if(selections[0].json.TipoDenticion === "TEMPORAL"){
                                                CalcularCEO(Ext.getCmp('sysIdPacienteHC').getValue(),"SI");
                                            }else{
                                                CalcularCOP(Ext.getCmp('sysIdPacienteHC').getValue(),"NO");
                                                CalcularCEO(Ext.getCmp('sysIdPacienteHC').getValue(),"NO");
                                            }
                                        }
                                    }
                                }
                            }
                        ]
                    },
                    {
                        xtype: 'panel',
                        layout: 'form',
                        width: 745,
                        height: 470,
                        items: [
                            OdontogramaInical
                        ]
                    }
                ]
            },
            {
                xtype: 'panel',
                layout: 'form',
                title: 'Calculo Indices COP-D y COP-D Modificado',
                frame: true,
                anchor: '100%',
                autoHeight: true,
                id: 'pnCOP',
                padding: 10,
                border: true,
                autoScroll: true,
                style: 'background:transparent;',
                items: [
                    {
                        xtype: 'compositefield',
                        style: 'background:transparent;',
                        items: [
                            {
                                xtype: 'numberfield',
                                width: 60,
                                decimalPrecision: 0,
                                readOnly: true,
                                allowBlank: true,
                                name: 'COP - Sanos',
                                fieldLabel: 'Dientes - Sanos',
                                id: 'sysCOPSanos'
                            },
                            {
                                html: 'C1:'
                            },
                            {
                                xtype: 'numberfield',
                                width: 60,
                                decimalPrecision: 0,
                                readOnly: true,
                                allowBlank: true,
                                name: 'COP - Caries No Cavitacional',
                                id: 'sysCOPC1'
                            },
                            {
                                html: 'C2:'
                            },
                            {
                                xtype: 'numberfield',
                                width: 60,
                                decimalPrecision: 0,
                                readOnly: true,
                                allowBlank: true,
                                name: 'COP - Caries Cavitacional',
                                id: 'sysCOPC2'
                            },
                            {
                                html: 'O:'
                            },
                            {
                                xtype: 'numberfield',
                                width: 60,
                                decimalPrecision: 0,
                                readOnly: true,
                                allowBlank: true,
                                name: 'COP - Obturados',
                                id: 'sysCOPO'
                            },
                            {
                                html: 'P:'
                            },
                            {
                                xtype: 'numberfield',
                                width: 60,
                                decimalPrecision: 0,
                                readOnly: true,
                                allowBlank: true,
                                name: 'COP - Perdidos por Caries',
                                id: 'sysCOPP'
                            },
                            {
                                html: 'K:'
                            },
                            {
                                xtype: 'numberfield',
                                width: 60,
                                decimalPrecision: 0,
                                readOnly: true,
                                allowBlank: true,
                                name: 'COP - No Presentes Otra Razon',
                                id: 'sysCOPK'
                            }
                        ]
                    },
                    {
                        xtype: 'compositefield',
                        style: 'background:transparent;',
                        items: [
                            {
                                html: 'Total Dientes Presentes (S+C1+C2+O)'
                            },
                            {
                                xtype: 'numberfield',
                                width: 60,
                                decimalPrecision: 0,
                                readOnly: true,
                                allowBlank: true,
                                fieldLabel: 'Calculo',
                                name: 'COP - Total Dientes Presentes (S+C1+C2+O)',
                                id: 'sysCOPTotalDientesPresentes'
                            },
                            {
                                html: 'COP (C2+O+P):'
                            },
                            {
                                xtype: 'numberfield',
                                width: 60,
                                decimalPrecision: 0,
                                readOnly: true,
                                allowBlank: true,
                                name: 'COP - (C2+O+P)',
                                id: 'sysCOPCOP'
                            },
                            {
                                html: 'COP MODIFICADO (C1+C2+O+P):'
                            },
                            {
                                xtype: 'numberfield',
                                width: 60,
                                decimalPrecision: 0,
                                readOnly: true,
                                allowBlank: true,
                                name: 'COP MODIFICADO - (C1+C2+O+P)',
                                id: 'sysCOPCOPM'
                            }
                        ]
                    }
                ]
            },
            {
                xtype: 'panel',
                layout: 'form',
                title: 'Calculo Indices ceo-D y ceo-D Modificado',
                frame: true,
                anchor: '100%',
                autoHeight: true,
                id: 'pnCEO',
                padding: 10,
                border: true,
                autoScroll: true,
                style: 'background:transparent;',
                items: [
                    {
                        xtype: 'compositefield',
                        style: 'background:transparent;',
                        items: [
                            {
                                xtype: 'numberfield',
                                width: 60,
                                decimalPrecision: 0,
                                readOnly: true,
                                allowBlank: true,
                                name: 'ceo - Sanos',
                                fieldLabel: 'Dientes - Sanos',
                                id: 'sysceoSanos'
                            },
                            {
                                html: 'C1:'
                            },
                            {
                                xtype: 'numberfield',
                                width: 60,
                                decimalPrecision: 0,
                                readOnly: true,
                                allowBlank: true,
                                name: 'ceo - Caries No Cavitacional',
                                id: 'sysceoC1'
                            },
                            {
                                html: 'C2:'
                            },
                            {
                                xtype: 'numberfield',
                                width: 60,
                                decimalPrecision: 0,
                                readOnly: true,
                                allowBlank: true,
                                name: 'ceo - Caries Cavitacional',
                                id: 'sysceoC2'
                            },
                            {
                                html: 'O:'
                            },
                            {
                                xtype: 'numberfield',
                                width: 60,
                                decimalPrecision: 0,
                                readOnly: true,
                                allowBlank: true,
                                name: 'ceo - Obturados',
                                id: 'sysceoO'
                            },
                            {
                                html: 'P:'
                            },
                            {
                                xtype: 'numberfield',
                                width: 60,
                                decimalPrecision: 0,
                                readOnly: true,
                                allowBlank: true,
                                name: 'ceo - Perdidos por Caries',
                                id: 'sysceoP'
                            },
                            {
                                html: 'K:'
                            },
                            {
                                xtype: 'numberfield',
                                width: 60,
                                decimalPrecision: 0,
                                readOnly: true,
                                allowBlank: true,
                                name: 'ceo - No Presentes Otra Razon',
                                id: 'sysceoK'
                            }
                        ]
                    },
                    {
                        xtype: 'compositefield',
                        style: 'background:transparent;',
                        items: [
                            {
                                html: 'Total Dientes Presentes (S+C1+C2+O)'
                            },
                            {
                                xtype: 'numberfield',
                                width: 60,
                                decimalPrecision: 0,
                                readOnly: true,
                                allowBlank: true,
                                fieldLabel: 'Calculo',
                                name: 'ceo - Total Dientes Presentes (S+C1+C2+O)',
                                id: 'sysceoTotalDientesPresentes'
                            },
                            {
                                html: 'ceo (C2+O+P):'
                            },
                            {
                                xtype: 'numberfield',
                                width: 60,
                                decimalPrecision: 0,
                                readOnly: true,
                                allowBlank: true,
                                name: 'ceo - (C2+O+P)',
                                id: 'sysceoceo'
                            },
                            {
                                html: 'ceo MODIFICADO (C1+C2+O+P):'
                            },
                            {
                                xtype: 'numberfield',
                                width: 60,
                                decimalPrecision: 0,
                                readOnly: true,
                                allowBlank: true,
                                name: 'ceo MODIFICADO - (C1+C2+O+P)',
                                id: 'sysceoceoM'
                            }
                        ]
                    }
                ]
            }
        ];
        CartaDental001Ui.superclass.initComponent.call(this);
    }
});

function fnEliminarOdontograma(URL,arrParam, pGrid, arrParamStore){
    Ext.Ajax.request({
        waitMsg: 'Por favor Espere...',
        url: URL,
        params: arrParam,
        success: function(response){
            var result=eval(response.responseText);
            switch(result){
                case 1:
                    if (typeof pGrid !== 'undefined'){
                        Ext.getCmp(pGrid).store.reload(arrParamStore);
                        ID_PLANTILLA_CITAS = 0;
                    }
                    break;

                case 3:
                    if (typeof pGrid !== 'undefined'){
                        Ext.getCmp(pGrid).store.reload(arrParamStore);
                        ID_PLANTILLA_CITAS = 0;
                        Ext.MessageBox.show({
                            title: 'eOfiClinic',
                            msg: 'Alguno de los registros no se pudieron eliminar',
                            buttons: Ext.MessageBox.OK,
                            icon: Ext.MessageBox.WARNING
                        });
                    }
                    break;

                default:
                    Ext.MessageBox.show({
                        title: 'Error',
                        msg: 'No podemos eliminar el registro en estos momentos o existen datos relacionados en otras tablas',
                        buttons: Ext.MessageBox.OK,
                        icon: Ext.MessageBox.ERROR
                    });
                    break;
            }
        },
        failure: function(response){
            var result = response.responseText;
            Ext.MessageBox.show({
                title: 'Error Base Datos',
                msg: 'No podemos eliminar los registros en estos momentos',
                buttons: Ext.MessageBox.OK,
                icon: Ext.MessageBox.ERROR
            });
        }
    });
}