/*
* @category    Grid Carne de vacunacion
* @package     OfiClinic Web
* @author      Jorge Ancizar Galeano Ruiz<desarrollo@ofisalud.com>
* @copyright   2010 Jorge Ancizar GAleano Ruiz
* @version     OfiClinic Web 1.0
* @license     COMERCIAL
* @link        http://www.ofisalud.com
* @country     Colombia
* @telephone   3016398114
*/

GridCarneVacunacion001Ui = Ext.extend(Ext.Panel, {
    anchor: '100%',
    autoHeight: true,
    initComponent: function() {
        
        function DescripcionRemision(val, x, store){
            mostrarHC = '<table><tr><td style="padding: 1px;">';
            mostrarHC += val;
            mostrarHC += '</td></tr></table>';
            return mostrarHC;
        }
                                            
        this.items = [
            {
                xtype: 'grid',
                title: ' ',
                id: 'gridRemisionesHC',
                store: 'StoreGridRemSolicitadosHC',
                anchor: "100%",
                height: 335,
                border: false,
                frame: true,
                loadMask: true,
                colModel: new Ext.ux.grid.LockingColumnModel([
                    {
                        xtype: 'gridcolumn',
                        header: 'Id',
                        sortable: false,
                        width: 1,
                        hidden: true,
                        hideable: false,
                        dataIndex: 'idConsecutivoSolicitud',
                        id: 'idConsecutivoSolicitud'
                    },
                    {
                        xtype: 'gridcolumn',
                        header: 'Vacuna - Biologico',
                        sortable: false,
                        width: 450,
                        dataIndex: 'descConcepto',
                        id: 'descConcepto'
                    },
                    {
                        xtype: 'gridcolumn',
                        header: 'Observaciones',
                        sortable: false,
                        renderer: DescripcionRemision,
                        width: 410,
                        dataIndex: 'Remision',
                        id: 'Remision'
                    }
                ]),
                selModel: new Ext.grid.RowSelectionModel({singleSelect:false}),
                iconCls:'icon-grid',
                //view: new Ext.grid.GroupingView(),
                tbar:
                    {
                        xtype: 'toolbar',
                        items: [
                            {
                                xtype: 'button',
                                text: 'Adicionar Registro',
                                iconCls: 'btnAddRow',
                                id: 'btnAddRemEvolucion',
                                listeners: {
                                    click : function() {
                                        if (Ext.getCmp('sysYaGuardoHC').getValue() == 1){
                                            if (objREMADD != "NA"){
                                                var xSolREMADD = eval(objREMADD);
                                                Ext.getCmp('intPrestadorRem').setValue(ID_EMPRESA);
                                                Ext.getCmp('intIPSRem').setValue(ID_SEDE);
                                                Ext.getCmp('intPacienteRem').setValue(Ext.getCmp('sysIdPacienteHC').getValue());
                                                Ext.getCmp('intCASRem').setValue(Ext.getCmp('sysCASHC').getValue());
                                                Ext.getCmp('intProfesionalRem').setValue(Ext.getCmp('sysProfesionalHC').getValue());
                                                Ext.getCmp('intUsuarioRem').setValue(ID_USUARIO);
                                                xSolREMADD.show();
                                            }
                                        }else{
                                            Ext.Msg.show({
                                                title: 'eOfiClinic',
                                                msg: 'Usted No ha Guardado la Evolución',
                                                buttons: Ext.Msg.OK,
                                                icon: Ext.Msg.ERROR
                                            });
                                        }
                                    }
                                }
                            },
                            {
                                xtype: 'tbseparator'
                            },
                            {
                                xtype: 'button',
                                text: 'Eliminar Registro',
                                iconCls: 'btnDelRow',
                                id: 'btnDelRemEvolucion',
                                listeners: {
                                    click : function() {
                                         if(Ext.getCmp('gridRemisionesHC').selModel.getCount() == 1)
                                        {
                                            var selections = Ext.getCmp('gridRemisionesHC').selModel.getSelections();
                                            Ext.Msg.show({
                                                title: 'Remisiones',
                                                msg: 'Esta Seguro que Desea Eliminar el Registro ' + selections[0].json.descConcepto + '?',
                                                buttons: Ext.Msg.YESNO,
                                                icon: Ext.Msg.QUESTION,
                                                fn: function(btn)
                                                {
                                                    if(btn=="yes")
                                                    {
                                                        fnEliminarRegistros("../../controlador/solrem/controlador_solrem.php",{task: "ELIMINAR_OFIMEDICAL", pIdMx: selections[0].json.idConsecutivoSolicitud}, 'gridRemisionesHC')
                                                    }
                                                }
                                            });
                                        }else{
                                            Ext.MessageBox.show({
                                                title: 'Error',
                                                msg: 'No podemos eliminar los registros en estos momentos, verifique que solo haya seleccionado un registro',
                                                buttons: Ext.MessageBox.OK,
                                                icon: Ext.MessageBox.ERROR
                                            });
                                        }
                                    }
                                }
                            },
                            {
                                xtype: 'tbseparator'
                            },
                            '->',
                            {
                                xtype: 'tbseparator'
                            },
                            {
                                xtype: 'button',
                                text: 'Imprimir CARNE',
                                iconCls: 'btnImprimir',
                                id: 'btnPrintRemSeleccion',
                                listeners: {
                                    click : function() {
                                        var Registros;
                                        Registros = Ext.getCmp('gridRemisionesHC').selModel.getCount();
                                        if(Registros > 0){
                                            var selections = Ext.getCmp('gridRemisionesHC').selModel.getSelections();
                                            var prez = [];
                                            for(i = 0; i < Registros; i++){
                                                prez.push(selections[i].json.idConsecutivoSolicitud);
                                            }
                                            var encoded_array = Ext.encode(prez);
                                            window.open ("../../controlador/asistencial/printordenrem0_1.php?pEmpresa=" + ID_EMPRESA + "&pIPS=" + ID_IPS + "&pPaciente=" + Ext.getCmp('sysIdPacienteHC').getValue() + "&pCAS=" + Ext.getCmp('sysCASHC').getValue() +  "&pItems=" + encoded_array,"Remisiones");
                                        }else{
                                            Ext.MessageBox.show({
                                                title: 'Error',
                                                msg: 'Debe seleccionar las Remisiones a imprimir',
                                                buttons: Ext.MessageBox.OK,
                                                icon: Ext.MessageBox.ERROR
                                            });
                                        }
                                    }
                                }
                            },
                            {
                                xtype: 'tbseparator'
                            }
                        ]
                    }
            }
        ];
        GridCarneVacunacion001Ui.superclass.initComponent.call(this);
    }
});
