/*
* @category    Formulario Modelo Evolucion Historia Clinica Rehabilitacion Cardiaca Ingreso
* @package     OfiClinic Web
* @author      Jorge Ancizar Galeano Ruiz<desarrollo@ofisalud.com>
* @copyright   2010 Jorge Ancizar Galeano Ruiz
* @version     OfiClinic Web 1.0
* @license     COMERCIAL
* @link        http://www.ofisalud.com
* @country     Colombia
* @telephone   3016398114
*/

winHCTerapiaCardiaca001Ui = Ext.extend(Ext.Window, {
    title: 'eOfiClinic ©  .:: Plantilla HC Rehabilitacion Cardiaca Ingreso ::.',
    width: 990,
    height: 636,
    closable: false,
    resizable: false,
    draggable: false,
    modal: true,
    id: 'winHC',
    initComponent: function() {
        
        var dataPrueba = [
            ['POSITIVO'],
            ['NEGATIVO']
        ];
        var stPrueba = new Ext.data.ArrayStore({
            fields: [
                {name: 'Descripcion'}
            ]
        });
        stPrueba.loadData(dataPrueba);
     

        this.items = [
            {
                xtype: 'panel',
                frame: true,
                anchor: '100%',
                id: 'panelHC',
                border: false,
                height: 570,
                autoScroll: true,
                layout: 'form',
                style: 'background:transparent;',
                items: [
                    {
                        xtype: 'hidden',
                        anchor: '100%',
                        allowBlank: true,
                        readOnly: true,
                        id: 'sysIdCodPlantillaHC'
                    },
                    {
                        xtype: 'hidden',
                        anchor: '100%',
                        allowBlank: true,
                        readOnly: true,
                        value: 1,
                        id: 'sysUsaGridSalida'
                    },
                    {
                        xtype: 'hidden',
                        anchor: '100%',
                        allowBlank: true,
                        readOnly: true,
                        style: 'background:transparent;font-size:16px;font-weight:bolder;border:none;color:blue;',
                        value: 0,
                        id: 'sysYaGuardoHC'
                    },
                    {
                        xtype: 'hidden',
                        anchor: '100%',
                        allowBlank: true,
                        readOnly: true,
                        fieldLabel: 'Plantilla',
                        id: 'sysPlantillaHC',
                        name: 'PLANTILLA'
                    },
                    {
                        xtype: 'hidden',
                        anchor: '100%',
                        allowBlank: true,
                        readOnly: true,
                        id: 'sysRutaRptHC'
                    },
                    {
                        xtype: 'hidden',
                        anchor: '100%',
                        allowBlank: true,
                        readOnly: true,
                        id: 'sysRutaRptMx'
                    },
                    {
                        xtype: 'hidden',
                        anchor: '100%',
                        allowBlank: true,
                        readOnly: true,
                        id: 'sysRutaRptExa'
                    },
                    {
                        xtype: 'hidden',
                        anchor: '100%',
                        allowBlank: true,
                        readOnly: true,
                        id: 'sysRutaRptRem'
                    },
                    {
                        xtype: 'textfield',
                        anchor: '100%',
                        allowBlank: true,
                        readOnly: true,
                        fieldLabel: 'Actividad',
                        style: 'background:transparent;font-size:16px;font-weight:bolder;border:none;color:blue;',
                        id: 'sysActividadHC',
                        name: 'PLANTILLA'
                    },
                    {
                        xtype: 'hidden',
                        anchor: '100%',
                        allowBlank: true,
                        readOnly: true,
                        fieldLabel: 'Empresa',
                        id: 'sysEmpresaHC'
                    },
                    {
                        xtype: 'hidden',
                        anchor: '100%',
                        allowBlank: true,
                        readOnly: true,
                        fieldLabel: 'IPS',
                        id: 'sysIPSHC'
                    },
                    {
                        xtype: 'hidden',
                        anchor: '100%',
                        allowBlank: true,
                        readOnly: true,
                        fieldLabel: 'Usuario',
                        id: 'sysUsuarioHC'
                    },
                    {
                        xtype: 'hidden',
                        anchor: '100%',
                        allowBlank: true,
                        readOnly: true,
                        fieldLabel: 'Profesional',
                        id: 'sysProfesionalHC'
                    },
                    {
                        xtype: 'hidden',
                        anchor: '100%',
                        allowBlank: true,
                        readOnly: true,
                        fieldLabel: 'Paciente',
                        id: 'sysIdPacienteHC'
                    },
                    {
                        xtype: 'hidden',
                        anchor: '100%',
                        allowBlank: true,
                        readOnly: true,
                        fieldLabel: 'Apertura',
                        id: 'sysAperturaHC'
                    },
                    {
                        xtype: 'textfield',
                        anchor: '100%',
                        allowBlank: true,
                        readOnly: true,
                        fieldLabel: 'Cliente',
                        id: 'sysClienteHC'
                    },
                    {
                        xtype: 'hidden',
                        anchor: '100%',
                        allowBlank: true,
                        readOnly: true,
                        fieldLabel: 'Plantilla',
                        id: 'sysIdClienteHC'
                    },
                    {
                        xtype: 'hidden',
                        anchor: '100%',
                        allowBlank: true,
                        readOnly: true,
                        fieldLabel: 'Plantilla',
                        id: 'sysIdPlanHC'
                    },
                    {
                        xtype: 'hidden',
                        anchor: '100%',
                        allowBlank: true,
                        readOnly: true,
                        fieldLabel: 'Plantilla',
                        id: 'sysIdSubPlanHC'
                    },
                    {
                        xtype: 'hidden',
                        anchor: '100%',
                        allowBlank: true,
                        readOnly: true,
                        fieldLabel: 'Plantilla',
                        id: 'sysIdContratoHC'
                    },
                    {
                        xtype: 'hidden',
                        anchor: '100%',
                        allowBlank: true,
                        readOnly: true,
                        fieldLabel: 'Genero',
                        id: 'sysGeneroPacHC'
                    },
                    {
                        xtype: 'hidden',
                        anchor: '100%',
                        allowBlank: true,
                        readOnly: true,
                        fieldLabel: 'Edad',
                        id: 'sysEdadPacHC'
                    },
                    {
                        xtype: 'textfield',
                        anchor: '100%',
                        allowBlank: true,
                        readOnly: true,
                        fieldLabel: 'Profesional',
                        id: 'sysProfesionalAgendaHC'
                    },
                    {
                        xtype: 'hidden',
                        anchor: '100%',
                        allowBlank: true,
                        readOnly: true,
                        fieldLabel: 'ConsecutivoDetalle',
                        id: 'sysConsecutivoDetalleHC'
                    },
                    {
                        xtype: 'compositefield',
                        style: 'background:transparent;',
                        items: [
                            {
                                xtype: 'textfield',
                                allowBlank: true,
                                readOnly: true,
                                fieldLabel: 'CAS',
                                id: 'sysCASHC'
                            },
                            {
                                xtype: 'displayfield',
                                id: 'sysFechaHC',
                                value: 'Fecha: '
                            },
                            {
                                xtype: 'textfield',
                                allowBlank: true,
                                readOnly: true,
                                id: 'sysFechaHC'
                            },
                            {
                                xtype: 'displayfield',
                                id: 'sysHoraHC',
                                value: 'Hora: '
                            },
                            {
                                xtype: 'textfield',
                                allowBlank: true,
                                readOnly: true,
                                id: 'sysHoraHC'
                            },
                            {
                                xtype: 'displayfield',
                                id: 'sysLegalizacionHC',
                                value: 'Legalización: '
                            },
                            {
                                xtype: 'textfield',
                                allowBlank: true,
                                readOnly: true,
                                id: 'sysLegalizaHC'
                            }
                        ]
                    },
                    {
                        xtype: 'textfield',
                        anchor: '100%',
                        allowBlank: true,
                        readOnly: true,
                        fieldLabel: 'Paciente',
                        value: 'CC 792558261  - JORGE GALEANO RUIZ - (Masculino) FechaNac: 1973-01-30, Edad 38 Años',
                        id: 'sysPacienteHC'
                    },
                    {
                        xtype: 'compositefield',
                        style: 'background:transparent;',
                        items: [
                            {
                                xtype: 'textfield',
                                width: 100,
                                allowBlank: true,
                                readOnly: true,
                                fieldLabel: 'Genero',
                                id: 'sysGeneroHC'
                            },
                            {
                                html: 'Fecha Nac:'
                            },
                            {
                                xtype: 'textfield',
                                width: 100,
                                allowBlank: true,
                                readOnly: true,
                                id: 'sysFechaNac'
                            },
                            {
                                html: 'Edad:'
                            },
                            {
                                xtype: 'textfield',
                                width: 350,
                                allowBlank: true,
                                readOnly: true,
                                id: 'sysEdadHC'
                            }
                        ]
                    },
                    /*{
                        xtype: 'button',
                        iconCls: 'btnImprimir',
                        text: 'Cargar Antecedentes',
                        tooltip: 'Cargar Antecedentes',
                        listeners:{
                            click : function(){
                                Ext.Ajax.request({
                                    url: '../../controlador/asistencial/evolucionhc.php',
                                    waitMsg: 'Cargando Información...',
                                    params:{
                                        pCAS: myCAS,
                                        pPaciente: Ext.getCmp('sysIdPacienteHC').getValue(),
                                        task: 'ImportarAntecedentesPersonalesOfiClinic001'
                                    },
                                    success: function(result, request)
                                    {
                                        var jsonAntPersonales = Ext.util.JSON.decode(result.responseText);
                                        UtilCargarAntecedentesOfiClinic001(jsonAntPersonales.data);
                                    },
                                    scope:this
                                });
                            }
                        }
                    },*/
                    {
                        html: '<hr>',
                        style: 'background:transparent;',
                        border: false
                    },
                    {
                        xtype: 'tabpanel',
                        anchor: '99%',
                        autoHeight: true,
                        border: false,
                        enableTabScroll: true,
                        ref: 'fTabPanel',
                        id: 'fTabPanel',
                        activeTab: 0,
                        items: [
                            {
                                xtype: 'panel',
                                title: 'Evolución',
                                autoHeight: true,
                                autoScroll: true,
                                width: 921,
                                frame: true,
                                border: false,
                                id: 'fichaEvolucion',
                                layout: 'form',
                                items: [
                                    {
                                        xtype: 'form',
                                        frame: true,
                                        anchor: '100%',
                                        id: 'frmHC',
                                        padding: 10,
                                        border: false,
                                        autoScroll: true,
                                        style: 'background:transparent;',
                                        items: [
                                            {
                                                xtype: 'fieldset',
                                                title: 'DIAGNOOSTICO',
                                                layout: 'form',
                                                collapseFirst: false,
                                                collapsible: true,
                                                animCollapse: true,
                                                titleCollapse: true,
                                                anchor: '100%',
                                                labelSeparator: '',
                                                autoHeight: true,
                                                padding: 7,
                                                items: [
                                                    {
                                                        xtype: 'textfield',
                                                        anchor: '100%',
                                                        fieldLabel: 'Evento',
                                                        name: 'Evento',
                                                        allowBlank: true,
                                                        id: 'strDiagnosticoEvento'
                                                    },
                                                    {
                                                        xtype: 'textfield',
                                                        anchor: '100%',
                                                        fieldLabel: 'Origen',
                                                        name: 'Origen',
                                                        allowBlank: true,
                                                        id: 'strDiagnosticoOrigen'
                                                    },
                                                    {
                                                        xtype: 'textfield',
                                                        anchor: '100%',
                                                        fieldLabel: 'Diagnostico Principal',
                                                        name: 'Diagnostico Principal',
                                                        allowBlank: true,
                                                        id: 'strDiagnosticoDiagnostico'
                                                    },
                                                    {
                                                        xtype: 'textfield',
                                                        anchor: '100%',
                                                        fieldLabel: 'Otros Diagnostico',
                                                        name: 'Otros Diagnostico',
                                                        allowBlank: true,
                                                        id: 'strDiagnosticoOtrosDiagnostico'
                                                    }
                                                ]
                                            },
                                            {
                                                xtype: 'fieldset',
                                                title: 'PRUEBA DE ESFUERZO',
                                                layout: 'form',
                                                collapseFirst: false,
                                                collapsible: true,
                                                animCollapse: true,
                                                titleCollapse: true,
                                                anchor: '100%',
                                                labelSeparator: '',
                                                autoHeight: true,
                                                padding: 7,
                                                items: [
                                                    {
                                                        xtype: 'compositefield',
                                                        style: 'background:transparent;',
                                                        items: [
                                                            {
                                                                xtype: 'numberfield',
                                                                fieldLabel: 'FC Max',
                                                                width: 60,
                                                                decimalPrecision: 2,
                                                                name: 'FC Max',
                                                                allowBlank: true,
                                                                id: 'intPruebaEsfuerzoFCMax'
                                                            },
                                                            {
                                                                html: '%FCM'
                                                            },
                                                            {
                                                                xtype: 'numberfield',
                                                                width: 60,
                                                                decimalPrecision: 2,
                                                                name: '%FCM',
                                                                allowBlank: true,
                                                                id: 'intPruebaEsfuerzoFCM'
                                                            },
                                                            {
                                                                html: 'METs'
                                                            },
                                                            {
                                                                xtype: 'numberfield',
                                                                width: 60,
                                                                decimalPrecision: 2,
                                                                name: 'METs',
                                                                allowBlank: true,
                                                                id: 'intPruebaEsfuerzoMETs'
                                                            },
                                                            {
                                                                html: 'PAS Max'
                                                            },
                                                            {
                                                                xtype: 'numberfield',
                                                                width: 60,
                                                                decimalPrecision: 2,
                                                                name: 'PAS Max',
                                                                allowBlank: true,
                                                                id: 'intPruebaEsfuerzoPASMax'
                                                            }
                                                        ]
                                                    },
                                                    {
                                                        xtype: 'combo',
                                                        fieldLabel: 'DP',
                                                        name: 'DP',
                                                        width: 250,
                                                        allowBlank: true,
                                                        store: stPrueba,
                                                        valueField: 'Descripcion',
                                                        displayField: 'Descripcion',
                                                        mode: 'local',
                                                        forceSelection: true,
                                                        typeAhead: true,
                                                        typeAheadDelay: 10,
                                                        triggerAction: 'all',
                                                        id: 'strPruebaEsfuerzoDP'
                                                    },
                                                    {
                                                        xtype: 'compositefield',
                                                        style: 'background:transparent;',
                                                        items: [
                                                            {
                                                                xtype: 'numberfield',
                                                                fieldLabel: 'VO2Max Teorico',
                                                                width: 150,
                                                                decimalPrecision: 2,
                                                                name: 'VO2Max Teorico',
                                                                allowBlank: true,
                                                                emptyText: 'Ml/kg/min',
                                                                id: 'intPruebaEsfuerzoVO2MaxTeorico'
                                                            },
                                                            {
                                                                html:'VO2Max Real'
                                                            },
                                                            {
                                                                xtype: 'numberfield',
                                                                width: 150,
                                                                decimalPrecision: 2,
                                                                name: 'VO2Max Real',
                                                                allowBlank: true,
                                                                emptyText: 'Ml/kg/min',
                                                                id: 'intPruebaEsfuerzoVO2MaxReal'
                                                            }
                                                        ]
                                                    },
                                                    {
                                                        xtype: 'compositefield',
                                                        style: 'background:transparent;',
                                                        items: [
                                                            {
                                                                xtype: 'textfield',
                                                                width: 300,
                                                                fieldLabel: 'Respuesta Cronotropica',
                                                                name: 'Respuesta Cronotropica',
                                                                allowBlank: true,
                                                                id: 'strPruebaEsfuerzoRespuestaCronotropica'
                                                            },
                                                            {
                                                                html: 'Respuesta Presora'
                                                            },
                                                            {
                                                                xtype: 'textfield',
                                                                width: 300,
                                                                name: 'Respuesta Presora',
                                                                allowBlank: true,
                                                                id: 'strPruebaEsfuerzoRespuestaPresora'
                                                            }
                                                        ]
                                                    },
                                                    {
                                                        xtype: 'textfield',
                                                        anchor: '100%',
                                                        fieldLabel: 'Otros',
                                                        name: 'Otros',
                                                        allowBlank: true,
                                                        id: 'strPruebaEsfuerzoOtros'
                                                    }
                                                ]
                                            },
                                            {
                                                xtype: 'fieldset',
                                                title: 'ECOCARDIOGRAMA',
                                                layout: 'form',
                                                collapseFirst: false,
                                                collapsible: true,
                                                animCollapse: true,
                                                titleCollapse: true,
                                                anchor: '100%',
                                                labelSeparator: '',
                                                autoHeight: true,
                                                padding: 7,
                                                items: [
                                                    {
                                                        xtype: 'compositefield',
                                                        style: 'background:transparent;',
                                                        items: [
                                                            {
                                                                xtype: 'numberfield',
                                                                fieldLabel: 'FEVI',
                                                                width: 150,
                                                                decimalPrecision: 2,
                                                                name: 'FEVI',
                                                                allowBlank: true,
                                                                emptyText: '%',
                                                                id: 'intEcocardiogramaFEVI'
                                                            },
                                                            {
                                                                html: 'Dilatacion'
                                                            },
                                                            {
                                                                xtype: 'combo',
                                                                name: 'Dilatacion',
                                                                width: 150,
                                                                allowBlank: true,
                                                                store: 'StoreSiNo',
                                                                valueField: 'Descripcion',
                                                                displayField: 'Descripcion',
                                                                mode: 'local',
                                                                forceSelection: true,
                                                                typeAhead: true,
                                                                typeAheadDelay: 10,
                                                                triggerAction: 'all',
                                                                id: 'strEcocardiogramaDilatacion'
                                                            }
                                                        ]
                                                    },
                                                    {
                                                        xtype: 'compositefield',
                                                        style: 'background:transparent;',
                                                        items: [
                                                            {
                                                                html: 'Col'
                                                            },
                                                            {
                                                                xtype: 'checkbox',
                                                                fieldLabel: 'Laboratorios',
                                                                name: 'Col',
                                                                anchor: '100%',
                                                                value: 'false',
                                                                id: 'bolEcocardiogramaCol'
                                                            },
                                                            {
                                                                html: 'LDL'
                                                            },
                                                            {
                                                                xtype: 'checkbox',
                                                                name: 'LDL',
                                                                anchor: '100%',
                                                                value: 'false',
                                                                id: 'bolEcocardiogramaLDL'
                                                            },
                                                            {
                                                                html: 'HDL'
                                                            },
                                                            {
                                                                xtype: 'checkbox',
                                                                name: 'HDL',
                                                                anchor: '100%',
                                                                value: 'false',
                                                                id: 'bolEcocardiogramaHDL'
                                                            },
                                                            {
                                                                html: 'Trig'
                                                            },
                                                            {
                                                                xtype: 'checkbox',
                                                                name: 'Trig',
                                                                anchor: '100%',
                                                                value: 'false',
                                                                id: 'bolEcocardiogramaTrig'
                                                            },
                                                            {
                                                                html: 'Glic'
                                                            },
                                                            {
                                                                xtype: 'checkbox',
                                                                name: 'Glic',
                                                                anchor: '100%',
                                                                value: 'false',
                                                                id: 'bolEcocardiogramaGlic'
                                                            },
                                                            {
                                                                html: 'HGL'
                                                            },
                                                            {
                                                                xtype: 'checkbox',
                                                                name: 'GliHGLc',
                                                                anchor: '100%',
                                                                value: 'false',
                                                                id: 'bolEcocardiogramaHGL'
                                                            },
                                                            {
                                                                html: 'Glicemia'
                                                            },
                                                            {
                                                                xtype: 'numberfield',
                                                                width: 60,
                                                                decimalPrecision: 2,
                                                                name: 'Glicemia',
                                                                allowBlank: true,
                                                                id: 'intEcocardiogramaGlicemia'
                                                            }
                                                        ]
                                                    },
                                                    {
                                                        xtype: 'textfield',
                                                        anchor: '100%',
                                                        fieldLabel: 'Consideraciones Para el Ejercicio',
                                                        name: 'Consideraciones Para el Ejercicio',
                                                        allowBlank: true,
                                                        id: 'strEcocardiogramaConsideracionesEjercicio'
                                                    },
                                                    {
                                                        xtype: 'compositefield',
                                                        style: 'background:transparent;',
                                                        items: [
                                                            {
                                                                html: 'Limite Inferior'
                                                            },
                                                            {
                                                                xtype: 'textfield',
                                                                width: 150,
                                                                fieldLabel: 'Marcapasos',
                                                                name: 'Marcapasos Limite Inferior',
                                                                allowBlank: true,
                                                                id: 'strEcocardiogramaMarcapasosLimiteInferior'
                                                            },
                                                            {
                                                                html: 'Limite Superior'
                                                            },
                                                            {
                                                                xtype: 'textfield',
                                                                width: 150,
                                                                name: 'Marcapasos Limite Superior',
                                                                allowBlank: true,
                                                                id: 'strEcocardiogramaMarcapasosLimiteSuperior'
                                                            }
                                                        ]
                                                    },
                                                    {
                                                        xtype: 'compositefield',
                                                        style: 'background:transparent;',
                                                        items: [
                                                            {
                                                                xtype: 'combo',
                                                                fieldLabel: 'CDI',
                                                                name: 'CDI',
                                                                width: 150,
                                                                allowBlank: true,
                                                                store: 'StoreSiNo',
                                                                valueField: 'Descripcion',
                                                                displayField: 'Descripcion',
                                                                mode: 'local',
                                                                forceSelection: true,
                                                                typeAhead: true,
                                                                typeAheadDelay: 10,
                                                                triggerAction: 'all',
                                                                id: 'strEcocardiogramaCDI'
                                                            },
                                                            {
                                                                html: 'Tipo'
                                                            },
                                                            {
                                                                xtype: 'textfield',
                                                                width: 150,
                                                                name: 'Tipo',
                                                                allowBlank: true,
                                                                id: 'strEcocardiogramaTipo'
                                                            }
                                                        ]
                                                    },
                                                    {
                                                        xtype: 'textfield',
                                                        width: 150,
                                                        fieldLabel: 'Frecuencia de Descarga',
                                                        name: 'Frecuencia de Descarga',
                                                        allowBlank: true,
                                                        id: 'strEcocardiogramaFrecuenciaDescarga'
                                                    }
                                                ]
                                            },
                                            {
                                                xtype: 'fieldset',
                                                title: 'DATOS ANTROPOMETRICOS',
                                                layout: 'form',
                                                collapseFirst: false,
                                                collapsible: true,
                                                animCollapse: true,
                                                titleCollapse: true,
                                                anchor: '100%',
                                                labelSeparator: '',
                                                autoHeight: true,
                                                padding: 7,
                                                items: [
                                                    {
                                                        xtype: 'compositefield',
                                                        style: 'background:transparent;',
                                                        items: [
                                                            {
                                                                xtype: 'numberfield',
                                                                width: 60,
                                                                minValue: 0,
                                                                maxValue: 250,
                                                                decimalPrecision: 2,
                                                                allowBlank: false,
                                                                emptyText: '(Kg)',
                                                                fieldLabel:"PESO (Kg)",
                                                                name:"PESO (Kg)",
                                                                id: 'intPeso',
                                                                listeners:{
                                                                    change : function(f,pNew, pOld){
                                                                        if(pNew == null || pNew == 0){
                                                                            Ext.getCmp('intPeso').setValue(null);
                                                                            Ext.getCmp('intIMC').setValue(0);
                                                                        }else{
                                                                            //peso [kg]/ estatura [m2]
                                                                            if(Ext.getCmp('intTalla').getValue() > 0){
                                                                                var pTalla = Ext.getCmp('intTalla').getValue() / 100;
                                                                                Ext.getCmp('intIMC').setValue(Ext.getCmp('intPeso').getValue()/(pTalla*pTalla));
                                                                            }else{
                                                                                Ext.getCmp('intIMC').setValue(0);
                                                                            }
                                                                        }
                                                                        if(Ext.getCmp('intIMC').getValue()<1){
                                                                           Ext.getCmp('strIMCClasificacion').setValue(null);
                                                                        }else{
                                                                            if(Ext.getCmp('intIMC').getValue() < 18.40){
                                                                               Ext.getCmp('strIMCClasificacion').setValue("BAJO PESO");
                                                                            }else{
                                                                                if(Ext.getCmp('intIMC').getValue()<=25.00 && Ext.getCmp('intIMC').getValue()>=18.41){
                                                                                   Ext.getCmp('strIMCClasificacion').setValue("PESO NORMAL");
                                                                                }else{
                                                                                    if(Ext.getCmp('intIMC').getValue()<=30.00 && Ext.getCmp('intIMC').getValue()>=25.01){
                                                                                       Ext.getCmp('strIMCClasificacion').setValue("SOBREPESO");
                                                                                    }else{
                                                                                        if(Ext.getCmp('intIMC').getValue()<=35.00 && Ext.getCmp('intIMC').getValue()>=30.01){
                                                                                           Ext.getCmp('strIMCClasificacion').setValue("OBESIDAD GRADO I");
                                                                                        }else{
                                                                                            if(Ext.getCmp('intIMC').getValue()<=40.00 && Ext.getCmp('intIMC').getValue()>=35.01){
                                                                                               Ext.getCmp('strIMCClasificacion').setValue("OBESIDAD GRADO II");
                                                                                            }else{
                                                                                                if(Ext.getCmp('intIMC').getValue()<=60.00 && Ext.getCmp('intIMC').getValue()>=40.01){
                                                                                                   Ext.getCmp('strIMCClasificacion').setValue("OBESIDAD MORBIDA");
                                                                                                }
                                                                                            }
                                                                                        }
                                                                                    }
                                                                                }
                                                                            }
                                                                        }
                                                                    }
                                                                }
                                                            },
                                                            {
                                                                html: 'TALLA (cm)'
                                                            },
                                                            {
                                                                xtype: 'numberfield',
                                                                width: 60,
                                                                minValue: 0,
                                                                maxValue: 250,
                                                                decimalPrecision: 2,
                                                                allowBlank: false,
                                                                name:"TALLA (cm)",
                                                                emptyText: '(cm)',
                                                                id: 'intTalla',
                                                                listeners:{
                                                                    change : function(f,pNew, pOld){
                                                                        if(pNew == null || pNew == 0){
                                                                            Ext.getCmp('intTalla').setValue(null);
                                                                            Ext.getCmp('intIMC').setValue(0);
                                                                        }else{
                                                                            if(Ext.getCmp('intPeso').getValue() > 0){
                                                                                var pTalla = Ext.getCmp('intTalla').getValue() / 100;
                                                                                Ext.getCmp('intIMC').setValue(Ext.getCmp('intPeso').getValue()/(pTalla*pTalla));
                                                                            }else{
                                                                                Ext.getCmp('intIMC').setValue(0);
                                                                            }
                                                                        }
                                                                       if(Ext.getCmp('intIMC').getValue()<1){
                                                                           Ext.getCmp('strIMCClasificacion').setValue(null);
                                                                        }else{
                                                                            if(Ext.getCmp('intIMC').getValue() < 18.40){
                                                                               Ext.getCmp('strIMCClasificacion').setValue("BAJO PESO");
                                                                            }else{
                                                                                if(Ext.getCmp('intIMC').getValue()<=25.00 && Ext.getCmp('intIMC').getValue()>=18.41){
                                                                                   Ext.getCmp('strIMCClasificacion').setValue("PESO NORMAL");
                                                                                }else{
                                                                                    if(Ext.getCmp('intIMC').getValue()<=30.00 && Ext.getCmp('intIMC').getValue()>=25.01){
                                                                                       Ext.getCmp('strIMCClasificacion').setValue("SOBREPESO");
                                                                                    }else{
                                                                                        if(Ext.getCmp('intIMC').getValue()<=35.00 && Ext.getCmp('intIMC').getValue()>=30.01){
                                                                                           Ext.getCmp('strIMCClasificacion').setValue("OBESIDAD GRADO I");
                                                                                        }else{
                                                                                            if(Ext.getCmp('intIMC').getValue()<=40.00 && Ext.getCmp('intIMC').getValue()>=35.01){
                                                                                               Ext.getCmp('strIMCClasificacion').setValue("OBESIDAD GRADO II");
                                                                                            }else{
                                                                                                if(Ext.getCmp('intIMC').getValue()<=60.00 && Ext.getCmp('intIMC').getValue()>=40.01){
                                                                                                   Ext.getCmp('strIMCClasificacion').setValue("OBESIDAD MORBIDA");
                                                                                                }
                                                                                            }
                                                                                        }
                                                                                    }
                                                                                }
                                                                            }
                                                                        }
                                                                        if(Ext.getCmp('intTalla').getValue()<=1){
                                                                            Ext.getCmp('intPesoMax').setValue(0);
                                                                        }else{
                                                                            Ext.getCmp('intPesoMax').setValue(((Ext.getCmp('intTalla').getValue()/100)*(Ext.getCmp('intTalla').getValue()/100))*24.9);
                                                                        }
                                                                        if(Ext.getCmp('intTalla').getValue()<=1){
                                                                            Ext.getCmp('intPesoIdeal').setValue(0);
                                                                        }else{
                                                                            Ext.getCmp('intPesoIdeal').setValue(((Ext.getCmp('intTalla').getValue()/100)*(Ext.getCmp('intTalla').getValue()/100))*22);
                                                                        }
                                                                        if(Ext.getCmp('intTalla').getValue()<=1){
                                                                            Ext.getCmp('intPesoMin').setValue(0);
                                                                        }else{
                                                                            Ext.getCmp('intPesoMin').setValue(((Ext.getCmp('intTalla').getValue()/100)*(Ext.getCmp('intTalla').getValue()/100))*18.5);
                                                                        }
                                                                        var TallaMts = parseFloat(parseInt(Ext.getCmp('intTalla').getValue())/100);
                                                                        Ext.getCmp('intAKS').setValue((parseInt(Ext.getCmp('intKGMM').getValue())/(Math.pow(TallaMts,3)*0.1)/100));
                                                                    }
                                                                }
                                                            },
                                                            {
                                                                html: 'IMC'
                                                            },
                                                            {
                                                                xtype: 'numberfield',
                                                                width: 60,
                                                                minValue: 0,
                                                                decimalPrecision: 2,
                                                                allowBlank: false,
                                                                readOnly: true,
                                                                name: "IMC",
                                                                id: 'intIMC'
                                                            },
                                                            {
                                                                xtype: 'textfield',
                                                                anchor: '100%',
                                                                allowBlank: false,
                                                                readOnly: true,
                                                                name: "IMC - CLASIFICACION",
                                                                id: 'strIMCClasificacion'
                                                            }
                                                        ]
                                                    },
                                                    {
                                                        xtype: 'compositefield',
                                                        style: 'background:transparent;',
                                                        items: [
                                                            {
                                                                xtype: 'numberfield',
                                                                width: 60,
                                                                minValue: 0,
                                                                decimalPrecision: 2,
                                                                allowBlank: false,
                                                                readOnly: true,
                                                                fieldLabel:"Peso Max",
                                                                name: "Peso Max",
                                                                id: 'intPesoMax'
                                                            },
                                                            {
                                                                html: 'Peso Ideal'
                                                            },
                                                            {
                                                                xtype: 'numberfield',
                                                                width: 60,
                                                                minValue: 0,
                                                                decimalPrecision: 2,
                                                                allowBlank: false,
                                                                readOnly: true,
                                                                name: "Peso Ideal",
                                                                id: 'intPesoIdeal'
                                                            },
                                                            {
                                                                html: 'Peso Min'
                                                            },
                                                            {
                                                                xtype: 'numberfield',
                                                                width: 60,
                                                                minValue: 0,
                                                                decimalPrecision: 2,
                                                                allowBlank: false,
                                                                readOnly: true,
                                                                name: "Peso Min",
                                                                id: 'intPesoMin'
                                                            }
                                                        ]
                                                    },
                                                    {
                                                        xtype: 'compositefield',
                                                        style: 'background:transparent;',
                                                        items: [
                                                            {
                                                                xtype: 'numberfield',
                                                                width: 60,
                                                                minValue: 0,
                                                                maxValue: 250,
                                                                decimalPrecision: 2,
                                                                allowBlank: true,
                                                                name: "SE",
                                                                value: 0,
                                                                fieldLabel: "SE",
                                                                id: 'intGrasaSE',
                                                                listeners:{
                                                                    change : function(f,pNew, pOld){
                                                                        if(pNew != null || pNew != 0){
                                                                            Ext.getCmp('intGrasaTotal').setValue(Ext.getCmp('intGrasaSE').getValue() + Ext.getCmp('intGrasaT').getValue() + Ext.getCmp('intGrasaSI').getValue() + Ext.getCmp('intGrasaABD').getValue() + Ext.getCmp('intGrasaM').getValue() + Ext.getCmp('intGrasaP').getValue());
                                                                        }
                                                                        if(Ext.getCmp('sysGeneroHC').getValue() === "MASCULINO"){
                                                                            Ext.getCmp('intGrasa').setValue((Ext.getCmp('intGrasaTotal').getValue()*0.097)+3.64)
                                                                        }else{
                                                                            Ext.getCmp('intGrasa').setValue((Ext.getCmp('intGrasaTotal').getValue()*0.1429)+4.56)
                                                                        }
                                                                    }
                                                                }
                                                            },
                                                            {
                                                                html: 'T:'
                                                            },
                                                            {
                                                                xtype: 'numberfield',
                                                                width: 60,
                                                                minValue: 0,
                                                                maxValue: 250,
                                                                decimalPrecision: 2,
                                                                allowBlank: true,
                                                                name:"T",
                                                                value: 0,
                                                                id: 'intGrasaT',
                                                                listeners:{
                                                                    change : function(f,pNew, pOld){
                                                                        if(pNew != null || pNew != 0){
                                                                            Ext.getCmp('intGrasaTotal').setValue(Ext.getCmp('intGrasaSE').getValue() + Ext.getCmp('intGrasaT').getValue() + Ext.getCmp('intGrasaSI').getValue() + Ext.getCmp('intGrasaABD').getValue() + Ext.getCmp('intGrasaM').getValue() + Ext.getCmp('intGrasaP').getValue());
                                                                        }
                                                                        if(Ext.getCmp('sysGeneroHC').getValue() === "MASCULINO"){
                                                                            Ext.getCmp('intGrasa').setValue((Ext.getCmp('intGrasaTotal').getValue()*0.097)+3.64)
                                                                        }else{
                                                                            Ext.getCmp('intGrasa').setValue((Ext.getCmp('intGrasaTotal').getValue()*0.1429)+4.56)
                                                                        }
                                                                    }
                                                                }
                                                            },
                                                            {
                                                                html: 'SI:'
                                                            },
                                                            {
                                                                xtype: 'numberfield',
                                                                width: 60,
                                                                minValue: 0,
                                                                maxValue: 250,
                                                                decimalPrecision: 2,
                                                                allowBlank: true,
                                                                name:"SI",
                                                                value: 0,
                                                                id: 'intGrasaSI',
                                                                listeners:{
                                                                    change : function(f,pNew, pOld){
                                                                        if(pNew != null || pNew != 0){
                                                                            Ext.getCmp('intGrasaTotal').setValue(Ext.getCmp('intGrasaSE').getValue() + Ext.getCmp('intGrasaT').getValue() + Ext.getCmp('intGrasaSI').getValue() + Ext.getCmp('intGrasaABD').getValue() + Ext.getCmp('intGrasaM').getValue() + Ext.getCmp('intGrasaP').getValue());
                                                                        }
                                                                        if(Ext.getCmp('sysGeneroHC').getValue() === "MASCULINO"){
                                                                            Ext.getCmp('intGrasa').setValue((Ext.getCmp('intGrasaTotal').getValue()*0.097)+3.64)
                                                                        }else{
                                                                            Ext.getCmp('intGrasa').setValue((Ext.getCmp('intGrasaTotal').getValue()*0.1429)+4.56)
                                                                        }
                                                                    }
                                                                }
                                                            },
                                                            {
                                                                html: 'ABD:'
                                                            },
                                                            {
                                                                xtype: 'numberfield',
                                                                width: 60,
                                                                minValue: 0,
                                                                maxValue: 250,
                                                                decimalPrecision: 2,
                                                                allowBlank: true,
                                                                name:"ABD",
                                                                value: 0,
                                                                id: 'intGrasaABD',
                                                                listeners:{
                                                                    change : function(f,pNew, pOld){
                                                                        if(pNew != null || pNew != 0){
                                                                            Ext.getCmp('intGrasaTotal').setValue(Ext.getCmp('intGrasaSE').getValue() + Ext.getCmp('intGrasaT').getValue() + Ext.getCmp('intGrasaSI').getValue() + Ext.getCmp('intGrasaABD').getValue() + Ext.getCmp('intGrasaM').getValue() + Ext.getCmp('intGrasaP').getValue());
                                                                        }
                                                                        if(Ext.getCmp('sysGeneroHC').getValue() === "MASCULINO"){
                                                                            Ext.getCmp('intGrasa').setValue((Ext.getCmp('intGrasaTotal').getValue()*0.097)+3.64)
                                                                        }else{
                                                                            Ext.getCmp('intGrasa').setValue((Ext.getCmp('intGrasaTotal').getValue()*0.1429)+4.56)
                                                                        }
                                                                    }
                                                                }
                                                            },
                                                            {
                                                                html: 'M:'
                                                            },
                                                            {
                                                                xtype: 'numberfield',
                                                                width: 60,
                                                                minValue: 0,
                                                                maxValue: 250,
                                                                decimalPrecision: 2,
                                                                allowBlank: true,
                                                                name:"M",
                                                                value: 0,
                                                                id: 'intGrasaM',
                                                                listeners:{
                                                                    change : function(f,pNew, pOld){
                                                                        if(pNew != null || pNew != 0){
                                                                            Ext.getCmp('intGrasaTotal').setValue(Ext.getCmp('intGrasaSE').getValue() + Ext.getCmp('intGrasaT').getValue() + Ext.getCmp('intGrasaSI').getValue() + Ext.getCmp('intGrasaABD').getValue() + Ext.getCmp('intGrasaM').getValue() + Ext.getCmp('intGrasaP').getValue());
                                                                        }
                                                                        if(Ext.getCmp('sysGeneroHC').getValue() === "MASCULINO"){
                                                                            Ext.getCmp('intGrasa').setValue((Ext.getCmp('intGrasaTotal').getValue()*0.097)+3.64)
                                                                        }else{
                                                                            Ext.getCmp('intGrasa').setValue((Ext.getCmp('intGrasaTotal').getValue()*0.1429)+4.56)
                                                                        }
                                                                    }
                                                                }
                                                            },
                                                            {
                                                                html: 'P:'
                                                            },
                                                            {
                                                                xtype: 'numberfield',
                                                                width: 60,
                                                                minValue: 0,
                                                                maxValue: 250,
                                                                decimalPrecision: 2,
                                                                allowBlank: true,
                                                                name:"P",
                                                                value: 0,
                                                                id: 'intGrasaP',
                                                                listeners:{
                                                                    change : function(f,pNew, pOld){
                                                                        if(pNew != null || pNew != 0){
                                                                            Ext.getCmp('intGrasaTotal').setValue(parseInt(Ext.getCmp('intGrasaSE').getValue()) + parseInt(Ext.getCmp('intGrasaT').getValue()) + parseInt(Ext.getCmp('intGrasaSI').getValue()) + parseInt(Ext.getCmp('intGrasaABD').getValue()) + parseInt(Ext.getCmp('intGrasaM').getValue()) + parseInt(Ext.getCmp('intGrasaP').getValue()));
                                                                        }
                                                                        if(Ext.getCmp('sysGeneroHC').getValue() === "MASCULINO"){
                                                                            Ext.getCmp('intGrasa').setValue((parseInt(Ext.getCmp('intGrasaTotal').getValue())*0.097)+3.64);
                                                                        }else{
                                                                            Ext.getCmp('intGrasa').setValue((parseInt(Ext.getCmp('intGrasaTotal').getValue())*0.1429)+4.56);
                                                                        }
                                                                    }
                                                                }
                                                            },
                                                            {
                                                                html: 'Total:'
                                                            },
                                                            {
                                                                xtype: 'numberfield',
                                                                width: 150,
                                                                decimalPrecision: 2,
                                                                name: 'Total',
                                                                allowBlank: true,
                                                                id: 'intGrasaTotal'
                                                            }
                                                        ]
                                                    },
                                                    {
                                                        xtype: 'numberfield',
                                                        fieldLabel: '% Grasa',
                                                        width: 150,
                                                        decimalPrecision: 2,
                                                        name: '% Grasa',
                                                        allowBlank: true,
                                                        id: 'intGrasa'
                                                    },
                                                    {
                                                        xtype: 'fieldset',
                                                        title: 'Perimetros',
                                                        layout: 'form',
                                                        collapseFirst: false,
                                                        collapsible: true,
                                                        animCollapse: true,
                                                        titleCollapse: true,
                                                        anchor: '100%',
                                                        autoHeight: true,
                                                        padding: 7,
                                                        items: [
                                                            {
                                                                xtype: 'compositefield',
                                                                style: 'background:transparent;',
                                                                items: [
                                                                    {
                                                                        xtype: 'numberfield',
                                                                        width: 60,
                                                                        decimalPrecision: 2,
                                                                        allowBlank: true,
                                                                        name:"Biceps Relajado",
                                                                        fieldLabel:"Biceps Relajado",
                                                                        id: 'intPerimetroBicepsRelajado'
                                                                    },
                                                                    {
                                                                        html: 'Biceps Contraido:'
                                                                    },
                                                                    {
                                                                        xtype: 'numberfield',
                                                                        width: 60,
                                                                        decimalPrecision: 2,
                                                                        allowBlank: true,
                                                                        name:"Biceps Contraido",
                                                                        id: 'intPerimetroBicepsContraido'
                                                                    },
                                                                    {
                                                                        html: 'Torax:'
                                                                    },
                                                                    {
                                                                        xtype: 'numberfield',
                                                                        width: 60,
                                                                        decimalPrecision: 2,
                                                                        allowBlank: true,
                                                                        name:"Torax",
                                                                        id: 'intPerimetroTorax'
                                                                    }
                                                                ]
                                                            },
                                                            {
                                                                xtype: 'compositefield',
                                                                style: 'background:transparent;',
                                                                items: [
                                                                    {
                                                                        xtype: 'numberfield',
                                                                        width: 60,
                                                                        decimalPrecision: 2,
                                                                        allowBlank: true,
                                                                        name:"Abdomen",
                                                                        fieldLabel:"Abdomen",
                                                                        id: 'intPerimetroAbdomen'
                                                                    },
                                                                    {
                                                                        html: 'Muslo:'
                                                                    },
                                                                    {
                                                                        xtype: 'numberfield',
                                                                        width: 60,
                                                                        decimalPrecision: 2,
                                                                        allowBlank: true,
                                                                        name:"Muslo",
                                                                        id: 'intPerimetroMuslo'
                                                                    },
                                                                    {
                                                                        html: 'Pierna:'
                                                                    },
                                                                    {
                                                                        xtype: 'numberfield',
                                                                        width: 60,
                                                                        decimalPrecision: 2,
                                                                        allowBlank: true,
                                                                        name:"Pierna",
                                                                        id: 'intPerimetroPierna'
                                                                    }
                                                                ]
                                                            }
                                                        ]
                                                    },
                                                    {
                                                        xtype: 'compositefield',
                                                        style: 'background:transparent;',
                                                        items: [
                                                            {
                                                                xtype: 'numberfield',
                                                                width: 60,
                                                                decimalPrecision: 2,
                                                                allowBlank: true,
                                                                name:"Porcentaje GC",
                                                                fieldLabel:"% GC",
                                                                id: 'intPorcentajeGC'
                                                            },
                                                            {
                                                                html: '% Agua:'
                                                            },
                                                            {
                                                                xtype: 'numberfield',
                                                                width: 60,
                                                                decimalPrecision: 2,
                                                                allowBlank: true,
                                                                name:"Porcentaje Agua",
                                                                id: 'intPorcentajeAgua'
                                                            },
                                                            {
                                                                html: 'KG. M. M.:'
                                                            },
                                                            {
                                                                xtype: 'numberfield',
                                                                width: 60,
                                                                decimalPrecision: 2,
                                                                allowBlank: true,
                                                                name:"KG. M. M.",
                                                                id: 'intKGMM',
                                                                value: 0,
                                                                listeners:{
                                                                    change : function(f,pNew, pOld){
                                                                        if(pNew != null || pNew != 0){
                                                                            TallaMts = parseFloat(parseInt(Ext.getCmp('intTalla').getValue())/100);
                                                                            Ext.getCmp('intAKS').setValue((parseInt(Ext.getCmp('intKGMM').getValue())/(Math.pow(TallaMts,3)*0.1)/100));
                                                                        }
                                                                    }
                                                                }
                                                            },
                                                            {
                                                                html: 'Complexion:'
                                                            },
                                                            {
                                                                xtype: 'numberfield',
                                                                width: 60,
                                                                decimalPrecision: 2,
                                                                allowBlank: true,
                                                                name:"Complexion",
                                                                id: 'intComplexion'
                                                            }
                                                        ]
                                                    },
                                                    {
                                                        xtype: 'compositefield',
                                                        style: 'background:transparent;',
                                                        items: [
                                                            {
                                                                xtype: 'numberfield',
                                                                width: 60,
                                                                decimalPrecision: 2,
                                                                allowBlank: true,
                                                                name:"Calorias-Dia",
                                                                fieldLabel:"Calorias-Dia",
                                                                id: 'intCaloriasDia'
                                                            },
                                                            {
                                                                html: 'Edad Met. Años:'
                                                            },
                                                            {
                                                                xtype: 'numberfield',
                                                                width: 60,
                                                                decimalPrecision: 2,
                                                                allowBlank: true,
                                                                name:"Edad Met. Años",
                                                                id: 'intEdadMetAños'
                                                            },
                                                            {
                                                                html: 'KG. Peso Oseo'
                                                            },
                                                            {
                                                                xtype: 'numberfield',
                                                                width: 60,
                                                                decimalPrecision: 2,
                                                                allowBlank: true,
                                                                name:"KG. Peso Oseo",
                                                                id: 'intKGPesoOseo'
                                                            },
                                                            {
                                                                html: '% G-V'
                                                            },
                                                            {
                                                                xtype: 'numberfield',
                                                                width: 60,
                                                                decimalPrecision: 2,
                                                                allowBlank: true,
                                                                name:"Porcentaje G-V",
                                                                id: 'intPorcentajeGV'
                                                            }
                                                        ]
                                                    },
                                                    {
                                                        xtype: 'panel',
                                                        title: '<center>TANAKA</center>',
                                                        layout: 'form',
                                                        width: 750,
                                                        autoHeight: true,
                                                        items: [
                                                            {
                                                                xtype: 'panel',
                                                                layout: 'table',
                                                                anchor: '100%',
                                                                padding: 0,
                                                                layoutConfig: {
                                                                    columns: 3
                                                                },
                                                                autoHeight: true,
                                                                items: [
                                                                    {
                                                                        xtype: 'panel',
                                                                        layout: 'form',
                                                                        width: 250,
                                                                        height: 340,
                                                                        labelWidth: 1,
                                                                        labelSeparator: '',
                                                                        items: [
                                                                            {
                                                                                xtype: 'compositefield',
                                                                                style: 'background:transparent;',
                                                                                items: [
                                                                                    {
                                                                                        xtype: 'numberfield',
                                                                                        width: 60,
                                                                                        decimalPrecision: 1,
                                                                                        allowBlank: true,
                                                                                        name: "Tanaka",
                                                                                        value: 100,
                                                                                        id: 'intTanaka100',
                                                                                        listeners:{
                                                                                            change : function(f,pNew, pOld){
                                                                                                if(pNew != null || pNew != 0){
                                                                                                    CalculoTanaka();
                                                                                                }
                                                                                            }
                                                                                        }
                                                                                    },
                                                                                    {
                                                                                        html: '% '
                                                                                    },
                                                                                    {
                                                                                        xtype: 'numberfield',
                                                                                        width: 60,
                                                                                        decimalPrecision: 1,
                                                                                        allowBlank: true,
                                                                                        readOnly: true,
                                                                                        id: 'intTanakaR100'
                                                                                    }
                                                                                ]
                                                                            },
                                                                            {
                                                                                xtype: 'compositefield',
                                                                                style: 'background:transparent;',
                                                                                items: [
                                                                                    {
                                                                                        xtype: 'numberfield',
                                                                                        width: 60,
                                                                                        decimalPrecision: 1,
                                                                                        allowBlank: true,
                                                                                        name:"Tanaka",
                                                                                        value: 95,
                                                                                        id: 'intTanaka95',
                                                                                        listeners:{
                                                                                            change : function(f,pNew, pOld){
                                                                                                if(pNew != null || pNew != 0){
                                                                                                    CalculoTanaka();
                                                                                                }
                                                                                            }
                                                                                        }
                                                                                    },
                                                                                    {
                                                                                        html: '% '
                                                                                    },
                                                                                    {
                                                                                        xtype: 'numberfield',
                                                                                        width: 60,
                                                                                        decimalPrecision: 1,
                                                                                        allowBlank: true,
                                                                                        readOnly: true,
                                                                                        id: 'intTanakaR95'
                                                                                    }
                                                                                ]
                                                                            },
                                                                            {
                                                                                xtype: 'compositefield',
                                                                                style: 'background:transparent;',
                                                                                items: [
                                                                                    {
                                                                                        xtype: 'numberfield',
                                                                                        width: 60,
                                                                                        decimalPrecision: 1,
                                                                                        allowBlank: true,
                                                                                        name:"Tanaka",
                                                                                        value: 90,
                                                                                        id: 'intTanaka90',
                                                                                        listeners:{
                                                                                            change : function(f,pNew, pOld){
                                                                                                if(pNew != null || pNew != 0){
                                                                                                    CalculoTanaka();
                                                                                                }
                                                                                            }
                                                                                        }
                                                                                    },
                                                                                    {
                                                                                        html: '% '
                                                                                    },
                                                                                    {
                                                                                        xtype: 'numberfield',
                                                                                        width: 60,
                                                                                        decimalPrecision: 1,
                                                                                        allowBlank: true,
                                                                                        readOnly: true,
                                                                                        id: 'intTanakaR90'
                                                                                    }
                                                                                ]
                                                                            },
                                                                            {
                                                                                xtype: 'compositefield',
                                                                                style: 'background:transparent;',
                                                                                items: [
                                                                                    {
                                                                                        xtype: 'numberfield',
                                                                                        width: 60,
                                                                                        decimalPrecision: 1,
                                                                                        allowBlank: true,
                                                                                        name:"Tanaka",
                                                                                        value: 85,
                                                                                        id: 'intTanaka85',
                                                                                        listeners:{
                                                                                            change : function(f,pNew, pOld){
                                                                                                if(pNew != null || pNew != 0){
                                                                                                    CalculoTanaka();
                                                                                                }
                                                                                            }
                                                                                        }
                                                                                    },
                                                                                    {
                                                                                        html: '% '
                                                                                    },
                                                                                    {
                                                                                        xtype: 'numberfield',
                                                                                        width: 60,
                                                                                        decimalPrecision: 1,
                                                                                        allowBlank: true,
                                                                                        readOnly: true,
                                                                                        id: 'intTanakaR85'
                                                                                    }
                                                                                ]
                                                                            },
                                                                            {
                                                                                xtype: 'compositefield',
                                                                                style: 'background:transparent;',
                                                                                items: [
                                                                                    {
                                                                                        xtype: 'numberfield',
                                                                                        width: 60,
                                                                                        decimalPrecision: 1,
                                                                                        allowBlank: true,
                                                                                        name:"Tanaka",
                                                                                        value: 80,
                                                                                        id: 'intTanaka80',
                                                                                        listeners:{
                                                                                            change : function(f,pNew, pOld){
                                                                                                if(pNew != null || pNew != 0){
                                                                                                    CalculoTanaka();
                                                                                                }
                                                                                            }
                                                                                        }
                                                                                    },
                                                                                    {
                                                                                        html: '% '
                                                                                    },
                                                                                    {
                                                                                        xtype: 'numberfield',
                                                                                        width: 60,
                                                                                        decimalPrecision: 1,
                                                                                        allowBlank: true,
                                                                                        readOnly: true,
                                                                                        id: 'intTanakaR80'
                                                                                    }
                                                                                ]
                                                                            },
                                                                            {
                                                                                xtype: 'compositefield',
                                                                                style: 'background:transparent;',
                                                                                items: [
                                                                                    {
                                                                                        xtype: 'numberfield',
                                                                                        width: 60,
                                                                                        decimalPrecision: 1,
                                                                                        allowBlank: true,
                                                                                        name:"Tanaka",
                                                                                        value: 75,
                                                                                        id: 'intTanaka75',
                                                                                        listeners:{
                                                                                            change : function(f,pNew, pOld){
                                                                                                if(pNew != null || pNew != 0){
                                                                                                    CalculoTanaka();
                                                                                                }
                                                                                            }
                                                                                        }
                                                                                    },
                                                                                    {
                                                                                        html: '% '
                                                                                    },
                                                                                    {
                                                                                        xtype: 'numberfield',
                                                                                        width: 60,
                                                                                        decimalPrecision: 1,
                                                                                        allowBlank: true,
                                                                                        readOnly: true,
                                                                                        id: 'intTanakaR75'
                                                                                    }
                                                                                ]
                                                                            },
                                                                            {
                                                                                xtype: 'compositefield',
                                                                                style: 'background:transparent;',
                                                                                items: [
                                                                                    {
                                                                                        xtype: 'numberfield',
                                                                                        width: 60,
                                                                                        decimalPrecision: 1,
                                                                                        allowBlank: true,
                                                                                        name:"Tanaka",
                                                                                        value: 70,
                                                                                        id: 'intTanaka70',
                                                                                        listeners:{
                                                                                            change : function(f,pNew, pOld){
                                                                                                if(pNew != null || pNew != 0){
                                                                                                    CalculoTanaka();
                                                                                                }
                                                                                            }
                                                                                        }
                                                                                    },
                                                                                    {
                                                                                        html: '% '
                                                                                    },
                                                                                    {
                                                                                        xtype: 'numberfield',
                                                                                        width: 60,
                                                                                        decimalPrecision: 1,
                                                                                        allowBlank: true,
                                                                                        readOnly: true,
                                                                                        id: 'intTanakaR70'
                                                                                    }
                                                                                ]
                                                                            },
                                                                            {
                                                                                xtype: 'compositefield',
                                                                                style: 'background:transparent;',
                                                                                items: [
                                                                                    {
                                                                                        xtype: 'numberfield',
                                                                                        width: 60,
                                                                                        decimalPrecision: 1,
                                                                                        allowBlank: true,
                                                                                        name:"Tanaka",
                                                                                        value: 65,
                                                                                        id: 'intTanaka65',
                                                                                        listeners:{
                                                                                            change : function(f,pNew, pOld){
                                                                                                if(pNew != null || pNew != 0){
                                                                                                    CalculoTanaka();
                                                                                                }
                                                                                            }
                                                                                        }
                                                                                    },
                                                                                    {
                                                                                        html: '% '
                                                                                    },
                                                                                    {
                                                                                        xtype: 'numberfield',
                                                                                        width: 60,
                                                                                        decimalPrecision: 1,
                                                                                        allowBlank: true,
                                                                                        readOnly: true,
                                                                                        id: 'intTanakaR65'
                                                                                    }
                                                                                ]
                                                                            },
                                                                            {
                                                                                xtype: 'compositefield',
                                                                                style: 'background:transparent;',
                                                                                items: [
                                                                                    {
                                                                                        xtype: 'numberfield',
                                                                                        width: 60,
                                                                                        decimalPrecision: 1,
                                                                                        allowBlank: true,
                                                                                        name:"Tanaka",
                                                                                        value: 60,
                                                                                        id: 'intTanaka60',
                                                                                        listeners:{
                                                                                            change : function(f,pNew, pOld){
                                                                                                if(pNew != null || pNew != 0){
                                                                                                    CalculoTanaka();
                                                                                                }
                                                                                            }
                                                                                        }
                                                                                    },
                                                                                    {
                                                                                        html: '% '
                                                                                    },
                                                                                    {
                                                                                        xtype: 'numberfield',
                                                                                        width: 60,
                                                                                        decimalPrecision: 1,
                                                                                        allowBlank: true,
                                                                                        readOnly: true,
                                                                                        id: 'intTanakaR60'
                                                                                    }
                                                                                ]
                                                                            },
                                                                            {
                                                                                xtype: 'compositefield',
                                                                                style: 'background:transparent;',
                                                                                items: [
                                                                                    {
                                                                                        xtype: 'numberfield',
                                                                                        width: 60,
                                                                                        decimalPrecision: 1,
                                                                                        allowBlank: true,
                                                                                        name:"Tanaka",
                                                                                        value: 55,
                                                                                        id: 'intTanaka55',
                                                                                        listeners:{
                                                                                            change : function(f,pNew, pOld){
                                                                                                if(pNew != null || pNew != 0){
                                                                                                    CalculoTanaka();
                                                                                                }
                                                                                            }
                                                                                        }
                                                                                    },
                                                                                    {
                                                                                        html: '% '
                                                                                    },
                                                                                    {
                                                                                        xtype: 'numberfield',
                                                                                        width: 60,
                                                                                        decimalPrecision: 1,
                                                                                        allowBlank: true,
                                                                                        readOnly: true,
                                                                                        id: 'intTanakaR55'
                                                                                    }
                                                                                ]
                                                                            },
                                                                            {
                                                                                xtype: 'compositefield',
                                                                                style: 'background:transparent;',
                                                                                items: [
                                                                                    {
                                                                                        xtype: 'numberfield',
                                                                                        width: 60,
                                                                                        decimalPrecision: 1,
                                                                                        allowBlank: true,
                                                                                        name:"Tanaka",
                                                                                        value: 50,
                                                                                        id: 'intTanaka50',
                                                                                        listeners:{
                                                                                            change : function(f,pNew, pOld){
                                                                                                if(pNew != null || pNew != 0){
                                                                                                    CalculoTanaka();
                                                                                                }
                                                                                            }
                                                                                        }
                                                                                    },
                                                                                    {
                                                                                        html: '% '
                                                                                    },
                                                                                    {
                                                                                        xtype: 'numberfield',
                                                                                        width: 60,
                                                                                        decimalPrecision: 1,
                                                                                        allowBlank: true,
                                                                                        readOnly: true,
                                                                                        id: 'intTanakaR50'
                                                                                    }
                                                                                ]
                                                                            },
                                                                            {
                                                                                xtype: 'compositefield',
                                                                                style: 'background:transparent;',
                                                                                items: [
                                                                                    {
                                                                                        xtype: 'numberfield',
                                                                                        width: 60,
                                                                                        decimalPrecision: 1,
                                                                                        allowBlank: true,
                                                                                        name:"Tanaka",
                                                                                        value: 45,
                                                                                        id: 'intTanaka45',
                                                                                        listeners:{
                                                                                            change : function(f,pNew, pOld){
                                                                                                if(pNew != null || pNew != 0){
                                                                                                    CalculoTanaka();
                                                                                                }
                                                                                            }
                                                                                        }
                                                                                    },
                                                                                    {
                                                                                        html: '% '
                                                                                    },
                                                                                    {
                                                                                        xtype: 'numberfield',
                                                                                        width: 60,
                                                                                        decimalPrecision: 1,
                                                                                        allowBlank: true,
                                                                                        readOnly: true,
                                                                                        id: 'intTanakaR45'
                                                                                    }
                                                                                ]
                                                                            },
                                                                            {
                                                                                xtype: 'compositefield',
                                                                                style: 'background:transparent;',
                                                                                items: [
                                                                                    {
                                                                                        xtype: 'numberfield',
                                                                                        width: 60,
                                                                                        decimalPrecision: 1,
                                                                                        allowBlank: true,
                                                                                        name:"Tanaka",
                                                                                        value: 40,
                                                                                        id: 'intTanaka40',
                                                                                        listeners:{
                                                                                            change : function(f,pNew, pOld){
                                                                                                if(pNew != null || pNew != 0){
                                                                                                    CalculoTanaka();
                                                                                                }
                                                                                            }
                                                                                        }
                                                                                    },
                                                                                    {
                                                                                        html: '% '
                                                                                    },
                                                                                    {
                                                                                        xtype: 'numberfield',
                                                                                        width: 60,
                                                                                        decimalPrecision: 1,
                                                                                        allowBlank: true,
                                                                                        readOnly: true,
                                                                                        id: 'intTanakaR40'
                                                                                    }
                                                                                ]
                                                                            }
                                                                        ]
                                                                    },
                                                                    {
                                                                        xtype: 'panel',
                                                                        layout: 'form',
                                                                        width: 250,
                                                                        height: 340,
                                                                        labelWidth: 100,
                                                                        labelSeparator: '',
                                                                        items: [
                                                                            {
                                                                                xtype: 'numberfield',
                                                                                width: 100,
                                                                                decimalPrecision: 1,
                                                                                allowBlank: true,
                                                                                name:"Tanaka",
                                                                                fieldLabel:"Tanaka",
                                                                                id: 'intTanaka'
                                                                            },
                                                                            {
                                                                                xtype: 'numberfield',
                                                                                width: 100,
                                                                                decimalPrecision: 8,
                                                                                allowBlank: true,
                                                                                name:"AKS",
                                                                                fieldLabel:"AKS",
                                                                                id: 'intAKS'
                                                                            }
                                                                        ]
                                                                    }
                                                                ]
                                                            }
                                                        ]
                                                    }
                                                ]
                                            },
                                            {
                                                xtype: 'fieldset',
                                                title: 'LIMITACIONES OSTEOMUSCULARES',
                                                layout: 'table',
                                                collapseFirst: false,
                                                collapsible: true,
                                                animCollapse: true,
                                                titleCollapse: true,
                                                anchor: '100%',
                                                autoHeight: true,
                                                padding: 7,
                                                items: [
                                                    {
                                                        xtype: 'textarea',
                                                        anchor: '100%',
                                                        width: 880,
                                                        fieldLabel: 'LIMITACIONES OSTEOMUSCULARES',
                                                        name: 'LIMITACIONES OSTEOMUSCULARES',
                                                        height: 100,
                                                        allowBlank: true,
                                                        id: 'memLimitacionesosteoMusculares'
                                                    }
                                                ]
                                            },
                                            {
                                                xtype: 'fieldset',
                                                title: 'EVENTOS',
                                                layout: 'form',
                                                collapseFirst: false,
                                                collapsible: true,
                                                animCollapse: true,
                                                titleCollapse: true,
                                                anchor: '100%',
                                                autoHeight: true,
                                                padding: 7,
                                                items: [
                                                     {
                                                        xtype: 'compositefield',
                                                        style: 'background:transparent;',
                                                        items: [
                                                            {
                                                                xtype: 'numberfield',
                                                                fieldLabel: 'T.A.',
                                                                name: 'T.A. Sistolica',
                                                                width: 60,
                                                                minValue: 0,
                                                                maxValue: 300,
                                                                decimalPrecision: 0,
                                                                allowBlank: true,
                                                                id: 'intTASistolica'
                                                            },
                                                            {
                                                                html: '/'
                                                            },
                                                            {
                                                                xtype: 'numberfield',
                                                                name: 'T.A. Diastolica',
                                                                width: 60,
                                                                minValue: 0,
                                                                maxValue: 300,
                                                                decimalPrecision: 0,
                                                                allowBlank: true,
                                                                id: 'intTADiastolica'
                                                            },
                                                            {
                                                                html: 'F.C.'
                                                            },                                                            
                                                            {
                                                                xtype: 'numberfield',
                                                                width: 60,
                                                                minValue: 0,
                                                                decimalPrecision: 2,
                                                                name: 'FC',
                                                                allowBlank: true,
                                                                id: 'intFC'
                                                            },
                                                            {
                                                                html: 'F.R.'
                                                            },                                                            
                                                            {
                                                                xtype: 'numberfield',
                                                                width: 60,
                                                                minValue: 0,
                                                                decimalPrecision: 2,
                                                                name: 'FR',
                                                                allowBlank: true,
                                                                id: 'intFR'
                                                            }
                                                        ]
                                                     },
                                                     {
                                                        xtype: 'compositefield',
                                                        style: 'background:transparent;',
                                                        items: [                                                         
                                                            {
                                                                xtype: 'numberfield',
                                                                width: 60,
                                                                minValue: 0,
                                                                decimalPrecision: 2,
                                                                name: 'SAT O2',
                                                                fieldLabel: 'SAT O2',
                                                                allowBlank: true,
                                                                id: 'intSATO2'
                                                            },
                                                            {
                                                                html: 'Temperatura'
                                                            },
                                                            {
                                                                xtype: 'numberfield',
                                                                width: 60,
                                                                minValue: 0,
                                                                decimalPrecision: 2,
                                                                name: 'Temperatura',
                                                                allowBlank: true,
                                                                id: 'intTemp'
                                                            }
                                                        ]
                                                    },
                                                    {
                                                        xtype: 'textfield',
                                                        anchor: '100%',
                                                        fieldLabel: 'Estratificacion Del Riesgo',
                                                        name: 'Estratificacion Del Riesgo',
                                                        allowBlank: true,
                                                        id: 'strEstratificacionRiesgo'
                                                    },                                                       
                                                    {
                                                        xtype: 'numberfield',
                                                        width: 60,
                                                        minValue: 0,
                                                        decimalPrecision: 0,
                                                        name: 'Nro. Sesiones',
                                                        fieldLabel: 'Nro. Sesiones',
                                                        allowBlank: true,
                                                        id: 'intNumeroSesiones'
                                                    },
                                                ]
                                            },
                                            {
                                                xtype: 'fieldset',
                                                title: 'PROTOCOLO',
                                                layout: 'form',
                                                collapseFirst: false,
                                                collapsible: true,
                                                animCollapse: true,
                                                titleCollapse: true,
                                                anchor: '100%',
                                                autoHeight: true,
                                                padding: 7,
                                                items: [
                                                    {
                                                        xtype: 'compositefield',
                                                        style: 'background:transparent;',
                                                        items: [ 
                                                            {
                                                                html: 'ERGOMETRIA SIMPLE INICIAL '
                                                            },
                                                            {
                                                                xtype: 'combo',
                                                                name: 'ERGOMETRIA SIMPLE INICIAL',
                                                                width: 150,
                                                                allowBlank: true,
                                                                store: 'StoreSiNo',
                                                                valueField: 'Descripcion',
                                                                displayField: 'Descripcion',
                                                                mode: 'local',
                                                                forceSelection: true,
                                                                typeAhead: true,
                                                                typeAheadDelay: 10,
                                                                triggerAction: 'all',
                                                                id: 'strProtocoloErgometria'
                                                            }
                                                        ]
                                                    },
                                                    {
                                                        html: '<br>'
                                                    },
                                                    {
                                                        xtype: 'compositefield',
                                                        style: 'background:transparent;',
                                                        items: [ 
                                                            {
                                                                html: 'TELEMETRIA'
                                                            },
                                                            {
                                                                xtype: 'combo',
                                                                name: 'TELEMETRIA',
                                                                width: 150,
                                                                allowBlank: true,
                                                                store: 'StoreSiNo',
                                                                valueField: 'Descripcion',
                                                                displayField: 'Descripcion',
                                                                mode: 'local',
                                                                forceSelection: true,
                                                                typeAhead: true,
                                                                typeAheadDelay: 10,
                                                                triggerAction: 'all',
                                                                id: 'strProtocoloTelemetria'
                                                            }
                                                        ]
                                                    },
                                                    {
                                                        html: '<br>'
                                                    },
                                                    {
                                                        xtype: 'compositefield',
                                                        style: 'background:transparent;',
                                                        items: [ 
                                                            {
                                                                html: 'MEDICION DE VARIABLES  HEMODINAMICAS  EN REPOSO-DURANTE EL EJERCICIO Y AL FINAL'
                                                            },
                                                            {
                                                                xtype: 'combo',
                                                                name: 'MEDICION DE VARIABLES  HEMODINAMICAS  EN REPOSO-DURANTE EL EJERCICIO Y AL FINAL',
                                                                width: 150,
                                                                allowBlank: true,
                                                                store: 'StoreSiNo',
                                                                valueField: 'Descripcion',
                                                                displayField: 'Descripcion',
                                                                mode: 'local',
                                                                forceSelection: true,
                                                                typeAhead: true,
                                                                typeAheadDelay: 10,
                                                                triggerAction: 'all',
                                                                id: 'strProtocoloHemodinamicas'
                                                            }
                                                        ]
                                                    },
                                                    {
                                                        html: '<br>'
                                                    },
                                                    {
                                                        xtype: 'compositefield',
                                                        style: 'background:transparent;',
                                                        items: [ 
                                                            {
                                                                html: 'MONITOR DE FRECUENCIA CARDIACA  TIPO POLAR'
                                                            },
                                                            {
                                                                xtype: 'combo',
                                                                name: 'MONITOR DE FRECUENCIA CARDIACA  TIPO POLAR ',
                                                                width: 150,
                                                                allowBlank: true,
                                                                store: 'StoreSiNo',
                                                                valueField: 'Descripcion',
                                                                displayField: 'Descripcion',
                                                                mode: 'local',
                                                                forceSelection: true,
                                                                typeAhead: true,
                                                                typeAheadDelay: 10,
                                                                triggerAction: 'all',
                                                                id: 'strProtocoloMonitorFC'
                                                            }
                                                        ]
                                                    },
                                                    {
                                                        html: '<br>'
                                                    },
                                                    {
                                                        xtype: 'compositefield',
                                                        style: 'background:transparent;',
                                                        items: [ 
                                                            {
                                                                html: 'FASE CALENTAMIENTO 10 MINUTOS'
                                                            },
                                                            {
                                                                xtype: 'combo',
                                                                name: 'FASE CALENTAMIENTO 10 MINUTOS',
                                                                width: 150,
                                                                allowBlank: true,
                                                                store: 'StoreSiNo',
                                                                valueField: 'Descripcion',
                                                                displayField: 'Descripcion',
                                                                mode: 'local',
                                                                forceSelection: true,
                                                                typeAhead: true,
                                                                typeAheadDelay: 10,
                                                                triggerAction: 'all',
                                                                id: 'strProtocoloCalentamiento'
                                                            }
                                                        ]
                                                    },
                                                    {
                                                        html: '<br>'
                                                    },
                                                    {
                                                        xtype: 'compositefield',
                                                        style: 'background:transparent;',
                                                        items: [ 
                                                            {
                                                                html: 'TRABAJO AEROBICO ASI: 30 MINUTOS (15-15) ESCALA  DE BORG   ENTRE  3 Y 4, O FC  ENTRE:'
                                                            },
                                                            {
                                                                xtype: 'numberfield',
                                                                width: 60,
                                                                minValue: 0,
                                                                decimalPrecision: 0,
                                                                name: 'TRABAJO AEROBICO: FC X MIN',
                                                                allowBlank: true,
                                                                id: 'intProtocoloTrabajoAerobico'
                                                            }, 
                                                            {
                                                                html: 'X MINUTO SEGUN TANAKA'
                                                            }
                                                        ]
                                                    },
                                                    {
                                                        xtype: 'compositefield',
                                                        style: 'background:transparent;',
                                                        items: [
                                                            {
                                                                xtype: 'numberfield',
                                                                width: 60,
                                                                minValue: 0,
                                                                decimalPrecision: 0,
                                                                name: 'PROCENTAJE TANAKA 1',
                                                                allowBlank: true,
                                                                id: 'intProtocoloTrabajoAerobicoPorcentaje1'
                                                            }, 
                                                            {
                                                                html: '% AL'
                                                            },
                                                            {
                                                                xtype: 'numberfield',
                                                                width: 60,
                                                                minValue: 0,
                                                                decimalPrecision: 0,
                                                                name: 'PROCENTAJE TANAKA 2',
                                                                allowBlank: true,
                                                                id: 'intProtocoloTrabajoAerobicoPorcentaje2'
                                                            }, 
                                                            {
                                                                html: 'DE LA MAXIMA'
                                                            },
                                                        ]
                                                    },
                                                    {
                                                        html: '<br>'
                                                    },
                                                    {
                                                        xtype: 'compositefield',
                                                        style: 'background:transparent;',
                                                        items: [ 
                                                            {
                                                                html: 'ERGOMETRO DE TREN INFERIOR TIPO RECUMBENT A:'
                                                            },
                                                            {
                                                                xtype: 'numberfield',
                                                                width: 60,
                                                                minValue: 0,
                                                                decimalPrecision: 0,
                                                                name: 'ERGOMETRO DE TREN INFERIOR TIPO RECUMBENT 1',
                                                                allowBlank: true,
                                                                id: 'intProtocoloErgometroInferior1'
                                                            }, 
                                                            {
                                                                html: 'A:'
                                                            },
                                                            {
                                                                xtype: 'numberfield',
                                                                width: 60,
                                                                minValue: 0,
                                                                decimalPrecision: 0,
                                                                name: 'ERGOMETRO DE TREN INFERIOR TIPO RECUMBENT 2',
                                                                allowBlank: true,
                                                                id: 'intProtocoloErgometroInferior2'
                                                            },
                                                            {
                                                                html: 'WATTIOS CON CADENCIA DE:'
                                                            },
                                                            {
                                                                xtype: 'numberfield',
                                                                width: 60,
                                                                minValue: 0,
                                                                decimalPrecision: 0,
                                                                name: 'WATTIOS CON CADENCIA DE:',
                                                                allowBlank: true,
                                                                id: 'intProtocoloCadencia'
                                                            },
                                                            {
                                                                html: 'CICLOS x MIN'
                                                            },
                                                        ]
                                                    },
                                                    {
                                                        html: '<br>'
                                                    },
                                                    {
                                                        xtype: 'compositefield',
                                                        style: 'background:transparent;',
                                                        items: [ 
                                                            {
                                                                html: 'ERGOMETRO DE BRAZOS A ENTRE'
                                                            },
                                                            {
                                                                xtype: 'numberfield',
                                                                width: 60,
                                                                minValue: 0,
                                                                decimalPrecision: 0,
                                                                name: 'ERGOMETRO DE BRAZOS',
                                                                allowBlank: true,
                                                                id: 'intProtocoloErgometroBrazos'
                                                            }, 
                                                            {
                                                                html: 'RPM'
                                                            }
                                                        ]
                                                    },
                                                    {
                                                        html: '<br>'
                                                    },
                                                    {
                                                        xtype: 'compositefield',
                                                        style: 'background:transparent;',
                                                        items: [ 
                                                            {
                                                                html: 'ELIPTICA A:'
                                                            },
                                                            {
                                                                xtype: 'numberfield',
                                                                width: 60,
                                                                minValue: 0,
                                                                decimalPrecision: 0,
                                                                name: 'ELIPTICA METS',
                                                                allowBlank: true,
                                                                id: 'intProtocoloElipticaMets'
                                                            }, 
                                                            {
                                                                html: 'METS O'
                                                            },
                                                            {
                                                                xtype: 'numberfield',
                                                                width: 60,
                                                                minValue: 0,
                                                                decimalPrecision: 0,
                                                                name: 'ELIPTICA WATTIOS',
                                                                allowBlank: true,
                                                                id: 'intProtocoloElipticaWattios'
                                                            },  
                                                            {
                                                                html: 'WATTIOS'
                                                            },
                                                        ]
                                                    },
                                                    {
                                                        html: '<br>'
                                                    },
                                                    {
                                                        xtype: 'compositefield',
                                                        style: 'background:transparent;',
                                                        items: [ 
                                                            {
                                                                html: 'CAMINADORA O BANDA A VELOCIDAD DE'
                                                            },
                                                            {
                                                                xtype: 'numberfield',
                                                                width: 60,
                                                                minValue: 0,
                                                                decimalPrecision: 0,
                                                                name: 'CAMINADORA O BANDA A VELOCIDAD X MIN',
                                                                allowBlank: true,
                                                                id: 'intProtocoloCaminadoraMin'
                                                            }, 
                                                            {
                                                                html: '/ MIN E INCLINACION DE'
                                                            },
                                                            {
                                                                xtype: 'numberfield',
                                                                width: 60,
                                                                minValue: 0,
                                                                decimalPrecision: 0,
                                                                name: 'CAMINADORA O BANDA A VELOCIDAD INCLINACION',
                                                                allowBlank: true,
                                                                id: 'intProtocoloCaminadoraInclinacion'
                                                            }, 
                                                        ]
                                                    },
                                                    {
                                                        html: '<br>'
                                                    },
                                                    {
                                                        xtype: 'compositefield',
                                                        style: 'background:transparent;',
                                                        items: [ 
                                                            {
                                                                html: 'FORTALECIMIENTO SOLO CON AUTOCARGA'
                                                            },
                                                            {
                                                                xtype: 'numberfield',
                                                                width: 60,
                                                                minValue: 0,
                                                                decimalPrecision: 0,
                                                                name: 'FORTALECIMIENTO AUTOCARGA',
                                                                allowBlank: true,
                                                                id: 'intProtocoloFortalecimientoAutocarga'
                                                            }, 
                                                            {
                                                                html: 'O FORTALECIMIENTO A'
                                                            },
                                                            {
                                                                xtype: 'numberfield',
                                                                width: 60,
                                                                minValue: 0,
                                                                decimalPrecision: 0,
                                                                name: 'FORTALECIMIENTO A',
                                                                allowBlank: true,
                                                                id: 'intProtocoloFortalecimientoA'
                                                            },
                                                            {
                                                                html: '% DE 1 RM'
                                                            }
                                                        ]
                                                    },
                                                    {
                                                        xtype: 'compositefield',
                                                        style: 'background:transparent;',
                                                        items: [ 
                                                            {
                                                                xtype: 'numberfield',
                                                                width: 60,
                                                                minValue: 0,
                                                                decimalPrecision: 0,
                                                                name: 'FORTALECIMIENTO SERIES',
                                                                allowBlank: true,
                                                                id: 'intProtocoloFortalecimientoSeries'
                                                            },
                                                            {
                                                                html: 'SERIES'
                                                            },
                                                            {
                                                                xtype: 'numberfield',
                                                                width: 60,
                                                                minValue: 0,
                                                                decimalPrecision: 0,
                                                                name: 'FORTALECIMIENTO REPETICIONES',
                                                                allowBlank: true,
                                                                id: 'intProtocoloFortalecimientoRepeticiones'
                                                            },
                                                            {
                                                                html: 'REPETICIONES'
                                                            }
                                                        ]
                                                    },
                                                    {
                                                        html: '<br>'
                                                    },
                                                    {
                                                        xtype: 'compositefield',
                                                        style: 'background:transparent;',
                                                        items: [ 
                                                            {
                                                                html: 'HIDRATACION AGUA O BEBIDA CON ELECTROLITOS'
                                                            },
                                                            {
                                                                xtype: 'combo',
                                                                name: 'HIDRATACION AGUA O BEBIDA CON ELECTROLITOS',
                                                                width: 150,
                                                                allowBlank: true,
                                                                store: 'StoreSiNo',
                                                                valueField: 'Descripcion',
                                                                displayField: 'Descripcion',
                                                                mode: 'local',
                                                                forceSelection: true,
                                                                typeAhead: true,
                                                                typeAheadDelay: 10,
                                                                triggerAction: 'all',
                                                                id: 'strProtocoloHidratacion'
                                                            },
                                                            {
                                                                html: 'CANTIDAD CC'
                                                            },
                                                            {
                                                                xtype: 'textfield',
                                                                anchor: '100%',
                                                                name: 'Cantidad CC',
                                                                allowBlank: true,
                                                                id: 'strCantidadCC'
                                                            }
                                                        ]
                                                    },
                                                    {
                                                        html: '<br>'
                                                    },
                                                    {
                                                        xtype: 'compositefield',
                                                        style: 'background:transparent;',
                                                        items: [ 
                                                            {
                                                                html: 'OXIGENO CON CANULA NASAL A 1.5 LITROS POR MINUTO'
                                                            },
                                                            {
                                                                xtype: 'combo',
                                                                name: 'OXIGENO CON CANULA NASAL A 1.5 LITROS POR MINUTO',
                                                                width: 150,
                                                                allowBlank: true,
                                                                store: 'StoreSiNo',
                                                                valueField: 'Descripcion',
                                                                displayField: 'Descripcion',
                                                                mode: 'local',
                                                                forceSelection: true,
                                                                typeAhead: true,
                                                                typeAheadDelay: 10,
                                                                triggerAction: 'all',
                                                                id: 'strProtocoloOxigeno'
                                                            }
                                                        ]
                                                    },
                                                    {
                                                        html: '<br>'
                                                    },
                                                    {
                                                        xtype: 'compositefield',
                                                        style: 'background:transparent;',
                                                        items: [ 
                                                            {
                                                                html: 'ISOMETRIA DE LAS EXTREMIDADES Y/O NUCLEO CORE'
                                                            },
                                                            {
                                                                xtype: 'combo',
                                                                name: 'ISOMETRIA DE LAS EXTREMIDADES Y/O NUCLEO CORE',
                                                                width: 150,
                                                                allowBlank: true,
                                                                store: 'StoreSiNo',
                                                                valueField: 'Descripcion',
                                                                displayField: 'Descripcion',
                                                                mode: 'local',
                                                                forceSelection: true,
                                                                typeAhead: true,
                                                                typeAheadDelay: 10,
                                                                triggerAction: 'all',
                                                                id: 'strProtocoloIsometria'
                                                            }
                                                        ]
                                                    },
                                                    {
                                                        html: '<br>'
                                                    },
                                                    {
                                                        xtype: 'compositefield',
                                                        style: 'background:transparent;',
                                                        items: [ 
                                                            {
                                                                html: 'PROTOCOLO PARA SINCOPE (ORTOSTATICOS + ISOMETRIA)'
                                                            },
                                                            {
                                                                xtype: 'combo',
                                                                name: 'PROTOCOLO PARA SINCOPE (ORTOSTATICOS + ISOMETRIA)',
                                                                width: 150,
                                                                allowBlank: true,
                                                                store: 'StoreSiNo',
                                                                valueField: 'Descripcion',
                                                                displayField: 'Descripcion',
                                                                mode: 'local',
                                                                forceSelection: true,
                                                                typeAhead: true,
                                                                typeAheadDelay: 10,
                                                                triggerAction: 'all',
                                                                id: 'strProtocoloSincope'
                                                            }
                                                        ]
                                                    },
                                                    {
                                                        html: '<br>'
                                                    },
                                                    {
                                                        xtype: 'compositefield',
                                                        style: 'background:transparent;',
                                                        items: [ 
                                                            {
                                                                html: 'TRABAJO AEROBICO - ISOMETRICO'
                                                            },
                                                            {
                                                                xtype: 'combo',
                                                                name: 'TRABAJO AEROBICO - ISOMETRICO',
                                                                width: 150,
                                                                allowBlank: true,
                                                                store: 'StoreSiNo',
                                                                valueField: 'Descripcion',
                                                                displayField: 'Descripcion',
                                                                mode: 'local',
                                                                forceSelection: true,
                                                                typeAhead: true,
                                                                typeAheadDelay: 10,
                                                                triggerAction: 'all',
                                                                id: 'strProtocoloTrabajoAerobico'
                                                            }
                                                        ]
                                                    },
                                                    {
                                                        html: '<br>'
                                                    },
                                                    {
                                                        xtype: 'compositefield',
                                                        style: 'background:transparent;',
                                                        items: [ 
                                                            {
                                                                html: 'FASE  DE ENFRIAMIENTO'
                                                            },
                                                            {
                                                                xtype: 'combo',
                                                                name: 'FASE  DE ENFRIAMIENTO',
                                                                width: 150,
                                                                allowBlank: true,
                                                                store: 'StoreSiNo',
                                                                valueField: 'Descripcion',
                                                                displayField: 'Descripcion',
                                                                mode: 'local',
                                                                forceSelection: true,
                                                                typeAhead: true,
                                                                typeAheadDelay: 10,
                                                                triggerAction: 'all',
                                                                id: 'strProtocoloFaseEnfriamiento'
                                                            }
                                                        ]
                                                    },
                                                    {
                                                        html: '<br>'
                                                    },
                                                    {
                                                        xtype: 'compositefield',
                                                        style: 'background:transparent;',
                                                        items: [ 
                                                            {
                                                                html: 'FASE  DE ESTIRAMIENTO'
                                                            },
                                                            {
                                                                xtype: 'combo',
                                                                name: 'USAR PULSOXIMETRIA',
                                                                width: 150,
                                                                allowBlank: true,
                                                                store: 'StoreSiNo',
                                                                valueField: 'Descripcion',
                                                                displayField: 'Descripcion',
                                                                mode: 'local',
                                                                forceSelection: true,
                                                                typeAhead: true,
                                                                typeAheadDelay: 10,
                                                                triggerAction: 'all',
                                                                id: 'strProtocoloPulsoximetria'
                                                            }
                                                        ]
                                                    },
                                                    {
                                                        html: '<br>'
                                                    },
                                                    {
                                                        xtype: 'compositefield',
                                                        style: 'background:transparent;',
                                                        items: [ 
                                                            {
                                                                html: 'DISMINUIR LA INTENSIDAD SI HAY DESATURACION O INCREMENTO DE LA FC'
                                                            },
                                                            {
                                                                xtype: 'numberfield',
                                                                width: 60,
                                                                minValue: 0,
                                                                decimalPrecision: 0,
                                                                name: 'DISMINUIR LA INTENSIDAD DEL EJERCICIO SI HAY DESATURACION O INCREMENTO DE LA FC X MIN',
                                                                allowBlank: true,
                                                                id: 'intProtocoloDisminuirIntensidadFC'
                                                            },
                                                            {
                                                                html: 'X MIN. O SINTOMAS CARDIOVASCULARES'
                                                            }
                                                        ]
                                                    },
                                                    {
                                                        html: '<br>'
                                                    },
                                                    {
                                                        xtype: 'compositefield',
                                                        style: 'background:transparent;',
                                                        items: [ 
                                                            {
                                                                html: 'ERGOMETRIA SIMPLE AL FINALIZAR EL PROTOCOLO DE REHABILITACION CARDIACA'
                                                            },
                                                            {
                                                                xtype: 'combo',
                                                                name: 'ERGOMETRIA SIMPLE AL FINALIZAR EL PROTOCOLO DE REHABILITACION CARDIACA',
                                                                width: 150,
                                                                allowBlank: true,
                                                                store: 'StoreSiNo',
                                                                valueField: 'Descripcion',
                                                                displayField: 'Descripcion',
                                                                mode: 'local',
                                                                forceSelection: true,
                                                                typeAhead: true,
                                                                typeAheadDelay: 10,
                                                                triggerAction: 'all',
                                                                id: 'strProtocoloErgometriaRehabilitacion'
                                                            }
                                                        ]
                                                    },
                                                    {
                                                        html: '<br>'
                                                    },
                                                    {
                                                        xtype: 'compositefield',
                                                        style: 'background:transparent;',
                                                        items: [ 
                                                            {
                                                                html: 'ROPA DEPORTIVA'
                                                            },
                                                            {
                                                                xtype: 'combo',
                                                                name: 'ROPA DEPORTIVA',
                                                                width: 150,
                                                                allowBlank: true,
                                                                store: 'StoreSiNo',
                                                                valueField: 'Descripcion',
                                                                displayField: 'Descripcion',
                                                                mode: 'local',
                                                                forceSelection: true,
                                                                typeAhead: true,
                                                                typeAheadDelay: 10,
                                                                triggerAction: 'all',
                                                                id: 'strProtocoloRopaDeportiva'
                                                            }
                                                        ]
                                                    }
                                                ]
                                            },
                                            {
                                                xtype: 'fieldset',
                                                title: 'RIPS',
                                                layout: 'form',
                                                collapseFirst: false,
                                                collapsible: true,
                                                animCollapse: true,
                                                titleCollapse: true,
                                                anchor: '100%',
                                                autoHeight: true,
                                                padding: 7,
                                                items: [
                                                    {
                                                        xtype: 'compositefield',
                                                        style: 'background:transparent;',
                                                        items: [
                                                            {
                                                                xtype: 'textfield',
                                                                width: 96,
                                                                allowBlank: false,
                                                                fieldLabel: 'Diagnostico Principal',
                                                                id: 'sysDiagPpalHC',
                                                                listeners:{
                                                                    specialkey: function(f,e){
                                                                        if (e.getKey() == e.ENTER || e.getKey() == e.TAB)
                                                                        {
                                                                            if (f.getValue() != "" && f.getValue() != null && f.getValue().toUpperCase() != Ext.getCmp('sysDiagRel1HC').getValue() && f.getValue().toUpperCase() != Ext.getCmp('sysDiagRel2HC').getValue() && f.getValue().toUpperCase() != Ext.getCmp('sysDiagRel3HC').getValue()){
                                                                                Ext.Ajax.request({
                                                                                    url: '../../controlador/cie10/controlador_cie10.php',
                                                                                    params:{
                                                                                        task: 'BUSCAR',
                                                                                        pCodigo: f.getValue().toUpperCase()
                                                                                    },
                                                                                    success: function(response,options)
                                                                                    {
                                                                                        var el = Ext.get('response'); // get the LOG
                                                                                        var Respuesta = response.responseText;
                                                                                        var Contenido = Respuesta.split('^');
                                                                                        if(Contenido[0]=="" || Contenido[0]== "{success:false}" || Contenido[0]== null){
                                                                                            Ext.getCmp('sysDiagPpalHC').setValue(null);
                                                                                            Ext.getCmp('sysDiagPpalHCNom').setValue(null);
                                                                                        } else {
                                                                                            Ext.getCmp('sysDiagPpalHC').setValue(Contenido[0].toUpperCase());
                                                                                            Ext.getCmp('sysDiagPpalHCNom').setValue(Contenido[1].toUpperCase());
                                                                                        }
                                                                                    },
                                                                                    failure: function(response,options){
                                                                                        var el = Ext.get('response');
                                                                                        Ext.getCmp('sysDiagPpalHC').setValue(null);
                                                                                        Ext.getCmp('sysDiagPpalHCNom').setValue(null);
                                                                                    },
                                                                                    scope:this //bind the callbacks
                                                                                });
                                                                            }else{
                                                                                Ext.getCmp('sysDiagPpalHC').setValue(null);
                                                                                Ext.getCmp('sysDiagPpalHCNom').setValue(null);
                                                                            }
                                                                        }
                                                                    },
                                                                    blur: function(t){
                                                                        if(Ext.getCmp('sysDiagPpalHCNom').getValue()==null || Ext.getCmp('sysDiagPpalHCNom').getValue()== "")
                                                                        {
                                                                            if (Ext.getCmp('sysDiagPpalHC').getValue() != "" && Ext.getCmp('sysDiagPpalHC').getValue() != null && Ext.getCmp('sysDiagPpalHC').getValue().toUpperCase() != Ext.getCmp('sysDiagRel1HC').getValue() && Ext.getCmp('sysDiagPpalHC').getValue().toUpperCase() != Ext.getCmp('sysDiagRel2HC').getValue() && Ext.getCmp('sysDiagPpalHC').getValue().toUpperCase() != Ext.getCmp('sysDiagRel3HC').getValue()){
                                                                                Ext.Ajax.request({
                                                                                    url: '../../controlador/cie10/controlador_cie10.php',
                                                                                    params:{
                                                                                        task: 'BUSCAR',
                                                                                        pCodigo: Ext.getCmp('sysDiagPpalHC').getValue().toUpperCase()
                                                                                    },
                                                                                    success: function(response,options)
                                                                                    {
                                                                                        var el = Ext.get('response'); // get the LOG
                                                                                        var Respuesta = response.responseText;
                                                                                        var Contenido = Respuesta.split('^');
                                                                                        if(Contenido[0]=="" || Contenido[0]== "{success:false}" || Contenido[0]== null){
                                                                                            Ext.getCmp('sysDiagPpalHC').setValue(null);
                                                                                            Ext.getCmp('sysDiagPpalHCNom').setValue(null);
                                                                                        } else {
                                                                                            Ext.getCmp('sysDiagPpalHC').setValue(Contenido[0].toUpperCase());
                                                                                            Ext.getCmp('sysDiagPpalHCNom').setValue(Contenido[1].toUpperCase());
                                                                                        }
                                                                                    },
                                                                                    failure: function(response,options){
                                                                                        var el = Ext.get('response');
                                                                                        Ext.getCmp('sysDiagPpalHC').setValue(null);
                                                                                        Ext.getCmp('sysDiagPpalHCNom').setValue(null);
                                                                                    },
                                                                                    scope:this //bind the callbacks
                                                                                });
                                                                            }else{
                                                                                Ext.getCmp('sysDiagPpalHC').setValue(null);
                                                                                Ext.getCmp('sysDiagPpalHCNom').setValue(null);
                                                                            }
                                                                        }
                                                                    }
                                                                }
                                                            },
                                                            {
                                                                xtype: 'textarea',
                                                                readOnly: true,
                                                                width: 625,
                                                                height: 22,
                                                                id: 'sysDiagPpalHCNom'
                                                            },
                                                            {
                                                                xtype: 'button',
                                                                iconCls: 'btnBuscar',
                                                                tooltip: 'Buscar Diagnostico Principal',
                                                                id: 'btnSearchDiagPpalHC',
                                                                listeners:{
                                                                    click : function(){
                                                                        buscarcie10('sysDiagPpalHC','sysDiagPpalHCNom');
                                                                    }
                                                                }
                                                            }
                                                        ]
                                                    },
                                                    {
                                                        xtype: 'compositefield',
                                                        style: 'background:transparent;',
                                                        items: [
                                                            {
                                                                xtype: 'textfield',
                                                                width: 96,
                                                                allowBlank: true,
                                                                fieldLabel: 'Diagnostico Relacionado Nro.1',
                                                                id: 'sysDiagRel1HC',
                                                                listeners:{
                                                                    specialkey: function(f,e){
                                                                        if (e.getKey() == e.ENTER || e.getKey() == e.TAB)
                                                                        {
                                                                            if (f.getValue() != "" && f.getValue() != null && f.getValue().toUpperCase() != Ext.getCmp('sysDiagPpalHC').getValue() && f.getValue().toUpperCase() != Ext.getCmp('sysDiagRel2HC').getValue() && f.getValue().toUpperCase() != Ext.getCmp('sysDiagRel3HC').getValue()){
                                                                                Ext.Ajax.request(
                                                                                {
                                                                                    url: '../../controlador/cie10/controlador_cie10.php',
                                                                                    params:{
                                                                                        task: 'BUSCAR',
                                                                                        pCodigo: f.getValue().toUpperCase()
                                                                                    },
                                                                                    success: function(response,options)
                                                                                    {
                                                                                        var el = Ext.get('response'); // get the LOG
                                                                                        var Respuesta = response.responseText;
                                                                                        var Contenido = Respuesta.split('^');
                                                                                        if(Contenido[0]=="" || Contenido[0]== "{success:false}" || Contenido[0]== null){
                                                                                            Ext.getCmp('sysDiagRel1HC').setValue(null);
                                                                                            Ext.getCmp('sysDiagRel1HCNom').setValue(null);
                                                                                        } else {
                                                                                            Ext.getCmp('sysDiagRel1HC').setValue(Contenido[0].toUpperCase());
                                                                                            Ext.getCmp('sysDiagRel1HCNom').setValue(Contenido[1].toUpperCase());
                                                                                        }
                                                                                    },
                                                                                    failure: function(response,options){
                                                                                        var el = Ext.get('response');
                                                                                        Ext.getCmp('sysDiagRel1HC').setValue(null);
                                                                                        Ext.getCmp('sysDiagRel1HCNom').setValue(null);
                                                                                    },
                                                                                    scope:this //bind the callbacks
                                                                                });
                                                                            }else{
                                                                                Ext.getCmp('sysDiagRel1HC').setValue(null);
                                                                                Ext.getCmp('sysDiagRel1HCNom').setValue(null);
                                                                            }
                                                                        }
                                                                    },
                                                                    blur: function(t){
                                                                        if (Ext.getCmp('sysDiagRel1HCNom').getValue == null ||  Ext.getCmp('sysDiagRel1HCNom').getValue() == "")
                                                                        {
                                                                            if (Ext.getCmp('sysDiagRel1HC').getValue() != "" && Ext.getCmp('sysDiagRel1HC').getValue() != null && Ext.getCmp('sysDiagRel1HC').getValue().toUpperCase() != Ext.getCmp('sysDiagPpalHC').getValue() && Ext.getCmp('sysDiagRel1HC').getValue().toUpperCase() != Ext.getCmp('sysDiagRel2HC').getValue() && Ext.getCmp('sysDiagRel1HC').getValue().toUpperCase() != Ext.getCmp('sysDiagRel3HC').getValue()){
                                                                                Ext.Ajax.request(
                                                                                {
                                                                                    url: '../../controlador/cie10/controlador_cie10.php',
                                                                                    params:{
                                                                                        task: 'BUSCAR',
                                                                                        pCodigo: Ext.getCmp('sysDiagRel1HC').getValue().toUpperCase()
                                                                                    },
                                                                                    success: function(response,options)
                                                                                    {
                                                                                        var el = Ext.get('response'); // get the LOG
                                                                                        var Respuesta = response.responseText;
                                                                                        var Contenido = Respuesta.split('^');
                                                                                        if(Contenido[0]=="" || Contenido[0]== "{success:false}" || Contenido[0]== null){
                                                                                            Ext.getCmp('sysDiagRel1HC').setValue(null);
                                                                                            Ext.getCmp('sysDiagRel1HCNom').setValue(null);
                                                                                        } else {
                                                                                            Ext.getCmp('sysDiagRel1HC').setValue(Contenido[0].toUpperCase());
                                                                                            Ext.getCmp('sysDiagRel1HCNom').setValue(Contenido[1].toUpperCase());
                                                                                        }
                                                                                    },
                                                                                    failure: function(response,options){
                                                                                        var el = Ext.get('response');
                                                                                        Ext.getCmp('sysDiagRel1HC').setValue(null);
                                                                                        Ext.getCmp('sysDiagRel1HCNom').setValue(null);
                                                                                    },
                                                                                    scope:this //bind the callbacks
                                                                                });
                                                                            }else{
                                                                                Ext.getCmp('sysDiagRel1HC').setValue(null);
                                                                                Ext.getCmp('sysDiagRel1HCNom').setValue(null);
                                                                            }
                                                                        }
                                                                    }
                                                                }
                                                            },
                                                            {
                                                                xtype: 'textarea',
                                                                readOnly: true,
                                                                width: 625,
                                                                height: 22,
                                                                id: 'sysDiagRel1HCNom'
                                                            },
                                                            {
                                                                xtype: 'button',
                                                                iconCls: 'btnBuscar',
                                                                tooltip: 'Buscar Diagnostico Relacionado1',
                                                                id: 'btnSearchDiagRel1HC',
                                                                listeners:{
                                                                    click : function(){
                                                                        buscarcie10('sysDiagRel1HC','sysDiagRel1HCNom');
                                                                    }
                                                                }
                                                            }
                                                        ]
                                                    },
                                                    {
                                                        xtype: 'compositefield',
                                                        style: 'background:transparent;',
                                                        items: [
                                                            {
                                                                xtype: 'textfield',
                                                                width: 96,
                                                                allowBlank: true,
                                                                fieldLabel: 'Diagnostico Relacionado Nro.2',
                                                                id: 'sysDiagRel2HC',
                                                                listeners:{
                                                                    specialkey: function(f,e){
                                                                        if (e.getKey() == e.ENTER || e.getKey() == e.TAB)
                                                                        {
                                                                            if (f.getValue() != "" && f.getValue() != null && f.getValue().toUpperCase() != Ext.getCmp('sysDiagPpalHC').getValue() && f.getValue().toUpperCase() != Ext.getCmp('sysDiagRel1HC').getValue() && f.getValue().toUpperCase() != Ext.getCmp('sysDiagRel3HC').getValue()){
                                                                                Ext.Ajax.request(
                                                                                {
                                                                                    url: '../../controlador/cie10/controlador_cie10.php',
                                                                                    params:{
                                                                                        task: 'BUSCAR',
                                                                                        pCodigo: f.getValue().toUpperCase()
                                                                                    },
                                                                                    success: function(response,options)
                                                                                    {
                                                                                        var el = Ext.get('response'); // get the LOG
                                                                                        var Respuesta = response.responseText;
                                                                                        var Contenido = Respuesta.split('^');
                                                                                        if(Contenido[0]=="" || Contenido[0]== "{success:false}" || Contenido[0]== null){
                                                                                            Ext.getCmp('sysDiagRel2HC').setValue(null);
                                                                                            Ext.getCmp('sysDiagRel2HCNom').setValue(null);
                                                                                        } else {
                                                                                            Ext.getCmp('sysDiagRel2HC').setValue(Contenido[0].toUpperCase());
                                                                                            Ext.getCmp('sysDiagRel2HCNom').setValue(Contenido[1].toUpperCase());
                                                                                        }
                                                                                    },
                                                                                    failure: function(response,options){
                                                                                        var el = Ext.get('response');
                                                                                        Ext.getCmp('sysDiagRel2HC').setValue(null);
                                                                                        Ext.getCmp('sysDiagRel2HCNom').setValue(null);
                                                                                    },
                                                                                    scope:this //bind the callbacks
                                                                                });
                                                                            }else{
                                                                                Ext.getCmp('sysDiagRel2HC').setValue(null);
                                                                                Ext.getCmp('sysDiagRel2HCNom').setValue(null);
                                                                            }
                                                                        }
                                                                    },
                                                                    blur: function(t){
                                                                        if (Ext.getCmp('sysDiagRel2HCNom').getValue == null || Ext.getCmp('sysDiagRel2HCNom').getValue() == "")
                                                                        {
                                                                            if (Ext.getCmp('sysDiagRel2HC').getValue() != "" && Ext.getCmp('sysDiagRel2HC').getValue() != null && Ext.getCmp('sysDiagRel2HC').getValue().toUpperCase() != Ext.getCmp('sysDiagPpalHC').getValue() && Ext.getCmp('sysDiagRel2HC').getValue().toUpperCase() != Ext.getCmp('sysDiagRel1HC').getValue() && Ext.getCmp('sysDiagRel2HC').getValue().toUpperCase() != Ext.getCmp('sysDiagRel3HC').getValue()){
                                                                                Ext.Ajax.request(
                                                                                {
                                                                                    url: '../../controlador/cie10/controlador_cie10.php',
                                                                                    params:{
                                                                                        task: 'BUSCAR',
                                                                                        pCodigo: Ext.getCmp('sysDiagRel2HC').getValue().toUpperCase()
                                                                                    },
                                                                                    success: function(response,options)
                                                                                    {
                                                                                        var el = Ext.get('response'); // get the LOG
                                                                                        var Respuesta = response.responseText;
                                                                                        var Contenido = Respuesta.split('^');
                                                                                        if(Contenido[0]=="" || Contenido[0]== "{success:false}" || Contenido[0]== null){
                                                                                            Ext.getCmp('sysDiagRel2HC').setValue(null);
                                                                                            Ext.getCmp('sysDiagRel2HCNom').setValue(null);
                                                                                        } else {
                                                                                            Ext.getCmp('sysDiagRel2HC').setValue(Contenido[0].toUpperCase());
                                                                                            Ext.getCmp('sysDiagRel2HCNom').setValue(Contenido[1].toUpperCase());
                                                                                        }
                                                                                    },
                                                                                    failure: function(response,options){
                                                                                        var el = Ext.get('response');
                                                                                        Ext.getCmp('sysDiagRel2HC').setValue(null);
                                                                                        Ext.getCmp('sysDiagRel2HCNom').setValue(null);
                                                                                    },
                                                                                    scope:this //bind the callbacks
                                                                                });
                                                                            }else{
                                                                                Ext.getCmp('sysDiagRel2HC').setValue(null);
                                                                                Ext.getCmp('sysDiagRel2HCNom').setValue(null);
                                                                            }
                                                                        }
                                                                    }
                                                                }
                                                            },
                                                            {
                                                                xtype: 'textarea',
                                                                readOnly: true,
                                                                width: 625,
                                                                height: 22,
                                                                id: 'sysDiagRel2HCNom'
                                                            },
                                                            {
                                                                xtype: 'button',
                                                                iconCls: 'btnBuscar',
                                                                tooltip: 'Buscar Diagnostico Relacionado2',
                                                                id: 'btnSearchDiagRel2HC1',
                                                                listeners:{
                                                                    click : function(){
                                                                        buscarcie10('sysDiagRel2HC','sysDiagRel2HCNom');
                                                                    }
                                                                }
                                                            }
                                                        ]
                                                    },
                                                    {
                                                        xtype: 'compositefield',
                                                        style: 'background:transparent;',
                                                        items: [
                                                            {
                                                                xtype: 'textfield',
                                                                width: 96,
                                                                allowBlank: true,
                                                                fieldLabel: 'Diagnostico Relacionado Nro.3',
                                                                id: 'sysDiagRel3HC',
                                                                listeners:{
                                                                    specialkey: function(f,e){
                                                                        if (e.getKey() == e.ENTER || e.getKey() == e.TAB)
                                                                        {
                                                                            if (f.getValue() != "" && f.getValue() != null && f.getValue().toUpperCase() != Ext.getCmp('sysDiagPpalHC').getValue() && f.getValue().toUpperCase() != Ext.getCmp('sysDiagRel1HC').getValue() && f.getValue().toUpperCase() != Ext.getCmp('sysDiagRel2HC').getValue()){
                                                                                Ext.Ajax.request(
                                                                                {
                                                                                    url: '../../controlador/cie10/controlador_cie10.php',
                                                                                    params:{
                                                                                        task: 'BUSCAR',
                                                                                        pCodigo: f.getValue().toUpperCase()
                                                                                    },
                                                                                    success: function(response,options)
                                                                                    {
                                                                                        var el = Ext.get('response'); // get the LOG
                                                                                        var Respuesta = response.responseText;
                                                                                        var Contenido = Respuesta.split('^');
                                                                                        if(Contenido[0]=="" || Contenido[0]== "{success:false}" || Contenido[0]== null){
                                                                                            Ext.getCmp('sysDiagRel3HC').setValue(null);
                                                                                            Ext.getCmp('sysDiagRel3HCNom').setValue(null);
                                                                                        } else {
                                                                                            Ext.getCmp('sysDiagRel3HC').setValue(Contenido[0].toUpperCase());
                                                                                            Ext.getCmp('sysDiagRel3HCNom').setValue(Contenido[1].toUpperCase());
                                                                                        }
                                                                                    },
                                                                                    failure: function(response,options){
                                                                                        var el = Ext.get('response');
                                                                                        Ext.getCmp('sysDiagRel3HC').setValue(null);
                                                                                        Ext.getCmp('sysDiagRel3HCNom').setValue(null);
                                                                                    },
                                                                                    scope:this //bind the callbacks
                                                                                });
                                                                            }else{
                                                                                Ext.getCmp('sysDiagRel3HC').setValue(null);
                                                                                Ext.getCmp('sysDiagRel3HCNom').setValue(null);
                                                                            }
                                                                        }
                                                                    },
                                                                    blur: function(t){
                                                                        if (Ext.getCmp('sysDiagRel3HCNom').getValue == null || Ext.getCmp('sysDiagRel3HCNom').getValue() == "")
                                                                        {
                                                                            if (Ext.getCmp('sysDiagRel3HC').getValue() != "" && Ext.getCmp('sysDiagRel3HC').getValue() != null && Ext.getCmp('sysDiagRel3HC').getValue().toUpperCase() != Ext.getCmp('sysDiagPpalHC').getValue() && Ext.getCmp('sysDiagRel3HC').getValue().toUpperCase() != Ext.getCmp('sysDiagRel1HC').getValue() && Ext.getCmp('sysDiagRel3HC').getValue().toUpperCase() != Ext.getCmp('sysDiagRel2HC').getValue()){
                                                                                Ext.Ajax.request(
                                                                                {
                                                                                    url: '../../controlador/cie10/controlador_cie10.php',
                                                                                    params:{
                                                                                        task: 'BUSCAR',
                                                                                        pCodigo: Ext.getCmp('sysDiagRel3HC').getValue().toUpperCase()
                                                                                    },
                                                                                    success: function(response,options)
                                                                                    {
                                                                                        var el = Ext.get('response'); // get the LOG
                                                                                        var Respuesta = response.responseText;
                                                                                        var Contenido = Respuesta.split('^');
                                                                                        if(Contenido[0]=="" || Contenido[0]== "{success:false}" || Contenido[0]== null){
                                                                                            Ext.getCmp('sysDiagRel3HC').setValue(null);
                                                                                            Ext.getCmp('sysDiagRel3HCNom').setValue(null);
                                                                                        } else {
                                                                                            Ext.getCmp('sysDiagRel3HC').setValue(Contenido[0].toUpperCase());
                                                                                            Ext.getCmp('sysDiagRel3HCNom').setValue(Contenido[1].toUpperCase());
                                                                                        }
                                                                                    },
                                                                                    failure: function(response,options){
                                                                                        var el = Ext.get('response');
                                                                                        Ext.getCmp('sysDiagRel3HC').setValue(null);
                                                                                        Ext.getCmp('sysDiagRel3HCNom').setValue(null);
                                                                                    },
                                                                                    scope:this //bind the callbacks
                                                                                });
                                                                            }else{
                                                                                Ext.getCmp('sysDiagRel3HC').setValue(null);
                                                                                Ext.getCmp('sysDiagRel3HCNom').setValue(null);
                                                                            }
                                                                        }
                                                                    }
                                                                }
                                                            },
                                                            {
                                                                xtype: 'textarea',
                                                                readOnly: true,
                                                                width: 625,
                                                                height: 22,
                                                                id: 'sysDiagRel3HCNom'
                                                            },
                                                            {
                                                                xtype: 'button',
                                                                iconCls: 'btnBuscar',
                                                                tooltip: 'Buscar Diagnostico Relacionado3',
                                                                id: 'btnSearchDiagRel3HC',
                                                                listeners:{
                                                                    click : function(){
                                                                        buscarcie10('sysDiagRel3HC','sysDiagRel3HCNom');
                                                                    }
                                                                }
                                                            }
                                                        ]
                                                    },
                                                    {
                                                        xtype: 'combo',
                                                        fieldLabel: 'Tipo de Diagnostico',
                                                        width:750,
                                                        name: 'Tipo de Diagnostico',
                                                        allowBlank: false,
                                                        store: 'StoreTipoDiagnostico',
                                                        forceSelection: true,
                                                        triggerAction: 'all',
                                                        typeAhead: true,
                                                        typeAheadDelay: 50,
                                                        mode: 'local',
                                                        valueField: 'Codigo',
                                                        displayField: 'Descripcion',
                                                        emptyText: 'Seleccione....',
                                                        submitValue: true,
                                                        id: 'sysTipoDiagosticoHC'
                                                    },
                                                    {
                                                        xtype: 'combo',
                                                        fieldLabel: 'Finalidad Consulta',
                                                        width:750,
                                                        name: 'Finalidad Consulta',
                                                        allowBlank: false,
                                                        store: 'StoreFinalidadConsulta',
                                                        forceSelection: true,
                                                        triggerAction: 'all',
                                                        typeAhead: true,
                                                        typeAheadDelay: 50,
                                                        mode: 'local',
                                                        valueField: 'Codigo',
                                                        displayField: 'Descripcion',
                                                        emptyText: 'Seleccione....',
                                                        submitValue: true,
                                                        id: 'sysFinalidadConsultaHC'
                                                    },
                                                    {
                                                        xtype: 'combo',
                                                        fieldLabel: 'Causa Externa',
                                                        width:750,
                                                        name: 'Causa Externa',
                                                        allowBlank: false,
                                                        store: 'StoreCausaExterna',
                                                        forceSelection: true,
                                                        triggerAction: 'all',
                                                        typeAhead: true,
                                                        typeAheadDelay: 50,
                                                        mode: 'local',
                                                        valueField: 'Codigo',
                                                        displayField: 'Descripcion',
                                                        emptyText: 'Seleccione....',
                                                        submitValue: true,
                                                        id: 'sysCausaExternaHC'
                                                    }
                                                ]
                                            }
                                        ]
                                    }
                                ]
                            }
                        ]
                    }
                ],
                bbar:{
                    items: [
                        {
                            xtype: 'tbfill'
                        },
                        {
                            xtype: 'tbseparator'
                        },
                        {
                            xtype: 'button',
                            text: 'Salir',
                            iconCls: 'btnSalir',
                            id: 'btnSalirEvolucion',
                            listeners:{
                                click : function(){
                                    if (Ext.getCmp('sysYaGuardoHC').getValue() == 1)
                                        Ext.Msg.show({
                                            title: 'eOfiClinic',
                                            msg: 'Esta seguro que desea cerrar la ventana?',
                                            buttons: Ext.Msg.YESNO,
                                            icon: Ext.Msg.QUESTION,
                                            fn: function(btn)
                                            {
                                                if(btn=="yes")
                                                {
                                                    Ext.getCmp('gridFormulario').store.reload();
                                                    Ext.getCmp('winHC').close();
                                                }
                                            }
                                        });
                                    else{
                                        Ext.Msg.show({
                                            title: 'eOfiClinic',
                                            msg: 'Usted No ha Guardado la Evolución del Paciente y Se Perdera la Información, Esta seguro que desea cerrar la ventana?',
                                            buttons: Ext.Msg.YESNO,
                                            icon: Ext.Msg.QUESTION,
                                            fn: function(btn)
                                            {
                                                if(btn=="yes")
                                                {
                                                    Ext.getCmp('gridFormulario').store.reload();
                                                    Ext.getCmp('winHC').close();
                                                }
                                            }
                                        });
                                    }
                                }
                            }
                        }
                    ]
                },
                tbar:{
                    items: [
                        {
                            xtype: 'tbseparator'
                        },
                        {
                            xtype: 'button',
                            text: 'Ver Historia Clínica',
                            iconCls: 'btnVerHC',
                            id: 'btnVerHC',
                            listeners:{
                                click : function(){
                                    var cmpResumenHC = new winFrmVerHistorialHC({
                                        renderTo: Ext.getBody()
                                    });
                                    Ext.getCmp('winViewEvolucionHC').title = "PACIENTE: " + Ext.getCmp('sysPacienteHC').getValue();
                                    Ext.getCmp('gridHistorialEvoluciones').store.load({
                                        params: {
                                            pEmpresa: Ext.getCmp('sysEmpresaHC').getValue(),
                                            pPaciente: Ext.getCmp('sysIdPacienteHC').getValue()
                                        }
                                    });
                                    cmpResumenHC.show();
                                }
                            }
                        },
                        {
                            xtype: 'tbfill'
                        },
                        {
                            xtype: 'tbseparator'
                        },
                        {
                            xtype: 'button',
                            text: 'Guardar Evolución',
                            iconCls: 'btnGuardar',
                            id: 'btnGuardarEvolucion',
                            listeners:{
                                click : function(){
                                    if (Ext.getCmp('sysYaGuardoHC').getValue() == 0)
                                    {
                                        Ext.Msg.show({
                                            title: 'eOfiClinic',
                                            msg: 'Esta seguro que desea Guardar la evolución?',
                                            buttons: Ext.Msg.YESNO,
                                            icon: Ext.Msg.QUESTION,
                                            fn: function(btn)
                                            {
                                                if(btn=="yes")
                                                {
                                                    fnGuardarRegistrosMedicinaGeneral();
                                                }
                                            }
                                        });
                                    }else{
                                        Ext.Msg.show({
                                            title: 'eOfiClinic',
                                            msg: 'Esta seguro que desea Modificar la evolución?',
                                            buttons: Ext.Msg.YESNO,
                                            icon: Ext.Msg.QUESTION,
                                            fn: function(btn)
                                            {
                                                if(btn=="yes")
                                                {
                                                    fnModificarRegistrosMedicinaGeneral();
                                                }
                                            }
                                        });
                                    }
                                }
                            }
                        }
                    ]
                }
            }
        ];
        this.on({
            afterlayout:{
                scope:this, 
                single:true, 
                fn:function() {
                    Ext.Msg.hide();
                    //Predefinir Comportamiento Campos
                    if(Ext.getCmp('sysFechaHC').getValue() !== null || Ext.getCmp('sysFechaHC').getValue() !== 0){
                       calculoEdadPacienteMeses();
                       var Tanaka = 208-(AniosCumplidos*0.7);
                       Ext.getCmp('intTanaka').setValue(Tanaka);
                       Ext.getCmp('intTanakaR100').setValue(Tanaka);
                       Ext.getCmp('intTanakaR95').setValue(Tanaka * parseFloat(Ext.getCmp('intTanaka95').getValue())/100);
                       Ext.getCmp('intTanakaR90').setValue(Tanaka * parseFloat(Ext.getCmp('intTanaka90').getValue())/100);
                       Ext.getCmp('intTanakaR85').setValue(Tanaka * parseFloat(Ext.getCmp('intTanaka85').getValue())/100);
                       Ext.getCmp('intTanakaR80').setValue(Tanaka * parseFloat(Ext.getCmp('intTanaka80').getValue())/100);
                       Ext.getCmp('intTanakaR75').setValue(Tanaka * parseFloat(Ext.getCmp('intTanaka75').getValue())/100);
                       Ext.getCmp('intTanakaR70').setValue(Tanaka * parseFloat(Ext.getCmp('intTanaka70').getValue())/100);
                       Ext.getCmp('intTanakaR65').setValue(Tanaka * parseFloat(Ext.getCmp('intTanaka65').getValue())/100);
                       Ext.getCmp('intTanakaR60').setValue(Tanaka * parseFloat(Ext.getCmp('intTanaka60').getValue())/100);
                       Ext.getCmp('intTanakaR55').setValue(Tanaka * parseFloat(Ext.getCmp('intTanaka55').getValue())/100);
                       Ext.getCmp('intTanakaR50').setValue(Tanaka * parseFloat(Ext.getCmp('intTanaka50').getValue())/100);
                       Ext.getCmp('intTanakaR45').setValue(Tanaka * parseFloat(Ext.getCmp('intTanaka45').getValue())/100);
                       Ext.getCmp('intTanakaR40').setValue(Tanaka * parseFloat(Ext.getCmp('intTanaka40').getValue())/100);
                    }
                }
            }
        });
        winHCTerapiaCardiaca001Ui.superclass.initComponent.call(this);
    }
});

function fnGuardarRegistrosMedicinaGeneral(){
    var frm = Ext.getCmp('frmHC').getForm();
    if (frm.isValid())
    {
        var listacampos = ExtraerCamposFrmHC(frm);
        frm.submit({
            url: '../../controlador/asistencial/evolucionhc.php',
            params:{
                task: 'guardar',
                CAMPOS: listacampos,
                pEmpresa: Ext.getCmp('sysEmpresaHC').getValue(),
                pIPS: Ext.getCmp('sysIPSHC').getValue(),
                pPaciente: Ext.getCmp('sysIdPacienteHC').getValue(),
                pProfesional: Ext.getCmp('sysProfesionalHC').getValue(),
                pCAS: Ext.getCmp('sysCASHC').getValue(),
                pidPlantillaHC : Ext.getCmp('sysIdCodPlantillaHC').getValue(),
                pFechaAtencion: Ext.getCmp('sysFechaHC').getValue(),
                pHoraApertura: Ext.getCmp('sysAperturaHC').getValue(),
                pActividad: Ext.getCmp('sysActividadHC').getValue(),
                pPlantilla: Ext.getCmp('sysPlantillaHC').getValue(),
                pRutaRptHC: Ext.getCmp('sysRutaRptHC').getValue(),
                pRutaRptMx: Ext.getCmp('sysRutaRptMx').getValue(),
                pRutaRptExa: Ext.getCmp('sysRutaRptExa').getValue(),
                pRutaRptRem: Ext.getCmp('sysRutaRptRem').getValue(),
                pDiagppal: Ext.getCmp('sysDiagPpalHC').getValue(),
                pDiagrel1: Ext.getCmp('sysDiagRel1HC').getValue(),
                pDiagrel2: Ext.getCmp('sysDiagRel2HC').getValue(),
                pDiagrel3: Ext.getCmp('sysDiagRel3HC').getValue(),
                pTipodiag: Ext.getCmp('sysTipoDiagosticoHC').getValue(),
                pFinalidad: Ext.getCmp('sysFinalidadConsultaHC').getValue(),
                pCausa: Ext.getCmp('sysCausaExternaHC').getValue(),
                pUsuario: Ext.getCmp('sysUsuarioHC').getValue(),
                pIdCliente: Ext.getCmp('sysIdClienteHC').getValue(),
                pIdPlan: Ext.getCmp('sysIdPlanHC').getValue(),
                pIdSubPlan: Ext.getCmp('sysIdSubPlanHC').getValue(),
                pIdContrato: Ext.getCmp('sysIdContratoHC').getValue(),
                pConsecutivoDetalle: Ext.getCmp('sysConsecutivoDetalleHC').getValue()
            },
            success: function(res,req)
            {
                switch(req.result.requestedId){
                    case "1":
                        Ext.MessageBox.show({
                            title: 'Guardar',
                            msg: 'Se Guardo la Información con Exito.',
                            buttons: Ext.MessageBox.OK,
                            icon: Ext.MessageBox.INFO
                        });
                        Ext.getCmp('sysYaGuardoHC').setValue(1);
                        break;

                    default:
                        Ext.MessageBox.show({
                            title: 'Guardar',
                            msg: 'Ocurrio un error al guardar, la llave principal no es valida o no se pudo establecer conexión con el servidor.',
                            buttons: Ext.MessageBox.OK,
                            icon: Ext.MessageBox.ERROR
                        });
                        break;
                }
            },
            failure: function(response,options)
            {
                Ext.MessageBox.show({
                    title: 'Guardar',
                    msg: 'Ocurrio un error al guardar o no se pudo establecer conexión con el servidor.',
                    buttons: Ext.MessageBox.OK,
                    icon: Ext.MessageBox.ERROR
                });
            }
        });
    }else{
        Ext.MessageBox.show({
            title: 'Guardar',
            msg: 'Por favor verifique que todos los campos obligatorios estén diligenciados.',
            buttons: Ext.MessageBox.OK,
            icon: Ext.MessageBox.ERROR
        });
    }
}

function fnModificarRegistrosMedicinaGeneral(){
    var frm = Ext.getCmp('frmHC').getForm();
    if (frm.isValid())
    {
        var listacampos = ExtraerCamposFrmHC(frm);
        frm.submit({
            url: '../../controlador/asistencial/evolucionhc.php',
            params:{
                task: 'modificar',
                CAMPOS: listacampos,
                pEmpresa: Ext.getCmp('sysEmpresaHC').getValue(),
                pIPS: Ext.getCmp('sysIPSHC').getValue(),
                pPaciente: Ext.getCmp('sysIdPacienteHC').getValue(),
                pProfesional: Ext.getCmp('sysProfesionalHC').getValue(),
                pCAS: Ext.getCmp('sysCASHC').getValue(),
                pidPlantillaHC : Ext.getCmp('sysIdCodPlantillaHC').getValue(),
                pFechaAtencion: Ext.getCmp('sysFechaHC').getValue(),
                pHoraApertura: Ext.getCmp('sysAperturaHC').getValue(),
                pActividad: Ext.getCmp('sysActividadHC').getValue(),
                pPlantilla: Ext.getCmp('sysPlantillaHC').getValue(),
                pRutaRptHC: Ext.getCmp('sysRutaRptHC').getValue(),
                pRutaRptMx: Ext.getCmp('sysRutaRptMx').getValue(),
                pRutaRptExa: Ext.getCmp('sysRutaRptExa').getValue(),
                pRutaRptRem: Ext.getCmp('sysRutaRptRem').getValue(),
                pDiagppal: Ext.getCmp('sysDiagPpalHC').getValue(),
                pDiagrel1: Ext.getCmp('sysDiagRel1HC').getValue(),
                pDiagrel2: Ext.getCmp('sysDiagRel2HC').getValue(),
                pDiagrel3: Ext.getCmp('sysDiagRel3HC').getValue(),
                pTipodiag: Ext.getCmp('sysTipoDiagosticoHC').getValue(),
                pFinalidad: Ext.getCmp('sysFinalidadConsultaHC').getValue(),
                pCausa: Ext.getCmp('sysCausaExternaHC').getValue(),
                pUsuario: Ext.getCmp('sysUsuarioHC').getValue(),
                pIdCliente: Ext.getCmp('sysIdClienteHC').getValue(),
                pIdPlan: Ext.getCmp('sysIdPlanHC').getValue(),
                pIdSubPlan: Ext.getCmp('sysIdSubPlanHC').getValue(),
                pIdContrato: Ext.getCmp('sysIdContratoHC').getValue(),
                pConsecutivoDetalle: Ext.getCmp('sysConsecutivoDetalleHC').getValue()
            },
            success: function(res,req)
            {
                switch(req.result.requestedId){
                    case "1":
                        Ext.MessageBox.show({
                            title: 'Guardar',
                            msg: 'Se Guardo la Información con Exito.',
                            buttons: Ext.MessageBox.OK,
                            icon: Ext.MessageBox.INFO
                        });
                        Ext.getCmp('sysYaGuardoHC').setValue(1);
                        break;

                    default:
                        Ext.MessageBox.show({
                            title: 'Guardar',
                            msg: 'Ocurrio un error al guardar, la llave principal no es valida o no se pudo establecer conexión con el servidor.',
                            buttons: Ext.MessageBox.OK,
                            icon: Ext.MessageBox.ERROR
                        });
                        break;
                }
            },
            failure: function(response,options)
            {
                Ext.MessageBox.show({
                    title: 'Guardar',
                    msg: 'Ocurrio un error al guardar o no se pudo establecer conexión con el servidor.',
                    buttons: Ext.MessageBox.OK,
                    icon: Ext.MessageBox.ERROR
                });
            }
        });
    }else{
        Ext.MessageBox.show({
            title: 'Guardar',
            msg: 'Por favor verifique que todos los campos obligatorios estén diligenciados.',
            buttons: Ext.MessageBox.OK,
            icon: Ext.MessageBox.ERROR
        });
    }
}

function calculoEdadPacienteMeses(){
    var valFecha1 = 0;
    var pFec2Anio = 0;
    var pFec2Mes = 0;
    var pFec2Dia = 0;
    var valFecha2 = 0;
    MesesCumplidos = 0;
    AniosCumplidos = 0;


    valFecha1 = Ext.getCmp('sysFechaHC').getValue();
    pFec2Anio = Ext.getCmp('sysFechaNac').getValue().substr(6,4);
    pFec2Mes = Ext.getCmp('sysFechaNac').getValue().substr(3,2);
    pFec2Dia = Ext.getCmp('sysFechaNac').getValue().substr(0,2);
    
    valFecha2 =  pFec2Anio + "/" + pFec2Mes + "/" + pFec2Dia;

    MesesCumplidos = MostrarEdadMeses(valFecha1, valFecha2);
    
    AniosCumplidos = MostrarEdadAnios(valFecha1, valFecha2);
}

function CalculoTanaka(){
    Ext.getCmp('intTanakaR100').setValue(parseFloat(Ext.getCmp('intTanaka').getValue()) * parseFloat(Ext.getCmp('intTanaka100').getValue())/100);
    Ext.getCmp('intTanakaR95').setValue(parseFloat(Ext.getCmp('intTanaka').getValue()) * parseFloat(Ext.getCmp('intTanaka95').getValue())/100);
    Ext.getCmp('intTanakaR90').setValue(parseFloat(Ext.getCmp('intTanaka').getValue()) * parseFloat(Ext.getCmp('intTanaka90').getValue())/100);
    Ext.getCmp('intTanakaR85').setValue(parseFloat(Ext.getCmp('intTanaka').getValue()) * parseFloat(Ext.getCmp('intTanaka85').getValue())/100);
    Ext.getCmp('intTanakaR80').setValue(parseFloat(Ext.getCmp('intTanaka').getValue()) * parseFloat(Ext.getCmp('intTanaka80').getValue())/100);
    Ext.getCmp('intTanakaR75').setValue(parseFloat(Ext.getCmp('intTanaka').getValue()) * parseFloat(Ext.getCmp('intTanaka75').getValue())/100);
    Ext.getCmp('intTanakaR70').setValue(parseFloat(Ext.getCmp('intTanaka').getValue()) * parseFloat(Ext.getCmp('intTanaka70').getValue())/100);
    Ext.getCmp('intTanakaR65').setValue(parseFloat(Ext.getCmp('intTanaka').getValue()) * parseFloat(Ext.getCmp('intTanaka65').getValue())/100);
    Ext.getCmp('intTanakaR60').setValue(parseFloat(Ext.getCmp('intTanaka').getValue()) * parseFloat(Ext.getCmp('intTanaka60').getValue())/100);
    Ext.getCmp('intTanakaR55').setValue(parseFloat(Ext.getCmp('intTanaka').getValue()) * parseFloat(Ext.getCmp('intTanaka55').getValue())/100);
    Ext.getCmp('intTanakaR50').setValue(parseFloat(Ext.getCmp('intTanaka').getValue()) * parseFloat(Ext.getCmp('intTanaka50').getValue())/100);
    Ext.getCmp('intTanakaR45').setValue(parseFloat(Ext.getCmp('intTanaka').getValue()) * parseFloat(Ext.getCmp('intTanaka45').getValue())/100);
    Ext.getCmp('intTanakaR40').setValue(parseFloat(Ext.getCmp('intTanaka').getValue()) * parseFloat(Ext.getCmp('intTanaka40').getValue())/100);
}
