
function retornarLogaritmo(nom){
    return Math.log(nom);
}

function calcularColesterolRat(hdl, chol){
    if (hdl > 0){
        Ext.getCmp('sysRiesgoColesterolHDL').setValue((Math.round((chol * 10) / hdl)) / 10);
    }
}

function calculadoraFramingham(){
    var sbp = parseFloat(Ext.getCmp('sysPASistolica').getValue());
    var hdl = parseFloat(Ext.getCmp('sysColesterolHDL').getValue());
    var chol = parseFloat(Ext.getCmp('sysColesterol').getValue());
    calcularColesterolRat(hdl, chol);
    if (chol > 0){
        if (hdl > 0){
           var cholrat = chol / hdl;
       }
    }
    if (hdl === 0) {
        var cholrat = chol;
        Ext.getCmp('sysRiesgoColesterolHDL').setValue(cholrat);
    }
    if (chol === 0) {
        var cholrat = 5;
        Ext.getCmp('sysRiesgoColesterolHDL').setValue(5);
    }
    if (Ext.getCmp('sysFumador').getValue() === "SI"){
        var smoker = 1;
    }else{
        var smoker = 0;
    }
    Ext.getCmp('sysRiesgo10Anios').setValue(calcularRiesgoFramingham(10, smoker, cholrat, sbp));
    Ext.getCmp('sysRiesgo5Anios').setValue(calcularRiesgoFramingham(5, smoker, cholrat, sbp));
    Ext.getCmp('sysRiesgoTodosAnt').setValue(calcularRiesgoFramingham(10, 0, 4, 120));
    Ext.getCmp('sysRiesgoNoFuma').setValue(calcularRiesgoFramingham(10, 0, cholrat, sbp));
    Ext.getCmp('sysRiesgoColesterol').setValue(calcularRiesgoFramingham(10, smoker, 4, sbp));
    Ext.getCmp('sysRiesgoPA').setValue(calcularRiesgoFramingham(10, smoker, cholrat, 120));
    mostrarAlarmas();
}

function calcularRiesgoFramingham(years, smoker, chdl, bloodpres){
    with (Math){ 
        var age1 = AniosCumplidos;
	var risk = 0;
	var co1 = 0.9145;
	var co2 = -0.2784;
	var co3 = 15.5305;
	var fem = 28.4441;
	var logage = -1.4792;
	var lagef = -14.4588;
	var lagef2 = 1.8515;
	var lsbp = -0.9119;
	var cigs = -0.2767;
	var logchol = -0.7181;
	var diab = -0.1759;
	var diabf = -0.1999;
	var cvrisk = 0;
    }
    cvrisk = co3;
    if (Ext.getCmp('sysGeneroPacHC').setValue() === "FEMENINO"){
        cvrisk += fem;
        cvrisk += (retornarLogaritmo(age1) * lagef);
        cvrisk += (retornarLogaritmo(age1) * retornarLogaritmo(age1) * lagef2);
    }
    cvrisk += (retornarLogaritmo(age1) * logage);
    cvrisk += (retornarLogaritmo(bloodpres) * lsbp);
    if (smoker === 1){
        cvrisk += cigs;
    }
    cvrisk += (retornarLogaritmo(chdl) * logchol);
    if (Ext.getCmp('sysDiabetico').getValue() === "SI"){
        cvrisk += diab;
    }
    var la = (co1 + (co2 * cvrisk));
    la = Math.exp(la);
    la = ((retornarLogaritmo(years) - cvrisk) / la);
    cvrisk = Math.round(1000*(1 - Math.exp(-Math.exp(la))))/10;
    return cvrisk;
}

function mostrarAlarmas() {
    var alarm_on=15;
    var warn_on=10;
    if (parseInt(Ext.getCmp('sysRiesgo10Anios').setValue()) >= alarm_on){
        Ext.getCmp('sysRiesgo10Anios').removeClass('fondoRiesgoRojo');
        Ext.getCmp('sysRiesgo10Anios').removeClass('fondoRiesgoAmarillo');
        Ext.getCmp('sysRiesgo10Anios').removeClass('fondoRiesgoVerde');
        Ext.getCmp('sysRiesgo10Anios').addClass('fondoRiesgoRojo');
    } else {
        if (parseInt(Ext.getCmp('sysRiesgo10Anios').setValue()) >= warn_on) {
            Ext.getCmp('sysRiesgo10Anios').removeClass('fondoRiesgoRojo');
            Ext.getCmp('sysRiesgo10Anios').removeClass('fondoRiesgoAmarillo');
            Ext.getCmp('sysRiesgo10Anios').removeClass('fondoRiesgoVerde');
            Ext.getCmp('sysRiesgo10Anios').addClass('fondoRiesgoAmarillo');
        } else {
            Ext.getCmp('sysRiesgo10Anios').removeClass('fondoRiesgoRojo');
            Ext.getCmp('sysRiesgo10Anios').removeClass('fondoRiesgoAmarillo');
            Ext.getCmp('sysRiesgo10Anios').removeClass('fondoRiesgoVerde');
            Ext.getCmp('sysRiesgo10Anios').addClass('fondoRiesgoVerde');
        }
    }
    if (parseInt(Ext.getCmp('sysRiesgo5Anios').setValue()) >= alarm_on) {
        Ext.getCmp('sysRiesgo5Anios').removeClass('fondoRiesgoRojo');
        Ext.getCmp('sysRiesgo5Anios').removeClass('fondoRiesgoAmarillo');
        Ext.getCmp('sysRiesgo5Anios').removeClass('fondoRiesgoVerde');
        Ext.getCmp('sysRiesgo5Anios').addClass('fondoRiesgoRojo');
    } else {
        if (parseInt(Ext.getCmp('sysRiesgo5Anios').setValue()) >= warn_on) {
            Ext.getCmp('sysRiesgo5Anios').removeClass('fondoRiesgoRojo');
            Ext.getCmp('sysRiesgo5Anios').removeClass('fondoRiesgoAmarillo');
            Ext.getCmp('sysRiesgo5Anios').removeClass('fondoRiesgoVerde');
            Ext.getCmp('sysRiesgo5Anios').addClass('fondoRiesgoAmarillo');
        } else {
            Ext.getCmp('sysRiesgo5Anios').removeClass('fondoRiesgoRojo');
            Ext.getCmp('sysRiesgo5Anios').removeClass('fondoRiesgoAmarillo');
            Ext.getCmp('sysRiesgo5Anios').removeClass('fondoRiesgoVerde');
            Ext.getCmp('sysRiesgo5Anios').addClass('fondoRiesgoVerde');
        }
    }
    
    if (parseInt(Ext.getCmp('sysRiesgoTodosAnt').setValue()) >= alarm_on){
        Ext.getCmp('sysRiesgoTodosAnt').removeClass('fondoRiesgoRojo');
        Ext.getCmp('sysRiesgoTodosAnt').removeClass('fondoRiesgoAmarillo');
        Ext.getCmp('sysRiesgoTodosAnt').removeClass('fondoRiesgoVerde');
        Ext.getCmp('sysRiesgoTodosAnt').addClass('fondoRiesgoRojo');
    } else {
        if (parseInt(Ext.getCmp('sysRiesgoTodosAnt').setValue()) >= warn_on) {
            Ext.getCmp('sysRiesgoTodosAnt').removeClass('fondoRiesgoRojo');
            Ext.getCmp('sysRiesgoTodosAnt').removeClass('fondoRiesgoAmarillo');
            Ext.getCmp('sysRiesgoTodosAnt').removeClass('fondoRiesgoVerde');
            Ext.getCmp('sysRiesgoTodosAnt').addClass('fondoRiesgoAmarillo');
        } else {
            Ext.getCmp('sysRiesgoTodosAnt').removeClass('fondoRiesgoRojo');
            Ext.getCmp('sysRiesgoTodosAnt').removeClass('fondoRiesgoAmarillo');
            Ext.getCmp('sysRiesgoTodosAnt').removeClass('fondoRiesgoVerde');
            Ext.getCmp('sysRiesgoTodosAnt').addClass('fondoRiesgoVerde');
        }
    }
   
    if (parseInt(Ext.getCmp('sysRiesgoNoFuma').setValue()) >= alarm_on){
        Ext.getCmp('sysRiesgoNoFuma').removeClass('fondoRiesgoRojo');
        Ext.getCmp('sysRiesgoNoFuma').removeClass('fondoRiesgoAmarillo');
        Ext.getCmp('sysRiesgoNoFuma').removeClass('fondoRiesgoVerde');
        Ext.getCmp('sysRiesgoNoFuma').addClass('fondoRiesgoRojo');
    } else {
        if (parseInt(Ext.getCmp('sysRiesgoNoFuma').setValue()) >= warn_on) {
            Ext.getCmp('sysRiesgoNoFuma').removeClass('fondoRiesgoRojo');
            Ext.getCmp('sysRiesgoNoFuma').removeClass('fondoRiesgoAmarillo');
            Ext.getCmp('sysRiesgoNoFuma').removeClass('fondoRiesgoVerde');
            Ext.getCmp('sysRiesgoNoFuma').addClass('fondoRiesgoAmarillo');
        } else {
            Ext.getCmp('sysRiesgoNoFuma').removeClass('fondoRiesgoRojo');
            Ext.getCmp('sysRiesgoNoFuma').removeClass('fondoRiesgoAmarillo');
            Ext.getCmp('sysRiesgoNoFuma').removeClass('fondoRiesgoVerde');
            Ext.getCmp('sysRiesgoNoFuma').addClass('fondoRiesgoVerde');
        }
    }
    
    if (parseInt(Ext.getCmp('sysRiesgoColesterol').setValue()) >= alarm_on){
        Ext.getCmp('sysRiesgoColesterol').removeClass('fondoRiesgoRojo');
        Ext.getCmp('sysRiesgoColesterol').removeClass('fondoRiesgoAmarillo');
        Ext.getCmp('sysRiesgoColesterol').removeClass('fondoRiesgoVerde');
        Ext.getCmp('sysRiesgoColesterol').addClass('fondoRiesgoRojo');
    } else {
        if (parseInt(Ext.getCmp('sysRiesgoColesterol').setValue()) >= warn_on) {
            Ext.getCmp('sysRiesgoColesterol').removeClass('fondoRiesgoRojo');
            Ext.getCmp('sysRiesgoColesterol').removeClass('fondoRiesgoAmarillo');
            Ext.getCmp('sysRiesgoColesterol').removeClass('fondoRiesgoVerde');
            Ext.getCmp('sysRiesgoColesterol').addClass('fondoRiesgoAmarillo');
        } else {
            Ext.getCmp('sysRiesgoColesterol').removeClass('fondoRiesgoRojo');
            Ext.getCmp('sysRiesgoColesterol').removeClass('fondoRiesgoAmarillo');
            Ext.getCmp('sysRiesgoColesterol').removeClass('fondoRiesgoVerde');
            Ext.getCmp('sysRiesgoColesterol').addClass('fondoRiesgoVerde');
        }
    }

    if (parseInt(Ext.getCmp('sysRiesgoPA').setValue()) >= alarm_on){
        Ext.getCmp('sysRiesgoPA').removeClass('fondoRiesgoRojo');
        Ext.getCmp('sysRiesgoPA').removeClass('fondoRiesgoAmarillo');
        Ext.getCmp('sysRiesgoPA').removeClass('fondoRiesgoVerde');
        Ext.getCmp('sysRiesgoPA').addClass('fondoRiesgoRojo');
    } else {
        if (parseInt(Ext.getCmp('sysRiesgoPA').setValue()) >= warn_on) {
            Ext.getCmp('sysRiesgoPA').removeClass('fondoRiesgoRojo');
            Ext.getCmp('sysRiesgoPA').removeClass('fondoRiesgoAmarillo');
            Ext.getCmp('sysRiesgoPA').removeClass('fondoRiesgoVerde');
            Ext.getCmp('sysRiesgoPA').addClass('fondoRiesgoAmarillo');
        } else {
            Ext.getCmp('sysRiesgoPA').removeClass('fondoRiesgoRojo');
            Ext.getCmp('sysRiesgoPA').removeClass('fondoRiesgoAmarillo');
            Ext.getCmp('sysRiesgoPA').removeClass('fondoRiesgoVerde');
            Ext.getCmp('sysRiesgoPA').addClass('fondoRiesgoVerde');
        }
    }

    if (parseInt(Ext.getCmp('sysRiesgoColesterolHDL').setValue()) >= 5.5){
        Ext.getCmp('sysRiesgoColesterolHDL').removeClass('fondoRiesgoRojo');
        Ext.getCmp('sysRiesgoColesterolHDL').removeClass('fondoRiesgoAmarillo');
        Ext.getCmp('sysRiesgoColesterolHDL').removeClass('fondoRiesgoVerde');
        Ext.getCmp('sysRiesgoColesterolHDL').addClass('fondoRiesgoRojo');
    } else {
        if (parseInt(Ext.getCmp('sysRiesgoColesterolHDL').setValue()) >= 4.1) {
            Ext.getCmp('sysRiesgoColesterolHDL').removeClass('fondoRiesgoRojo');
            Ext.getCmp('sysRiesgoColesterolHDL').removeClass('fondoRiesgoAmarillo');
            Ext.getCmp('sysRiesgoColesterolHDL').removeClass('fondoRiesgoVerde');
            Ext.getCmp('sysRiesgoColesterolHDL').addClass('fondoRiesgoAmarillo');
        } else {
            Ext.getCmp('sysRiesgoColesterolHDL').removeClass('fondoRiesgoRojo');
            Ext.getCmp('sysRiesgoColesterolHDL').removeClass('fondoRiesgoAmarillo');
            Ext.getCmp('sysRiesgoColesterolHDL').removeClass('fondoRiesgoVerde');
            Ext.getCmp('sysRiesgoColesterolHDL').addClass('fondoRiesgoVerde');
        }
    }
}