
/*
* @category    Formulario Seleccion Plantilla HC y Apertura HC
* @package     OfiClinic Web
* @author      Jorge Ancizar Galeano Ruiz<desarrollo@ofisalud.com>
* @copyright   2010 Jorge Ancizar GAleano Ruiz
* @version     OfiClinic Web 1.0
* @license     COMERCIAL
* @link        http://www.ofisalud.com
* @country     Colombia
* @telephone   3016398114
*/

winSeleccionPlantillaOpenHCUi = Ext.extend(Ext.Window, {
    title: 'eOfiClinic .:: Apertura de Historia Clínica ::.',
    width: 730,
    autoHeight: true,
    modal: true,
    closable: false,
    frame: true,
    padding: 10,
    labelWidth: 150,
    layout: 'form',
    id: 'winSeleccionPlantillaOpenHC',
    style: 'background:transparent;',
    initComponent: function() {
        
        var myMask = new Ext.LoadMask(Ext.getBody(), {msg:"Cargando Formulario..."});
        myMask.show();
        
        var stGrid = new StoreGridPlantillasHC();
        stGrid.setBaseParam('pEmpresa', ID_EMPRESA);
        stGrid.load();
        
        this.items = [
            {
                xtype: 'hidden',
                id: 'sysEmpresaPlantillaHC'
            },
            {
                xtype: 'hidden',
                id: 'sysSedePlantillaHC'
            },
            {
                xtype: 'hidden',
                id: 'sysIPSPlantillaHC'
            },
            {
                xtype: 'hidden',
                id: 'sysActividadPlantillaHC'
            },
            {
                xtype: 'hidden',
                id: 'sysPlantillaPlantillaHC'
            },
            {
                xtype: 'hidden',
                id: 'sysUsuarioPlantillaHC'
            },
            {
                xtype: 'hidden',
                id: 'sysProfesionalPlantillaHC'
            },
            {
                xtype: 'hidden',
                id: 'sysPacientePlantillaHC'
            },
            {
                xtype: 'hidden',
                id: 'sysUbicacionPlantillaHC'
            },
            {
                xtype: 'hidden',
                id: 'sysConsecutivoDetalle_HC'
            },
            {
                xtype: 'hidden',
                id: 'sysYaTomaSignosHC'
            },
            {
                xtype: 'hidden',
                anchor: '100%',
                allowBlank: true,
                id: 'sysGeneroPaciente_HC'
            },
            {
                xtype: 'hidden',
                anchor: '100%',
                allowBlank: true,
                id: 'sysEdadPaciente_HC'
            },
            {
                xtype: 'hidden',
                anchor: '100%',
                allowBlank: true,
                id: 'sysFecNacPaciente_HC'
            },
            {
                xtype: 'textfield',
                anchor: '100%',
                allowBlank: true,
                readOnly: true,
                fieldLabel: 'CAS',
                id: 'sysCASPlantillaHC'
            },
            {
                xtype: 'textfield',
                anchor: '100%',
                allowBlank: true,
                readOnly: true,
                fieldLabel: 'Profesional',
                id: 'sysNomProfesionalPlantillaHC'
            },
            {
                xtype: 'textfield',
                anchor: '100%',
                allowBlank: true,
                readOnly: true,
                fieldLabel: 'Consultorio',
                id: 'sysConsultorioPlantillaHC'
            },
            {
                xtype: 'compositefield',
                frame: true,
                fieldLabel: 'Fecha Cita',
                style: 'background:transparent;',
                items: [
                    {
                        xtype: 'textfield',
                        allowBlank: true,
                        readOnly: true,
                        fieldLabel: 'Fecha',
                        id: 'sysFechaPlantillaHC'
                    },
                    {
                        xtype: 'displayfield',
                        value: ' - Hora:'
                    },
                    {
                        xtype: 'textfield',
                        allowBlank: true,
                        readOnly: true,
                        id: 'sysHoraPlantillaHC'
                    },
                    {
                        xtype: 'displayfield',
                        value: ' - Legalización:'
                    },
                    {
                        xtype: 'textfield',
                        allowBlank: true,
                        readOnly: true,
                        id: 'sysFechaLegalizaPlantillaHC'
                    },
                    {
                        xtype: 'hidden',
                        id: 'sysHoraEstimadaPlantillaHC'
                    }
                ]
            },
            {
                xtype: 'textfield',
                anchor: '100%',
                allowBlank: true,
                readOnly: true,
                fieldLabel: 'Cliente',
                id: 'sysClientePlantillaHC'
            },
            {
                xtype: 'hidden',
                anchor: '100%',
                allowBlank: true,
                id: 'sysIdCliente_HC'
            },
            {
                xtype: 'hidden',
                anchor: '100%',
                allowBlank: true,
                id: 'sysIdPlan_HC'
            },
            {
                xtype: 'hidden',
                anchor: '100%',
                allowBlank: true,
                id: 'sysIdSubPlan_HC'
            },
            {
                xtype: 'hidden',
                anchor: '100%',
                allowBlank: true,
                id: 'sysIdContrato_HC'
            },
            {
                xtype: 'textfield',
                anchor: '100%',
                allowBlank: true,
                readOnly: true,
                fieldLabel: 'Actividad Programada',
                id: 'sysActividadPlantillaHC'
            },
            {
                xtype: 'textfield',
                anchor: '100%',
                autoHeight: true,
                allowBlank: true,
                readOnly: true,
                fieldLabel: 'Paciente',
                id: 'sysNomPacientePlantillaHC'
            },
            {
                xtype: 'grid',
                id: 'gridSeleccionarPlantillaHC',
                store: stGrid,
                anchor: "100%",
                height: 290,
                border: false,
                frame: true,
                loadMask: true,
                stripeRows: true,
                columnLines: true,
                columns: [
                    {
                        header: 'Plantilla',
                        dataIndex: 'NomPlantilla',
                        readOnly: true,
                        sortable: false,
                        width: 650,
                        hideable: false
                    },{
                        header: 'Grupo',
                        dataIndex: 'Grupo',
                        readOnly: true,
                        sortable: false,
                        width: 100,
                        hidden: true,
                        hideable: false
                    }
                ],
                tbar:
                {
                    xtype: 'toolbar',
                    items: [
                        '->',
                        new Ext.app.SearchField({
                            id: 'qryPlantillasHC',
                            store: stGrid,
                            emptyText: 'Escriba el criterio que desea buscar',
                            width: 120
                        })
                    ]
                },
                viewConfig: {
                    forceFit:true
                },
                selModel: new Ext.grid.RowSelectionModel({singleSelect:true}),
                view: new Ext.grid.GroupingView({
                   groupTextTpl: '{text} ({[values.rs.length]} {[values.rs.length > 1 ? "Items" : "Item"]})'
                }),
                buttons: [
                    {
                        text: 'Abrir Histora Clínica',
                        iconCls: 'btnEvolucionar',
                        listeners: {
                            click : function() {
                                if(Ext.getCmp('gridSeleccionarPlantillaHC').selModel.getCount() == 1)
                                {
                                    var selections = Ext.getCmp('gridSeleccionarPlantillaHC').selModel.getSelections();
                                    stCIE10 = new StoreCIE10();
                                    objMX = "NA";
                                    objMXADD = "NA";
                                    objEXA = "NA";
                                    objEXAADD = "NA";
                                    objREM = "NA";
                                    objREMADD = "NA";
                                    wPaciente = Ext.getCmp('sysPacientePlantillaHC').getValue();
                                    wCAS = Ext.getCmp('sysCASPlantillaHC').getValue();
                                    if(selections[0].json.RutaFrmMx != null && selections[0].json.RutaFrmMx != ""){
                                        ScriptMgr.loadJs({
                                            scripts : selections[0].json.RutaFrmMx,
                                            callback : function(){
                                                objMX = selections[0].json.NomObjetoMx;
                                                ScriptMgr.loadJs({
                                                    scripts : selections[0].json.RutaFrmAddMx,
                                                    callback : function(){
                                                        objMXADD = selections[0].json.NomObjetoAddMx;
                                                    }
                                                });
                                            }
                                        });
                                    }
                                    if(selections[0].json.RutaFrmExa != null && selections[0].json.RutaFrmExa != ""){
                                        ScriptMgr.loadJs({
                                            scripts : selections[0].json.RutaFrmExa,
                                            callback : function(){
                                                objEXA = selections[0].json.NomObjetoExa;
                                                ScriptMgr.loadJs({
                                                    scripts : selections[0].json.RutaFrmAddExa,
                                                    callback : function(){
                                                        objEXAADD = selections[0].json.NomObjetoAddExa;
                                                    }
                                                });
                                            }
                                        });
                                    }
                                    if(selections[0].json.RutaFrmRem != null && selections[0].json.RutaFrmRem != ""){
                                        ScriptMgr.loadJs({
                                            scripts : selections[0].json.RutaFrmRem,
                                            callback : function(){
                                                objREM = selections[0].json.NomObjetoRem;
                                                ScriptMgr.loadJs({
                                                    scripts : selections[0].json.RutaFrmAddRem,
                                                    callback : function(){
                                                        objREMADD = selections[0].json.NomObjetoAddRem;
                                                    }
                                                });
                                            }
                                        });
                                    }
                                    ScriptMgr.loadJs({
                                        scripts : selections[0].json.RutaPlantilla,
                                        callback : function(){
                                            var winHC = eval(selections[0].json.NomObjeto);//new winHCUi();
                                            
                                            Ext.getCmp('sysPlantillaHC').setValue(PonerAcentosMayusculas(selections[0].json.NomPlantilla));
                                            Ext.getCmp('sysRutaRptHC').setValue(PonerAcentosMayusculas(selections[0].json.RutaRptHC));
                                            Ext.getCmp('sysRutaRptMx').setValue(PonerAcentosMayusculas(selections[0].json.RutaRptMx));
                                            Ext.getCmp('sysRutaRptExa').setValue(PonerAcentosMayusculas(selections[0].json.RutaRptExa));
                                            Ext.getCmp('sysRutaRptRem').setValue(PonerAcentosMayusculas(selections[0].json.RutaRptRem));
                                            Ext.getCmp('sysActividadHC').setValue(PonerAcentosMayusculas(Ext.getCmp('sysActividadPlantillaHC').getValue()));
                                            Ext.getCmp('sysEmpresaHC').setValue(ID_EMPRESA);
                                            Ext.getCmp('sysIPSHC').setValue(ID_IPS);
                                            Ext.getCmp('sysUsuarioHC').setValue(ID_USUARIO);
                                            Ext.getCmp('sysProfesionalHC').setValue(Ext.getCmp('sysProfesionalPlantillaHC').getValue());
                                            Ext.getCmp('sysIdPacienteHC').setValue(Ext.getCmp('sysPacientePlantillaHC').getValue());
                                            Ext.getCmp('sysClienteHC').setValue(Ext.getCmp('sysClientePlantillaHC').getValue());
                                            Ext.getCmp('sysCASHC').setValue(Ext.getCmp('sysCASPlantillaHC').getValue());
                                            Ext.getCmp('sysProfesionalAgendaHC').setValue(PonerAcentosMayusculas(Ext.getCmp('sysNomProfesionalPlantillaHC').getValue()));
                                            Ext.getCmp('sysFechaHC').setValue(Ext.getCmp('sysFechaPlantillaHC').getValue());
                                            Ext.getCmp('sysHoraHC').setValue(PonerAcentosMayusculas(Ext.getCmp('sysHoraPlantillaHC').getValue()));
                                            Ext.getCmp('sysLegalizaHC').setValue(Ext.getCmp('sysFechaLegalizaPlantillaHC').getValue());
                                            Ext.getCmp('sysPacienteHC').setValue(PonerAcentosMayusculas(Ext.getCmp('sysNomPacientePlantillaHC').getValue()));
                                            Ext.getCmp('sysAperturaHC').setValue(new Date().format("h:i:s"));
                                            
                                            Ext.getCmp('sysConsecutivoDetalleHC').setValue(Ext.getCmp('sysConsecutivoDetalle_HC').getValue());
                                            
                                            Ext.getCmp('sysIdClienteHC').setValue(Ext.getCmp('sysIdCliente_HC').getValue());
                                            Ext.getCmp('sysIdPlanHC').setValue(Ext.getCmp('sysIdPlan_HC').getValue());
                                            Ext.getCmp('sysIdSubPlanHC').setValue(Ext.getCmp('sysIdSubPlan_HC').getValue());
                                            Ext.getCmp('sysIdContratoHC').setValue(Ext.getCmp('sysIdContrato_HC').getValue());
                                            Ext.getCmp('sysIdCodPlantillaHC').setValue(selections[0].json.IdPlantilla);
                                            try {
                                                var campo = Ext.getCmp('sysNroAutorizacionHC');
                                                if ( campo != null ) {
                                                    Ext.getCmp('sysNroAutorizacionHC').setValue(Ext.getCmp('sysNroAutorizacion').getValue());
                                                }
                                            }catch(ex) {
                                            }
                                            try {
                                                var campo1 = Ext.getCmp('strEmpresaSaludOcupacional');
                                                if ( campo1 != null ) {
                                                    Ext.getCmp('strEmpresaSaludOcupacional').setValue(Ext.getCmp('strEmpresaTrabaja').getValue());
                                                }
                                            }catch(ex) {
                                            }
                                            try {
                                                if(Ext.getCmp('strGenero').getValue() == "F"){
                                                    var campoAP_Ginecologicos = Ext.getCmp('memAP_Ginecologicos');
                                                    if ( campoAP_Ginecologicos != null ) {
                                                        Ext.getCmp('memAP_Ginecologicos').setVisible(true);
                                                    }
                                                }
                                            }catch(ex) {
                                            }    
                                            try {
                                                var campo3 = Ext.getCmp('sysGeneroPacHC');
                                                if ( campo3 != null ) {
                                                    if(Ext.getCmp('sysGeneroPaciente_HC').getValue() == "M"){
                                                        Ext.getCmp('sysGeneroPacHC').setValue("MASCULINO");
                                                    }else{
                                                        Ext.getCmp('sysGeneroPacHC').setValue("FEMENINO");
                                                    }
                                                }
                                            }catch(ex) {
                                            }
                                            try {
                                                var campo4 = Ext.getCmp('sysEdadPacHC');
                                                if ( campo4 != null ) {
                                                    Ext.getCmp('sysEdadPacHC').setValue(Ext.getCmp('sysEdadPaciente_HC').getValue());
                                                }
                                            }catch(ex) {
                                            }    
                                            try {
                                                var campo5 = Ext.getCmp('sysFecNacPacHC');
                                                if ( campo5 != null ) {
                                                    Ext.getCmp('sysFecNacPacHC').setValue(Ext.getCmp('sysFecNacPaciente_HC').getValue());
                                                }
                                            }catch(ex) {
                                            }    
                                            paramOpcion = "Nuevo";
                                            if(Ext.getCmp('sysYaTomaSignosHC').getValue() == "1"){
                                                Ext.getCmp('sysYaGuardoHC').setValue(1);
                                                paramOpcion = "Modifica";
                                            }
                                            winHC.show();
                                            Ext.getCmp('winSeleccionPlantillaOpenHC').close();
                                        }
                                    });
                                }else{
                                    Ext.MessageBox.show({
                                        title: 'eOfiClinic',
                                        msg: 'Debe Seleccionar una Plantilla.',
                                        buttons: Ext.MessageBox.OK,
                                        icon: Ext.MessageBox.ERROR
                                    });
                                }
                            }
                        }
                    },
                    {
                        text: 'Cancelar',
                        iconCls: 'btnCancelar',
                        listeners: {
                            click : function() {
                                Ext.Msg.show({
                                    title: 'eOfiClinic',
                                    msg: 'Esta seguro que desea cerrar la ventana?',
                                    buttons: Ext.Msg.YESNO,
                                    icon: Ext.Msg.QUESTION,
                                    fn: function(btn)
                                    {
                                        if(btn=="yes")
                                        {
                                            Ext.getCmp('winSeleccionPlantillaOpenHC').close();
                                        }
                                    }
                                });
                            }
                        }
                    }
                ],
                buttonAlign: 'center',
                listeners: {
                    viewready : function() {
                        myMask.hide();
                    }
                }
            }
        ];
        winSeleccionPlantillaOpenHCUi.superclass.initComponent.call(this);
    }
});
