/*
* @category    Formulario Modelo Evolucion Historia Clinica
* @package     OfiClinic Web
* @author      Jorge Ancizar Galeano Ruiz<desarrollo@ofisalud.com>
* @copyright   2010 Jorge Ancizar Galeano Ruiz
* @version     OfiClinic Web 1.0
* @license     COMERCIAL
* @link        http://www.ofisalud.com
* @country     Colombia
* @telephone   3016398114
*/

winHCMedicinaBasica002Ui = Ext.extend(Ext.Window, {
    title: 'eOfiClinic ©  .:: Plantilla Evaluacion Medica de Fatiga (EMEFA) ::.',
    width: 990,
    height: 636,
    closable: false,
    resizable: false,
    draggable: false,
    modal: true,
    id: 'winHC',
    initComponent: function() {
        
        var fsDiagnosticosConsulta = new fsDiagnosticosConsultaUi();
        
        tmpmx = objMX;
        tmpmxadd = objMXADD;
        tmpexa = objEXA;
        tmprem = objREM;
        myPaciente = 0;
        myCAS = 0;

        try {
            var campo = Ext.getCmp('sysPacientePlantillaHC');
            if ( campo != null ) {
                myPaciente = Ext.getCmp('sysPacientePlantillaHC').getValue();
            }
        }catch(ex){
        }
        if(myPaciente == 0){
            try {
                var campo1 = Ext.getCmp('sysIdPacienteHC');
                if ( campo1 != null ) {
                    myPaciente = Ext.getCmp('sysIdPacienteHC').getValue();
                }
            }catch(ex){
            }
        }
        if(myPaciente == 0){
            try {
                var campo5 = Ext.getCmp('sysPacienteRefHC');
                if ( campo5 != null ) {
                    myPaciente = Ext.getCmp('sysPacienteRefHC').getValue();
                }
            }catch(ex){
            }
        }
        try {
            var campo2 = Ext.getCmp('sysCASPlantillaHC');
            if ( campo2 != null ) {
                myCAS = Ext.getCmp('sysCASPlantillaHC').getValue();
            }
        }catch(ex){
        }
        if(myCAS == 0){
            try {
                var campo3 = Ext.getCmp('sysCASHC');
                if ( campo3 != null ) {
                    myCAS = Ext.getCmp('sysCASHC').getValue();
                }
            }catch(ex){
            }
        }
        if(myCAS == 0){
            try {
                var campo4 = Ext.getCmp('sysCASRefHC');
                if ( campo4 != null ) {
                    myCAS = Ext.getCmp('sysCASRefHC').getValue();
                }
            }catch(ex){
            }
        }
        if (objMX != "NA"){
            var xSolMX = eval(objMX);
            Ext.getCmp('gridMedicamentosHC').store.load({
                params: {
                    pEmpresa: ID_EMPRESA,
                    pIPS: ID_IPS,
                    pPaciente: wPaciente,
                    pCAS: wCAS
                }
            });
        }
        else{
            var xSolMX = Ext.extend(Ext.form.Hidden, {
                initComponent: function() {
                    MyHiddenFieldUi.superclass.initComponent.call(this);
                }
            });
        }
        if (objEXA != "NA"){
            var xSolEXA = eval(objEXA);
            Ext.getCmp('gridExamenesHC').store.load({
                params: {
                    pEmpresa: ID_EMPRESA,
                    pIPS: ID_IPS,
                    pPaciente: wPaciente,
                    pCAS: wCAS
                }
            });
        }else{
            var xSolEXA = Ext.extend(Ext.form.Hidden, {
                initComponent: function() {
                    MyHiddenFieldUi.superclass.initComponent.call(this);
                }
            });
        }
        if (objREM != "NA"){
            var xSolREM = eval(objREM);
            Ext.getCmp('gridRemisionesHC').store.load({
                params: {
                    pEmpresa: ID_EMPRESA,
                    pIPS: ID_IPS,
                    pPaciente: wPaciente,
                    pCAS: wCAS
                }
            });
        }else{
            var xSolREM = Ext.extend(Ext.form.Hidden, {
                initComponent: function() {
                    MyHiddenFieldUi.superclass.initComponent.call(this);
                }
            });
        }

        var dataResultadoCitologia = [
            ['NO REALIZADA'],
            ['NORMAL'],
            ['ANORMAL']
        ];
        var stResultadoCitologia = new Ext.data.ArrayStore({
            fields: [
                {name: 'Descripcion'}
            ]
        });
        stResultadoCitologia.loadData(dataResultadoCitologia);


        var dataProximaCita = [
            ['2 DIAS'],
            ['1 SEMANA'],
            ['1 MES'],
            ['6 MESES'],
            ['1 AÑO'],
            ['CONTROL CON PARACLINICOS']
        ];
        var stProximaCita = new Ext.data.ArrayStore({
            fields: [
                {name: 'Descripcion'}
            ]
        });
        stProximaCita.loadData(dataProximaCita);

        var dataAlteraEmocional = [
            ['PRISA'],
            ['PREMURA'],
            ['AFAN'],
            ['ANGUSTIA'],
            ['MAL HUMOR'],
            ['TRISTEZA'],
            ['EUFORIA'],
            ['TENSION'],
            ['DISTRACCION'],
            ['MIEDO'],
            ['IRA']
        ];
        var stAlteraEmocional = new Ext.data.ArrayStore({
            fields: [
                {name: 'Descripcion'}
            ]
        });
        stAlteraEmocional.loadData(dataAlteraEmocional);
        
        var dataAlteraNeurologicas = [
            ['ATENCION'],
            ['COORDINACION'],
            ['MEMORIA'],
            ['MARCHA'],
            ['EQUILIBRIO']
        ];
        var stAlteraNeurologicas = new Ext.data.ArrayStore({
            fields: [
                {name: 'Descripcion'}
            ]
        });
        stAlteraNeurologicas.loadData(dataAlteraNeurologicas);
        
        //
        this.items = [
            {
                xtype: 'panel',
                frame: true,
                anchor: '100%',
                id: 'panelHC',
                border: false,
                height: 570,
                autoScroll: true,
                layout: 'form',
                style: 'background:transparent;',
                items: [
                    {
                        xtype: 'tabpanel',
                        anchor: '99%',
                        autoHeight: true,
                        border: false,
                        enableTabScroll: true,
                        ref: 'fTabPanel',
                        id: 'fTabPanel',
                        activeTab: 0,
                        items: [
                            {
                                xtype: 'panel',
                                title: 'INFORMACION',
                                autoHeight: true,
                                autoScroll: true,
                                width: 921,
                                frame: true,
                                border: false,
                                id: 'fichaIdentifica',
                                layout: 'form',
                                items:[
                                    {
                                        xtype: 'hidden',
                                        anchor: '100%',
                                        allowBlank: true,
                                        readOnly: true,
                                        id: 'sysIdCodPlantillaHC'
                                    },
                                     {
                                        xtype: 'hidden',
                                        anchor: '100%',
                                        allowBlank: true,
                                        readOnly: true,
                                        value: 1,
                                        id: 'sysUsaGridSalida'
                                    },
                                    {
                                        xtype: 'hidden',
                                        anchor: '100%',
                                        allowBlank: true,
                                        readOnly: true,
                                        style: 'background:transparent;font-size:16px;font-weight:bolder;border:none;color:blue;',
                                        value: 0,
                                        id: 'sysYaGuardoHC'
                                    },
                                    {
                                        xtype: 'hidden',
                                        anchor: '100%',
                                        allowBlank: true,
                                        readOnly: true,
                                        fieldLabel: 'Plantilla',
                                        id: 'sysPlantillaHC',
                                        name: 'PLANTILLA'
                                    },
                                    {
                                        xtype: 'hidden',
                                        anchor: '100%',
                                        allowBlank: true,
                                        readOnly: true,
                                        id: 'sysRutaRptHC'
                                    },
                                    {
                                        xtype: 'hidden',
                                        anchor: '100%',
                                        allowBlank: true,
                                        readOnly: true,
                                        id: 'sysRutaRptMx'
                                    },
                                    {
                                        xtype: 'hidden',
                                        anchor: '100%',
                                        allowBlank: true,
                                        readOnly: true,
                                        id: 'sysRutaRptExa'
                                    },
                                    {
                                        xtype: 'hidden',
                                        anchor: '100%',
                                        allowBlank: true,
                                        readOnly: true,
                                        id: 'sysRutaRptRem'
                                    },
                                    {
                                        xtype: 'textfield',
                                        anchor: '100%',
                                        allowBlank: true,
                                        readOnly: true,
                                        fieldLabel: 'Actividad',
                                        style: 'background:transparent;font-size:16px;font-weight:bolder;border:none;color:blue;',
                                        id: 'sysActividadHC',
                                        name: 'PLANTILLA'
                                    },
                                    {
                                        xtype: 'hidden',
                                        anchor: '100%',
                                        allowBlank: true,
                                        readOnly: true,
                                        fieldLabel: 'Empresa',
                                        id: 'sysEmpresaHC'
                                    },
                                    {
                                        xtype: 'hidden',
                                        anchor: '100%',
                                        allowBlank: true,
                                        readOnly: true,
                                        fieldLabel: 'IPS',
                                        id: 'sysIPSHC'
                                    },
                                    {
                                        xtype: 'hidden',
                                        anchor: '100%',
                                        allowBlank: true,
                                        readOnly: true,
                                        fieldLabel: 'Usuario',
                                        id: 'sysUsuarioHC'
                                    },
                                    {
                                        xtype: 'hidden',
                                        anchor: '100%',
                                        allowBlank: true,
                                        readOnly: true,
                                        fieldLabel: 'Profesional',
                                        id: 'sysProfesionalHC'
                                    },
                                    {
                                        xtype: 'hidden',
                                        anchor: '100%',
                                        allowBlank: true,
                                        readOnly: true,
                                        fieldLabel: 'Paciente',
                                        id: 'sysIdPacienteHC'
                                    },
                                    {
                                        xtype: 'hidden',
                                        anchor: '100%',
                                        allowBlank: true,
                                        readOnly: true,
                                        fieldLabel: 'Apertura',
                                        id: 'sysAperturaHC'
                                    },
                                    {
                                        xtype: 'textfield',
                                        anchor: '100%',
                                        allowBlank: true,
                                        readOnly: true,
                                        fieldLabel: 'Cliente',
                                        id: 'sysClienteHC'
                                    },
                                    {
                                        xtype: 'hidden',
                                        anchor: '100%',
                                        allowBlank: true,
                                        readOnly: true,
                                        fieldLabel: 'Plantilla',
                                        id: 'sysIdClienteHC'
                                    },
                                    {
                                        xtype: 'hidden',
                                        anchor: '100%',
                                        allowBlank: true,
                                        readOnly: true,
                                        fieldLabel: 'Plantilla',
                                        id: 'sysIdPlanHC'
                                    },
                                    {
                                        xtype: 'hidden',
                                        anchor: '100%',
                                        allowBlank: true,
                                        readOnly: true,
                                        fieldLabel: 'Plantilla',
                                        id: 'sysIdSubPlanHC'
                                    },
                                    {
                                        xtype: 'hidden',
                                        anchor: '100%',
                                        allowBlank: true,
                                        readOnly: true,
                                        fieldLabel: 'Plantilla',
                                        id: 'sysIdContratoHC'
                                    },
                                    {
                                        xtype: 'hidden',
                                        anchor: '100%',
                                        allowBlank: true,
                                        readOnly: true,
                                        fieldLabel: 'Genero',
                                        id: 'sysGeneroPacHC'
                                    },
                                    {
                                        xtype: 'hidden',
                                        anchor: '100%',
                                        allowBlank: true,
                                        readOnly: true,
                                        fieldLabel: 'Edad',
                                        id: 'sysEdadPacHC'
                                    },
                                    {
                                        xtype: 'textfield',
                                        anchor: '100%',
                                        allowBlank: true,
                                        readOnly: true,
                                        fieldLabel: 'Profesional',
                                        id: 'sysProfesionalAgendaHC'
                                    },
                                    {
                                        xtype: 'hidden',
                                        anchor: '100%',
                                        allowBlank: true,
                                        readOnly: true,
                                        fieldLabel: 'ConsecutivoDetalle',
                                        id: 'sysConsecutivoDetalleHC'
                                    },
                                    {
                                        xtype: 'compositefield',
                                        style: 'background:transparent;',
                                        items: [
                                            {
                                                xtype: 'textfield',
                                                allowBlank: true,
                                                readOnly: true,
                                                fieldLabel: 'CAS',
                                                id: 'sysCASHC'
                                            },
                                            {
                                                xtype: 'displayfield',
                                                id: 'sysFechaHC',
                                                value: 'Fecha: '
                                            },
                                            {
                                                xtype: 'textfield',
                                                allowBlank: true,
                                                readOnly: true,
                                                id: 'sysFechaHC'
                                            },
                                            {
                                                xtype: 'displayfield',
                                                id: 'sysHoraHC',
                                                value: 'Hora: '
                                            },
                                            {
                                                xtype: 'textfield',
                                                allowBlank: true,
                                                readOnly: true,
                                                id: 'sysHoraHC'
                                            },
                                            {
                                                xtype: 'displayfield',
                                                id: 'sysLegalizacionHC',
                                                value: 'Legalización: '
                                            },
                                            {
                                                xtype: 'textfield',
                                                allowBlank: true,
                                                readOnly: true,
                                                id: 'sysLegalizaHC'
                                            }
                                        ]
                                    },
                                    {
                                        xtype: 'textfield',
                                        anchor: '100%',
                                        allowBlank: true,
                                        readOnly: true,
                                        fieldLabel: 'Paciente',
                                        value: 'CC 792558261  - JORGE GALEANO RUIZ - (Masculino) FechaNac: 1973-01-30, Edad 38 Años',
                                        id: 'sysPacienteHC'
                                    },
                                    {
                                        xtype: 'compositefield',
                                        style: 'background:transparent;',
                                        items: [
                                            {
                                                xtype: 'textfield',
                                                width: 100,
                                                allowBlank: true,
                                                readOnly: true,
                                                fieldLabel: 'Genero',
                                                id: 'sysGeneroHC'
                                            },
                                            {
                                                html: 'Fecha Nac:'
                                            },
                                            {
                                                xtype: 'textfield',
                                                width: 100,
                                                allowBlank: true,
                                                readOnly: true,
                                                id: 'sysFechaNac'
                                            },
                                            {
                                                html: 'Edad:'
                                            },
                                            {
                                                xtype: 'textfield',
                                                width: 350,
                                                allowBlank: true,
                                                readOnly: true,
                                                id: 'sysEdadHC'
                                            }
                                        ]
                                    },
                                    {
                                        xtype: 'compositefield',
                                        style: 'background:transparent;',
                                        items: [
                                            {
                                                xtype: 'textfield',
                                                width: 370,
                                                allowBlank: true,
                                                readOnly: true,
                                                fieldLabel: 'Ocupación',
                                                id: 'sysOcupacionHC'
                                            },
                                            {
                                                html: 'Discapacidad:'
                                            },
                                            {
                                                xtype: 'textfield',
                                                width: 370,
                                                allowBlank: true,
                                                readOnly: true,
                                                id: 'sysDiscapacidadHC'
                                            }
                                        ]
                                    },
                                    {
                                        xtype: 'compositefield',
                                        style: 'background:transparent;',
                                        items: [
                                            {
                                                xtype: 'textfield',
                                                width: 370,
                                                allowBlank: true,
                                                readOnly: true,
                                                fieldLabel: 'Estado Civil',
                                                id: 'sysEstadoCivilHC'
                                            },
                                            {
                                                html: 'Escolaridad:'
                                            },
                                            {
                                                xtype: 'textfield',
                                                width: 380,
                                                allowBlank: true,
                                                readOnly: true,
                                                id: 'sysEscolaridadHC'
                                            }
                                        ]
                                    },
                                    {
                                        xtype: 'compositefield',
                                        style: 'background:transparent;',
                                        items: [
                                            {
                                                xtype: 'textfield',
                                                width: 370,
                                                allowBlank: true,
                                                readOnly: true,
                                                fieldLabel: 'Dirección',
                                                id: 'sysDireccionHC'
                                            },
                                            {
                                                html: 'Telefono:'
                                            },
                                            {
                                                xtype: 'textfield',
                                                width: 390,
                                                allowBlank: true,
                                                readOnly: true,
                                                id: 'sysTelefonoHC'
                                            }
                                        ]
                                    },
                                    {
                                        xtype: 'compositefield',
                                        style: 'background:transparent;',
                                        items: [
                                            {
                                                xtype: 'textfield',
                                                width: 380,
                                                allowBlank: true,
                                                readOnly: true,
                                                fieldLabel: 'Etnia',
                                                id: 'sysEtniaHC'
                                            },
                                            {
                                                html: 'Estrato:'
                                            },
                                            {
                                                xtype: 'textfield',
                                                width: 390,
                                                allowBlank: true,
                                                readOnly: true,
                                                id: 'sysEstratoHC'
                                            }
                                        ]
                                    },
                                    {
                                        html: '<hr>',
                                        style: 'background:transparent;',
                                        border: false
                                    }
                                ]
                            },
                            {
                                xtype: 'panel',
                                title: 'Evolución',
                                autoHeight: true,
                                autoScroll: true,
                                width: 921,
                                frame: true,
                                border: false,
                                id: 'fichaEvolucion',
                                layout: 'form',
                                items: [
                                    {
                                        xtype: 'form',
                                        frame: true,
                                        anchor: '100%',
                                        id: 'frmHC',
                                        padding: 10,
                                        border: false,
                                        autoScroll: true,
                                        style: 'background:transparent;',
                                        items: [
                                            {
                                                xtype: 'compositefield',
                                                style: 'background:transparent;',
                                                items: [
                                                    {
                                                        xtype: 'textfield',
                                                        fieldLabel: 'Destino',
                                                        name: 'Destino',
                                                        width: 300,
                                                        allowBlank: true,
                                                        id: 'strDestino'
                                                    },
                                                    {
                                                        html: ' - Tiempo de Llegada:'
                                                    },
                                                    {
                                                        xtype: 'textfield',
                                                        name: 'Tiempo de LLegada',
                                                        width: 300,
                                                        allowBlank: true,
                                                        id: 'strTiempoLLegada'
                                                    },
                                                    {
                                                        html: ' - Nro Paca:'
                                                    },
                                                    {
                                                        xtype: 'textfield',
                                                        name: 'Nro de Placa del Vehiculo',
                                                        width: 300,
                                                        allowBlank: true,
                                                        id: 'strNroPlaca'
                                                    }
                                                ]
                                            },
                                            {           
                                                xtype: 'panel',
                                                layout: 'form',
                                                autoHeight: true,
                                                anchor: '100%',
                                                padding: 5,
                                                title: 'ANTECEDENTES PERSONALES',
                                                items:[
                                                    {
                                                        xtype: 'panel',
                                                        autoHeight: true,
                                                        width: 840,
                                                        layout: {
                                                            columns: 2,
                                                            type: 'table'
                                                        },
                                                        items: [
                                                            {           
                                                                xtype: 'panel',
                                                                layout: 'form',
                                                                autoHeight: true,
                                                                width: 410,
                                                                padding: 5,
                                                                items:[
                                                                    {
                                                                        xtype: 'combo',
                                                                        fieldLabel: 'Diabetes',
                                                                        name: 'Diabetes',
                                                                        width: 60,
                                                                        allowBlank: false,
                                                                        store: 'StoreSiNo',
                                                                        valueField: 'Descripcion',
                                                                        displayField: 'Descripcion',
                                                                        mode: 'local',
                                                                        forceSelection: true,
                                                                        typeAhead: true,
                                                                        typeAheadDelay: 10,
                                                                        triggerAction: 'all',
                                                                        value: 'NO',
                                                                        id: 'strAP_Diabetes'
                                                                    },
                                                                    {
                                                                        xtype: 'combo',
                                                                        fieldLabel: 'Hipertension',
                                                                        name: 'Hipertension',
                                                                        width: 60,
                                                                        allowBlank: false,
                                                                        store: 'StoreSiNo',
                                                                        valueField: 'Descripcion',
                                                                        displayField: 'Descripcion',
                                                                        mode: 'local',
                                                                        forceSelection: true,
                                                                        typeAhead: true,
                                                                        typeAheadDelay: 10,
                                                                        triggerAction: 'all',
                                                                        value: 'NO',
                                                                        id: 'strAP_Hipertension'
                                                                    },
                                                                    {
                                                                        xtype: 'combo',
                                                                        fieldLabel: 'Colesterol Alto',
                                                                        name: 'Colesterol Alto',
                                                                        width: 60,
                                                                        allowBlank: true,
                                                                        store: 'StoreSiNo',
                                                                        valueField: 'Descripcion',
                                                                        displayField: 'Descripcion',
                                                                        mode: 'local',
                                                                        forceSelection: true,
                                                                        typeAhead: true,
                                                                        typeAheadDelay: 10,
                                                                        triggerAction: 'all',
                                                                        value: 'NO',
                                                                        id: 'strAP_ColesterolAlto'
                                                                    },
                                                                    {
                                                                        xtype: 'combo',
                                                                        fieldLabel: 'Trigliceridos Altos',
                                                                        name: 'Trigliceridos Altos',
                                                                        width: 60,
                                                                        allowBlank: true,
                                                                        store: 'StoreSiNo',
                                                                        valueField: 'Descripcion',
                                                                        displayField: 'Descripcion',
                                                                        mode: 'local',
                                                                        forceSelection: true,
                                                                        typeAhead: true,
                                                                        typeAheadDelay: 10,
                                                                        triggerAction: 'all',
                                                                        value: 'NO',
                                                                        id: 'strAP_TrigliceridosAltos'
                                                                    },
                                                                    {
                                                                        xtype: 'combo',
                                                                        fieldLabel: 'Alteraciones Visuales',
                                                                        name: 'Alteraciones Visuales',
                                                                        width: 60,
                                                                        allowBlank: true,
                                                                        store: 'StoreSiNo',
                                                                        valueField: 'Descripcion',
                                                                        displayField: 'Descripcion',
                                                                        mode: 'local',
                                                                        forceSelection: true,
                                                                        typeAhead: true,
                                                                        typeAheadDelay: 10,
                                                                        triggerAction: 'all',
                                                                        value: 'NO',
                                                                        id: 'strAP_AlteracionesVisuales'
                                                                    }
                                                                ]
                                                            },
                                                            {           
                                                                xtype: 'panel',
                                                                layout: 'form',
                                                                autoHeight: true,
                                                                width: 410,
                                                                padding: 5,
                                                                items:[
                                                                    {
                                                                        xtype: 'combo',
                                                                        fieldLabel: 'Alteraciones Auditivas',
                                                                        name: 'Alteraciones Auditivas',
                                                                        width: 60,
                                                                        allowBlank: true,
                                                                        store: 'StoreSiNo',
                                                                        valueField: 'Descripcion',
                                                                        displayField: 'Descripcion',
                                                                        mode: 'local',
                                                                        forceSelection: true,
                                                                        typeAhead: true,
                                                                        typeAheadDelay: 10,
                                                                        triggerAction: 'all',
                                                                        value: 'NO',
                                                                        id: 'strAP_AlteracionesAuditivas'
                                                                    },
                                                                    {
                                                                        xtype: 'combo',
                                                                        fieldLabel: 'Limitaciones Motoras',
                                                                        name: 'Limitaciones Motoras',
                                                                        width: 60,
                                                                        allowBlank: true,
                                                                        store: 'StoreSiNo',
                                                                        valueField: 'Descripcion',
                                                                        displayField: 'Descripcion',
                                                                        mode: 'local',
                                                                        forceSelection: true,
                                                                        typeAhead: true,
                                                                        typeAheadDelay: 10,
                                                                        triggerAction: 'all',
                                                                        value: 'NO',
                                                                        id: 'strAP_LimitacionesMotoras'
                                                                    },
                                                                    {
                                                                        xtype: 'combo',
                                                                        fieldLabel: 'Limitaciones Neurologicas',
                                                                        name: 'Limitaciones Neurologicas',
                                                                        width: 60,
                                                                        allowBlank: true,
                                                                        store: 'StoreSiNo',
                                                                        valueField: 'Descripcion',
                                                                        displayField: 'Descripcion',
                                                                        mode: 'local',
                                                                        forceSelection: true,
                                                                        typeAhead: true,
                                                                        typeAheadDelay: 10,
                                                                        triggerAction: 'all',
                                                                        value: 'NO',
                                                                        id: 'strAP_LimitacionesNeurologicas'
                                                                    },
                                                                    {
                                                                        xtype: 'combo',
                                                                        fieldLabel: 'Toma Medicamentos',
                                                                        name: 'Toma Medicamentos',
                                                                        width: 60,
                                                                        allowBlank: true,
                                                                        store: 'StoreSiNo',
                                                                        valueField: 'Descripcion',
                                                                        displayField: 'Descripcion',
                                                                        mode: 'local',
                                                                        forceSelection: true,
                                                                        typeAhead: true,
                                                                        typeAheadDelay: 10,
                                                                        triggerAction: 'all',
                                                                        value: 'NO',
                                                                        id: 'strAP_TomaMedicamentos'
                                                                    }
                                                                ]
                                                            }
                                                        ]
                                                    },
                                                    {
                                                        xtype: 'textarea',
                                                        fieldLabel: 'Otros',
                                                        name: 'Otros',
                                                        width: 820,
                                                        id: 'memAP_Otros'
                                                    }
                                                ]
                                            },
                                            {
                                                xtype: 'fieldset',
                                                title: 'TIEMPOS DE CONDUCCION',
                                                layout: 'form',
                                                collapseFirst: false,
                                                collapsible: true,
                                                animCollapse: true,
                                                titleCollapse: true,
                                                anchor: '100%',
                                                autoHeight: true,
                                                padding: 7,
                                                labelWidth: 170,
                                                items: [
                                                    {
                                                        xtype: 'textfield',
                                                        width: 120,
                                                        fieldLabel: 'Previo a la labor',
                                                        name: 'Previo a la labor - Tiempos de Conduccion',
                                                        emptyText: 'Horas',
                                                        allowBlank: false,
                                                        id: 'strTiempoConduccionPrevioLabor'
                                                    },
                                                    {
                                                        xtype: 'textfield',
                                                        width: 120,
                                                        fieldLabel: 'Espera en los destinos intermedios',
                                                        name: 'Espera en los destinos intermedios - Tiempos de Conduccion',
                                                        emptyText: 'Horas',
                                                        allowBlank: false,
                                                        id: 'strTiempoConduccionDestinosIntermedios'
                                                    },
                                                    {
                                                        xtype: 'textfield',
                                                        width: 120,
                                                        fieldLabel: 'Tiempo de descanso previo a la realizacion de labores (sueño efectivo)',
                                                        name: 'Tiempo de descanso previo a la realizacion de labores (sueño efectivo) - Tiempos de Conduccion',
                                                        emptyText: 'Horas',
                                                        allowBlank: false,
                                                        id: 'strTiempoConduccionDescansoPrevio'
                                                    }
                                                ]
                                            },
                                            {
                                                xtype: 'fieldset',
                                                title: 'SINTOMAS DE FATIGA',
                                                layout: 'form',
                                                collapseFirst: false,
                                                collapsible: true,
                                                animCollapse: true,
                                                titleCollapse: true,
                                                anchor: '100%',
                                                autoHeight: true,
                                                padding: 7,
                                                items:[
                                                    {
                                                        xtype: 'combo',
                                                        fieldLabel: 'Sed',
                                                        name: 'Sed',
                                                        width: 60,
                                                        allowBlank: false,
                                                        store: 'StoreSiNo',
                                                        valueField: 'Descripcion',
                                                        displayField: 'Descripcion',
                                                        mode: 'local',
                                                        forceSelection: true,
                                                        typeAhead: true,
                                                        typeAheadDelay: 10,
                                                        triggerAction: 'all',
                                                        id: 'strSintomasFatigaSed'
                                                    },
                                                    {
                                                        xtype: 'combo',
                                                        fieldLabel: 'Hambre',
                                                        name: 'Hambre',
                                                        width: 60,
                                                        allowBlank: false,
                                                        store: 'StoreSiNo',
                                                        valueField: 'Descripcion',
                                                        displayField: 'Descripcion',
                                                        mode: 'local',
                                                        forceSelection: true,
                                                        typeAhead: true,
                                                        typeAheadDelay: 10,
                                                        triggerAction: 'all',
                                                        id: 'strSintomasFatigaHambre'
                                                    },
                                                    {
                                                        xtype: 'combo',
                                                        fieldLabel: 'Sueño',
                                                        name: 'Sueño',
                                                        width: 60,
                                                        allowBlank: false,
                                                        store: 'StoreSiNo',
                                                        valueField: 'Descripcion',
                                                        displayField: 'Descripcion',
                                                        mode: 'local',
                                                        forceSelection: true,
                                                        typeAhead: true,
                                                        typeAheadDelay: 10,
                                                        triggerAction: 'all',
                                                        id: 'strSintomasFatigaSueno'
                                                    },
                                                    {
                                                        xtype: 'combo',
                                                        fieldLabel: 'Temblor Distal',
                                                        name: 'Temblor Distal',
                                                        width: 60,
                                                        allowBlank: false,
                                                        store: 'StoreSiNo',
                                                        valueField: 'Descripcion',
                                                        displayField: 'Descripcion',
                                                        mode: 'local',
                                                        forceSelection: true,
                                                        typeAhead: true,
                                                        typeAheadDelay: 10,
                                                        triggerAction: 'all',
                                                        id: 'strSintomasFatigaTemblorDistal'
                                                    }
                                                ]
                                            },
                                            {
                                                xtype: 'fieldset',
                                                title: 'SIGNOS DE FATIGA',
                                                layout: 'form',
                                                collapseFirst: false,
                                                collapsible: true,
                                                animCollapse: true,
                                                titleCollapse: true,
                                                anchor: '100%',
                                                autoHeight: true,
                                                padding: 7,
                                                items: [
                                                    {
                                                        xtype: 'compositefield',
                                                        style: 'background:transparent;',
                                                        items: [
                                                            {
                                                                xtype: 'numberfield',
                                                                fieldLabel: 'T.A.',
                                                                name: 'T.A. Sistolica',
                                                                width: 70,
                                                                minValue: 0,
                                                                maxValue: 300,
                                                                decimalPrecision: 0,
                                                                allowBlank: false,
                                                                id: 'intEXAFISTASistolica'
                                                            },
                                                            {
                                                                html: '/'
                                                            },
                                                            {
                                                                xtype: 'numberfield',
                                                                name: 'T.A. Diastolica',
                                                                width: 70,
                                                                minValue: 0,
                                                                maxValue: 300,
                                                                decimalPrecision: 0,
                                                                allowBlank: false,
                                                                id: 'intEXAFISTADiastolica'
                                                            },
                                                            {
                                                                html: 'F.C.'
                                                            },                                                            
                                                            {
                                                                xtype: 'numberfield',
                                                                width: 60,
                                                                minValue: 0,
                                                                decimalPrecision: 2,
                                                                name: 'FC',
                                                                allowBlank: false,
                                                                id: 'intEXAFISFC'
                                                            },
                                                            {
                                                                html: 'F.R.'
                                                            },                                                            
                                                            {
                                                                xtype: 'numberfield',
                                                                width: 60,
                                                                minValue: 0,
                                                                decimalPrecision: 2,
                                                                name: 'FR',
                                                                allowBlank: false,
                                                                id: 'intEXAFISFR'
                                                            },
                                                            {
                                                                html: 'Talla'
                                                            },   
                                                            {
                                                                xtype: 'numberfield',
                                                                width: 60,
                                                                minValue: 0,
                                                                maxValue: 250,
                                                                decimalPrecision: 2,
                                                                allowBlank: false,
                                                                name:"TALLA (cm)",
                                                                emptyText: '(cm)',
                                                                id: 'intEXAFISTalla'
                                                            },
                                                            {
                                                                html: 'Peso'
                                                            },   
                                                            {
                                                                xtype: 'numberfield',
                                                                width: 60,
                                                                minValue: 0,
                                                                maxValue: 250,
                                                                decimalPrecision: 2,
                                                                allowBlank: false,
                                                                emptyText: '(Kg)',
                                                                name:"PESO (Kg)",
                                                                id: 'intEXAFISPeso'
                                                            }
                                                        ]
                                                    },
                                                    {
                                                        html: '<hr>Signos Fisicos<hr>'
                                                    },
                                                    {
                                                        xtype: 'combo',
                                                        fieldLabel: 'Ojos Rojos',
                                                        name: 'Ojos Rojos',
                                                        width: 60,
                                                        allowBlank: false,
                                                        store: 'StoreSiNo',
                                                        valueField: 'Descripcion',
                                                        displayField: 'Descripcion',
                                                        mode: 'local',
                                                        forceSelection: true,
                                                        typeAhead: true,
                                                        typeAheadDelay: 10,
                                                        triggerAction: 'all',
                                                        id: 'strSignosFatigaOjosRojos'
                                                    },
                                                    {
                                                        xtype: 'combo',
                                                        fieldLabel: 'Boca Seca',
                                                        name: 'Boca Seca',
                                                        width: 60,
                                                        allowBlank: false,
                                                        store: 'StoreSiNo',
                                                        valueField: 'Descripcion',
                                                        displayField: 'Descripcion',
                                                        mode: 'local',
                                                        forceSelection: true,
                                                        typeAhead: true,
                                                        typeAheadDelay: 10,
                                                        triggerAction: 'all',
                                                        id: 'strSignosFatigaBocaSeca'
                                                    },
                                                    {
                                                        xtype: 'combo',
                                                        fieldLabel: 'Frialdad Distal',
                                                        name: 'Frialdad Distal',
                                                        width: 60,
                                                        allowBlank: false,
                                                        store: 'StoreSiNo',
                                                        valueField: 'Descripcion',
                                                        displayField: 'Descripcion',
                                                        mode: 'local',
                                                        forceSelection: true,
                                                        typeAhead: true,
                                                        typeAheadDelay: 10,
                                                        triggerAction: 'all',
                                                        id: 'strSignosFatigaFrialdadDistal'
                                                    },
                                                    {
                                                        xtype: 'combo',
                                                        fieldLabel: 'Sudoracion',
                                                        name: 'Sudoracion',
                                                        width: 60,
                                                        allowBlank: false,
                                                        store: 'StoreSiNo',
                                                        valueField: 'Descripcion',
                                                        displayField: 'Descripcion',
                                                        mode: 'local',
                                                        forceSelection: true,
                                                        typeAhead: true,
                                                        typeAheadDelay: 10,
                                                        triggerAction: 'all',
                                                        id: 'strSignosFatigaSudoracion'
                                                    },
                                                    {
                                                        xtype: 'combo',
                                                        fieldLabel: 'Tinitus',
                                                        name: 'Tinitus',
                                                        width: 60,
                                                        allowBlank: false,
                                                        store: 'StoreSiNo',
                                                        valueField: 'Descripcion',
                                                        displayField: 'Descripcion',
                                                        mode: 'local',
                                                        forceSelection: true,
                                                        typeAhead: true,
                                                        typeAheadDelay: 10,
                                                        triggerAction: 'all',
                                                        id: 'strSignosFatigaTinitus'
                                                    },
                                                    {
                                                        xtype: 'combo',
                                                        fieldLabel: 'Temblor Distal',
                                                        name: 'Temblor Distal',
                                                        width: 60,
                                                        allowBlank: false,
                                                        store: 'StoreSiNo',
                                                        valueField: 'Descripcion',
                                                        displayField: 'Descripcion',
                                                        mode: 'local',
                                                        forceSelection: true,
                                                        typeAhead: true,
                                                        typeAheadDelay: 10,
                                                        triggerAction: 'all',
                                                        id: 'strSignosFatigaTemblorDistal'
                                                    },
                                                    {
                                                        xtype: 'compositefield',
                                                        style: 'background:transparent;',
                                                        items: [
                                                            {
                                                                xtype: 'combo',
                                                                fieldLabel: 'Alteraciones Emocionales',
                                                                name: 'Alteraciones Emocionales',
                                                                width: 60,
                                                                allowBlank: false,
                                                                store: 'StoreSiNo',
                                                                valueField: 'Descripcion',
                                                                displayField: 'Descripcion',
                                                                mode: 'local',
                                                                forceSelection: true,
                                                                typeAhead: true,
                                                                typeAheadDelay: 10,
                                                                triggerAction: 'all',
                                                                id: 'strSignosFatigaAlteracionesEmocionales'
                                                            },
                                                            {
                                                                html: ' - '
                                                            },
                                                            {
                                                                xtype: 'combo',
                                                                name: 'Alteraciones Emocionales',
                                                                width: 260,
                                                                allowBlank: true,
                                                                store: stAlteraEmocional,
                                                                valueField: 'Descripcion',
                                                                displayField: 'Descripcion',
                                                                mode: 'local',
                                                                forceSelection: true,
                                                                typeAhead: true,
                                                                typeAheadDelay: 10,
                                                                triggerAction: 'all',
                                                                id: 'strSignosFatigaAlteracionesAddEmocionales'
                                                            }
                                                        ]
                                                    },
                                                    {
                                                        xtype: 'compositefield',
                                                        style: 'background:transparent;',
                                                        items: [
                                                            {
                                                                xtype: 'combo',
                                                                fieldLabel: 'Alteraciones Neurologicas',
                                                                width: 60,
                                                                allowBlank: false,
                                                                store: 'StoreSiNo',
                                                                valueField: 'Descripcion',
                                                                displayField: 'Descripcion',
                                                                mode: 'local',
                                                                forceSelection: true,
                                                                typeAhead: true,
                                                                typeAheadDelay: 10,
                                                                triggerAction: 'all',
                                                                id: 'strSignosFatigaAlteracionesNeurologicas'
                                                            },
                                                            {
                                                                html: ' - '
                                                            },
                                                            {
                                                                xtype: 'combo',
                                                                name: 'Alteraciones Neurologicas',
                                                                width: 260,
                                                                allowBlank: true,
                                                                store: stAlteraNeurologicas,
                                                                valueField: 'Descripcion',
                                                                displayField: 'Descripcion',
                                                                mode: 'local',
                                                                forceSelection: true,
                                                                typeAhead: true,
                                                                typeAheadDelay: 10,
                                                                triggerAction: 'all',
                                                                id: 'strSignosFatigaAlteracionesAddNeurologicas'
                                                            }
                                                        ]
                                                    }
                                                ]
                                            },
                                            /*{
                                                xtype: 'fieldset',
                                                title: 'EVOLUCION',
                                                layout: 'table',
                                                collapseFirst: false,
                                                collapsible: true,
                                                animCollapse: true,
                                                titleCollapse: true,
                                                anchor: '100%',
                                                autoHeight: true,
                                                padding: 7,
                                                items: [
                                                    {
                                                        xtype: 'textarea',
                                                        anchor: '100%',
                                                        width: 880,
                                                        fieldLabel: 'EVOLUCION',
                                                        name: 'EVOLUCION',
                                                        height: 100,
                                                        allowBlank: false,
                                                        id: 'memEvolucion'
                                                    }
                                                ]
                                            },*/
                                            {
                                                xtype: 'fieldset',
                                                title: 'RECOMENDACIONES',
                                                layout: 'form',
                                                collapseFirst: false,
                                                collapsible: true,
                                                animCollapse: true,
                                                titleCollapse: true,
                                                anchor: '100%',
                                                autoHeight: true,
                                                padding: 7,
                                                items: [
                                                    {
                                                        xtype: 'checkbox',
                                                        fieldLabel: 'Conduccion con revelador',
                                                        name: 'Conduccion con revelador',
                                                        anchor: '100%',
                                                        value: 'false',
                                                        id: 'bolRECOMENConductorRelevador'
                                                    },
                                                    {
                                                        xtype: 'checkbox',
                                                        fieldLabel: 'Ultimo destino (no conducir)',
                                                        name: 'Ultimo destino (no conducir)',
                                                        anchor: '100%',
                                                        value: 'false',
                                                        id: 'bolRECOMENUltimoDestino'
                                                    },
                                                    {
                                                        xtype: 'checkbox',
                                                        fieldLabel: 'Valoracion medica de urgencia',
                                                        name: 'Valoracion medica de urgencia',
                                                        anchor: '100%',
                                                        value: 'false',
                                                        id: 'bolRECOMENValoracionMedicaUrg'
                                                    },
                                                    {
                                                        xtype: 'checkbox',
                                                        fieldLabel: 'Valoracion medica ambulatoria',
                                                        name: 'Valoracion medica ambulatoria',
                                                        anchor: '100%',
                                                        value: 'false',
                                                        id: 'bolRECOMENValoracionMedicaAmbulatoria'
                                                    },
                                                    {
                                                        xtype: 'checkbox',
                                                        fieldLabel: 'Registro seriado de tension arterial',
                                                        name: 'Registro seriado de tension arterial',
                                                        anchor: '100%',
                                                        value: 'false',
                                                        id: 'bolRECOMENRegistroSeriadotensionArterial'
                                                    },
                                                    {
                                                        xtype: 'checkbox',
                                                        fieldLabel: 'Nutricionales',
                                                        name: 'Nutricionales',
                                                        anchor: '100%',
                                                        value: 'false',
                                                        id: 'bolRECOMENNutricionales'
                                                    }
                                                ]
                                            },
                                            {
                                                xtype: 'fieldset',
                                                title: 'CONDUCTA',
                                                layout: 'table',
                                                collapseFirst: false,
                                                collapsible: true,
                                                animCollapse: true,
                                                titleCollapse: true,
                                                anchor: '100%',
                                                autoHeight: true,
                                                padding: 7,
                                                items: [
                                                    {
                                                        xtype: 'textarea',
                                                        anchor: '100%',
                                                        width: 880,
                                                        fieldLabel: 'CONDUCTA',
                                                        name: 'CONDUCTA',
                                                        height: 100,
                                                        allowBlank: false,
                                                        id: 'memConducta'
                                                    }
                                                ]
                                            },
                                            {
                                                xtype: 'fieldset',
                                                title: 'INFORMACION PROXIMA CITA',
                                                layout: 'form',
                                                collapseFirst: false,
                                                collapsible: true,
                                                animCollapse: true,
                                                titleCollapse: true,
                                                anchor: '100%',
                                                autoHeight: true,
                                                padding: 5,
                                                items: [
                                                    {
                                                        xtype: 'combo',
                                                        name: 'Proxima Cita',
                                                        width: 250,
                                                        allowBlank: true,
                                                        store: stProximaCita,
                                                        valueField: 'Descripcion',
                                                        displayField: 'Descripcion',
                                                        mode: 'local',
                                                        forceSelection: true,
                                                        typeAhead: true,
                                                        typeAheadDelay: 10,
                                                        triggerAction: 'all',
                                                        id: 'strProximaCita'
                                                    },
                                                    {
                                                        xtype: 'textarea',
                                                        anchor: '100%',
                                                        width: 880,
                                                        fieldLabel: 'Observacion',
                                                        name: 'Observacion',
                                                        height: 100,
                                                        allowBlank: true,
                                                        id: 'memProximaCitaObservacion'
                                                    }
                                                ]
                                            },
                                            fsDiagnosticosConsulta
                                        ]
                                    }
                                ]
                            },
                            {
                                xtype: 'panel',
                                title: 'Solicitud Medicamentos',
                                height: 355,
                                width: 921,
                                frame: true,
                                border: false,
                                id: 'fichaMedicamentos',
                                items: [
                                    xSolMX
                                ]
                            },
                            {
                                xtype: 'panel',
                                title: 'Solicitud Servicios',
                                height: 355,
                                width: 921,
                                frame: true,
                                border: false,
                                id: 'fichaServicios',
                                items: [
                                    xSolEXA
                                ]
                            },
                            {
                                xtype: 'panel',
                                title: 'Solicitud Remisiones',
                                height: 355,
                                width: 921,
                                frame: true,
                                border: false,
                                id: 'fichaRemisiones',
                                items: [
                                    xSolREM
                                ]
                            }
                            /*,
                            {
                                xtype: 'panel',
                                title: 'Solicitud CTC',
                                height: 355,
                                width: 921,
                                frame: true,
                                border: false,
                                id: 'fichaCTC',
                                items: [
                                ]
                            },
                            {
                                xtype: 'panel',
                                title: 'Consentimientos Informados',
                                height: 355,
                                width: 921,
                                frame: true,
                                border: false,
                                id: 'fichaConsentimientos',
                                items: [
                                ]
                            },*/
                        ]
                    }
                ],
                bbar:{
                    items: [
                        {
                            xtype: 'tbfill'
                        },
                        {
                            xtype: 'tbseparator'
                        },
                        {
                            xtype: 'button',
                            text: 'Salir',
                            iconCls: 'btnSalir',
                            id: 'btnSalirEvolucion',
                            listeners:{
                                click : function(){
                                    if (Ext.getCmp('sysYaGuardoHC').getValue() == 1)
                                        Ext.Msg.show({
                                            title: 'eOfiClinic',
                                            msg: 'Esta seguro que desea cerrar la ventana?',
                                            buttons: Ext.Msg.YESNO,
                                            icon: Ext.Msg.QUESTION,
                                            fn: function(btn)
                                            {
                                                if(btn=="yes")
                                                {
                                                    Ext.getCmp('gridFormulario').store.reload();
                                                    Ext.getCmp('winHC').close();
                                                }
                                            }
                                        });
                                    else{
                                        Ext.Msg.show({
                                            title: 'eOfiClinic',
                                            msg: 'Usted No ha Guardado la Evolución del Paciente y Se Perdera la Información, Esta seguro que desea cerrar la ventana?',
                                            buttons: Ext.Msg.YESNO,
                                            icon: Ext.Msg.QUESTION,
                                            fn: function(btn)
                                            {
                                                if(btn=="yes")
                                                {
                                                    Ext.getCmp('gridFormulario').store.reload();
                                                    Ext.getCmp('winHC').close();
                                                }
                                            }
                                        });
                                    }
                                }
                            }
                        }
                    ]
                },
                tbar:{
                    items: [
                        {
                            xtype: 'tbseparator'
                        },
                        {
                            xtype: 'button',
                            text: 'Ver Historia Clínica',
                            iconCls: 'btnVerHC',
                            id: 'btnVerHC',
                            listeners:{
                                click : function(){
                                    var cmpResumenHC = new winFrmVerHistorialHC({
                                        renderTo: Ext.getBody()
                                    });
                                    Ext.getCmp('winViewEvolucionHC').title = "PACIENTE: " + Ext.getCmp('sysPacienteHC').getValue();
                                    Ext.getCmp('gridHistorialEvoluciones').store.load({
                                        params: {
                                            pEmpresa: Ext.getCmp('sysEmpresaHC').getValue(),
                                            pPaciente: Ext.getCmp('sysIdPacienteHC').getValue()
                                        }
                                    });
                                    cmpResumenHC.show();
                                }
                            }
                        },
                        {
                            xtype: 'tbfill'
                        },
                        {
                            xtype: 'tbseparator'
                        },
                        {
                            xtype: 'button',
                            text: 'Guardar Evolución',
                            iconCls: 'btnGuardar',
                            id: 'btnGuardarEvolucion',
                            listeners:{
                                click : function(){
                                    if (Ext.getCmp('sysYaGuardoHC').getValue() == 0)
                                    {
                                        Ext.Msg.show({
                                            title: 'eOfiClinic',
                                            msg: 'Esta seguro que desea Guardar la evolución?',
                                            buttons: Ext.Msg.YESNO,
                                            icon: Ext.Msg.QUESTION,
                                            fn: function(btn)
                                            {
                                                if(btn=="yes")
                                                {
                                                    fnGuardarRegistrosMedicinaGeneral();
                                                }
                                            }
                                        });
                                    }else{
                                        Ext.Msg.show({
                                            title: 'eOfiClinic',
                                            msg: 'Esta seguro que desea Modificar la evolución?',
                                            buttons: Ext.Msg.YESNO,
                                            icon: Ext.Msg.QUESTION,
                                            fn: function(btn)
                                            {
                                                if(btn=="yes")
                                                {
                                                    fnModificarRegistrosMedicinaGeneral();
                                                }
                                            }
                                        });
                                    }
                                }
                            }
                        }
                    ]
                }
            }
        ];
        winHCMedicinaBasica002Ui.superclass.initComponent.call(this);
    }
});

function fnGuardarRegistrosMedicinaGeneral(){
    var frm = Ext.getCmp('frmHC').getForm();
    if (frm.isValid())
    {
        var listacampos = ExtraerCamposFrmHC(frm);
        frm.submit({
            url: '../../controlador/asistencial/evolucionhc.php',
            params:{
                task: 'guardar',
                CAMPOS: listacampos,
                pEmpresa: Ext.getCmp('sysEmpresaHC').getValue(),
                pIPS: Ext.getCmp('sysIPSHC').getValue(),
                pPaciente: Ext.getCmp('sysIdPacienteHC').getValue(),
                pProfesional: Ext.getCmp('sysProfesionalHC').getValue(),
                pCAS: Ext.getCmp('sysCASHC').getValue(),
                pidPlantillaHC : Ext.getCmp('sysIdCodPlantillaHC').getValue(),
                pFechaAtencion: Ext.getCmp('sysFechaHC').getValue(),
                pHoraApertura: Ext.getCmp('sysAperturaHC').getValue(),
                pActividad: Ext.getCmp('sysActividadHC').getValue(),
                pPlantilla: Ext.getCmp('sysPlantillaHC').getValue(),
                pRutaRptHC: Ext.getCmp('sysRutaRptHC').getValue(),
                pRutaRptMx: Ext.getCmp('sysRutaRptMx').getValue(),
                pRutaRptExa: Ext.getCmp('sysRutaRptExa').getValue(),
                pRutaRptRem: Ext.getCmp('sysRutaRptRem').getValue(),
                pDiagppal: Ext.getCmp('sysDiagPpalHC').getValue(),
                pDiagrel1: Ext.getCmp('sysDiagRel1HC').getValue(),
                pDiagrel2: Ext.getCmp('sysDiagRel2HC').getValue(),
                pDiagrel3: Ext.getCmp('sysDiagRel3HC').getValue(),
                pTipodiag: Ext.getCmp('sysTipoDiagosticoHC').getValue(),
                pFinalidad: Ext.getCmp('sysFinalidadConsultaHC').getValue(),
                pCausa: Ext.getCmp('sysCausaExternaHC').getValue(),
                pUsuario: Ext.getCmp('sysUsuarioHC').getValue(),
                pIdCliente: Ext.getCmp('sysIdClienteHC').getValue(),
                pIdPlan: Ext.getCmp('sysIdPlanHC').getValue(),
                pIdSubPlan: Ext.getCmp('sysIdSubPlanHC').getValue(),
                pIdContrato: Ext.getCmp('sysIdContratoHC').getValue(),
                pConsecutivoDetalle: Ext.getCmp('sysConsecutivoDetalleHC').getValue()
            },
            success: function(res,req)
            {
                switch(req.result.requestedId){
                    case "1":
                        Ext.MessageBox.show({
                            title: 'Guardar',
                            msg: 'Se Guardo la Información con Exito.',
                            buttons: Ext.MessageBox.OK,
                            icon: Ext.MessageBox.INFO
                        });
                        Ext.getCmp('sysYaGuardoHC').setValue(1);
                        break;

                    default:
                        Ext.MessageBox.show({
                            title: 'Guardar',
                            msg: 'Ocurrio un error al guardar, la llave principal no es valida o no se pudo establecer conexión con el servidor.',
                            buttons: Ext.MessageBox.OK,
                            icon: Ext.MessageBox.ERROR
                        });
                        break;
                }
            },
            failure: function(response,options)
            {
                Ext.MessageBox.show({
                    title: 'Guardar',
                    msg: 'Ocurrio un error al guardar o no se pudo establecer conexión con el servidor.',
                    buttons: Ext.MessageBox.OK,
                    icon: Ext.MessageBox.ERROR
                });
            }
        });
    }else{
        Ext.MessageBox.show({
            title: 'Guardar',
            msg: 'Por favor verifique que todos los campos obligatorios estén diligenciados.',
            buttons: Ext.MessageBox.OK,
            icon: Ext.MessageBox.ERROR
        });
    }
}

function fnModificarRegistrosMedicinaGeneral(){
    var frm = Ext.getCmp('frmHC').getForm();
    if (frm.isValid())
    {
        var listacampos = ExtraerCamposFrmHC(frm);
        frm.submit({
            url: '../../controlador/asistencial/evolucionhc.php',
            params:{
                task: 'modificar',
                CAMPOS: listacampos,
                pEmpresa: Ext.getCmp('sysEmpresaHC').getValue(),
                pIPS: Ext.getCmp('sysIPSHC').getValue(),
                pPaciente: Ext.getCmp('sysIdPacienteHC').getValue(),
                pProfesional: Ext.getCmp('sysProfesionalHC').getValue(),
                pCAS: Ext.getCmp('sysCASHC').getValue(),
                pFechaAtencion: Ext.getCmp('sysFechaHC').getValue(),
                pHoraApertura: Ext.getCmp('sysAperturaHC').getValue(),
                pActividad: Ext.getCmp('sysActividadHC').getValue(),
                pPlantilla: Ext.getCmp('sysPlantillaHC').getValue(),
                pRutaRptHC: Ext.getCmp('sysRutaRptHC').getValue(),
                pRutaRptMx: Ext.getCmp('sysRutaRptMx').getValue(),
                pRutaRptExa: Ext.getCmp('sysRutaRptExa').getValue(),
                pRutaRptRem: Ext.getCmp('sysRutaRptRem').getValue(),
                pDiagppal: Ext.getCmp('sysDiagPpalHC').getValue(),
                pDiagrel1: Ext.getCmp('sysDiagRel1HC').getValue(),
                pDiagrel2: Ext.getCmp('sysDiagRel2HC').getValue(),
                pDiagrel3: Ext.getCmp('sysDiagRel3HC').getValue(),
                pTipodiag: Ext.getCmp('sysTipoDiagosticoHC').getValue(),
                pFinalidad: Ext.getCmp('sysFinalidadConsultaHC').getValue(),
                pCausa: Ext.getCmp('sysCausaExternaHC').getValue(),
                pUsuario: Ext.getCmp('sysUsuarioHC').getValue(),
                pIdCliente: Ext.getCmp('sysIdClienteHC').getValue(),
                pIdPlan: Ext.getCmp('sysIdPlanHC').getValue(),
                pIdSubPlan: Ext.getCmp('sysIdSubPlanHC').getValue(),
                pIdContrato: Ext.getCmp('sysIdContratoHC').getValue(),
                pConsecutivoDetalle: Ext.getCmp('sysConsecutivoDetalleHC').getValue()
            },
            success: function(res,req)
            {
                switch(req.result.requestedId){
                    case "1":
                        Ext.MessageBox.show({
                            title: 'Guardar',
                            msg: 'Se Guardo la Información con Exito.',
                            buttons: Ext.MessageBox.OK,
                            icon: Ext.MessageBox.INFO
                        });
                        Ext.getCmp('sysYaGuardoHC').setValue(1);
                        break;

                    default:
                        Ext.MessageBox.show({
                            title: 'Guardar',
                            msg: 'Ocurrio un error al guardar, la llave principal no es valida o no se pudo establecer conexión con el servidor.',
                            buttons: Ext.MessageBox.OK,
                            icon: Ext.MessageBox.ERROR
                        });
                        break;
                }
            },
            failure: function(response,options)
            {
                Ext.MessageBox.show({
                    title: 'Guardar',
                    msg: 'Ocurrio un error al guardar o no se pudo establecer conexión con el servidor.',
                    buttons: Ext.MessageBox.OK,
                    icon: Ext.MessageBox.ERROR
                });
            }
        });
    }else{
        Ext.MessageBox.show({
            title: 'Guardar',
            msg: 'Por favor verifique que todos los campos obligatorios estén diligenciados.',
            buttons: Ext.MessageBox.OK,
            icon: Ext.MessageBox.ERROR
        });
    }
}
