/*
* @category    Formulario Modelo Evolucion Historia Clinica Control Consumo Alcohol y Sustancias Psicoactivas
* @package     OfiClinic Web
* @author      Jorge Ancizar Galeano Ruiz<desarrollo@ofisalud.com>
* @copyright   2010 Jorge Ancizar Galeano Ruiz
* @version     OfiClinic Web 1.0
* @license     COMERCIAL
* @link        http://www.ofisalud.com
* @country     Colombia
* @telephone   3016398114
*/


winHCConrolAlcoholSpa001Ui = Ext.extend(Ext.Window, {
    title: 'eOfiClinic ©  .:: Plantilla HC - Conrol Consumo Alcohol y Sustancias Psicoactivas ::.',
    width: 990,
    height: 636,
    closable: false,
    resizable: false,
    draggable: false,
    modal: true,
    id: 'winHC',
    initComponent: function() {
        
        tmpmx = objMX;
        tmpmxadd = objMXADD;
        tmpexa = objEXA;
        tmprem = objREM;
        myPaciente = 0;
        myCAS = 0;
        
        try {
            var campo = Ext.getCmp('sysPacientePlantillaHC');
            if ( campo != null ) {
                myPaciente = Ext.getCmp('sysPacientePlantillaHC').getValue();
            }
        }catch(ex){
        }
        if(myPaciente == 0){
            try {
                var campo1 = Ext.getCmp('sysIdPacienteHC');
                if ( campo1 != null ) {
                    myPaciente = Ext.getCmp('sysIdPacienteHC').getValue();
                }
            }catch(ex){
            }
        }
        if(myPaciente == 0){
            try {
                var campo5 = Ext.getCmp('sysPacienteRefHC');
                if ( campo5 != null ) {
                    myPaciente = Ext.getCmp('sysPacienteRefHC').getValue();
                }
            }catch(ex){
            }
        }
        try {
            var campo2 = Ext.getCmp('sysCASPlantillaHC');
            if ( campo2 != null ) {
                myCAS = Ext.getCmp('sysCASPlantillaHC').getValue();
            }
        }catch(ex){
        }
        if(myCAS == 0){
            try {
                var campo3 = Ext.getCmp('sysCASHC');
                if ( campo3 != null ) {
                    myCAS = Ext.getCmp('sysCASHC').getValue();
                }
            }catch(ex){
            }
        }
        if(myCAS == 0){
            try {
                var campo4 = Ext.getCmp('sysCASRefHC');
                if ( campo4 != null ) {
                    myCAS = Ext.getCmp('sysCASRefHC').getValue();
                }
            }catch(ex){
            }
        }
        if (objMX != "NA"){
            var xSolMX = eval(objMX);
            Ext.getCmp('gridMedicamentosHC').store.load({
                params: {
                    pEmpresa: ID_EMPRESA,
                    pIPS: ID_IPS,
                    pPaciente: myPaciente,
                    pCAS: myCAS
                }
            });
        }
        else{
            var xSolMX = Ext.extend(Ext.form.Hidden, {
                initComponent: function() {
                    MyHiddenFieldUi.superclass.initComponent.call(this);
                }
            });
        }
        if (objEXA != "NA"){
            var xSolEXA = eval(objEXA);
            Ext.getCmp('gridExamenesHC').store.load({
                params: {
                    pEmpresa: ID_EMPRESA,
                    pIPS: ID_IPS,
                    pPaciente: myPaciente,
                    pCAS: myCAS
                }
            });
        }else{
            var xSolEXA = Ext.extend(Ext.form.Hidden, {
                initComponent: function() {
                    MyHiddenFieldUi.superclass.initComponent.call(this);
                }
            });
        }    
        if (objREM != "NA"){
            var xSolREM = eval(objREM);
            Ext.getCmp('gridRemisionesHC').store.load({
                params: {
                    pEmpresa: ID_EMPRESA,
                    pIPS: ID_IPS,
                    pPaciente: myPaciente,
                    pCAS: myCAS
                }
            });
        }else{
            var xSolREM = Ext.extend(Ext.form.Hidden, {
                initComponent: function() {
                    MyHiddenFieldUi.superclass.initComponent.call(this);
                }
            });
        }
        
        var dataConLicor = [
            ['DIARIO'],
            ['DOS VECES EN LA SEMANA'],
            ['LOS FINES DE SEMANA'],
            ['CADA 15 DIAS'],
            ['SOCIALMENTE']
        ];
        var stConLicor = new Ext.data.ArrayStore({
            fields: [
                {name: 'Descripcion'}
            ]
        });
        stConLicor.loadData(dataConLicor);
        
        var dataApaFisica = [
            ['BIEN ARREGLADO'],
            ['DESARREGLADO']
        ];
        var stApaFisica = new Ext.data.ArrayStore({
            fields: [
                {name: 'Descripcion'}
            ]
        });
        stApaFisica.loadData(dataApaFisica);
        
        var dataExaMentalActitud = [
            ['COLABORADOR'],
            ['APREHENSIVO'],
            ['SUSPICAZ'],
            ['HOSTIL']
        ];
        var stExaMentalActitud = new Ext.data.ArrayStore({
            fields: [
                {name: 'Descripcion'}
            ]
        });
        stExaMentalActitud.loadData(dataExaMentalActitud);
        
        var dataExaMentalActMotora = [
            ['TRANQUILO'],
            ['HIPERACTIVO'],
            ['AGITADO'],
            ['TEMBLOR']
        ];
        var stExaMentalActMotora = new Ext.data.ArrayStore({
            fields: [
                {name: 'Descripcion'}
            ]
        });
        stExaMentalActMotora.loadData(dataExaMentalActMotora);
        
        var dataExaMentalHipoactivo = [
            ['CONDUCTA DESORGANIZADA']
        ];
        var stExaMentalHipoactivo = new Ext.data.ArrayStore({
            fields: [
                {name: 'Descripcion'}
            ]
        });
        stExaMentalHipoactivo.loadData(dataExaMentalHipoactivo);
        
        var dataExaMentalAfecto = [
            ['ADECUADO'],
            ['INADECUADO'],
            ['LABIL'],
            ['IRRITABLE']
        ];
        var stExaMentalAfecto = new Ext.data.ArrayStore({
            fields: [
                {name: 'Descripcion'}
            ]
        });
        stExaMentalAfecto.loadData(dataExaMentalAfecto);
        
        var dataExaMentalEstanimo = [
            ['NORMAL'],
            ['DEPRIMIDO'],
            ['ANSIOSO'],
            ['EUFORICO']
        ];
        var stExaMentalEstAnimo = new Ext.data.ArrayStore({
            fields: [
                {name: 'Descripcion'}
            ]
        });
        stExaMentalEstAnimo.loadData(dataExaMentalEstanimo);
        
        var dataExaMentalLenguaje = [
            ['NORMAL'],
            ['VACILANTE'],
            ['ACELERADO'],
            ['CONFUSO'],
            ['INCOHERENTE']
        ];
        var stExaMentalLenguaje = new Ext.data.ArrayStore({
            fields: [
                {name: 'Descripcion'}
            ]
        });
        stExaMentalLenguaje.loadData(dataExaMentalLenguaje);
        
        var dataExaMentalProPensamiento = [
            ['INTACTO'],
            ['FUGA DE IDEAS'],
            ['PERDIDA DE ASOCIACIONES']
        ];
        var stExaMentalProPensamiento = new Ext.data.ArrayStore({
            fields: [
                {name: 'Descripcion'}
            ]
        });
        stExaMentalProPensamiento.loadData(dataExaMentalProPensamiento);
        
        var dataExamenFisicoRubidundez = [
            ['FACIAL'],
            ['PALIDEZ'],
            ['ALIENTO'],
            ['MIOSIS'],
            ['NISTAGMUS'],
            ['INYECCION CONJUNTIVAL']
        ];
        var stExaFisicoRubidundez = new Ext.data.ArrayStore({
            fields: [
                {name: 'Descripcion'}
            ]
        });
        stExaFisicoRubidundez.loadData(dataExamenFisicoRubidundez);
            
        this.items = [
            {
                xtype: 'panel',
                frame: true,
                anchor: '100%',
                id: 'panelHC',
                padding: 10,
                border: false,
                height: 610,
                autoScroll: true,
                layout: 'form',
                style: 'background:transparent;',
                items: [
                    {
                        xtype: 'hidden',
                        anchor: '100%',
                        allowBlank: true,
                        readOnly: true,
                        id: 'sysIdCodPlantillaHC'
                    },
                    {
                        xtype: 'hidden',
                        anchor: '100%',
                        allowBlank: true,
                        readOnly: true,
                        value: 1,
                        id: 'sysUsaGridSalida'
                    },
                    {
                        xtype: 'hidden',
                        anchor: '100%',
                        allowBlank: true,
                        readOnly: true,
                        style: 'background:transparent;font-size:16px;font-weight:bolder;border:none;color:blue;',
                        value: 0,
                        id: 'sysYaGuardoHC'
                    },
                    {
                        xtype: 'hidden',
                        anchor: '100%',
                        allowBlank: true,
                        readOnly: true,
                        fieldLabel: 'Plantilla',
                        id: 'sysPlantillaHC',
                        name: 'PLANTILLA'
                    },
                    {
                        xtype: 'hidden',
                        anchor: '100%',
                        allowBlank: true,
                        readOnly: true,
                        id: 'sysRutaRptHC'
                    },
                    {
                        xtype: 'hidden',
                        anchor: '100%',
                        allowBlank: true,
                        readOnly: true,
                        id: 'sysRutaRptMx'
                    },
                    {
                        xtype: 'hidden',
                        anchor: '100%',
                        allowBlank: true,
                        readOnly: true,
                        id: 'sysRutaRptExa'
                    },
                    {
                        xtype: 'hidden',
                        anchor: '100%',
                        allowBlank: true,
                        readOnly: true,
                        id: 'sysRutaRptRem'
                    },
                    {
                        xtype: 'textfield',
                        anchor: '100%',
                        allowBlank: true,
                        readOnly: true,
                        fieldLabel: 'Actividad',
                        style: 'background:transparent;font-size:16px;font-weight:bolder;border:none;color:blue;',
                        id: 'sysActividadHC',
                        name: 'PLANTILLA'
                    },
                    {
                        xtype: 'hidden',
                        anchor: '100%',
                        allowBlank: true,
                        readOnly: true,
                        fieldLabel: 'Empresa',
                        id: 'sysEmpresaHC'
                    },
                    {
                        xtype: 'hidden',
                        anchor: '100%',
                        allowBlank: true,
                        readOnly: true,
                        fieldLabel: 'IPS',
                        id: 'sysIPSHC'
                    },
                    {
                        xtype: 'hidden',
                        anchor: '100%',
                        allowBlank: true,
                        readOnly: true,
                        fieldLabel: 'Usuario',
                        id: 'sysUsuarioHC'
                    },
                    {
                        xtype: 'hidden',
                        anchor: '100%',
                        allowBlank: true,
                        readOnly: true,
                        fieldLabel: 'Profesional',
                        id: 'sysProfesionalHC'
                    },
                    {
                        xtype: 'hidden',
                        anchor: '100%',
                        allowBlank: true,
                        readOnly: true,
                        fieldLabel: 'Paciente',
                        id: 'sysIdPacienteHC'
                    },
                    {
                        xtype: 'hidden',
                        anchor: '100%',
                        allowBlank: true,
                        readOnly: true,
                        fieldLabel: 'Apertura',
                        id: 'sysAperturaHC'
                    },
                    {
                        xtype: 'textfield',
                        anchor: '100%',
                        allowBlank: true,
                        readOnly: true,
                        fieldLabel: 'Cliente',
                        id: 'sysClienteHC'
                    },
                    {
                        xtype: 'hidden',
                        anchor: '100%',
                        allowBlank: true,
                        readOnly: true,
                        fieldLabel: 'Plantilla',
                        id: 'sysIdClienteHC'
                    },
                    {
                        xtype: 'hidden',
                        anchor: '100%',
                        allowBlank: true,
                        readOnly: true,
                        fieldLabel: 'Plantilla',
                        id: 'sysIdPlanHC'
                    },
                    {
                        xtype: 'hidden',
                        anchor: '100%',
                        allowBlank: true,
                        readOnly: true,
                        fieldLabel: 'Plantilla',
                        id: 'sysIdSubPlanHC'
                    },
                    {
                        xtype: 'hidden',
                        anchor: '100%',
                        allowBlank: true,
                        readOnly: true,
                        fieldLabel: 'Plantilla',
                        id: 'sysIdContratoHC'
                    },
                    {
                        xtype: 'textfield',
                        anchor: '100%',
                        allowBlank: true,
                        readOnly: true,
                        fieldLabel: 'Profesional',
                        id: 'sysProfesionalAgendaHC'
                    },
                    {
                        xtype: 'hidden',
                        anchor: '100%',
                        allowBlank: true,
                        readOnly: true,
                        fieldLabel: 'ConsecutivoDetalle',
                        id: 'sysConsecutivoDetalleHC'
                    },
                    {
                        xtype: 'compositefield',
                        style: 'background:transparent;',
                        items: [
                            {
                                xtype: 'textfield',
                                allowBlank: true,
                                readOnly: true,
                                fieldLabel: 'CAS',
                                id: 'sysCASHC'
                            },
                            {
                                xtype: 'displayfield',
                                id: 'sysFechaHC',
                                value: 'Fecha: '
                            },
                            {
                                xtype: 'textfield',
                                allowBlank: true,
                                readOnly: true,
                                width: 100,
                                id: 'sysFechaHC'
                            },
                            {
                                xtype: 'displayfield',
                                id: 'sysHoraHC',
                                value: 'Hora: '
                            },
                            {
                                xtype: 'textfield',
                                allowBlank: true,
                                readOnly: true,
                                width: 90,
                                id: 'sysHoraHC'
                            },
                            {
                                xtype: 'displayfield',
                                id: 'sysLegalizacionHC',
                                value: 'Legalización: '
                            },
                            {
                                xtype: 'textfield',
                                allowBlank: true,
                                readOnly: true,
                                width: 100,
                                id: 'sysLegalizaHC'
                            },
                            {
                                xtype: 'displayfield',
                                id: 'sysAutorizacionHC',
                                value: 'Nro Autorización: '
                            },
                            {
                                xtype: 'textfield',
                                width: 210,
                                allowBlank: true,
                                style: 'color:brown;',
                                readOnly: true,
                                id: 'sysNroAutorizacionHC'
                            }
                        ]
                    },
                    {
                        xtype: 'textfield',
                        anchor: '100%',
                        allowBlank: true,
                        readOnly: true,
                        fieldLabel: 'Paciente',
                        value: 'CC 792558261  - JORGE GALEANO RUIZ - (Masculino) FechaNac: 1973-01-30, Edad 38 Años',
                        id: 'sysPacienteHC'
                    },
                    {
                        xtype: 'compositefield',
                        style: 'background:transparent;',
                        items: [
                            {
                                xtype: 'textfield',
                                width: 120,
                                allowBlank: true,
                                readOnly: true,
                                fieldLabel: 'Genero',
                                id: 'sysGeneroPacHC'
                            },
                            {
                                html: 'Fecha Nacimiento'
                            },
                            {
                                xtype: 'datefield',
                                width: 120,
                                allowBlank: true,
                                readOnly: true,
                                id: 'sysFecNacPacHC'
                            },
                            {
                                html: 'Edad'
                            },
                            {
                                xtype: 'textfield',
                                width: 250,
                                allowBlank: true,
                                readOnly: true,
                                id: 'sysEdadPacHC'
                            }
                        ]
                    },
                    {
                        html: '<hr>',
                        style: 'background:transparent;',
                        border: false
                    },
                    {
                        xtype: 'tabpanel',
                        width: 930,
                        autoHeight: true,
                        border: false,
                        ref: 'fTabPanel',
                        id: 'fTabPanel',
                        activeTab: 0,
                        items: [
                            {
                                xtype: 'panel',
                                title: 'Evolución',
                                autoHeight: true,
                                autoScroll: true,
                                width: 921,
                                frame: true,
                                border: false,
                                id: 'fichaEvolucion',
                                layout: 'form',
                                items: [
                                    {
                                        xtype: 'form',
                                        frame: true,
                                        anchor: '100%',
                                        id: 'frmHC',
                                        padding: 10,
                                        border: false,
                                        autoScroll: true,
                                        style: 'background:transparent;',
                                        items: [
                                            // AQUI EMPIEZAN CAMBIOS
                                            {
                                                xtype: 'compositefield',
                                                style: 'background:transparent;',
                                                items: [
                                                    {
                                                        xtype: 'textfield',
                                                        width: 100,
                                                        fieldLabel: 'CONDUCE Nº',
                                                        name: 'CONDUCE Nro',
                                                        allowBlank: true,
                                                        id: 'strConduceN'
                                                    },
                                                    {
                                                        html: 'TIPO DE VEHICULO'
                                                    },
                                                    {
                                                        xtype: 'textfield',
                                                        width: 100,
                                                        name: 'TIPO DE VEHICULO',
                                                        allowBlank: true,
                                                        id: 'strTipVehiculo'
                                                    },
                                                    {
                                                        html: 'PLACA'
                                                    },
                                                    {
                                                        xtype: 'textfield',
                                                        width: 100,
                                                        name: 'PLACA',
                                                        allowBlank: true,
                                                        id: 'strPLACA'
                                                    },
                                                    {
                                                        html: 'HORA SALIDA'
                                                    },
                                                    {
                                                        xtype: 'textfield',
                                                        width: 100,
                                                        name: 'HORA SALIDA',
                                                        allowBlank: true,
                                                        id: 'strHorSalida'
                                                    },
                                                ]
                                            },
                                            {
                                                xtype: 'textfield',
                                                anchor: '100%',
                                                fieldLabel: 'NOMBRE DEL CONDUCTOR',
                                                name: 'NOMBRE DEL CONDUCTOR',
                                                allowBlank: true,
                                                id: 'strNomConductor'
                                            },
                                            {
                                                xtype: 'panel',
                                                autoHeight: true,
                                                width: 880,
                                                labelWidth: 250,
                                                layout: {
                                                    columns: 2,
                                                    type: 'table'
                                                },
                                                items: [
                                                    {           
                                                        xtype: 'panel',
                                                        layout: 'form',
                                                        autoHeight: true,
                                                        width: 430,
                                                        padding: 5,
                                                        items:[
                                                            {
                                                                xtype: 'checkbox',
                                                                fieldLabel: 'HISTORIA PREVIA DE CONSUMO DE LICOR',
                                                                name: 'HISTORIA PREVIA DE CONSUMO DE LICOR',
                                                                anchor: '100%',
                                                                value: 'false',
                                                                id: 'bolHisPreConLicor'
                                                            },
                                                            {
                                                                xtype: 'checkbox',
                                                                fieldLabel: 'HISTORIA PARA USO DE OTRAS SUSTANCIAS',
                                                                name: 'HISTORIA PARA USO DE OTRAS SUSTANCIAS',
                                                                anchor: '100%',
                                                                value: 'false',
                                                                id: 'bolHisOtraSustancias'
                                                            }
                                                        ]
                                                    },
                                                    {           
                                                        xtype: 'panel',
                                                        layout: 'form',
                                                        autoHeight: true,
                                                        width: 430,
                                                        padding: 5,
                                                        items:[
                                                            {
                                                                xtype: 'checkbox',
                                                                fieldLabel: 'HISTORIA PREVIA A NIVEL PSIQUIÁTRICO',
                                                                name: 'HISTORIA PREVIA A NIVEL PSIQUIÁTRICO',
                                                                anchor: '100%',
                                                                value: 'false',
                                                                id: 'bolHisPreNivPsiquiatrico'
                                                            },
                                                            {
                                                                xtype: 'compositefield',
                                                                style: 'background:transparent;',
                                                                items: [
                                                                    {
                                                                        xtype: 'combo',
                                                                        fieldLabel: 'IDEAS DELIRANTES',
                                                                        name: 'IDEAS DELIRANTES',
                                                                        anchor: '100%',
                                                                        store:'StoreSiNo',
                                                                        mode: 'local',
                                                                        forceSelection: true,
                                                                        typeAhead: true,
                                                                        typeAheadDelay: 10,
                                                                        triggerAction: 'all',
                                                                        valueField: 'Descripcion',
                                                                        displayField: 'Descripcion',
                                                                        id: 'strIdeDelirantes'
                                                                    },
                                                                    {
                                                                        html: 'IDEAS SUICIDAS:'
                                                                    },
                                                                    {
                                                                        xtype: 'combo',
                                                                        name: 'IDEAS SUICIDAS',
                                                                        anchor: '100%',
                                                                        store:'StoreSiNo',
                                                                        mode: 'local',
                                                                        forceSelection: true,
                                                                        typeAhead: true,
                                                                        typeAheadDelay: 10,
                                                                        triggerAction: 'all',
                                                                        valueField: 'Descripcion',
                                                                        displayField: 'Descripcion',
                                                                        id: 'strIdeSuicidas'
                                                                    }
                                                                ]
                                                            }
                                                        ]
                                                    }
                                                ]
                                            },
                                            {
                                                xtype: 'combo',
                                                anchor: '100%',
                                                store: stConLicor,
                                                mode: 'local',
                                                forceSelection: true,
                                                typeAhead: true,
                                                typeAheadDelay: 10,
                                                triggerAction: 'all',
                                                valueField: 'Descripcion',
                                                displayField: 'Descripcion',
                                                fieldLabel: 'CONSUME LICOR CON QUÉ FRECUENCIA',
                                                name:'strConLicFrecuencia',
                                                id: 'strConLicFrecuencia'
                                            },
                                            {
                                                xtype: 'compositefield',
                                                style: 'background:transparent;',
                                                items: [
                                                    {
                                                        xtype: 'numberfield',
                                                        width: 60,
                                                        minValue: 0,
                                                        maxValue: 250,
                                                        decimalPrecision: 2,
                                                        allowBlank: true,
                                                        fieldLabel: 'PESO (kg)',
                                                        name:"PESO (kg)",
                                                        emptyText: '(kg)',
                                                        id: 'intConAlcPeso'
                                                    },
                                                    {
                                                        xtype: 'numberfield',
                                                        width: 60,
                                                        minValue: 0,
                                                        maxValue: 250,
                                                        decimalPrecision: 2,
                                                        allowBlank: true,
                                                        fieldLabel: 'TALLA (cm)',
                                                        name:"TALLA (cm)",
                                                        emptyText: '(cm)',
                                                        id: 'intConAlcTalla'
                                                    },
                                                    {
                                                        xtype: 'numberfield',
                                                        width: 60,
                                                        minValue: 0,
                                                        maxValue: 250,
                                                        decimalPrecision: 2,
                                                        allowBlank: true,
                                                        fieldLabel: 'PRESIÓN ARTERIAL',
                                                        name:"Presion arterial (cm)",
                                                        id: 'intConAlcPreArterial'
                                                    },
                                                    {
                                                        xtype: 'numberfield',
                                                        width: 60,
                                                        minValue: 0,
                                                        maxValue: 250,
                                                        decimalPrecision: 2,
                                                        allowBlank: true,
                                                        fieldLabel: 'FRECUENCIA CARDÍACA ',
                                                        name:"Frecuencia Cardiaca ",
                                                        id: 'intConAlcFreCardiaca'
                                                    }
                                                ]
                                            },
                                            {
                                                xtype: 'combo',
                                                anchor: '100%',
                                                store: stApaFisica,
                                                mode: 'local',
                                                forceSelection: true,
                                                typeAhead: true,
                                                typeAheadDelay: 10,
                                                triggerAction: 'all',
                                                valueField: 'Descripcion',
                                                displayField: 'Descripcion',
                                                fieldLabel: 'APARIENCIA FÍSICA:',
                                                name:'intApaFisica',
                                                id: 'intApaFisica'
                                            },
                                            {
                                                xtype: 'fieldset',
                                                title: 'EXAMEN MENTAL',
                                                collapsible: true,
                                                titleCollapse: true,
                                                anchor: '100%',
                                                autoHeight: true,
                                                padding: 7,
                                                items: [
                                                    {
                                                        xtype: 'compositefield',
                                                        style: 'background:transparent;',
                                                        items: [
                                                            { 
                                                                xtype:'displayfield',
                                                                id:'sysExaMenActituc',
                                                                value:'ACTITUD: '
                                                            },
                                                            {
                                                                xtype: 'combo',
                                                                anchor: '100%',
                                                                store:stExaMentalActitud,
                                                                mode: 'local',
                                                                forceSelection: true,
                                                                typeAhead: true,
                                                                typeAheadDelay: 10,
                                                                triggerAction: 'all',
                                                                valueField: 'Descripcion',
                                                                displayField: 'Descripcion',
                                                                name:'strExaMenActituc',
                                                                id: 'strExaMenActituc'
                                                            },
                                                            { 
                                                                xtype:'displayfield',
                                                                id:'sysExaMenActMotora',
                                                                value:'ACTIVIDAD MOTORA:'
                                                            },
                                                            {
                                                                xtype: 'combo',
                                                                anchor: '100%',
                                                                store: stExaMentalActMotora,
                                                                mode: 'local',
                                                                forceSelection: true,
                                                                typeAhead: true,
                                                                typeAheadDelay: 10,
                                                                triggerAction: 'all',
                                                                valueField: 'Descripcion',
                                                                displayField: 'Descripcion',
                                                                name:'strExaMenActMotora',
                                                                id: 'strExaMenActMotora'
                                                            },
                                                        ]
                                                    },
                                                    {
                                                        xtype: 'compositefield',
                                                        style: 'background:transparent;',
                                                        items: [
                                                            { 
                                                                xtype:'displayfield',
                                                                id:'sysExaMentalHipoactivo',
                                                                value:'HIPOACTIVO:'
                                                            },
                                                            {
                                                                xtype: 'combo',
                                                                anchor: '100%',
                                                                store: stExaMentalHipoactivo,
                                                                mode: 'local',
                                                                forceSelection: true,
                                                                typeAhead: true,
                                                                typeAheadDelay: 10,
                                                                triggerAction: 'all',
                                                                valueField: 'Descripcion',
                                                                displayField: 'Descripcion',
                                                                name:'strExaMentalHipoactivo',
                                                                id: 'strExaMentalHipoactivo'
                                                            },
                                                            { 
                                                                xtype:'displayfield',
                                                                id:'sysExaMentalAfecto',
                                                                value:'AFECTO:'
                                                            },
                                                            {
                                                                xtype: 'combo',
                                                                anchor: '100%',
                                                                store: stExaMentalAfecto,
                                                                mode: 'local',
                                                                forceSelection: true,
                                                                typeAhead: true,
                                                                typeAheadDelay: 10,
                                                                triggerAction: 'all',
                                                                valueField: 'Descripcion',
                                                                displayField: 'Descripcion',
                                                                name:'strExaMentalAfecto',
                                                                id: 'strExaMentalAfecto'
                                                            }
                                                        ]
                                                    },
                                                    {
                                                        xtype: 'compositefield',
                                                        style: 'background:transparent;',
                                                        items: [
                                                            { 
                                                                xtype:'displayfield',
                                                                id:'sysExaMentalEstAnimo',
                                                                value:'ESTADO DE ÁNIMO:'
                                                            },
                                                            {
                                                                xtype: 'combo',
                                                                anchor: '100%',
                                                                store: stExaMentalEstAnimo,
                                                                mode: 'local',
                                                                forceSelection: true,
                                                                typeAhead: true,
                                                                typeAheadDelay: 10,
                                                                triggerAction: 'all',
                                                                valueField: 'Descripcion',
                                                                displayField: 'Descripcion',
                                                                name:'strExaMentalEstAnimo',
                                                                id: 'strExaMentalEstAnimo'
                                                            },
                                                            { 
                                                                xtype:'displayfield',
                                                                id:'sysExaMentalLenguaje',
                                                                value:'LENGUAJE:'
                                                            },
                                                            {
                                                                xtype: 'combo',
                                                                anchor: '100%',
                                                                store: stExaMentalLenguaje,
                                                                mode: 'local',
                                                                forceSelection: true,
                                                                typeAhead: true,
                                                                typeAheadDelay: 10,
                                                                triggerAction: 'all',
                                                                valueField: 'Descripcion',
                                                                displayField: 'Descripcion',
                                                                name:'strExaMentalLenguaje',
                                                                id: 'strExaMentalLenguaje'
                                                            },
                                                            { 
                                                                xtype:'displayfield',
                                                                id:'sysExaMentalProPensamiento',
                                                                value:'PROCESO DE PENSAMIENTO:'
                                                            },
                                                            {
                                                                xtype: 'combo',
                                                                anchor: '100%',
                                                                store: stExaMentalProPensamiento,
                                                                mode: 'local',
                                                                forceSelection: true,
                                                                typeAhead: true,
                                                                typeAheadDelay: 10,
                                                                triggerAction: 'all',
                                                                valueField: 'Descripcion',
                                                                displayField: 'Descripcion',
                                                                name:'strExaMentalProPensamiento',
                                                                id: 'strExaMentalProPensamiento'
                                                            }
                                                        ]
                                                    }
                                                ]
                                            },
                                            {
                                                xtype: 'textfield',
                                                width: 50,
                                                fieldLabel: 'PRUEBAS',
                                                name: 'sysPruebas',
                                                allowBlank: true,
                                                id: 'sysPruebas'
                                            },
                                            {
                                                xtype: 'fieldset',
                                                title: 'LENGUAJE Y PRAXIAS',
                                                layout: 'form',
                                                collapsible: true,
                                                titleCollapse: true,
                                                anchor: '100%',
                                                autoHeight: true,
                                                padding: 7,
                                                items: [
                                                    {
                                                        xtype: 'textfield',
                                                        anchor: '100%',
                                                        width: 850,
                                                        fieldLabel: 'ORIENTACIÓN AUTOPSÍQUICA R/ HALOPSÍQUICA R/ TIENE, ESPACIO, LUGAR',
                                                        name: 'ORIENTACION AUTOPSÍQUICA',
                                                        id: 'strPruebasOriAutipsiquica'
                                                    },
                                                    {
                                                        xtype: 'textfield',
                                                        anchor: '100%',
                                                        width: 850,
                                                        fieldLabel: 'DESDE 100 HAGA CINCO RESTAS DE 7 EN 7 R/',
                                                        id: 'strPruebasCinRestas'
                                                    },
                                                    {
                                                        xtype: 'textfield',
                                                        anchor: '100%',
                                                        width: 850,
                                                        fieldLabel: 'MENCIONE TRES OBJECTOS Y DÍGALE QUE TIENE TRES SEGUNDOS PARA REPETIRLOS DE 1 EN 1 R/',
                                                        id: 'strPruebasTresObjectos'
                                                    },
                                                    {
                                                        xtype: 'textfield',
                                                        anchor: '100%',
                                                        width: 850,
                                                        fieldLabel: 'MUÉSTRELE UN LÁPIZ Y UN RELOJ Y PÍDALE LOS NOMBRES R/',
                                                        id: 'strPruebasLapizReloj'
                                                    },
                                                    {
                                                        xtype: 'textfield',
                                                        anchor: '100%',
                                                        width: 850,
                                                        fieldLabel: 'PÍDALE QUE REPITA: NO, SIES, IES Y PEROS R/',
                                                        id: 'strPruebasRepita'
                                                    },
                                                    {
                                                        xtype: 'textfield',
                                                        anchor: '100%',
                                                        width: 850,
                                                        fieldLabel: 'COJA UN PAPEL CON LA MANO DERECHA, DÓBLELO A LA MITAD Y COLÓQUELO EN EL PISO R/',
                                                        id: 'strPruebasPapelDerecha'
                                                    },
                                                    {
                                                        xtype: 'textfield',
                                                        anchor: '100%',
                                                        width: 850,
                                                        fieldLabel: 'PRUEBAS DE EUMETRIÁ R/',
                                                        id: 'strPruebasEumetria'
                                                    },
                                                    {
                                                        xtype: 'textfield',
                                                        anchor: '100%',
                                                        width: 850,
                                                        fieldLabel: 'DIADOCOCINESIA: CRUZANDO EXTREMIDADES SUPERIORES R/',
                                                        id: 'strPruebaDiadococinesia'
                                                    },
                                                    {
                                                        xtype: 'textfield',
                                                        anchor: '100%',
                                                        width: 850,
                                                        fieldLabel: 'CRUZANDO EXTREMIDADES INFERIORES R/',
                                                        id: 'strPruebaExtInferiores'
                                                    },
                                                    {
                                                        xtype: 'textfield',
                                                        anchor: '100%',
                                                        width: 850,
                                                        fieldLabel: 'TOCÁNDOSE LA PUNTA DE LA NARIZ CON OJOS ABIERTOS Y CERRADOS R/',
                                                        id: 'strPruebaPuntaNariz'
                                                    },
                                                    {
                                                        xtype: 'textfield',
                                                        anchor: '100%',
                                                        width: 850,
                                                        fieldLabel: 'ESCRIBA UNA FRASE',
                                                        id: 'strPruebaEscFrase'
                                                    }
                                                ]
                                            },
                                            {
                                                xtype: 'fieldset',
                                                title: 'SIGNOS INDIRECTOS EXAMEN FÍSICO',
                                                layout: 'form',
                                                collapsible: true,
                                                titleCollapse: true,
                                                anchor: '100%',
                                                autoHeight: true,
                                                padding: 7,
                                                items: [
                                                    {
                                                        xtype: 'combo',
                                                        anchor: '100%',
                                                        store: stExaFisicoRubidundez,
                                                        mode: 'local',
                                                        forceSelection: true,
                                                        typeAhead: true,
                                                        typeAheadDelay: 10,
                                                        triggerAction: 'all',
                                                        valueField: 'Descripcion',
                                                        displayField: 'Descripcion',
                                                        fieldLabel: 'RUBIDUNDEZ CONJUNTIVAL',
                                                        name:'strExaFisicostExaFisicoRubidundez',
                                                        id: 'strExaFisicostExaFisicoRubidundez'
                                                    },
                                                    {
                                                        xtype: 'textfield',
                                                        anchor: '100%',
                                                        width: 850,
                                                        fieldLabel: 'EVALUACIÓN CUANTITIATIVA',
                                                        id: 'strExaFisicoEvaCuantitativa'
                                                    },
                                                    {
                                                        xtype: 'textfield',
                                                        anchor: '100%',
                                                        width: 850,
                                                        fieldLabel: 'UBÍQUELO EN EL GRADO POR CLÍNICA',
                                                        id: 'strExaFisicoGraClinica'
                                                    },
                                                    {
                                                        xtype: 'panel',
                                                        title: 'TABLA',
                                                        height:280,
                                                        tpl:[
                                                            '<table border="6" class="notificacion">',
                                                            '<tr><td>NIVELES</td><td>EFECTOS  EN LA CONDUCCIÓN (LEY 769 DE 2002)</td></tr>',
                                                            '<tr><td> 1 A 39.99 mg% SIN EMBRIAGUEZ</td><td></td></tr>',
                                                            '<tr><td> 40 A 99.99 mg% EMBRIAGUEZ GRADO 1</td><td> SE ALTERA LA VALORACIÓN DEL RIESGO. DISMINUYE LA AUTOCRÍTICA Y SE SOBREVALORAN LAS CAPACIDADES, SE TIENE UNA APRECIACIÓN INCORRECTA DE LA VELOCIDAD. CONDUCCIÓN ESTÁ PROHIBIDA.</td></tr>',
                                                            '<tr><td>100 A 149 mg EMBRIAGUEZ GRADO 2</td><td>PREDOMINA LA SENSACIÓN DE EUFORIA Y NO SE TOMA CONCIENCIA DE LOS PELIGROS REALES QUE SE CORREN Y SE HACEN CORRER A LOS DEMÁS. CONDUCCIÓN ESTA PROHIBIDA.</td></tr>',
                                                            '<tr><td>150 mg% EMBRIAGUEZ GRADO 3</td><td>HAY SÍNTOMAS CLAROS DE INTOXICACIÓN. ESTÁN SERIAMENTE AFECTADAS LA VIGILANCIA, LA ATENCIÓN, LA PERCEPCIÓN Y LA COORDINACIÓN. LOS REFLEJOS ESTAN PERTURBADOS. TRASTORNOS DEL EQUILIBRIO Y LA MARCHA. PÉRDIDA DE LA CONCIENCIA. EMBRIAGUEZ PROFUNDA. CONDUCCIÓN ESTA PROHIBIDA.</td></tr>',                         
                                                            '</table>'
                                                        ],
                                                        padding: 10,
                                                        autoScroll: true
                                                    }
                                                ]
                                            },
                                            {
                                                xtype: 'textarea',
                                                anchor: '100%',
                                                width: 850,
                                                fieldLabel: 'OBSERVACIONES',
                                                name: 'OBSERVACIONES',
                                                height: 30,
                                                grow: true,
                                                minGrow: 30,            
                                                allowBlank: false,
                                                id: 'memExamenFisicoObservaciones'
                                            },
                                            {
                                                xtype: 'compositefield',
                                                style: 'background:transparent;',
                                                items: [
                                                    {
                                                        xtype: 'combo',
                                                        anchor: '100%',
                                                        store:'StoreSiNo',
                                                        mode: 'local',
                                                        forceSelection: true,
                                                        typeAhead: true,
                                                        typeAheadDelay: 10,
                                                        triggerAction: 'all',
                                                        fieldLabel: 'REQUIERE ALCOHOLEMIA POR ANÁLISIS DE LABORATORIO:',
                                                        valueField: 'Descripcion',
                                                        displayField: 'Descripcion',
                                                        name:'intExaFisicoAlcoholemia',
                                                        id: 'intExaFisicoAlcoholemia'
                                                    },
                                                    {
                                                        xtype: 'textfield',
                                                        anchor: '100%',
                                                        width: 850,
                                                        fieldLabel: 'R.',
                                                        id: 'strExaFisicoRespuestaAlcoholemia'
                                                    }
                                                ]
                                            },
                                            // AQUI FINALIZAN CAMBIOS
                                            {
                                                xtype: 'fieldset',
                                                title: 'RIPS',
                                                layout: 'form',
                                                collapsible: true,
                                                titleCollapse: true,
                                                anchor: '100%',
                                                autoHeight: true,
                                                id: 'fsRips',
                                                items: [
                                                    {
                                                        xtype: 'compositefield',
                                                        style: 'background:transparent;',
                                                        items: [
                                                            {
                                                                xtype: 'textfield',
                                                                width: 96,
                                                                allowBlank: false,
                                                                fieldLabel: 'Diagnostico Principal',
                                                                id: 'sysDiagPpalHC',
                                                                listeners:{
                                                                    specialkey: function(f,e){
                                                                        if (e.getKey() == e.ENTER || e.getKey() == e.TAB)
                                                                        {
                                                                            if (f.getValue() != "" && f.getValue() != null && f.getValue().toUpperCase() != Ext.getCmp('sysDiagRel1HC').getValue() && f.getValue().toUpperCase() != Ext.getCmp('sysDiagRel2HC').getValue() && f.getValue().toUpperCase() != Ext.getCmp('sysDiagRel3HC').getValue()){
                                                                                Ext.Ajax.request({
                                                                                    url: '../../controlador/cie10/controlador_cie10.php',
                                                                                    params:{
                                                                                        task: 'BUSCAR',
                                                                                        pCodigo: f.getValue().toUpperCase()
                                                                                    },
                                                                                    success: function(response,options)
                                                                                    {
                                                                                        var el = Ext.get('response'); // get the LOG
                                                                                        var Respuesta = response.responseText;
                                                                                        var Contenido = Respuesta.split('^');
                                                                                        if(Contenido[0]=="" || Contenido[0]== "{success:false}" || Contenido[0]== null){
                                                                                            Ext.getCmp('sysDiagPpalHC').setValue(null);
                                                                                            Ext.getCmp('sysDiagPpalHCNom').setValue(null);
                                                                                        } else {
                                                                                            Ext.getCmp('sysDiagPpalHC').setValue(Contenido[0]);
                                                                                            Ext.getCmp('sysDiagPpalHCNom').setValue(Contenido[1]);
                                                                                        }
                                                                                    },
                                                                                    failure: function(response,options){
                                                                                        var el = Ext.get('response');
                                                                                        Ext.getCmp('sysDiagPpalHC').setValue(null);
                                                                                        Ext.getCmp('sysDiagPpalHCNom').setValue(null);
                                                                                    },
                                                                                    scope:this //bind the callbacks
                                                                                });
                                                                            }else{
                                                                                Ext.getCmp('sysDiagPpalHC').setValue(null);
                                                                                Ext.getCmp('sysDiagPpalHCNom').setValue(null);
                                                                            }
                                                                        }
                                                                    }
                                                                }
                                                            },
                                                            {
                                                                xtype: 'textarea',
                                                                readOnly: true,
                                                                width: 625,
                                                                height: 22,
                                                                id: 'sysDiagPpalHCNom'
                                                            },
                                                            {
                                                                xtype: 'button',
                                                                iconCls: 'btnBuscar',
                                                                tooltip: 'Buscar Diagnostico Principal',
                                                                id: 'btnSearchDiagPpalHC',
                                                                listeners:{
                                                                    click : function(){
                                                                        buscarcie10('sysDiagPpalHC','sysDiagPpalHCNom');
                                                                    }
                                                                }
                                                            }
                                                        ]
                                                    },
                                                    {
                                                        xtype: 'compositefield',
                                                        style: 'background:transparent;',
                                                        items: [
                                                            {
                                                                xtype: 'textfield',
                                                                width: 96,
                                                                allowBlank: true,
                                                                fieldLabel: 'Diagnostico Relacionado Nro.1',
                                                                id: 'sysDiagRel1HC',
                                                                listeners:{
                                                                    specialkey: function(f,e){
                                                                        if (e.getKey() == e.ENTER || e.getKey() == e.TAB)
                                                                        {
                                                                            if (f.getValue() != "" && f.getValue() != null && f.getValue().toUpperCase() != Ext.getCmp('sysDiagPpalHC').getValue() && f.getValue().toUpperCase() != Ext.getCmp('sysDiagRel2HC').getValue() && f.getValue().toUpperCase() != Ext.getCmp('sysDiagRel3HC').getValue()){
                                                                                Ext.Ajax.request(
                                                                                {
                                                                                    url: '../../controlador/cie10/controlador_cie10.php',
                                                                                    params:{
                                                                                        task: 'BUSCAR',
                                                                                        pCodigo: f.getValue().toUpperCase()
                                                                                    },
                                                                                    success: function(response,options)
                                                                                    {
                                                                                        var el = Ext.get('response'); // get the LOG
                                                                                        var Respuesta = response.responseText;
                                                                                        var Contenido = Respuesta.split('^');
                                                                                        if(Contenido[0]=="" || Contenido[0]== "{success:false}" || Contenido[0]== null){
                                                                                            Ext.getCmp('sysDiagRel1HC').setValue(null);
                                                                                            Ext.getCmp('sysDiagRel1HCNom').setValue(null);
                                                                                        } else {
                                                                                            Ext.getCmp('sysDiagRel1HC').setValue(Contenido[0]);
                                                                                            Ext.getCmp('sysDiagRel1HCNom').setValue(Contenido[1]);
                                                                                        }
                                                                                    },
                                                                                    failure: function(response,options){
                                                                                        var el = Ext.get('response');
                                                                                        Ext.getCmp('sysDiagRel1HC').setValue(null);
                                                                                        Ext.getCmp('sysDiagRel1HCNom').setValue(null);
                                                                                    },
                                                                                    scope:this //bind the callbacks
                                                                                });
                                                                            }else{
                                                                                Ext.getCmp('sysDiagRel1HC').setValue(null);
                                                                                Ext.getCmp('sysDiagRel1HCNom').setValue(null);
                                                                            }
                                                                        }
                                                                    }
                                                                }
                                                            },
                                                            {
                                                                xtype: 'textarea',
                                                                readOnly: true,
                                                                width: 625,
                                                                height: 22,
                                                                id: 'sysDiagRel1HCNom'
                                                            },
                                                            {
                                                                xtype: 'button',
                                                                iconCls: 'btnBuscar',
                                                                tooltip: 'Buscar Diagnostico Relacionado1',
                                                                id: 'btnSearchDiagRel1HC',
                                                                listeners:{
                                                                    click : function(){
                                                                        buscarcie10('sysDiagRel1HC','sysDiagRel1HCNom');
                                                                    }
                                                                }
                                                            }
                                                        ]
                                                    },
                                                    {
                                                        xtype: 'compositefield',
                                                        style: 'background:transparent;',
                                                        items: [
                                                            {
                                                                xtype: 'textfield',
                                                                width: 96,
                                                                allowBlank: true,
                                                                fieldLabel: 'Diagnostico Relacionado Nro.2',
                                                                id: 'sysDiagRel2HC',
                                                                listeners:{
                                                                    specialkey: function(f,e){
                                                                        if (e.getKey() == e.ENTER || e.getKey() == e.TAB)
                                                                        {
                                                                            if (f.getValue() != "" && f.getValue() != null && f.getValue().toUpperCase() != Ext.getCmp('sysDiagPpalHC').getValue() && f.getValue().toUpperCase() != Ext.getCmp('sysDiagRel1HC').getValue() && f.getValue().toUpperCase() != Ext.getCmp('sysDiagRel3HC').getValue()){
                                                                                Ext.Ajax.request(
                                                                                {
                                                                                    url: '../../controlador/cie10/controlador_cie10.php',
                                                                                    params:{
                                                                                        task: 'BUSCAR',
                                                                                        pCodigo: f.getValue().toUpperCase()
                                                                                    },
                                                                                    success: function(response,options)
                                                                                    {
                                                                                        var el = Ext.get('response'); // get the LOG
                                                                                        var Respuesta = response.responseText;
                                                                                        var Contenido = Respuesta.split('^');
                                                                                        if(Contenido[0]=="" || Contenido[0]== "{success:false}" || Contenido[0]== null){
                                                                                            Ext.getCmp('sysDiagRel2HC').setValue(null);
                                                                                            Ext.getCmp('sysDiagRel2HCNom').setValue(null);
                                                                                        } else {
                                                                                            Ext.getCmp('sysDiagRel2HC').setValue(Contenido[0]);
                                                                                            Ext.getCmp('sysDiagRel2HCNom').setValue(Contenido[1]);
                                                                                        }
                                                                                    },
                                                                                    failure: function(response,options){
                                                                                        var el = Ext.get('response');
                                                                                        Ext.getCmp('sysDiagRel2HC').setValue(null);
                                                                                        Ext.getCmp('sysDiagRel2HCNom').setValue(null);
                                                                                    },
                                                                                    scope:this //bind the callbacks
                                                                                });
                                                                            }else{
                                                                                Ext.getCmp('sysDiagRel2HC').setValue(null);
                                                                                Ext.getCmp('sysDiagRel2HCNom').setValue(null);
                                                                            }
                                                                        }
                                                                    }
                                                                }
                                                            },
                                                            {
                                                                xtype: 'textarea',
                                                                readOnly: true,
                                                                width: 625,
                                                                height: 22,
                                                                id: 'sysDiagRel2HCNom'
                                                            },
                                                            {
                                                                xtype: 'button',
                                                                iconCls: 'btnBuscar',
                                                                tooltip: 'Buscar Diagnostico Relacionado2',
                                                                id: 'btnSearchDiagRel2HC1',
                                                                listeners:{
                                                                    click : function(){
                                                                        buscarcie10('sysDiagRel2HC','sysDiagRel2HCNom');
                                                                    }
                                                                }
                                                            }
                                                        ]
                                                    },
                                                    {
                                                        xtype: 'compositefield',
                                                        style: 'background:transparent;',
                                                        items: [
                                                            {
                                                                xtype: 'textfield',
                                                                width: 96,
                                                                allowBlank: true,
                                                                fieldLabel: 'Diagnostico Relacionado Nro.3',
                                                                id: 'sysDiagRel3HC',
                                                                listeners:{
                                                                    specialkey: function(f,e){
                                                                        if (e.getKey() == e.ENTER || e.getKey() == e.TAB)
                                                                        {
                                                                            if (f.getValue() != "" && f.getValue() != null && f.getValue().toUpperCase() != Ext.getCmp('sysDiagPpalHC').getValue() && f.getValue().toUpperCase() != Ext.getCmp('sysDiagRel1HC').getValue() && f.getValue().toUpperCase() != Ext.getCmp('sysDiagRel2HC').getValue()){
                                                                                Ext.Ajax.request(
                                                                                {
                                                                                    url: '../../controlador/cie10/controlador_cie10.php',
                                                                                    params:{
                                                                                        task: 'BUSCAR',
                                                                                        pCodigo: f.getValue().toUpperCase()
                                                                                    },
                                                                                    success: function(response,options)
                                                                                    {
                                                                                        var el = Ext.get('response'); // get the LOG
                                                                                        var Respuesta = response.responseText;
                                                                                        var Contenido = Respuesta.split('^');
                                                                                        if(Contenido[0]=="" || Contenido[0]== "{success:false}" || Contenido[0]== null){
                                                                                            Ext.getCmp('sysDiagRel3HC').setValue(null);
                                                                                            Ext.getCmp('sysDiagRel3HCNom').setValue(null);
                                                                                        } else {
                                                                                            Ext.getCmp('sysDiagRel3HC').setValue(Contenido[0]);
                                                                                            Ext.getCmp('sysDiagRel3HCNom').setValue(Contenido[1]);
                                                                                        }
                                                                                    },
                                                                                    failure: function(response,options){
                                                                                        var el = Ext.get('response');
                                                                                        Ext.getCmp('sysDiagRel3HC').setValue(null);
                                                                                        Ext.getCmp('sysDiagRel3HCNom').setValue(null);
                                                                                    },
                                                                                    scope:this //bind the callbacks
                                                                                });
                                                                            }else{
                                                                                Ext.getCmp('sysDiagRel3HC').setValue(null);
                                                                                Ext.getCmp('sysDiagRel3HCNom').setValue(null);
                                                                            }
                                                                        }
                                                                    }
                                                                }
                                                            },
                                                            {
                                                                xtype: 'textarea',
                                                                readOnly: true,
                                                                width: 625,
                                                                height: 22,
                                                                id: 'sysDiagRel3HCNom'
                                                            },
                                                            {
                                                                xtype: 'button',
                                                                iconCls: 'btnBuscar',
                                                                tooltip: 'Buscar Diagnostico Relacionado3',
                                                                id: 'btnSearchDiagRel3HC',
                                                                listeners:{
                                                                    click : function(){
                                                                        buscarcie10('sysDiagRel3HC','sysDiagRel3HCNom');
                                                                    }
                                                                }
                                                            }
                                                        ]
                                                    },
                                                    {
                                                        xtype: 'combo',
                                                        fieldLabel: 'Tipo de Diagnostico',
                                                        width:750,
                                                        name: 'Tipo de Diagnostico',
                                                        allowBlank: false,
                                                        store: 'StoreTipoDiagnostico',
                                                        forceSelection: true,
                                                        triggerAction: 'all',
                                                        typeAhead: true,
                                                        typeAheadDelay: 50,
                                                        mode: 'local',
                                                        valueField: 'Codigo',
                                                        displayField: 'Descripcion',
                                                        emptyText: 'Seleccione....',
                                                        submitValue: true,
                                                        id: 'sysTipoDiagosticoHC'
                                                    },
                                                    {
                                                        xtype: 'combo',
                                                        fieldLabel: 'Finalidad Consulta',
                                                        width:750,
                                                        name: 'Finalidad Consulta',
                                                        allowBlank: false,
                                                        store: 'StoreFinalidadConsulta',
                                                        forceSelection: true,
                                                        triggerAction: 'all',
                                                        typeAhead: true,
                                                        typeAheadDelay: 50,
                                                        mode: 'local',
                                                        valueField: 'Codigo',
                                                        displayField: 'Descripcion',
                                                        emptyText: 'Seleccione....',
                                                        submitValue: true,
                                                        value: 10,
                                                        id: 'sysFinalidadConsultaHC'
                                                    },
                                                    {
                                                        xtype: 'combo',
                                                        fieldLabel: 'Causa Externa',
                                                        width:750,
                                                        name: 'Causa Externa',
                                                        allowBlank: false,
                                                        store: 'StoreCausaExterna',
                                                        forceSelection: true,
                                                        triggerAction: 'all',
                                                        typeAhead: true,
                                                        typeAheadDelay: 50,
                                                        mode: 'local',
                                                        valueField: 'Codigo',
                                                        displayField: 'Descripcion',
                                                        emptyText: 'Seleccione....',
                                                        submitValue: true,
                                                        value: 13,
                                                        id: 'sysCausaExternaHC'
                                                    }                            
                                                ]
                                            }
                                        ]
                                    }
                                ]
                            },
                            {
                                xtype: 'panel',
                                title: 'Solicitud Medicamentos',
                                height: 352,
                                width: 921,
                                frame: true,
                                border: false,
                                id: 'fichaMedicamentos',
                                items: [
                                    xSolMX
                                ]
                            },
                            {
                                xtype: 'panel',
                                title: 'Solicitud Servicios',
                                height: 355,
                                width: 921,
                                frame: true,
                                border: false,
                                id: 'fichaServicios',
                                items: [
                                    xSolEXA
                                ]
                            },
                            {
                                xtype: 'panel',
                                title: 'Solicitud Remisiones',
                                height: 355,
                                width: 921,
                                frame: true,
                                border: false,
                                id: 'fichaRemisiones',
                                items: [
                                    xSolREM
                                ]
                            }
                            /*,
                            {
                                xtype: 'panel',
                                title: 'Solicitud CTC',
                                height: 355,
                                width: 921,
                                frame: true,
                                border: false,
                                id: 'fichaCTC',
                                items: [
                                ]
                            },
                            {
                                xtype: 'panel',
                                title: 'Consentimientos Informados',
                                height: 355,
                                width: 921,
                                frame: true,
                                border: false,
                                id: 'fichaConsentimientos',
                                items: [
                                ]
                            },*/
                        ]
                    }
                ],
                bbar:{
                    items: [
                        {
                            xtype: 'tbfill'
                        },
                        {
                            xtype: 'tbseparator'
                        },
                        {
                            xtype: 'button',
                            text: 'Salir',
                            iconCls: 'btnSalir',
                            id: 'btnSalirEvolucion',
                            listeners:{
                                click : function(){
                                    if (Ext.getCmp('sysYaGuardoHC').getValue() == 1) 
                                        Ext.Msg.show({
                                            title: 'eOfiClinic',
                                            msg: 'Esta seguro que desea cerrar la ventana?',
                                            buttons: Ext.Msg.YESNO,
                                            icon: Ext.Msg.QUESTION,
                                            fn: function(btn)
                                            {
                                                if(btn=="yes")
                                                {
                                                    if (Ext.getCmp('sysUsaGridSalida').getValue() == 1){
                                                        Ext.getCmp('gridFormulario').store.reload();
                                                    }
                                                    Ext.getCmp('winHC').close();
                                                }
                                            }
                                        });
                                    else{
                                        Ext.Msg.show({
                                            title: 'eOfiClinic',
                                            msg: 'Usted No ha Guardado la Evolución del Paciente y Se Perdera la Información, Esta seguro que desea cerrar la ventana?',
                                            buttons: Ext.Msg.YESNO,
                                            icon: Ext.Msg.QUESTION,
                                            fn: function(btn)
                                            {
                                                if(btn=="yes")
                                                {
                                                    Ext.getCmp('gridFormulario').store.reload();
                                                    Ext.getCmp('winHC').close();
                                                }
                                            }
                                        });
                                    }
                                }
                            }
                        }
                    ]
                },
                tbar:{
                    items: [
                        {
                            xtype: 'tbseparator'
                        },
                        {
                            xtype: 'button',
                            text: 'Ver Historia Clínica',
                            iconCls: 'btnVerHC',
                            id: 'btnVerHC',
                            listeners:{
                                click : function(){
                                    var cmpResumenHC = new winFrmVerHistorialHC({
                                        renderTo: Ext.getBody()
                                    });
                                    Ext.getCmp('winViewEvolucionHC').title = "PACIENTE: " + Ext.getCmp('sysPacienteHC').getValue();
                                    Ext.getCmp('gridHistorialEvoluciones').store.load({
                                        params: {
                                            pEmpresa: Ext.getCmp('sysEmpresaHC').getValue(),
                                            pPaciente: Ext.getCmp('sysIdPacienteHC').getValue()
                                        }
                                    });
                                    cmpResumenHC.show();
                                }
                            }
                        },
                        {
                            xtype: 'tbfill'
                        },
                        {
                            xtype: 'tbseparator'
                        },
                        {
                            xtype: 'button',
                            text: 'Guardar Evolución',
                            iconCls: 'btnGuardar',
                            id: 'btnGuardarEvolucion',
                            listeners:{
                                click : function(){
                                    if (Ext.getCmp('sysYaGuardoHC').getValue() == 0) 
                                    {
                                        Ext.Msg.show({
                                            title: 'eOfiClinic',
                                            msg: 'Esta seguro que desea Guardar la evolución?',
                                            buttons: Ext.Msg.YESNO,
                                            icon: Ext.Msg.QUESTION,
                                            fn: function(btn)
                                            {
                                                if(btn=="yes")
                                                {
                                                    fnGuardarRegistros();
                                                }
                                            }
                                        });
                                    }else{
                                        Ext.Msg.show({
                                            title: 'eOfiClinic',
                                            msg: 'Esta seguro que desea Modificar la evolución?',
                                            buttons: Ext.Msg.YESNO,
                                            icon: Ext.Msg.QUESTION,
                                            fn: function(btn)
                                            {
                                                if(btn=="yes")
                                                {
                                                    fnModificarRegistros();
                                                }
                                            }
                                        });
                                    }
                                }
                            }
                        }
                    ]
                }
            }
        ];
        winHCConrolAlcoholSpa001Ui.superclass.initComponent.call(this);
    }
});

function fnGuardarRegistros(){
    var frm = Ext.getCmp('frmHC').getForm();
    if (frm.isValid())
    {
        var listacampos = ExtraerCamposFrmHC(frm);
        frm.submit({
            url: '../../controlador/asistencial/evolucionhc.php',
            params:{
                task: 'guardar',
                CAMPOS: listacampos,
                pEmpresa: Ext.getCmp('sysEmpresaHC').getValue(),
                pIPS: Ext.getCmp('sysIPSHC').getValue(),
                pPaciente: Ext.getCmp('sysIdPacienteHC').getValue(),
                pProfesional: Ext.getCmp('sysProfesionalHC').getValue(),
                pCAS: Ext.getCmp('sysCASHC').getValue(),
                pidPlantillaHC : Ext.getCmp('sysIdCodPlantillaHC').getValue(),
                pFechaAtencion: Ext.getCmp('sysFechaHC').getValue(),
                pHoraApertura: Ext.getCmp('sysAperturaHC').getValue(),
                pActividad: Ext.getCmp('sysActividadHC').getValue(),
                pPlantilla: Ext.getCmp('sysPlantillaHC').getValue(),
                pRutaRptHC: Ext.getCmp('sysRutaRptHC').getValue(),
                pRutaRptMx: Ext.getCmp('sysRutaRptMx').getValue(),
                pRutaRptExa: Ext.getCmp('sysRutaRptExa').getValue(),
                pRutaRptRem: Ext.getCmp('sysRutaRptRem').getValue(),
                pDiagppal: Ext.getCmp('sysDiagPpalHC').getValue(),
                pDiagrel1: Ext.getCmp('sysDiagRel1HC').getValue(),
                pDiagrel2: Ext.getCmp('sysDiagRel2HC').getValue(),
                pDiagrel3: Ext.getCmp('sysDiagRel3HC').getValue(),
                pTipodiag: Ext.getCmp('sysTipoDiagosticoHC').getValue(),
                pFinalidad: Ext.getCmp('sysFinalidadConsultaHC').getValue(),
                pCausa: Ext.getCmp('sysCausaExternaHC').getValue(),
                pUsuario: Ext.getCmp('sysUsuarioHC').getValue(),
                pIdCliente: Ext.getCmp('sysIdClienteHC').getValue(),
                pIdPlan: Ext.getCmp('sysIdPlanHC').getValue(),
                pIdSubPlan: Ext.getCmp('sysIdSubPlanHC').getValue(),
                pIdContrato: Ext.getCmp('sysIdContratoHC').getValue(),
                pConsecutivoDetalle: Ext.getCmp('sysConsecutivoDetalleHC').getValue()
            },
            success: function(res,req)
            {
                switch(req.result.requestedId){
                    case "1":
                        Ext.MessageBox.show({
                            title: 'Guardar',
                            msg: 'Se Guardo la Información con Exito.',
                            buttons: Ext.MessageBox.OK,
                            icon: Ext.MessageBox.INFO
                        });
                        Ext.getCmp('sysYaGuardoHC').setValue(1); 
                        break;

                    default:
                        Ext.MessageBox.show({
                            title: 'Guardar',
                            msg: 'Ocurrio un error al guardar, la llave principal no es valida o no se pudo establecer conexión con el servidor.',
                            buttons: Ext.MessageBox.OK,
                            icon: Ext.MessageBox.ERROR
                        });
                        break;
                }
            },
            failure: function(response,options)
            {
                Ext.MessageBox.show({
                    title: 'Guardar',
                    msg: 'Ocurrio un error al guardar o no se pudo establecer conexión con el servidor.',
                    buttons: Ext.MessageBox.OK,
                    icon: Ext.MessageBox.ERROR
                });
            }
        });
    }else{
        Ext.MessageBox.show({
            title: 'Guardar',
            msg: 'Por favor verifique que todos los campos obligatorios estén diligenciados.',
            buttons: Ext.MessageBox.OK,
            icon: Ext.MessageBox.ERROR
        });
    }
}

function fnModificarRegistros(){
    var frm = Ext.getCmp('frmHC').getForm();
    if (frm.isValid())
    {
        var listacampos = ExtraerCamposFrmHC(frm);
        frm.submit({
            url: '../../controlador/asistencial/evolucionhc.php',
            params:{
                task: 'modificar',
                CAMPOS: listacampos,
                pEmpresa: Ext.getCmp('sysEmpresaHC').getValue(),
                pIPS: Ext.getCmp('sysIPSHC').getValue(),
                pPaciente: Ext.getCmp('sysIdPacienteHC').getValue(),
                pProfesional: Ext.getCmp('sysProfesionalHC').getValue(),
                pCAS: Ext.getCmp('sysCASHC').getValue(),
                pFechaAtencion: Ext.getCmp('sysFechaHC').getValue(),
                pHoraApertura: Ext.getCmp('sysAperturaHC').getValue(),
                pActividad: Ext.getCmp('sysActividadHC').getValue(),
                pPlantilla: Ext.getCmp('sysPlantillaHC').getValue(),
                pRutaRptHC: Ext.getCmp('sysRutaRptHC').getValue(),
                pRutaRptMx: Ext.getCmp('sysRutaRptMx').getValue(),
                pRutaRptExa: Ext.getCmp('sysRutaRptExa').getValue(),
                pRutaRptRem: Ext.getCmp('sysRutaRptRem').getValue(),
                pDiagppal: Ext.getCmp('sysDiagPpalHC').getValue(),
                pDiagrel1: Ext.getCmp('sysDiagRel1HC').getValue(),
                pDiagrel2: Ext.getCmp('sysDiagRel2HC').getValue(),
                pDiagrel3: Ext.getCmp('sysDiagRel3HC').getValue(),
                pTipodiag: Ext.getCmp('sysTipoDiagosticoHC').getValue(),
                pFinalidad: Ext.getCmp('sysFinalidadConsultaHC').getValue(),
                pCausa: Ext.getCmp('sysCausaExternaHC').getValue(),
                pUsuario: Ext.getCmp('sysUsuarioHC').getValue(),
                pIdCliente: Ext.getCmp('sysIdClienteHC').getValue(),
                pIdPlan: Ext.getCmp('sysIdPlanHC').getValue(),
                pIdSubPlan: Ext.getCmp('sysIdSubPlanHC').getValue(),
                pIdContrato: Ext.getCmp('sysIdContratoHC').getValue(),
                pConsecutivoDetalle: Ext.getCmp('sysConsecutivoDetalleHC').getValue()
            },
            success: function(res,req)
            {
                switch(req.result.requestedId){
                    case "1":
                        Ext.MessageBox.show({
                            title: 'Guardar',
                            msg: 'Se Guardo la Información con Exito.',
                            buttons: Ext.MessageBox.OK,
                            icon: Ext.MessageBox.INFO
                        });
                        Ext.getCmp('sysYaGuardoHC').setValue(1);
                        break;

                    default:
                        Ext.MessageBox.show({
                            title: 'Guardar',
                            msg: 'Ocurrio un error al guardar, la llave principal no es valida o no se pudo establecer conexión con el servidor.',
                            buttons: Ext.MessageBox.OK,
                            icon: Ext.MessageBox.ERROR
                        });
                        break;
                }
            },
            failure: function(response,options)
            {
                Ext.MessageBox.show({
                    title: 'Guardar',
                    msg: 'Ocurrio un error al guardar o no se pudo establecer conexión con el servidor.',
                    buttons: Ext.MessageBox.OK,
                    icon: Ext.MessageBox.ERROR
                });
            }
        });
    }else{
        Ext.MessageBox.show({
            title: 'Guardar',
            msg: 'Por favor verifique que todos los campos obligatorios estén diligenciados.',
            buttons: Ext.MessageBox.OK,
            icon: Ext.MessageBox.ERROR
        });
    }
}
