/*
* @category    Programacion Eventos Formulario Profesionales
* @package     OfiClinic Web
* @author      Jorge Ancizar Galeano Ruiz<desarrollo@ofisalud.com>
* @copyright   2010 Jorge Ancizar GAleano Ruiz
* @version     OfiClinic Web 1.0
* @license     COMERCIAL
* @link        http://www.ofisalud.com
* @country     Colombia
* @telephone   3016398114
*/


winFrmRadicaCitaEsp = Ext.extend(winFrmRadicaCitaEspUi, {
    initComponent: function() {
        winFrmRadicaCitaEsp.superclass.initComponent.call(this);
        el = Ext.get('idempresa');
        ID_EMPRESA = el.getValue();
        el = Ext.get('idsede');
        ID_SEDE = el.getValue();
        el = Ext.get('idips');
        ID_IPS = el.getValue();
        el = Ext.get('idusuario');
        ID_USUARIO = el.getValue();
        el = Ext.get('idperfil');
        ID_PERFIL = el.getValue();
        
        BD_MULTIPRESTADOR = "NA";
        
        CODPROCED_SELECCIONADO = "NA";
        DESPROCED_SELECCIONADO = "NA";
        TARPROCED_SELECCIONADO = 0;
        
        stOpcionesSistema = new StoreOpcionesSistema();
        stOpcionesSistema.load({
            params: { 'pPerfil': ID_PERFIL }
        });
        
        var btnNuevoAgendaManual = Ext.getCmp('btnNuevoAgendaManual').on("click",this.NuevoPacienteAgendaManual,this);
        var fFecNac = Ext.getCmp('fecFecNac').on("Blur",this.MostrarEdadAgendaManual,this);
        var btnBuscarPacienteAgendaManual = Ext.getCmp('btnBuscarPacienteAgendaManual').on("click",this.BuscarPacienteAgendaManual,this);
        var intClienteAsignaCita = Ext.getCmp('intClienteAsignaCita').on("select",this.CargarPlanesCliente,this);
        var intClienteAsignaCita1 = Ext.getCmp('intClienteAsignaCita').on("change",this.ChangePlanesCliente,this);
        var intClientePlanAsignaCita = Ext.getCmp('intClientePlanAsignaCita').on("select",this.CargarSubPlanesCliente,this);
        var intClientePlanAsignaCita1 = Ext.getCmp('intClientePlanAsignaCita').on("change",this.ChangeSubPlanesCliente,this);
        var btn_AdicionarItemAgendaManual = Ext.getCmp('btn_AdicionarItemAgendaManual').on("click",this.GuardarItemAgendaManual,this);
        var btn_ModificarItemAgendaManual = Ext.getCmp('btn_ModificarItemAgendaManual').on("click",this.ModificarItemAgendaManual,this);
        var btn_RadicarCitaItemAgendaManual = Ext.getCmp('btn_RadicarCitaItemAgendaManual').on("click",this.RadicarCita,this);
        var strEspecialidadAsignaCita = Ext.getCmp('strEspecialidadAsignaCita').on("select",this.BuscarHistorialCitasxEspecialidad,this);
        var strTipoAtencionAsignaCita = Ext.getCmp('strTipoAtencionAsignaCita').on("select",this.CambiarTipoCita,this);
        var strDocID = Ext.getCmp('strDocID').on("specialkey",this.ValidarNumeroDocumentoPacSK,this);
        var TieneCitaTramite = 0;
        Ext.getCmp('btn_ModificarItemAgendaManual').setVisible(false);
        Ext.getCmp('pnEstaEmbarazo').setVisible(false);
        
    },
    ValidarNumeroDocumentoPacSK: function(f,e){
        if (e.getKey() == e.ENTER || e.getKey() == e.TAB)
        {
            Ext.getCmp('sysPacienteValido').setValue(0);
            Ext.getCmp('strGenero').setValue(null);
            Ext.getCmp('strApe1').setValue(null);
            Ext.getCmp('strApe2').setValue(null);
            Ext.getCmp('strNom1').setValue(null);
            Ext.getCmp('strNom2').setValue(null);
            Ext.getCmp('fecFecNac').setValue(null);
            Ext.getCmp('strEdad').setValue(null);
            Ext.getCmp('strDeptoMuni').setValue(null);
            Ext.getCmp('strDireccion').setValue(null);
            Ext.getCmp('strTel1').setValue(null);
            Ext.getCmp('strTel2').setValue(null);
            Ext.getCmp('strZona').setValue(null);
            Ext.getCmp('strEmail').setValue(null);
            Ext.getCmp('intIdPaciente').setValue(0);
            Ext.getCmp('sysCitaTramite').setValue(1);
            Ext.getCmp('strEspecialidadAsignaCita').setValue(null);
            Ext.Msg.wait('Cargando Información del Paciente... por favor espere!');
            Ext.Ajax.request(
            {
                url: '../../controlador/pacientes/pacientes_cargardatos.php',
                params:{
                    pTdoc: Ext.getCmp('strTdoc').getValue(),
                    pDocumento: f.getValue()
                },
                success: function(response,options)
                {
                    var el = Ext.get('response'); // get the LOG
                    var Respuesta = response.responseText;
                    var Contenido = Respuesta.split('^');
                    if(Contenido[0]=="" || Contenido[0]== "{success:false}" || Contenido[0]== null){
                        Ext.Msg.hide();
                        Ext.getCmp('intIdPaciente').setValue(0);
                        verListadoAtencion(ID_EMPRESA, ID_SEDE, ID_IPS, Ext.getCmp('strTdoc').getValue(), Ext.getCmp('strDocID').getValue(),true,Ext.getCmp('intIdPaciente').getValue(),"RadicarCitasEsp");
                    } else {
                        Ext.Msg.hide();
                        Ext.getCmp('intIdPaciente').setValue(Contenido[0]);
                        Ext.getCmp('strTdoc').setValue(Contenido[1]);
                        Ext.getCmp('strGenero').setValue(Contenido[9]);
                        Ext.getCmp('strApe1').setValue(PonerAcentosMayusculas(Contenido[3]));
                        Ext.getCmp('strApe2').setValue(PonerAcentosMayusculas(Contenido[4]));
                        Ext.getCmp('strNom1').setValue(PonerAcentosMayusculas(Contenido[5]));
                        Ext.getCmp('strNom2').setValue(PonerAcentosMayusculas(Contenido[6]));
                        Ext.getCmp('strEdad').setValue(Contenido[8]);
                        Ext.getCmp('strDeptoMuni').setValue(Contenido[15]);
                        Ext.getCmp('strDireccion').setValue(PonerAcentosMayusculas(Contenido[10]));
                        Ext.getCmp('strZona').setValue(Contenido[11]);
                        Ext.getCmp('strTel1').setValue(PonerAcentosMayusculas(Contenido[12]));
                        Ext.getCmp('strTel2').setValue(PonerAcentosMayusculas(Contenido[13]));
                        Ext.getCmp('strEmail').setValue(PonerAcentosMayusculas(Contenido[14]));
                        if (Contenido[7] != null && Contenido[7] != "")
                        {
                            var xfecnac = Array();
                            xfecnac = Contenido[7].split('-');
                            var dianac = xfecnac[0];
                            var mesnac = (xfecnac[1].length < 2)?'0':'';
                            mesnac += xfecnac[1];
                            var anonac = xfecnac[2];
                            Ext.getCmp('fecFecNac').setValue(dianac + "-" + mesnac + "-" + anonac);
                            //Ext.getCmp('strEdad').setValue(MostrarEdadCompleta(new Date().format('Y/m/d'),Ext.getCmp('fecFecNac_citas').getValue().format('Y/m/d')));
                        }
                        Ext.getCmp('sysPacienteValido').setValue(1);
                        Ext.getCmp('btn_AdicionarItemAgendaManual').setVisible(false);
                        Ext.getCmp('btn_ModificarItemAgendaManual').setVisible(true);
                        verListadoAtencion(ID_EMPRESA, ID_SEDE, ID_IPS, Ext.getCmp('strTdoc').getValue(), Ext.getCmp('strDocID').getValue(),true,Ext.getCmp('intIdPaciente').getValue(),"RadicarCitasEsp");
                    }
                },
                failure: function(response,options){
                    var el = Ext.get('response');
                    alert("error al comunicarse con el servidor.");
                },
                scope:this 
            });
        }
    },
    CambiarTipoCita: function(cmb, rec, idx) {
        if(cmb.getValue() == null || cmb.getValue() == ""){
            Ext.getCmp('intControlEn').setValue(null);
            Ext.getCmp('strControlEn').setValue(null);
            Ext.getCmp('intControlEn').allowBlank = true;
            Ext.getCmp('strControlEn').allowBlank = true;
            Ext.getCmp('intControlEn').clearInvalid();
            Ext.getCmp('strControlEn').clearInvalid();
            Ext.getCmp('intControlEn').disable();
            Ext.getCmp('strControlEn').disable();
        }else{
            if(cmb.getValue() != "CONTROL"){
                Ext.getCmp('intControlEn').setValue(null);
                Ext.getCmp('strControlEn').setValue(null);
                Ext.getCmp('intControlEn').allowBlank = true;
                Ext.getCmp('strControlEn').allowBlank = true;
                Ext.getCmp('intControlEn').clearInvalid();
                Ext.getCmp('strControlEn').clearInvalid();
                Ext.getCmp('intControlEn').disable();
                Ext.getCmp('strControlEn').disable();
            }else{
                Ext.getCmp('intControlEn').enable();
                Ext.getCmp('strControlEn').enable();
                Ext.getCmp('intControlEn').allowBlank = false;
                Ext.getCmp('strControlEn').allowBlank = false;
            }
        }
    },
    BuscarHistorialCitasxEspecialidad:  function(cmb, rec, idx) {
        if(cmb.getValue() != null && cmb.getValue() != ""){
            if(Ext.getCmp('intIdPaciente').getValue() != null && Ext.getCmp('intIdPaciente').getValue() != 0){
                TieneCitaTramite = 0;
                Ext.getCmp('sysCitaTramite').setValue(0);
                Ext.Ajax.request({
                    waitMsg: 'Por favor Espere...',
                    url: "../../controlador/asignarcitasesp/controlador_asignarcitasesp.php",
                    params: {
                        task: "VALIDAR_RADICARCITA",
                        pEmpresa: ID_EMPRESA,
                        pIPS: ID_IPS, 
                        pPaciente: Ext.getCmp('intIdPaciente').getValue(),
                        pEspecialidad: Ext.getCmp('strEspecialidadAsignaCita').getValue()
                    },
                    success: function(response)
                    {
                        var result = response.responseText.split("^");
                        if (result[0] > 0){
                            TieneCitaTramite = 1;
                            Ext.getCmp('sysCitaTramite').setValue(1);
                        }else{
                            TieneCitaTramite = 0;
                            Ext.getCmp('sysCitaTramite').setValue(0);
                        }
                    },
                    failure: function(response){
                        var result = response.responseText;
                        Ext.MessageBox.show({
                            title: 'Error Base Datos',
                            msg: 'Error de conexión - No podemos validar la informacion en estos momentos',
                            buttons: Ext.MessageBox.OK,
                            icon: Ext.MessageBox.ERROR
                        });
                    },
                    callback: function(){
                        var winFrmHistorialCitaRadicadas = new winFrmHistorialCitaRadicadasUi();
                        Ext.getCmp('gridHistorialCitasRadicada').store.load({
                            params: {
                                task: 'HISTORIAL_CITAS_RADICADAS',
                                pEmpresa: ID_EMPRESA,
                                pIPS: ID_IPS, 
                                pPaciente: Ext.getCmp('intIdPaciente').getValue(),
                                pEspecialidad: Ext.getCmp('strEspecialidadAsignaCita').getValue(),
                                pRangoFechas1Mes: "SI", 
                                pRangoFechas: "NO"
                            }
                        });
                        winFrmHistorialCitaRadicadas.show();
                        if(TieneCitaTramite == 1){
                            Ext.MessageBox.show({
                                title: 'Error',
                                msg: 'El Paciente tiene actualmente una cita radicada para esta especialidad y esta en tramite de asignacion.',
                                buttons: Ext.MessageBox.OK,
                                icon: Ext.MessageBox.ERROR
                            });
                        }
                    }
                });
            }
        }
    },
    RadicarCita: function(){
        if (Ext.getCmp('sysPacienteValido').getValue() != 0 && Ext.getCmp('intClienteAsignaCita').getValue() != null && Ext.getCmp('intClienteAsignaCita').getValue() != "" && Ext.getCmp('strEspecialidadAsignaCita').getValue() != null && Ext.getCmp('strEspecialidadAsignaCita').getValue() != "" && Ext.getCmp('strTel1').getValue() != null && Ext.getCmp('strTel1').getValue() != ""){
            if(Ext.getCmp('sysCitaTramite').getValue() == 1){
                Ext.MessageBox.show({
                    title: 'Error',
                    msg: 'El Paciente tiene actualmente una cita radicada para esta especialidad y esta en tramite de asignacion. NO SE PUEDEN RADICAR MAS CITAS',
                    buttons: Ext.MessageBox.OK,
                    icon: Ext.MessageBox.ERROR
                });
            }else{
                Ext.Msg.show({
                    title: 'eOfiClinic',
                    msg: 'Esta seguro que desea radicar la cita?',
                    buttons: Ext.Msg.YESNO,
                    icon: Ext.Msg.QUESTION,
                    fn: function(btn)
                    {
                        if(btn=="yes")
                        {
                            Ext.Ajax.request({
                                waitMsg: 'Por favor Espere...',
                                url: "../../controlador/asignarcitasesp/controlador_asignarcitasesp.php",
                                params: {
                                    task: "AGENDA_MANUAL_RADICARCITA",
                                    pEmpresa: ID_EMPRESA,
                                    pSEDE: ID_SEDE, 
                                    pIPS: ID_IPS, 
                                    pPaciente: Ext.getCmp('intIdPaciente').getValue(),
                                    pCliente: Ext.getCmp('intClienteAsignaCita').getValue(),
                                    pPlan: Ext.getCmp('intClientePlanAsignaCita').getValue(),
                                    pSubPlan: Ext.getCmp('intClienteSubPlanAsignaCita').getValue(),
                                    pContrato: Ext.getCmp('intClienteContratoAsignaCita').getValue(),
                                    pEspecialidad: Ext.getCmp('strEspecialidadAsignaCita').getValue(),
                                    pFechaAtendieron: Ext.getCmp('fecFechaAtendieronAsignaCita').getValue(),
                                    pTipoRegistro: Ext.getCmp('strTipoAtencionAsignaCita').getValue(),
                                    pPeriodoControlInt: Ext.getCmp('intControlEn').getValue(),
                                    pPeriodoControlStr: Ext.getCmp('strControlEn').getValue(),
                                    pObservaciones: Ext.getCmp('memObservacionAsignaCita').getValue(),
                                    pUsuario: ID_USUARIO
                                },
                                success: function(response)
                                {
                                    var result = response.responseText.split("^");
                                    if (result[0] > 0)
                                    {
                                        var html = '<table><tr><td width="50"><img src="../../../resources/varios/citas.png" alt=""/></td><td width="10">&nbsp</td><td style="padding 10px;"><h1 style="color: #2E2EFE; font-size: 14px;">Se Radico la Citas con exito..!</h1></td></tr></table>';
                                        Sexy.info(html);
                                        var frm = Ext.getCmp('frmPacientesCitaManual').getForm();
                                        frm.reset();
                                        frm.clearInvalid();
                                        Ext.getCmp('intIdPaciente').setValue(0);
                                        Ext.getCmp('btn_AdicionarItemAgendaManual').setVisible(true);
                                        Ext.getCmp('btn_ModificarItemAgendaManual').setVisible(false);
                                        Ext.getCmp('intClienteAsignaCita').setValue(null);
                                        Ext.getCmp('intClientePlanAsignaCita').setValue(null);
                                        Ext.getCmp('intClienteSubPlanAsignaCita').setValue(null);
                                        Ext.getCmp('intClienteContratoAsignaCita').setValue(null);
                                        Ext.getCmp('strEspecialidadAsignaCita').setValue(null);
                                        Ext.getCmp('fecFechaAtendieronAsignaCita').setValue(null);
                                        Ext.getCmp('strTipoAtencionAsignaCita').setValue(null);
                                        Ext.getCmp('memObservacionAsignaCita').setValue(null);
                                        Ext.getCmp('sysCitaTramite').setValue(1);
                                    }else{
                                        Ext.MessageBox.show({
                                            title: 'Error',
                                            msg: 'No podemos radicar la cita en estos momentos',
                                            buttons: Ext.MessageBox.OK,
                                            icon: Ext.MessageBox.ERROR
                                        });
                                    }
                                },
                                failure: function(response){
                                    var result = response.responseText;
                                    Ext.MessageBox.show({
                                        title: 'Error Base Datos',
                                        msg: 'Error de conexión - No podemos radicar la cita en estos momentos',
                                        buttons: Ext.MessageBox.OK,
                                        icon: Ext.MessageBox.ERROR
                                    });
                                }
                            });
                        }
                    }
                });
            }
        }else{
            Ext.MessageBox.show({
                title: 'Error',
                msg: 'Verifique que los campos obligatorios estan diligenciados y/o el paciente este creado.',
                buttons: Ext.MessageBox.OK,
                icon: Ext.MessageBox.ERROR
            });
        }
    },
    ModificarItemAgendaManual: function(){ //ok
        Ext.Msg.show({
            title: 'Guardar Pacientes',
            msg: 'Esta Seguro que Desea Guardar la Información?',
            buttons: Ext.Msg.YESNO,
            icon: Ext.Msg.QUESTION,
            fn: function(btn)
            {
                if(btn=="yes")
                {
                    fnGuardarRegistrosAgendaManual("MODIFICAR","NO","winFrmRadicaCitaEsp","frmPacientesCitaManual","../../controlador/pacientes/controlador_agendamanual.php","NA","NA","NA","NO","NO");
                }
            }
        });
    },
    GuardarItemAgendaManual: function(){ //ok
        Ext.Msg.show({
            title: 'Guardar Pacientes',
            msg: 'Esta Seguro que Desea Guardar la Información?',
            buttons: Ext.Msg.YESNO,
            icon: Ext.Msg.QUESTION,
            fn: function(btn)
            {
                if(btn=="yes")
                {
                    fnInsertarRegistrosAgendaManual("INSERTAR","SI","winAsignarCitaManualUi","frmPacientesCitaManual","../../controlador/pacientes/controlador_agendamanual.php","NA");
                }
            }
        });
    },
    ChangePlanesCliente: function(f,newValue,oldValue){
        if(newValue == null || newValue == ""){
            Ext.getCmp('intClientePlanAsignaCita').store.removeAll(true);
            Ext.getCmp('intClienteSubPlanAsignaCita').store.removeAll(true);
            Ext.getCmp('intProcedAsignaCita').store.removeAll(true);
            Ext.getCmp('intClientePlanAsignaCita').setValue(null);
            Ext.getCmp('intClienteSubPlanAsignaCita').setValue(null);
            Ext.getCmp('intClientePlanAsignaCita').disable();
            Ext.getCmp('intClienteSubPlanAsignaCita').disable();
            Ext.getCmp('intClienteContratoAsignaCita').disable();
        }
    },
    ChangeSubPlanesCliente: function(f,newValue,oldValue){
        if(newValue == null || newValue == ""){
            Ext.getCmp('intClienteSubPlanAsignaCita').store.removeAll(true);
            Ext.getCmp('intClienteSubPlanAsignaCita').setValue(null);
            Ext.getCmp('intClienteSubPlanAsignaCita').disable();
        }
    },
    CargarPlanesCliente: function(cmb, rec, idx) {
        if(cmb.getValue() == null || cmb.getValue() == ""){
            Ext.getCmp('intClientePlanAsignaCita').store.removeAll(true);
            Ext.getCmp('intClienteSubPlanAsignaCita').store.removeAll(true);
            Ext.getCmp('intConceptoAsignaCita').store.removeAll(true);
            Ext.getCmp('intClientePlanAsignaCita').setValue(null);
            Ext.getCmp('intClienteSubPlanAsignaCita').setValue(null);
            Ext.getCmp('intConceptoAsignaCita').setValue(null);
            Ext.getCmp('intClientePlanAsignaCita').disable();
            Ext.getCmp('intClienteSubPlanAsignaCita').disable();
            Ext.getCmp('intConceptoAsignaCita').disable();
        }else{
            Ext.getCmp('intClientePlanAsignaCita').store.removeAll(true);
            Ext.getCmp('intClienteSubPlanAsignaCita').store.removeAll(true);
            Ext.getCmp('intConceptoAsignaCita').store.removeAll(true);
            Ext.getCmp('intConceptoAsignaCita').setValue(null);
            Ext.getCmp('intClientePlanAsignaCita').setValue(null);
            Ext.getCmp('intClienteSubPlanAsignaCita').setValue(null);
            Ext.getCmp('intClienteSubPlanAsignaCita').disable();
            Ext.getCmp('intClientePlanAsignaCita').store.load({
                params:{
                    pCliente: cmb.getValue()
                },
                callback: function(){
                    Ext.getCmp('intClientePlanAsignaCita').enable();
                }
            });
            Ext.getCmp('intClienteContratoAsignaCita').store.load({
                params:{
                    pCliente: cmb.getValue()
                },
                callback: function(){
                    Ext.getCmp('intClienteContratoAsignaCita').enable();
                }
            });
            Ext.getCmp('intConceptoAsignaCita').store.load({
                params:{
                    pCliente: cmb.getValue(),
                    pIPS: ID_IPS
                },
                callback: function(){
                    Ext.getCmp('intConceptoAsignaCita').enable();
                }
            });
        }
    },
    CargarSubPlanesCliente: function(cmb, rec, idx) {
        if(cmb.getValue() == null || cmb.getValue() == ""){
            Ext.getCmp('intClienteSubPlanAsignaCita').setValue(null);
            Ext.getCmp('intClienteSubPlanAsignaCita').store.removeAll(true);
            Ext.getCmp('intClienteSubPlanAsignaCita').disable();
        }else{
            Ext.getCmp('intClienteSubPlanAsignaCita').setValue(null);
            Ext.getCmp('intClienteSubPlanAsignaCita').store.removeAll(true);
            Ext.getCmp('intClienteSubPlanAsignaCita').store.load({
                params:{
                    pPlan: cmb.getValue()
                },
                callback: function(){
                    Ext.getCmp('intClienteSubPlanAsignaCita').enable();
                }
            });
        }
    },
    NuevoPacienteAgendaManual: function(){
        Ext.Msg.show({
            title: 'Nuevo Registro',
            msg: 'Esta seguro que desea hacer un nuevo registro, si hace este se perdera la información ingresada hasta ahora',
            buttons: Ext.Msg.YESNO,
            icon: Ext.Msg.QUESTION,
            fn: function(btn)
            {
                if(btn=="yes")
                {
                    var frm = Ext.getCmp('frmPacientesCitaManual').getForm();
                    frm.reset();
                    frm.clearInvalid();
                    Ext.getCmp('intIdPaciente').setValue(0);
                    Ext.getCmp('btn_AdicionarItemAgendaManual').setVisible(true);
                    Ext.getCmp('btn_ModificarItemAgendaManual').setVisible(false);
                }
            }
        });
    },
    BuscarPacienteAgendaManual: function(){
        buscarpacienteagendamanual();
    },
    MostrarEdadAgendaManual: function(f) {
        Ext.getCmp('strEdad').setValue(MostrarEdadCompleta(new Date().format('Y/m/d'),f.getValue().format('Y/m/d')));
    }
});


function fnInsertarRegistrosAgendaManual(pAccion,pCerrar,pWin,pForm,URL,pGrid,arrParam,pCampoLlave,pCampoTextoLlave, pLimpiarForm, pCambiarBotones){
    var frm = Ext.getCmp(pForm).getForm();
    if (frm.isValid())
    {
        var listacampos = ExtraerCamposFrm(frm);
        frm.submit({
            waitMsg: 'Por favor Espere...',
            url: URL,
            params:{
                task: pAccion,
                CAMPOS: listacampos
            },
            success: function(res,req)
            {
                var Respuesta = req.result.requestedId;
                var Contenido = Respuesta.split('^');
                if(Contenido[0]=="0" || Contenido[0]=="" || Contenido[0]== "{success:false}" || Contenido[0]== null){
                    Ext.getCmp('intIdPaciente').setValue(0);
                    Ext.getCmp('sysPacienteValido').setValue(0);
                    Ext.Msg.hide();
                    Ext.MessageBox.show({
                        title: 'Guardando Paciente',
                        msg: 'Ocurrio un error al guardar la información del paciente o no se pudo establecer conexión con el servidor.',
                        buttons: Ext.MessageBox.OK,
                        icon: Ext.MessageBox.ERROR
                    });
                } else {
                    Ext.getCmp('intIdPaciente').setValue(Contenido[0]);
                    Ext.getCmp('sysPacienteValido').setValue(1);
                    Ext.getCmp('btn_AdicionarItemAgendaManual').setVisible(false);
                    Ext.getCmp('btn_ModificarItemAgendaManual').setVisible(true);
                    Ext.MessageBox.hide();
                    Ext.MessageBox.show({
                        title: 'Guardar',
                        msg: 'Se Guardo la Información con Exito.',
                        buttons: Ext.MessageBox.OK,
                        icon: Ext.MessageBox.INFO
                    });
                }
            },
            failure: function(response,options)
            {
                Ext.MessageBox.hide();
                Ext.MessageBox.show({
                    title: 'Guardar',
                    msg: 'Ocurrio un error al guardar o no se pudo establecer conexión con el servidor.',
                    buttons: Ext.MessageBox.OK,
                    icon: Ext.MessageBox.ERROR
                });
            }
        });
    }else{
        Ext.MessageBox.hide();
        Ext.MessageBox.show({
            title: 'Guardar',
            msg: 'Por favor verifique que todos los campos obligatorios estén diligenciados.',
            buttons: Ext.MessageBox.OK,
            icon: Ext.MessageBox.ERROR
        });
    }
}

                                                
function fnGuardarRegistrosAgendaManual(pAccion,pCerrar,pWin,pForm,URL,pGrid,arrParam,pCampoLlave,pCampoTextoLlave, pLimpiarForm, pCambiarBotones){
    var frm = Ext.getCmp(pForm).getForm();
    if (frm.isValid())
    {
        var listacampos = ExtraerCamposFrm(frm);
        frm.submit({
            waitMsg: 'Por favor Espere...',
            url: URL,
            params:{
                task: pAccion,
                CAMPOS: listacampos
            },
            success: function(res,req)
            {
                switch(req.result.requestedId){
                    case "1":
                        Ext.MessageBox.hide();
                        Ext.MessageBox.show({
                            title: 'Guardar',
                            msg: 'Se Guardo la Información con Exito.',
                            buttons: Ext.MessageBox.OK,
                            icon: Ext.MessageBox.INFO
                        });
                        if (typeof pLimpiarForm != 'undefined')
                        {
                            if (pLimpiarForm == "SI")
                                frm.reset();
                        }else{
                            frm.reset();
                        }
                        if (typeof pGrid != 'undefined')
                        {
                            if (pGrid != 'NA')
                            {
                                Ext.getCmp(pGrid).store.reload(arrParam);
                            }
                        }
                        if (typeof pCampoLlave != 'undefined')
                        {
                            if (pCampoLlave != 'NA')
                            {
                                Ext.getCmp(pCampoLlave).setValue(req.result.Data);
                                if (typeof pCampoTextoLlave != 'undefined')
                                    Ext.getCmp(pCampoTextoLlave).setValue("Tarjeta Nro: " + req.result.Data);
                            }
                        }
                        if (typeof pCambiarBotones != 'undefined')
                        {
                            if (pCambiarBotones == 'SI')
                            {
                                Ext.getCmp('btnGuardarDatosBasicosTarjeta').setVisible(false);
                                Ext.getCmp('btnModificarDatosBasicosTarjeta').setVisible(true);
                            }
                        }
                        if(pCerrar == "SI")
                        {
                            Ext.getCmp(pWin).close();
                        }
                        break;

                    default:
                        Ext.MessageBox.hide();
                        Ext.MessageBox.show({
                            title: 'Guardar',
                            msg: 'Ocurrio un error al guardar, la llave principal no es valida o no se pudo establecer conexión con el servidor.',
                            buttons: Ext.MessageBox.OK,
                            icon: Ext.MessageBox.ERROR
                        });
                        break;
                }
            },
            failure: function(response,options)
            {
                Ext.MessageBox.hide();
                Ext.MessageBox.show({
                    title: 'Guardar',
                    msg: 'Ocurrio un error al guardar o no se pudo establecer conexión con el servidor.',
                    buttons: Ext.MessageBox.OK,
                    icon: Ext.MessageBox.ERROR
                });
            }
        });
    }else{
        Ext.MessageBox.hide();
        Ext.MessageBox.show({
            title: 'Guardar',
            msg: 'Por favor verifique que todos los campos obligatorios estén diligenciados.',
            buttons: Ext.MessageBox.OK,
            icon: Ext.MessageBox.ERROR
        });
    }
}