/*
* @category    Programacion Eventos Formulario Profesionales
* @package     OfiClinic Web
* @author      Jorge Ancizar Galeano Ruiz<desarrollo@ofisalud.com>
* @copyright   2010 Jorge Ancizar GAleano Ruiz
* @version     OfiClinic Web 1.0
* @license     COMERCIAL
* @link        http://www.ofisalud.com
* @country     Colombia
* @telephone   3016398114
*/


winFrmConfirmacionCitaEsp = Ext.extend(winFrmConfirmacionCitaEspUi, {
    initComponent: function() {
        winFrmConfirmacionCitaEsp.superclass.initComponent.call(this);
        el = Ext.get('idempresa');
        ID_EMPRESA = el.getValue();
        el = Ext.get('idsede');
        ID_SEDE = el.getValue();
        el = Ext.get('idips');
        ID_IPS = el.getValue();
        el = Ext.get('idusuario');
        ID_USUARIO = el.getValue();
        el = Ext.get('idperfil');
        ID_PERFIL = el.getValue();
        BD_MULTIPRESTADOR = "NA";

        
        stOpcionesSistema = new StoreOpcionesSistema();
        stOpcionesSistema.load({
            params: { 'pPerfil': ID_PERFIL }
        });
        
        Ext.getCmp('sysIdEmpresa').setValue(ID_EMPRESA);
        
        var btnBuscarPacienteLegalizacion = Ext.getCmp('btnBuscarPacienteLegalizacion').on("click",this.BuscarPacienteLegaliza,this);
        var btnLimpiarPacienteLegalizacion = Ext.getCmp('btnLimpiarPacienteLegalizacion').on("click",this.LimpiarDatosPaciente,this);
        var btnActualizar = Ext.getCmp('btnActualizar').on("click",this.Actualizar,this);
        var btnCitasxConfirmar = Ext.getCmp('btnCitasxConfirmar').on("click",this.CitasxConfirmar,this);
        var btnCitaRechazada = Ext.getCmp('btnCitaRechazada').on("click",this.CitaRechazada,this);
        var btnAbrirConfirmarCita = Ext.getCmp('btnAbrirConfirmarCita').on("click",this.AbrirConfirmarCita,this);
        var btnVerHistorialCitas_citas = Ext.getCmp('btnVerHistorialCitas_citas').on("click",this.HistorialCitasAsignadas,this);
        var btnSalir = Ext.getCmp('btnSalir').on("click",this.SalirOpcion,this);
    },
    
    CitaRechazada: function(){
        if(Ext.getCmp('gridConfirmacionCitas').selModel.getCount() == 1)
        {
            var selections = Ext.getCmp('gridConfirmacionCitas').selModel.getSelections();
            xCAS = selections[0].json.CAS;
            Ext.Msg.show({
                title: 'eOfiClinic',
                msg: 'La Cita Seleccionada fue Rechazada o Cancelada por el Paciente?',
                buttons: Ext.Msg.YESNO,
                icon: Ext.Msg.QUESTION,
                fn: function(btn)
                {
                    if(btn=="yes")
                    {
                        var winCitaRechazadaPaciente = new winCitaRechazadaPacienteUi();
                        Ext.getCmp('sysCAS').setValue(xCAS);
                        Ext.getCmp('sysIdPaciente').setValue(Ext.getCmp('intPacienteLegalizacion').getValue());
                        Ext.getCmp('sysUsuario').setValue(ID_USUARIO);
                        Ext.getCmp('sysIdAgendaManual').setValue(selections[0].json.Cod);
                        Ext.getCmp('sysProfesionalAgenda').setValue(selections[0].json.Profesional);
                        Ext.getCmp('sysPrimerApellido').setValue(selections[0].json.PrimerApellido);
                        Ext.getCmp('sysSegundoApellido').setValue(selections[0].json.SegundoApellido);
                        Ext.getCmp('sysPrimerNombre').setValue(selections[0].json.PrimerNombre);
                        Ext.getCmp('sysSegundoNombre').setValue(selections[0].json.SegundoNombre);
                        Ext.getCmp('sysSede').setValue(selections[0].json.Sede);
                        Ext.getCmp('sysFecha').setValue(selections[0].json.FechaCita);
                        Ext.getCmp('sysHora').setValue(selections[0].json.HoraCita);
                        winCitaRechazadaPaciente.show();
                    }
                }
            });
        }
    },
    
    AbrirConfirmarCita: function(){
        if(Ext.getCmp('gridConfirmacionCitas').selModel.getCount() == 1)
        {
            var selections = Ext.getCmp('gridConfirmacionCitas').selModel.getSelections();
            xCAS = selections[0].json.CAS;
            Ext.Msg.show({
                title: 'eOfiClinic',
                msg: 'Esta seguro que desea Confirmar la Cita?',
                buttons: Ext.Msg.YESNO,
                icon: Ext.Msg.QUESTION,
                fn: function(btn)
                {
                    if(btn=="yes")
                    {
                        var winConfirmacionCitaPaciente = new winConfirmacionCitaPacienteUi();
                        Ext.getCmp('sysCAS').setValue(xCAS);
                        Ext.getCmp('sysIdPaciente').setValue(Ext.getCmp('intPacienteLegalizacion').getValue());
                        Ext.getCmp('sysUsuario').setValue(ID_USUARIO);
                        Ext.getCmp('sysIdAgendaManual').setValue(selections[0].json.Cod);
                        Ext.getCmp('sysProfesionalAgenda').setValue(selections[0].json.Profesional);
                        Ext.getCmp('sysPrimerApellido').setValue(selections[0].json.PrimerApellido);
                        Ext.getCmp('sysSegundoApellido').setValue(selections[0].json.SegundoApellido);
                        Ext.getCmp('sysPrimerNombre').setValue(selections[0].json.PrimerNombre);
                        Ext.getCmp('sysSegundoNombre').setValue(selections[0].json.SegundoNombre);
                        Ext.getCmp('sysSede').setValue(selections[0].json.Sede);
                        Ext.getCmp('sysFecha').setValue(selections[0].json.FechaCita);
                        Ext.getCmp('sysHora').setValue(selections[0].json.HoraCita);
                        winConfirmacionCitaPaciente.show();
                    }
                }
            });
        }
    },
    LimpiarDatosPaciente: function(){
        Ext.getCmp('intPacienteLegalizacion').setValue(0);
        Ext.getCmp('sysPacienteLegalizacion').setValue(null);
        Ext.getCmp('gridConfirmacionCitas').store.load({
            params: {
                pPaciente: 0
            }
        });
    },
    CitasxConfirmar: function(){
        if (Ext.getCmp('fecAgendaDesde').getValue() == "" || Ext.getCmp('fecAgendaDesde').getValue() == null || Ext.getCmp('strAgendaMunicipio').getValue() == "")
        {
            Ext.MessageBox.show({
                title: 'Error',
                msg: 'Debe Seleccionar el Rango de Fechas y Municipio',
                buttons: Ext.MessageBox.OK,
                icon: Ext.MessageBox.ERROR
            });
            
        }else{
            Ext.getCmp('gridConfirmacionCitas').store.load({
                params: {
                    pPaciente: Ext.getCmp('intPacienteLegalizacion').getValue(),
                    pDesde: Ext.getCmp('fecAgendaDesde').getValue().format("Y-m-d"),
                    pHasta: Ext.getCmp('fecAgendaHasta').getValue().format("Y-m-d"),
                    pMunicipio: Ext.getCmp('strAgendaMunicipio').getValue(),
                    pCliente: Ext.getCmp('sysCliente').getValue()
                }
            });
        }
    },
    HistorialCitasAsignadas: function(){
        if (Ext.getCmp('intPacienteLegalizacion').getValue() != 0){
            var winFrmHistorialCitas = new winFrmHistorialCitasUi();
            winFrmHistorialCitas.setTitle("OfiClinic© Web..! .:: Historial de Citas Asignadas ::.");
            winFrmHistorialCitas.setIconClass("btnCitasAsignadas");
            Ext.getCmp('gridHistorialCitas').store.setBaseParam("task", "HISTORIAL_CITAS_ASIGNADAS_MANUAL");
            Ext.getCmp('gridHistorialCitas').store.setBaseParam("pEmpresa", ID_EMPRESA);
            Ext.getCmp('gridHistorialCitas').store.setBaseParam("pPaciente", Ext.getCmp('intPacienteLegalizacion').getValue());
            Ext.getCmp('gridHistorialCitas').getColumnModel().setHidden(5, true);
            Ext.getCmp('gridHistorialCitas').getColumnModel().setHidden(6, true);
            Ext.getCmp('gridHistorialCitas').getColumnModel().setHidden(7, true);
            Ext.getCmp('gridHistorialCitas').getColumnModel().setHidden(8, true);
            Ext.getCmp('gridHistorialCitas').store.load({
                params: {
                    start: 0,
                    limit: 15
                }
            });
            winFrmHistorialCitas.show();
        }
    },
    BuscarPacienteLegaliza: function(){
        buscarpaciente("LegalizaAgendaManual");
    },
    BuscarPacienteAgendaManual: function(){
        buscarpacienteagendamanual();
    },
    Actualizar: function(){
        Ext.getCmp('gridConfirmacionCitas').store.reload();
    },
    SalirOpcion: function(){
        Ext.Msg.show({
            title: 'eOfiClinic',
            msg: 'Esta seguro que desea cerrar la ventana?',
            buttons: Ext.Msg.YESNO,
            icon: Ext.Msg.QUESTION,
            fn: function(btn)
            {
                if(btn=="yes")
                {
                    window.close();
                }
            }
        });
    }
});
