/*
* @category    Formulario Incluir Horario
* @package     OfiClinic Web
* @author      Jorge Ancizar Galeano Ruiz<desarrollo@ofisalud.com>
* @copyright   2010 Jorge Ancizar GAleano Ruiz
* @version     OfiClinic Web 1.0
* @license     COMERCIAL
* @link        http://www.ofisalud.com
* @country     Colombia
* @telephone   3016398114
*/

winFrmIncluirHorarioUi = Ext.extend(Ext.Window, {
    //title: 'OfiClinic© Web..! .:: Agenda por Profesional ::.',
    id: 'winFrmIncluirHorario',
    closable:false,
    autoScroll: true,
    width:980,
    height:260,
    closeAction: 'hide',
    plain: true,
    modal: true,
    frame: true,
    border: false,
    draggable: false,
    resizable: false,
    //draggable : false,
    y:120,
    padding: 5,
    layout: 'form',
    initComponent: function() {
        
        var mybbar = new utilBbarUi();
        this.bbar = mybbar;
        this.tbar = [
            {
                xtype: 'tbfill'
            },
            {
                xtype: 'tbseparator'
            },
            {
                xtype: 'button',
                text: 'Incluir Horario',
                iconCls: 'btnAddRow',
                id: 'btnIncluirHorario',
                listeners:{
                    click : function(){
                        var frm = Ext.getCmp('frmIncluirHorario').getForm();
                        if (frm.isValid()){
                            Ext.Msg.show({
                                title: 'OfiClinic',
                                msg: 'Esta Seguro que Desea Incluir los Horarios?',
                                buttons: Ext.Msg.YESNO,
                                icon: Ext.Msg.QUESTION,
                                fn: function(btn){
                                    if(btn === "yes"){
                                        frm.submit({
                                            url: '../../controlador/agendas/controlador_agendas_002.php',
                                            params: {
                                                task: 'INCLUIR_HORARIOS',
                                                pProfesional: Ext.getCmp('sysProfeAgenda').getValue(),
                                                pConsultorio: Ext.getCmp('sysUbicacionAgenda').getValue(),
                                                pPlantilla: Ext.getCmp('intidPlantillaCitaProgramar').getValue(),
                                                pHorario: Ext.getCmp('sysHorario').getValue(),
                                                pDesde: Ext.getCmp('sysDesde').getValue().format("Y-m-d"),
                                                pHasta: Ext.getCmp('sysHasta').getValue().format("Y-m-d")
                                            },
                                            success: function(res,req){
                                                switch(req.result.requestedId){
                                                    case "1":
                                                        Ext.MessageBox.show({
                                                            title: 'OfiClinic',
                                                            msg: 'Se Incluyo el Horario con Exito.',
                                                            buttons: Ext.MessageBox.OK,
                                                            icon: Ext.MessageBox.INFO
                                                        });
                                                        break;

                                                    default:
                                                        Ext.MessageBox.show({
                                                            title: 'OfiClinic',
                                                            msg: 'Ocurrio un error al incluir el horario a la agenda o no se pudo establecer conexión con el servidor.',
                                                            buttons: Ext.MessageBox.OK,
                                                            icon: Ext.MessageBox.ERROR
                                                        });
                                                        break;
                                                }
                                            },
                                            failure: function(response,options)
                                            {
                                                Ext.MessageBox.show({
                                                    title: 'Error Base Datos',
                                                    msg: 'No podemos Incluir el Horario a la agenda en estos momentos',
                                                    buttons: Ext.MessageBox.OK,
                                                    icon: Ext.MessageBox.ERROR
                                                });
                                            }
                                        });
                                    }
                                }
                            });
                        }else{
                            Ext.MessageBox.show({
                                title: 'Error',
                                msg: 'Todos los campos son Requeridos',
                                buttons: Ext.MessageBox.OK,
                                icon: Ext.MessageBox.ERROR
                            });
                        }
                    }
                }
            }
        ];
        this.items = [
            {
                xtype: 'form',
                frame: true,
                anchor: '100%',
                id: 'frmIncluirHorario',
                border: false,
                style: 'background:transparent;',
                items: [
                    {
                        xtype: 'combo',
                        fieldLabel: 'Profesional',
                        allowBlank: false,
                        store: 'StoreProfesionales',
                        forceSelection: true,
                        triggerAction: 'all',
                        mode: 'local',
                        typeAhead: true,
                        typeAheadDelay: 400,
                        emptyText: 'Seleccione Profesional....',
                        valueField: 'Codigo',
                        displayField: 'Descripcion',
                        anchor: '100%',
                        submitValue: true,
                        id: 'sysProfeAgenda'
                    },
                    {
                        xtype: 'combo',
                        fieldLabel: 'Ubicación',
                        allowBlank: false,
                        store: 'StoreVerUbicacionAgenda',
                        forceSelection: true,
                        triggerAction: 'all',
                        mode: 'local',
                        typeAhead: true,
                        typeAheadDelay: 400,
                        emptyText: 'Seleccione Ubicacion....',
                        valueField: 'Codigo',
                        displayField: 'Descripcion',
                        anchor: '100%',
                        submitValue: true,
                        disabled: true,
                        id: 'sysUbicacionAgenda'
                    },
                    {
                        xtype: 'combo',
                        fieldLabel: 'Plantilla Citas',
                        anchor: '100%',
                        triggerAction: 'all',
                        mode: 'local',
                        typeAhead: true,
                        emptyText: 'Seleccionar Plantilla...!',
                        valueField: 'Codigo',
                        displayField: 'Descripcion',
                        store: 'StorePlantillaCitasxProfe',
                        forceSelection: true,
                        allowBlank: false,
                        id: 'intidPlantillaCitaProgramar'
                    },
                    {
                        xtype: 'combo',
                        fieldLabel: 'Horario',
                        name: 'Horario',
                        emptyText: 'Seleccione Horario....',
                        anchor: '100%',
                        allowBlank: false,
                        store: 'StoreHorarios',
                        valueField: 'IdTipoHorario',
                        displayField: 'Descripcion',
                        mode: 'local',
                        forceSelection: true,
                        typeAhead: true,
                        disabled: true,
                        typeAheadDelay: 10,
                        triggerAction: 'all',
                        id: 'sysHorario'
                    },
                    {
                        xtype: 'datefield',
                        width: 150,
                        fieldLabel: 'Fecha Desde',
                        name: 'Fecha Desde',
                        allowBlank: false,
                        disabledDates: '',
                        //emptyText: 'Desde (dia/mes/año)',
                        style: 'text-align:center;',
                        id: 'sysDesde'
                    },
                    {
                        xtype: 'datefield',
                        width: 150,
                        fieldLabel: 'Fecha Hasta',
                        name: 'Fecha Hasta',
                        allowBlank: false,
                        disabledDates: '',
                        //emptyText: 'Hasta (dia/mes/año)',
                        style: 'text-align:center;',
                        id: 'sysHasta'
                    }
                ]
            }
        ];
        winFrmIncluirHorarioUi.superclass.initComponent.call(this);
    }
});
