/*
* @category    Programacion Eventos Formulario Tipo de Horario
* @package     OfiClinic Web
* @author      Jorge Ancizar Galeano Ruiz<desarrollo@ofisalud.com>
* @copyright   2010 Jorge Ancizar GAleano Ruiz
* @version     OfiClinic Web 1.0
* @license     COMERCIAL
* @link        http://www.ofisalud.com
* @country     Colombia
* @telephone   3016398114
*/


winFrmHorarios = Ext.extend(winFrmHorariosUi, {
    initComponent: function() {
        winFrmHorarios.superclass.initComponent.call(this);
        //this.title = Ext.get('ofiversion').getValue() + " .:: Tipos de Horarios ::.";
        el = Ext.get('idempresa');
        ID_EMPRESA = el.getValue();
        el = Ext.get('idsede');
        ID_SEDE = el.getValue();
        el = Ext.get('idips');
        ID_IPS = el.getValue();
        el = Ext.get('idusuario');
        ID_USUARIO = el.getValue();
        el = Ext.get('idperfil');
        ID_PERFIL = el.getValue();
        el = Ext.get('idaplicacion');
        var NOM_APLICACION = el.getValue();
        el = Ext.get('idxac');
        var ID_CONSULTORIO = el.getValue();
        
        stOpcionesSistema = new StoreOpcionesSistema();
        stOpcionesSistema.load({
            params: { 'pPerfil': ID_PERFIL }
        });
        if(NOM_APLICACION == "OfiClinic"){
            Ext.getCmp('fNomEmpresa').setValue("EMPRESA: " + Ext.get('nomempresa').getValue());
            Ext.getCmp('fNomSede').setValue("");
            Ext.getCmp('fNomIPS').setValue("");
            Ext.getCmp('fNomUSR').setValue("Usr: [" + Ext.get('codusuario').getValue() + "]-" + Ext.get('nomusuario').getValue());
        }else{
            Ext.getCmp('fNomEmpresa').setValue("");
            Ext.getCmp('fNomSede').setValue("");
            Ext.getCmp('fNomIPS').setValue("");
            Ext.getCmp('fNomUSR').setValue("");
        }
        Ext.getCmp('gridTiposHorario').store.load({params: {query: null, pEmpresa: ID_EMPRESA, start: 0, limit: 15}});

        var btnSalirOpcion = Ext.getCmp('btnSalirOpcion').on("click",this.SalirOpcion,this);
        var btnAddTipoHorario = Ext.getCmp('btnAddTipoHorario').on("click",this.AddTipoHorario,this);
        var btnDelTipoHorario = Ext.getCmp('btnDelTipoHorario').on("click",this.DelTipoHorario,this);
        var btnEditTipoHorario = Ext.getCmp('btnEditTipoHorario').on("click",this.EditTipoHorario,this);
        var btnExcelTipoHorario = Ext.getCmp('btnExcelTipoHorario').on("click",this.ExportarExcel,this);
        var btnImprimirTipoHorario = Ext.getCmp('btnImprimirTipoHorario').on("click",this.PrintTipoHorario,this);

    },
    SalirOpcion: function(){
        Ext.Msg.show({
            title: 'eOfiClinic',
            msg: 'Esta seguro que desea cerrar la ventana?',
            buttons: Ext.Msg.YESNO,
            icon: Ext.Msg.QUESTION,
            fn: function(btn)
            {
                if(btn=="yes")
                {
                    window.close();
                }
            }
        });
    },
    ExportarExcel: function(){
        var permitir = false;
        var acceso = stOpcionesSistema.queryBy(function(record,id)
        {
            return record.get('codOpcion') == "ExcelTipoHorario";
        });
        acceso.each(function(item,index){
            permitir = true
        });
        if (!permitir)
        {
            Ext.example.Tiempo = 3;
            Ext.example.msg('Tipo Horario - Exportar a Excel:', "Usted no tiene acceso a esta opción del sistema...!");
        }else
        {
            location.href='../../controlador/agendas/tipo_horario_excel.php?pEmpresa='+ID_EMPRESA+'&query='+Ext.getCmp('qryTipoHorario').getValue();
        }
    },
    AddTipoHorario: function(){
        var permitir = false;
        var acceso = stOpcionesSistema.queryBy(function(record,id)
        {
            return record.get('codOpcion') == "AddTipoHorario";
        });
        acceso.each(function(item,index){
            permitir = true
        });
        if (!permitir)
        {
            Ext.example.Tiempo = 3;
            Ext.example.msg('Tipo Horario - Adicionar:', "Usted no tiene acceso a esta opción del sistema...!");
        }else
        {
            var winAddTipoHorario = new winTipoHorarioUi();
            winAddTipoHorario.title = 'eOfiClinic .::Adicionar Tipo Horario::.';
            Ext.getCmp('btn_AdicionarHorario').setVisible(true);
            Ext.getCmp('btn_ModificarHorario').setVisible(false);
            Ext.getCmp('sysUsuario').setVisible(false);
            Ext.getCmp('sysFechaAct').setVisible(false);
            Ext.getCmp('intPrestador').setValue(ID_EMPRESA);
            Ext.getCmp('intUsuario').setValue(ID_USUARIO);
            var btn_AdicionarHorario = Ext.getCmp('btn_AdicionarHorario').on("click",this.GuardarTipoHorario,this);
            var btn_SalirHorario = Ext.getCmp('btn_SalirHorario').on("click",this.CerrarVentana,this);
            winAddTipoHorario.show();
        }
    },
    EditTipoHorario: function(){
        var permitir = false;
        var acceso = stOpcionesSistema.queryBy(function(record,id)
        {
            return record.get('codOpcion') == "EditTipoHorario";
        });
        acceso.each(function(item,index){
            permitir = true
        });
        if (!permitir)
        {
            Ext.example.Tiempo = 3;
            Ext.example.msg('Tipo Horario - Modificar:', "Usted no tiene acceso a esta opción del sistema...!");
        }else
        {
            if(Ext.getCmp('gridTiposHorario').selModel.getCount() == 1)
            {
                var selections = Ext.getCmp('gridTiposHorario').selModel.getSelections();
                var winAddTipoHorario = new winTipoHorarioUi();
                winAddTipoHorario.title = 'eOfiClinic .::Modificar Tipo Horario::.';
                Ext.getCmp('btn_AdicionarHorario').setVisible(false);
                Ext.getCmp('btn_ModificarHorario').setVisible(true);
                Ext.getCmp('sysUsuario').setVisible(true);
                Ext.getCmp('sysFechaAct').setVisible(true);
                Ext.getCmp('intPrestador').setValue(ID_EMPRESA);
                Ext.getCmp('intUsuario').setValue(ID_USUARIO);
                Ext.getCmp('intIdTipoHorario').setValue(selections[0].json.IdTipoHorario);
                Ext.getCmp('strIdCita').setValue(PonerAcentosMayusculas(selections[0].json.IdCita));
                Ext.getCmp('strDesCita').setValue(PonerAcentosMayusculas(selections[0].json.DesCita));
                Ext.getCmp('strDesImprime').setValue(PonerAcentosMayusculas(selections[0].json.DesImprime));
                Ext.getCmp('strHoraAtencion').setValue(PonerAcentosMayusculas(selections[0].json.HoraAtencion));
                Ext.getCmp('sysUsuario').setValue(selections[0].json.Usuario);
                Ext.getCmp('sysUsuario').addClass('field_quienmodifico')
                Ext.getCmp('sysFechaAct').setValue(selections[0].json.FechaAct);
                Ext.getCmp('sysFechaAct').addClass('field_quienmodifico')
                var btn_ModificarHorario = Ext.getCmp('btn_ModificarHorario').on("click",this.ModificarTipoHorario,this);
                var btn_SalirHorario = Ext.getCmp('btn_SalirHorario').on("click",this.CerrarVentana,this);
                winAddTipoHorario.show();
            }
        }
    },
    GuardarTipoHorario: function(){
        Ext.Msg.show({
            title: 'Guardar Tipo de Horario',
            msg: 'Esta Seguro que Desea Guardar la Información?',
            buttons: Ext.Msg.YESNO,
            icon: Ext.Msg.QUESTION,
            fn: function(btn)
            {
                if(btn=="yes")
                {
                    fnGuardarRegistros("INSERTAR","SI","winTipoHorarioUi","frmTipoHorario","../../controlador/agendas/controlador_tipohorario.php","gridTiposHorario");
                }
            }
        });
    },
    DelTipoHorario: function(){
        var permitir = false;
        var acceso = stOpcionesSistema.queryBy(function(record,id)
        {
            return record.get('codOpcion') == "DelTipoHorario";
        });
        acceso.each(function(item,index){
            permitir = true
        });
        if (!permitir)
        {
            Ext.example.Tiempo = 3;
            Ext.example.msg('Tipo Horario - Eliminar:', "Usted no tiene acceso a esta opción del sistema...!");
        }else
        {
            if(Ext.getCmp('gridTiposHorario').selModel.getCount() == 1)
            {
                var selections = Ext.getCmp('gridTiposHorario').selModel.getSelections();
                Ext.Msg.show({
                    title: 'Tipo de Horario',
                    msg: 'Esta Seguro que Desea Eliminar el Registro ' + selections[0].json.DesCita + '?',
                    buttons: Ext.Msg.YESNO,
                    icon: Ext.Msg.QUESTION,
                    fn: function(btn)
                    {
                        if(btn=="yes")
                        {
                            fnEliminarRegistros("../../controlador/agendas/controlador_tipohorario.php",{task: "ELIMINAR", pIdTipoHorario: selections[0].json.IdTipoHorario}, 'gridTiposHorario')
                        }
                    }
                });
            }else{
                Ext.MessageBox.show({
                    title: 'Error',
                    msg: 'No podemos eliminar los registros en estos momentos, verifique que solo haya seleccionado un registro',
                    buttons: Ext.MessageBox.OK,
                    icon: Ext.MessageBox.ERROR
                });
            }
        }
    },
    ModificarTipoHorario: function(){
        Ext.Msg.show({
            title: 'Guardar Tipo de Horario',
            msg: 'Esta Seguro que Desea Modificar la Información?',
            buttons: Ext.Msg.YESNO,
            icon: Ext.Msg.QUESTION,
            fn: function(btn)
            {
                if(btn=="yes")
                {
                    fnGuardarRegistros("MODIFICAR","SI","winTipoHorarioUi","frmTipoHorario","../../controlador/agendas/controlador_tipohorario.php","gridTiposHorario");
                }
            }
        });
    },
    CerrarVentana: function(){
        Ext.Msg.show({
            title: 'eOfiClinic',
            msg: 'Esta seguro que desea cerrar la ventana?',
            buttons: Ext.Msg.YESNO,
            icon: Ext.Msg.QUESTION,
            fn: function(btn)
            {
                if(btn=="yes")
                {
                   Ext.getCmp('winTipoHorarioUi').close();
                }
            }
        });
    },
    PrintTipoHorario: function(){
        var permitir = false;
        var acceso = stOpcionesSistema.queryBy(function(record,id)
        {
            return record.get('codOpcion') == "PrintTipoHorario";
        });
        acceso.each(function(item,index){
            permitir = true
        });
        if (!permitir)
        {
            Ext.example.Tiempo = 3;
            Ext.example.msg('Tipo Horario - Imprimir:', "Usted no tiene acceso a esta opción del sistema...!");
        }else
        {
            location.href='../../controlador/agendas/tipo_horario_print.php?pEmpresa='+ID_EMPRESA+'&query='+Ext.getCmp('qryTipoHorario').getValue();
        }
    }
});


function fnEliminarRegistros(URL,arrParam, pGrid, arrParamStore)
{
    Ext.Ajax.request({
        waitMsg: 'Por favor Espere...',
        url: URL,
        params: arrParam,
        success: function(response){
            var result=eval(response.responseText);
            switch(result){
                case 1:
                    if (typeof pGrid != 'undefined')
                    {
                        Ext.getCmp(pGrid).store.reload(arrParamStore);
                    }
                    break;

                default:
                    Ext.MessageBox.show({
                        title: 'Error',
                        msg: 'No podemos eliminar los registros en estos momentos',
                        buttons: Ext.MessageBox.OK,
                        icon: Ext.MessageBox.ERROR
                    });
                    break;
            }
        },
        failure: function(response){
            var result = response.responseText;
            Ext.MessageBox.show({
                title: 'Error Base Datos',
                msg: 'No podemos eliminar los registros en estos momentos',
                buttons: Ext.MessageBox.OK,
                icon: Ext.MessageBox.ERROR
            });
        }
    });
}

function fnGuardarRegistros(pAccion,pCerrar,pWin,pForm,URL,pGrid,arrParam,pCampoLlave,pCampoTextoLlave, pLimpiarForm, pCambiarBotones){
    var frm = Ext.getCmp(pForm).getForm();
    if (frm.isValid())
    {
        var listacampos = ExtraerCamposFrm(frm);
        frm.submit({
            url: URL,
            params:{
                task: pAccion,
                CAMPOS: listacampos
            },
            success: function(res,req)
            {
                switch(req.result.requestedId){
                    case "1":
                        Ext.MessageBox.show({
                            title: 'Guardar',
                            msg: 'Se Guardo la Información con Exito.',
                            buttons: Ext.MessageBox.OK,
                            icon: Ext.MessageBox.INFO
                        });
                        if (typeof pLimpiarForm != 'undefined')
                        {
                            if (pLimpiarForm == "SI")
                                frm.reset();
                        }else{
                            frm.reset();
                        }
                        if (typeof pGrid != 'undefined')
                        {
                            if (pGrid != 'NA')
                            {
                                Ext.getCmp(pGrid).store.reload(arrParam);
                            }
                        }
                        if (typeof pCampoLlave != 'undefined')
                        {
                            if (pCampoLlave != 'NA')
                            {
                                Ext.getCmp(pCampoLlave).setValue(req.result.Data);
                                if (typeof pCampoTextoLlave != 'undefined')
                                    Ext.getCmp(pCampoTextoLlave).setValue("Tarjeta Nro: " + req.result.Data);
                            }
                        }
                        if (typeof pCambiarBotones != 'undefined')
                        {
                            if (pCambiarBotones == 'SI')
                            {
                                Ext.getCmp('btnGuardarDatosBasicosTarjeta').setVisible(false);
                                Ext.getCmp('btnModificarDatosBasicosTarjeta').setVisible(true);
                            }
                        }
                        if(pCerrar == "SI")
                        {
                            Ext.getCmp(pWin).close();
                        }
                        break;

                    default:
                        Ext.MessageBox.show({
                            title: 'Guardar',
                            msg: 'Ocurrio un error al guardar, la llave principal no es valida o no se pudo establecer conexión con el servidor.',
                            buttons: Ext.MessageBox.OK,
                            icon: Ext.MessageBox.ERROR
                        });
                        break;
                }
            },
            failure: function(response,options)
            {
                Ext.MessageBox.show({
                    title: 'Guardar',
                    msg: 'Ocurrio un error al guardar o no se pudo establecer conexión con el servidor.',
                    buttons: Ext.MessageBox.OK,
                    icon: Ext.MessageBox.ERROR
                });
            }
        });
    }else{
        Ext.MessageBox.show({
            title: 'Guardar',
            msg: 'Por favor verifique que todos los campos obligatorios estén diligenciados.',
            buttons: Ext.MessageBox.OK,
            icon: Ext.MessageBox.ERROR
        });
    }
}
