/*
* @category    Formulario Cancelar Agenda
* @package     OfiClinic Web
* @author      Jorge Ancizar Galeano Ruiz<desarrollo@ofisalud.com>
* @copyright   2010 Jorge Ancizar GAleano Ruiz
* @version     OfiClinic Web 1.0
* @license     COMERCIAL
* @link        http://www.ofisalud.com
* @country     Colombia
* @telephone   3016398114
*/

winFrmCancelaAgendaUi = Ext.extend(Ext.Window, {
    //title: 'OfiClinic© Web..! .:: Agenda por Profesional ::.',
    id: 'winFrmCancelaAgenda',
    closable:false,
    draggable : false,
    width:980,
    height:230,
    plain:true,
    resizable : false,
    y:120,
    padding: 5,
    frame: true,
    layout: 'form',
    initComponent: function() {
        
        var mybbar = new utilBbarUi();
        this.bbar = mybbar;
        this.tbar = [
            {
                xtype: 'tbfill'
            },
            {
                xtype: 'tbseparator'
            },
            {
                xtype: 'button',
                text: 'Cancelar Agenda',
                iconCls: 'btnBorrar',
                id: 'btnCancelacion_Cita',
                listeners:{
                    click : function(){
                        var frm = Ext.getCmp('frmCancelarAgenda').getForm();
                        if (frm.isValid()){
                            Ext.Msg.show({
                                title: 'OfiClinic',
                                msg: 'Esta Seguro que Desea Cancelar la Agenda?',
                                buttons: Ext.Msg.YESNO,
                                icon: Ext.Msg.QUESTION,
                                fn: function(btn){
                                    if(btn === "yes"){
                                        frm.submit({
                                            url: '../../controlador/agendas/controlador_cancelaragenda.php',
                                            params: {
                                                task: 'CANECELAR_CITAS',
                                                pEmpresa: ID_EMPRESA,
                                                pIPS: ID_IPS,
                                                pAgenda: Ext.getCmp('sysFechaAgenda').getValue(),
                                                pMotivo: QuitarAcentosMayusculas(Ext.getCmp('strMotivo').getValue()),
                                                pUsuario: ID_USUARIO
                                            },
                                            success: function(res,req){
                                                switch(req.result.requestedId){
                                                    case "1":
                                                        Ext.MessageBox.show({
                                                            title: 'OfiClinic',
                                                            msg: 'Se Cancelo la Agenda con Exito.',
                                                            buttons: Ext.MessageBox.OK,
                                                            icon: Ext.MessageBox.INFO
                                                        });
                                                        break;

                                                    default:
                                                        Ext.MessageBox.show({
                                                            title: 'OfiClinic',
                                                            msg: 'Ocurrio un error al cancelar la agenda o no se pudo establecer conexión con el servidor.',
                                                            buttons: Ext.MessageBox.OK,
                                                            icon: Ext.MessageBox.ERROR
                                                        });
                                                        break;
                                                }
                                            },
                                            failure: function(response,options)
                                            {
                                                Ext.MessageBox.show({
                                                    title: 'Error Base Datos',
                                                    msg: 'No podemos Cancelar la agenda en estos momentos',
                                                    buttons: Ext.MessageBox.OK,
                                                    icon: Ext.MessageBox.ERROR
                                                });
                                            }
                                        });
                                    }
                                }
                            });
                        }else{
                            Ext.MessageBox.show({
                                title: 'Error',
                                msg: 'El Motivo de la Cancelación es Requerido',
                                buttons: Ext.MessageBox.OK,
                                icon: Ext.MessageBox.ERROR
                            });
                        }
                    }
                }
            }
        ];
        this.items = [
            {
                xtype: 'form',
                frame: true,
                anchor: '100%',
                id: 'frmCancelarAgenda',
                border: false,
                style: 'background:transparent;',
                items: [
                    {
                        xtype: 'combo',
                        fieldLabel: 'Profesional',
                        allowBlank: false,
                        store: 'StoreProfesionales',
                        forceSelection: true,
                        triggerAction: 'all',
                        mode: 'local',
                        typeAhead: true,
                        typeAheadDelay: 400,
                        emptyText: 'Seleccione Profesional....',
                        valueField: 'Codigo',
                        displayField: 'Descripcion',
                        anchor: '100%',
                        submitValue: true,
                        id: 'sysProfeAgenda'
                    },
                    {
                        xtype: 'combo',
                        fieldLabel: 'Ubicación',
                        allowBlank: false,
                        store: 'StoreVerUbicacionAgenda',
                        forceSelection: true,
                        triggerAction: 'all',
                        mode: 'local',
                        typeAhead: true,
                        typeAheadDelay: 400,
                        emptyText: 'Seleccione Ubicacion....',
                        valueField: 'Codigo',
                        displayField: 'Descripcion',
                        anchor: '100%',
                        submitValue: true,
                        disabled: true,
                        id: 'sysUbicacionAgenda'
                    },
                    {
                        xtype: 'combo',
                        fieldLabel: 'Fecha Agenda',
                        allowBlank: false,
                        store: 'StoreVerFechasAgenda',
                        forceSelection: true,
                        triggerAction: 'all',
                        mode: 'local',
                        typeAhead: true,
                        typeAheadDelay: 400,
                        emptyText: 'Seleccione Fecha....',
                        valueField: 'Codigo',
                        displayField: 'Descripcion',
                        anchor: '100%',
                        submitValue: true,
                        disabled: true,
                        id: 'sysFechaAgenda'
                    },
                    {
                        xtype: 'textarea',
                        anchor: '100%',
                        fieldLabel: 'Motivo',
                        name: 'strMotivo',
                        maxLength: 250,
                        allowBlank: false,
                        emptyText: 'Digite el Motivo de la Cancelación...!',
                        id: 'strMotivo'
                    }
                ]
            }
        ];
        winFrmCancelaAgendaUi.superclass.initComponent.call(this);
    }
});
