/*
* @category    Programacion Eventos Formulario Cancelar Agenda
* @package     OfiClinic Web
* @author      Jorge Ancizar Galeano Ruiz<desarrollo@ofisalud.com>
* @copyright   2010 Jorge Ancizar GAleano Ruiz
* @version     OfiClinic Web 1.0
* @license     COMERCIAL
* @link        http://www.ofisalud.com
* @country     Colombia
* @telephone   3016398114
*/


winFrmCancelaAgenda = Ext.extend(winFrmCancelaAgendaUi, {
    initComponent: function() {
        winFrmCancelaAgenda.superclass.initComponent.call(this);
        el = Ext.get('idempresa');
        ID_EMPRESA = el.getValue();
        el = Ext.get('idsede');
        ID_SEDE = el.getValue();
        el = Ext.get('idips');
        ID_IPS = el.getValue();
        el = Ext.get('idusuario');
        ID_USUARIO = el.getValue();
        el = Ext.get('idperfil');
        ID_PERFIL = el.getValue();
        BD_MULTIPRESTADOR = "NA";
        wURL = "";
        wNomImagen = "";
        winImgxPac = "";
        winDocxPac = "";
        paramOpcion = "Nuevo";
        stOpcionesSistema = new StoreOpcionesSistema();
        stOpcionesSistema.load({
            params: { 'pPerfil': ID_PERFIL }
        });
        Ext.getCmp('sysProfeAgenda').store.load({
            params: {
                pIPS: ID_IPS, 
                pUsuario: ID_USUARIO
            }
        }); 
        Ext.getCmp('fNomEmpresa').setValue("EMPRESA: " + Ext.get('nomempresa').getValue());
        Ext.getCmp('fNomSede').setValue("");
        Ext.getCmp('fNomIPS').setValue("");
        Ext.getCmp('fNomUSR').setValue("");
        
        var sysProfesionalAgenda = Ext.getCmp('sysProfeAgenda').on("select",this.CargaUbicacionAgenda,this);
        var sysUbicacionAgenda = Ext.getCmp('sysUbicacionAgenda').on("select",this.CargaFechasAgenda,this);
        var btnSalir = Ext.getCmp('btnSalirOpcion').on("click",this.SalirOpcion, this);
    },
    CargaFechasAgenda: function(cmb, rec, idx) {
        Ext.getCmp('sysFechaAgenda').clearValue();
        Ext.getCmp('sysFechaAgenda').enable();
        Ext.getCmp('sysFechaAgenda').store.load({
            params: {
                pIPS: ID_IPS, 
                pProfesional: Ext.getCmp('sysProfeAgenda').getValue(),
                pConsultorio: cmb.getValue()
            }
        }); 
    },
    CargaUbicacionAgenda: function(cmb, rec, idx) {
        Ext.getCmp('sysUbicacionAgenda').clearValue();
        Ext.getCmp('sysUbicacionAgenda').enable();
        Ext.getCmp('sysFechaAgenda').clearValue();
        Ext.getCmp('sysFechaAgenda').disable();
        Ext.getCmp('sysUbicacionAgenda').store.load({
            params: {
                pIPS: ID_IPS, 
                pProfesional: cmb.getValue()
            }
        }); 
    },
    SalirOpcion: function(){
        Ext.Msg.show({
            title: 'eOfiClinic',
            msg: 'Esta seguro que desea cerrar la ventana?',
            buttons: Ext.Msg.YESNO,
            icon: Ext.Msg.QUESTION,
            fn: function(btn)
            {
                if(btn=="yes")
                {
                    window.close();
                }
            }
        });
    }
});

