<?php
/*
* @category    Grid Repositorio 
* @package     Nube Apps - Planificador de Creditos
* @author      Jorge Ancizar Galeano Ruiz<desarrollo@nubeapps.com.co>
* @copyright   2010 Jorge Ancizar Galeano Ruiz
* @version     Planificar de Creditos Ver 1.0
* @license     COMERCIAL
* @link        http://www.nubeapps.com.co
* @country     Colombia
* @telephone   3168345866
*/
include "classConsentimiento.php";
class ConentimientosRepository {
    protected $db;
    public function __construct(PDO $db) {
        $this->db = $db;
    }
    private function read($row) {
        $result = new Consentimiento();
        $result->IdConsecutivoConsentimiento = $row["IdConsecutivoConsentimiento"];
        $result->Paciente = $row["Paciente"];
        $result->IdConsentimiento = $row["IdConsentimiento"];
        $result->FechaRegistro = $row["FechaRegistro"];
        $result->Responsable = $row["Responsable"];
        $result->Observaciones = $row["Observaciones"];
        $result->FirmaAceptacion = $row["FirmaAceptacion"];
        $result->FechaAceptacion = $row["FechaAceptacion"];
        $result->Consentimiento = $row["Consentimiento"]; 
        $result->TipoAceptacion = $row["TipoAceptacion"];
        $result->Firma = $row["Firma"];
        $result->NoFirma = $row["NoFirma"];
        $result->Foto = $row["Foto"];
        $result->FotoAnexo = $row["FotoAnexo"];
        $result->Huella = $row["Huella"];
        $result->Usuario = $row["Usuario"];
        $result->FechaAct = $row["FechaAct"];
        $result->NomConsentimiento = $row["NomConsentimiento"];
        $result->RutaConsentimiento = $row["RutaConsentimiento"];
        $result->Titulo = $row["Titulo"];
        $result->IdCodigo = $row["IdCodigo"];
        $result->IdVersion = $row["IdVersion"];
        $result->FechaPublica = $row["FechaPublica"];
        $result->TipDoc = $row["TipDoc"];
        $result->Documento = $row["Documento"];
        $result->nomPaciente = $row["nomPaciente"];
        $result->FecNac = $row["FecNac"];
        $result->Edad = $row["Edad"];
        return $result;
    }
    public function getAll($pPaciente) {
        $sql = 'CALL sp_consentimientoinformado_listar(\'' . $pPaciente . '\',"%")';
        $q = $this->db->prepare($sql);
        $q->execute();
        $rows = $q->fetchAll();
        $result = array();
        foreach($rows as $row) {
            array_push($result, $this->read($row));
        }
        return $result;
    }
    
}