<?php
@session_start();
require("../../../../core/php/_database.php");
require("../../../../core/php/php_functions.php");
class Profesionales {
    public $Codigo;
    public $Descripcion;
}

class ProfesionalesRepository {
    protected $db;
    public function __construct(PDO $db) {
        $this->db = $db;
    }
    private function read($row) {
        $result = new Profesionales();
        $result->Codigo = $row["Codigo"];
        $result->Descripcion = $row["Descripcion"];
        return $result;
    }
    public function getAll() {
        $sql = "CALL sp_combo_profesionales()";
        $q = $this->db->prepare($sql);
        $q->execute();
        $rows = $q->fetchAll();
        $result = array();
        foreach($rows as $row) {
            array_push($result, $this->read($row));
        }
        return $result;
    }
}

$config = include("config_dbgrid.php");
$db = new PDO($config["db"], $config["username"], $config["password"]);
$profesionales = new ProfesionalesRepository($db);
switch($_SERVER["REQUEST_METHOD"]) {
    case "GET":
        $result = $profesionales->getAll();
        break;
}
header("Content-Type: application/json");
echo json_encode($result);