/*
 * @category    Pagina Maestra
 * @package     Nube Apps - Planificador
 * @author      Jorge Ancizar Galeano Ruiz<desarrollo@nubeapps.com.co>
 * @copyright   2010 Jorge Ancizar Galeano Ruiz
 * @version     Planificador Ver 1.0
 * @license     COMERCIAL
 * @link        http://www.nubeapps.com.co
 * @country     Colombia
 * @telephone   3168345866
 */

$(function () {
  var DiaSemana = "";
  var Jornada = "";
  var showColumns = 0;

  function showHideColumn() {
    // if(showColumns === 1){
    //   $("#gridRecaudos").fields[2].visible = false;
    //   $("#gridRecaudos").fields[3].visible = false;
    //   showColumns = 0;
    // }else{
    //   $("#gridRecaudos").fields[2].visible = true;
    //   $("#gridRecaudos").fields[3].visible = true;
    //   showColumns = 1;
    // }
  }

  let formatting_options = {
    style: "currency",
    currency: "COP",
    minimumFractionDigits: 0,
  };
  let dollarString = new Intl.NumberFormat("es-ES", formatting_options);
  const modalTitle = document.getElementById("modalTitle");
  const divVlrSistema = document.getElementById("divVlrSistema");
  const divDiferenciaT = document.getElementById("divDiferenciaT");
  const divNotaT = document.getElementById("divNotaT");
  const btnActionGuardarItem = document.getElementById("btnActionGuardarItem");

  modalTitle.addEventListener("dblclick", () => {
    if (divVlrSistema.style.display === "none") {
      divVlrSistema.style.display = "block";
    } else {
      divVlrSistema.style.display = "none";
    }

    if (divDiferenciaT.style.display === "none") {
      divDiferenciaT.style.display = "block";
    } else {
      divDiferenciaT.style.display = "none";
    }

    if (divNotaT.style.display === "none") {
      divNotaT.style.display = "block";
    } else {
      divNotaT.style.display = "none";
    }
  });

  var MyDateField = function (config) {
    jsGrid.Field.call(this, config);
  };
  MyDateField.prototype = new jsGrid.Field({
    sorter: function (date1, date2) {
      return new Date(date1) - new Date(date2);
    },
    itemTemplate: function (value) {
      //return new Date(value).toDateString();
      return value;
    },
    insertTemplate: function (value) {
      return (this._insertPicker = $("<input>").datepicker({ defaultDate: new Date() }));
    },
    editTemplate: function (value) {
      return (this._editPicker = $("<input>").datepicker().datepicker("setDate", new Date(value)));
    },
    insertValue: function () {
      return this._insertPicker.datepicker("getDate").toISOString();
    },
    editValue: function () {
      return this._editPicker.datepicker("getDate").toISOString();
    },
  });
  jsGrid.fields.myDateField = MyDateField;

  function FloatNumberField(config) {
    jsGrid.NumberField.call(this, config);
  }

  FloatNumberField.prototype = new jsGrid.Field({
    filterValue: function () {
      return parseFloat(this.filterControl.val());
    },

    insertValue: function () {
      return parseFloat(this.insertControl.val());
    },

    editValue: function () {
      return parseFloat(this.editControl.val());
    },
  });

  jsGrid.fields.floatNumber = FloatNumberField;

  stSINO = [{ Descripcion: "SI" }, { Descripcion: "NO" }];

  stPesas = [{ Descripcion: "1" }, { Descripcion: "2" }, { Descripcion: "3" }, { Descripcion: "4" }, { Descripcion: "5" }];

  $("#gridRecaudos").jsGrid({
    //height: "auto",
    height: 550,
    width: 1335,
    filtering: false,
    inserting: false,
    editing: true,
    sorting: false,
    paging: true,
    autoload: false,
    pageSize: 500,
    pageButtonCount: 5,
    pagerFormat: "Paginas: {first} {prev} {pages} {next} {last}    {pageIndex} de {pageCount}",
    pagePrevText: "<-Anterior",
    pageNextText: "Siguiente->",
    pageFirstText: "Primera",
    pageLastText: "Ultima",
    pageNavigatorNextText: "...",
    pageNavigatorPrevText: "...",
    deleteConfirm: "Esta seguro que desea eliminar el registro?",
    noDataContent: "No existen datos para mostrar...!",
    controller: {
      loadData: function (filter) {
        var Dia = $("#sysDiaAgenda").val();
        var myDia = $("#sysDiaAgenda").val().split("/");
        $.ajax({
          type: "GET",
          url: "includes/resumen_diario_recaudo.php",
          data: {
            pFecha: myDia[2] + "-" + myDia[1] + "-" + myDia[0],
          },
        }).done(function (resp) {
          const data = JSON.parse(JSON.stringify(resp));
          showResumenDay(data);
          $.ajax({
            type: "GET",
            url: "includes/resumen_mensual_recaudo.php",
            data: {
              pFecha: myDia[2] + "-" + myDia[1] + "-" + myDia[0],
            },
          }).done(function (resp) {
            const data = JSON.parse(JSON.stringify(resp));
            showResumenMonth(data);
          });
        });
        return $.ajax({
          type: "GET",
          url: "includes/list_plantilla_recaudo.php",
          data: {
            pFecha: myDia[2] + "-" + myDia[1] + "-" + myDia[0],
          },
        });
      },
      insertItem: function (item) {
        //
      },
      updateItem: function (item) {
        //
      },
      deleteItem: function (item) {
        //
      },
    },
    fields: [
      //{ name: "Fecha", title: "Fecha", type: "myDateField", width: 100, align: "center" },
      { name: "usuario", title: "Usuario", width: 250, readOnly: true, align: "left" },
      {
        name: "vlrRecaudado",
        title: "Vlr Recaudado",
        type: "number",
        width: 120,
        sorting: false,
        filtering: false,
        align: "right",
        itemTemplate: function (value) {
          return "$" + new Intl.NumberFormat("en-US").format(value);
        },
      },
      {
        name: "vlrDiferencia",
        title: "Vlr Diferencia",
        type: "number",
        width: 120,
        sorting: false,
        filtering: false,
        align: "right",
        readOnly: true,
        itemTemplate: function (value) {
          return "$" + new Intl.NumberFormat("en-US").format(value);
        },
      },
      {
        name: "nota",
        title: "Nota",
        type: "text",
        width: 100,
        sorting: false,
        filtering: false,
        align: "center",
        readOnly: true,
        itemTemplate: function (value) {
          if (value === "FALTANTE") {
            return "<div style='background-color:#f7668b; color: white;'>" + value + "</div>";
          } else if (value === "SOBRANTE") {
            return "<div style='background-color:#658538; color: white;'>" + value + "</div>";
          } else {
            return "<div style='background-color:#f2fce4;'>" + value + "</div>";
          }
        },
      },
      {
        name: "vlrErrorTirillas",
        title: "Vlr Tirillas",
        type: "number",
        width: 120,
        sorting: false,
        filtering: false,
        align: "right",
        itemTemplate: function (value) {
          return "$" + new Intl.NumberFormat("en-US").format(value);
        },
      },
      {
        name: "vlrInsumosLab",
        title: "Vlr InsumosLab",
        type: "number",
        width: 120,
        sorting: false,
        filtering: false,
        align: "right",
        itemTemplate: function (value) {
          return "$" + new Intl.NumberFormat("en-US").format(value);
        },
      },
      {
        name: "vlrInsumosOdontologia",
        title: "Vlr InsumosOdo",
        type: "number",
        width: 120,
        sorting: false,
        filtering: false,
        align: "right",
        itemTemplate: function (value) {
          return "$" + new Intl.NumberFormat("en-US").format(value);
        },
      },
      {
        name: "vlrHistoriasClinicas",
        title: "Vlr InsumosHC",
        type: "number",
        width: 120,
        sorting: false,
        filtering: false,
        align: "right",
        itemTemplate: function (value) {
          return "$" + new Intl.NumberFormat("en-US").format(value);
        },
      },
      {
        name: "vlrOtros",
        title: "Vlr Otros",
        type: "number",
        width: 120,
        sorting: false,
        filtering: false,
        align: "right",
        itemTemplate: function (value) {
          return "$" + new Intl.NumberFormat("en-US").format(value);
        },
      },
      { name: "observaciones", title: "Observaciones", type: "text", width: 250, align: "left" },
    ],
    rowClick: function (args) {
      var item = args.item;
      var heading = $("#modalTitle");
      heading.html(`Detalle del Recaudo - ${item.usuario.toString().toUpperCase()}`);
      $("#itemDetails").text("Nombre: " + item.usuario + "VlrSistema: " + item.vlrRecaudoSistema);
      document.getElementById("sysItem").value = item.idItem;
      document.getElementById("sysIdUsuario").value = item.idUusuario;
      document.getElementById("sysUsuario").value = item.usuario;
      document.getElementById("sysFecha").value = item.fecha;
      document.getElementById("sysVlrSistema").value = item.vlrRecaudoSistema;
      document.getElementById("sysVlrSistemaT").value = dollarString.format(item.vlrRecaudoSistema);
      document.getElementById("sysVlrRecaudado").value = item.vlrRecaudado;
      document.getElementById("sysVlrDiferencia").value = item.vlrDiferencia;
      document.getElementById("sysVlrDiferenciaT").value = dollarString.format(item.vlrDiferencia);
      document.getElementById("sysVlrErrorTirillas").value = item.vlrErrorTirillas;
      document.getElementById("sysVlrInsumosLab").value = item.vlrInsumosLab;
      document.getElementById("sysVlrInsumosOdontologia").value = item.vlrInsumosOdontologia;
      document.getElementById("sysVlrHistoriasClinicas").value = item.vlrHistoriasClinicas;
      document.getElementById("sysVlrOtros").value = item.vlrOtros;
      document.getElementById("sysObservaciones").value = item.observaciones;
      document.getElementById("sysNota").innerHTML = item.nota;
      if (item.nota === "FALTANTE") {
        document.getElementById("sysNota").innerHTML =
          "<div style='background-color:#f7668b; color: white; font-size: 125%; text-align: center;'>" + item.nota + "</div>";
      } else if (item.nota === "SOBRANTE") {
        document.getElementById("sysNota").innerHTML =
          "<div style='background-color:#658538; color: white; font-size: 125%; text-align: center;'>" + item.nota + "</div>";
      } else {
        document.getElementById("sysNota").innerHTML =
          "<div style='background-color:#f2fce4; font-size: 125%; text-align: center;'>" + item.nota + "</div>";
      }
      // Mostrar el modal
      $("#myModal").modal("show");
    },
    onItemEditing: function (args) {
      if (args.item.YaCerrado === "SI") {
        args.cancel = true;
      }
    },
  });
  $("#sysDiaAgenda").datepicker();
  $("#btnActionAgenda").click(function () {
    if ($("#sysDiaAgenda").val() !== "" && $("#sysDiaAgenda").val() !== null) {
      $("#gridRecaudos").jsGrid("loadData");
      showHideColumn();
    } else {
      Ext.MessageBox.show({
        title: "OfiClinic",
        msg: "El campos dia es obligatorio.",
        buttons: Ext.MessageBox.OK,
        icon: Ext.MessageBox.ERROR,
      });
    }
  });

  $("#btnActionDescargar1").click(function () {
    if ($("#sysDiaAgenda").val() !== "" && $("#sysDiaAgenda").val() !== null) {
      var Dia = $("#sysDiaAgenda").val();
      var myDia = $("#sysDiaAgenda").val().split("/");
      window.open("./includes/infResumenUsuarioDia.php" + "?pFecha=" + myDia[2] + "-" + myDia[1] + "-" + myDia[0], "Informe Caja");
    } else {
      Ext.MessageBox.show({
        title: "OfiClinic",
        msg: "El campos dia es obligatorio.",
        buttons: Ext.MessageBox.OK,
        icon: Ext.MessageBox.ERROR,
      });
    }
  });

  $("#btnActionDescargar2").click(function () {
    if ($("#sysDiaAgenda").val() !== "" && $("#sysDiaAgenda").val() !== null) {
      var Dia = $("#sysDiaAgenda").val();
      var myDia = $("#sysDiaAgenda").val().split("/");
      window.open("./includes/infResumenUsuarioTotal.php" + "?pFecha=" + myDia[2] + "-" + myDia[1] + "-" + myDia[0], "Informe Caja");
    } else {
      Ext.MessageBox.show({
        title: "OfiClinic",
        msg: "El campos dia es obligatorio.",
        buttons: Ext.MessageBox.OK,
        icon: Ext.MessageBox.ERROR,
      });
    }
  });

  btnActionGuardarItem.addEventListener("click", () => {
    let nota = "OK";
    if (parseInt(document.getElementById("sysVlrDiferencia").value) === 0) {
      nota = "OK";
    } else if (parseInt(document.getElementById("sysVlrDiferencia").value) < 0) {
      nota = "FALTANTE";
    } else {
      nota = "SOBRANTE";
    }
    $.ajax({
      type: "POST",
      url: "includes/update_plantilla_recaudo.php",
      data: {
        idItem: document.getElementById("sysItem").value,
        idUsuario: document.getElementById("sysIdUsuario").value,
        usuario: document.getElementById("sysUsuario").value,
        fecha: document.getElementById("sysFecha").value,
        vlrRecaudoSistema: document.getElementById("sysVlrSistema").value,
        vlrRecaudado: document.getElementById("sysVlrRecaudado").value,
        vlrDiferencia: document.getElementById("sysVlrDiferencia").value,
        nota: nota,
        vlrErrorTirillas: document.getElementById("sysVlrErrorTirillas").value,
        vlrInsumosLab: document.getElementById("sysVlrInsumosLab").value,
        vlrInsumosOdontologia: document.getElementById("sysVlrInsumosOdontologia").value,
        vlrHistoriasClinicas: document.getElementById("sysVlrHistoriasClinicas").value,
        vlrOtros: document.getElementById("sysVlrOtros").value,
        vlrRecaudadoAnt: 0,
        vlrErrorTirillasAnt: 0,
        vlrDiferenciaAnt: 0,
        notaAnt: 0,
        observaciones: document.getElementById("sysObservaciones").value,
      },
    }).done(function () {
      return $.ajax({
        type: "POST",
        url: "includes/update_recaudo_diario.php",
      }).done(function () {
        $("#gridRecaudos").jsGrid("loadData");
        $("#myModal").modal("hide");
        $.ajax({
          type: "GET",
          url: "includes/resumen_diario_recaudo.php",
          data: {
            pFecha: document.getElementById("sysFecha").value,
          },
        }).done(function (resp) {
          const data = JSON.parse(JSON.stringify(resp));
          showResumenDay(data);
          $.ajax({
            type: "GET",
            url: "includes/resumen_mensual_recaudo.php",
            data: {
              pFecha: document.getElementById("sysFecha").value,
            },
          }).done(function (resp) {
            const data = JSON.parse(JSON.stringify(resp));
            showResumenMonth(data);
          });
        });
      });
    });
  });
});

function showResumenDay(data) {
  const total =
    parseInt(data[0]["vlrRecaudado"]) +
    parseInt(data[0]["vlrInsumosLab"]) +
    parseInt(data[0]["vlrInsumosOdontologia"]) +
    parseInt(data[0]["vlrHistoriasClinicas"]) +
    parseInt(data[0]["vlrOtros"]);
  $("#sysDiaVlrDiferencia").html(new Intl.NumberFormat().format(data[0]["vlrDiferencia"]));
  $("#sysDiaVlrRecaudo").html(new Intl.NumberFormat().format(data[0]["vlrRecaudado"]));
  $("#sysDiaVlrInsumosLab").html(new Intl.NumberFormat().format(data[0]["vlrInsumosLab"]));
  $("#sysDiaVlrInsumosOdo").html(new Intl.NumberFormat().format(data[0]["vlrInsumosOdontologia"]));
  $("#sysDiaHC").html(new Intl.NumberFormat().format(data[0]["vlrHistoriasClinicas"]));
  $("#sysDiaVlrOtros").html(new Intl.NumberFormat().format(data[0]["vlrOtros"]));
  // $("#sysDiaVlrConsignaInicial").html(new Intl.NumberFormat().format(data[0]["vlrDiferencia"]));
  // $("#sysDiaVlrConsignaPosterior").html(new Intl.NumberFormat().format(data[0]["vlrDiferencia"]));
  $("#sysDiaVlrTotalConsigna").html(new Intl.NumberFormat().format(total));
}

function showResumenMonth(data) {
  const total =
    parseInt(data[0]["vlrRecaudado"]) +
    parseInt(data[0]["vlrInsumosLab"]) +
    parseInt(data[0]["vlrInsumosOdontologia"]) +
    parseInt(data[0]["vlrHistoriasClinicas"]) +
    parseInt(data[0]["vlrOtros"]);
  $("#sysMesVlrDiferencia").html(new Intl.NumberFormat().format(data[0]["vlrDiferencia"]));
  $("#sysMesVlrRecaudo").html(new Intl.NumberFormat().format(data[0]["vlrRecaudado"]));
  $("#sysMesVlrInsumosLab").html(new Intl.NumberFormat().format(data[0]["vlrInsumosLab"]));
  $("#sysMesVlrInsumosOdo").html(new Intl.NumberFormat().format(data[0]["vlrInsumosOdontologia"]));
  $("#sysMesHC").html(new Intl.NumberFormat().format(data[0]["vlrHistoriasClinicas"]));
  $("#sysMesVlrOtros").html(new Intl.NumberFormat().format(data[0]["vlrOtros"]));
  // $("#sysMesaVlrConsignaInicial").html(new Intl.NumberFormat().format(data[0]["vlrDiferencia"]));
  // $("#sysMesVlrConsignaPosterior").html(new Intl.NumberFormat().format(data[0]["vlrDiferencia"]));
  $("#sysMesVlrTotalConsigna").html(new Intl.NumberFormat().format(total));
}

function validateValues() {
  let formatting_options = {
    style: "currency",
    currency: "COP",
    minimumFractionDigits: 0,
  };
  let dollarString = new Intl.NumberFormat("es-ES", formatting_options);

  var dif =
    parseInt(document.getElementById("sysVlrRecaudado").value) +
    parseInt(document.getElementById("sysVlrErrorTirillas").value) -
    parseInt(document.getElementById("sysVlrSistema").value);
  document.getElementById("sysVlrDiferencia").value = dif;
  document.getElementById("sysVlrDiferenciaT").value = dollarString.format(dif);
  if (parseInt(dif) === 0) {
    document.getElementById("sysNota").innerHTML =
      "<div style='background-color:#f2fce4; font-size: 125%; text-align: center;'>OK</div>";
  } else if (parseInt(dif) < 0) {
    document.getElementById("sysNota").innerHTML =
      "<div style='background-color:#f7668b; color: white; font-size: 125%; text-align: center;'>FALTANTE</div>";
  } else {
    document.getElementById("sysNota").innerHTML =
      "<div style='background-color:#658538; color: white; font-size: 125%; text-align: center;'>SOBRANTE</div>";
  }
}

function altoVentanaActual() {
  var myWidth = 0,
    myHeight = 0;
  if (typeof window.innerWidth == "number") {
    //No-IE
    myWidth = window.innerWidth;
    myHeight = window.innerHeight;
  } else if (document.documentElement && (document.documentElement.clientWidth || document.documentElement.clientHeight)) {
    //IE 6+
    myWidth = document.documentElement.clientWidth;
    myHeight = document.documentElement.clientHeight;
  } else if (document.body && (document.body.clientWidth || document.body.clientHeight)) {
    //IE 4 compatible
    myWidth = document.body.clientWidth;
    myHeight = document.body.clientHeight;
  }
  return myHeight;
}

function stringToDate(str) {
  var date = str.split("/"),
    m = date[1],
    d = date[0],
    y = date[2],
    temp = [];
  temp.push(y, m, d);
  return new Date(temp.join("-")).toUTCString();
}
