<?php

    session_start();
    set_time_limit(500);
    require_once('../../../../lib/tcpdf/config/lang/spa.php');
    require_once('../../../../lib/tcpdf/tcpdf.php');
    require("../../../../core/php/_database.php");
    require("../../../../core/php/php_functions.php");
    
    $pConsultorioVirtual = $_SESSION['IDBD'];
    $nomEmpresa = $_SESSION['NOM_EMPRESA'];
    $nomUsuario = $_SESSION['NOM_USUARIO'];
    $pPaciente = isset($_REQUEST['pPaciente'])?$_REQUEST['pPaciente']:0;
    $pDocPaciente = isset($_REQUEST['p0'])?$_REQUEST['p0']:null;
    $pNomPaciente = isset($_REQUEST['p1'])?$_REQUEST['p1']:null;
    $pEdadPaciente = isset($_REQUEST['p2'])?$_REQUEST['p2']:null;
    $pDocProfesional = isset($_REQUEST['p3'])?$_REQUEST['p3']:null;
    $pNomProfesional = isset($_REQUEST['p4'])?$_REQUEST['p4']:null;
    $pTitulo = isset($_REQUEST['p5'])?$_REQUEST['p5']:null;
    $pCodigo = isset($_REQUEST['p6'])?$_REQUEST['p6']:null;
    $pVersionConsentimiento = isset($_REQUEST['p7'])?$_REQUEST['p7']:null;
    $pFechaPublica = isset($_REQUEST['p8'])?$_REQUEST['p8']:null;
    $pIdConsentimiento = isset($_REQUEST['pK'])?$_REQUEST['pK']:null;
    //Definicion de las Margenes
    $LeftMargin = PDF_MARGIN_LEFT;
    $TopMargin = 5;
    $RightMargin = PDF_MARGIN_RIGHT;
    $HeaderMargin = PDF_MARGIN_HEADER;
    $BottomMargin = 3;
    $FooterMargin = 5;
    $Alineacion = "P";
    $FormatoPagina = "CARTA";
    $UsaPiePagina = "SI";
    $pTipoEncabezado = "FVP";
    $pControlSalto = 30;

    //Inicializacion de la Clase
    $pdf = new TCPDF($Alineacion, PDF_UNIT, $FormatoPagina, true, 'UTF-8', false);
    //Inicializacion Variables de Control
    $pdf->pAlineacionEncabezado = $Alineacion;
    $pdf->pTituloInforme = "CONSENTIMIENTO INFORMADO";
    $pdf->pImprimeLogo = "NO";
    $pdf->pAnchoTxtPagina = 210;
    $pdf->pNomEmpresa = $_SESSION['NOM_EMPRESA'];
    $pdf->pTDocEmpresa = $_SESSION['EMPRESA_TDOC'];
    $pdf->pDocEmpresa = $_SESSION['EMPRESA_DOC'];
    $pdf->pDirEmpresa = $_SESSION['EMPRESA_DIR'];
    $pdf->pTelEmpresa = $_SESSION['EMPRESA_TEL'];
    $pdf->pCiuEmpresa = $_SESSION['EMPRESA_CIU'];
    $pdf->pEspEmpresa = $_SESSION['EMPRESA_ESP'];
    $pdf->pRegEmpresa = $_SESSION['EMPRESA_REGIMEN'];
    $pdf->pContribuyentes = $_SESSION['EMPRESA_CONTRIBUYENTE'];
    $pdf->pReteIVA  = $_SESSION['EMPRESA_RTEICA'];
    $pdf->pReteICA = $_SESSION['EMPRESA_RTEIVA'];

    $pdf->pTipoEncabezado = $pTipoEncabezado;
    $pdf->pNomSede = $_SESSION['EMPRESA_DOC'];
    $pdf->pNomIPS = $_SESSION['NOM_IPS'];
    $pdf->pMargenPie = -20;
    if($_SESSION['IdAplicacion'] == "OfiMedical"){
        $pdf->pLogoCliente = "../../../../consultoriovirtual/" . $_SESSION['IDBD'] . "/logo/logoenc.png";
    }else{
        $pdf->pLogoCliente = "../../../../empresas/" . $_SESSION['ID_EMPRESA'] . "/logo/logoenc.png";
    }
    $pdf->pPrefijo = 1; //$row[0]["Prefijo"];
    $pdf->pNroDocumento = 1; //str_pad($row[0]["NroDocumento"], 7, "0", STR_PAD_LEFT);
    $pdf->pNroResolucion = 1; //$row[0]["NroResolucion"];
    $pdf->pFechaDoc = 1; //$row[0]["FechaDocumento"];
    $pdf->pCAS = null;
    $pdf->pTratamiento = null;
    $pdf->pUsaPie = $UsaPiePagina;
    
    //Modificacion para no dejar copiar el contenido
    //$pdf->SetProtection($permissions=array('copy'), $user_pass=null, $owner_pass=null, $mode=0, $pubkeys=null);
    
    $pdf->SetCreator(PDF_CREATOR);
    $pdf->SetAuthor('NubeApps © - 2006');
    $pdf->SetTitle('OfiClinic©');
    $pdf->SetSubject('Consentimiento Informado');

    $pdf->SetHeaderData($pdf->pLogoCliente, PDF_HEADER_LOGO_WIDTH, $pdf->pTituloInforme, PDF_HEADER_STRING);
    $pdf->setHeaderFont(Array(PDF_FONT_NAME_MAIN, '', PDF_FONT_SIZE_MAIN));
    $pdf->setFooterFont(Array(PDF_FONT_NAME_DATA, '', PDF_FONT_SIZE_DATA));
    $pdf->SetDefaultMonospacedFont(PDF_FONT_MONOSPACED);
    $pdf->SetMargins($LeftMargin, $TopMargin, $RightMargin);
    $pdf->SetHeaderMargin($HeaderMargin);
    $pdf->SetFooterMargin($FooterMargin);
    // set bacground image

    $pdf->SetAutoPageBreak(TRUE, $BottomMargin);
    $pdf->setImageScale(PDF_IMAGE_SCALE_RATIO);
    $pdf->setLanguageArray($l);
    $pdf->setFontSubsetting(true);
    $pdf->SetFont('dejavusans', '', 14, '', true);
    
    $gBaseDatos = new ofiMySQLi();
    $gBaseDatos->conectar();
    $qry = "CALL sp_consentimientoinformado_imprimir('" . $pIdConsentimiento . "')";
    //echo $qry;
    $gBaseDatos->QryID = @mysqli_query($gBaseDatos->ConexionID, $qry);
    while ($row[] = @mysqli_fetch_assoc($gBaseDatos->QryID));
    $gBaseDatos->liberar();
    $gBaseDatos->cerrar();
    $pRegistros = count($row);
    $i = 0;
    if($row[$i]["Paciente"] != "" && $row[$i]["Paciente"] != null){
        EncabezadoPagina($pdf, $row, $i, $pNomAplicacion, $pTitulo, $pCodigo, $pVersionConsentimiento, $pFechaPublica);
        
        $mostrarHC = $row[$i]["Consentimiento"];
        $pdf->writeHTML($mostrarHC, true, false, false, false, '');
        if ($pdf->GetY() >= ($pdf->getPageHeight()-$pControlSalto)){
            EncabezadoPagina($pdf, $row, $i, $pNomAplicacion, $pTitulo, $pCodigo, $pVersionConsentimiento, $pFechaPublica);
        }
        
        if($row[$i]["Observaciones"] !== "" && $row[$i]["Observaciones"] !== null){
            $mostrarHC = '<br>OBSERVACIONES: ' . $row[$i]["Observaciones"];
            $pdf->writeHTML($mostrarHC, true, false, false, false, '');
            if ($pdf->GetY() >= ($pdf->getPageHeight()-$pControlSalto)){
                EncabezadoPagina($pdf, $row, $i, $pNomAplicacion, $pTitulo, $pCodigo, $pVersionConsentimiento, $pFechaPublica);
            }
        }
        
        if($row[$i]["FotoAnexo"] == "1"){
            $pImg = '../../../../empresas/' . $_SESSION['ID_EMPRESA']  . '/consentimientos/' . $pIdConsentimiento . '_fotoanexo.jpg'; 
            if (file_exists($pImg)) {
                $mostrarHC = '<span align="center"><img src="' . $pImg . '" width="240" height="180"></span>';
            }
            $pdf->writeHTML($mostrarHC, true, false, false, false, '');
            if ($pdf->GetY() >= ($pdf->getPageHeight()-$pControlSalto)){
                EncabezadoPagina($pdf, $row, $i, $pNomAplicacion, $pTitulo, $pCodigo, $pVersionConsentimiento, $pFechaPublica);
            }
        }
        
        if($row[$i]["TipoAceptacion"] == "ACEPTO"){
            $mostrarHC = '<span style="color: darkgreen; font-size: 34px;"><b>DECLARO LIBREMENTE QUE HE LEIDO, ENTIENDO Y ACEPTO LA REALIZACION DEL TRATAMIENTO, CONSULTA Y/O PROCEDIMIENTO DESCRITO EN ESTE DOCUMENTO.</b></span><br>';
        }else{
            $mostrarHC = '<span style="color: darkred; font-size: 34px;"><b>DECLARO LIBREMENTE QUE HE LEIDO, ENTIENDO Y NO ACEPTO LA REALIZACION DEL TRATAMIENTO, CONSULTA Y/O PROCEDIMIENTO DESCRITO EN ESTE DOCUMENTO.</b></span><br>';
        }
        $pdf->writeHTML($mostrarHC, true, false, false, false, '');
        if ($pdf->GetY() >= ($pdf->getPageHeight()-$pControlSalto)){
            EncabezadoPagina($pdf, $row, $i, $pNomAplicacion, $pTitulo, $pCodigo, $pVersionConsentimiento, $pFechaPublica);
        }
        
        $mostrarHC = '<table border="1" style="padding:3px; border-top-width: 0.5px; border-right-width: 0.5px; border-bottom-width: 0.5px; border-left-width: 0.5px;"><tr><td colspan="2" align="center" style="font-size:24px; font-weight:bolder;">CONSENTIMIENTO INFORMADO Y POLITICA DE PROTECCION DE DATOS PERSONALES DE ' . $_SESSION['NOM_EMPRESA'] . '</td></tr>';
        $mostrarHC .= '<tr><td width="258" style="text-align:justify; font-size:20px; color:#000;">En cumplimiento del Artículo 34 de la Ley 23 de 1.981; la Resolución No. 76434 de 2.012; la Ley 1581 de 2.012; la Resolución No. 20752 de 2.013 y demás disposiciones legales autorizo el registro fotográfico o fílmico, huella y firma que se catalogan en mi historia clínica y/o consentimientos informados, también autorizo a que dichos reportes me sean enviados por correo cuando lo solicite de manera expresa, preferiblemente por escrito, y al personal de ' . $_SESSION['NOM_EMPRESA'] . ' a brindar la información necesaria a las personas y/o entidades contempladas en la legislación. Bajo la gravedad del juramento, manifiesto que toda la información relativa a mis datos personales es verídica. Con mi firma y huella dactilar estoy aceptando la política de protección de datos personales de la cual previamente se me informó y está publicada en la página web http:/medicareips.com.co</td>';
        if($row[$i]["Foto"] == "1"){
            $pImg = '../../../../empresas/' . $_SESSION['ID_EMPRESA']  . '/consentimientos/' . $pIdConsentimiento . '_foto.jpg'; 
            if (file_exists($pImg)) {
                $mostrarHC .= '<td width="150" align="center"><img src="' . $pImg . '" width="150" height="110"><br>FOTOGRAFIA DEL PACIENTE</td>';
            }
        }
        if($row[$i]["Firma"] == "1" && $row[$i]["NoFirma"] == "0"){
            $pImg = '../../../../empresas/' . $_SESSION['ID_EMPRESA']  . '/consentimientos/' . $pIdConsentimiento . '_firma.png'; 
            if (file_exists($pImg)) {
                $mostrarHC .= '<td width="200" align="center"><img src="' . $pImg . '" width="200" height="110"><br>FIRMA DEL PACIENTE</td>';
            }
        }else if($row[$i]["NoFirma"] == "1"){
            $mostrarHC .= '<td width="150" align="center" style="color: darkblue; font-size: 30px;"><br><br><br><br><b>NO SE REGISTRA FIRMA PORQUE EL PACIENTE NO SABE FIRMAR</b></td>';
        }
        if($row[$i]["Huella"] == "1"){
            $pImg = '../../../../empresas/' . $_SESSION['ID_EMPRESA']  . '/consentimientos/' . $pIdConsentimiento . '_huella.gif';
            if (file_exists($pImg)) {
                $mostrarHC .= '<td width="100" align="center"><img src="' . $pImg . '" width="92" height="99"><br>HUELLA DEL PACIENTE</td>';
            }
        }
        $mostrarHC .= '</tr>';
        $mostrarHC .= '</table>';
        $pdf->writeHTML($mostrarHC, true, false, false, false, '');
        if ($pdf->GetY() >= ($pdf->getPageHeight()-$pControlSalto)){
            EncabezadoPagina($pdf, $row, $i, $pNomAplicacion, $pTitulo, $pCodigo, $pVersionConsentimiento, $pFechaPublica);
        }
    }
    $pdf->Output('infConsentimientoInformado.pdf', 'I');

    function EncabezadoPagina(&$pdf, &$row, &$i, $pNomAplicacion, $pTitulo, $pCodigo, $pVersionConsentimiento, $pFechaPublica){
        $Alineacion = "P";
        $FormatoPagina = "CARTA";
        $pdf->AddPage($Alineacion,$FormatoPagina);
        $pdf->Ln(2);
        $pdf->SetFont(PDF_FONT_NAME_MAIN, '', 7);
        $EncabezadoHTML = '<table border="1" width="100%" cellpadding="5" style=" border-style: solid;">
            <tr>
                <td width="25%">
                    <img src="../../../../empresas/' . $_SESSION['ID_EMPRESA'] . '/logo/logoenc.png"/>
                </td>
                <td width="50%">
                    <p style="padding: 5px; font-weight: bold; color: darkblue; text-align: center; font-size: 36px;">' . $pTitulo . '</p>
                </td>
                <td width="25%">
                    <p style="padding: 5px; font-weight: bold; color: darkblue; text-align: justify; font-size: 22px;">
                    ' . $pCodigo . '<br>
                    ' . $pVersionConsentimiento . '<br>
                    ' . $pFechaPublica . '<br>
                    SISTEMA DE GESTIÓN DE CALIDAD
                    </p>
                </td>
            </tr>
        </table>';
        $pdf->writeHTML($EncabezadoHTML, true, false, false, false, '');
    }
