<?php

/*
* @category    Consentimiento Informado 
* @package     OfiClinic Web
* @author      Jorge Ancizar Galeano Ruiz<desarrollo@ofisalud.com>
* @copyright   2010 Jorge Ancizar Galeano Ruiz
* @version     OfiClinic Web 1.0
* @license     COMERCIAL
* @link        http://www.desarrollo@ofisalud.com
* @country     Colombia
* @telephone   3016398114
*/
require("../../../../core/php/constantes.php");
$idVersion = ofiVERSION;
session_start();
header("Cache-control: private"); // IE 6 Fix
$pPaciente = isset($_REQUEST['pPaciente'])?$_REQUEST['pPaciente']:0;
$pDocPaciente = isset($_REQUEST['p0'])?$_REQUEST['p0']:null;
$pNomPaciente = isset($_REQUEST['p1'])?$_REQUEST['p1']:null;
$pEdadPaciente = isset($_REQUEST['p2'])?$_REQUEST['p2']:null;
$pDocProfesional = isset($_REQUEST['p3'])?$_REQUEST['p3']:null;
$pNomProfesional = isset($_REQUEST['p4'])?$_REQUEST['p4']:null;
$pTitulo = isset($_REQUEST['p5'])?$_REQUEST['p5']:null;
$pCodigo = isset($_REQUEST['p6'])?$_REQUEST['p6']:null;
$pVersionConsentimiento = isset($_REQUEST['p7'])?$_REQUEST['p7']:null;
$pFechaPublica = isset($_REQUEST['p8'])?$_REQUEST['p8']:null;
$pIdConsentimiento = isset($_REQUEST['pK'])?$_REQUEST['pK']:null;
$_SESSION['ID_CONSENTIMIENTO'] = 0;

if( isset( $_SESSION['ID_EMPRESA'])){
    $idEmpresa = $_SESSION['ID_EMPRESA'];
    $nomEmpresa = $_SESSION['NOM_EMPRESA'];
    $nomAplicacion = $_SESSION['IdAplicacion'];
    $idClienteConsultorio = $_SESSION['IDBD'];
    $nomConsultorio = $_SESSION['IdNombreConsultorio'];
    $nomEspecialidad = $_SESSION['IdEspecialidadConsultorio'];
    $nomSubEspecialidad = $_SESSION['IdSubEspecialidadConsultorio'];
    $dirConsultorio = $_SESSION['IdDireccionConsultorio'];
    $telConsultorio = $_SESSION['IdTelefonoConsultorio'];
    $ciuConsultorio = $_SESSION['IdCiudadConsultorio'];
    $usaPatrocinador = $_SESSION['Patrocinador'];
    $idPatrocinador = $_SESSION['IdPatrocinador'];
    $idCliente = 0;
    $nomCliente = "&nbsp;";
    $idSede = $_SESSION['ID_SEDE'];
    $nomSede = $_SESSION['NOM_SEDE'];
    $idIps = $_SESSION['ID_IPS'];
    $nomIps = $_SESSION['NOM_IPS'];
    $idUsuario = $_SESSION['ID_USUARIO'];
    $codUsuario = $_SESSION['COD_USUARIO'];
    $nomUsuario = $_SESSION['NOM_USUARIO'];
    $idPerfil = $_SESSION['ID_PERFIL'];
    $seguir = true;
    $_SESSION['NOM_OPCION_MENU'] = $_REQUEST['OP'];
    $nomOpcion = $_SESSION['NOM_OPCION_MENU'];
    $_SESSION['DES_OPCION_MENU']= $_REQUEST['DESC'];
    $desOpcion = $_SESSION['DES_OPCION_MENU'];
    $_SESSION['ID_CONSENTIMIENTO'] = 0;
    $_SESSION['ID_CONSENTIMIENTO'] = $pIdConsentimiento;
}
else{
    $idEmpresa = 0;
    $nomEmpresa = "&nbsp;";
    $idCliente = 0;
    $nomCliente = "&nbsp;";
    $idSede = 0;
    $nomSede = "&nbsp;";
    $idIps = 0;
    $nomIps = "&nbsp;";
    $idUsuario = 0;
    $codUsuario = "&nbsp;";
    $nomUsuario = "&nbsp;";
    $idPerfil = 0;
    $seguir = false;
    $nomAplicacion = "OfiClinic";
    $nomConsultorio = "&nbsp;";
    $nomEspecialidad = "&nbsp;";
    $nomSubEspecialidad = "&nbsp;";
    $dirConsultorio = "&nbsp;";
    $telConsultorio = "&nbsp;";
    $ciuConsultorio = "&nbsp;";
    $usaPatrocinador = "NA";
    $idPatrocinador = "&nbsp;";
    $idClienteConsultorio = "X1";
    $nomOpcion = "&nbsp;";
    $desOpcion = "&nbsp;";
}
if($pNomAplicacion == "OfiMedical"){
    $_SESSION['URL_FOTO_PACIENTE'] = '/consultoriovirtual/' . $idClienteConsultorio  . '/consentimientos/' . $pIdConsentimiento . '_foto.jpg';
    $_SESSION['URL_FOTO_DESTINO'] = '../../../../consultoriovirtual/' . $idClienteConsultorio  . '/consentimientos/';
    $_SESSION['URL_FIRMA_PACIENTE'] = '/consultoriovirtual/' . $idClienteConsultorio  . '/consentimientos/' . $pIdConsentimiento . '_firma.png';
    $_SESSION['URL_FIRMA_DESTINO'] = '../../../../consultoriovirtual/' . $idClienteConsultorio  . '/consentimientos/';   
    $_SESSION['URL_HUELLA_PACIENTE'] = '/consultoriovirtual/' . $idClienteConsultorio  . '/consentimientos/' . $pIdConsentimiento . '_huella.gif';
    $_SESSION['URL_HUELLA_DESTINO'] = '../../../../consultoriovirtual/' . $idClienteConsultorio  . '/consentimientos/';
}else{
   $_SESSION['URL_FOTO_PACIENTE'] = '/empresas/' . $idEmpresa  . '/consentimientos/' . $pIdConsentimiento . '_foto.jpg';
   $_SESSION['URL_FOTO_DESTINO'] = '../../../../empresas/' . $idEmpresa  . '/consentimientos/'; 
   $_SESSION['URL_FIRMA_PACIENTE'] = '/empresas/' . $idEmpresa  . '/consentimientos/' . $pIdConsentimiento . '_firma.png'; 
   $_SESSION['URL_FIRMA_DESTINO'] = '../../../../empresas/' . $idEmpresa  . '/consentimientos/';
   $_SESSION['URL_HUELLA_PACIENTE'] = '/empresas/' . $idEmpresa  . '/consentimientos/' .  $pIdConsentimiento . '_huella.gif';
   $_SESSION['URL_HUELLA_DESTINO'] = '../../../../empresas/' . $idEmpresa  . '/consentimientos/'; 
}

?>
<!DOCTYPE>
<html>
    <head>
            <meta http-equiv="Content-Type" content="text/html; charset=UTF-8">
            <title>eOfiClinic ... !Sistema de Información Especializado para el Sector Salud..¡</title>
            <META http-equiv="imagetoolbar" content="no">
            <meta name="robots" content="noindex, nofollow">
            <meta name="viewport" content="width=device-width,initial-scale=1,maximum-scale=1.0">
            <link rel="stylesheet" type="text/css" href="../../../../lib/extjs/resources/css/ext-all.css"/>
            <link rel="stylesheet" type="text/css" href="../../../../lib/extjs/resources/css/xtheme-gray.css" />
            <link rel="stylesheet" type="text/css" href="../../../../lib/extjs/resources/css/Multiselect.css"/>
            <link rel="stylesheet" type="text/css" href="../../../../lib/jquery/sexyalertbox.css"/>
            <link rel="stylesheet" type="text/css" href="../../../../core/css/styles.css">
            <link rel="stylesheet" type="text/css" href="../../../../core/css/grid.css">
            <script type="text/javascript" src="../../../../core/js/functions.js"></script>
            <script type="text/javascript" src="../../../../lib/extjs/adapter/ext/ext-base.js"></script>
            <script type="text/javascript" src="../../../../lib/extjs/ext-all-debug.js"></script>
            <script type="text/javascript" src="../../../../lib/extjs/inputMask.js"></script>
            <script type="text/javascript" src="../../../../lib/extjs/src/locale/ext-lang-es.js"></script>
            <link rel="stylesheet" type="text/css" href="../../../../lib/extjs/shared/examples.css"/>
            <script type="text/javascript" src="../../../../lib/extjs/shared/examples.js"></script>
            <script type="text/javascript" src="../../../../lib/jquery/jquery-1.3.2.min.js"></script>
            <script type="text/javascript" src="../../../../core/js/searchfield.js"></script>
            <script type="text/javascript" src="webcam.js"></script>
            <link rel="stylesheet" href="../../../../libjq/css/bootstrap.min.css">
            <script src="../../../../libjq/js/vendor/modernizr-respond.min.js"></script>
            <script src="../../../../libjq/js/vendor/jquery-2.2.1.js"></script>
            <script src="../../../../libjq/js/vendor/bootstrap.min.js"></script>
            <link href="../../../../libjq/js/vendor/alertify/alertify.core.css" rel="stylesheet" />
            <link href="../../../../libjq/js/vendor/alertify/alertify.default.css" rel="stylesheet" />
            <script src="../../../../libjq/js/vendor/alertify/alertify.js"></script>
            <script src="../../../../libjq/js/vendor/jsignature/jSignature.min.noconflict.js"></script>
            <script src="pasteimage.js"></script>
            <link rel="stylesheet" href="rocanvas.css?v=1.0">
            <style type="text/css">
                div {
                        margin-top:1em;
                        margin-bottom:1em;
                }
                input {
                        padding: .5em;
                        margin: .5em;
                }
                select {
                        padding: .5em;
                        margin: .5em;
                }

                #signatureparent {
                        color:darkblue;
                        background-color:darkgrey;
                        /*max-width:600px;*/
                        padding:20px;
                }
                /*This is the div within which the signature canvas is fitted*/
                #signature {
                        border: 2px dotted black;
                        background-color:lightgrey;
                }
                #signatureparentAco {
                        color:darkblue;
                        background-color:darkgrey;
                        /*max-width:600px;*/
                        padding:20px;
                }
                /*This is the div within which the signature canvas is fitted*/
                #signatureAco {
                        border: 2px dotted black;
                        background-color:lightgrey;
                }

                /* Drawing the 'gripper' for touch-enabled devices */ 
                html.touch #content {
                        float:left;
                        width:92%;
                }
                html.touch #scrollgrabber {
                        float:right;
                        width:4%;
                        margin-right:2%;
                        background-image:url(data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAAAEAAAAFCAAAAACh79lDAAAAAXNSR0IArs4c6QAAABJJREFUCB1jmMmQxjCT4T/DfwAPLgOXlrt3IwAAAABJRU5ErkJggg==)
                }
                html.borderradius #scrollgrabber {
                        border-radius: 1em;
                }
            </style>
    </head>
    <body style="margin: 5,0,0,0;">
        <input id="idempresa" name="idempresa"  type="hidden" value="<?php echo $idEmpresa;?>"/>
        <input id="nomempresa" name="nomempresa"  type="hidden" value="<?php echo $nomEmpresa;?>"/>
        <input id="idcliente" name="idcliente"  type="hidden" value="<?php echo $idCliente;?>"/>
        <input id="nomcliente" name="nomcliente"  type="hidden" value="<?php echo $nomCliente;?>"/>
        <input id="idsede" name="idsede"  type="hidden" value="<?php echo $idSede;?>"/>
        <input id="nomsede" name="nomsede"  type="hidden" value="<?php echo $nomSede;?>"/>
        <input id="idips" name="idips"  type="hidden" value="<?php echo $idIps;?>"/>
        <input id="nomips" name="nomips"  type="hidden" value="<?php echo $nomIps;?>"/>
        <input id="idusuario" name="idusuario"  type="hidden" value="<?php echo $idUsuario;?>"/>
        <input id="nomusuario" name="nomusuario"  type="hidden" value="<?php echo $nomUsuario;?>"/>
        <input id="codusuario" name="codusuario"  type="hidden" value="<?php echo $codUsuario;?>"/>
        <input id="idperfil" name="idperfil"  type="hidden" value="<?php echo $idPerfil;?>"/>
        <input id="FecSistema" name="FecSistema"  type="hidden" value="<?php echo "02/02/2011";?>"/>
        <input id="FecControl" name="FecControl"  type="hidden" value="<?php echo "15/01/2011";?>"/>
        <input id="ofiversion" name="ofiversion"  type="hidden" value="<?php echo $idVersion;?>"/>
        <input id="idseguir" name="idseguir"  type="hidden" value="<?php echo $seguir;?>"/>
        <input id="idURL" name="idURL"  type="hidden" value="<?php echo $idURL;?>"/>
        <input id="sysIdConsentimiento" name="sysIdConsentimiento"  type="hidden" value="<?php echo $pIdConsentimiento;?>"/>
        <input id="sysFoto" name="sysFoto"  type="hidden" value="0"/>
        <input id="sysFirma" name="sysFirma"  type="hidden" value="0"/>
        <input id="sysFirmaAco" name="sysFirmaAco"  type="hidden" value="0"/>
        <input id="sysHuella" name="sysHuella"  type="hidden" value="0"/>
        <input id="sysGuardo" name="sysGuardo"  type="hidden" value="0"/>
        
        <div class="row">
            <div class="col-md-1"></div>
            <div class="col-md-10">
                <table border="1" width="100%" cellpadding="5" style=" border-style: solid;">
                    <tr>
                        <td width="25%">
                            <?php echo '<img src="../../../../empresas/' . $_SESSION['ID_EMPRESA'] . '/logo/logoenc.png"/>';?>
                        </td>
                        <td width="50%">
                            <p style="padding: 5px; font-weight: bold; color: darkblue; text-align: center; font-size: 24px;"><?php echo $pTitulo;?></p>
                        </td>
                        <td width="25%">
                            <p style="padding: 5px; font-weight: bold; color: darkblue; text-align: justify; font-size: 12px;">
                            <?php echo $pCodigo;?><br>
                            <?php echo $pVersionConsentimiento;?><br>
                            PAGINACIÓN: 1 DE 1<br>
                            <?php echo $pFechaPublica;?><br>
                            SISTEMA DE GESTIÓN DE CALIDAD
                            </p>
                        </td>
                    </tr>
                </table>
            </div>
            <div class="col-md-1"></div>
        </div>
        <div class="row">
            <div class="col-md-1"></div>
            <div class="col-md-10">
                <span style=" font-size: 24px; text-align: justify; ">
                    <span id="sysContenidoConcentimiento000">
                        <span align="center"><b>(En cumplimiento de la ley 23 de 1981 y las guías de Prácticas clínicas para la Seguridad del Paciente. Ministerio de la protección Social 2010)</b></span><br><br>Yo: <u><?php echo $pNomPaciente; ?></u> con Documento de identidad: <u><?php echo $pDocPaciente; ?></u> Edad <u><?php echo $pEdadPaciente; ?></u>, En forma voluntaria, consiento que el funcionario: <u><?php echo $pNomProfesional; ?></u>.<br><br>
                        <p>A trav&eacute;s del presente, <strong>AUTORIZO</strong> al Doctor m&aacute;s abajo identificado, as&iacute; mismo DECLARO y MANIFIESTO,&nbsp; en pleno uso de mis facultades mentales, libre y espont&aacute;neamente y en consecuencia lo siguiente:<br /><br />La instituci&oacute;n a trav&eacute;s de sus profesionales adscritos y dem&aacute;s personal vinculado me ha explicado en forma suficiente y adecuada en que consiste el tratamiento y me ha indicado a si mismo cu&aacute;les son sus consecuencias, ventajas, riesgos y posibles complicaciones y/o molestias que puedan presentarse y han permitido que haga las preguntas necesarias de las cuales han dado respuesta en forma satisfactoria y clara. Me explicaron y entend&iacute; lo siguiente:<br /><br />1. Me explicaron que la ortodoncia es el tratamiento indicado para corregir las mal posiciones dentarias que desgastan los dientes y causan muchos otros problemas, no solo dentales sino tambi&eacute;n articulares y est&eacute;ticos. Para este proceso se utilizan diferentes tipos de aparatos fijos y removibles para mover los dientes, volver a entrenar los m&uacute;sculos y modificar el crecimiento de los maxilares, con el fin de corregir sus posibles alteraciones y mantenerlos dentro de un estado &oacute;ptimo de salud y armon&iacute;a. Los aparatos fijos m&aacute;s comunes, consisten en un sistema de bandas, alambres y brackets que funcionan aplicando la presi&oacute;n&nbsp; indicada sobre los dientes y los huesos. Que tambi&eacute;n existen aparatos especiales de acuerdo al caso. Me explicaron las alternativas de tratamiento y que para el inicio de la ortodoncia, se programa una cita para el montaje de aparatolog&iacute;a (brackets) y a partir de esta cita la programaci&oacute;n ser&aacute; mensual de acuerdo al caso. Al lograr los objetivos ideales del tratamiento, el siguiente paso ser&aacute; el retiro de la aparatolog&iacute;a y colocaci&oacute;n de los retenedores, para los cuales debo asistir a controles indicados por el ortodoncista. De acuerdo a esta informaci&oacute;n, declaro que eleg&iacute; la alternativa de tratamiento m&aacute;s indicada para mi caso y presupuesto.<br /><br />2. <strong>RIESGOS TIPICOS Y LIMITACIONES</strong> (riesgos m&aacute;s comunes y frecuentes del tratamiento)<br />La prestaci&oacute;n de este servicio no tiene por objeto el logro concreto de un resultado espec&iacute;fico sino corresponde a una obligaci&oacute;n de medio por cuanto la salud oral no es una ciencia exacta. Toda forma de tratamiento m&eacute;dico y dental, incluida la ortodoncia tiene riesgos y limitaciones. Afortunadamente en la ortodoncia las complicaciones no son frecuentes y cuando ocurren, generalmente son de poca importancia, no obstante deben considerarse las mismas al tomar la decisi&oacute;n de someterse al tratamiento de ortodoncia.<br /><br />&nbsp; * <strong>Caries dental</strong>: que se puedan presentar por malos h&aacute;bitos en la higiene oral y/o no seguir las recomendaciones dadas por el(los) especialistas(s)<br /><br />&nbsp; * <strong>Gingivitis</strong>: Es una inflamaci&oacute;n de la enc&iacute;a en donde puede haber sangrado y aumento de tama&ntilde;o de la enc&iacute;a, que se produce por no realizar una adecuada higiene. Cuando el aumento de tama&ntilde;o de la enc&iacute;a se convierte en un proceso cr&oacute;nico (hiperplasia gingival) se debe recurrir a procedimientos quir&uacute;rgicos para su correcci&oacute;n que deben ser asumidos por el paciente.<br /><br />&nbsp; * <strong>Manchas en los dientes</strong>: pueden estar asociadas a caries o descalcificaciones en los dientes que se pueden presentar por mala higiene o por cambios hormonales. Por esto es importante informar al profesional tratante sobre cualquier anomal&iacute;a o cambio hormonal que se presente en el transcurso del tratamiento para poder adoptar las precauciones necesarias.<br /><br />&nbsp; * <strong>Reabsorciones radiculares</strong>: En algunos casos la longitud de las ra&iacute;ces de los dientes puede sufrir una remodelaci&oacute;n sobre todo en el &aacute;pice radicular (punta de la ra&iacute;z) que se considera un proceso normal por el movimiento dentario, pero en otros casos esta remodelaci&oacute;n puede convertirse en un proceso m&aacute;s severo y reducir notablemente el tama&ntilde;o de la ra&iacute;z de los dientes, por tal motivo es indispensable no dejar de programar y asistir a las citas durante el transcurso del tratamiento y realizarse los ex&aacute;menes radiogr&aacute;ficos que le indiquen los especialistas tratantes para controlar la punta de las ra&iacute;ces.<br /><br />&nbsp; * Pacientes con enfermedad periodontal: No est&aacute; contraindicado un tratamiento ortod&oacute;ncico para aquellos pacientes con enfermedad periodontal siempre y cuando est&eacute;n controlados por el periodoncista y su enfermedad no este activa. Estos pacientes deber&aacute;n ser valorados peri&oacute;dicamente y tomar ayudas diagnosticas como radiograf&iacute;as, no incluidas en el plan de tratamiento de ortodoncia, para ir evaluando el progreso del tratamiento y controlando los tejidos de soporte (hueso &ndash; enc&iacute;a)<br /><br />&nbsp; * Puede surgir (con o sin ortodoncia) problemas en la articulaci&oacute;n temporomandibular (ATM) que causen dolor de cabeza, de o&iacute;do o de la misma articulaci&oacute;n, o simplemente ruidos que se generan al abrir o cerrar la boca. En la gran mayor&iacute;a de los casos estos ruidos y dolores disminuyen pero no siempre desaparecen por ser un problema ya instaurado en la articulaci&oacute;n, sin embargo se debe avisar al especialista sobre cualquier anomal&iacute;a.<br /><br />&nbsp; * Es posible que una pieza dental por una restauraci&oacute;n existente (calza, resina, amalgama), o por un accidente anterior, se haya afectado el nervio (pulpa), por esto en algunos casos el movimiento ortodontico puede agravar esta condici&oacute;n y puede ser necesario un tratamiento de conducto no incluido en el plan de ortodoncia.<br /><br />&nbsp; * Es posible que una pieza dental por una restauraci&oacute;n existente (calza, resina, amalgama), o por un accidente anterior, se haya afectado la corona del diente, siendo posible que exista una l&iacute;nea de fractura&nbsp; la cual se puede acentuar con los movimientos ortodonticos, por lo que ser&iacute;a necesario una restauraci&oacute;n mayor no incluida en el tratamiento de ortodoncia.<br /><br />&nbsp; * La cirug&iacute;a oral, extracci&oacute;n de piezas dentales, o la cirug&iacute;a ortogn&aacute;tica pueden ser necesarios para el tratamiento de ortodoncia para corregir api&ntilde;amiento, malas oclusiones, l&iacute;neas medias, etc. Antes de realizar alguno de estos procedimientos debe consultar al cirujano sobre los riesgos y costos impl&iacute;citos en este tratamiento que no incluye la ortodoncia.<br /><br />&nbsp; * Debido a la gran variaci&oacute;n en el tama&ntilde;o y forma de los dientes as&iacute; como la perdida prematura de dientes o molares, se puede requerir de un tratamiento restaurativo (cierre de espacios con cosm&eacute;tica dental, correcci&oacute;n de anomal&iacute;a de forma de los dientes con cosm&eacute;tica dental, tratamiento con corona&nbsp; y puentes y/o colocaci&oacute;n de implantes). Los costos de estos tratamientos no est&aacute;n considerados dentro del costo del tratamiento de ortodoncia, por lo tanto deben ser asumidos por el paciente.<br /><br />&nbsp; * Cuando hay dientes impactados (especialmente los caninos), puede ser dif&iacute;cil su ubicaci&oacute;n adecuada en el arco dental y puede presentarse problemas periodontales. Estos casos pueden aumentar el tiempo activo del tratamiento, por lo tanto es importante que consulte con su especialista sobre c&oacute;mo va el curso del tratamiento. Igualmente, en este caso se requerir&aacute; realizar al paciente un procedimiento denominado &ldquo;ventana quir&uacute;rgica&rdquo; no incluido en el plan de ortodoncia.<br /><br />&nbsp; * Es posible que por un trauma (golpe) o por una raz&oacute;n desconocida&nbsp; un diente se anquilosa (no se puede mover) y no sea posible colocarlo en la posici&oacute;n adecuada. Est&aacute; en una limitante del tratamiento.<br /><br />&nbsp; * Durante la vida de toda persona, la mordida puede cambiar de manera adversa interfiriendo con el desarrollo y/o estabilidad del tratamiento de ortodoncia, lo cual ocurre por diversas causas como cambios durante el crecimiento, respirar por la boca, tocar instrumentos de viento y otros h&aacute;bitos orales que est&aacute;n fuera de control del ortodoncista.<br /><br />&nbsp; * Las enc&iacute;as, las mejillas y los labios pueden irritarse a causa de los aparatos rotos, sueltos o por golpes en la boca, por lo cual es necesario que cualquier molestia se la comunique al especialista tratante.<br /><br />3. Adem&aacute;s de los riesgos t&iacute;picos antes descritos, por mi circunstancias especiales hay que esperar los siguientes <strong>riesgos personalizados</strong> <span id="strORTO1"><input id="sysORTO1" type="text" /></span><br /><br />4. Son considerados malos h&aacute;bitos orales la respiraci&oacute;n oral, succi&oacute;n de dedos o la interposici&oacute;n lingual que pueden afectar el desarrollo del tratamiento y su estabilidad despu&eacute;s de terminado, por lo tanto el paciente debe realizar las interconsultas necesarias y los tratamientos correspondientes con los especialistas para no perder los logros o para que el tratamiento no se vea interrumpido por falta de interconsulta, lo cual tambi&eacute;n es considerado un incumplimiento del tratamiento de ortodoncia, debiendo el paciente en ese caso cancelar los controles adicionales para la terminaci&oacute;n del mismo. Es necesario que el paciente presente al ortodoncista tratante el informe o contraremision escrita de la evoluci&oacute;n.<br /><br />5. Perdida o fractura de la aparatolog&iacute;a: los Brackets y dem&aacute;s aparatolog&iacute;a se cementan con un material bastante resistente, de calidad certificada y garantizada, sin embargo se deben tener cuidados especiales. Si usted es cuidadoso se quedaran en su lugar durante todo el tratamiento. Los brackets <strong>NO</strong> se caen, usted puede descementarlos si consume alg&uacute;n alimento contraindicado. Si la descementacion de los brackets no ocurre inmediatamente, es probable que se hayan desprendido pero usted solo lo note cuando ingiera algo suave, tome liquido o cepille sus dientes. Est&aacute; comprobado cl&iacute;nicamente que los brackets y dem&aacute;s aparatolog&iacute;a se da&ntilde;an &uacute;nicamente por no seguir las recomendaciones para el tratamiento de ortodoncia.<br /><br />6. Est&aacute; contraindicado ingerir productos pegajosos, tostados, duros o crujientes. Alimentos como manzana sin cascaras, peras sin cascara, pan tostado, zanahoria, mazorca o similares se pueden consumir parti&eacute;ndolos en trozos peque&ntilde;os. No desgarre los alimentos, ni consuma chicles, melcochas, bocadillos, manimotos, almendras, hielo, ma&iacute;z pira, ni introduzca objetos extra&ntilde;os en sus dientes como l&aacute;pices o palillos. El no seguir estas recomendaciones acarrear&aacute; las reparaciones necesarias a cargo del paciente para continuar con el tratamiento, la descementacion continua de brackets, bandas o tubos es causal de pago de controles adicionales y conlleva el retraso en el tiempo de duraci&oacute;n del tratamiento.<br /><br />7. La <strong>INCOMODIDAD</strong>: es normal sentir molestia en los dientes, en las enc&iacute;as y en los labios durante algunas semanas despu&eacute;s de la cementaci&oacute;n de la aparatolog&iacute;a ortod&oacute;ntica. A medida que los dientes se van acomodando sentir&aacute; muerde diferente, estos cambios son normales. Es probable que se le dificulte comer o pronunciar algunas letras, esto es transitorio, no se alarme. Si el extremo de alg&uacute;n alambre se levanta y siente una molestia mayor, coloque cera de ortodoncia en la zona y comente lo sucedido en el siguiente control o ac&eacute;rquese a la cl&iacute;nica donde le realizan el tratamiento, para atender la urgencia en el horario de atenci&oacute;n al p&uacute;blico.<br /><br />8. <strong>HIGIENE ORAL Y CEPILLADO</strong>: En los dientes se acumulan alimentos, situaci&oacute;n que se incrementa con el uso de aparatolog&iacute;a de ortodoncia, por lo cual debe cumplir con una adecuada rutina de higiene. Si no limpian adecuadamente los dientes, se forma placa bacteriana que produce mal aliento, caries, manchas, inflamaci&oacute;n y sangrado de las enc&iacute;as. Si las enc&iacute;as se inflaman se impide el adecuado movimiento de los dientes durante el tratamiento, por lo cual el mismo se prolonga innecesariamente.</p><p><br />&nbsp; * <strong>Instrucciones de cepillado</strong>: El no seguir correctamente las instrucciones de cepillado dadas por el especialista y/o hacer uso inadecuado de los aditamentos aqu&iacute; enunciados, puede ocasionar la descenmentacion o ca&iacute;da de la aparatolog&iacute;a.<br /><br />Seda dental: puede ayudarse con el uso de enhebradores limpiando en cada espacio las dos superficies.<br /><br />Cepille sus dientes despu&eacute;s de cada comida y antes de dormir: Es importante limpiar los brackets y las enc&iacute;as de la forma como le ha sido explicada por el especialista, utilizando el cepillo de dientes convencional y el cepillo unipenacho.<br /><br />Enjuague bucal: luego de utilizar la seda dental y cepillar sus dientes, use enjuague bucal. Preferiblemente utilice enjuague especial para ortodoncia o util&iacute;celo exclusivamente si su especialista as&iacute; lo prescribe.<br /><br />Profilaxis: Debe realizarse una profilaxis m&iacute;nimo cada tres meses o antes si el especialista as&iacute; lo prescribe.<br /><br />9. <strong>COMPROMISOS DEL PACIENTE Y/O REPRESENTANTE LEGAL DEL PACIENTE</strong><br />&nbsp; * Cumplir y programar las citas para llevar a cabo el tratamiento a raz&oacute;n de un control de cada 30 d&iacute;as calendario o con una periodicidad menor si as&iacute; lo estima necesario el especialista tratante, pues recuerde que la inasistencia a cualquier control es causal de pago de controles adicionales.<br />&nbsp; * Cumplir con las instrucciones de higiene oral y el uso adecuado de cepillos, seda dental, enjuagues bucales y dem&aacute;s recomendaciones dadas por el especialista.<br />&nbsp; * Cumplir con las remisiones de interconsulta medica odontol&oacute;gica o de otras especialidades que sean ordenadas por el especialista tratante. El no cumplimiento de este compromiso es causal de pago de controles adicionales.<br />&nbsp; * Usar los aparatos y/o elementos extraorales e/o intraorales que requiera de la colaboraci&oacute;n del paciente para el correcto&nbsp; avance del tratamiento. El paciente y/o responsable del paciente sabe (n) que es causal de pago de controles adicionales la falta de colaboraci&oacute;n en el desarrollo del tratamiento.<br />&nbsp; * Realizarse a su costa los tratamientos necesarios y que le sean prescritos por los especialistas para el &eacute;xito del tratamiento de ortodoncia o dem&aacute;s ex&aacute;menes como radiograf&iacute;as panor&aacute;micas, periapicales o tomograf&iacute;a axial computarizada (TAC).<br />&nbsp; * Luego de la cementaci&oacute;n de la aparatolog&iacute;a, frente a un espejo facial y con la compa&ntilde;&iacute;a de su ortodoncista verifique que ning&uacute;n bracket presente movilidad.<br /><br />10. <strong>NO INCLUSIONES DEL TRATAMIENTO</strong><br />El valor del tratamiento NO incluye y por lo tanto deber&aacute;n ser asumidos por el paciente y/o responsable del paciente:<br />&nbsp; * Paquete b&aacute;sico para diagn&oacute;stico de ortodoncia<br />&nbsp; * Kit de ortodoncia<br />&nbsp; * Reparaci&oacute;n de bracket<br />&nbsp; * Reparaci&oacute;n de banda o tubo<br />&nbsp; * Reparaci&oacute;n del aparato de ortopedia<br />&nbsp; * Placas o aparatolog&iacute;a adicional<br />&nbsp; * Exodoncias (s)<br />&nbsp; * Profilaxis m&iacute;nimo cada tres meses, pero de acuerdo a las circunstancias espec&iacute;ficas del paciente, el Ortodoncista puede considerarlas necesarias con mayor frecuencia.<br />&nbsp; * El&aacute;sticos<br />&nbsp; * Procedimientos Adicionales<br />&nbsp; * Radiograf&iacute;a panor&aacute;mica de control anual, tres meses antes del retiro de la aparatolog&iacute;a y de finalizaci&oacute;n de tratamiento para retiro de la aparatolog&iacute;a. Las anteriores radiograf&iacute;as son las m&iacute;nimas requeridas durante el tratamiento, pero el especialista podr&aacute; solicitar otras si as&iacute; lo considera necesario.<br />&nbsp; * Fotos de finalizaci&oacute;n<br />&nbsp; * Retenedores, los cuales se colocaran una vez retirados los brackets, esto con el fin de darle estabilidad y garant&iacute;a al tratamiento de ortodoncia realizado.<br /><br />11. <strong>Los RETENEDORES</strong>: Al paciente y/o representante legal del paciente se le(s) explico y entendi&oacute; (entendieron) la importancia del uso de los retenedores como parte final del tratamiento de ortodoncia, ya que el no uso de los mismos en el tiempo y forma prescrito por el especialista conlleva la involuci&oacute;n del tratamiento sin que exista soluci&oacute;n al respecto, pues en este caso si quiere recuperar los resultados obtenidos debe iniciar un nuevo tratamiento de ortodoncia. El paciente y/o responsable del paciente es (son) conscientes (s) de esta situaci&oacute;n, igualmente si por alguna circunstancia el paciente no se toma radiograf&iacute;a panor&aacute;mica y fotos de finalizaci&oacute;n, no podr&aacute;(n) hacer ning&uacute;n tipo de reclamaci&oacute;n a la cl&iacute;nica ni a los especialistas tratantes.<br /><br />12. Declaro que he le&iacute;do y entendido este consentimiento, ya que se me han aclarado las dudas e interrogantes sobre este, acerca de la naturaleza y prop&oacute;sito del tratamiento y de las sustancias e insumos involucrados, beneficios, complicaciones, efectos secundarios, riesgos previsibles y consecuencias, habiendo dado mi consentimiento informado, acuerdo por la presente liberar a la entidad tratante, a sus empleados y contratistas de cualquier responsabilidad con respecto al permiso para este (estos) procedimientos(s) odontol&oacute;gicos(s) y riesgos o resultados desfavorables inmediatos o tard&iacute;os de imposible o dif&iacute;cil previsi&oacute;n para dicho(s) tratamiento(s).<br /><br />13. Entiendo por lo tanto que en el curso del (los) tratamiento(s) pueden presentarse situaciones especiales e imprevistas que requieran procedimientos adicionales cuyos costos deben ser asumidos por el paciente.<br /><br />14. Por ello, manifiesto que estoy satisfecho con la informaci&oacute;n recibida&nbsp; y que comprendo el alcance y los riesgos del tratamiento, y en tales condiciones, autorizo al profesional de la instituci&oacute;n designe, para que en ejercicio legal de su profesi&oacute;n me realice los siguientes procedimientos:<span id="strORTO2"><input id="sysORTO2" type="text" /></span><br /><br />Comprendo las implicaciones del presente consentimiento, me encuentro en capacidad de expresarme y dejo constancia que los espacios en blanco han sido diligenciados antes de mi firma.<br /><br /><strong>NOTA</strong>: Cuando el paciente no tenga capacidad legal o mental para otorgar el consentimiento, las manifestaciones de los contenidos en el presente documento son hechas por la persona responsable que lo representa.</p><br>
                    </span>
                    <hr>
                    <div class="row">
                        <div class="col-md-12 text-center">
                            <label class="radio-inline"><input type="radio" id="bolAceptoConsentimiento" name="bolAceptoConsentimiento" value="ACEPTO" checked><strong style="color: darkgreen;">ACEPTO</strong></label>
                            <label class="radio-inline"><input type="radio" id="bolAceptoConsentimiento" name="bolAceptoConsentimiento" value="NO ACEPTO"><strong style="color: darkred;">NO ACEPTO</strong></label>
                        </div>
                    </div>
                </span>
            </div>
            <div class="col-md-1"></div>
        </div>
        <div class="container">
            <h2>Foto del Paciente</h2>
            <div class="panel panel-default">
                <div class="panel-body">
                    <div class="row">
                        <div class="col-md-12 text-center">
                            <center>
                                <table border="1">
                                    <tr>
                                        <td>
                                            <video id="sysImgFoto" autoplay="true" width="320" height="240">
                                                No hay soporte para video en su navegador
                                            </video>
                                            <canvas id="canvas" width="320" height="240" style="display: none"></canvas>
                                        </td>
                                    </tr>
                                    <tr>
                                        <td colspan="2" align="center">
                                            <button id="snap" style="font-size: 22px;" class="btn btn-sm btn-success" onclick="take_snapshot();">Capturar Foto</button>
                                            <script>
                                                var video=document.querySelector('#sysImgFoto');
                                                var canvas=document.querySelector('#canvas');
                                                var context=canvas.getContext('2d');
                                                var w,h,ratio;
                                                navigator.getUserMedia = navigator.getUserMedia || navigator.webkitGetUserMedia || navigator.mozGetUserMedia || navigator.msGetUserMedia || navigator.oGetUserMedia;
                                                if(navigator.getUserMedia){
                                                    navigator.getUserMedia({video: true}, handleVideo, videoError);
                                                }
                                                video.addEventListener('loadedmetadata', function() {
                                                    ratio = video.videoWidth/video.videoHeight;
                                                    w = video.videoWidth-100;
                                                    h = parseInt(w/ratio,10);
                                                    canvas.width = w;
                                                    canvas.height = h;
                                                },false);
                                                function handleVideo(stream){
                                                    video.srcObject = stream;
                                                }
                                                function videoError(e){
                                                    alert("Problema con la camara web");
                                                }
                                                function take_snapshot() {
                                                    if($("#sysFoto").val() == "0"){
                                                        context.fillRect(0, 0, w, h);
                                                        context.drawImage(video, 0, 0, w, h);
                                                        //var imagen = canvas.toDataURL("image/png");
                                                        var data = canvas.toDataURL("image/jpeg");
                                                        var xhr = new XMLHttpRequest();
                                                        xhr.onreadystatechange = function() {
                                                          if (xhr.readyState == 4) {
                                                            alertify.success("Se capturo la foto correctamente.");
                                                          }
                                                        };
                                                        xhr.open('POST','savefotopac2021.php',true);
                                                        xhr.setRequestHeader('Content-Type', 'application/upload');
                                                        xhr.send(data);
                                                    }else{
                                                        alertify.set({ delay: 4000 });
                                                        alertify.error("Ya se registro la foto del paciente.");
                                                    }
                                                }
                                            </script>
                                        </td>
                                    </tr>
                                </table>
                            </center>
                        </div>
                    </div> 
                    
                </div>
            </div>
        </div>
        <div class="container">
            <h2>Huella del Paciente</h2>
            <div class="panel panel-default">
                <div class="panel-body">
                    <div class="row">
                        <div class="col-md-12 text-center">
                            <img id="imgHuellaPac">
                            <div id="rodiv2"><canvas id="sampleBoard2" width="181" height="181" style="border:1pt solid black"></canvas><p>presione ctrl+v para pegar la huella</p></div>
                            <script src="rocanvas.js"></script>
                            <script>     
                                var r2=new RoCanvas;
                                r2.RO("sampleBoard2", {
                                    "toolbar": {
                                        colors: null,
                                        custom_color: false,
                                        tools: null,
                                        sizes: null,			
                                        saveButton: {"text": "Guardar Huella", "callback": "testSave(r2);"}			
                                    },
                                    "settings": {
                                        color: '#000'		
                                    }
                                });

                                function testSave(instance){
                                    if(COPY_FINGERPRINT === 1){
                                        if($("#sysHuella").val() == "0"){
                                            var datosHuella = instance.serialize();
                                            var ajax = new XMLHttpRequest();
                                            ajax.open("POST",'savehuellapac2021.php?p0=' + $("#sysIdConsentimiento").val(),false);
                                            ajax.onreadystatechange = function() {
                                                console.log(ajax.responseText);
                                            };
                                            ajax.setRequestHeader('Content-Type', 'application/upload');
                                            ajax.send("imgData="+datosHuella);
                                            $("#sysHuella").val(1);
                                            alertify.set({ delay: 5000 });
                                            alertify.success("Se capturo la huella correctamente.");
                                            setTimeout(function(){
                                                //window.close();
                                            }, 6000);
                                        }else{
                                            alertify.set({ delay: 4000 });
                                            alertify.error("Ya se registro la huella del paciente.");
                                        }
                                    }else{
                                        alertify.set({ delay: 4000 });
                                        alertify.error("No ha pegado la huella del paciente.");
                                    }
                                }
                           </script>
                        </div>
                    </div> 
                    
                </div>
            </div>
        </div>
        <div class="container">
            <h2>Firma del Paciente</h2>
            <div class="panel panel-default">
                <div class="panel-body">
                    <div class="row">
                        <div class="col-md-12 text-center">
                            <button id="btnGuardarNOFirma" style="font-size: 22px;" class="btn btn-sm btn-primary" onclick="guardarNOFirma();">Paciente NO Firma</button>
                            <button id="btnLimpiar" style="font-size: 22px;" class="btn btn-sm btn-warning" onclick="limpiar();">Limpiar</button>
                            <button id="btnGuardarFirma" style="font-size: 22px;" class="btn btn-sm btn-success" onclick="guardarFirma();">Guardar Firma</button>
                        </div>
                    </div> 
                    <div id="content">
                        <div id="signatureparent">
                            <div id="signature"></div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        <div class="container">
            <h2>Firma del Acudiente / Acompañante</h2>
            <div class="panel panel-default">
                <div class="panel-body">
                    <div class="row">
                        <div class="col-md-12 text-center">
                            <button id="btnLimpiarAco" style="font-size: 22px;" class="btn btn-sm btn-warning" onclick="limpiarAco();">Limpiar</button>
                            <button id="btnGuardarFirmaAco" style="font-size: 22px;" class="btn btn-sm btn-success" onclick="guardarFirmaAco();">Guardar Firma</button>
                            </div>
                    </div> 
                    <div id="content">
                        <div id="signatureparentAco">
                            <div id="signatureAco"></div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        <div class="row">
            <div class="col-md-12 text-center">
                <button id="btnSalir" style="font-size: 22px;" class="btn btn-sm btn-danger" onclick="salir();">Salir</button>
                <button id="btnGuardarCI000" style="font-size: 22px;" class="btn btn-sm btn-success" onclick="GuardarCI000();">Guardar Consentimiento</button>
            </div>
        </div> 
    </body>
    <script>
        $sigdiv = "";
        $sigdivAco = "";
        COPY_FINGERPRINT = 0;
        $(function(){ 
            $sigdiv = $("#signature").jSignature({'UndoButton':false, 'color':"black"});
            $sigdivAco = $("#signatureAco").jSignature({'UndoButton':false, 'color':"black"});
            COPY_FINGERPRINT = 0;
            var CLIPBOARD = new CLIPBOARD_CLASS("sampleBoard2", true);
        });
        
        function limpiar(){
            $sigdiv.jSignature('reset');
        }
        function limpiarAco(){
            $sigdivAco.jSignature('reset');
        }
        function salir(){
            window.close();
        }
        function guardarFirma(){
            if($("#sysFirma").val() == "0"){
                Ext.Msg.show({
                    title: 'eOfiClinic',
                    msg: 'Esta seguro que desea registrar la Firma?',
                    buttons: Ext.Msg.YESNO,
                    icon: Ext.Msg.QUESTION,
                    fn: function(btn){
                        if(btn=="yes"){
                            var dataImg = $sigdiv.jSignature('getData', 'image');
                            $.ajax({
                                type: "POST",
                                url: "controlador_firma.php",
                                data: {
                                    task: 'GUARDAR_FIRMA',
                                    p0: $("#sysIdConsentimiento").val(),
                                    pImagen: dataImg
                                }, 
                                success: function(data){
                                    var response = JSON.parse(data);
                                    if(response['success'] === "true"){
                                        $("#sysFirma").val(1);
                                        alertify.set({ delay: 5000 });
                                        alertify.success("Se capturo la firma correctamente.");
                                        setTimeout(function(){
                                            //window.close();
                                        }, 6000);
                                    }else{
                                        $("#sysFirma").val(0);
                                        alertify.set({ delay: 4000 });
                                        alertify.error("No podemos registrar la firma en estos momentos, por favor vuelve a intentarlo.");
                                    }
                                }
                            });
                        }
                    }
                });
            }else{
                alertify.set({ delay: 4000 });
                alertify.error("Ya se registro la firma del paciente.");
            }
        }
        function guardarNOFirma(){
            if($("#sysFirma").val() == "0"){
                Ext.Msg.show({
                    title: 'eOfiClinic',
                    msg: 'Esta seguro que desea registrar como NO Firma?',
                    buttons: Ext.Msg.YESNO,
                    icon: Ext.Msg.QUESTION,
                    fn: function(btn){
                        if(btn=="yes"){
                            $.ajax({
                                type: "POST",
                                url: "controlador_firma.php",
                                data: {
                                    task: 'GUARDAR_NO_FIRMA',
                                    p0: $("#sysIdConsentimiento").val()
                                }, 
                                success: function(data){
                                    var response = JSON.parse(data);
                                    if(response['success'] === "true"){
                                        $("#sysFirma").val(1);
                                        alertify.set({ delay: 5000 });
                                        alertify.success("Se Registro como NO FIRMADO correctamente.");
                                        setTimeout(function(){
                                            //window.close();
                                        }, 6000);
                                    }else{
                                        $("#sysFirma").val(0);
                                        alertify.set({ delay: 4000 });
                                        alertify.error("No podemos registrar como NO FIRMADO en estos momentos, por favor vuelve a intentarlo.");
                                    }
                                }
                            });
                        }
                    }
                });
            }else{
                alertify.set({ delay: 4000 });
                alertify.error("Ya se registro la firma del paciente.");
            }
        }
        function guardarFirmaAco(){ 
            if($("#sysFirmaAco").val() == "0"){
                Ext.Msg.show({
                    title: 'eOfiClinic',
                    msg: 'Esta seguro que desea registrar la Firma del acompañante - acudiente?',
                    buttons: Ext.Msg.YESNO,
                    icon: Ext.Msg.QUESTION,
                    fn: function(btn){
                        if(btn=="yes"){
                            var dataImg = $sigdivAco.jSignature('getData', 'image');
                            $.ajax({
                                type: "POST",
                                url: "controlador_firma.php",
                                data: {
                                    task: 'GUARDAR_FIRMA_ACO',
                                    p0: $("#sysIdConsentimiento").val(),
                                    pImagen: dataImg
                                }, 
                                success: function(data){
                                    var response = JSON.parse(data);
                                    if(response['success'] === "true"){
                                        $("#sysFirmaAco").val(1);
                                        alertify.set({ delay: 5000 });
                                        alertify.success("Se capturo la firma del acompañante - acudiente correctamente.");
                                        setTimeout(function(){
                                            //window.close();
                                        }, 6000);
                                    }else{
                                        $("#sysFirmaAco").val(0);
                                        alertify.set({ delay: 4000 });
                                        alertify.error("No podemos registrar la firma del acompañante - acudiente en estos momentos, por favor vuelve a intentarlo.");
                                    }
                                }
                            });
                        }
                    }
                });
            }else{
                alertify.set({ delay: 4000 });
                alertify.error("Ya se registro la firma del paciente.");
            }
        }
        function CLIPBOARD_CLASS(canvas_id, autoresize) {
            var _self = this;
            var canvas = document.getElementById(canvas_id);
            var ctx = document.getElementById(canvas_id).getContext("2d");
            var ctrl_pressed = false;
            var command_pressed = false;
            var paste_event_support;
            var pasteCatcher;
            //handlers
            document.addEventListener('keydown', function (e) {
                _self.on_keyboard_action(e);
            }, false); //firefox fix
            document.addEventListener('keyup', function (e) {
                _self.on_keyboardup_action(e);
            }, false); //firefox fix
            document.addEventListener('paste', function (e) {
                _self.paste_auto(e);
            }, false); //official paste handler
            //constructor - we ignore security checks here
            this.init = function () {
    		pasteCatcher = document.createElement("div");
    		pasteCatcher.setAttribute("id", "paste_ff");
    		pasteCatcher.setAttribute("contenteditable", "");
                pasteCatcher.style.cssText = 'opacity:0;position:fixed;top:0px;left:0px;width:10px;margin-left:-20px;';
                document.body.appendChild(pasteCatcher);

    		// create an observer instance
    		var observer = new MutationObserver(function(mutations) {
                    mutations.forEach(function(mutation) {
                        if (paste_event_support === true || ctrl_pressed == false || mutation.type != 'childList'){
                            //we already got data in paste_auto()
                            return true;
                        }
                        //if paste handle failed - capture pasted object manually
    			if(mutation.addedNodes.length == 1) {
                            if (mutation.addedNodes[0].src != undefined) {
                                //image
    				_self.paste_createImage(mutation.addedNodes[0].src);
                            }
                            //register cleanup after some time.
                            setTimeout(function () {
                                pasteCatcher.innerHTML = '';
                            }, 20);
                        }
                    });
    		});
    		var target = document.getElementById('paste_ff');
    		var config = { attributes: true, childList: true, characterData: true };
    		observer.observe(target, config);
            }();
            //default paste action
            this.paste_auto = function (e) {
    		paste_event_support = false;
    		if(pasteCatcher != undefined){
                    pasteCatcher.innerHTML = '';
    		}
    		if (e.clipboardData) {
                    var items = e.clipboardData.items;
                    if (items) {
                        paste_event_support = true;
                        //access data directly
                        for (var i = 0; i < items.length; i++) {
                            if (items[i].type.indexOf("image") !== -1) {
                                //image
    				var blob = items[i].getAsFile();
    				var URLObj = window.URL || window.webkitURL;
                                var source = URLObj.createObjectURL(blob);
    				this.paste_createImage(source);
                            }
                        }
    			e.preventDefault();
                    }else {
    			//wait for DOMSubtreeModified event
    			//https://bugzilla.mozilla.org/show_bug.cgi?id=891247
                    }
    		}
            };
            //on keyboard press
            this.on_keyboard_action = function (event) {
    		k = event.keyCode;
    		//ctrl
    		if (k == 17 || event.metaKey || event.ctrlKey) {
                    if (ctrl_pressed == false){
                        ctrl_pressed = true;
                    }
    		}
    		//v
    		if (k == 86) {
                    if (document.activeElement != undefined && document.activeElement.type == 'text') {
                        //let user paste into some input
                        return false;
                    }
                    if (ctrl_pressed == true && pasteCatcher != undefined){
                        pasteCatcher.focus();
                    }
    		}
            };
            //on kaybord release
            this.on_keyboardup_action = function (event) {
    		//ctrl
    		if (event.ctrlKey == false && ctrl_pressed == true) {
                    ctrl_pressed = false;
    		}else if(event.metaKey == false && command_pressed == true){
                    command_pressed = false;
                    ctrl_pressed = false;
    		}
            };
            //draw pasted image to canvas
            this.paste_createImage = function (source) {
    		var pastedImage = new Image();
                pastedImage.onload = function () {
                    if(autoresize == true){
                        //resize
                        //canvas.width = pastedImage.width;
    			//canvas.height = pastedImage.height;
                        canvas.width = 164;
    			canvas.height = 176;
                    }else{
    			//clear canvas
    			ctx.clearRect(0, 0, canvas.width, canvas.height);
                    }
                    //ctx.drawImage(pastedImage, 0, 0);
                    ctx.drawImage(pastedImage,0,0,pastedImage.width,pastedImage.height,0,0,164,176);
                    COPY_FINGERPRINT = 1;
    		};
    		pastedImage.src = source;
            };
        }
        function GuardarCI000(){
            if($("#sysHuella").val() == "1" && $("#sysGuardo").val() == "0"){
                Ext.Msg.show({
                    title: 'eOfiClinic',
                    msg: 'Esta seguro que desea Guardar el Registro del Consentimiento Informado?',
                    buttons: Ext.Msg.YESNO,
                    icon: Ext.Msg.QUESTION,
                    fn: function(btn){
                        if(btn=="yes"){
                            var tipoaceptacion = $("input:radio[name ='bolAceptoConsentimiento']:checked").val();
                            
                            if ($('#sysORTO1').val() != "" && $('#sysORTO1').val() != null){
                                var notifica = $('#sysORTO1').val();
                                $("#strORTO1").html(notifica);
                            }else{
                                $("#strORTO1").html("");
                            }
                            
                            if ($('#sysORTO2').val() != "" && $('#sysORTO2').val() != null){
                                var notifica = $('#sysORTO2').val();
                                $("#strORTO2").html(notifica);
                            }else{
                                $("#strORTO2").html("");
                            }
                            
                            $.ajax({
                                type: "POST",
                                url: "controlador_consentimiento2018.php",
                                data: {
                                    task: 'GUARDAR_CONSENTIMIENTO',
                                    pIdConsentimiento: $("#sysIdConsentimiento").val(),
                                    pTipoAceptacion: tipoaceptacion,
                                    pConsentimiento: QuitarAcentosTxtMayusculas($("#sysContenidoConcentimiento000").html())
                                }, 
                                success: function(data){
                                    var response = JSON.parse(data);
                                    if(response['success'] === "true"){
                                        $("#sysGuardo").val(1);
                                        alertify.set({ delay: 5000 });
                                        alertify.success("Se registro el consentimiento informado correctamente.");
                                        setTimeout(function(){
                                            //window.close();
                                        }, 6000);
                                    }else{
                                        $("#sysGuardo").val(0);
                                        alertify.set({ delay: 4000 });
                                        alertify.error("No podemos registrar el consentimiento informado en estos momentos, por favor vuelve a intentarlo.");
                                    }
                                }
                            });
                        }
                    }
                });
            }else{
                alertify.set({ delay: 4000 });
                alertify.error("Debe realizar la captura de la huella que son obligatorios y/o ya realizo el registro del consentimiento y no se puede modificar.");
                //alertify.error("Debe realizar la captura de la firma y la huella que son obligatorios y/o ya realizo el registro del consentimiento y no se puede modificar.");
            }
        }
    </script>
</html>