<?php

/*
* @category    Consentimiento Informado Covid Odontologia
* @package     OfiClinic Web
* @author      Jorge Ancizar Galeano Ruiz<desarrollo@ofisalud.com>
* @copyright   2010 Jorge Ancizar Galeano Ruiz
* @version     OfiClinic Web 1.0
* @license     COMERCIAL
* @link        http://www.desarrollo@ofisalud.com
* @country     Colombia
* @telephone   3016398114
*/
require("../../../../core/php/constantes.php");
$idVersion = ofiVERSION;
session_start();
header("Cache-control: private"); // IE 6 Fix
$pPaciente = isset($_REQUEST['pPaciente'])?$_REQUEST['pPaciente']:0;
$pDocPaciente = isset($_REQUEST['p0'])?$_REQUEST['p0']:null;
$pNomPaciente = isset($_REQUEST['p1'])?$_REQUEST['p1']:null;
$pEdadPaciente = isset($_REQUEST['p2'])?$_REQUEST['p2']:null;
$pDocProfesional = isset($_REQUEST['p3'])?$_REQUEST['p3']:null;
$pNomProfesional = isset($_REQUEST['p4'])?$_REQUEST['p4']:null;
$pTitulo = isset($_REQUEST['p5'])?$_REQUEST['p5']:null;
$pCodigo = isset($_REQUEST['p6'])?$_REQUEST['p6']:null;
$pVersionConsentimiento = isset($_REQUEST['p7'])?$_REQUEST['p7']:null;
$pFechaPublica = isset($_REQUEST['p8'])?$_REQUEST['p8']:null;
$pIdConsentimiento = isset($_REQUEST['pK'])?$_REQUEST['pK']:null;
$_SESSION['ID_CONSENTIMIENTO'] = 0;

if( isset( $_SESSION['ID_EMPRESA'])){
    $idEmpresa = $_SESSION['ID_EMPRESA'];
    $nomEmpresa = $_SESSION['NOM_EMPRESA'];
    $nomAplicacion = $_SESSION['IdAplicacion'];
    $idClienteConsultorio = $_SESSION['IDBD'];
    $nomConsultorio = $_SESSION['IdNombreConsultorio'];
    $nomEspecialidad = $_SESSION['IdEspecialidadConsultorio'];
    $nomSubEspecialidad = $_SESSION['IdSubEspecialidadConsultorio'];
    $dirConsultorio = $_SESSION['IdDireccionConsultorio'];
    $telConsultorio = $_SESSION['IdTelefonoConsultorio'];
    $ciuConsultorio = $_SESSION['IdCiudadConsultorio'];
    $usaPatrocinador = $_SESSION['Patrocinador'];
    $idPatrocinador = $_SESSION['IdPatrocinador'];
    $idCliente = 0;
    $nomCliente = "&nbsp;";
    $idSede = $_SESSION['ID_SEDE'];
    $nomSede = $_SESSION['NOM_SEDE'];
    $idIps = $_SESSION['ID_IPS'];
    $nomIps = $_SESSION['NOM_IPS'];
    $idUsuario = $_SESSION['ID_USUARIO'];
    $codUsuario = $_SESSION['COD_USUARIO'];
    $nomUsuario = $_SESSION['NOM_USUARIO'];
    $idPerfil = $_SESSION['ID_PERFIL'];
    $seguir = true;
    $_SESSION['NOM_OPCION_MENU'] = $_REQUEST['OP'];
    $nomOpcion = $_SESSION['NOM_OPCION_MENU'];
    $_SESSION['DES_OPCION_MENU']= $_REQUEST['DESC'];
    $desOpcion = $_SESSION['DES_OPCION_MENU'];
    $_SESSION['ID_CONSENTIMIENTO'] = 0;
    $_SESSION['ID_CONSENTIMIENTO'] = $pIdConsentimiento;
}
else{
    $idEmpresa = 0;
    $nomEmpresa = "&nbsp;";
    $idCliente = 0;
    $nomCliente = "&nbsp;";
    $idSede = 0;
    $nomSede = "&nbsp;";
    $idIps = 0;
    $nomIps = "&nbsp;";
    $idUsuario = 0;
    $codUsuario = "&nbsp;";
    $nomUsuario = "&nbsp;";
    $idPerfil = 0;
    $seguir = false;
    $nomAplicacion = "OfiClinic";
    $nomConsultorio = "&nbsp;";
    $nomEspecialidad = "&nbsp;";
    $nomSubEspecialidad = "&nbsp;";
    $dirConsultorio = "&nbsp;";
    $telConsultorio = "&nbsp;";
    $ciuConsultorio = "&nbsp;";
    $usaPatrocinador = "NA";
    $idPatrocinador = "&nbsp;";
    $idClienteConsultorio = "X1";
    $nomOpcion = "&nbsp;";
    $desOpcion = "&nbsp;";
}
if($pNomAplicacion == "OfiMedical"){
    $_SESSION['URL_FOTO_PACIENTE'] = '/consultoriovirtual/' . $idClienteConsultorio  . '/consentimientos/' . $pIdConsentimiento . '_foto.jpg';
    $_SESSION['URL_FOTO_DESTINO'] = '../../../../consultoriovirtual/' . $idClienteConsultorio  . '/consentimientos/';
    $_SESSION['URL_FIRMA_PACIENTE'] = '/consultoriovirtual/' . $idClienteConsultorio  . '/consentimientos/' . $pIdConsentimiento . '_firma.png';
    $_SESSION['URL_FIRMA_DESTINO'] = '../../../../consultoriovirtual/' . $idClienteConsultorio  . '/consentimientos/';   
    $_SESSION['URL_HUELLA_PACIENTE'] = '/consultoriovirtual/' . $idClienteConsultorio  . '/consentimientos/' . $pIdConsentimiento . '_huella.gif';
    $_SESSION['URL_HUELLA_DESTINO'] = '../../../../consultoriovirtual/' . $idClienteConsultorio  . '/consentimientos/';
}else{
   $_SESSION['URL_FOTO_PACIENTE'] = '/empresas/' . $idEmpresa  . '/consentimientos/' . $pIdConsentimiento . '_foto.jpg';
   $_SESSION['URL_FOTO_DESTINO'] = '../../../../empresas/' . $idEmpresa  . '/consentimientos/'; 
   $_SESSION['URL_FIRMA_PACIENTE'] = '/empresas/' . $idEmpresa  . '/consentimientos/' . $pIdConsentimiento . '_firma.png'; 
   $_SESSION['URL_FIRMA_DESTINO'] = '../../../../empresas/' . $idEmpresa  . '/consentimientos/';
   $_SESSION['URL_HUELLA_PACIENTE'] = '/empresas/' . $idEmpresa  . '/consentimientos/' .  $pIdConsentimiento . '_huella.gif';
   $_SESSION['URL_HUELLA_DESTINO'] = '../../../../empresas/' . $idEmpresa  . '/consentimientos/'; 
}

?>
<!DOCTYPE>
<html>
    <head>
            <meta http-equiv="Content-Type" content="text/html; charset=UTF-8">
            <title>eOfiClinic ... !Sistema de Información Especializado para el Sector Salud..¡</title>
            <META http-equiv="imagetoolbar" content="no">
            <meta name="robots" content="noindex, nofollow">
            <meta name="viewport" content="width=device-width,initial-scale=1,maximum-scale=1.0">
            <link rel="stylesheet" type="text/css" href="../../../../lib/extjs/resources/css/ext-all.css"/>
            <link rel="stylesheet" type="text/css" href="../../../../lib/extjs/resources/css/xtheme-gray.css" />
            <link rel="stylesheet" type="text/css" href="../../../../lib/extjs/resources/css/Multiselect.css"/>
            <link rel="stylesheet" type="text/css" href="../../../../lib/jquery/sexyalertbox.css"/>
            <link rel="stylesheet" type="text/css" href="../../../../core/css/styles.css">
            <link rel="stylesheet" type="text/css" href="../../../../core/css/grid.css">
            <script type="text/javascript" src="../../../../core/js/functions.js"></script>
            <script type="text/javascript" src="../../../../lib/extjs/adapter/ext/ext-base.js"></script>
            <script type="text/javascript" src="../../../../lib/extjs/ext-all-debug.js"></script>
            <script type="text/javascript" src="../../../../lib/extjs/inputMask.js"></script>
            <script type="text/javascript" src="../../../../lib/extjs/src/locale/ext-lang-es.js"></script>
            <link rel="stylesheet" type="text/css" href="../../../../lib/extjs/shared/examples.css"/>
            <script type="text/javascript" src="../../../../lib/extjs/shared/examples.js"></script>
            <script type="text/javascript" src="../../../../lib/jquery/jquery-1.3.2.min.js"></script>
            <script type="text/javascript" src="../../../../core/js/searchfield.js"></script>
            <script type="text/javascript" src="webcam.js"></script>
            <link rel="stylesheet" href="../../../../libjq/css/bootstrap.min.css">
            <script src="../../../../libjq/js/vendor/modernizr-respond.min.js"></script>
            <script src="../../../../libjq/js/vendor/jquery-2.2.1.js"></script>
            <script src="../../../../libjq/js/vendor/bootstrap.min.js"></script>
            <link href="../../../../libjq/js/vendor/alertify/alertify.core.css" rel="stylesheet" />
            <link href="../../../../libjq/js/vendor/alertify/alertify.default.css" rel="stylesheet" />
            <script src="../../../../libjq/js/vendor/alertify/alertify.js"></script>
            <script src="../../../../libjq/js/vendor/jsignature/jSignature.min.noconflict.js"></script>
            <script src="pasteimage.js"></script>
            <link rel="stylesheet" href="rocanvas.css?v=1.0">
            <style type="text/css">
                div {
                        margin-top:1em;
                        margin-bottom:1em;
                }
                input {
                        padding: .5em;
                        margin: .5em;
                }
                select {
                        padding: .5em;
                        margin: .5em;
                }

                #signatureparent {
                        color:darkblue;
                        background-color:darkgrey;
                        /*max-width:600px;*/
                        padding:20px;
                }
                /*This is the div within which the signature canvas is fitted*/
                #signature {
                        border: 2px dotted black;
                        background-color:lightgrey;
                }
                #signatureparentAco {
                        color:darkblue;
                        background-color:darkgrey;
                        /*max-width:600px;*/
                        padding:20px;
                }
                /*This is the div within which the signature canvas is fitted*/
                #signatureAco {
                        border: 2px dotted black;
                        background-color:lightgrey;
                }

                /* Drawing the 'gripper' for touch-enabled devices */ 
                html.touch #content {
                        float:left;
                        width:92%;
                }
                html.touch #scrollgrabber {
                        float:right;
                        width:4%;
                        margin-right:2%;
                        background-image:url(data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAAAEAAAAFCAAAAACh79lDAAAAAXNSR0IArs4c6QAAABJJREFUCB1jmMmQxjCT4T/DfwAPLgOXlrt3IwAAAABJRU5ErkJggg==)
                }
                html.borderradius #scrollgrabber {
                        border-radius: 1em;
                }
            </style>
    </head>
    <body style="margin: 5,0,0,0;">
        <input id="idempresa" name="idempresa"  type="hidden" value="<?php echo $idEmpresa;?>"/>
        <input id="nomempresa" name="nomempresa"  type="hidden" value="<?php echo $nomEmpresa;?>"/>
        <input id="idcliente" name="idcliente"  type="hidden" value="<?php echo $idCliente;?>"/>
        <input id="nomcliente" name="nomcliente"  type="hidden" value="<?php echo $nomCliente;?>"/>
        <input id="idsede" name="idsede"  type="hidden" value="<?php echo $idSede;?>"/>
        <input id="nomsede" name="nomsede"  type="hidden" value="<?php echo $nomSede;?>"/>
        <input id="idips" name="idips"  type="hidden" value="<?php echo $idIps;?>"/>
        <input id="nomips" name="nomips"  type="hidden" value="<?php echo $nomIps;?>"/>
        <input id="idusuario" name="idusuario"  type="hidden" value="<?php echo $idUsuario;?>"/>
        <input id="nomusuario" name="nomusuario"  type="hidden" value="<?php echo $nomUsuario;?>"/>
        <input id="codusuario" name="codusuario"  type="hidden" value="<?php echo $codUsuario;?>"/>
        <input id="idperfil" name="idperfil"  type="hidden" value="<?php echo $idPerfil;?>"/>
        <input id="FecSistema" name="FecSistema"  type="hidden" value="<?php echo "02/02/2011";?>"/>
        <input id="FecControl" name="FecControl"  type="hidden" value="<?php echo "15/01/2011";?>"/>
        <input id="ofiversion" name="ofiversion"  type="hidden" value="<?php echo $idVersion;?>"/>
        <input id="idseguir" name="idseguir"  type="hidden" value="<?php echo $seguir;?>"/>
        <input id="idURL" name="idURL"  type="hidden" value="<?php echo $idURL;?>"/>
        <input id="sysIdConsentimiento" name="sysIdConsentimiento"  type="hidden" value="<?php echo $pIdConsentimiento;?>"/>
        <input id="sysFoto" name="sysFoto"  type="hidden" value="0"/>
        <input id="sysFirma" name="sysFirma"  type="hidden" value="0"/>
        <input id="sysFirmaAco" name="sysFirmaAco"  type="hidden" value="0"/>
        <input id="sysHuella" name="sysHuella"  type="hidden" value="0"/>
        <input id="sysGuardo" name="sysGuardo"  type="hidden" value="0"/>
        
        <div class="row">
            <div class="col-md-1"></div>
            <div class="col-md-10">
                <table border="1" width="100%" cellpadding="5" style=" border-style: solid;">
                    <tr>
                        <td width="25%">
                            <?php echo '<img src="../../../../empresas/' . $_SESSION['ID_EMPRESA'] . '/logo/logoenc.png"/>';?>
                        </td>
                        <td width="50%">
                            <p style="padding: 5px; font-weight: bold; color: darkblue; text-align: center; font-size: 24px;"><?php echo $pTitulo;?></p>
                        </td>
                        <td width="25%">
                            <p style="padding: 5px; font-weight: bold; color: darkblue; text-align: justify; font-size: 12px;">
                            <?php echo $pCodigo;?><br>
                            <?php echo $pVersionConsentimiento;?><br>
                            PAGINACIÓN: 1 DE 1<br>
                            <?php echo $pFechaPublica;?><br>
                            SISTEMA DE GESTIÓN DE CALIDAD
                            </p>
                        </td>
                    </tr>
                </table>
            </div>
            <div class="col-md-1"></div>
        </div>
        <div class="row">
            <div class="col-md-1"></div>
            <div class="col-md-10">
                <span style=" font-size: 24px; text-align: justify; ">
                    <span id="sysContenidoConcentimiento000">
                        <span align="center"><b>(En cumplimiento de la ley 23 de 1981 y las guías de Prácticas clínicas para la Seguridad del Paciente. Ministerio de la protección Social 2010)</b></span><br><br>Yo: <u><?php echo $pNomPaciente; ?></u> con Documento de identidad: <u><?php echo $pDocPaciente; ?></u> Edad <u><?php echo $pEdadPaciente; ?></u>, En forma voluntaria, consiento que el funcionario: <u><?php echo $pNomProfesional; ?></u>.<br><p>Manifiesto que he sido informado de manera detallada, suficiente, completa, clara, oportuna, en un lenguaje comprensible y claro sobre mi condici&oacute;n o enfermedad buco-dental y del balance entre los beneficios y riesgos del procedimiento cl&iacute;nico odontol&oacute;gico recomendado; trat&aacute;ndose en este caso de una atenci&oacute;n odontol&oacute;gica durante la pandemia por COVID-19, otorgo al profesional indicado, para que en ejercicio legal de su profesi&oacute;n se me practique / se le practique a mi representado los siguientes procedimientos odontol&oacute;gicos:</p><p>&nbsp;</p><p>Mismos que solicito se practiquen bajo mi entero conocimiento de:</p><p><strong>PRIMERO</strong>: Conozco y entiendo que actualmente nos encontramos en una emergencia sanitaria global declarada como consecuencia de la pandemia del Virus COVID-19.</p><p><strong>SEGUNDO</strong>: Que por lo anterior conozco, entiendo y se me ha explicado con lenguaje claro y sencillo por el profesional tratante que en la ejecuci&oacute;n todas las actividades que impliquen contacto cercano, como es el caso de la practica odontol&oacute;gica, existe un potencial riesgo de contagio, ya que tales procedimientos pueden generar aerosoles que favorezcan la diseminaci&oacute;n de la enfermedad, cuya aplicaci&oacute;n puede permanecer en el aire por minutos e incluso horas aumentando la posibilidad de un eventual contagio.</p><p><strong>TERCERO</strong>: Asimismo, he sido debidamente informado por el odont&oacute;logo tratante que el tiempo entre la exposici&oacute;n al virus SARS cov2 &ndash; COVID-19 y la aparici&oacute;n de los primeros s&iacute;ntomas es extenso, y durante el cual sus portadores pueden estar asintom&aacute;ticos, pudiendo ser de igual manera altamente contagiosos, por lo que es completo determinar efectivamente quien es portador del virus, debido a las limitaciones actuales de las pruebas diagn&oacute;sticas.</p><p><strong>CUARTO</strong>: Del mismo modo, he sido debidamente advertido y he comprendido acerca del alto riesgo de transmisi&oacute;n del virus SARS cov2 COVID-19, de las presencias de otras personas en el consultorio y las caracter&iacute;sticas de los procedimientos odontol&oacute;gicos, en virtud de lo cual no es posible asegurar un riesgo nulo de transmisi&oacute;n del virus, aun cumpliendo rigurosamente todos y cada uno de los protocolos de protecci&oacute;n, seguridad e higiene disponibles e instaurados en la instituci&oacute;n.</p><p><strong>QUINTO</strong>: Que el profesional de la salud, previa prestaci&oacute;n del servicio, me ha solicitado absolver el siguiente cuestionario cuyas respuestas bajo la brevedad de juramento declaro que son las siguientes:</p><p>1 &iquest;tiene fiebre o la ha tenido en los &uacute;ltimos 14 d&iacute;as? (temperatura &gt;37.5&ordm;) <span id="bolQuestion1"><input id="sysQuestion1" name="sysQuestion1" type="checkbox" value="SI" /><strong>- SI</strong>&nbsp;</span>&nbsp;<span id="bolQuestion1n"><input id="sysQuestion1n" name="sysQuestion1n" type="checkbox" value="NO" /><strong>- NO</strong>&nbsp;</span><br />2 &iquest;Ha tenido tos o cualquier otro s&iacute;ntoma de dificultad respiratoria en los &uacute;ltimos 14 d&iacute;as? <span id="bolQuestion2"><input id="sysQuestion2" name="sysQuestion2" type="checkbox" value="SI" /><strong>- SI</strong>&nbsp;</span>&nbsp;<span id="bolQuestion2n"><input id="sysQuestion2n" name="sysQuestion2n" type="checkbox" value="NO" /><strong>- NO</strong>&nbsp;</span><br />3 &iquest;Ha tenido en los &uacute;ltimos 14 d&iacute;as o tiene diarrea o sintomatolog&iacute;a digestiva? <span id="bolQuestion3"><input id="sysQuestion3" name="sysQuestion3" type="checkbox" value="SI" /><strong>- SI</strong>&nbsp;</span>&nbsp;<span id="bolQuestion3n"><input id="sysQuestion3n" name="sysQuestion3n" type="checkbox" value="NO" /><strong>- NO</strong>&nbsp;</span><br />4 &iquest;tiene o ha tenido sensaci&oacute;n de mucho cansancio o malestar en los &uacute;ltimos 14 d&iacute;as? <span id="bolQuestion4"><input id="sysQuestion4" name="sysQuestion4" type="checkbox" value="SI" /><strong>- SI</strong>&nbsp;</span>&nbsp;<span id="bolQuestion4n"><input id="sysQuestion4n" name="sysQuestion4n" type="checkbox" value="NO" /><strong>- NO</strong>&nbsp;</span><br />5 &iquest;Ha notado una p&eacute;rdida del sentido del gusto o del olfato en los &uacute;ltimos 14 d&iacute;as? <span id="bolQuestion5"><input id="sysQuestion5" name="sysQuestion5" type="checkbox" value="SI" /><strong>- SI</strong>&nbsp;</span>&nbsp;<span id="bolQuestion5n"><input id="sysQuestion5n" name="sysQuestion5n" type="checkbox" value="NO" /><strong>- NO</strong>&nbsp;</span><br />6 &iquest;Ha estado en contacto o conviviendo con alguna persona sospechosa confirmada de coronavirus? <span id="bolQuestion6"><input id="sysQuestion6" name="sysQuestion6" type="checkbox" value="SI" /><strong>- SI</strong>&nbsp;</span>&nbsp;<span id="bolQuestion6n"><input id="sysQuestion6n" name="sysQuestion6n" type="checkbox" value="NO" /><strong>- NO</strong>&nbsp;</span><br />7 &iquest;tiene o ha presentado la enfermedad de COVID &ndash; 19? <span id="bolQuestion7"><input id="sysQuestion7" name="sysQuestion7" type="checkbox" value="SI" /><strong>- SI</strong>&nbsp;</span>&nbsp;<span id="bolQuestion7n"><input id="sysQuestion7n" name="sysQuestion7n" type="checkbox" value="NO" /><strong>- NO</strong>&nbsp;</span><br />8 En caso de haber presentado la enfermedad &iquest;ya tiene una segunda muestra negativa? <span id="bolQuestion8"><input id="sysQuestion8" name="sysQuestion8" type="checkbox" value="SI" /><strong>- SI</strong>&nbsp;</span>&nbsp;<span id="bolQuestion8n"><input id="sysQuestion8n" name="sysQuestion8n" type="checkbox" value="NO" /><strong>- NO</strong>&nbsp;</span></p><p><strong>SEXTO</strong>: Que una vez absuelto el cuestionario y en atenci&oacute;n a las respuestas por mi dadas y confirmadas, el profesional tratante ha llegado a la conclusi&oacute;n que no soy factor de riesgo de contagio y por tanto se me prestara el servicio odontol&oacute;gico, observando los protocolos de seguridad pertinentes.</p><p><strong>SEPTIMO</strong>: Que el profesional tratante, previa atenci&oacute;n me ha informado las medidas y protocolos de bioseguridad que como paciente debo acatar y que estos son:</p><p>1 Que debo utilizar tapabocas, durante mi permanencia en &aacute;reas comunes como salas de espera y pasillos.<br />2 Que antes de realizar a consulta debo realizar higiene de manos adecuadamente e higiene bucal con los elementos que me han suministrado para tal fin.<br />3 Permitir que al ingreso a la instituci&oacute;n se me tome la temperatura corporal<br />4 Mantener distancia m&iacute;nimo de dos metros con otros usuarios o personal de la instituci&oacute;n durante mi permanencia en salas de espera y/o espacios comunes<br />5 Previamente se me ha informado que no debo acudir a la instituci&oacute;n usando accesorios personales, guantes y que debo tener el cabello recogido.<br />6 Que no debo asistir con acompa&ntilde;antes a menos que por mi edad o situaci&oacute;n particular as&iacute; lo requiera o asista en calidad e acudiente de una persona discapacitada.</p><p><strong>OCTAVO</strong>: El profesional tratante me ha informado y he comprendido sobre la aplicaci&oacute;n de los protocolos utilizados en la intervenci&oacute;n y en general en la instituci&oacute;n para minimizar el potencial riesgo de contagio son los siguientes:</p><p>1 Que el equipo de protecci&oacute;n personal (EPP) a utilizar por el profesional tratante es: bata de manga larga anti fluido, overol, careta de protecci&oacute;n larga, monogafas, mascarilla respiratoria N95, gorro quir&uacute;rgico desechable y guantes desechables.<br />2 Que todas las piezas quir&uacute;rgicas o instrumentos a utilizar son desechables y los que no ser&aacute;n debidamente desinfectados y esterilizados.<br />3 Todos los funcionarios de la instituci&oacute;n realizan protocolo de lavado de manos, seg&uacute;n los 5 pasos de la OMS y se les toma la temperatura de manera diaria, adem&aacute;s de que reportan su estado de salud de manera diaria.<br />4 Todas las superficies que incluye paredes, pisos, ba&ntilde;os, y mobiliario en general es desinfectado todos los d&iacute;as.<br />5 Que se cuenta con acceso f&aacute;cil y con todos los elementos para la higienizaci&oacute;n y lavado de manos.<br />6 Que se respeta la debida distancia de dos metros en salas de espera, y que las barras de servicio para atenci&oacute;n de usuarios cuenta con su debida separaci&oacute;n en vidrio.<br />7 Que todas las &aacute;reas y ambientes cuentan con ventilaci&oacute;n e iluminaci&oacute;n adecuadas.</p><p><strong>NOVENO</strong>: Que una vez informado acerca de los protocolos incluidos en el literal octavo del presente documento, doy fe que:</p><p>1 El profesional tratante porta los EPP<br />2 Que se respeta el distanciamiento social en salas de espera<br />3 Que me exigieron higienizaci&oacute;n e manos al ingreso a la instituci&oacute;n y uso de tapabocas<br />4 Que se me realizo higiene bucal al ingreso al consultorio<br />5 Que se me ha suministrado monogafas al ingreso al consultorio<br />6 Que en el momento de ingresar se me ha tomado la temperatura</p><p><strong>DECIMO</strong>: Que una vez absuelto el cuestionario para establecer mi estado de salud, conocer los protocolos que como paciente debo seguir y respetar, as&iacute; como los que la instituci&oacute;n deben observar, he verificado su total cumplimiento por parte de la instituci&oacute;n y por tanto declaro que estando plenamente informado del potencial RIESGO DE CONTADIO COVID-19 /SARS-COV.19 que implica el ejercicio de la salud oral, doy mi consentimiento LIBRE para que el profesional tratante realice el procedimiento convenido, librando de responsabilidad tanto al profesional tratante, como a la instituci&oacute;n MEDICARE IPS S.A.S por un posible contagio.</p><p><br /><strong>HE LE&Iacute;DO CUIDADOSAMENTE ESTE DOCUMENTO ANTES DE FIRMARLO Y HE PODIDO COMENTARLO CON EL PROFESIONAL ASIGNADO ACLARANDO DUDAS Y OBTENIENDO RESPUESTA SATISFACTORIA, POR QUE DOY MI CONSENTIMIENTO PARA QUE SE ME REALICE EL TRATAMIENTO PROPUESTO.</strong></p><br>
                    </span>
                    <hr>
                    <div class="row">
                        <div class="col-md-12 text-center">
                            <label class="radio-inline"><input type="radio" id="bolAceptoConsentimiento" name="bolAceptoConsentimiento" value="ACEPTO" checked><strong style="color: darkgreen;">ACEPTO</strong></label>
                            <label class="radio-inline"><input type="radio" id="bolAceptoConsentimiento" name="bolAceptoConsentimiento" value="NO ACEPTO"><strong style="color: darkred;">NO ACEPTO</strong></label>
                        </div>
                    </div>
                </span>
            </div>
            <div class="col-md-1"></div>
        </div>
        <div class="container">
            <h2>Foto del Paciente</h2>
            <div class="panel panel-default">
                <div class="panel-body">
                    <div class="row">
                        <div class="col-md-12 text-center">
                            <center>
                                <table border="1">
                                    <tr>
                                        <td>
                                            <video id="sysImgFoto" autoplay="true" width="320" height="240">
                                                No hay soporte para video en su navegador
                                            </video>
                                            <canvas id="canvas" width="320" height="240" style="display: none"></canvas>
                                        </td>
                                    </tr>
                                    <tr>
                                        <td colspan="2" align="center">
                                            <button id="snap" style="font-size: 22px;" class="btn btn-sm btn-success" onclick="take_snapshot();">Capturar Foto</button>
                                            <script>
                                                var video=document.querySelector('#sysImgFoto');
                                                var canvas=document.querySelector('#canvas');
                                                var context=canvas.getContext('2d');
                                                var w,h,ratio;
                                                navigator.getUserMedia = navigator.getUserMedia || navigator.webkitGetUserMedia || navigator.mozGetUserMedia || navigator.msGetUserMedia || navigator.oGetUserMedia;
                                                if(navigator.getUserMedia){
                                                    navigator.getUserMedia({video: true}, handleVideo, videoError);
                                                }
                                                video.addEventListener('loadedmetadata', function() {
                                                    ratio = video.videoWidth/video.videoHeight;
                                                    w = video.videoWidth-100;
                                                    h = parseInt(w/ratio,10);
                                                    canvas.width = w;
                                                    canvas.height = h;
                                                },false);
                                                function handleVideo(stream){
                                                    video.srcObject = stream;
                                                }
                                                function videoError(e){
                                                    alert("Problema con la camara web");
                                                }
                                                function take_snapshot() {
                                                    if($("#sysFoto").val() == "0"){
                                                        context.fillRect(0, 0, w, h);
                                                        context.drawImage(video, 0, 0, w, h);
                                                        //var imagen = canvas.toDataURL("image/png");
                                                        var data = canvas.toDataURL("image/jpeg");
                                                        var xhr = new XMLHttpRequest();
                                                        xhr.onreadystatechange = function() {
                                                          if (xhr.readyState == 4) {
                                                            alertify.success("Se capturo la foto correctamente.");
                                                          }
                                                        };
                                                        xhr.open('POST','savefotopac2021.php',true);
                                                        xhr.setRequestHeader('Content-Type', 'application/upload');
                                                        xhr.send(data);
                                                    }else{
                                                        alertify.set({ delay: 4000 });
                                                        alertify.error("Ya se registro la foto del paciente.");
                                                    }
                                                }
                                            </script>
                                        </td>
                                    </tr>
                                </table>
                            </center>
                        </div>
                    </div> 
                    
                </div>
            </div>
        </div>
        <div class="container">
            <h2>Huella del Paciente</h2>
            <div class="panel panel-default">
                <div class="panel-body">
                    <div class="row">
                        <div class="col-md-12 text-center">
                            <img id="imgHuellaPac">
                            <div id="rodiv2"><canvas id="sampleBoard2" width="181" height="181" style="border:1pt solid black"></canvas><p>presione ctrl+v para pegar la huella</p></div>
                            <script src="rocanvas.js"></script>
                            <script>     
                                var r2=new RoCanvas;
                                r2.RO("sampleBoard2", {
                                    "toolbar": {
                                        colors: null,
                                        custom_color: false,
                                        tools: null,
                                        sizes: null,			
                                        saveButton: {"text": "Guardar Huella", "callback": "testSave(r2);"}			
                                    },
                                    "settings": {
                                        color: '#000'		
                                    }
                                });

                                function testSave(instance){
                                    if($("#sysHuella").val() == "0"){
                                        var datosHuella = instance.serialize();
                                        var ajax = new XMLHttpRequest();
                                        ajax.open("POST",'savehuellapac2021.php?p0=' + $("#sysIdConsentimiento").val(),false);
                                        ajax.onreadystatechange = function() {
                                            console.log(ajax.responseText);
                                        };
                                        ajax.setRequestHeader('Content-Type', 'application/upload');
                                        ajax.send("imgData="+datosHuella);
                                        $("#sysHuella").val(1);
                                        alertify.set({ delay: 5000 });
                                        alertify.success("Se capturo la huella correctamente.");
                                        setTimeout(function(){
                                            //window.close();
                                        }, 6000);
                                    }else{
                                        alertify.set({ delay: 4000 });
                                        alertify.error("Ya se registro la huella del paciente.");
                                    }
                                }
                           </script>
                        </div>
                    </div> 
                    
                </div>
            </div>
        </div>
        <div class="container">
            <h2>Firma del Paciente</h2>
            <div class="panel panel-default">
                <div class="panel-body">
                    <div class="row">
                        <div class="col-md-12 text-center">
                            <button id="btnGuardarNOFirma" style="font-size: 22px;" class="btn btn-sm btn-primary" onclick="guardarNOFirma();">Paciente NO Firma</button>
                            <button id="btnLimpiar" style="font-size: 22px;" class="btn btn-sm btn-warning" onclick="limpiar();">Limpiar</button>
                            <button id="btnGuardarFirma" style="font-size: 22px;" class="btn btn-sm btn-success" onclick="guardarFirma();">Guardar Firma</button>
                        </div>
                    </div> 
                    <div id="content">
                        <div id="signatureparent">
                            <div id="signature"></div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        <div class="container">
            <h2>Firma del Acudiente / Acompañante</h2>
            <div class="panel panel-default">
                <div class="panel-body">
                    <div class="row">
                        <div class="col-md-12 text-center">
                            <button id="btnLimpiarAco" style="font-size: 22px;" class="btn btn-sm btn-warning" onclick="limpiarAco();">Limpiar</button>
                            <button id="btnGuardarFirmaAco" style="font-size: 22px;" class="btn btn-sm btn-success" onclick="guardarFirmaAco();">Guardar Firma</button>
                            </div>
                    </div> 
                    <div id="content">
                        <div id="signatureparentAco">
                            <div id="signatureAco"></div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        <div class="row">
            <div class="col-md-12 text-center">
                <button id="btnSalir" style="font-size: 22px;" class="btn btn-sm btn-danger" onclick="salir();">Salir</button>
                <button id="btnGuardarCI000" style="font-size: 22px;" class="btn btn-sm btn-success" onclick="GuardarCI000();">Guardar Consentimiento</button>
            </div>
        </div> 
    </body>
    <script>
        $sigdiv = "";
        $sigdivAco = "";
        $(function(){ 
            $sigdiv = $("#signature").jSignature({'UndoButton':false, 'color':"black"});
            $sigdivAco = $("#signatureAco").jSignature({'UndoButton':false, 'color':"black"});
            var CLIPBOARD = new CLIPBOARD_CLASS("sampleBoard2", true);
        });
        
        function limpiar(){
            $sigdiv.jSignature('reset');
        }
        function limpiarAco(){
            $sigdivAco.jSignature('reset');
        }
        function salir(){
            window.close();
        }
        function guardarFirma(){
            if($("#sysFirma").val() == "0"){
                Ext.Msg.show({
                    title: 'eOfiClinic',
                    msg: 'Esta seguro que desea registrar la Firma?',
                    buttons: Ext.Msg.YESNO,
                    icon: Ext.Msg.QUESTION,
                    fn: function(btn){
                        if(btn=="yes"){
                            var dataImg = $sigdiv.jSignature('getData', 'image');
                            $.ajax({
                                type: "POST",
                                url: "controlador_firma.php",
                                data: {
                                    task: 'GUARDAR_FIRMA',
                                    p0: $("#sysIdConsentimiento").val(),
                                    pImagen: dataImg
                                }, 
                                success: function(data){
                                    var response = JSON.parse(data);
                                    if(response['success'] === "true"){
                                        $("#sysFirma").val(1);
                                        alertify.set({ delay: 5000 });
                                        alertify.success("Se capturo la firma correctamente.");
                                        setTimeout(function(){
                                            //window.close();
                                        }, 6000);
                                    }else{
                                        $("#sysFirma").val(0);
                                        alertify.set({ delay: 4000 });
                                        alertify.error("No podemos registrar la firma en estos momentos, por favor vuelve a intentarlo.");
                                    }
                                }
                            });
                        }
                    }
                });
            }else{
                alertify.set({ delay: 4000 });
                alertify.error("Ya se registro la firma del paciente.");
            }
        }
        function guardarNOFirma(){
            if($("#sysFirma").val() == "0"){
                Ext.Msg.show({
                    title: 'eOfiClinic',
                    msg: 'Esta seguro que desea registrar como NO Firma?',
                    buttons: Ext.Msg.YESNO,
                    icon: Ext.Msg.QUESTION,
                    fn: function(btn){
                        if(btn=="yes"){
                            $.ajax({
                                type: "POST",
                                url: "controlador_firma.php",
                                data: {
                                    task: 'GUARDAR_NO_FIRMA',
                                    p0: $("#sysIdConsentimiento").val()
                                }, 
                                success: function(data){
                                    var response = JSON.parse(data);
                                    if(response['success'] === "true"){
                                        $("#sysFirma").val(1);
                                        alertify.set({ delay: 5000 });
                                        alertify.success("Se Registro como NO FIRMADO correctamente.");
                                        setTimeout(function(){
                                            //window.close();
                                        }, 6000);
                                    }else{
                                        $("#sysFirma").val(0);
                                        alertify.set({ delay: 4000 });
                                        alertify.error("No podemos registrar como NO FIRMADO en estos momentos, por favor vuelve a intentarlo.");
                                    }
                                }
                            });
                        }
                    }
                });
            }else{
                alertify.set({ delay: 4000 });
                alertify.error("Ya se registro la firma del paciente.");
            }
        }
        function guardarFirmaAco(){ 
            if($("#sysFirmaAco").val() == "0"){
                Ext.Msg.show({
                    title: 'eOfiClinic',
                    msg: 'Esta seguro que desea registrar la Firma del acompañante - acudiente?',
                    buttons: Ext.Msg.YESNO,
                    icon: Ext.Msg.QUESTION,
                    fn: function(btn){
                        if(btn=="yes"){
                            var dataImg = $sigdivAco.jSignature('getData', 'image');
                            $.ajax({
                                type: "POST",
                                url: "controlador_firma.php",
                                data: {
                                    task: 'GUARDAR_FIRMA_ACO',
                                    p0: $("#sysIdConsentimiento").val(),
                                    pImagen: dataImg
                                }, 
                                success: function(data){
                                    var response = JSON.parse(data);
                                    if(response['success'] === "true"){
                                        $("#sysFirmaAco").val(1);
                                        alertify.set({ delay: 5000 });
                                        alertify.success("Se capturo la firma del acompañante - acudiente correctamente.");
                                        setTimeout(function(){
                                            //window.close();
                                        }, 6000);
                                    }else{
                                        $("#sysFirmaAco").val(0);
                                        alertify.set({ delay: 4000 });
                                        alertify.error("No podemos registrar la firma del acompañante - acudiente en estos momentos, por favor vuelve a intentarlo.");
                                    }
                                }
                            });
                        }
                    }
                });
            }else{
                alertify.set({ delay: 4000 });
                alertify.error("Ya se registro la firma del paciente.");
            }
        }
        function CLIPBOARD_CLASS(canvas_id, autoresize) {
            var _self = this;
            var canvas = document.getElementById(canvas_id);
            var ctx = document.getElementById(canvas_id).getContext("2d");
            var ctrl_pressed = false;
            var command_pressed = false;
            var paste_event_support;
            var pasteCatcher;
            //handlers
            document.addEventListener('keydown', function (e) {
                _self.on_keyboard_action(e);
            }, false); //firefox fix
            document.addEventListener('keyup', function (e) {
                _self.on_keyboardup_action(e);
            }, false); //firefox fix
            document.addEventListener('paste', function (e) {
                _self.paste_auto(e);
            }, false); //official paste handler
            //constructor - we ignore security checks here
            this.init = function () {
    		pasteCatcher = document.createElement("div");
    		pasteCatcher.setAttribute("id", "paste_ff");
    		pasteCatcher.setAttribute("contenteditable", "");
                pasteCatcher.style.cssText = 'opacity:0;position:fixed;top:0px;left:0px;width:10px;margin-left:-20px;';
                document.body.appendChild(pasteCatcher);

    		// create an observer instance
    		var observer = new MutationObserver(function(mutations) {
                    mutations.forEach(function(mutation) {
                        if (paste_event_support === true || ctrl_pressed == false || mutation.type != 'childList'){
                            //we already got data in paste_auto()
                            return true;
                        }
                        //if paste handle failed - capture pasted object manually
    			if(mutation.addedNodes.length == 1) {
                            if (mutation.addedNodes[0].src != undefined) {
                                //image
    				_self.paste_createImage(mutation.addedNodes[0].src);
                            }
                            //register cleanup after some time.
                            setTimeout(function () {
                                pasteCatcher.innerHTML = '';
                            }, 20);
                        }
                    });
    		});
    		var target = document.getElementById('paste_ff');
    		var config = { attributes: true, childList: true, characterData: true };
    		observer.observe(target, config);
            }();
            //default paste action
            this.paste_auto = function (e) {
    		paste_event_support = false;
    		if(pasteCatcher != undefined){
                    pasteCatcher.innerHTML = '';
    		}
    		if (e.clipboardData) {
                    var items = e.clipboardData.items;
                    if (items) {
                        paste_event_support = true;
                        //access data directly
                        for (var i = 0; i < items.length; i++) {
                            if (items[i].type.indexOf("image") !== -1) {
                                //image
    				var blob = items[i].getAsFile();
    				var URLObj = window.URL || window.webkitURL;
                                var source = URLObj.createObjectURL(blob);
    				this.paste_createImage(source);
                            }
                        }
    			e.preventDefault();
                    }else {
    			//wait for DOMSubtreeModified event
    			//https://bugzilla.mozilla.org/show_bug.cgi?id=891247
                    }
    		}
            };
            //on keyboard press
            this.on_keyboard_action = function (event) {
    		k = event.keyCode;
    		//ctrl
    		if (k == 17 || event.metaKey || event.ctrlKey) {
                    if (ctrl_pressed == false){
                        ctrl_pressed = true;
                    }
    		}
    		//v
    		if (k == 86) {
                    if (document.activeElement != undefined && document.activeElement.type == 'text') {
                        //let user paste into some input
                        return false;
                    }
                    if (ctrl_pressed == true && pasteCatcher != undefined){
                        pasteCatcher.focus();
                    }
    		}
            };
            //on kaybord release
            this.on_keyboardup_action = function (event) {
    		//ctrl
    		if (event.ctrlKey == false && ctrl_pressed == true) {
                    ctrl_pressed = false;
    		}else if(event.metaKey == false && command_pressed == true){
                    command_pressed = false;
                    ctrl_pressed = false;
    		}
            };
            //draw pasted image to canvas
            this.paste_createImage = function (source) {
    		var pastedImage = new Image();
                pastedImage.onload = function () {
                    if(autoresize == true){
                        //resize
                        //canvas.width = pastedImage.width;
    			//canvas.height = pastedImage.height;
                        canvas.width = 164;
    			canvas.height = 176;
                    }else{
    			//clear canvas
    			ctx.clearRect(0, 0, canvas.width, canvas.height);
                    }
                    //ctx.drawImage(pastedImage, 0, 0);
                    ctx.drawImage(pastedImage,0,0,pastedImage.width,pastedImage.height,0,0,164,176);
    		};
    		pastedImage.src = source;
            };
        }
        function GuardarCI000(){
            if($("#sysHuella").val() == "1" && $("#sysGuardo").val() == "0"){
                Ext.Msg.show({
                    title: 'eOfiClinic',
                    msg: 'Esta seguro que desea Guardar el Registro del Consentimiento Informado?',
                    buttons: Ext.Msg.YESNO,
                    icon: Ext.Msg.QUESTION,
                    fn: function(btn){
                        if(btn=="yes"){
                            var tipoaceptacion = $("input:radio[name ='bolAceptoConsentimiento']:checked").val();
                            
                            if ($('#sysQuestion1').is(':checked')){
                                $("#bolQuestion1").html('&nbsp;&nbsp;-&nbsp;&nbsp;SI.');
                            }else{
                                $("#bolQuestion1").html("");
                            }
                            if ($('#sysQuestion1n').is(':checked')){
                                $("#bolQuestion1n").html('&nbsp;&nbsp;-&nbsp;&nbsp;NO.');
                            }else{
                                $("#bolQuestion1n").html("");
                            }
                            if ($('#sysQuestion2').is(':checked')){
                                $("#bolQuestion2").html('&nbsp;&nbsp;-&nbsp;&nbsp;SI.');
                            }else{
                                $("#bolQuestion2").html("");
                            }
                            if ($('#sysQuestion2n').is(':checked')){
                                $("#bolQuestion2n").html('&nbsp;&nbsp;-&nbsp;&nbsp;NO.');
                            }else{
                                $("#bolQuestion2n").html("");
                            }
                            if ($('#sysQuestion3').is(':checked')){
                                $("#bolQuestion3").html('&nbsp;&nbsp;-&nbsp;&nbsp;SI.');
                            }else{
                                $("#bolQuestion3").html("");
                            }
                            if ($('#sysQuestion3n').is(':checked')){
                                $("#bolQuestion3n").html('&nbsp;&nbsp;-&nbsp;&nbsp;NO.');
                            }else{
                                $("#bolQuestion3n").html("");
                            }
                            
                            if ($('#sysQuestion4').is(':checked')){
                                $("#bolQuestion4").html('&nbsp;&nbsp;-&nbsp;&nbsp;SI.');
                            }else{
                                $("#bolQuestion4").html("");
                            }
                            if ($('#sysQuestion4n').is(':checked')){
                                $("#bolQuestion4n").html('&nbsp;&nbsp;-&nbsp;&nbsp;NO.');
                            }else{
                                $("#bolQuestion4n").html("");
                            }
                            if ($('#sysQuestion6').is(':checked')){
                                $("#bolQuestion6").html('&nbsp;&nbsp;-&nbsp;&nbsp;SI.');
                            }else{
                                $("#bolQuestion6").html("");
                            }
                            if ($('#sysQuestion6n').is(':checked')){
                                $("#bolQuestion6n").html('&nbsp;&nbsp;-&nbsp;&nbsp;NO.');
                            }else{
                                $("#bolQuestion6n").html("");
                            }
                            if ($('#sysQuestion7').is(':checked')){
                                $("#bolQuestion7").html('&nbsp;&nbsp;-&nbsp;&nbsp;SI.');
                            }else{
                                $("#bolQuestion7").html("");
                            }
                            if ($('#sysQuestion7n').is(':checked')){
                                $("#bolQuestion7n").html('&nbsp;&nbsp;-&nbsp;&nbsp;NO.');
                            }else{
                                $("#bolQuestion7n").html("");
                            }
                            
                            if ($('#sysQuestion8').is(':checked')){
                                $("#bolQuestion8").html('&nbsp;&nbsp;-&nbsp;&nbsp;SI.');
                            }else{
                                $("#bolQuestion8").html("");
                            }
                            if ($('#sysQuestion8n').is(':checked')){
                                $("#bolQuestion8n").html('&nbsp;&nbsp;-&nbsp;&nbsp;NO.');
                            }else{
                                $("#bolQuestion8n").html("");
                            }
                            
                            if ($('#sysProcedimientos').val() != "" && $('#sysProcedimientos').val() != null){
                                var proced = $('#sysProcedimientos').val();
                                $("#strProcedimientos").html(proced + '<br>');
                            }else{
                                $("#strProcedimientos").html("");
                            }
                            
                            $.ajax({
                                type: "POST",
                                url: "controlador_consentimiento2018.php",
                                data: {
                                    task: 'GUARDAR_CONSENTIMIENTO',
                                    pIdConsentimiento: $("#sysIdConsentimiento").val(),
                                    pTipoAceptacion: tipoaceptacion,
                                    pConsentimiento: QuitarAcentosTxtMayusculas($("#sysContenidoConcentimiento000").html())
                                }, 
                                success: function(data){
                                    var response = JSON.parse(data);
                                    if(response['success'] === "true"){
                                        $("#sysGuardo").val(1);
                                        alertify.set({ delay: 5000 });
                                        alertify.success("Se registro el consentimiento informado correctamente.");
                                        setTimeout(function(){
                                            //window.close();
                                        }, 6000);
                                    }else{
                                        $("#sysGuardo").val(0);
                                        alertify.set({ delay: 4000 });
                                        alertify.error("No podemos registrar el consentimiento informado en estos momentos, por favor vuelve a intentarlo.");
                                    }
                                }
                            });
                        }
                    }
                });
            }else{
                alertify.set({ delay: 4000 });
                alertify.error("Debe realizar la captura de la huella que son obligatorios y/o ya realizo el registro del consentimiento y no se puede modificar.");
                //alertify.error("Debe realizar la captura de la firma y la huella que son obligatorios y/o ya realizo el registro del consentimiento y no se puede modificar.");
            }
        }
    </script>
</html>