<?php

/*
* @category    Controlador Varios
* @package     OfiClinic Web
* @author      Jorge Ancizar Galeano Ruiz<desarrollo@ofisalud.com>
* @copyright   2010 Jorge Ancizar Galeano Ruiz
* @version     OfiClinic Web 1.0
* @license     COMERCIAL
* @link        http://www.ofisalud.com
* @country     Colombia
* @telephone   3016398114
*/

require("../../../core/php/_database.php");
require("../../../core/php/php_functions.php");

$task = '';
if ( isset($_POST['task'])){
  $task = $_POST['task'];
}
switch($task){
    case "BUSCAR_MUNICIPIO":
        searchMunicipio();
        break;
    case "BUSCAR_PACIENTE":
        searchPaciente();
        break;
    case "BUSCAR_CLIENTE":
        searchCliente();
        break;
    case "BUSCAR_PLAN":
        searchPlan();
        break;
    case "BUSCAR_SUBPLAN":
        searchSubPlan();
        break;
    case "BUSCAR_CONTRATO":
        searchContrato();
        break;
    case "BUSCAR_CONCEPTO":
        searchConcepto();
        break;
    case "BUSCAR_PROFESIONAL":
        searchProfesional();
        break;
    case "BUSCAR_DATOS ULTIMAASIGNA":
        searchUltimaAsigna();
        break;
    case "BUSCAR_NROAUTORIZACION":
        searchNroAutorizacion();
        break;
    default:
        echo "{failure:true}";
        break;
}
   
function searchNroAutorizacion(){
    $pAutorizacion = isset($_REQUEST['pAutoriza']) ? $_REQUEST['pAutoriza']:"NA";
    $pCliente = isset($_REQUEST['pCliente']) ? $_REQUEST['pCliente']:0;
    if($pAutorizacion != "" && $pAutorizacion != null && $pAutorizacion != "NA"){
        $gBaseDatos = new ofiMySQLi();
        $gBaseDatos->conectar();
        $qry = 'SELECT estudios.CAS FROM estudios WHERE estudios.NroAutorizacion = "' . $pAutorizacion . '"';
        if($pCliente != 0){
            $qry .= ' AND estudios.Cliente = ' . $pCliente;
        }
        //echo $qry;
        $CampoLlave = explode("^",$gBaseDatos->jasonSP_arreglo2011($qry));
        $gBaseDatos->liberar();
        $gBaseDatos->cerrar();
        echo $CampoLlave[0];
    }else{
        echo "{failure:true}";
    }
    
}

function searchMunicipio(){
    $pMunicipio = isset($_REQUEST['pMunicipio']) ? $_REQUEST['pMunicipio']:"NA";
    $gBaseDatos = new ofiMySQLi();
    $gBaseDatos->conectar();
    $qry = 'SELECT pdepartamentos_municipios.IdDeptoMunicipio, CONCAT(pdepartamentos_municipios.Descripcion," - ",pdepartamentos.Descripcion) FROM pdepartamentos_municipios Inner Join pdepartamentos ON pdepartamentos_municipios.IdDepto = pdepartamentos.IdDepto WHERE pdepartamentos_municipios.IdDeptoMunicipio = "' . $pMunicipio . '"';
    //echo $qry;
    $CampoLlave = explode("^",$gBaseDatos->jasonSP_arreglo2011($qry));
    $gBaseDatos->liberar();
    $gBaseDatos->cerrar();
    echo $CampoLlave[0] . '^' . $CampoLlave[1];
}

function searchPaciente(){
    $pTdoc = isset($_REQUEST['pTdoc']) ? $_REQUEST['pTdoc']:"NA";
    if($pTdoc == "" || $pTdoc == null){
        $pTdoc = "NA";
    }
    $pDoc = isset($_REQUEST['pDoc']) ? $_REQUEST['pDoc']:"NA";
    $gBaseDatos = new ofiMySQLi();
    $gBaseDatos->conectar();
    $qry = 'SELECT
    pacientes.TipDoc,
    pacientes.Documento,
    pacientes.Genero,
    pacientes.PrimerApellido,
    pacientes.SegundoApellido,
    pacientes.PrimerNombre,
    pacientes.SegundoNombre,
    DATE_FORMAT(pacientes.FecNac,"%d-%m-%Y"),
    pacientes.DeptoMunici,
    pacientes.Direccion,
    pacientes.Telefono,
    pacientes.Telefono1,
    pacientes.Zona,
    pacientes.Email,
    pacientes.Paciente
    FROM
    pacientes
    WHERE
    pacientes.Documento =  "' . $pDoc . '"';
    if($pTdoc != "NA"){
         $qry .= ' AND pacientes.TipDoc = "' . $pTdoc . '"';
    }
    //echo $qry;
    $CampoLlave = explode("^",$gBaseDatos->jasonSP_arreglo2011($qry));
    $gBaseDatos->liberar();
    $gBaseDatos->cerrar();
    echo $CampoLlave[0] . '^' . $CampoLlave[1] . '^' . $CampoLlave[2] . '^' . $CampoLlave[3] . '^' . $CampoLlave[4] . '^' . $CampoLlave[5] . '^' . $CampoLlave[6] . '^' . $CampoLlave[7] . '^' . $CampoLlave[8] . '^' . $CampoLlave[9] . '^' . $CampoLlave[10] . '^' . $CampoLlave[11] . '^' . $CampoLlave[12] . '^' . $CampoLlave[13] . '^' . $CampoLlave[14];
}

function searchCliente(){
    $pCliente = isset($_REQUEST['pCliente']) ? $_REQUEST['pCliente']:"-NA";
    $gBaseDatos = new ofiMySQLi();
    $gBaseDatos->conectar();
    $qry = 'SELECT
    pprestatario_clientes.IdCliente,
    pprestatario_clientes.Descripcion
    FROM
    pprestatario_clientes
    WHERE
    pprestatario_clientes.CodRapido =  "' . $pCliente . '"';
    //echo $qry;
    $CampoLlave = explode("^",$gBaseDatos->jasonSP_arreglo2011($qry));
    $gBaseDatos->liberar();
    $gBaseDatos->cerrar();
    echo $CampoLlave[0] . '^' . $CampoLlave[1];
}

function searchPlan(){
    $pCliente = isset($_REQUEST['pCliente']) ? $_REQUEST['pCliente']:"-NA";
    $pPlan = isset($_REQUEST['pPlan']) ? $_REQUEST['pPlan']:"-NA";
    $gBaseDatos = new ofiMySQLi();
    $gBaseDatos->conectar();
    $qry = 'SELECT
    pprestatario_clientes_plan.IdPlan,
    pprestatario_clientes_plan.Descripcion
    FROM
    pprestatario_clientes_plan
    WHERE
    pprestatario_clientes_plan.CodRapido =  "' . $pPlan . '" AND
    pprestatario_clientes_plan.IdCliente = ' . $pCliente;
    //echo $qry;
    $CampoLlave = explode("^",$gBaseDatos->jasonSP_arreglo2011($qry));
    $gBaseDatos->liberar();
    $gBaseDatos->cerrar();
    echo $CampoLlave[0] . '^' . $CampoLlave[1];
}

function searchSubPlan(){
    $pPlan = isset($_REQUEST['pPlan']) ? $_REQUEST['pPlan']:0;
    $pSubPlan = isset($_REQUEST['pSubPlan']) ? $_REQUEST['pSubPlan']:"-NA";
    $gBaseDatos = new ofiMySQLi();
    $gBaseDatos->conectar();
    $qry = 'SELECT
    pprestatario_clientes_subplan.IdSubPlan,
    pprestatario_clientes_subplan.Descripcion
    FROM
    pprestatario_clientes_subplan
    WHERE
    pprestatario_clientes_subplan.IdPlan = ' . $pPlan . ' AND
    pprestatario_clientes_subplan.Activo = 1 AND
    pprestatario_clientes_subplan.CodRapido = "' . $pSubPlan . '"';
    //echo $qry;
    $CampoLlave = explode("^",$gBaseDatos->jasonSP_arreglo2011($qry));
    $gBaseDatos->liberar();
    $gBaseDatos->cerrar();
    echo $CampoLlave[0] . '^' . $CampoLlave[1];
}

function searchContrato(){
    $pCliente = isset($_REQUEST['pCliente']) ? $_REQUEST['pCliente']:0;
    $pContrato = isset($_REQUEST['pContrato']) ? $_REQUEST['pContrato']:"-NA";
    $gBaseDatos = new ofiMySQLi();
    $gBaseDatos->conectar();
    $qry = 'SELECT
    pprestatario_clientes_contrato.IdContrato,
    pprestatario_clientes_contrato.Descripcion
    FROM
    pprestatario_clientes_contrato
    WHERE
    pprestatario_clientes_contrato.IdCliente = ' . $pCliente . ' AND
    pprestatario_clientes_contrato.CodRapido = "' . $pContrato . '" AND
    pprestatario_clientes_contrato.Activo = 1';
    //echo $qry;
    $CampoLlave = explode("^",$gBaseDatos->jasonSP_arreglo2011($qry));
    $gBaseDatos->liberar();
    $gBaseDatos->cerrar();
    echo $CampoLlave[0] . '^' . $CampoLlave[1];
}

function searchConcepto(){
    $pCliente = isset($_REQUEST['pCliente']) ? $_REQUEST['pCliente']:0;
    $pPlan = isset($_REQUEST['pPlan']) ? $_REQUEST['pPlan']:0;
    $pSubPlan = isset($_REQUEST['pSubPlan']) ? $_REQUEST['pSubPlan']:0;
    $pConcepto = isset($_REQUEST['pConcepto']) ? $_REQUEST['pConcepto']:"-NA";
    $gBaseDatos = new ofiMySQLi();
    $gBaseDatos->conectar();
    $qry = 'SELECT
    tmp_conceptos.IdProced,
    tmp_conceptos.DesProced,
    tmp_conceptos.Tarifa
    FROM
    tmp_conceptos
    WHERE
    tmp_conceptos.IdCliente =  ' . $pCliente . ' AND
    tmp_conceptos.IdPlan =  ' . $pPlan . ' AND
    tmp_conceptos.IdSubPlan =  ' . $pSubPlan . ' AND
    tmp_conceptos.CodProced =  "' . $pConcepto . '"';
    //echo $qry;
    $CampoLlave = explode("^",$gBaseDatos->jasonSP_arreglo2011($qry));
    $gBaseDatos->liberar();
    $gBaseDatos->cerrar();
    echo $CampoLlave[0] . '^' . $CampoLlave[1] . '^' . $CampoLlave[2];
}

function searchProfesional(){
    $pConcepto = isset($_REQUEST['pConcepto']) ? $_REQUEST['pConcepto']:0;
    $pProfesional = isset($_REQUEST['pProfesional']) ? $_REQUEST['pProfesional']:"-NA";
    $gBaseDatos = new ofiMySQLi();
    $gBaseDatos->conectar();
    $qry = 'SELECT
    pprofesionales.idProfesional,
    pprofesionales.Descripcion
    FROM
    pprofesionales_programarprocedimientos
    Inner Join pprofesionales ON pprofesionales_programarprocedimientos.idProfesional = pprofesionales.idProfesional
    WHERE
    pprofesionales.CodRapido =  "' . $pProfesional . '" AND
    pprofesionales.Activo =  1 AND
    pprofesionales_programarprocedimientos.IdProced = ' . $pConcepto;
    //echo $qry;
    $CampoLlave = explode("^",$gBaseDatos->jasonSP_arreglo2011($qry));
    $gBaseDatos->liberar();
    $gBaseDatos->cerrar();
    echo $CampoLlave[0] . '^' . $CampoLlave[1];
}

function searchUltimaAsigna(){
    $pPaciente = isset($_REQUEST['pPaciente']) ? $_REQUEST['pPaciente']:0;
    $gBaseDatos = new ofiMySQLi();
    $gBaseDatos->conectar();
    $qry = 'SELECT
    pprestatario_clientes.CodRapido AS Campo00,
    pprestatario_clientes.IdCliente AS Campo01,
    pprestatario_clientes.Descripcion AS Campo02,
    pprestatario_clientes_plan.CodRapido AS Campo03,
    pprestatario_clientes_plan.IdPlan AS Campo04,
    pprestatario_clientes_plan.Descripcion AS Campo05,
    pprestatario_clientes_subplan.CodRapido AS Campo06,
    pprestatario_clientes_subplan.IdSubPlan AS Campo07,
    pprestatario_clientes_subplan.Descripcion AS Campo08,
    pprestatario_clientes_contrato.CodRapido AS Campo09,
    pprestatario_clientes_contrato.IdContrato AS Campo10,
    pprestatario_clientes_contrato.NroContrato AS Campo11
    FROM
    estudios
    Inner Join pprestatario_clientes ON estudios.Cliente = pprestatario_clientes.IdCliente
    Inner Join pprestatario_clientes_plan ON estudios.Cliente = pprestatario_clientes_plan.IdCliente AND estudios.Plan = pprestatario_clientes_plan.IdPlan
    Inner Join pprestatario_clientes_subplan ON estudios.Plan = pprestatario_clientes_subplan.IdPlan
    Inner Join pprestatario_clientes_contrato ON estudios.Contrato = pprestatario_clientes_contrato.IdContrato AND estudios.Cliente = pprestatario_clientes_contrato.IdCliente
    WHERE
    estudios.CAS = (SELECT
    Max(estudios.CAS)
    FROM
    estudios
    WHERE
    estudios.Paciente = ' .$pPaciente . ' AND
    estudios.Origen LIKE  "%ASIGNA%")';
    //echo $qry;
    //$CampoLlave = explode("^",$gBaseDatos->jasonSP_arreglo2011($qry));
    echo $gBaseDatos->jasonSP_arreglo2011($qry);
    $gBaseDatos->liberar();
    $gBaseDatos->cerrar();
    //echo $CampoLlave[0] . '^' . $CampoLlave[1] . '^' . $CampoLlave[2] . '^' . $CampoLlave[3] . '^' . $CampoLlave[4] . '^' . $CampoLlave[5] . '^' . $CampoLlave[6] . '^' . $CampoLlave[7] . '^' . $CampoLlave[8] . '^' . $CampoLlave[9] . '^' . $CampoLlave[10] . '^' . $CampoLlave[11];
}

?>