<?php
/*
* @category    Listar Usuario x Codigo 
* @package     OfiClinic Web
* @author      Jorge Ancizar Galeano Ruiz<desarrollo@ofisalud.com>
* @copyright   2010 Jorge Ancizar Galeano Ruiz
* @version     OfiClinic Web 1.0
* @license     COMERCIAL
* @link        http://www.ofisalud.com
* @country     Colombia
* @telephone   3016398114
*/
header("Content-Type: text/plain; charset=utf-8");
require("../../../core/php/_database.php");
require("../../../core/php/php_functions.php");

$task = '';
if ( isset($_POST['task'])){
  $task = $_POST['task'];
}
switch($task){
    case "qryxusuario":
        BuscarUsuario();
        break;
    case "LISTAR":
        Listar();
        break;
    case "LISTAR_USRxBODEGA":
        ListarxBodegas();
        break;
    case "LISTAR_USRxIPS":
        ListarxIPS();
        break;
    case "INSERTAR":
        Insertar();
        break;
    case "MODIFICAR":
        Modificar();
        break;
    case "ASOCIAR_IPS":
        AsociarIPS();
        break;
    case "ASOCIAR_BODEGA":
        AsociarBOD();
        break;
    case "DESASOCIAR_BODEGAS":
        DesasociarBOD();
        break;
    case "DESASOCIAR_IPS":
        DesasociarIPS();
        break;
    case "CAMBIARPASS":
        CambiarPass();
        break;
    default:
        break;
}

function CambiarPass(){
    $pUsuario = isset($_REQUEST['pUsuario'])?$_REQUEST['pUsuario']:0;
    $pPassNew = isset($_REQUEST['pPassNew'])?$_REQUEST['pPassNew']:"NOAPLICA";
    $gBaseDatos = new ofiMySQLi();
    $gBaseDatos->conectar();
    $qry = "CALL sp_ususariosist_changepass('" . $pUsuario . "',\"" . $pPassNew . "\")";
    if(@mysqli_query($gBaseDatos->ConexionID, $qry))
        echo "{success: true, requestedId:'1'}";
    else
        echo "{success: true, requestedId:'0'}";
    $gBaseDatos->cerrar();
}

function DesasociarBOD(){
    $pUsuario = isset($_REQUEST['pUsuario'])?$_REQUEST['pUsuario']:0;
    $pBodega = isset($_REQUEST['pBodega'])?$_REQUEST['pBodega']:0;
    $gBaseDatos = new ofiMySQLi();
    $gBaseDatos->conectar();
    $qry = "CALL sp_ususariosist_desasociarbod('" . $pBodega . "','" . $pUsuario . "')";
    if(@mysqli_query($gBaseDatos->ConexionID, $qry))
        echo '1';
    else
        echo '0';
    $gBaseDatos->cerrar();    
}

function DesasociarIPS(){
    $pUsuario = isset($_REQUEST['pUsuario'])?$_REQUEST['pUsuario']:0;
    $pIPS = isset($_REQUEST['pIPS'])?$_REQUEST['pIPS']:0;
    $gBaseDatos = new ofiMySQLi();
    $gBaseDatos->conectar();
    $qry = "CALL sp_ususariosist_desasociarips('" . $pIPS . "','" . $pUsuario . "')";
    if(@mysqli_query($gBaseDatos->ConexionID, $qry))
        echo '1';
    else
        echo '0';
    $gBaseDatos->cerrar();
}

function AsociarBOD(){
    $estructura = explode("¬", $_REQUEST['CAMPOS']);
    $gBaseDatos = new ofiMySQLi();
    $gBaseDatos->conectar();
    $qry = "CALL sp_ususariosist_asociarbod(" . spParametros($estructura,"SI") . ")";
    if(@mysqli_query($gBaseDatos->ConexionID, $qry))
        echo "{success: true, requestedId:'1'}";
    else
       echo "{success: true, requestedId:'0'}";
    $gBaseDatos->cerrar();
}

function AsociarIPS()
{
    $estructura = explode("¬", $_REQUEST['CAMPOS']);
    $gBaseDatos = new ofiMySQLi();
    $gBaseDatos->conectar();
    $qry = "CALL sp_ususariosist_asociarips(" . spParametros($estructura,"SI") . ")";
    if(@mysqli_query($gBaseDatos->ConexionID, $qry))
        echo "{success: true, requestedId:'1'}";
    else
       echo "{success: true, requestedId:'0'}";
    $gBaseDatos->cerrar();
}

function Modificar()
{
    $estructura = explode("¬", $_REQUEST['CAMPOS']);
    $gBaseDatos = new ofiMySQLi();
    $gBaseDatos->conectar();
    $qry = "CALL sp_ususariosist_update(" . spParametros($estructura,"SI") . ")";
    if(@mysqli_query($gBaseDatos->ConexionID, $qry))
        echo "{success: true, requestedId:'1'}";
    else
       echo "{success: true, requestedId:'0'}";
    $gBaseDatos->cerrar();
}

function Insertar()
{
    $estructura = explode("¬", $_REQUEST['CAMPOS']);
    $gBaseDatos = new ofiMySQLi();
    $gBaseDatos->conectar();
    $qry = "CALL sp_ususariosist_insert(" . spParametros($estructura,"SI") . ")";
    //echo $qry;
    if(@mysqli_query($gBaseDatos->ConexionID, $qry))
        echo "{success: true, requestedId:'1'}";
    else
       echo "{success: true, requestedId:'0'}";
    $gBaseDatos->cerrar();
}

function ListarxBodegas(){
    $pUsuario = isset($_REQUEST['pUsuario'])?$_REQUEST['pUsuario']:0;
    $gBaseDatos = new ofiMySQLi();
    $gBaseDatos->conectar();
    $qry = "CALL sp_usuariossist_listar_bodegas('" . $pUsuario . "')";
    $gBaseDatos->QryID = @mysqli_query($gBaseDatos->ConexionID, $qry);
    $arr = array();
    if($gBaseDatos->QryID)
    {
        while($row = @mysqli_fetch_assoc($gBaseDatos->QryID))
        {
            $nRow = $row;
            foreach($row as $key => $val)
            {
                $nRow[$key] = PonerAcentosHTML($val);
            }
            $arr[] = $nRow;
        }
        $jsonresult = JEncode($arr);
        $gBaseDatos->liberar();
        $gBaseDatos->cerrar();
        echo '({success: true, requestedId:"1", "total":"1","results":'.$jsonresult.'})';
    } else {
        $gBaseDatos->liberar();
        $gBaseDatos->cerrar();
        echo '({success: false, requestedId:"1", "total":"0", "results":""})';
    }
}

function ListarxIPS(){
    $pUsuario = isset($_REQUEST['pUsuario'])?$_REQUEST['pUsuario']:0;
    $gBaseDatos = new ofiMySQLi();
    $gBaseDatos->conectar();
    $qry = "CALL sp_usuariossist_listar_ips('" . $pUsuario . "')";
    $gBaseDatos->QryID = @mysqli_query($gBaseDatos->ConexionID, $qry);
    $arr = array();
    if($gBaseDatos->QryID)
    {
        while($row = @mysqli_fetch_assoc($gBaseDatos->QryID))
        {
            $nRow = $row;
            foreach($row as $key => $val)
            {
                $nRow[$key] = PonerAcentosHTML($val);
            }
            $arr[] = $nRow;
        }
        $jsonresult = JEncode($arr);
        $gBaseDatos->liberar();
        $gBaseDatos->cerrar();
        echo '({success: true, requestedId:"1", "total":"1","results":'.$jsonresult.'})';
    } else {
        $gBaseDatos->liberar();
        $gBaseDatos->cerrar();
        echo '({success: false, requestedId:"1", "total":"0", "results":""})';
    }
}

function Listar(){
    $pEmpresa = isset($_REQUEST['paramP1'])?$_REQUEST['paramP1']:0;
    $pDescripcion = isset($_REQUEST['query'])?$_REQUEST['query']:null;
    if (is_null($pDescripcion) || $pDescripcion == "")
        $pDescripcion = "Todos";
    $gBaseDatos = new ofiMySQLi();
    $gBaseDatos->conectar();
    $qry = "CALL sp_usuariossist_listar('" . $pEmpresa . "',\"" . $pDescripcion . "\")";
    $gBaseDatos->QryID = @mysqli_query($gBaseDatos->ConexionID, $qry);
    $arr = array();
    if($gBaseDatos->QryID)
    {
        while($row = @mysqli_fetch_assoc($gBaseDatos->QryID))
        {
            $nRow = $row;
            foreach($row as $key => $val)
            {
                $nRow[$key] = PonerAcentosHTML($val);
            }
            $arr[] = $nRow;
        }
        $jsonresult = JEncode($arr);
        $gBaseDatos->liberar();
        $gBaseDatos->cerrar();
        echo '({success: true, requestedId:"1", "total":"1","results":'.$jsonresult.'})';
    } else {
        $gBaseDatos->liberar();
        $gBaseDatos->cerrar();
        echo '({success: false, requestedId:"1", "total":"0", "results":""})';
    }
}

function BuscarUsuario(){
    $gBaseDatos = new ofiMySQLi();
    $gBaseDatos->conectar();
    $pUsuario = isset($_REQUEST['pUsuario'])?$_REQUEST['pUsuario']:0;
    $qry = "CALL sp_usuarios_buscarxcodigo('" . $pUsuario . "')";
    echo $gBaseDatos->jsonSP($qry,"R");
    $gBaseDatos->liberar();
    $gBaseDatos->cerrar();
}

?>
