<?php

session_start();
require_once('../../../lib/tcpdf/config/lang/spa.php');
require_once('../../../lib/tcpdf/tcpdf.php');

//Definicion de las Margenes
$LeftMargin = PDF_MARGIN_LEFT;
$TopMargin = 5;
$RightMargin = PDF_MARGIN_RIGHT;
$HeaderMargin = PDF_MARGIN_HEADER;
$BottomMargin = 3;
$FooterMargin = 5;
$Alineacion = "P";
$FormatoPagina = "CARTA";
$UsaPiePagina = "NO";
$pTipoEncabezado = "FVP";
$pControlSalto = 30;

//Inicializacion de la Clase
$pdf = new TCPDF($Alineacion, PDF_UNIT, $FormatoPagina, true, 'UTF-8', false);
$pdf->pAlineacionEncabezado = $Alineacion;
$pdf->pTituloInforme = "EJEMPLO";
$pdf->pImprimeLogo = "NO";
$pdf->pAnchoTxtPagina = 210;
$pdf->pNomEmpresa = "";
$pdf->pTDocEmpresa = "";
$pdf->pDocEmpresa = "";
$pdf->pDirEmpresa = "";
$pdf->pTelEmpresa = "";
$pdf->pCiuEmpresa = "";
$pdf->pEspEmpresa = "";
$pdf->pRegEmpresa = "";
$pdf->pContribuyentes = "";
$pdf->pReteIVA = "";
$pdf->pReteICA = "";
$pdf->pTipoEncabezado = $pTipoEncabezado;
$pdf->pNomSede = "";
$pdf->pNomIPS = "";
$pdf->pMargenPie = -20;
$pdf->pLogoCliente = "../../../empresas/1/logo/logoenc.png";
$pdf->pPrefijo = 1;
$pdf->pNroDocumento = 1;
$pdf->pNroResolucion = 1;
$pdf->pFechaDoc = 1;
$pdf->pCAS = null;
$pdf->pTratamiento = null;
$pdf->pUsaPie = $UsaPiePagina;
$pdf->SetCreator(PDF_CREATOR);
$pdf->SetAuthor('Sistemas Ofisalud © - 2006');
$pdf->SetTitle('OfiClinic©');
$pdf->SetSubject('Soporte Historia Clinica');
$pdf->SetHeaderData($pdf->pLogoCliente, PDF_HEADER_LOGO_WIDTH, $pdf->pTituloInforme, PDF_HEADER_STRING);
$pdf->setHeaderFont(Array(PDF_FONT_NAME_MAIN, '', PDF_FONT_SIZE_MAIN));
$pdf->setFooterFont(Array(PDF_FONT_NAME_DATA, '', PDF_FONT_SIZE_DATA));
$pdf->SetDefaultMonospacedFont(PDF_FONT_MONOSPACED);
$pdf->SetMargins($LeftMargin, $TopMargin, $RightMargin);
$pdf->SetHeaderMargin($HeaderMargin);
$pdf->SetFooterMargin($FooterMargin);
$pdf->SetAutoPageBreak(TRUE, $BottomMargin);
$pdf->setImageScale(PDF_IMAGE_SCALE_RATIO);
$pdf->setLanguageArray($l);
$pdf->setFontSubsetting(true);
$pdf->SetFont('dejavusans', '', 14, '', true);

$pdf->AddPage($Alineacion,$FormatoPagina);
$pdf->Ln(2);
$pdf->SetFont(PDF_FONT_NAME_MAIN, '', 7);
    
$contenidoImp = "Imprimir Logo: ";
$pdf->writeHTML($contenidoImp, true, false, false, false, '');
$contenidoImp = '<img src="../../../empresas/1/logo/logoenc.png" align="right"/>';
$pdf->writeHTML($contenidoImp, true, false, false, false, '');

$pdf->Ln(2);
$contenidoImp = "Imprimir Diente: ";
$pdf->writeHTML($contenidoImp, true, false, false, false, '');
$contenidoImp = '<img src="../../../resources/odontograma/diente.png" align="right"/>';
$pdf->writeHTML($contenidoImp, true, false, false, false, '');


$pdf->Output('infPrueba.pdf', 'I');

?>