<?php
    session_start();
    set_time_limit(500);
    require_once('../../../lib/tcpdf/config/lang/spa.php');
    require_once('../../../lib/tcpdf/tcpdf.php');
    require("../../../core/php/_database.php");
    require("../../../core/php/php_functions.php");
    //require("../asistencial/formatoshc/formatoshc.php");
    //header('Content-type: application/pdf; charset: UTF-8');

    $pConsultorioVirtual = $_SESSION['IDBD'];
    $nomEmpresa = $_SESSION['NOM_EMPRESA'];
    $nomUsuario = $_SESSION['NOM_USUARIO'];
    $pEmpresa = isset($_REQUEST['pEmpresa'])?$_REQUEST['pEmpresa']:1;
    $pIPS = isset($_REQUEST['pIPS'])?$_REQUEST['pIPS']:1;
    $pPaciente = isset($_REQUEST['pPaciente'])?$_REQUEST['pPaciente']:0;
    $pEvolucion = isset($_REQUEST['pEvolucion'])?$_REQUEST['pEvolucion']:0;
    $pConsecutivoDetalle = isset($_REQUEST['pConsecutivoDetalle'])?$_REQUEST['pConsecutivoDetalle']:0;
    //Definicion de las Margenes
    $LeftMargin = PDF_MARGIN_LEFT;
    $TopMargin = 5;
    $RightMargin = PDF_MARGIN_RIGHT;
    $HeaderMargin = PDF_MARGIN_HEADER;
    $BottomMargin = 3;
    $FooterMargin = 5;
    $Alineacion = "P";
    $FormatoPagina = "CARTA";
    $UsaPiePagina = "SI";
    $pTipoEncabezado = "FVP";
    $pControlSalto = 30;
    $estructura = explode("¬", $_REQUEST['param']);
    $pNomParametros = spNomParametrosMI($estructura,"NO");
    $NameParam = explode("¬", $pNomParametros);
    $pParametros = spParametrosMI($estructura,"NO");
    $DataParam = explode("¬", $pParametros);
       
    $items = count($NameParam);
    for ($i=0; $i<$items; $i++)
    {
        switch ($NameParam[$i]) 
        {
            case "intEmpresa":
                if ($DataParam[$i] == "" || $DataParam[$i] == null || $DataParam[$i] == "null")
                    $pEmpresa = 0;
                else
                    $pEmpresa = $DataParam[$i];
                break;
                
            case "intIPS":
                if ($DataParam[$i] == "" || $DataParam[$i] == null || $DataParam[$i] == "null")
                    $pIPS = 0;
                else
                    $pIPS = $DataParam[$i];
                break;
                
            case "intCliente":
                if ($DataParam[$i] == "" || $DataParam[$i] == null || $DataParam[$i] == "null")
                    $pCliente = 0;
                else
                    $pCliente = $DataParam[$i];
                break;
                
            case "intPlan":
                if ($DataParam[$i] == "" || $DataParam[$i] == null || $DataParam[$i] == "null")
                    $pPlan = 0;
                else
                    $pPlan = $DataParam[$i];
                break;
                
            case "intSubPlan":
                if ($DataParam[$i] == "" || $DataParam[$i] == null || $DataParam[$i] == "null")
                    $pSubPlan = 0;
                else
                    $pSubPlan = $DataParam[$i];
                break;
                
            case "fecDesde":
                if ($DataParam[$i] == "" || $DataParam[$i] == null || $DataParam[$i] == "null")
                {    
                    $pDesde = date('Y-m-d');
                }else{
                    $pDesde = $DataParam[$i];
                }
                break;
                
            case "fecHasta":
                if ($DataParam[$i] == "" || $DataParam[$i] == null || $DataParam[$i] == "null")
                {
                    $pHasta = date('Y-m-d');
                }else{
                    $pHasta = $DataParam[$i];
                }
                break;
                
            case "strCampo1":
                if ($DataParam[$i] == "" || $DataParam[$i] == null || $DataParam[$i] == "null")
                {
                    $pCampo1 = 'NO';
                }else{
                    $pCampo1 = $DataParam[$i];
                }
                break;
            
            case "strCampo2":
                if ($DataParam[$i] == "" || $DataParam[$i] == null || $DataParam[$i] == "null")
                {
                    $pCampo2 = 'NO';
                }else{
                    $pCampo2 = $DataParam[$i];
                }
                break;
            
            case "strCampo3":
                if ($DataParam[$i] == "" || $DataParam[$i] == null || $DataParam[$i] == "null")
                {
                    $pCampo3 = 'NO';
                }else{
                    $pCampo3 = $DataParam[$i];
                }
                break;
            
            case "intContrato":
                if ($DataParam[$i] == "" || $DataParam[$i] == null || $DataParam[$i] == "null")
                {
                    $pContrato = 0;
                }else{
                    $pContrato = $DataParam[$i];
                }
                break;
                
            case "strPaciente":
                if ($DataParam[$i] == "" || $DataParam[$i] == null || $DataParam[$i] == "null")
                {
                    $pPaciente = 'Todos';
                }else{
                    $pPaciente = $DataParam[$i];
                }
                break;
                
            case "strAutorizacion":
                if ($DataParam[$i] == "" || $DataParam[$i] == null || $DataParam[$i] == "null")
                {
                    $pAutorizacion = 'Todos';
                }else{
                    $pAutorizacion = $DataParam[$i];
                }
                break;
            
            case "strTipoAnatomopatologia":
                if ($DataParam[$i] == "" || $DataParam[$i] == null || $DataParam[$i] == "null")
                {
                    $pTipoAnatomo = 'Todos';
                }else{
                    $pTipoAnatomo = $DataParam[$i];
                }
                break;
                
            case "strPrefijoAnatomopatologia":
                if ($DataParam[$i] == "" || $DataParam[$i] == null || $DataParam[$i] == "null")
                {
                    $pPrefijoAnatomo = 'Todos';
                }else{
                    $pPrefijoAnatomo = $DataParam[$i];
                }
                break;
                
            case "intExaDesdeAnatomopatologia":
                if ($DataParam[$i] == "" || $DataParam[$i] == null || $DataParam[$i] == "null")
                {
                    $pDesdeAnatomo = 0;
                }else{
                    $pDesdeAnatomo = $DataParam[$i];
                }
                break;
                
            case "intExaHastaAnatomopatologia":
                if ($DataParam[$i] == "" || $DataParam[$i] == null || $DataParam[$i] == "null")
                {
                    $pHastaAnatomo = 0;
                }else{
                    $pHastaAnatomo = $DataParam[$i];
                }
                break;
            
            default:
                break;
        }
    }
    if($pCliente != "" && $pCliente != null && $pCliente != 0){
        //Inicializacion de la Clase
        $pdf = new TCPDF($Alineacion, PDF_UNIT, $FormatoPagina, true, 'UTF-8', false);
        //Inicializacion Variables de Control
        $pdf->pAlineacionEncabezado = $Alineacion;
        $pdf->pTituloInforme = "REPORTE CITOLOGIAS";
        $pdf->pImprimeLogo = "NO";
        $pdf->pAnchoTxtPagina = 210;
        $pdf->pNomEmpresa = $_SESSION['NOM_EMPRESA'];
        $pdf->pTDocEmpresa = $_SESSION['EMPRESA_TDOC'];
        $pdf->pDocEmpresa = $_SESSION['EMPRESA_DOC'];
        $pdf->pDirEmpresa = $_SESSION['EMPRESA_DIR'];
        $pdf->pTelEmpresa = $_SESSION['EMPRESA_TEL'];
        $pdf->pCiuEmpresa = $_SESSION['EMPRESA_CIU'];
        $pdf->pEspEmpresa = $_SESSION['EMPRESA_ESP'];
        $pdf->pRegEmpresa = $_SESSION['EMPRESA_REGIMEN'];
        $pdf->pContribuyentes = $_SESSION['EMPRESA_CONTRIBUYENTE'];
        $pdf->pReteIVA  = $_SESSION['EMPRESA_RTEICA'];
        $pdf->pReteICA = $_SESSION['EMPRESA_RTEIVA'];

        $pdf->pTipoEncabezado = $pTipoEncabezado;
        $pdf->pNomSede = $_SESSION['EMPRESA_DOC'];
        $pdf->pNomIPS = $_SESSION['NOM_IPS'];
        $pdf->pMargenPie = -20;
        if($_SESSION['IdAplicacion'] == "OfiMedical"){
            $pdf->pLogoCliente = "../../../consultoriovirtual/" . $_SESSION['IDBD'] . "/logo/logoenc.gif";
        }else{
            $pdf->pLogoCliente = "../../../empresas/" . $_SESSION['ID_EMPRESA'] . "/logo/logoenc.gif";
        }
        $pdf->pPrefijo = 1; //$row[$i]["Prefijo"];
        $pdf->pNroDocumento = 1; //str_pad($row[$i]["NroDocumento"], 7, "0", STR_PAD_LEFT);
        $pdf->pNroResolucion = 1; //$row[$i]["NroResolucion"];
        $pdf->pFechaDoc = 1; //$row[$i]["FechaDocumento"];
        $pdf->pCAS = null;
        $pdf->pTratamiento = null;
        $pdf->pUsaPie = $UsaPiePagina;

        $pdf->SetCreator(PDF_CREATOR);
        $pdf->SetAuthor('Sistemas Ofisalud © - 2006');
        $pdf->SetTitle('OfiClinic©');
        $pdf->SetSubject('Soporte Reporte Anatomopatologia');

        $pdf->SetHeaderData($pdf->pLogoCliente, PDF_HEADER_LOGO_WIDTH, $pdf->pTituloInforme, PDF_HEADER_STRING);
        $pdf->setHeaderFont(Array(PDF_FONT_NAME_MAIN, '', PDF_FONT_SIZE_MAIN));
        $pdf->setFooterFont(Array(PDF_FONT_NAME_DATA, '', PDF_FONT_SIZE_DATA));
        $pdf->SetDefaultMonospacedFont(PDF_FONT_MONOSPACED);
        $pdf->SetMargins($LeftMargin, $TopMargin, $RightMargin);
        $pdf->SetHeaderMargin($HeaderMargin);
        $pdf->SetFooterMargin($FooterMargin);
        // set bacground image

        $pdf->SetAutoPageBreak(TRUE, $BottomMargin);
        $pdf->setImageScale(PDF_IMAGE_SCALE_RATIO);
        $pdf->setLanguageArray($l);
        $pdf->setFontSubsetting(true);
        $pdf->SetFont('dejavusans', '', 14, '', true);

        $gBaseDatos = new ofiMySQLi();
        $gBaseDatos->conectar();

        $qry = "CALL sp_macroinformes_anatomo_resultados_cito('" . $pEmpresa . "','" . $pIPS . "','" . $pCliente . "','" . $pPlan . "','" . $pSubPlan . "','" . $pContrato . "',\"" . $pDesde . "\",\"" . $pHasta . "\",\"" . $pTipoAnatomo . "\",\"" . $pPrefijoAnatomo . "\",'" . $pDesdeAnatomo . "','" . $pHastaAnatomo . "')";
        //echo $qry;

        //$pdf->AddPage($Alineacion,$FormatoPagina);
        //$pdf->writeHTML($qry, true, false, false, false, '');

        $gBaseDatos->QryID = @mysqli_query($gBaseDatos->ConexionID, $qry);
        unset($rowHC);
        while ($rowHC[] = @mysqli_fetch_assoc($gBaseDatos->QryID));
        $gBaseDatos->liberar();
        $gBaseDatos->cerrar();
        $pRegistros = count($rowHC);
        $pProfesional = 0;
        $pNomProfesional = "";
        $pnomEspecialidad = "";
        $pRegistroProfesional = "";
        $pImprimeFirmas = "SI";
        $idPaciente = "";
        for($i=0;$i<$pRegistros;$i++){
            if($rowHC[$i]["nomPaciente"] != ""){
                $TamanoFuente = 9;
                if ($idPaciente != $rowHC[$i]["nomPaciente"])
                {
                    $pdf->SetFont(PDF_FONT_NAME_MAIN, '', 8);
                    EncabezadoPaginaCITOLOGIA($pdf, $rowHC, $i, $rowcount, $contador, $pDesde, $pHasta, $pNomAplicacion);
                }
                $pdf->SetFont(PDF_FONT_NAME_MAIN, '', $TamanoFuente);
                $pdf->Ln(2);
                $ResultadoHTML = "";
                $ResultadoHTML .= '<table cellspacing="0" border="0">';
                $ResultadoHTML .= '<tr>';
                $ResultadoHTML .= '<td width="30"></td>';
                $ResultadoHTML .= '<td width="1000">';
                unset($rowHC_A);
                $gBaseDatosA = new ofiMySQLi();
                $gBaseDatosA->conectar();
                $qry = "CALL sp_asistencial_printhc_citologia_detalle('" . $rowHC[$i]["CAS"] . "','" . $rowHC[$i]["Paciente"] . "','" . $rowHC[$i]["ConsecutivoDetalle"] . "',\"A\")";
                $gBaseDatosA->QryID = @mysqli_query($gBaseDatosA->ConexionID, $qry);
                while ($rowHC_A[] = @mysqli_fetch_assoc($gBaseDatosA->QryID));
                $gBaseDatosA->liberar();
                $gBaseDatosA->cerrar();
                $pRegistrosA = count($rowHC_A);
                if($pRegistrosA > 0){
                    if(PonerAcentosHTML(utf8_decode($rowHC_A[0]["Descripcion"])) != "" && PonerAcentosHTML(utf8_decode($rowHC_A[0]["Descripcion"])) != null){
                        $ResultadoHTML .= '<span><b>A. CALIDAD DE LA MUESTRA</b></span>';
                        for($k=0;$k<$pRegistrosA;$k++){
                            $ResultadoHTML .= '<br><span>' . PonerAcentosHTML(utf8_decode($rowHC_A[$k]["Descripcion"])) . '</span>';
                        }
                    }
                }
                unset($rowHC_B);
                $gBaseDatos = new ofiMySQLi();
                $gBaseDatos->conectar();
                $qry = "CALL sp_asistencial_printhc_citologia_detalle('" . $rowHC[$i]["CAS"] . "','" . $rowHC[$i]["Paciente"] . "','" . $rowHC[$i]["ConsecutivoDetalle"] . "',\"B\")";
                $gBaseDatos->QryID = @mysqli_query($gBaseDatos->ConexionID, $qry);
                while ($rowHC_B[] = @mysqli_fetch_assoc($gBaseDatos->QryID));
                $gBaseDatos->liberar();
                $gBaseDatos->cerrar();
                $pRegistrosB = count($rowHC_B);
                if($pRegistrosB>0){
                    if(PonerAcentosHTML(utf8_decode($rowHC_B[0]["Descripcion"])) != "" && PonerAcentosHTML(utf8_decode($rowHC_B[0]["Descripcion"])) != null){
                        $ResultadoHTML .= '<span><b>B. CATEGORIZACION GENERAL</b></span>';
                        for($k=0;$k<$pRegistrosB;$k++){
                            $ResultadoHTML .= '<br><span>' . PonerAcentosHTML(utf8_decode($rowHC_B[$k]["Descripcion"])) . '</span>';
                        }
                    }
                }
                unset($rowHC_C);
                $gBaseDatos = new ofiMySQLi();
                $gBaseDatos->conectar();
                $qry = "CALL sp_asistencial_printhc_citologia_detalle('" . $rowHC[$i]["CAS"] . "','" . $rowHC[$i]["Paciente"] . "','" . $rowHC[$i]["ConsecutivoDetalle"] . "',\"C\")";
                $gBaseDatos->QryID = @mysqli_query($gBaseDatos->ConexionID, $qry);
                while ($rowHC_C[] = @mysqli_fetch_assoc($gBaseDatos->QryID));
                $gBaseDatos->liberar();
                $gBaseDatos->cerrar();
                $pRegistrosC = count($rowHC_C);
                if($pRegistrosC>0){
                    if(PonerAcentosHTML(utf8_decode($rowHC_C[0]["Descripcion"])) != "" && PonerAcentosHTML(utf8_decode($rowHC_C[0]["Descripcion"])) != null){
                        $ResultadoHTML .= '<span><b>C. MICROORGANISMOS</b></span>';
                        for($k=0;$k<$pRegistrosC;$k++){
                            $ResultadoHTML .= '<br><span>' . PonerAcentosHTML(utf8_decode($rowHC_C[$k]["Descripcion"])) . '</span>';
                        }
                    }
                }
                unset($rowHC_D);
                $gBaseDatos = new ofiMySQLi();
                $gBaseDatos->conectar();
                $qry = "CALL sp_asistencial_printhc_citologia_detalle('" . $rowHC[$i]["CAS"] . "','" . $rowHC[$i]["Paciente"] . "','" . $rowHC[$i]["ConsecutivoDetalle"] . "',\"D\")";
                $gBaseDatos->QryID = @mysqli_query($gBaseDatos->ConexionID, $qry);
                while ($rowHC_D[] = @mysqli_fetch_assoc($gBaseDatos->QryID));
                $gBaseDatos->liberar();
                $gBaseDatos->cerrar();
                $pRegistrosD = count($rowHC_D);
                if($pRegistrosD>0){
                    if(PonerAcentosHTML(utf8_decode($rowHC_D[0]["Descripcion"])) != "" && PonerAcentosHTML(utf8_decode($rowHC_D[0]["Descripcion"])) != null){
                        $ResultadoHTML .= '<span><b>D. OTROS HALLAZGOS NO NEOPLASICOS</b></span>';
                        for($k=0;$k<$pRegistrosA;$k++){
                            $ResultadoHTML .= '<br><span>' . PonerAcentosHTML(utf8_decode($rowHC_D[$k]["Descripcion"])) . '</span>';
                        }
                    }
                }
                unset($rowHC_E);
                $gBaseDatos = new ofiMySQLi();
                $gBaseDatos->conectar();
                $qry = "CALL sp_asistencial_printhc_citologia_detalle('" . $rowHC[$i]["CAS"] . "','" . $rowHC[$i]["Paciente"] . "','" . $rowHC[$i]["ConsecutivoDetalle"] . "',\"E\")";
                $gBaseDatos->QryID = @mysqli_query($gBaseDatos->ConexionID, $qry);
                while ($rowHC_E[] = @mysqli_fetch_assoc($gBaseDatos->QryID));
                $gBaseDatos->liberar();
                $gBaseDatos->cerrar();
                $pRegistrosE = count($rowHC_E);
                if($pRegistrosE>0){
                    if(PonerAcentosHTML(utf8_decode($rowHC_E[0]["Descripcion"])) != "" && PonerAcentosHTML(utf8_decode($rowHC_E[0]["Descripcion"])) != null){
                        $ResultadoHTML .= '<span><b>E. ANORMALIDADES EN CELULAS ESCAMOSAS</b></span>';
                        for($k=0;$k<$pRegistrosA;$k++){
                            $ResultadoHTML .= '<br><span>' . PonerAcentosHTML(utf8_decode($rowHC_E[$k]["Descripcion"])) . '</span>';
                        }
                    }
                }
                unset($rowHC_F);
                $gBaseDatos = new ofiMySQLi();
                $gBaseDatos->conectar();
                $qry = "CALL sp_asistencial_printhc_citologia_detalle('" . $rowHC[$i]["CAS"] . "','" . $rowHC[$i]["Paciente"] . "','" . $rowHC[$i]["ConsecutivoDetalle"] . "',\"F\")";
                $gBaseDatos->QryID = @mysqli_query($gBaseDatos->ConexionID, $qry);
                while ($rowHC_F[] = @mysqli_fetch_assoc($gBaseDatos->QryID));
                $gBaseDatos->liberar();
                $gBaseDatos->cerrar();
                $pRegistrosF = count($rowHC_F);
                if($pRegistrosF>0){
                    if(PonerAcentosHTML(utf8_decode($rowHC_F[0]["Descripcion"])) != "" && PonerAcentosHTML(utf8_decode($rowHC_F[0]["Descripcion"])) != null){
                        $ResultadoHTML .= '<span><b>F. ANORMALIDADES EN CELULAS GLANDULARES</b></span>';
                        for($k=0;$k<$pRegistrosA;$k++){
                            $ResultadoHTML .= '<br><span>' . PonerAcentosHTML(utf8_decode($rowHC_F[$k]["Descripcion"])) . '</span>';
                        }
                    }
                }
                if($rowHC[$i]["ObservacionesGenCit"] != "" && $rowHC[$i]["ObservacionesGenCit"] != null){
                    $ResultadoHTML .= '<br><span>' . PonerAcentosHTML($rowHC[$i]["ObservacionesGenCit"]) . '</span>';
                }
                $ResultadoHTML .= '</td></tr></table>';
                if($ResultadoHTML != "" && $ResultadoHTML != null){
                    $pdf->SetFont(PDF_FONT_NAME_MAIN, '', 8);
                    $pdf->writeHTML($ResultadoHTML, true, false, false, false, '');
                    if ($pdf->GetY() >= ($pdf->getPageHeight()-$pControlSalto))
                    {
                        EncabezadoPaginaCITOLOGIA($pdf, $rowHC, $i, $rowcount, $contador, $pDesde, $pHasta, $pNomAplicacion);
                    }
                }
                $mostrarHC = '<br><table border="0" cellspacing="0">';
                if($rowHC[$i]["EstadoAnatomo"] == "CERRADO"){
                    if($pNomAplicacion == "OfiMedical"){
                        if (file_exists('../../../consultoriovirtual/' . $_SESSION['IDBD']  . '/firmas/' . $rowHC[$i]["Profesional"] . '.png')) {
                            $mostrarHC .= '<tr>';
                            $mostrarHC .= '<td width="300" valign="middle"><img src="../../../consultoriovirtual/' . $_SESSION['IDBD'] . '/firmas/' . $rowHC[$i]["Profesional"] . '.png" width="100" height="45"/></td>';
                            if($rowHC[$i]["NomReviso"] != "" && $rowHC[$i]["NomReviso"] != null){
                                $mostrarHC .= '<td width="70"></td>';
                                if (file_exists('../../../consultoriovirtual/' . $_SESSION['IDBD']  . '/firmas/' . $rowHC[$i]["ProfesionalReviso"] . '.png')) {
                                    $mostrarHC .= '<td width="300" valign="middle"><img src="../../../consultoriovirtual/' . $_SESSION['IDBD'] . '/firmas/' . $rowHC[$i]["ProfesionalReviso"] . '.png" width="100" height="45"/></td>';
                                }
                            }
                            $mostrarHC .= '</tr>';
                        }
                    }else{
                       if (file_exists('../../../empresas/' . $_SESSION['ID_EMPRESA']  . '/firmas/' . $rowHC[$i]["Profesional"] . '.png')) {
                            $mostrarHC .= '<tr>';
                            $mostrarHC .= '<td width="300" valign="middle"><img src="../../../empresas/' . $_SESSION['ID_EMPRESA'] . '/firmas/' . $rowHC[$i]["Profesional"] . '.png" width="100" height="45"/></td>';
                            if($rowHC[$i]["NomReviso"] != "" && $rowHC[$i]["NomReviso"] != null){
                                $mostrarHC .= '<td width="70"></td>';
                                if (file_exists('../../../consultoriovirtual/' . $_SESSION['IDBD']  . '/firmas/' . $rowHC[$i]["ProfesionalReviso"] . '.png')) {
                                    $mostrarHC .= '<td width="300" valign="middle"><img src="../../../empresas/' . $_SESSION['ID_EMPRESA'] . '/firmas/' . $rowHC[$i]["ProfesionalReviso"] . '.png" width="100" height="45"/></td>';
                                }
                            }
                            $mostrarHC .= '</tr>';
                        }
                    }

                }
                $mostrarHC .= '<tr>';
                $mostrarHC .= '<td width="300" style="font-size:32px; border-top-width: 1px; border-top-style: solid; text-align:left;">';
                $mostrarHC .= '<b>Realizado por: ' . utf8_decode($rowHC[$i]["NomProfesional"]) . '</b><br>CITOLOGO';
                $mostrarHC .= '</td>';
                if($rowHC[$i]["NomReviso"] != "" && $rowHC[$i]["NomReviso"] != null){
                    $mostrarHC .= '<td width="70"></td>';
                    $mostrarHC .= '<td width="300" style="font-size:32px; border-top-width: 1px; border-top-style: solid; text-align:left;">';
                    $mostrarHC .= '<b>Revisado Por: ' . utf8_decode($rowHC[$i]["NomReviso"]) . '</b><br>PATOLOGO';
                    $mostrarHC .= '</td>';
                }
                $mostrarHC .= '</tr>';
                $mostrarHC .= '</table>';
                $pdf->writeHTML($mostrarHC, true, false, false, false, '');
                $pImprimeFirmas = "NO";
            }
            $idPaciente = $rowHC[$i]["nomPaciente"];
        }
        $pdf->Output('infReportesCitologia.pdf', 'I');
    }

    function EncabezadoPaginaCITOLOGIA(&$pdf, &$rowHC, &$i, &$rowcount, &$contador, &$pDesde, &$pHasta, $pNomAplicacion){
        $pdf->pFechaDoc = "";
        $pdf->pCAS = "";
        $pdf->pAplicacionId = "";
        $pdf->pEntidad = "";
        $pdf->pInfo1 = "";
        $pdf->pInfo2 = "";
        $pdf->pInfo3 = "";
        $pdf->pInfo4 = "";
        $pdf->pInfo5 = "";
        $pdf->pInfo6 = "";
        $pdf->pInfo7 = "";
        $pdf->pInfo8 = "";
        $pdf->pInfo9 = "";
        $pdf->pInfo10 = "";
        $pdf->pInfo11 = "";
        $pdf->pInfo12 = "";
        $pdf->pInfo13 = "";
        $pdf->pInfo14 = "";
        
        $Alineacion = "L";
        $TopMargin = 3;
        $FormatoPagina = "MEDIACARTA";
        $pdf->pTipoEncabezado = "vREPORTECITOLOGIA";
        $pdf->pFechaDoc = $rowHC[$i]["Fecha"];
        $pdf->pCAS = $rowHC[$i]["CAS"];
        $pdf->pAplicacionId = $pNomAplicacion;
        $pdf->pEntidad = $rowHC[$i]["Cliente"];
        $pdf->pInfo1 = $_SESSION['ID_EMPRESA'];
        $pdf->pInfo2 = $_SESSION['IDBD'];
        $pdf->pInfo3 = $rowHC[$i]["Actividad"];
        $pdf->pInfo4 = utf8_decode($rowHC[$i]["TipDoc"]) . ' ' . utf8_decode($rowHC[$i]["Documento"]);
        $pdf->pInfo5 = PonerAcentosHTML(utf8_decode($rowHC[$i]["Nom1"])) . ' ' . PonerAcentosHTML(utf8_decode($rowHC[$i]["Nom2"])) . ' ' . PonerAcentosHTML(utf8_decode($rowHC[$i]["Ape1"])) . ' ' . PonerAcentosHTML(utf8_decode($rowHC[$i]["Ape2"]));
        $pdf->pInfo6 = $rowHC[$i]["Genero"];
        $pdf->pInfo7 = $rowHC[$i]["Edad"];
        $pdf->pInfo8 = $rowHC[$i]["Telefono"];
        $pdf->pInfo9 = $rowHC[$i]["EstadoAnatomo"];
        $pdf->pInfo10 = $rowHC[$i]["NroPlacaRef"];
        $pdf->pInfo11 = $rowHC[$i]["Direccion"];
        $pdf->pInfo12 = $rowHC[$i]["Remitente"];
        $pdf->pInfo13 = $rowHC[$i]["NroAutorizacion"];
        $pdf->pInfo14 = $rowHC[$i]["FechaCierreAnatomo"];

        if($rowHC[$i]["Telefono1"] != "" && $rowHC[$i]["Telefono1"] != null){
            $pdf->pInfo8 .= ' - ' . $rowHC[$i]["Telefono1"];
        }
        $pdf->setFooterMargin(8);
        $pdf->SetMargins(5,65,-1,true); 
        $pdf->AddPage($Alineacion,$FormatoPagina);
        $pdf->Ln(-60);
        $pdf->SetFont(PDF_FONT_NAME_MAIN, '', 10);
        $EncabezadoHTML = '<table cellspacing="0" border="0" style="font-size:24px; color:#000;">';
        $EncabezadoHTML .= '<tr>';
        $EncabezadoHTML .= '<td width="725" colspan="5" style="font-size:35px; color:#000; font-weight:bold" align="rigth">INFORME DE CITOLOGIA</td>';
        $EncabezadoHTML .= '</tr>';
        $EncabezadoHTML .= '<tr>';
        $EncabezadoHTML .= '<td width="32"></td>';
        $EncabezadoHTML .= '<td align="left" width="210">';
        if($pNomAplicacion == "OfiMedical"){
            if (file_exists("../../../consultoriovirtual/" . $_SESSION['IDBD'] . "/logo/logo.png")) {
                $EncabezadoHTML .= '<img src="../../../consultoriovirtual/' . $_SESSION['IDBD'] . '/logo/logo.png" align="right"/>';
                $EncabezadoHTML .= '<br>';
            }else{
                if (file_exists("../../../../consultoriovirtual/" . $_SESSION['IDBD'] . "/logo/logo.png")) {
                    $EncabezadoHTML .= '<img src="../../../../consultoriovirtual/' . $_SESSION['IDBD'] . '/logo/logo.png" align="right"/>';
                    $EncabezadoHTML .= '<br>';
                }
            }
        }else{
            if (file_exists("../../../empresas/" . $_SESSION['ID_EMPRESA'] . "/logo/logo.png")) {
                $EncabezadoHTML .= '<img src="../../../empresas/' . $_SESSION['ID_EMPRESA'] . '/logo/logo.png" width="210" height="110" align="right"/>';
                $EncabezadoHTML .= '<br>';
            }else{
                if (file_exists("../../../../empresas/" . $_SESSION['ID_EMPRESA'] . "/logo/logo.png")) {
                    $EncabezadoHTML .= '<img src="../../../../empresas/' . $_SESSION['ID_EMPRESA'] . '/logo/logo.png" width="210" height="110" align="right"/>';
                    $EncabezadoHTML .= '<br>';
                }
            }
        }
        $EncabezadoHTML .= '</td>';
        $EncabezadoHTML .= '<td width="20"></td>';
        //COL2
        $EncabezadoHTML .= '<td width="285"><br><br><br>';
        $EncabezadoHTML .= '<span style="font-size:37px; color:#000; font-weight:bold">' . utf8_decode($pdf->pNomEmpresa) . '</span><br>';
        //$EncabezadoHTML .= '<span style="font-size:40px; color:#000;">' . utf8_decode($this->pEspEmpresa) . '</span><br>';
        if($pdf->pTDocEmpresa == "NI"){
            $tipodoc = "NIT: ";
            $EncabezadoHTML .= '<span style="font-size:34px; color:#000;">' . $tipodoc . $pdf->pDocEmpresa . '</span><br>';
        }
        $EncabezadoHTML .= '<span style="font-size:34px; color:#000;">' . $pdf->pDirEmpresa . ' Telefonos: ' . $pdf->pTelEmpresa . '</span><br>';
        $EncabezadoHTML .= '<span style="font-size:34px; color:#000;">' . $pdf->pCiuEmpresa . '</span>';
        $EncabezadoHTML .= '</td>';
        $EncabezadoHTML .= '<td width="179" align="rigth">';
        $EncabezadoHTML .= '<span style="font-size:36px; color:#000;"><b>EXAMEN:&nbsp;' . PonerAcentosHTML(utf8_decode($rowHC[$i]["NroPlacaRef"])) . '</b></span><br>';
        if($rowHC[$i]["EstadoAnatomo"] == "CERRADO"){
            $EncabezadoHTML .= '<span style="font-size:34px; color:#000;"><b>FECHA:&nbsp;</b>' . PonerAcentosHTML(utf8_decode($rowHC[$i]["FechaCierreAnatomo"])) . '</span><br>';
        }else{
            if($rowHC[$i]["FechaRealizado"] != "" && $rowHC[$i]["FechaRealizado"] != null){
                $EncabezadoHTML .= '<span style="font-size:34px; color:#000;"><b>FECHA:&nbsp;</b>' . PonerAcentosHTML(utf8_decode($rowHC[$i]["FechaRealizado"])) . '</span><br>';
            }
        }
        $EncabezadoHTML .= '<span style="font-size:28px; color:#000;"><b>CAS:&nbsp;</b>' . $rowHC[$i]["CAS"] . '</span>';
        $EncabezadoHTML .= '</td>';
        $EncabezadoHTML .= '</tr>';
        $EncabezadoHTML .= '</table>';
        $pdf->writeHTML($EncabezadoHTML, true, false, false, false, '');
        $pdf->Ln(-6);
        $EncabezadoHTML = '<table cellspacing="0" border="0">';
        $EncabezadoHTML .= '<tr>';
        $EncabezadoHTML .= '<td width="32"></td>';
        $EncabezadoHTML .= '<td width="1000">';
        $EncabezadoHTML .= '<span style="font-size:36px; color:#000;"><b>PACIENTE:&nbsp;&nbsp;</b>' . PonerAcentosHTML(utf8_decode($rowHC[$i]["Nom1"])) . ' ' . PonerAcentosHTML(utf8_decode($rowHC[$i]["Nom2"])) . ' ' . PonerAcentosHTML(utf8_decode($rowHC[$i]["Ape1"])) . ' ' . PonerAcentosHTML(utf8_decode($rowHC[$i]["Ape2"])) . ' ' . utf8_decode($rowHC[$i]["TipDoc"]) . ' ' . utf8_decode($rowHC[$i]["Documento"]);
        if ($rowHC[$i]["Genero"] == "M"){
            $EncabezadoHTML .= '&nbsp;&nbsp;<b>GENERO:&nbsp;&nbsp;</b>MASCULINO';
        }else{
            $EncabezadoHTML .= '&nbsp;&nbsp;<b>GENERO:&nbsp;&nbsp;</b>FEMENINO';
        }
        $EncabezadoHTML .= '&nbsp;&nbsp;<b>EDAD:&nbsp;&nbsp;</b>' . $rowHC[$i]["Edad"] . '</span>';
        $EncabezadoHTML .= '</td>';
        $EncabezadoHTML .= '</tr>';
        $EncabezadoHTML .= '<tr>';
        $EncabezadoHTML .= '<td width="32"></td>';
        $EncabezadoHTML .= '<td width="1000">';
        if($rowHC[$i]["Direccion"] != "" && $rowHC[$i]["Direccion"] != null && $rowHC[$i]["Direccion"] != "NA"){
            $EncabezadoHTML .= '<span style="font-size:36px; color:#000;"><b>DIRECCION:&nbsp;&nbsp;</b>' . $rowHC[$i]["Direccion"] . '</span>&nbsp;&nbsp;-&nbsp;';
        }
        $EncabezadoHTML .= '<span style="font-size:36px; color:#000;"><b>TELEFONO:&nbsp;&nbsp;</b>' . $rowHC[$i]["Telefono"] . '</span>';
        $EncabezadoHTML .= '</td>';
        $EncabezadoHTML .= '</tr>';
        $EncabezadoHTML .= '<tr>';
        $EncabezadoHTML .= '<td width="32"></td>';
        $EncabezadoHTML .= '<td width="1000">';
        $EncabezadoHTML .= '<span style="font-size:36px; color:#000;"><b>ENTIDAD:&nbsp;&nbsp;</b>' . $rowHC[$i]["Cliente"] . '</span>';
        //if($this->pInfo13 != "" && $this->pInfo13 != null){
        //    $EncabezadoHTML .= '<br><span style="font-size:36px; color:#000;"><b>AUTORIZACION:&nbsp;&nbsp;</b>' . $this->pInfo13 . '</span>';
        //}
        $EncabezadoHTML .= '</td>';
        $EncabezadoHTML .= '</tr>';
        if($rowHC[$i]["Remitente"] != "" && $rowHC[$i]["Remitente"] != null && $rowHC[$i]["Remitente"] != "NA"){
            $EncabezadoHTML .= '<tr>';
            $EncabezadoHTML .= '<td width="32"></td>';
            $EncabezadoHTML .= '<td width="1000">';
            $EncabezadoHTML .= '<span style="font-size:36px; color:#000;"><b>REMITE:&nbsp;&nbsp;</b>' . $rowHC[$i]["Remitente"] . '</span>';
            $EncabezadoHTML .= '</td>';
            $EncabezadoHTML .= '</tr>';
        }
        $EncabezadoHTML .= '<tr>';
        $EncabezadoHTML .= '<td width="32"></td>';
        $EncabezadoHTML .= '<td width="1000">';
        $EncabezadoHTML .= '<br><span style="font-size:36px; color:#000;"><b>FECHA RECEPCION DEL EXAMEN:&nbsp;&nbsp;</b>' . $rowHC[$i]["Fecha"] . '</span>';
        $EncabezadoHTML .= '</td>';
        $EncabezadoHTML .= '</tr>';
        $EncabezadoHTML .= '</table>';
        $pdf->writeHTML($EncabezadoHTML, true, false, false, false, '');
    }

?>