<?php
    session_start();
    set_time_limit(500);
    require_once('../../../lib/tcpdf/config/lang/spa.php');
    require_once('../../../lib/tcpdf/tcpdf.php');
    require("../../../core/php/_database.php");
    require("../../../core/php/php_functions.php");
    //require("../asistencial/formatoshc/formatoshc.php");
    //header('Content-type: application/pdf; charset: UTF-8');
    $Alineacion = "L";
    $TopMargin = 1;
    $FormatoPagina = "LABORATORIO";
    $pdf = new TCPDF($Alineacion, PDF_UNIT, $FormatoPagina, true, 'UTF-8', false);
    $pdf->SetCreator(PDF_CREATOR);
    $pdf->SetAuthor('Sistemas Ofisalud © - 2006');
    $pdf->SetTitle('OfiClinic©');
    $pdf->SetSubject('Sticker Laboratorio');
    //remove header and footer
    $pdf->setPrintHeader(false);
    $pdf->setPrintFooter(false);
    // set default monospaced font
    $pdf->SetDefaultMonospacedFont(PDF_FONT_MONOSPACED);
    // set margins
    $pdf->setTopMargin(4);
    $pdf->SetLeftMargin(3.5);
    $pdf->SetRightMargin(2);
    $pdf->setHeaderMargin(0.1);
    $pdf->SetFooterMargin(0.5); //13mm
    // set auto page breaks
    $pdf->SetAutoPageBreak(TRUE, 0.5);
    $pdf->setLanguageArray($l);
    $pdf->setFontSubsetting(true);
    $pdf->pTipoEncabezado = "SIN";
    
    $styleBarCode = array(
        'position' => 'C',
        'align' => 'C',
        'stretch' => true,
        'fitwidth' => false,
        'cellfitalign' => 'C',
        'border' => true,
        'hpadding' => 'auto',
        'vpadding' => 'auto',
        'fgcolor' => array(0,0,0),
        'bgcolor' => false, //array(255,255,255),
        'text' => true,
        'border' => false,
        'font' => 'helvetica',
        'fontsize' => 7,
        'stretchtext' => 4
    );
    $style = array(
        'position' => '',
        'align' => 'C',
        'stretch' => false,
        'fitwidth' => true,
        'cellfitalign' => '',
        'border' => false,
        'hpadding' => 'auto',
        'vpadding' => 'auto',
        'fgcolor' => array(0,0,0),
        'bgcolor' => false, //array(255,255,255),
        'text' => true,
        'font' => 'helvetica',
        'fontsize' => 8,
        'stretchtext' => 4
    );
    $styleBarCode['position'] = 'R';
    
    
    $pCAS = isset($_REQUEST['pCAS'])?$_REQUEST['pCAS']:0;
    $qry = "CALL sp_laboratorioclinico_sticker('" .  $pCAS . "')";
    unset($rowHC);
    $gBaseDatos = new ofiMySQLi();
    $gBaseDatos->conectar();
    $gBaseDatos->QryID = @mysqli_query($gBaseDatos->ConexionID, $qry);
    while ($rowHC[] = @mysqli_fetch_assoc($gBaseDatos->QryID));
    $gBaseDatos->liberar();
    $gBaseDatos->cerrar();
    $pRegistros = count($rowHC);
    $idGrupo = "";
    $idPie = "";
    $TipoEstudio = '';
    for($i=0;$i<$pRegistros;$i++){
        if($rowHC[$i]["Examen"] != ""){
            $pie = $rowHC[$i]["TipoEstudio"];
            if ($rowHC[$i]["TipoEstudio"] != $idGrupo){
                EncabezadoPagina($pdf, $rowHC, $i);
                $pie = $rowHC[$i]["TipoEstudio"];
                $examenes = '<span style="font-size:22px;">';
                //$examenes .= $rowHC[$i]["Examen"] . "-";
            }
            $idGrupo = $rowHC[$i]["TipoEstudio"];
            if ($rowHC[$i+1]["TipoEstudio"] != $pie){
                $examenes .= $rowHC[$i]["Examen"] . "-";
                $examenes .= '</span>';
                //$pdf->Ln(-2);
                $pdf->writeHTML($examenes, true, false, false, false, '');
            }else{
                $examenes .= $rowHC[$i]["Examen"] . " - ";
            }
        }
    }
    
    $pdf->Output('infStickerLaboratorio.pdf', 'I');
    
    function EncabezadoPagina(&$pdf, &$rowHC, &$i){
        $Alineacion = "L";
        $FormatoPagina = "LABORATORIO";
        $pdf->AddPage($Alineacion,$FormatoPagina);
        $pdf->SetFont("Helvetica", '', 7);
        //$pdf->Ln(-4);
        //$pdf->write1DBarcode($rowHC[0]["CAS"], 'EAN13', '', '', '', 10, 0.4, $style, 'N');
        $pdf->write1DBarcode($rowHC[0]["CAS"], 'C93', '', '', '', 10, 0.4, $style, 'N');
        $pdf->SetFont(PDF_FONT_NAME_MAIN, '', 9);
        $EncabezadoHTML = '<span style="font-size:24px;">CAS: ' . $rowHC[0]["CAS"];
        //$EncabezadoHTML .= ' - CONS: ' . $rowHC[0]["NADEF"] . '</span><br>';
        $EncabezadoHTML .= ' - ' . $rowHC[0]["Entidad"] . '</span><br>';
        $EncabezadoHTML .= '<span style="font-size:22px;">' . substr($rowHC[0]["Documento"],0,30) . ' - ' . substr($rowHC[0]["nomPaciente"],0,19) . '</span>';
        $pdf->writeHTML($EncabezadoHTML, true, false, false, false, '');
    }
?>