<?php

/*
* @category    Controlador Profesionales
* @package     OfiClinic Web
* @author      Jorge Ancizar Galeano Ruiz<desarrollo@ofisalud.com>
* @copyright   2010 Jorge Ancizar Galeano Ruiz
* @version     OfiClinic Web 1.0
* @license     COMERCIAL
* @link        http://www.ofisalud.com
* @country     Colombia
* @telephone   3016398114
*/

require("../../../core/php/_database.php");
require("../../../core/php/php_functions.php");

$task = '';
if ( isset($_POST['task'])){
  $task = $_POST['task'];
}
switch($task){
    case "LISTAR_INTRUMENTADORAS":
        ListarxEspecialidad("INTRUMEN");
        break;
    case "LISTAR_ANESTESIOLOGOS":
        ListarxEspecialidad("ANESTESI");
        break;
    case "LISTAROFIMEDICAL":
        ListarOfimedical();
        break;
    case "LISTAR":
        Listar();
        break;
    case "BUSCAR":
        Listar();
        break;
    case "INSERTAR":
        Insertar();
        break;
    case "MODIFICAR":
        Modificar();
        break;
    case "ELIMINAR":
        Eliminar();
        break;
    case "GRID_SEDE_IPS":
        Listar_SedeIPS();
        break;
    case "GRID_SEDE_IPS_ASOCIAR":
        Asociar_SedeIPS();
        break;
    case "GRID_SEDE_IPS_ELIMINAR":
        Eliminar_SedeIPS();
        break;
    case "GRID_PLANTILLA_CITAS":
        Listar_PlantillaCitas();
        break;
    case "GRID_PLANTILLA_CITAS_INSERTAR":
        Insertar_PlantillaCitas();
        break;
    case "GRID_PLANTILLA_CITAS_ELIMINAR":
        Eliminar_PlantillaCitas();
        break;
    case "GRID_PLANTILLA_CITAS_HORARIO":
        Listar_PlantillaCitasHorario();
        break;
    case "GRID_PLANTILLA_CITAS_HORARIO_INSERTAR":
        Insertar_HorarioPlantillaCitas();
        break;
    case "GRID_PLANTILLA_CITAS_HORARIO_ELIMINAR":
        Eliminar_HorarioPlantillaCitas();
        break;
    case "GRID_PROCEDIMIENTOS":
        Listar_ProcedimientosaProgramar();
        break;
    case "GRID_PROCEDIMIENTOS_INSERTAR":
        Insertar_ProcedimientosaProgramar();
        break;
    case "GRID_PROCEDIMIENTOS_ELIMINAR":
        Eliminar_ProcedimientosaProgramar();
        break;
    case "GRID_AGENDA_PROGRAMADAS":
        Listar_AgendasProgramadas();
        break;  
    case "GRID_CONSULTORIOS_PROFESIONAL":
        Listar_ConsultoriosxProfe();
        break;
    case "ESTABLECER_FECHAS_PROGRAMAR":
        Listar_FechasxAgendar();
        break;  
    case "PROGRAMAR_AGENDAS_INSERTAR":
        ProgramarAgendas();
        break;  
    case "PROGRAMAR_AGENDAS_ANULAR":
        AnularAgendas();
        break; 
    case "GRID_CONSULTORIOS_IPS":
        Listar_GridConsultoriosxProfe();
        break; 
    case "GRID_CONSULTORIOS_INSERTAR":
        AsociarConsultorios();
        break; 
    case "GRID_CONSULTORIOS_ELIMINAR":
        DesasociarConsultorios();
        break; 
    case "AGENDA_MANUAL_LISTAR":
        AgendaManualListar();
        break;
    case "AGENDA_MANUAL_CANCELAR":
        AgendaManualCancelar();
        break;
    case "AGENDA_MANUAL_INASISTENCIA":
        AgendaManualInasistencia();
        break;
    case "AGENDA_MANUAL_ASIGNARCITA":
        AgendaManualAsignarCita();
        break;
    case "AGENDA_MANUAL_EVOLUCIONAR":
        AgendaManualEvolucionar();
        break;
    case "AGENDA_MANUAL_EVOLUCIONAR003":
        AgendaManualEvolucionar003();
        break;
    case "AGENDA_MANUAL_EVOLUCIONAR_ASOTRANSCAL":
        AgendaManualEvolucionarAsotranscal();
        break;
    case "GRID_PLANTILLA_PROCED":
        Listar_PlantillaProced();
        break;
    case "GRID_PLANTILLA_PROCED_INSERTAR":
        Insertar_PlantillaProced();
        break;
    case "GRID_PLANTILLA_PROCED_ELIMINAR":
        Eliminar_PlantillaProced();
        break;
    case "GRID_PLANTILLA_PROCED_MODIFICAR":
        Modificar_PlantillaProced();
        break;
    case "PLANTILLA_PROCED_LISTAR":
        Listar_PlantillaProced1();
        break;
    default:
        echo "{failure:true}";
        break;
}

function ListarxEspecialidad($pEspecialidad){
    $pEspecialidadxProfe = "%" . $pEspecialidad . "%";
    $gBaseDatos = new ofiMySQLi();
    $gBaseDatos->conectar();
    $qry = "CALL sp_combo_profesionales_listarxespecialidad(\"" . $pEspecialidadxProfe . "\")";
    $gBaseDatos->QryID = @mysqli_query($gBaseDatos->ConexionID, $qry);
    $arr = array();
    while($row = @mysqli_fetch_assoc($gBaseDatos->QryID))
    {
        $nRow = $row;
        foreach($row as $key => $val)
        {
            $nRow[$key] = PonerAcentosHTML($val);
        }
        $arr[] = $nRow;
    }
    $gBaseDatos->liberar();
    $gBaseDatos->cerrar();
    $jsonresult = JEncode($arr);
    if (!is_null($jsonresult))
        echo '({"total":"0","results":'. $jsonresult .'})'; 
}

function Listar_PlantillaProced1()
{
    $pProfesional = isset($_REQUEST['pProfesional'])?$_REQUEST['pProfesional']:1;
    //$pProced = isset($_REQUEST['pProced'])?$_REQUEST['pProced']:0;
    if($pProfesional == "" || $pProfesional == null){
        $pProfesional = 3;
    }
    $pProcedimiento = isset($_REQUEST['pProced'])?$_REQUEST['pProced']:0;
    $gBaseDatos = new ofiMySQLi();
    $gBaseDatos->conectar();
    $qry = "CALL sp_combo_profesionales_plantillaproced('" . $pProfesional . "','" . $pProcedimiento . "')";
    $gBaseDatos->QryID = @mysqli_query($gBaseDatos->ConexionID, $qry);
    $arr = array();
    while($row = @mysqli_fetch_assoc($gBaseDatos->QryID))
    {
        $nRow = $row;
        foreach($row as $key => $val)
        {
            $nRow[$key] = PonerAcentosHTML($val);
        }
        $arr[] = $nRow;
    }
    $gBaseDatos->liberar();
    $gBaseDatos->cerrar();
    $jsonresult = JEncode($arr);
    if (!is_null($jsonresult))
        echo '({"total":"0","results":'. $jsonresult .'})';
}

function Modificar_PlantillaProced(){
    $estructura = explode("¬", $_REQUEST['CAMPOS']);
    $gBaseDatos = new ofiMySQLi();
    $gBaseDatos->conectar();
    $qry = "CALL sp_profesionales_plantillaproced_update(" . spParametrosHTML($estructura,"NO") . ")";
    //echo $qry;
    if(@mysqli_query($gBaseDatos->ConexionID, $qry))
        echo "{success: true, requestedId:'1'}";
    else
       echo "{success: true, requestedId:'0'}";
    $gBaseDatos->cerrar();
}

function Eliminar_PlantillaProced()
{
    $pidPlantillaProcedxProfe = isset($_REQUEST['pidPlantillaProcedxProfe'])?$_REQUEST['pidPlantillaProcedxProfe']:0;
    $gBaseDatos = new ofiMySQLi();
    $gBaseDatos->conectar();
    $qry = "CALL sp_profesionales_plantillaproced_delete('" . $pidPlantillaProcedxProfe . "')";
    if(@mysqli_query($gBaseDatos->ConexionID, $qry))
        echo '1';
    else
        echo '0';
    $gBaseDatos->cerrar();
}

function Insertar_PlantillaProced(){
    $estructura = explode("¬", $_REQUEST['CAMPOS']);
    $qry = "CALL sp_profesionales_plantillaproced_insert(" . spParametrosHTML($estructura,"NO") . ")";
    //echo $qry;
    $gBaseDatos = new ofiMySQLi();
    $gBaseDatos->conectar();
    if(@mysqli_query($gBaseDatos->ConexionID, $qry))
        echo "{success: true, requestedId:'1'}";
    else
       echo "{success: true, requestedId:'0'}";
    $gBaseDatos->cerrar();
}

function AgendaManualEvolucionar003(){
    $pPrestador = isset($_REQUEST['pEmpresa'])?$_REQUEST['pEmpresa']:0;
    $pIPS = isset($_REQUEST['pIPS'])?$_REQUEST['pIPS']:0;
    $pProfesional = isset($_REQUEST['pProfesional'])?$_REQUEST['pProfesional']:0;
    $pFecha = isset($_REQUEST['pFecha'])?$_REQUEST['pFecha']:null;
    $pEstado = isset($_REQUEST['pEstado'])?$_REQUEST['pEstado']:'x';
    $gBaseDatos = new ofiMySQLi();
    $gBaseDatos->conectar();
    $qry = "CALL sp_profesionales_evolucionar2013('" . $pPrestador . "','"  . $pIPS . "','" . $pProfesional . "',\"" . $pFecha . "\",\"" . $pEstado . "\")";
    //echo $qry;
    $gBaseDatos->QryID = @mysqli_query($gBaseDatos->ConexionID, $qry);
    $arr = array();
    while($row = @mysqli_fetch_assoc($gBaseDatos->QryID))
    {
        $nRow = $row;
        foreach($row as $key => $val)
        {
            $nRow[$key] = PonerAcentosHTML($val);
        }
        $arr[] = $nRow;
    }
    $gBaseDatos->liberar();
    $gBaseDatos->cerrar();
    $jsonresult = JEncode($arr);
    if (!is_null($jsonresult))
        echo '({"total":"0","results":'. $jsonresult .'})';
}

function AgendaManualEvolucionar(){
    $pPrestador = isset($_REQUEST['pEmpresa'])?$_REQUEST['pEmpresa']:0;
    $pIPS = isset($_REQUEST['pIPS'])?$_REQUEST['pIPS']:0;
    $pProfesional = isset($_REQUEST['pProfesional'])?$_REQUEST['pProfesional']:0;
    $pFecha = isset($_REQUEST['pFecha'])?$_REQUEST['pFecha']:null;
    $pEstado = isset($_REQUEST['pEstado'])?$_REQUEST['pEstado']:'x';
    $gBaseDatos = new ofiMySQLi();
    $gBaseDatos->conectar();
    $qry = "CALL sp_profesionales_agendamanual_evolucionar('" . $pPrestador . "','"  . $pIPS . "','" . $pProfesional . "',\"" . $pFecha . "\",\"" . $pEstado . "\")";
    //echo $qry;
    $gBaseDatos->QryID = @mysqli_query($gBaseDatos->ConexionID, $qry);
    $arr = array();
    while($row = @mysqli_fetch_assoc($gBaseDatos->QryID))
    {
        $nRow = $row;
        foreach($row as $key => $val)
        {
            $nRow[$key] = PonerAcentosHTML($val);
        }
        $arr[] = $nRow;
    }
    $gBaseDatos->liberar();
    $gBaseDatos->cerrar();
    $jsonresult = JEncode($arr);
    if (!is_null($jsonresult))
        echo '({"total":"0","results":'. $jsonresult .'})';
}

function AgendaManualEvolucionarAsotranscal(){
    $pPrestador = isset($_REQUEST['pEmpresa'])?$_REQUEST['pEmpresa']:0;
    $pIPS = isset($_REQUEST['pIPS'])?$_REQUEST['pIPS']:0;
    $pProfesional = isset($_REQUEST['pProfesional'])?$_REQUEST['pProfesional']:0;
    $pFecha = isset($_REQUEST['pFecha'])?$_REQUEST['pFecha']:null;
    $pEstado = isset($_REQUEST['pEstado'])?$_REQUEST['pEstado']:'x';
    $gBaseDatos = new ofiMySQLi();
    $gBaseDatos->conectar();
    $qry = "CALL sp_agendamanual_evolucionar('" . $pPrestador . "','"  . $pIPS . "',\"" . $pFecha . "\",\"" . $pEstado . "\")";
    //echo $qry;
    $gBaseDatos->QryID = @mysqli_query($gBaseDatos->ConexionID, $qry);
    $arr = array();
    while($row = @mysqli_fetch_assoc($gBaseDatos->QryID))
    {
        $nRow = $row;
        foreach($row as $key => $val)
        {
            $nRow[$key] = PonerAcentosHTML($val);
        }
        $arr[] = $nRow;
    }
    $gBaseDatos->liberar();
    $gBaseDatos->cerrar();
    $jsonresult = JEncode($arr);
    if (!is_null($jsonresult))
        echo '({"total":"0","results":'. $jsonresult .'})';
}


function AgendaManualAsignarCita(){
    $CodInsercion = "PRS-" .  $_SESSION['ID_EMPRESA'] . "-SED-" . $_SESSION['ID_SEDE'] .  "-IPS-" . $_SESSION['ID_IPS'] . "-USR-" . $_SESSION['ID_USUARIO'] . "-CONS-" . mt_rand(0,100000) . "-" . date("His");
    $pEmpresa = isset($_REQUEST['pEmpresa'])?$_REQUEST['pEmpresa']:0;
    $pIPS = isset($_REQUEST['pIPS'])?$_REQUEST['pIPS']:0;
    $pProfesionalCita = isset($_REQUEST['pProfesionalCita'])?$_REQUEST['pProfesionalCita']:0;
    $pFechaCita = isset($_REQUEST['pFechaCita'])?$_REQUEST['pFechaCita']:null;
    $pHoraCita = isset($_REQUEST['pHoraCita'])?$_REQUEST['pHoraCita']:null;
    $pHoraCitaInfAdd = isset($_REQUEST['pHoraCitaInfAdd'])?$_REQUEST['pHoraCitaInfAdd']:null;
    $pPaciente = isset($_REQUEST['pPaciente'])?$_REQUEST['pPaciente']:0;
    $pCliente = isset($_REQUEST['pCliente'])?$_REQUEST['pCliente']:0;
    $pPlan = isset($_REQUEST['pPlan'])?$_REQUEST['pPlan']:0;
    $pSubPlan = isset($_REQUEST['pSubPlan'])?$_REQUEST['pSubPlan']:0;
    $pIdProcedimiento = isset($_REQUEST['pConcepto'])?$_REQUEST['pConcepto']:0;
    $pCodProcedimiento = isset($_REQUEST['pCodProced'])?$_REQUEST['pCodProced']:"";
    $pDesProcedimiento = isset($_REQUEST['pDesProced'])?$_REQUEST['pDesProced']:"";
    $pTarifaProcedimiento = isset($_REQUEST['pTarifaProced'])?$_REQUEST['pTarifaProced']:0;
    $pSolicitudUsuario = isset($_REQUEST['pSolicitudUsuario'])?$_REQUEST['pSolicitudUsuario']:0;
    $pUsuario = isset($_REQUEST['pUsuario'])?$_REQUEST['pUsuario']:0;
    $anio = substr($pFechaCita, 0, 4);
    $mes = substr($pFechaCita, 5, 2);
    $dia = substr($pFechaCita, 8, 2);
    $fecCita = mktime(0,0,0,$mes,$dia,$anio);
    $diaSemanaCita = date("D",$fecCita);
    $horaCita = date("H",$fecCita);
    $OportunidadCita = OportunidadAsignacionCitas($fecCita);
    $qry = "CALL sp_profesionales_agendamanual_asignar(\"" . $CodInsercion . "\",'" . $pEmpresa . "','" .$pIPS . "','" . $pProfesionalCita . "',\"" . $pFechaCita . "\",\"" . $pHoraCita . "\",\"" . $pHoraCitaInfAdd . "\",'" . $pPaciente . "','" . $pCliente . "','" . $pPlan . "','" . $pSubPlan . "','" . $pIdProcedimiento . "',\"" . $pCodProcedimiento . "\",\"" . $pDesProcedimiento . "\",'" . $pTarifaProcedimiento . "','" . $pUsuario . "',\"" . $pSolicitudUsuario . "\",'" . $OportunidadCita . "')";
    //echo $qry;
    $gBaseDatos = new ofiMySQLi();
    $gBaseDatos->conectar();
    echo $gBaseDatos->jasonSP_arreglo($qry);
    $gBaseDatos->liberar();
    $gBaseDatos->cerrar();
}
function AgendaManualInasistencia(){
    $pIdAgenda = isset($_REQUEST['pIdAgenda'])?$_REQUEST['pIdAgenda']:0;
    $pCAS = isset($_REQUEST['pCAS'])?$_REQUEST['pCAS']:0;
    $pMotivo = isset($_REQUEST['pMotivo']) ? utf8_encode(str_replace('"', '""',$_REQUEST['pMotivo'])):null;
    $pUsuario = isset($_REQUEST['pUsuario']) ? $_REQUEST['pUsuario']:0;
    $gBaseDatos = new ofiMySQLi();
    $gBaseDatos->conectar();
    $qry = "CALL sp_profesionales_agendamanual_inasistencia('" . $pIdAgenda . "','" . $pCAS . "',\"" . $pMotivo . "\",'" . $pUsuario . "')";
    //echo $qry;
    if(@mysqli_query($gBaseDatos->ConexionID, $qry))
        echo "{success: true, requestedId:'1'}";
        else
       echo "{success: true, requestedId:'0'}";
    $gBaseDatos->cerrar();
}

function AgendaManualCancelar(){
    $pIdAgenda = isset($_REQUEST['pIdAgenda'])?$_REQUEST['pIdAgenda']:0;
    $pCAS = isset($_REQUEST['pCAS'])?$_REQUEST['pCAS']:0;
    $pMotivo = isset($_REQUEST['pMotivo']) ? utf8_encode(str_replace('"', '""',$_REQUEST['pMotivo'])):null;
    $pUsuario = isset($_REQUEST['pUsuario']) ? $_REQUEST['pUsuario']:0;
    $gBaseDatos = new ofiMySQLi();
    $gBaseDatos->conectar();
    $qry = "CALL sp_profesionales_agendamanual_cancelar('" . $pIdAgenda . "','" . $pCAS . "',\"" . $pMotivo . "\",'" . $pUsuario . "')";
    //echo $qry;
    if(@mysqli_query($gBaseDatos->ConexionID, $qry))
        echo "{success: true, requestedId:'1'}";
    else
       echo "{success: true, requestedId:'0'}";
    $gBaseDatos->cerrar();
}

function AgendaManualListar(){
    $pPrestador = isset($_REQUEST['pPrestador'])?$_REQUEST['pPrestador']:0;
    $pIPS = isset($_REQUEST['pIPS'])?$_REQUEST['pIPS']:0;
    $pProfesional = isset($_REQUEST['pProfesional'])?$_REQUEST['pProfesional']:0;
    $pFecha = isset($_REQUEST['pFecha'])?$_REQUEST['pFecha']:null;
    $pEstado = isset($_REQUEST['pEstado'])?$_REQUEST['pEstado']:'x';
    $gBaseDatos = new ofiMySQLi();
    $gBaseDatos->conectar();
    $qry = "CALL sp_profesionales_agendamanual_list('" . $pPrestador . "','"  . $pIPS . "','" . $pProfesional . "',\"" . $pFecha . "\",\"" . $pEstado . "\")";
    //echo $qry;
    $gBaseDatos->QryID = @mysqli_query($gBaseDatos->ConexionID, $qry);
    $arr = array();
    while($row = @mysqli_fetch_assoc($gBaseDatos->QryID))
    {
        $nRow = $row;
        foreach($row as $key => $val)
        {
            $nRow[$key] = PonerAcentosHTML($val);
        }
        $arr[] = $nRow;
    }
    $gBaseDatos->liberar();
    $gBaseDatos->cerrar();
    $jsonresult = JEncode($arr);
    if (!is_null($jsonresult))
        echo '({"total":"0","results":'. $jsonresult .'})';
}

function DesasociarConsultorios(){
    $pProfesional = isset($_REQUEST['pProfesional'])?$_REQUEST['pProfesional']:0;
    $pIPS = isset($_REQUEST['pIPS'])?$_REQUEST['pIPS']:0;
    $pConsultorio = isset($_REQUEST['pConsultorio'])?$_REQUEST['pConsultorio']:0;
    $gBaseDatos = new ofiMySQLi();
    $gBaseDatos->conectar();
    $qry = "CALL sp_profesionales_consultorios_delete('" . $pProfesional . "','" . $pIPS . "','" . $pConsultorio . "')";
    if(@mysqli_query($gBaseDatos->ConexionID, $qry))
        echo '1';
    else
        echo '0';
    $gBaseDatos->cerrar();
}

function Listar_GridConsultoriosxProfe(){
    $pProfesional = isset($_REQUEST['pProfesional'])?$_REQUEST['pProfesional']:0;
    $pIPS = isset($_REQUEST['pIPS'])?$_REQUEST['pIPS']:0;
    $gBaseDatos = new ofiMySQLi();
    $gBaseDatos->conectar();
    $qry = "CALL sp_grid_consultoriosxipsxprofe1('" . $pIPS . "','" . $pProfesional . "')";
    //echo $qry;
    $gBaseDatos->QryID = @mysqli_query($gBaseDatos->ConexionID, $qry);
    $arr = array();
    while($row = @mysqli_fetch_assoc($gBaseDatos->QryID))
    {
        $nRow = $row;
        foreach($row as $key => $val)
        {
            $nRow[$key] = PonerAcentosHTML($val);
        }
        $arr[] = $nRow;
    }
    $gBaseDatos->liberar();
    $gBaseDatos->cerrar();
    $jsonresult = JEncode($arr);
    if (!is_null($jsonresult))
        echo '({"total":"0","results":'. $jsonresult .'})';
    
}

function AsociarConsultorios(){
    $estructura = explode("¬", $_REQUEST['CAMPOS']);
    $gBaseDatos = new ofiMySQLi();
    $gBaseDatos->conectar();
    $qry = "CALL sp_profesionales_consultorios_asociar(" . spParametros($estructura,"SI") . ")";
    //echo $qry;
    if(@mysqli_query($gBaseDatos->ConexionID, $qry))
        echo "{success: true, requestedId:'1'}";
    else
       echo "{success: true, requestedId:'0'}";
    $gBaseDatos->cerrar();
}

function ListarOfimedical(){
    $gBaseDatos = new ofiMySQLi();
    $gBaseDatos->conectar();
    $qry = "CALL sp_profesionales_listar()";
    //echo $qry;
    $gBaseDatos->QryID = @mysqli_query($gBaseDatos->ConexionID, $qry);
    $arr = array();
    while($row = @mysqli_fetch_assoc($gBaseDatos->QryID))
    {
        $nRow = $row;
        foreach($row as $key => $val)
        {
            $nRow[$key] = PonerAcentosHTML($val);
        }
        $arr[] = $nRow;
    }
    $gBaseDatos->liberar();
    $gBaseDatos->cerrar();
    $jsonresult = JEncode($arr);
    if (!is_null($jsonresult))
        echo '({"total":"0","results":'. $jsonresult .'})';
    
}

function Listar_ConsultoriosxProfe(){
    $pProfesional = isset($_REQUEST['pProfesional'])?$_REQUEST['pProfesional']:0;
    $pIPS = isset($_REQUEST['pIPS'])?$_REQUEST['pIPS']:0;
    $gBaseDatos = new ofiMySQLi();
    $gBaseDatos->conectar();
    $qry = "CALL sp_grid_consultoriosxipsxprofe('" . $pIPS . "','" . $pProfesional . "')";
    //echo $qry;
    $gBaseDatos->QryID = @mysqli_query($gBaseDatos->ConexionID, $qry);
    $arr = array();
    while($row = @mysqli_fetch_assoc($gBaseDatos->QryID))
    {
        $nRow = $row;
        foreach($row as $key => $val)
        {
            $nRow[$key] = PonerAcentosHTML($val);
        }
        $arr[] = $nRow;
    }
    $gBaseDatos->liberar();
    $gBaseDatos->cerrar();
    $jsonresult = JEncode($arr);
    if (!is_null($jsonresult))
        echo '({"total":"0","results":'. $jsonresult .'})';
    
}
function AnularAgendas(){
    $pAgenda = isset($_REQUEST['pAgenda'])?$_REQUEST['pAgenda']:0;
    $gBaseDatos = new ofiMySQLi();
    $gBaseDatos->conectar();
    $qry = "CALL sp_profesionales_agendas_programar_delete_det('" . $pAgenda . "')";
    if(@mysqli_query($gBaseDatos->ConexionID, $qry))
    {
        $qry = "CALL sp_profesionales_agendas_programar_delete_cab('" . $pAgenda . "')";
        if(@mysqli_query($gBaseDatos->ConexionID, $qry))
            echo '1';
        else
            echo '0';
    }else
        echo '0';
    $gBaseDatos->cerrar();
}

function ProgramarAgendas(){
    session_start();
    $pIPS = isset($_REQUEST['pIPS'])?$_REQUEST['pIPS']:0;
    $pProfesional = isset($_REQUEST['pProfesional'])?$_REQUEST['pProfesional']:0;
    $pPlantilla = isset($_REQUEST['pPlantilla'])?$_REQUEST['pPlantilla']:0;
    $pConsultorio = isset($_REQUEST['pConsultorio'])?$_REQUEST['pConsultorio']:null;
    if ($pConsultorio == "" || $pConsultorio == "null")
        $pConsultorio = null;
    $pUsuario = isset($_REQUEST['pUsuario'])?$_REQUEST['pUsuario']:0;
    $pDias = isset($_REQUEST['pDias'])?$_REQUEST['pDias']:null;
    $arrFechas = str_replace("/", "-", explode(',',$pDias));
    $Cantidad = count($arrFechas);
    $pConsultorios = isset($_REQUEST['pConsultorios'])?$_REQUEST['pConsultorios']:null;
    $arrConsultorios = explode(',',$pConsultorios);
    $CantidadConsultorios = 0;
    $CantidadConsultorios = count($arrConsultorios);
    if ($pConsultorio != null)
    {
        $CodInsercion = "PRS-" .  $_SESSION['ID_EMPRESA'] . "-SED-" . $_SESSION['ID_SEDE'] . "-IPS-" . $_SESSION['ID_IPS'] . "-USR-" . $_SESSION['ID_USUARIO'] . "-CONS-" . mt_rand(0,100000) . "-" . date("His");
        $gBaseDatos = new ofiMySQLi();
        $gBaseDatos->conectar();
        for ($i = 0; ($i < $Cantidad); $i++) {
            $qry = "INSERT INTO pprestatario_sedes_ips_profesionales_agendas (CodInsercion, idProfesional, idIPS, idConsultorio, idPlantilla, fecAgenda, estado, Usuario, FechaAct ) VALUES (\"" . $CodInsercion . "\",'" . $pProfesional . "','" . $pIPS . "','" . $pConsultorio . "','" . $pPlantilla . "',\"" . $arrFechas[$i] . "\",\"a\",'" . $pUsuario . "',now())";
            @mysqli_query($gBaseDatos->ConexionID, $qry);
        }
        $qry = "CALL sp_profesionales_agendas_programar_add(\"" . $CodInsercion . "\",'" . $_SESSION['ID_EMPRESA'] . "')";
        @mysqli_query($gBaseDatos->ConexionID, $qry);
        $gBaseDatos->cerrar(); 
        echo '1';
    }else{
        for ($j=0; $j<($CantidadConsultorios); $j++){
            $CodInsercion = "PRS-" .  $_SESSION['ID_EMPRESA'] . "-SED-" . $_SESSION['ID_SEDE'] . "-IPS-" . $_SESSION['ID_IPS'] . "-USR-" . $_SESSION['ID_USUARIO'] . "-CONS-" . mt_rand(0,100000) . "-" . date("His");
            $gBaseDatos = new ofiMySQLi();
            $gBaseDatos->conectar();
            for ($i = 0; ($i < $Cantidad); $i++) {
                $qry = "INSERT INTO pprestatario_sedes_ips_profesionales_agendas (CodInsercion, idProfesional, idIPS, idConsultorio, idPlantilla, fecAgenda, estado, Usuario, FechaAct ) VALUES (\"" . $CodInsercion . "\",'" . $pProfesional . "','" . $pIPS . "','" . $arrConsultorios[$j] . "','" . $pPlantilla . "',\"" . $arrFechas[$i] . "\",\"a\",'" . $pUsuario . "',now())";
                @mysqli_query($gBaseDatos->ConexionID, $qry);
            }
            $qry = "CALL sp_profesionales_agendas_programar_add(\"" . $CodInsercion . "\",'" . $_SESSION['ID_EMPRESA'] . "')";
            @mysqli_query($gBaseDatos->ConexionID, $qry);
            $gBaseDatos->cerrar(); 
        }
        echo '1';
    }
}

function Listar_FechasxAgendar(){

    $pLunes = isset($_REQUEST['pLunes'])?$_REQUEST['pLunes']:"false";
    $pMartes = isset($_REQUEST['pMartes'])?$_REQUEST['pMartes']:"false";
    $pMiercoles = isset($_REQUEST['pMiercoles'])?$_REQUEST['pMiercoles']:"false";
    $pJueves = isset($_REQUEST['pJueves'])?$_REQUEST['pJueves']:"false";
    $pViernes = isset($_REQUEST['pViernes'])?$_REQUEST['pViernes']:"false";
    $pSabado = isset($_REQUEST['pSabado'])?$_REQUEST['pSabado']:"false";
    $pDomingo = isset($_REQUEST['pDomingo'])?$_REQUEST['pDomingo']:"false";
    $pDesde = isset($_REQUEST['pDesde'])?$_REQUEST['pDesde']:date('d-m-Y',time());
    $pHasta = isset($_REQUEST['pHasta'])?$_REQUEST['pHasta']:date('d-m-Y',time());
    $dia = substr($pDesde, 0, 2);
    $mes = substr($pDesde, 3, 2);
    $anio = substr($pDesde, 6, 4);
    $fecDesde = mktime(0,0,0,$mes,$dia,$anio);
    $dia = substr($pHasta, 0, 2);
    $mes = substr($pHasta, 3, 2);
    $anio = substr($pHasta, 6, 4);
    $fecHasta = mktime(0,0,0,$mes,$dia,$anio);

    $gBaseDatos = new ofiMySQLi();
    $gBaseDatos->conectar();
    $qry = "CALL sp_diasnohabiles_listar('" . $_SESSION['ID_EMPRESA'] . "')";
    //echo $qry;
    $gBaseDatos->QryID = @mysqli_query($gBaseDatos->ConexionID, $qry);
    $diasNoHabiles = array("f");
    while ($row[] = @mysqli_fetch_array($gBaseDatos->QryID,MYSQL_NUM));
    $gBaseDatos->liberar();
    $gBaseDatos->cerrar();
    for ($i=0;$i<30;$i++){
        array_push($diasNoHabiles, $row[$i][0]);
    }
    $res = '{success: true, results:[';
    $dias_diferencia = ($fecHasta - $fecDesde)/(60 * 60 * 24); 
    for ($i=0; $i<=$dias_diferencia; $i++)
    {
        $diaSemana = DiaSemana(date('D',$fecDesde +($i*24*60*60)));
        $fechaValida = false;
        switch ($diaSemana)
        {
            case 'Lunes':
                if ($pLunes == "true")
                    $fechaValida = true;
                else
                    $fechaValida = false;
                  break;
            case 'Martes':
                if ($pMartes == "true")
                    $fechaValida = true;
                else
                    $fechaValida = false;
                break;
            case 'Miércoles':
                if ($pMiercoles == "true")
                    $fechaValida = true;
                else
                    $fechaValida = false;
                break;
            case 'Jueves':
                if ($pJueves == "true")
                    $fechaValida = true;
                else
                    $fechaValida = false;
                break;
            case 'Viernes':
                if ($pViernes == "true")
                    $fechaValida = true;
                else
                    $fechaValida = false;
                break;
            case 'Sábado':
                if ($pSabado == "true")
                    $fechaValida = true;
                else
                    $fechaValida = false;
                break;
            case 'Domingo':
                if ($pDomingo == "true")
                    $fechaValida = true;
                else
                    $fechaValida = false;
                break;
            default:
                $fechaValida = false;
                break;
        }
        $buscar = "f" . date('Y-m-d',$fecDesde +($i*24*60*60));
        if (in_array($buscar, $diasNoHabiles)){
            $fechaValida = false;
        }
        if ($fechaValida){
            $res .= '{"FechaAgendar":"' . date('Y-m-d',$fecDesde +($i*24*60*60)) . '","DiaSemana":"' . $diaSemana . '","Seleccionar":"true"},';
        }
    }
    $tmp = substr($res,0,(strlen($res)-1));
    $res = $tmp . ']}';
    echo $res;
}

function Listar_AgendasProgramadas()
{
    $pEmpresa = isset($_REQUEST['pEmpresa'])?$_REQUEST['pEmpresa']:0;
    $pProfesional = isset($_REQUEST['pProfesional'])?$_REQUEST['pProfesional']:0;
    $pIps = isset($_REQUEST['pIps'])?$_REQUEST['pIps']:0;
    $pConsultorio = isset($_REQUEST['pConsultorio'])?$_REQUEST['pConsultorio']:0;
    if (is_null($pConsultorio) || $pConsultorio == "" || $pConsultorio == 0)
        $pFiltroxConsultorio = "n";
    else
        $pFiltroxConsultorio = "s";
    $pDesde = isset($_REQUEST['pDesde'])?$_REQUEST['pDesde']:null;
    $pHasta = isset($_REQUEST['pHasta'])?$_REQUEST['pHasta']:null;
    $gBaseDatos = new ofiMySQLi();
    $gBaseDatos->conectar();
    $qry = "CALL sp_profesionales_agendas_programadas_grid('" . $pEmpresa . "','" . $pProfesional . "','" . $pIps . "',\"" . $pDesde . "\",\"" . $pHasta . "\",\"" . $pFiltroxConsultorio . "\",'" . $pConsultorio . "')";
    //echo $qry;
    $gBaseDatos->QryID = @mysqli_query($gBaseDatos->ConexionID, $qry);
    $arr = array();
    while($row = @mysqli_fetch_assoc($gBaseDatos->QryID))
    {
        $nRow = $row;
        foreach($row as $key => $val)
        {
            $nRow[$key] = PonerAcentosHTML($val);
        }
        $arr[] = $nRow;
    }
    $gBaseDatos->liberar();
    $gBaseDatos->cerrar();
    $jsonresult = JEncode($arr);
    if (!is_null($jsonresult))
        echo '({"total":"0","results":'. $jsonresult .'})';
}

function Listar_ProcedimientosaProgramar()
{
    $gBaseDatos = new ofiMySQLi();
    $gBaseDatos->conectar();
    $pProfesional = isset($_REQUEST['pProfesional'])?$_REQUEST['pProfesional']:0;
    if ($pProfesional == 0){
        $pProfesional = isset($_REQUEST['paramP1'])?$_REQUEST['paramP1']:0;
    }
    $pDescripcion = isset($_REQUEST['query']) ? $_REQUEST['query'] : null;
    if (is_null($pDescripcion) || $pDescripcion == "")
        $pDescripcion = "Todos";
    $qry = "CALL sp_profesionales_programarprocedimientos_grid('" . $pProfesional . "',\"" . $pDescripcion . "\")";
    $gBaseDatos->QryID = @mysqli_query($gBaseDatos->ConexionID, $qry);
    $arr = array();
    while($row = @mysqli_fetch_assoc($gBaseDatos->QryID))
    {
        $nRow = $row;
        foreach($row as $key => $val)
        {
            $nRow[$key] = utf8_decode($val);
        }
        $arr[] = $nRow;
    }
    $gBaseDatos->liberar();
    $gBaseDatos->cerrar();
    $jsonresult = JEncode($arr);
    if (!is_null($jsonresult))
        echo '({"total":"0","results":'. $jsonresult .'})';
}

function Insertar_ProcedimientosaProgramar(){
    $gBaseDatos = new ofiMySQLi();
    $gBaseDatos->conectar();
    $qry = $_REQUEST['qry'];
    $tmp = str_replace("tabla", "pprofesionales_programarprocedimientos", $qry);
    $qry = $tmp;
    $tmp = str_replace("campo1", "idProfesional", $qry);
    $qry = $tmp;
    $tmp = str_replace("campo2", "IdProced", $qry);
    $qry = $tmp;
    $tmp = str_replace("campo3", "Usuario", $qry);
    $qry = $tmp;
    $tmp = str_replace("campo4", "FechaAct", $qry);
    $qry = substr($tmp,0,(strlen($tmp)-1));
    $qry .= ";";
    $newQry =  stripslashes($qry);
    //echo $newQry;
    if(@mysqli_query($gBaseDatos->ConexionID, $newQry))
        echo '1';
    else
       echo '0';
    $gBaseDatos->cerrar();  
}

function Eliminar_ProcedimientosaProgramar()
{
    $pProfesional = isset($_REQUEST['pProfesional'])?$_REQUEST['pProfesional']:0;
    $pProcedimientos = isset($_REQUEST['pProcedimientos'])?$_REQUEST['pProcedimientos']:'0';
    $tmp = str_replace("[", "", $pProcedimientos);
    $pProcedimientos = $tmp;
    $tmp = str_replace("]", "", $pProcedimientos);
    $pProcedimientos = $tmp;
    //$tmp = str_replace("\"", "", $pProcedimientos);
    $tmp = str_replace(",\"\",", ",null,", $pProcedimientos);
    $pProcedimientos = str_replace('"', '', $tmp);
    //$pProcedimientos = $tmp;
    $data = explode(",", $pProcedimientos);
    $control = 0;
    $gBaseDatos = new ofiMySQLi();
    $gBaseDatos->conectar();
    for ($i = 0; ($i < count($data)); $i++) {
        $qry = "CALL sp_profesionales_programarprocedimientos_delete('" . $pProfesional . "','" . $data[$i] . "')";
        //echo $qry;
        if(@mysqli_query($gBaseDatos->ConexionID, $qry))
            $control = '1';
        else
            $control = '3';
    }
    $gBaseDatos->cerrar();
    echo $control;
}

function Insertar_HorarioPlantillaCitas(){
    //$estructura = explode("¬", $_REQUEST['CAMPOS']);
    $gBaseDatos = new ofiMySQLi();
    $gBaseDatos->conectar();
    //$qry = "CALL sp_profesionales_plantillacitas_horario_insert(" . spParametros($estructura,"SI") . ")";
    $qry = $_REQUEST['qry'];
    
    $tmp = str_replace("tabla", "pprestatario_profesionales_plantillacitas_horario", $qry);
    $qry = $tmp;
    $tmp = str_replace("campo1", "idPlantilla", $qry);
    $qry = $tmp;
    $tmp = str_replace("campo2", "idTipoHorario", $qry);
    $qry = $tmp;
    $tmp = str_replace("campo3", "GrupoPrioritario", $qry);
    $qry = $tmp;
    $tmp = str_replace("campo4", "AsignarWeb", $qry);
    $qry = $tmp;
    $tmp = str_replace("campo5", "InfoAddCita", $qry);
    $qry = $tmp;
    $tmp = str_replace("campo6", "Usuario", $qry);
    $qry = $tmp;
    $tmp = str_replace("campo7", "FechaAct", $qry);
    $qry = substr($tmp,0,(strlen($tmp)-1));
    $qry .= ";";
    $newQry =  stripslashes($qry);
    if(@mysqli_query($gBaseDatos->ConexionID, $newQry))
        echo '1';
    else
       echo '0';
    $gBaseDatos->cerrar();
}

function Insertar_PlantillaCitas(){
    $estructura = explode("¬", $_REQUEST['CAMPOS']);
    $gBaseDatos = new ofiMySQLi();
    $gBaseDatos->conectar();
    $qry = "CALL sp_profesionales_plantillacitas_insert(" . spParametros($estructura,"SI") . ")";
    //echo $qry;
    if(@mysqli_query($gBaseDatos->ConexionID, $qry))
        echo "{success: true, requestedId:'1'}";
    else
       echo "{success: true, requestedId:'0'}";
    $gBaseDatos->cerrar();
}

function Eliminar_HorarioPlantillaCitas()
{
    $pPlantilla = isset($_REQUEST['pPlantilla'])?$_REQUEST['pPlantilla']:0;
    $pHorario = isset($_REQUEST['pHorarios'])?$_REQUEST['pHorarios']:'0';
    $tmp = str_replace("[", "", $pHorario);
    $pHorario = $tmp;
    $tmp = str_replace("]", "", $pHorario);
    $pHorario = $tmp;
    $tmp = str_replace("\"", "", $pHorario);
    $pHorario = $tmp;
    $data = explode(",", $pHorario);
    $control = 0;
    $gBaseDatos = new ofiMySQLi();
    $gBaseDatos->conectar();
    for ($i = 0; ($i < count($data)); $i++) {
        $qry = "CALL sp_profesionales_plantillacitas_horario_delete('" . $pPlantilla . "','" . $data[$i] . "')";
        $newQry =  stripslashes($qry);
        if(@mysqli_query($gBaseDatos->ConexionID, $newQry))
            $control = '1';
        else
            $control = '3';
    }
    $gBaseDatos->cerrar();
    echo $control;
}

function Eliminar_PlantillaCitas()
{
    $pPlantilla = isset($_REQUEST['pPlantilla'])?$_REQUEST['pPlantilla']:0;
    $gBaseDatos = new ofiMySQLi();
    $gBaseDatos->conectar();
    $qry = "CALL sp_profesionales_plantillacitas_delete('" . $pPlantilla . "')";
    if(@mysqli_query($gBaseDatos->ConexionID, $qry))
        echo '1';
    else
        echo '0';
    $gBaseDatos->cerrar();
}

function Insertar()
{
    $estructura = explode("¬", $_REQUEST['CAMPOS']);
    $gBaseDatos = new ofiMySQLi();
    $gBaseDatos->conectar();
    $qry = "CALL sp_profesionales2013_insert(" . spParametros($estructura,"SI") . ")";
    //echo $qry;
    if(@mysqli_query($gBaseDatos->ConexionID, $qry))
        echo "{success: true, requestedId:'1'}";
    else
       echo "{success: true, requestedId:'0'}";
    $gBaseDatos->cerrar();
}

function Modificar()
{
    $estructura = explode("¬", $_REQUEST['CAMPOS']);
    $gBaseDatos = new ofiMySQLi();
    $gBaseDatos->conectar();
    $qry = "CALL sp_profesionales2013_update(" . spParametros($estructura,"SI") . ")";
    //echo $qry;
    if(@mysqli_query($gBaseDatos->ConexionID, $qry))
        echo "{success: true, requestedId:'1'}";
    else
       echo "{success: true, requestedId:'0'}";
    $gBaseDatos->cerrar();
}

function Eliminar()
{
    $pidProfesional = isset($_REQUEST['pidProfesional'])?$_REQUEST['pidProfesional']:0;
    $gBaseDatos = new ofiMySQLi();
    $gBaseDatos->conectar();
    $qry = "CALL sp_profesionales_delete('" . $pidProfesional . "')";
    if(@mysqli_query($gBaseDatos->ConexionID, $qry))
        echo '1';
    else
        echo '0';
    $gBaseDatos->cerrar();
}

function Listar_PlantillaCitas()
{
    $pEmpresa = isset($_REQUEST['pEmpresa'])?$_REQUEST['pEmpresa']:0;
    $pProfesional = isset($_REQUEST['pProfesional'])?$_REQUEST['pProfesional']:0;
    $gBaseDatos = new ofiMySQLi();
    $gBaseDatos->conectar();
    $qry = "CALL sp_profesionales_plantillacitas_grid('" . $pEmpresa . "','" . $pProfesional . "')";
    $gBaseDatos->QryID = @mysqli_query($gBaseDatos->ConexionID, $qry);
    $arr = array();
    while($row = @mysqli_fetch_assoc($gBaseDatos->QryID))
    {
        $nRow = $row;
        foreach($row as $key => $val)
        {
            $nRow[$key] = PonerAcentosHTML($val);
        }
        $arr[] = $nRow;
    }
    $gBaseDatos->liberar();
    $gBaseDatos->cerrar();
    $jsonresult = JEncode($arr);
    if (!is_null($jsonresult))
        echo '({"total":"0","results":'. $jsonresult .'})';
}

function Listar_PlantillaProced()
{
    $pEmpresa = isset($_REQUEST['pEmpresa'])?$_REQUEST['pEmpresa']:0;
    $pProfesional = isset($_REQUEST['pProfesional'])?$_REQUEST['pProfesional']:0;
    $gBaseDatos = new ofiMySQLi();
    $gBaseDatos->conectar();
    $qry = "CALL sp_profesionales_plantillaproced_grid('" . $pEmpresa . "','" . $pProfesional . "')";
    $gBaseDatos->QryID = @mysqli_query($gBaseDatos->ConexionID, $qry);
    $arr = array();
    while($row = @mysqli_fetch_assoc($gBaseDatos->QryID))
    {
        $nRow = $row;
        foreach($row as $key => $val)
        {
            $nRow[$key] = PonerAcentosHTML($val);
        }
        $arr[] = $nRow;
    }
    $gBaseDatos->liberar();
    $gBaseDatos->cerrar();
    $jsonresult = JEncode($arr);
    if (!is_null($jsonresult))
        echo '({"total":"0","results":'. $jsonresult .'})';
}

function Listar_PlantillaCitasHorario()
{
    $pEmpresa = isset($_REQUEST['pEmpresa'])?$_REQUEST['pEmpresa']:0;
    $pPlantilla = isset($_REQUEST['pPlantilla'])?$_REQUEST['pPlantilla']:0;
    $gBaseDatos = new ofiMySQLi();
    $gBaseDatos->conectar();
    $qry = "CALL sp_profesionales_plantillacitas_horario_grid('" . $pEmpresa . "','" . $pPlantilla . "')";
    $gBaseDatos->QryID = @mysqli_query($gBaseDatos->ConexionID, $qry);
    $arr = array();
    while($row = @mysqli_fetch_assoc($gBaseDatos->QryID))
    {
        $nRow = $row;
        foreach($row as $key => $val)
        {
            $nRow[$key] = PonerAcentosHTML($val);
        }
        $arr[] = $nRow;
    }
    $gBaseDatos->liberar();
    $gBaseDatos->cerrar();
    $jsonresult = JEncode($arr);
    if (!is_null($jsonresult))
        echo '({"total":"0","results":'. $jsonresult .'})';
}

function Listar_SedeIPS()
{
    $pEmpresa = isset($_REQUEST['pEmpresa'])?$_REQUEST['pEmpresa']:0;
    $pProfesional = isset($_REQUEST['pProfesional'])?$_REQUEST['pProfesional']:0;
    $gBaseDatos = new ofiMySQLi();
    $gBaseDatos->conectar();
    $qry = "CALL sp_profesionales_sedeips_grid('" . $pEmpresa . "','" . $pProfesional . "')";
    $gBaseDatos->QryID = @mysqli_query($gBaseDatos->ConexionID, $qry);
    $arr = array();
    while($row = @mysqli_fetch_assoc($gBaseDatos->QryID))
    {
        $nRow = $row;
        foreach($row as $key => $val)
        {
            $nRow[$key] = PonerAcentosHTML($val);
        }
        $arr[] = $nRow;
    }
    $gBaseDatos->liberar();
    $gBaseDatos->cerrar();
    $jsonresult = JEncode($arr);
    if (!is_null($jsonresult))
        echo '({"total":"0","results":'. $jsonresult .'})';
}

function Asociar_SedeIPS()
{
    $estructura = explode("¬", $_REQUEST['CAMPOS']);
    $gBaseDatos = new ofiMySQLi();
    $gBaseDatos->conectar();
    $qry = "CALL sp_profesionales_sedeips_asociar(" . spParametros($estructura,"SI") . ")";
    //echo $qry;
    if(@mysqli_query($gBaseDatos->ConexionID, $qry))
        echo "{success: true, requestedId:'1'}";
    else
       echo "{success: true, requestedId:'0'}";
    $gBaseDatos->cerrar();
}

function Eliminar_SedeIPS()
{
    $pProfesional = isset($_REQUEST['pProfesional'])?$_REQUEST['pProfesional']:0;
    $pIPS = isset($_REQUEST['pIPS'])?$_REQUEST['pIPS']:0;
    $gBaseDatos = new ofiMySQLi();
    $gBaseDatos->conectar();
    $qry = "CALL sp_profesionales_sedeips_delete('" . $pProfesional . "','" . $pIPS . "')";
    if(@mysqli_query($gBaseDatos->ConexionID, $qry))
        echo '1';
    else
        echo '0';
    $gBaseDatos->cerrar();
}

function Listar()
{
    // OR = ||
    $gBaseDatos = new ofiMySQLi();
    $gBaseDatos->conectar();
    $pEmpresa = isset($_REQUEST['pEmpresa'])?$_REQUEST['pEmpresa']:0;
    $Descripcion = isset($_REQUEST['query']) ? $_REQUEST['query'] : null;
    $Documento = isset($_REQUEST['pDocumento']) ? $_REQUEST['pDocumento'] : 0;
    $Especialidad = isset($_REQUEST['pEspecialidad']) ? $_REQUEST['pEspecialidad'] :"Todos";
    $Tipo = isset($_REQUEST['pTipo']) ? $_REQUEST['pTipo'] :"0";
    if (is_null($Descripcion) || $Descripcion == "")
        $Descripcion = "Todos";
    $qry = "CALL sp_profesionales_grid('" . $Documento . "',\"" . $Descripcion . "\",\"" . $Especialidad . "\",'" . $Tipo . "')";
    //echo $qry;
    $gBaseDatos->QryID = @mysqli_query($gBaseDatos->ConexionID, $qry);
    $nbrows = $gBaseDatos->nroRegistros();
    $gBaseDatos->liberar();
    $gBaseDatos->cerrar();
    if($nbrows>0){
        $gBaseDatos->conectar();
        $start = (integer) (isset($_POST['start']) ? $_POST['start'] : $_GET['start']);
        $end = (integer) (isset($_POST['limit']) ? $_POST['limit'] : $_GET['limit']);
        $qry = "CALL sp_profesionales_grid2013_limit('" . $Documento . "',\"" . $Descripcion . "\",\"" . $Especialidad . "\",'" . $Tipo . "','" . $start . "','" . $end . "')";
        $gBaseDatos->QryID = @mysqli_query($gBaseDatos->ConexionID, $qry);
        while($row = @mysqli_fetch_assoc($gBaseDatos->QryID))
        {
            $nRow = $row;
            foreach($row as $key => $val)
            {
                $nRow[$key] = PonerAcentosHTML($val);
            }
            $arr[] = $nRow;
        }
        $jsonresult = JEncode($arr);
        $gBaseDatos->liberar();
        $gBaseDatos->cerrar();
        echo '({success: true, requestedId:"1", "total":"'.$nbrows.'","results":'.$jsonresult.'})';
    } else {
        echo '({success: true, requestedId:"1", "total":"0", "results":""})';
    }
    $gBaseDatos->liberar();
    $gBaseDatos->cerrar();
}

?>
