<?php
/*
* @category    Controlador Paquete Servicios
* @package     OfiClinic Web
* @author      Jorge Ancizar Galeano Ruiz<desarrollo@ofisalud.com>
* @copyright   2010 Jorge Ancizar Galeano Ruiz
* @version     OfiClinic Web 1.0
* @license     COMERCIAL
* @link        http://www.ofisalud.com
* @country     Colombia
* @telephone   3016398114
*/
header("Content-Type: text/plain; charset=utf-8");
require("../../../core/php/_database.php");
require("../../../core/php/php_functions.php");

$task = '';
if ( isset($_POST['task'])){
  $task = $_POST['task'];
}
switch($task){
    case "LISTAR":
        Listar();
        break;
    case "LISTAR_CONCEPTOSxMANUAL":
        ListarxConceptos();
        break;
    case "LISTAR_CONCEPTOSxPAQUETE":
        ListarxConceptosxPaquete();
        break;
    case "INSERTAR":
        Insertar();
        break;
    case "MODIFICAR":
        Modificar();
        break;
    case "ASOCIAR_CONCEPTO":
        AsociarConcepto();
        break;
    case "DESASOCIAR_CONCEPTO":
        DesasociarConcepto();
        break;
    default:
        break;
}

function DesasociarConcepto(){
    $pManual = isset($_REQUEST['pManual'])?$_REQUEST['pManual']:0;
    $pConcepto = isset($_REQUEST['pConcepto'])?$_REQUEST['pConcepto']:0;
    $gBaseDatos = new ofiMySQLi();
    $gBaseDatos->conectar();
    $qry = "CALL sp_paqueteservicio_eliminarconcepto('" . $pManual . "','" . $pConcepto . "')";
    if(@mysqli_query($gBaseDatos->ConexionID, $qry))
        echo '1';
    else
        echo '0';
    $gBaseDatos->cerrar();
}

function AsociarConcepto()
{
    $estructura = explode("¬", $_REQUEST['CAMPOS']);
    $gBaseDatos = new ofiMySQLi();
    $gBaseDatos->conectar();
    $qry = "CALL sp_paqueteservicio_asociarconcepto(" . spParametros($estructura,"SI") . ")";
    if(@mysqli_query($gBaseDatos->ConexionID, $qry))
        echo "{success: true, requestedId:'1'}";
    else
       echo "{success: true, requestedId:'0'}";
    $gBaseDatos->cerrar();
}

function Modificar()
{
    $estructura = explode("¬", $_REQUEST['CAMPOS']);
    $gBaseDatos = new ofiMySQLi();
    $gBaseDatos->conectar();
    $qry = "CALL sp_paqueteservicio_update(" . spParametros($estructura,"SI") . ")";
    if(@mysqli_query($gBaseDatos->ConexionID, $qry))
        echo "{success: true, requestedId:'1'}";
    else
       echo "{success: true, requestedId:'0'}";
    $gBaseDatos->cerrar();
}

function Insertar()
{
    $estructura = explode("¬", $_REQUEST['CAMPOS']);
    $qry = "CALL sp_paqueteservicio_insert(" . spParametros($estructura,"SI") . ")";
    //echo $qry;
    $gBaseDatos = new ofiMySQLi();
    $gBaseDatos->conectar();
    if(@mysqli_query($gBaseDatos->ConexionID, $qry))
        echo "{success: true, requestedId:'1'}";
    else
       echo "{success: true, requestedId:'0'}";
    $gBaseDatos->cerrar();
}

function ListarxConceptosxPaquete(){
    $pPaquete = isset($_REQUEST['pPaquete'])?$_REQUEST['pPaquete']:0;
    $gBaseDatos = new ofiMySQLi();
    $gBaseDatos->conectar();
    $qry = "CALL sp_asistencial_partisalud_selectconceptosxpaquete('" . $pPaquete . "')";
    $gBaseDatos->QryID = @mysqli_query($gBaseDatos->ConexionID, $qry);
    $arr = array();
    while($row = @mysqli_fetch_assoc($gBaseDatos->QryID))
    {
        $nRow = $row;
        foreach($row as $key => $val)
        {
            $nRow[$key] = PonerAcentosHTML($val);
        }
        $arr[] = $nRow;
    }
    $gBaseDatos->liberar();
    $gBaseDatos->cerrar();
    $jsonresult = JEncode($arr);
    if (!is_null($jsonresult))
        echo '({"total":"0","results":'. $jsonresult .'})';    
}

function ListarxConceptos(){
    // OR = ||
    $gBaseDatos = new ofiMySQLi();
    $gBaseDatos->conectar();
    $pManual = isset($_REQUEST['pManual'])?$_REQUEST['pManual']:0;
    $pDescripcion = isset($_REQUEST['query']) ? $_REQUEST['query'] : null;
    if (is_null($pDescripcion) || $pDescripcion == "")
        $pDescripcion = "Todos";
    $qry = "CALL sp_paqueteservicio_listar_conceptos('" . $pManual . "',\"" . $pDescripcion . "\")";
    $CampoLlave = explode("^",$gBaseDatos->jasonSP_arreglo2011($qry));
    $nbrows = $CampoLlave[0];
    $gBaseDatos->liberar();
    $gBaseDatos->cerrar();
    if($nbrows>0){
        $start = (integer) (isset($_POST['start']) ? $_POST['start'] : $_GET['start']);
        $end = (integer) (isset($_POST['limit']) ? $_POST['limit'] : $_GET['limit']);
        $qry = "CALL sp_paqueteservicio_listar_conceptos_limit('" . $pManual . "',\"" . $pDescripcion . "\",'" . $start . "','" . $end . "')";
        //echo $qry;
        $gBaseDatos = new ofiMySQLi();
        $gBaseDatos->conectar();
        $gBaseDatos->QryID = @mysqli_query($gBaseDatos->ConexionID, $qry);
        while($row = @mysqli_fetch_assoc($gBaseDatos->QryID))
        {
            $nRow = $row;
            foreach($row as $key => $val)
            {
                $nRow[$key] = PonerAcentosHTML($val);
            }
            $arr[] = $nRow;
        }
        $jsonresult = JEncode($arr);
        $gBaseDatos->liberar();
        $gBaseDatos->cerrar();
        echo '({success: true, requestedId:"1", "total":"'.$nbrows.'","results":'.$jsonresult.'})';
    } else {
        echo '({success: true, requestedId:"1", "total":"0", "results":""})';
    }
    
    
}

function Listar(){
    $pEmpresa = isset($_REQUEST['paramP1'])?$_REQUEST['paramP1']:0;
    $pDescripcion = isset($_REQUEST['query'])?$_REQUEST['query']:null;
    if (is_null($pDescripcion) || $pDescripcion == "")
        $pDescripcion = "Todos";
    $gBaseDatos = new ofiMySQLi();
    $gBaseDatos->conectar();
    $qry = "CALL sp_paqueteservicio_listar(\"" . $pDescripcion . "\")";
    $gBaseDatos->QryID = @mysqli_query($gBaseDatos->ConexionID, $qry);
    $arr = array();
    if($gBaseDatos->QryID)
    {
        while($row = @mysqli_fetch_assoc($gBaseDatos->QryID))
        {
            $nRow = $row;
            foreach($row as $key => $val)
            {
                $nRow[$key] = PonerAcentosHTML($val);
            }
            $arr[] = $nRow;
        }
        $jsonresult = JEncode($arr);
        $gBaseDatos->liberar();
        $gBaseDatos->cerrar();
        echo '({success: true, requestedId:"1", "total":"1","results":'.$jsonresult.'})';
    } else {
        $gBaseDatos->liberar();
        $gBaseDatos->cerrar();
        echo '({success: false, requestedId:"1", "total":"0", "results":""})';
    }
}

?>
