<?php
ini_set('memory_limit', '-1'); 
set_time_limit(1500);
require_once('../../../../lib/tcpdf/config/lang/spa.php');
require_once('../../../../lib/tcpdf/tcpdf.php');
require_once('drawchart.php');
require("../../../../core/php/_database.php");
require("../../../../core/php/php_functions.php");
//header('Content-type: application/pdf; charset: UTF-8');

session_start();
$pConsultorioVirtual = $_SESSION['IDBD'];
$nomEmpresa = $_SESSION['NOM_EMPRESA'];
$nomUsuario = $_SESSION['NOM_USUARIO'];
#20,1,102,0,0,1,"2013-10-01","2013-10-31"

$estructura = explode("¬", $_REQUEST['param']);
$pNomParametros = spNomParametrosMI($estructura,"NO");
$NameParam = explode("¬", $pNomParametros);
$pParametros = spParametrosMI($estructura,"NO");
$DataParam = explode("¬", $pParametros);

$items = count($NameParam);
for ($i=0; $i<$items; $i++)
{
    switch ($NameParam[$i]) 
    {
        case "intEmpresa":
            if ($DataParam[$i] == "" || $DataParam[$i] == null || $DataParam[$i] == "null")
                $pEmpresa = 0;
            else
                $pEmpresa = $DataParam[$i];
            break;

        case "intIPS":
            if ($DataParam[$i] == "" || $DataParam[$i] == null || $DataParam[$i] == "null")
                $pIPS = 0;
            else
                $pIPS = $DataParam[$i];
            break;

        case "intCliente":
            if ($DataParam[$i] == "" || $DataParam[$i] == null || $DataParam[$i] == "null")
                $pCliente = 0;
            else
                $pCliente = $DataParam[$i];
            break;

        case "intPlan":
            if ($DataParam[$i] == "" || $DataParam[$i] == null || $DataParam[$i] == "null")
                $pPlan = 0;
            else
                $pPlan = $DataParam[$i];
            break;

        case "intSubPlan":
            if ($DataParam[$i] == "" || $DataParam[$i] == null || $DataParam[$i] == "null")
                $pSubPlan = 0;
            else
                $pSubPlan = $DataParam[$i];
            break;

        case "fecDesde":
            if ($DataParam[$i] == "" || $DataParam[$i] == null || $DataParam[$i] == "null")
            {    
                $pDesde = date('Y-m-d');
            }else{
                $pDesde = $DataParam[$i];
            }
            break;

        case "fecHasta":
            if ($DataParam[$i] == "" || $DataParam[$i] == null || $DataParam[$i] == "null")
            {
                $pHasta = date('Y-m-d');
            }else{
                $pHasta = $DataParam[$i];
            }
            break;

        case "strCampo1":
            if ($DataParam[$i] == "" || $DataParam[$i] == null || $DataParam[$i] == "null")
            {
                $pCampo1 = 'NO';
            }else{
                $pCampo1 = $DataParam[$i];
            }
            break;

        case "strCampo2":
            if ($DataParam[$i] == "" || $DataParam[$i] == null || $DataParam[$i] == "null")
            {
                $pCampo2 = 'NO';
            }else{
                $pCampo2 = $DataParam[$i];
            }
            break;

        case "strCampo3":
            if ($DataParam[$i] == "" || $DataParam[$i] == null || $DataParam[$i] == "null")
            {
                $pCampo3 = 'NO';
            }else{
                $pCampo3 = $DataParam[$i];
            }
            break;

        case "intProfesional":
            if ($DataParam[$i] == "" || $DataParam[$i] == null || $DataParam[$i] == "null")
            {
                $pProfesional = 0;
            }else{
                $pProfesional = $DataParam[$i];
            }
            break;

        case "intContrato":
            if ($DataParam[$i] == "" || $DataParam[$i] == null || $DataParam[$i] == "null")
            {
                $pContrato = 0;
            }else{
                $pContrato = $DataParam[$i];
            }
            break;

        case "strPaciente":
            if ($DataParam[$i] == "" || $DataParam[$i] == null || $DataParam[$i] == "null")
            {
                $pPaciente = 'Todos';
            }else{
                $pPaciente = $DataParam[$i];
            }
            break;

        case "strAutorizacion":
            if ($DataParam[$i] == "" || $DataParam[$i] == null || $DataParam[$i] == "null")
            {
                $pAutorizacion = 'Todos';
            }else{
                $pAutorizacion = $DataParam[$i];
            }
            break;
            
        case "strPlantillaHC":
            if ($DataParam[$i] == "" || $DataParam[$i] == null || $DataParam[$i] == "null")
            {
                $pPlantilla = 'Todos';
            }else{
                $pPlantilla = $DataParam[$i];
            }
            break;
            
        default:
            break;
    }
}
        
//Definicion de las Margenes
$LeftMargin = PDF_MARGIN_LEFT;
$TopMargin = 5;
$RightMargin = PDF_MARGIN_RIGHT;
$HeaderMargin = PDF_MARGIN_HEADER;
$BottomMargin = 3;
$FooterMargin = 5;
$Alineacion = "P";
$FormatoPagina = "CARTA";
$UsaPiePagina = "SI";
$pTipoEncabezado = "FVP";
$pControlSalto = 20;
$styleBarCode = array(
    'position' => 'R',
    'align' => 'R',
    'stretch' => false,
    'fitwidth' => true,
    'cellfitalign' => 'R',
    'border' => true,
    'hpadding' => 'auto',
    'vpadding' => 'auto',
    'fgcolor' => array(0,0,0),
    'bgcolor' => false, //array(255,255,255),
    'text' => true,
    'font' => 'helvetica',
    'fontsize' => 7,
    'stretchtext' => 4
);
//Inicializacion de la Clase
$pdf = new TCPDF($Alineacion, PDF_UNIT, $FormatoPagina, true, 'UTF-8', false);
//Inicializacion Variables de Control
$pdf->pAlineacionEncabezado = $Alineacion;
$pdf->pTituloInforme = "AUDIOMETRIA";
$pdf->pImprimeLogo = "NO";
$pdf->pAnchoTxtPagina = 210;
$pdf->pNomEmpresa = $_SESSION['NOM_EMPRESA'];
$pdf->pTDocEmpresa = $_SESSION['EMPRESA_TDOC'];
$pdf->pDocEmpresa = $_SESSION['EMPRESA_DOC'];
$pdf->pDirEmpresa = $_SESSION['EMPRESA_DIR'];
$pdf->pTelEmpresa = $_SESSION['EMPRESA_TEL'];
$pdf->pCiuEmpresa = $_SESSION['EMPRESA_CIU'];
$pdf->pEspEmpresa = $_SESSION['EMPRESA_ESP'];
$pdf->pRegEmpresa = $_SESSION['EMPRESA_REGIMEN'];
$pdf->pContribuyentes = $_SESSION['EMPRESA_CONTRIBUYENTE'];
$pdf->pReteIVA  = $_SESSION['EMPRESA_RTEICA'];
$pdf->pReteICA = $_SESSION['EMPRESA_RTEIVA'];

$pdf->pTipoEncabezado = $pTipoEncabezado;
$pdf->pNomSede = $_SESSION['EMPRESA_DOC'];
$pdf->pNomIPS = $_SESSION['NOM_IPS'];
$pdf->pMargenPie = -20;
$pdf->pLogoCliente = "../../../empresas/" . $_SESSION['I_EMPRESA'] . "/logo/logoenc.gif";
$pdf->pPrefijo = 1; //$row[0]["Prefijo"];
$pdf->pNroDocumento = 1; //str_pad($row[0]["NroDocumento"], 7, "0", STR_PAD_LEFT);
$pdf->pNroResolucion = 1; //$row[0]["NroResolucion"];
$pdf->pFechaDoc = 1; //$row[0]["FechaDocumento"];
$pdf->pCAS = null;
$pdf->pTratamiento = null;
$pdf->pUsaPie = $UsaPiePagina;

$pdf->SetCreator(PDF_CREATOR);
$pdf->SetAuthor('Sistemas Ofisalud © - 2011');
$pdf->SetTitle('OfiClinic©');
$pdf->SetSubject('Informe Final Salud Ocupacional');

$pdf->SetHeaderData($pdf->pLogoCliente, PDF_HEADER_LOGO_WIDTH, $pdf->pTituloInforme, PDF_HEADER_STRING);
$pdf->setHeaderFont(Array(PDF_FONT_NAME_MAIN, '', PDF_FONT_SIZE_MAIN));
$pdf->setFooterFont(Array(PDF_FONT_NAME_DATA, '', PDF_FONT_SIZE_DATA));
$pdf->SetDefaultMonospacedFont(PDF_FONT_MONOSPACED);
$pdf->SetMargins($LeftMargin, $TopMargin, $RightMargin);
$pdf->SetHeaderMargin($HeaderMargin);
$pdf->SetFooterMargin($FooterMargin);
// set bacground image

$pdf->SetAutoPageBreak(TRUE, $BottomMargin);
$pdf->setImageScale(PDF_IMAGE_SCALE_RATIO);
$pdf->setLanguageArray($l);
$pdf->setFontSubsetting(true);
$pdf->SetFont('dejavusans', '', 14, '', true);
EncabezadoPagina($pdf);
$mostrarHC = '<span style="font-size:34px; color:#000;"><b>3. RESULTADOS</b></span><br>';
$pdf->writeHTML($mostrarHC, true, false, false, false, '');
if ($pdf->GetY() >= ($pdf->getPageHeight()-$pControlSalto)){
    EncabezadoPagina($pdf);
}
$mostrarHC = '<span style="font-size:29px; color:#000; text-align:justify;">A continucación se presentan las tablas y gráficos de cada una de las variables analizadas.</span><br>';
$pdf->writeHTML($mostrarHC, true, false, false, false, '');
if ($pdf->GetY() >= ($pdf->getPageHeight()-$pControlSalto)){
    EncabezadoPagina($pdf);
}
unset($row);
$gBaseDatos = new ofiMySQLi();
$gBaseDatos->conectar();
$qry = "CALL sp_macroinformes_saludocupa002_infgen001('" . $pEmpresa . "','" . $pIPS . "','" . $pCliente . "','" . $pPlan . "','" . $pSubPlan . "','" . $pContrato . "',\"" . $pDesde . "\",\"" . $pHasta . "\")";
//echo $qry;
$gBaseDatos->QryID = @mysqli_query($gBaseDatos->ConexionID, $qry);
while ($row[] = @mysqli_fetch_assoc($gBaseDatos->QryID));
$gBaseDatos->liberar();
$gBaseDatos->cerrar();
$pRegistros = count($row);
$mostrarHC = "<br><br>";
$totalPersonas = $row[0]["Masculino"] + $row[0]["Femenino"];
if($totalPersonas == 0){
    $totalPersonas = 1;
}
$mostrarHC .= '<span style="font-size:33px; color:#000;"><b>3.1 DISTRIBUCION PORCENTUAL SEGUN GENERO</b></span><br><br>';
$mostrarHC .= '<span style="font-size:29px; color:#000;">El ' . round(number_format(($row[0]["Masculino"]/$totalPersonas)*100,2,".",",")) . '% de la población evaluada corresponde a género masculino, mientras que un ' . round(number_format(($row[0]["Femenino"]/$totalPersonas)*100,2,".",",")) . '% corresponde a género femenino.</span><br>';
$pdf->writeHTML($mostrarHC, true, false, false, false, '');
if ($pdf->GetY() >= ($pdf->getPageHeight()-$pControlSalto)){
    EncabezadoPagina($pdf);
}
//Graficar TABLA Y GRAFICA 1. DISTRIBUCION PORCENTUAL SEGUN GENERO
Draw001Genero($row);
$mostrarHC = '<center><table width="700" border="0" cellpadding="5">';
$mostrarHC .= '<tr>';
$mostrarHC .= '<td colspan="3" align="center"><span style="font-size:29px; color:#000;">TABLA Y GRAFICO 1. DISTRIBUCION PORCENTUAL SEGUN GENERO</span></td>';
$mostrarHC .= '</tr>';
$mostrarHC .= '<tr>';
$mostrarHC .= '<td width="3"></td>';
$mostrarHC .= '<td width="300">';
$mostrarHC .= '<table cellpadding="5" border="1">';
$mostrarHC .= '<tr style="background-color:#F2F2F2;" align="center">';
$mostrarHC .= '<td><b>GENERO</b></td>';
$mostrarHC .= '<td><b>Nro PERSONAS</b></td>';
$mostrarHC .= '<td><b>%</b></td>';
$mostrarHC .= '</tr>';
$mostrarHC .= '<tr>';
$mostrarHC .= '<td>MASCULINO</td>';
$mostrarHC .= '<td align="center">' . $row[0]["Masculino"] .'</td>';
$mostrarHC .= '<td align="center">' . round(number_format(($row[0]["Masculino"]/$totalPersonas)*100,2,".",",")) . '</td>';
$mostrarHC .= '</tr>';
$mostrarHC .= '<tr>';
$mostrarHC .= '<td>FEMENINO</td>';
$mostrarHC .= '<td align="center">' . $row[0]["Femenino"] .'</td>';
$mostrarHC .= '<td align="center">' . round(number_format(($row[0]["Femenino"]/$totalPersonas)*100,2,".",",")) . '</td>';
$mostrarHC .= '</tr>';
$mostrarHC .= '<tr>';
$mostrarHC .= '<td>TOTAL</td>';
$mostrarHC .= '<td align="center">' . round(number_format(($row[0]["Masculino"]+$row[0]["Femenino"]),2,".",",")) .'</td>';
$mostrarHC .= '<td align="center">100</td>';
$mostrarHC .= '</tr>';
$mostrarHC .= '</table>';
$mostrarHC .= '</td>';
$mostrarHC .= '<td width="350" align="center">';
$mostrarHC .= '<img src="chart001.png" width="230" height="100"/>';
$mostrarHC .= '</td>';
$mostrarHC .= '</tr>';
$mostrarHC .= '</table></center>';
$pdf->writeHTML($mostrarHC, true, false, false, false, '');
if ($pdf->GetY() >= ($pdf->getPageHeight()-$pControlSalto)){
    EncabezadoPagina($pdf);
}
///////////////////////////////////////////////////////////////////
unset($row);
unset($arrData);
unset($arrLabels);
unset($arrMin);
unset($arrMax);
$gBaseDatos = new ofiMySQLi();
$gBaseDatos->conectar();
$qry = "CALL sp_macroinformes_saludocupa002_infgen002('" . $pEmpresa . "','" . $pIPS . "','" . $pCliente . "','" . $pPlan . "','" . $pSubPlan . "','" . $pContrato . "',\"" . $pDesde . "\",\"" . $pHasta . "\")";
//echo $qry;
$gBaseDatos->QryID = @mysqli_query($gBaseDatos->ConexionID, $qry);
while ($row[] = @mysqli_fetch_assoc($gBaseDatos->QryID));
$gBaseDatos->liberar();
$gBaseDatos->cerrar();
$pRegistros = count($row);
$totalPac = 0;
for($i=0;$i<$pRegistros;$i++){
    if($row[$i]["RangoEdad"] != null && $row[$i]["RangoEdad"] != ""){
        $arrData[] = $row[$i]["Resgistros"];
        $arrLabels[] = $row[$i]["RangoEdad"];
        $arrMin[] = $row[$i]["MinEdad"];
        $arrMax[] = $row[$i]["MaxEdad"];
        $totalPac += $row[$i]["Resgistros"];
    }
}
if($totalPac == 0){
    $totalPac = 1;
}
$mostrarHC = "<br><br>";
$mostrarHC .= '<span style="font-size:33px; color:#000;"><b>3.2 DISTRIBUCION PORCENTUAL SEGUN RANGOS DE EDAD</b></span><br><br>';
$mostrarHC .= '<span style="font-size:29px; color:#000;">La edad mínima es de ' . min($arrMin) . ' y la máxima es de ' . max($arrMax) . '</span><br>';
$pdf->writeHTML($mostrarHC, true, false, false, false, '');
if ($pdf->GetY() >= ($pdf->getPageHeight()-$pControlSalto)){
    EncabezadoPagina($pdf);
}
//Graficar TABLA Y GRAFICA 1. DISTRIBUCION PORCENTUAL SEGUN GENERO
Draw002Edad($arrData,$arrLabels);
$mostrarHC = '<center><table width="700" border="0" cellpadding="5">';
$mostrarHC .= '<tr>';
$mostrarHC .= '<td colspan="3" align="center"><span style="font-size:29px; color:#000;">TABLA Y GRAFICO 2. DISTRIBUCION PORCENTUAL SEGUN RANGOS EDAD</span></td>';
$mostrarHC .= '</tr>';
$mostrarHC .= '<tr>';
$mostrarHC .= '<td width="3"></td>';
$mostrarHC .= '<td width="300">';
$mostrarHC .= '<table cellpadding="5" border="1">';
$mostrarHC .= '<tr style="background-color:#F2F2F2;" align="center">';
$mostrarHC .= '<td><b>EDAD</b></td>';
$mostrarHC .= '<td><b>FRECUENCIA</b></td>';
$mostrarHC .= '<td><b>%</b></td>';
$mostrarHC .= '</tr>';
for($i=0;$i<$pRegistros;$i++){
    if($row[$i]["RangoEdad"] != null && $row[$i]["RangoEdad"] != ""){
        $mostrarHC .= '<tr>';
        $mostrarHC .= '<td>' . $row[$i]["RangoEdad"] . '</td>';
        $mostrarHC .= '<td align="center">' . $row[$i]["Resgistros"] .'</td>';
        $mostrarHC .= '<td align="center">' . round(($row[$i]["Resgistros"]/$totalPac)*100) . '</td>';
        $mostrarHC .= '</tr>';
    }
}
$mostrarHC .= '<tr>';
$mostrarHC .= '<td>TOTAL</td>';
$mostrarHC .= '<td align="center">' . $totalPac .'</td>';
$mostrarHC .= '<td align="center">100</td>';
$mostrarHC .= '</tr>';
$mostrarHC .= '</table>';
$mostrarHC .= '</td>';
$mostrarHC .= '<td width="350" align="center">';
$mostrarHC .= '<img src="chart002.png" width="330" height="120"/>';
$mostrarHC .= '</td>';
$mostrarHC .= '</tr>';
$mostrarHC .= '</table></center>';
$pdf->writeHTML($mostrarHC, true, false, false, false, '');
if ($pdf->GetY() >= ($pdf->getPageHeight()-$pControlSalto)){
    EncabezadoPagina($pdf);
}
unset($row);
unset($arrData);
unset($arrLabels);
unset($arrMin);
unset($arrMax);
///////////////////////////////////////////////////////////////////

unset($row);
unset($arrData);
unset($arrLabels);
unset($arrEstadoCivil);
unset($resEstadoCivil);
unset($arrResultado);
$gBaseDatos = new ofiMySQLi();
$gBaseDatos->conectar();
$qry = "CALL sp_macroinformes_saludocupa002_infgen003('" . $pEmpresa . "','" . $pIPS . "','" . $pCliente . "','" . $pPlan . "','" . $pSubPlan . "','" . $pContrato . "',\"" . $pDesde . "\",\"" . $pHasta . "\")";
//echo $qry;
$gBaseDatos->QryID = @mysqli_query($gBaseDatos->ConexionID, $qry);
while ($row[] = @mysqli_fetch_assoc($gBaseDatos->QryID));
$gBaseDatos->liberar();
$gBaseDatos->cerrar();
$pRegistros = count($row);
$totalPac = 0;
for($i=0;$i<$pRegistros;$i++){
    if($row[$i]["Evolucion"] != null && $row[$i]["Evolucion"] != ""){
        $estructurahc = explode("¬",utf8_decode($row[$i]["Evolucion"]));
        $reg = count($estructurahc)-1;
        for ($j=0; $j<$reg; $j++){
            $contenidohc = explode("^~",$estructurahc[$j]);
            switch($contenidohc[1]){
                case "TRUE":
                    $txtContenido = "SI";
                    break;
                case "true":
                    $txtContenido = "SI";
                    break;

                case "FALSE":
                    $txtContenido = "NO";
                    break;
                case "false":
                    $txtContenido = "NO";
                    break;

                default:
                    $txtContenido = $contenidohc[1];
                    break;
            }
            if(substr($contenidohc[0],0,19) == "str004EstadoCivilSO"){ 
                if($txtContenido != null && $txtContenido != "" && $txtContenido != " "){
                    $arrEstadoCivil[] = PonerAcentosHTML($txtContenido);
                }
            }
        }
    }
}
$resEstadoCivil = array_values(array_unique($arrEstadoCivil));
$pRegistros = count($resEstadoCivil);
$arrResultado = array();
for($i=0;$i<$pRegistros;$i++){
    $arrResultado[$i] = array('EstadoCivil'=>$resEstadoCivil[$i], 'Personas'=>'0');
}
$pRegistros = count($arrResultado);
for($i=0;$i<$pRegistros;$i++){
    $arrResultado[$i]["Personas"] = DevolverElementos($arrEstadoCivil,$arrResultado[$i]["EstadoCivil"]);
    //echo $arrResultado[$i]["EstadoCivil"] . " : " . $arrResultado[$i]["Personas"] . " --- ";
    $arrData[] = $arrResultado[$i]["Personas"];
    $arrLabels[] = $arrResultado[$i]["EstadoCivil"];
    $totalPac += $arrResultado[$i]["Personas"];
}
if($totalPac == 0){
    $totalPac = 1;
}
$mostrarHC = "<br><br>";
$mostrarHC .= '<span style="font-size:33px; color:#000;"><b>3.3 DISTRIBUCION PORCENTUAL SEGUN ESTADO CIVIL</b></span><br><br>';
//$mostrarHC .= '<span style="font-size:29px; color:#000;">La edad mínima es de ' . min($arrMin) . ' y la máxima es de ' . max($arrMax) . '</span><br>';
$pdf->writeHTML($mostrarHC, true, false, false, false, '');
if ($pdf->GetY() >= ($pdf->getPageHeight()-$pControlSalto)){
    EncabezadoPagina($pdf);
}
Draw003General($arrData,$arrLabels,"03");
$mostrarHC = '<center><table width="700" border="0" cellpadding="5">';
$mostrarHC .= '<tr>';
$mostrarHC .= '<td colspan="3" align="center"><span style="font-size:29px; color:#000;">TABLA Y GRAFICO 3. DISTRIBUCION PORCENTUAL SEGUN ESTADO CIVIL</span></td>';
$mostrarHC .= '</tr>';
$mostrarHC .= '<tr>';
$mostrarHC .= '<td width="3"></td>';
$mostrarHC .= '<td width="300">';
$mostrarHC .= '<table cellpadding="5" border="1">';
$mostrarHC .= '<tr style="background-color:#F2F2F2;" align="center">';
$mostrarHC .= '<td><b>ESTADO CIVIL</b></td>';
$mostrarHC .= '<td><b>Nro PERSONAS</b></td>';
$mostrarHC .= '<td><b>%</b></td>';
$mostrarHC .= '</tr>';
for($i=0;$i<$pRegistros;$i++){
    $mostrarHC .= '<tr>';
    $mostrarHC .= '<td>' . $arrResultado[$i]["EstadoCivil"] . '</td>';
    $mostrarHC .= '<td align="center">' . $arrResultado[$i]["Personas"] .'</td>';
    $mostrarHC .= '<td align="center">' . round(($arrResultado[$i]["Personas"]/$totalPac)*100) . '</td>';
    $mostrarHC .= '</tr>';
}
$mostrarHC .= '<tr>';
$mostrarHC .= '<td>TOTAL</td>';
$mostrarHC .= '<td align="center">' . $totalPac .'</td>';
$mostrarHC .= '<td align="center">100</td>';
$mostrarHC .= '</tr>';
$mostrarHC .= '</table>';
$mostrarHC .= '</td>';
$mostrarHC .= '<td width="350" align="center">';
$mostrarHC .= '<img src="chart003.png" width="330" height="120"/>';
$mostrarHC .= '</td>';
$mostrarHC .= '</tr>';
$mostrarHC .= '</table></center>';
$pdf->writeHTML($mostrarHC, true, false, false, false, '');
if ($pdf->GetY() >= ($pdf->getPageHeight()-$pControlSalto)){
    EncabezadoPagina($pdf);
}
unset($row);
unset($arrData);
unset($arrLabels);
unset($arrEstadoCivil);
unset($resEstadoCivil);
unset($arrResultado);
//////////////////////////////////////////////////////////

EncabezadoPagina($pdf);

//////////////////////////////////////////////////////////
unset($row);
unset($arrData);
unset($arrLabels);
unset($arrEscolaridad);
unset($resEscolaridad);
unset($arrResultado);
$gBaseDatos = new ofiMySQLi();
$gBaseDatos->conectar();
$qry = "CALL sp_macroinformes_saludocupa002_infgen003('" . $pEmpresa . "','" . $pIPS . "','" . $pCliente . "','" . $pPlan . "','" . $pSubPlan . "','" . $pContrato . "',\"" . $pDesde . "\",\"" . $pHasta . "\")";
//echo $qry;
$gBaseDatos->QryID = @mysqli_query($gBaseDatos->ConexionID, $qry);
while ($row[] = @mysqli_fetch_assoc($gBaseDatos->QryID));
$gBaseDatos->liberar();
$gBaseDatos->cerrar();
$pRegistros = count($row);
$totalPac = 0;
$totalPorcentaje = 0;
for($i=0;$i<$pRegistros;$i++){
    if($row[$i]["Evolucion"] != null && $row[$i]["Evolucion"] != ""){
        $estructurahc = explode("¬",utf8_decode($row[$i]["Evolucion"]));
        $reg = count($estructurahc)-1;
        for ($j=0; $j<$reg; $j++){
            $contenidohc = explode("^~",$estructurahc[$j]);
            switch($contenidohc[1]){
                case "TRUE":
                    $txtContenido = "SI";
                    break;
                case "true":
                    $txtContenido = "SI";
                    break;

                case "FALSE":
                    $txtContenido = "NO";
                    break;
                case "false":
                    $txtContenido = "NO";
                    break;

                default:
                    $txtContenido = $contenidohc[1];
                    break;
            }
            if(substr($contenidohc[0],0,22) == "str005NivelAcademicoSO"){ 
                if($txtContenido != null && $txtContenido != "" && $txtContenido != " "){
                    $arrEscolaridad[] = $txtContenido;
                }
            }
        }
    }
}
$resEscolaridad = array_values(array_unique($arrEscolaridad));
$pRegistros = count($resEscolaridad);
$arrResultado = array();
for($i=0;$i<$pRegistros;$i++){
    $arrResultado[$i] = array('Escolaridad'=>$resEscolaridad[$i], 'Personas'=>'0');
}
$pRegistros = count($arrResultado);
for($i=0;$i<$pRegistros;$i++){
    $arrResultado[$i]["Personas"] = DevolverElementos($arrEscolaridad,$arrResultado[$i]["Escolaridad"]);
    //echo $arrResultado[$i]["EstadoCivil"] . " : " . $arrResultado[$i]["Personas"] . " --- ";
    $arrData[] = $arrResultado[$i]["Personas"];
    $arrLabels[] = $arrResultado[$i]["Escolaridad"];
    $totalPac += $arrResultado[$i]["Personas"];
}
if($totalPac == 0){
    $totalPac = 1;
}
$mostrarHC = "<br><br>";
$mostrarHC .= '<span style="font-size:33px; color:#000;"><b>3.4 DISTRIBUCION PORCENTUAL SEGUN NIVEL DE ESCOLARIDAD</b></span><br><br>';
//$mostrarHC .= '<span style="font-size:29px; color:#000;">La edad mínima es de ' . min($arrMin) . ' y la máxima es de ' . max($arrMax) . '</span><br>';
$pdf->writeHTML($mostrarHC, true, false, false, false, '');
if ($pdf->GetY() >= ($pdf->getPageHeight()-$pControlSalto)){
    EncabezadoPagina($pdf);
}
Draw004General($arrData,$arrLabels,"04");
$mostrarHC = '<center><table width="700" border="0" cellpadding="5">';
$mostrarHC .= '<tr>';
$mostrarHC .= '<td colspan="3" align="center"><span style="font-size:29px; color:#000;">TABLA Y GRAFICO 4. SEGUN NIVEL DE ESCOLARIDAD</span></td>';
$mostrarHC .= '</tr>';
$mostrarHC .= '<tr>';
$mostrarHC .= '<td width="3"></td>';
$mostrarHC .= '<td width="300">';
$mostrarHC .= '<table cellpadding="5" border="1">';
$mostrarHC .= '<tr style="background-color:#F2F2F2;" align="center">';
$mostrarHC .= '<td><b>ESCOLARIDAD</b></td>';
$mostrarHC .= '<td><b>Nro PERSONAS</b></td>';
$mostrarHC .= '<td><b>%</b></td>';
$mostrarHC .= '</tr>';
for($i=0;$i<$pRegistros;$i++){
    $mostrarHC .= '<tr>';
    $mostrarHC .= '<td>' . $arrResultado[$i]["Escolaridad"] . '<span style="font-size:20px; color:blue"> (' . ($i+1) . ') </span></td>';
    $mostrarHC .= '<td align="center">' . $arrResultado[$i]["Personas"] .'</td>';
    $mostrarHC .= '<td align="center">' . number_format(($arrResultado[$i]["Personas"]/$totalPac)*100,2,".",",") . '</td>';
    $totalPorcentaje += number_format(($arrResultado[$i]["Personas"]/$totalPac)*100,2,".",",");
    $mostrarHC .= '</tr>';
}
$mostrarHC .= '<tr>';
$mostrarHC .= '<td>TOTAL</td>';
$mostrarHC .= '<td align="center">' . $totalPac .'</td>';
$mostrarHC .= '<td align="center">' . round($totalPorcentaje) . '</td>';
$mostrarHC .= '</tr>';
$mostrarHC .= '</table>';
$mostrarHC .= '</td>';
$mostrarHC .= '<td width="450" align="center">';
$mostrarHC .= '<img src="chart004.png" width="410" height="370"/>';
$mostrarHC .= '</td>';
$mostrarHC .= '</tr>';
$mostrarHC .= '</table></center>';
$pdf->writeHTML($mostrarHC, true, false, false, false, '');
if ($pdf->GetY() >= ($pdf->getPageHeight()-$pControlSalto)){
    EncabezadoPagina($pdf);
}
unset($row);
unset($arrData);
unset($arrLabels);
unset($arrEscolaridad);
unset($resEscolaridad);
unset($arrResultado);
//////////////////////////////////////////////////////////

unset($row);
unset($arrData);
unset($arrLabels);
unset($arrEnfProfesional);
unset($resEnfProfesional);
unset($arrResultado);
$gBaseDatos = new ofiMySQLi();
$gBaseDatos->conectar();
$qry = "CALL sp_macroinformes_saludocupa002_infgen003('" . $pEmpresa . "','" . $pIPS . "','" . $pCliente . "','" . $pPlan . "','" . $pSubPlan . "','" . $pContrato . "',\"" . $pDesde . "\",\"" . $pHasta . "\")";
//echo $qry;
$gBaseDatos->QryID = @mysqli_query($gBaseDatos->ConexionID, $qry);
while ($row[] = @mysqli_fetch_assoc($gBaseDatos->QryID));
$gBaseDatos->liberar();
$gBaseDatos->cerrar();
$pRegistros = count($row);
$totalPac = 0;
$totalPorcentaje = 0;
for($i=0;$i<$pRegistros;$i++){
    if($row[$i]["Evolucion"] != null && $row[$i]["Evolucion"] != ""){
        $estructurahc = explode("¬",utf8_decode($row[$i]["Evolucion"]));
        $reg = count($estructurahc)-1;
        for ($j=0; $j<$reg; $j++){
            $contenidohc = explode("^~",$estructurahc[$j]);
            switch($contenidohc[1]){
                case "TRUE":
                    $txtContenido = "SI";
                    break;
                case "true":
                    $txtContenido = "SI";
                    break;

                case "FALSE":
                    $txtContenido = "NO";
                    break;
                case "false":
                    $txtContenido = "NO";
                    break;

                default:
                    $txtContenido = $contenidohc[1];
                    break;
            }
            if(substr($contenidohc[0],0,28) == "str251SufrioEnfProfesionalSO"){ 
                if($txtContenido != null && $txtContenido != "" && $txtContenido != " "){
                    $arrEnfProfesional[] = $txtContenido;
                }
            }
        }
    }
}
$resEnfProfesional = array_values(array_unique($arrEnfProfesional));
$pRegistros = count($resEnfProfesional);
$arrResultado = array();
for($i=0;$i<$pRegistros;$i++){
    $arrResultado[$i] = array('EnfProfesional'=>$resEnfProfesional[$i], 'Personas'=>'0');
}
$pRegistros = count($arrResultado);
$PersonasNO = 0;
$PersonasSI = 0;
for($i=0;$i<$pRegistros;$i++){
    $arrResultado[$i]["Personas"] = DevolverElementos($arrEnfProfesional,$arrResultado[$i]["EnfProfesional"]);
    //echo $arrResultado[$i]["EstadoCivil"] . " : " . $arrResultado[$i]["Personas"] . " --- ";
    $arrData[] = $arrResultado[$i]["Personas"];
    $arrLabels[] = $arrResultado[$i]["EnfProfesional"];
    if($arrResultado[$i]["EnfProfesional"] == "SI"){
        $PersonasSI += $arrResultado[$i]["Personas"];
    }else{
        $PersonasNO += $arrResultado[$i]["Personas"];
    }
    $totalPac += $arrResultado[$i]["Personas"];
}
if($totalPac == 0){
    $totalPac = 1;
}
$mostrarHC = "<br><br>";
$mostrarHC .= '<span style="font-size:33px; color:#000;"><b>3.5 DISTRIBUCION PORCENTUAL SEGUN ENFERMEDADES PROFESIONALES</b></span><br><br>';
if($PersonasNO > 0){
    $mostrarHC .= '<span style="font-size:29px; color:#000;">El ' . number_format((($PersonasNO/$totalPac)*100),2,".",",") . '% de los trabajadores evaluados refirieron no tener diagnósticos de enfermedad profesional</span>';
    if($PersonasSI > 0){
        $mostrarHC .= '<span style="font-size:29px; color:#000;">, y el ' . number_format((($PersonasSI/$totalPac)*100),2,".",",") . '% de los trabajadores evaluados reportan diagnósticos de enfermedad profesional</span>';    
    }
    $mostrarHC .= '<span style="font-size:29px; color:#000;">.</span>';    
}else{
    if($PersonasSI > 0){
        $mostrarHC .= '<span style="font-size:29px; color:#000;">El ' . number_format((($PersonasSI/$totalPac)*100),2,".",",") . '% de los trabajadores evaluados reportan diagnósticos de enfermedad profesional.</span>';    
    }
}
$pdf->writeHTML($mostrarHC, true, false, false, false, '');
if ($pdf->GetY() >= ($pdf->getPageHeight()-$pControlSalto)){
    EncabezadoPagina($pdf);
}
Draw003General($arrData,$arrLabels,"05");
$mostrarHC = '<center><table width="700" border="0" cellpadding="5">';
$mostrarHC .= '<tr>';
$mostrarHC .= '<td colspan="3" align="center"><span style="font-size:29px; color:#000;">TABLA Y GRAFICO 5. SEGUN ENFERMEDADES PROFESIONALES</span></td>';
$mostrarHC .= '</tr>';
$mostrarHC .= '<tr>';
$mostrarHC .= '<td width="3"></td>';
$mostrarHC .= '<td width="300">';
$mostrarHC .= '<table cellpadding="5" border="1">';
$mostrarHC .= '<tr style="background-color:#F2F2F2;" align="center">';
$mostrarHC .= '<td><b>EnfProfesional</b></td>';
$mostrarHC .= '<td><b>Nro PERSONAS</b></td>';
$mostrarHC .= '<td><b>%</b></td>';
$mostrarHC .= '</tr>';
for($i=0;$i<$pRegistros;$i++){
    $mostrarHC .= '<tr>';
    $mostrarHC .= '<td>' . $arrResultado[$i]["EnfProfesional"] . '</td>';
    $mostrarHC .= '<td align="center">' . $arrResultado[$i]["Personas"] .'</td>';
    $mostrarHC .= '<td align="center">' . number_format(($arrResultado[$i]["Personas"]/$totalPac)*100,2,".",",") . '</td>';
    $totalPorcentaje += number_format(($arrResultado[$i]["Personas"]/$totalPac)*100,2,".",",");
    $mostrarHC .= '</tr>';
}
$mostrarHC .= '<tr>';
$mostrarHC .= '<td>TOTAL</td>';
$mostrarHC .= '<td align="center">' . $totalPac .'</td>';
$mostrarHC .= '<td align="center">' . round($totalPorcentaje) . '</td>';
$mostrarHC .= '</tr>';
$mostrarHC .= '</table>';
$mostrarHC .= '</td>';
$mostrarHC .= '<td width="450" align="center">';
$mostrarHC .= '<img src="chart005.png" width="330" height="120"/>';
$mostrarHC .= '</td>';
$mostrarHC .= '</tr>';
$mostrarHC .= '</table></center>';
$pdf->writeHTML($mostrarHC, true, false, false, false, '');
if ($pdf->GetY() >= ($pdf->getPageHeight()-$pControlSalto)){
    EncabezadoPagina($pdf);
}
unset($row);
unset($arrData);
unset($arrLabels);
unset($arrEnfProfesional);
unset($resEnfProfesional);
unset($arrResultado);
//////////////////////////////////////////////////////////

EncabezadoPagina($pdf);

//////////////////////////////////////////////////////////
unset($row);
unset($arrData);
unset($arrLabels);
unset($arrAccTrabajo);
unset($resAccTrabajo);
unset($arrResultado);
$gBaseDatos = new ofiMySQLi();
$gBaseDatos->conectar();
$qry = "CALL sp_macroinformes_saludocupa002_infgen003('" . $pEmpresa . "','" . $pIPS . "','" . $pCliente . "','" . $pPlan . "','" . $pSubPlan . "','" . $pContrato . "',\"" . $pDesde . "\",\"" . $pHasta . "\")";
//echo $qry;
$gBaseDatos->QryID = @mysqli_query($gBaseDatos->ConexionID, $qry);
while ($row[] = @mysqli_fetch_assoc($gBaseDatos->QryID));
$gBaseDatos->liberar();
$gBaseDatos->cerrar();
$pRegistros = count($row);
$totalPac = 0;
$totalPorcentaje = 0;
for($i=0;$i<$pRegistros;$i++){
    if($row[$i]["Evolucion"] != null && $row[$i]["Evolucion"] != ""){
        $estructurahc = explode("¬",utf8_decode($row[$i]["Evolucion"]));
        $reg = count($estructurahc)-1;
        for ($j=0; $j<$reg; $j++){
            $contenidohc = explode("^~",$estructurahc[$j]);
            switch($contenidohc[1]){
                case "TRUE":
                    $txtContenido = "SI";
                    break;
                case "true":
                    $txtContenido = "SI";
                    break;

                case "FALSE":
                    $txtContenido = "NO";
                    break;
                case "false":
                    $txtContenido = "NO";
                    break;

                default:
                    $txtContenido = $contenidohc[1];
                    break;
            }
            if(substr($contenidohc[0],0,30) == "str231SufrioAccidenteTrabajoSO"){ 
                if($txtContenido != null && $txtContenido != "" && $txtContenido != " "){
                    $arrAccTrabajo[] = $txtContenido;
                }
            }
        }
    }
}
$resAccTrabajo = array_values(array_unique($arrAccTrabajo));
$pRegistros = count($resAccTrabajo);
$arrResultado = array();
for($i=0;$i<$pRegistros;$i++){
    $arrResultado[$i] = array('AccTrabajo'=>$resAccTrabajo[$i], 'Personas'=>'0');
}
$pRegistros = count($arrResultado);
$PersonasNO = 0;
$PersonasSI = 0;
for($i=0;$i<$pRegistros;$i++){
    $arrResultado[$i]["Personas"] = DevolverElementos($arrAccTrabajo,$arrResultado[$i]["AccTrabajo"]);
    //echo $arrResultado[$i]["EstadoCivil"] . " : " . $arrResultado[$i]["Personas"] . " --- ";
    $arrData[] = $arrResultado[$i]["Personas"];
    $arrLabels[] = $arrResultado[$i]["AccTrabajo"];
    if($arrResultado[$i]["AccTrabajo"] == "SI"){
        $PersonasSI += $arrResultado[$i]["Personas"];
    }else{
        $PersonasNO += $arrResultado[$i]["Personas"];
    }
    $totalPac += $arrResultado[$i]["Personas"];
}
if($totalPac == 0){
    $totalPac = 1;
}
$mostrarHC = '<span style="font-size:33px; color:#000;"><b>3.6 DISTRIBUCION PORCENTUAL SEGUN ACCIDENTES DE TRABAJO</b></span><br><br>';
if($PersonasNO > 0){
    $mostrarHC .= '<span style="font-size:29px; color:#000;">Con relación a antecedentes de accidentes de trabajo, ya sean reportados o no, se presentó la siguiente distribución de acuerdo a lo referido por los trabajadores, de los cuales, el ' . number_format((($PersonasNO/$totalPac)*100),2,".",",") . '% manifiesta no haber sufrido ningún accidente de trabajo</span>';
    if($PersonasSI > 0){
        $mostrarHC .= '<span style="font-size:29px; color:#000;">, y el ' . number_format((($PersonasSI/$totalPac)*100),2,".",",") . '% de los trabajadores evaluados reportan accidentes de trabajo</span>';    
    }
    $mostrarHC .= '<span style="font-size:29px; color:#000;">.</span>';    
}else{
    if($PersonasSI > 0){
        $mostrarHC .= '<span style="font-size:29px; color:#000;">, y el ' . number_format((($PersonasSI/$totalPac)*100),2,".",",") . '% de los trabajadores evaluados reportan accidentes de trabajo.</span>';    
    }
}
$pdf->writeHTML($mostrarHC, true, false, false, false, '');
if ($pdf->GetY() >= ($pdf->getPageHeight()-$pControlSalto)){
    EncabezadoPagina($pdf);
}
Draw003General($arrData,$arrLabels,"06");
$mostrarHC = '<center><table width="700" border="0" cellpadding="5">';
$mostrarHC .= '<tr>';
$mostrarHC .= '<td colspan="3" align="center"><span style="font-size:29px; color:#000;">TABLA Y GRAFICO 6. SEGUN ACCIDENTES DE TRABAJO</span></td>';
$mostrarHC .= '</tr>';
$mostrarHC .= '<tr>';
$mostrarHC .= '<td width="3"></td>';
$mostrarHC .= '<td width="300">';
$mostrarHC .= '<table cellpadding="5" border="1">';
$mostrarHC .= '<tr style="background-color:#F2F2F2;" align="center">';
$mostrarHC .= '<td><b>AccTrabajo</b></td>';
$mostrarHC .= '<td><b>Nro PERSONAS</b></td>';
$mostrarHC .= '<td><b>%</b></td>';
$mostrarHC .= '</tr>';
for($i=0;$i<$pRegistros;$i++){
    $mostrarHC .= '<tr>';
    $mostrarHC .= '<td>' . $arrResultado[$i]["AccTrabajo"] . '</td>';
    $mostrarHC .= '<td align="center">' . $arrResultado[$i]["Personas"] .'</td>';
    $mostrarHC .= '<td align="center">' . number_format(($arrResultado[$i]["Personas"]/$totalPac)*100,2,".",",") . '</td>';
    $totalPorcentaje += number_format(($arrResultado[$i]["Personas"]/$totalPac)*100,2,".",",");
    $mostrarHC .= '</tr>';
}
$mostrarHC .= '<tr>';
$mostrarHC .= '<td>TOTAL</td>';
$mostrarHC .= '<td align="center">' . $totalPac .'</td>';
$mostrarHC .= '<td align="center">' . round($totalPorcentaje) . '</td>';
$mostrarHC .= '</tr>';
$mostrarHC .= '</table>';
$mostrarHC .= '</td>';
$mostrarHC .= '<td width="450" align="center">';
$mostrarHC .= '<img src="chart006.png" width="330" height="120"/>';
$mostrarHC .= '</td>';
$mostrarHC .= '</tr>';
$mostrarHC .= '</table></center>';
$pdf->writeHTML($mostrarHC, true, false, false, false, '');
if ($pdf->GetY() >= ($pdf->getPageHeight()-$pControlSalto)){
    EncabezadoPagina($pdf);
}
unset($row);
unset($arrData);
unset($arrLabels);
unset($arrAccTrabajo);
unset($resAccTrabajo);
unset($arrResultado);

//////////////////////////////////////////////////////////
unset($row);
unset($arrData);
unset($arrLabels);
unset($arrAntecedentesFam);
unset($resAntecedentesFam);
unset($arrResultado);
$gBaseDatos = new ofiMySQLi();
$gBaseDatos->conectar();
$qry = "CALL sp_macroinformes_saludocupa002_infgen003('" . $pEmpresa . "','" . $pIPS . "','" . $pCliente . "','" . $pPlan . "','" . $pSubPlan . "','" . $pContrato . "',\"" . $pDesde . "\",\"" . $pHasta . "\")";
//echo $qry;
$gBaseDatos->QryID = @mysqli_query($gBaseDatos->ConexionID, $qry);
while ($row[] = @mysqli_fetch_assoc($gBaseDatos->QryID));
$gBaseDatos->liberar();
$gBaseDatos->cerrar();
$pRegistros = count($row);
$totalPac = 0;
$totalPorcentaje = 0;
for($i=0;$i<$pRegistros;$i++){
    if($row[$i]["Evolucion"] != null && $row[$i]["Evolucion"] != ""){
        $estructurahc = explode("¬",utf8_decode($row[$i]["Evolucion"]));
        $reg = count($estructurahc)-1;
        $esSI = 0;
        $esNO = 0;
        for ($j=0; $j<$reg; $j++){
            $contenidohc = explode("^~",$estructurahc[$j]);
            switch($contenidohc[1]){
                case "TRUE":
                    $txtContenido = "SI";
                    break;
                case "true":
                    $txtContenido = "SI";
                    break;

                case "FALSE":
                    $txtContenido = "NO";
                    break;
                case "false":
                    $txtContenido = "NO";
                    break;

                default:
                    $txtContenido = $contenidohc[1];
                    break;
            }
            if(substr($contenidohc[0],0,16) == "str024AFHTAPadSO"){ if($txtContenido == "SI"){ $esSI = 1; }else{ $esNO = 1;}}
            if(substr($contenidohc[0],0,16) == "str025AFHTAMadSO"){ if($txtContenido == "SI"){ $esSI = 1; }else{ $esNO = 1;}}
            if(substr($contenidohc[0],0,16) == "str026AFHTAHnoSO"){ if($txtContenido == "SI"){ $esSI = 1; }else{ $esNO = 1;}}
            if(substr($contenidohc[0],0,17) == "str027AFHTATioMSO"){ if($txtContenido == "SI"){ $esSI = 1; }else{ $esNO = 1;}}
            if(substr($contenidohc[0],0,17) == "str028AFHTATioPSO"){ if($txtContenido == "SI"){ $esSI = 1; }else{ $esNO = 1;}}
            if(substr($contenidohc[0],0,17) == "str029AFHTAAbuMSO"){ if($txtContenido == "SI"){ $esSI = 1; }else{ $esNO = 1;}}
            if(substr($contenidohc[0],0,17) == "str030AFHTAAbuPSO"){ if($txtContenido == "SI"){ $esSI = 1; }else{ $esNO = 1;}}
            if(substr($contenidohc[0],0,25) == "str031AFEnfCoronariaPadSO"){ if($txtContenido == "SI"){ $esSI = 1; }else{ $esNO = 1;}}
            if(substr($contenidohc[0],0,25) == "str032AFEnfCoronariaMadSO"){ if($txtContenido == "SI"){ $esSI = 1; }else{ $esNO = 1;}}
            if(substr($contenidohc[0],0,25) == "str033AFEnfCoronariaHnoSO"){ if($txtContenido == "SI"){ $esSI = 1; }else{ $esNO = 1;}}
            if(substr($contenidohc[0],0,26) == "str034AFEnfCoronariaTioMSO"){ if($txtContenido == "SI"){ $esSI = 1; }else{ $esNO = 1;}}
            if(substr($contenidohc[0],0,26) == "str035AFEnfCoronariaTioPSO"){ if($txtContenido == "SI"){ $esSI = 1; }else{ $esNO = 1;}}
            if(substr($contenidohc[0],0,26) == "str036AFEnfCoronariaAbuMSO"){ if($txtContenido == "SI"){ $esSI = 1; }else{ $esNO = 1;}}
            if(substr($contenidohc[0],0,26) == "str037AFEnfCoronariaAbuPSO"){ if($txtContenido == "SI"){ $esSI = 1; }else{ $esNO = 1;}}
            if(substr($contenidohc[0],0,16) == "str038AFACVPadSO"){ if($txtContenido == "SI"){ $esSI = 1; }else{ $esNO = 1;}}
            if(substr($contenidohc[0],0,16) == "str039AFACVMadSO"){ if($txtContenido == "SI"){ $esSI = 1; }else{ $esNO = 1;}}
            if(substr($contenidohc[0],0,16) == "str040AFACVHnoSO"){ if($txtContenido == "SI"){ $esSI = 1; }else{ $esNO = 1;}}
            if(substr($contenidohc[0],0,17) == "str041AFACVTioMSO"){ if($txtContenido == "SI"){ $esSI = 1; }else{ $esNO = 1;}}
            if(substr($contenidohc[0],0,17) == "str042AFACVTioPSO"){ if($txtContenido == "SI"){ $esSI = 1; }else{ $esNO = 1;}}
            if(substr($contenidohc[0],0,17) == "str043AFACVAbuMSO"){ if($txtContenido == "SI"){ $esSI = 1; }else{ $esNO = 1;}}
            if(substr($contenidohc[0],0,17) == "str044AFACVAbuPSO"){ if($txtContenido == "SI"){ $esSI = 1; }else{ $esNO = 1;}}
            if(substr($contenidohc[0],0,21) == "str045AFDiabetesPadSO"){ if($txtContenido == "SI"){ $esSI = 1; }else{ $esNO = 1;}}
            if(substr($contenidohc[0],0,21) == "str046AFDiabetesMadSO"){ if($txtContenido == "SI"){ $esSI = 1; }else{ $esNO = 1;}}
            if(substr($contenidohc[0],0,21) == "str047AFDiabetesHnoSO"){ if($txtContenido == "SI"){ $esSI = 1; }else{ $esNO = 1;}}
            if(substr($contenidohc[0],0,22) == "str048AFDiabetesTioMSO"){ if($txtContenido == "SI"){ $esSI = 1; }else{ $esNO = 1;}}
            if(substr($contenidohc[0],0,22) == "str049AFDiabetesTioPSO"){ if($txtContenido == "SI"){ $esSI = 1; }else{ $esNO = 1;}}
            if(substr($contenidohc[0],0,22) == "str050AFDiabetesAbuMSO"){ if($txtContenido == "SI"){ $esSI = 1; }else{ $esNO = 1;}}
            if(substr($contenidohc[0],0,22) == "str051AFDiabetesAbuPSO"){ if($txtContenido == "SI"){ $esSI = 1; }else{ $esNO = 1;}}
            if(substr($contenidohc[0],0,22) == "str052AFEnfMentalPadSO"){ if($txtContenido == "SI"){ $esSI = 1; }else{ $esNO = 1;}}
            if(substr($contenidohc[0],0,22) == "str053AFEnfMentalMadSO"){ if($txtContenido == "SI"){ $esSI = 1; }else{ $esNO = 1;}}
            if(substr($contenidohc[0],0,22) == "str054AFEnfMentalHnoSO"){ if($txtContenido == "SI"){ $esSI = 1; }else{ $esNO = 1;}}
            if(substr($contenidohc[0],0,23) == "str055AFEnfMentalTioMSO"){ if($txtContenido == "SI"){ $esSI = 1; }else{ $esNO = 1;}}
            if(substr($contenidohc[0],0,23) == "str056AFEnfMentalTioPSO"){ if($txtContenido == "SI"){ $esSI = 1; }else{ $esNO = 1;}}
            if(substr($contenidohc[0],0,23) == "str057AFEnfMentalAbuMSO"){ if($txtContenido == "SI"){ $esSI = 1; }else{ $esNO = 1;}}
            if(substr($contenidohc[0],0,23) == "str058AFEnfMentalAbuPSO"){ if($txtContenido == "SI"){ $esSI = 1; }else{ $esNO = 1;}}
            if(substr($contenidohc[0],0,31) == "str059AFSindromeConvulsivoPadSO"){ if($txtContenido == "SI"){ $esSI = 1; }else{ $esNO = 1;}}
            if(substr($contenidohc[0],0,31) == "str060AFSindromeConvulsivoMadSO"){ if($txtContenido == "SI"){ $esSI = 1; }else{ $esNO = 1;}}
            if(substr($contenidohc[0],0,31) == "str061AFSindromeConvulsivoHnoSO"){ if($txtContenido == "SI"){ $esSI = 1; }else{ $esNO = 1;}}
            if(substr($contenidohc[0],0,32) == "str062AFSindromeConvulsivoTioMSO"){ if($txtContenido == "SI"){ $esSI = 1; }else{ $esNO = 1;}}
            if(substr($contenidohc[0],0,32) == "str063AFSindromeConvulsivoTioPSO"){ if($txtContenido == "SI"){ $esSI = 1; }else{ $esNO = 1;}}
            if(substr($contenidohc[0],0,32) == "str064AFSindromeConvulsivoAbuMSO"){ if($txtContenido == "SI"){ $esSI = 1; }else{ $esNO = 1;}}
            if(substr($contenidohc[0],0,32) == "str065AFSindromeConvulsivoAbuPSO"){ if($txtContenido == "SI"){ $esSI = 1; }else{ $esNO = 1;}}
            if(substr($contenidohc[0],0,25) == "str066AFAlcoholDrogaPadSO"){ if($txtContenido == "SI"){ $esSI = 1; }else{ $esNO = 1;}}
            if(substr($contenidohc[0],0,25) == "str067AFAlcoholDrogaMadSO"){ if($txtContenido == "SI"){ $esSI = 1; }else{ $esNO = 1;}}
            if(substr($contenidohc[0],0,25) == "str068AFAlcoholDrogaHnoSO"){ if($txtContenido == "SI"){ $esSI = 1; }else{ $esNO = 1;}}
            if(substr($contenidohc[0],0,26) == "str069AFAlcoholDrogaTioMSO"){ if($txtContenido == "SI"){ $esSI = 1; }else{ $esNO = 1;}}
            if(substr($contenidohc[0],0,26) == "str070AFAlcoholDrogaTioPSO"){ if($txtContenido == "SI"){ $esSI = 1; }else{ $esNO = 1;}}
            if(substr($contenidohc[0],0,26) == "str071AFAlcoholDrogaAbuMSO"){ if($txtContenido == "SI"){ $esSI = 1; }else{ $esNO = 1;}}
            if(substr($contenidohc[0],0,26) == "str072AFAlcoholDrogaAbuPSO"){ if($txtContenido == "SI"){ $esSI = 1; }else{ $esNO = 1;}}
            if(substr($contenidohc[0],0,15) == "str073AFCAPadSO"){ if($txtContenido == "SI"){ $esSI = 1; }else{ $esNO = 1;}}
            if(substr($contenidohc[0],0,15) == "str074AFCAMadSO"){ if($txtContenido == "SI"){ $esSI = 1; }else{ $esNO = 1;}}
            if(substr($contenidohc[0],0,15) == "str075AFCAHnoSO"){ if($txtContenido == "SI"){ $esSI = 1; }else{ $esNO = 1;}}
            if(substr($contenidohc[0],0,16) == "str076AFCATioMSO"){ if($txtContenido == "SI"){ $esSI = 1; }else{ $esNO = 1;}}
            if(substr($contenidohc[0],0,16) == "str077AFCATioPSO"){ if($txtContenido == "SI"){ $esSI = 1; }else{ $esNO = 1;}}
            if(substr($contenidohc[0],0,16) == "str078AFCAAbuMSO"){ if($txtContenido == "SI"){ $esSI = 1; }else{ $esNO = 1;}}
            if(substr($contenidohc[0],0,16) == "str079AFCAAbuPSO"){ if($txtContenido == "SI"){ $esSI = 1; }else{ $esNO = 1;}}
        }
        if($esSI == 1){
            $arrAntecedentesFam[] = "SI";
        }else{
            if($esNO == 1){
                $arrAntecedentesFam[] = "NO";
            }
        }
    }
}
$resAntecedentesFam = array_values(array_unique($arrAntecedentesFam));
$pRegistros = count($resAntecedentesFam);
$arrResultado = array();
for($i=0;$i<$pRegistros;$i++){
    $arrResultado[$i] = array('AntecedentesFam'=>$resAntecedentesFam[$i], 'Personas'=>'0');
}
$pRegistros = count($arrResultado);
$PersonasNO = 0;
$PersonasSI = 0;
for($i=0;$i<$pRegistros;$i++){
    $arrResultado[$i]["Personas"] = DevolverElementos($arrAntecedentesFam,$arrResultado[$i]["AntecedentesFam"]);
    //echo $arrResultado[$i]["EstadoCivil"] . " : " . $arrResultado[$i]["Personas"] . " --- ";
    $arrData[] = $arrResultado[$i]["Personas"];
    $arrLabels[] = $arrResultado[$i]["AntecedentesFam"];
    if($arrResultado[$i]["AntecedentesFam"] == "SI"){
        $PersonasSI += $arrResultado[$i]["Personas"];
    }else{
        $PersonasNO += $arrResultado[$i]["Personas"];
    }
    $totalPac += $arrResultado[$i]["Personas"];
}
if($totalPac == 0){
    $totalPac = 1;
}
$mostrarHC = '<span style="font-size:33px; color:#000;"><b>3.7 DISTRIBUCION PORCENTUAL SEGUN ANTECEDENTES FAMILIARES</b></span><br><br>';
$mostrarHC .= '<span style="font-size:29px; color:#000;">Al interrogar sobre antecedentes de enfermedades sufridas por los familiares de primera y segunda línea de consanguinidad encontramos que el ' . number_format((($PersonasNO/$totalPac)*100),2,".",",") . '% de los trabajadores no presenta antecedentes, mientras el ' . number_format((($PersonasSI/$totalPac)*100),2,".",",") . '% si presentan antecedentes.</span>';
$pdf->writeHTML($mostrarHC, true, false, false, false, '');
if ($pdf->GetY() >= ($pdf->getPageHeight()-$pControlSalto)){
    EncabezadoPagina($pdf);
}
Draw003General($arrData,$arrLabels,"07");
$mostrarHC = '<center><table width="700" border="0" cellpadding="5">';
$mostrarHC .= '<tr>';
$mostrarHC .= '<td colspan="3" align="center"><span style="font-size:29px; color:#000;">TABLA Y GRAFICO 7. SEGUN ANTECEDENTES FAMILIARES</span></td>';
$mostrarHC .= '</tr>';
$mostrarHC .= '<tr>';
$mostrarHC .= '<td width="3"></td>';
$mostrarHC .= '<td width="300">';
$mostrarHC .= '<table cellpadding="5" border="1">';
$mostrarHC .= '<tr style="background-color:#F2F2F2;" align="center">';
$mostrarHC .= '<td><b>ANTECEDENTES FAMILIARES</b></td>';
$mostrarHC .= '<td><b>Nro PERSONAS</b></td>';
$mostrarHC .= '<td><b>%</b></td>';
$mostrarHC .= '</tr>';
for($i=0;$i<$pRegistros;$i++){
    $mostrarHC .= '<tr>';
    $mostrarHC .= '<td>' . $arrResultado[$i]["AntecedentesFam"] . '</td>';
    $mostrarHC .= '<td align="center">' . $arrResultado[$i]["Personas"] .'</td>';
    $mostrarHC .= '<td align="center">' . number_format(($arrResultado[$i]["Personas"]/$totalPac)*100,2,".",",") . '</td>';
    $totalPorcentaje += number_format(($arrResultado[$i]["Personas"]/$totalPac)*100,2,".",",");
    $mostrarHC .= '</tr>';
}
$mostrarHC .= '<tr>';
$mostrarHC .= '<td>TOTAL</td>';
$mostrarHC .= '<td align="center">' . $totalPac .'</td>';
$mostrarHC .= '<td align="center">' . round($totalPorcentaje) . '</td>';
$mostrarHC .= '</tr>';
$mostrarHC .= '</table>';
$mostrarHC .= '</td>';
$mostrarHC .= '<td width="450" align="center">';
$mostrarHC .= '<img src="chart007.png" width="330" height="120"/>';
$mostrarHC .= '</td>';
$mostrarHC .= '</tr>';
$mostrarHC .= '</table></center>';
$pdf->writeHTML($mostrarHC, true, false, false, false, '');
if ($pdf->GetY() >= ($pdf->getPageHeight()-$pControlSalto)){
    EncabezadoPagina($pdf);
}
unset($row);
unset($arrData);
unset($arrLabels);
unset($arrAntecedentesFam);
unset($resAntecedentesFam);
unset($arrResultado);

/////////////////////////////////////////////////////////
unset($row);
unset($arrData);
unset($arrLabels);
unset($arrFumadorActual);
unset($resFumadorActual);
unset($arrResultado);
$gBaseDatos = new ofiMySQLi();
$gBaseDatos->conectar();
$qry = "CALL sp_macroinformes_saludocupa002_infgen003('" . $pEmpresa . "','" . $pIPS . "','" . $pCliente . "','" . $pPlan . "','" . $pSubPlan . "','" . $pContrato . "',\"" . $pDesde . "\",\"" . $pHasta . "\")";
//echo $qry;
$gBaseDatos->QryID = @mysqli_query($gBaseDatos->ConexionID, $qry);
while ($row[] = @mysqli_fetch_assoc($gBaseDatos->QryID));
$gBaseDatos->liberar();
$gBaseDatos->cerrar();
$pRegistros = count($row);
$totalPac = 0;
$totalPorcentaje = 0;
for($i=0;$i<$pRegistros;$i++){
    if($row[$i]["Evolucion"] != null && $row[$i]["Evolucion"] != ""){
        $estructurahc = explode("¬",utf8_decode($row[$i]["Evolucion"]));
        $reg = count($estructurahc)-1;
        for ($j=0; $j<$reg; $j++){
            $contenidohc = explode("^~",$estructurahc[$j]);
            switch($contenidohc[1]){
                case "TRUE":
                    $txtContenido = "SI";
                    break;
                case "true":
                    $txtContenido = "SI";
                    break;

                case "FALSE":
                    $txtContenido = "NO";
                    break;
                case "false":
                    $txtContenido = "NO";
                    break;

                default:
                    $txtContenido = $contenidohc[1];
                    break;
            }
            if(substr($contenidohc[0],0,33) == "str107APToxicosFuamaActualmenteSO"){ 
                if($txtContenido != null && $txtContenido != "" && $txtContenido != " "){
                    $arrFumadorActual[] = $txtContenido;
                }
            }
        }
    }
}
$resFumadorActual = array_values(array_unique($arrFumadorActual));
$pRegistros = count($resFumadorActual);
$arrResultado = array();
for($i=0;$i<$pRegistros;$i++){
    $arrResultado[$i] = array('FumadorActual'=>$resFumadorActual[$i], 'Personas'=>'0');
}
$pRegistros = count($arrResultado);
$PersonasNO = 0;
$PersonasSI = 0;
for($i=0;$i<$pRegistros;$i++){
    $arrResultado[$i]["Personas"] = DevolverElementos($arrFumadorActual,$arrResultado[$i]["FumadorActual"]);
    //echo $arrResultado[$i]["EstadoCivil"] . " : " . $arrResultado[$i]["Personas"] . " --- ";
    $arrData[] = $arrResultado[$i]["Personas"];
    $arrLabels[] = $arrResultado[$i]["FumadorActual"];
    if($arrResultado[$i]["FumadorActual"] == "SI"){
        $PersonasSI += $arrResultado[$i]["Personas"];
    }else{
        $PersonasNO += $arrResultado[$i]["Personas"];
    }
    $totalPac += $arrResultado[$i]["Personas"];
}
if($totalPac == 0){
    $totalPac = 1;
}
$mostrarHC = '<span style="font-size:33px; color:#000;"><b>3.8 DISTRIBUCION PORCENTUAL SEGUN FUMADOR ACTUAL</b></span><br><br>';
if($PersonasNO > 0){
    $mostrarHC .= '<span style="font-size:29px; color:#000;">El ' . number_format((($PersonasNO/$totalPac)*100),2,".",",") . '% de la población evaluada refiere no ser fumadores en la actualidad</span>';
    if($PersonasSI > 0){
        $mostrarHC .= '<span style="font-size:29px; color:#000;">, y el ' . number_format((($PersonasSI/$totalPac)*100),2,".",",") . '% de los trabajadores evaluados refieren ser fumadores activos</span>';    
    }
    $mostrarHC .= '<span style="font-size:29px; color:#000;">.</span>';    
}else{
    if($PersonasSI > 0){
        $mostrarHC .= '<span style="font-size:29px; color:#000;">El ' . number_format((($PersonasSI/$totalPac)*100),2,".",",") . '% de los trabajadores evaluados refieren ser fumadores activos.</span>';    
    }
}
$pdf->writeHTML($mostrarHC, true, false, false, false, '');
if ($pdf->GetY() >= ($pdf->getPageHeight()-$pControlSalto)){
    EncabezadoPagina($pdf);
}
Draw003General($arrData,$arrLabels,"08");
$mostrarHC = '<center><table width="700" border="0" cellpadding="5">';
$mostrarHC .= '<tr>';
$mostrarHC .= '<td colspan="3" align="center"><span style="font-size:29px; color:#000;">TABLA Y GRAFICO 8. SEGUN FUMADOR ACTUAL</span></td>';
$mostrarHC .= '</tr>';
$mostrarHC .= '<tr>';
$mostrarHC .= '<td width="3"></td>';
$mostrarHC .= '<td width="300">';
$mostrarHC .= '<table cellpadding="5" border="1">';
$mostrarHC .= '<tr style="background-color:#F2F2F2;" align="center">';
$mostrarHC .= '<td><b>FUMADOR ACTUAL</b></td>';
$mostrarHC .= '<td><b>Nro PERSONAS</b></td>';
$mostrarHC .= '<td><b>%</b></td>';
$mostrarHC .= '</tr>';
for($i=0;$i<$pRegistros;$i++){
    $mostrarHC .= '<tr>';
    $mostrarHC .= '<td>' . $arrResultado[$i]["FumadorActual"] . '</td>';
    $mostrarHC .= '<td align="center">' . $arrResultado[$i]["Personas"] .'</td>';
    $mostrarHC .= '<td align="center">' . number_format(($arrResultado[$i]["Personas"]/$totalPac)*100,2,".",",") . '</td>';
    $totalPorcentaje += number_format(($arrResultado[$i]["Personas"]/$totalPac)*100,2,".",",");
    $mostrarHC .= '</tr>';
}
$mostrarHC .= '<tr>';
$mostrarHC .= '<td>TOTAL</td>';
$mostrarHC .= '<td align="center">' . $totalPac .'</td>';
$mostrarHC .= '<td align="center">' . round($totalPorcentaje) . '</td>';
$mostrarHC .= '</tr>';
$mostrarHC .= '</table>';
$mostrarHC .= '</td>';
$mostrarHC .= '<td width="450" align="center">';
$mostrarHC .= '<img src="chart008.png" width="330" height="120"/>';
$mostrarHC .= '</td>';
$mostrarHC .= '</tr>';
$mostrarHC .= '</table></center>';
$pdf->writeHTML($mostrarHC, true, false, false, false, '');
if ($pdf->GetY() >= ($pdf->getPageHeight()-$pControlSalto)){
    EncabezadoPagina($pdf);
}
unset($row);
unset($arrData);
unset($arrLabels);
unset($arrFumadorActual);
unset($resFumadorActual);
unset($arrResultado);
///////////////////////////////////////////////////

unset($row);
unset($arrData);
unset($arrLabels);
unset($arrIngestaLicor);
unset($resIngestaLicor);
unset($arrResultado);
$gBaseDatos = new ofiMySQLi();
$gBaseDatos->conectar();
$qry = "CALL sp_macroinformes_saludocupa002_infgen003('" . $pEmpresa . "','" . $pIPS . "','" . $pCliente . "','" . $pPlan . "','" . $pSubPlan . "','" . $pContrato . "',\"" . $pDesde . "\",\"" . $pHasta . "\")";
//echo $qry;
$gBaseDatos->QryID = @mysqli_query($gBaseDatos->ConexionID, $qry);
while ($row[] = @mysqli_fetch_assoc($gBaseDatos->QryID));
$gBaseDatos->liberar();
$gBaseDatos->cerrar();
$pRegistros = count($row);
$totalPac = 0;
$totalPorcentaje = 0;
for($i=0;$i<$pRegistros;$i++){
    if($row[$i]["Evolucion"] != null && $row[$i]["Evolucion"] != ""){
        $estructurahc = explode("¬",utf8_decode($row[$i]["Evolucion"]));
        $reg = count($estructurahc)-1;
        for ($j=0; $j<$reg; $j++){
            $contenidohc = explode("^~",$estructurahc[$j]);
            switch($contenidohc[1]){
                case "TRUE":
                    $txtContenido = "SI";
                    break;
                case "true":
                    $txtContenido = "SI";
                    break;

                case "FALSE":
                    $txtContenido = "NO";
                    break;
                case "false":
                    $txtContenido = "NO";
                    break;

                default:
                    $txtContenido = $contenidohc[1];
                    break;
            }
            if(substr($contenidohc[0],0,31) == "str113APToxicosConsumoAlcoholSO"){ 
                if($txtContenido != null && $txtContenido != "" && $txtContenido != " "){
                    $arrIngestaLicor[] = $txtContenido;
                }
            }
        }
    }
}
$resIngestaLicor = array_values(array_unique($arrIngestaLicor));
$pRegistros = count($resIngestaLicor);
$arrResultado = array();
for($i=0;$i<$pRegistros;$i++){
    $arrResultado[$i] = array('IngestaLicor'=>$resIngestaLicor[$i], 'Personas'=>'0');
}
$pRegistros = count($arrResultado);
$PersonasNO = 0;
$PersonasSI = 0;
for($i=0;$i<$pRegistros;$i++){
    $arrResultado[$i]["Personas"] = DevolverElementos($arrIngestaLicor,$arrResultado[$i]["IngestaLicor"]);
    //echo $arrResultado[$i]["EstadoCivil"] . " : " . $arrResultado[$i]["Personas"] . " --- ";
    $arrData[] = $arrResultado[$i]["Personas"];
    $arrLabels[] = $arrResultado[$i]["IngestaLicor"];
    if($arrResultado[$i]["IngestaLicor"] == "SI"){
        $PersonasSI += $arrResultado[$i]["Personas"];
    }else{
        $PersonasNO += $arrResultado[$i]["Personas"];
    }
    $totalPac += $arrResultado[$i]["Personas"];
}
if($totalPac == 0){
    $totalPac = 1;
}
$mostrarHC = '<span style="font-size:33px; color:#000;"><b>3.9 DISTRIBUCION PORCENTUAL SEGUN INGESTA DE LICOR</b></span><br><br>';
if($PersonasNO > 0){
    $mostrarHC .= '<span style="font-size:29px; color:#000;">El ' . number_format((($PersonasNO/$totalPac)*100),2,".",",") . '% de la población evaluada refiere no ingerir licor actualidad</span>';
    if($PersonasSI > 0){
        $mostrarHC .= '<span style="font-size:29px; color:#000;">, y el ' . number_format((($PersonasSI/$totalPac)*100),2,".",",") . '% de los trabajadores ingieren licor actualmente</span>';    
    }
    $mostrarHC .= '<span style="font-size:29px; color:#000;">.</span>';    
}else{
    if($PersonasSI > 0){
        $mostrarHC .= '<span style="font-size:29px; color:#000;">El ' . number_format((($PersonasSI/$totalPac)*100),2,".",",") . '% de los trabajadores ingieren licor actualmente.</span>';    
    }
}
$pdf->writeHTML($mostrarHC, true, false, false, false, '');
if ($pdf->GetY() >= ($pdf->getPageHeight()-$pControlSalto)){
    EncabezadoPagina($pdf);
}
Draw003General($arrData,$arrLabels,"09");
$mostrarHC = '<center><table width="700" border="0" cellpadding="5">';
$mostrarHC .= '<tr>';
$mostrarHC .= '<td colspan="3" align="center"><span style="font-size:29px; color:#000;">TABLA Y GRAFICO 9. SEGUN INGESTA DE LICOR</span></td>';
$mostrarHC .= '</tr>';
$mostrarHC .= '<tr>';
$mostrarHC .= '<td width="3"></td>';
$mostrarHC .= '<td width="300">';
$mostrarHC .= '<table cellpadding="5" border="1">';
$mostrarHC .= '<tr style="background-color:#F2F2F2;" align="center">';
$mostrarHC .= '<td><b>FUMADOR ACTUAL</b></td>';
$mostrarHC .= '<td><b>Nro PERSONAS</b></td>';
$mostrarHC .= '<td><b>%</b></td>';
$mostrarHC .= '</tr>';
for($i=0;$i<$pRegistros;$i++){
    $mostrarHC .= '<tr>';
    $mostrarHC .= '<td>' . $arrResultado[$i]["IngestaLicor"] . '</td>';
    $mostrarHC .= '<td align="center">' . $arrResultado[$i]["Personas"] .'</td>';
    $mostrarHC .= '<td align="center">' . number_format(($arrResultado[$i]["Personas"]/$totalPac)*100,2,".",",") . '</td>';
    $totalPorcentaje += number_format(($arrResultado[$i]["Personas"]/$totalPac)*100,2,".",",");
    $mostrarHC .= '</tr>';
}
$mostrarHC .= '<tr>';
$mostrarHC .= '<td>TOTAL</td>';
$mostrarHC .= '<td align="center">' . $totalPac .'</td>';
$mostrarHC .= '<td align="center">' . round($totalPorcentaje) . '</td>';
$mostrarHC .= '</tr>';
$mostrarHC .= '</table>';
$mostrarHC .= '</td>';
$mostrarHC .= '<td width="450" align="center">';
$mostrarHC .= '<img src="chart009.png" width="330" height="120"/>';
$mostrarHC .= '</td>';
$mostrarHC .= '</tr>';
$mostrarHC .= '</table></center>';
$pdf->writeHTML($mostrarHC, true, false, false, false, '');
unset($row);
unset($arrData);
unset($arrLabels);
unset($arrIngestaLicor);
unset($resIngestaLicor);
unset($arrResultado);
///////////////////////////////////////////////////

EncabezadoPagina($pdf);

///////////////////////////////////////////////////
unset($row);
unset($arrData);
unset($arrLabels);
unset($arrConsumoDroga);
unset($resConsumoDroga);
unset($arrResultado);
$gBaseDatos = new ofiMySQLi();
$gBaseDatos->conectar();
$qry = "CALL sp_macroinformes_saludocupa002_infgen003('" . $pEmpresa . "','" . $pIPS . "','" . $pCliente . "','" . $pPlan . "','" . $pSubPlan . "','" . $pContrato . "',\"" . $pDesde . "\",\"" . $pHasta . "\")";
//echo $qry;
$gBaseDatos->QryID = @mysqli_query($gBaseDatos->ConexionID, $qry);
while ($row[] = @mysqli_fetch_assoc($gBaseDatos->QryID));
$gBaseDatos->liberar();
$gBaseDatos->cerrar();
$pRegistros = count($row);
$totalPac = 0;
$totalPorcentaje = 0;
for($i=0;$i<$pRegistros;$i++){
    if($row[$i]["Evolucion"] != null && $row[$i]["Evolucion"] != ""){
        $estructurahc = explode("¬",utf8_decode($row[$i]["Evolucion"]));
        $reg = count($estructurahc)-1;
        for ($j=0; $j<$reg; $j++){
            $contenidohc = explode("^~",$estructurahc[$j]);
            switch($contenidohc[1]){
                case "TRUE":
                    $txtContenido = "SI";
                    break;
                case "true":
                    $txtContenido = "SI";
                    break;

                case "FALSE":
                    $txtContenido = "NO";
                    break;
                case "false":
                    $txtContenido = "NO";
                    break;

                default:
                    $txtContenido = $contenidohc[1];
                    break;
            }
            if(substr($contenidohc[0],0,31) == "str116APToxicosConsumoDrograsSO"){ 
                if($txtContenido != null && $txtContenido != "" && $txtContenido != " "){
                    $arrConsumoDroga[] = $txtContenido;
                }
            }
        }
    }
}
$resConsumoDroga = array_values(array_unique($arrConsumoDroga));
$pRegistros = count($resConsumoDroga);
$arrResultado = array();
for($i=0;$i<$pRegistros;$i++){
    $arrResultado[$i] = array('ConsumoDroga'=>$resConsumoDroga[$i], 'Personas'=>'0');
}
$pRegistros = count($arrResultado);
$PersonasNO = 0;
$PersonasSI = 0;
for($i=0;$i<$pRegistros;$i++){
    $arrResultado[$i]["Personas"] = DevolverElementos($arrConsumoDroga,$arrResultado[$i]["ConsumoDroga"]);
    //echo $arrResultado[$i]["EstadoCivil"] . " : " . $arrResultado[$i]["Personas"] . " --- ";
    $arrData[] = $arrResultado[$i]["Personas"];
    $arrLabels[] = $arrResultado[$i]["ConsumoDroga"];
    if($arrResultado[$i]["ConsumoDroga"] == "SI"){
        $PersonasSI += $arrResultado[$i]["Personas"];
    }else{
        $PersonasNO += $arrResultado[$i]["Personas"];
    }
    $totalPac += $arrResultado[$i]["Personas"];
}
if($totalPac == 0){
    $totalPac = 1;
}
$mostrarHC = '<span style="font-size:33px; color:#000;"><b>3.10 DISTRIBUCION PORCENTUAL SEGUN CONSUMO DE DROGA ALUCINOGENA</b></span><br><br>';
if($PersonasNO > 0){
    $mostrarHC .= '<span style="font-size:29px; color:#000;">En cuanto al consumo de droga alucinogena, el ' . number_format((($PersonasNO/$totalPac)*100),2,".",",") . '% de los trabajadores manifiesta no haber consumido droga alucinogena alguna vez es su vida</span>';
    if($PersonasSI > 0){
        $mostrarHC .= '<span style="font-size:29px; color:#000;">, y el ' . number_format((($PersonasSI/$totalPac)*100),2,".",",") . '% de los trabajadores actualmente consume drogras alucinogenas</span>';    
    }
    $mostrarHC .= '<span style="font-size:29px; color:#000;">.</span>';    
}else{
    if($PersonasSI > 0){
        $mostrarHC .= '<span style="font-size:29px; color:#000;">El ' . number_format((($PersonasSI/$totalPac)*100),2,".",",") . '% de los trabajadores actualmente consume drogras alucinogenas.</span>';    
    }
}
$pdf->writeHTML($mostrarHC, true, false, false, false, '');
if ($pdf->GetY() >= ($pdf->getPageHeight()-$pControlSalto)){
    EncabezadoPagina($pdf);
}
Draw003General($arrData,$arrLabels,"10");
$mostrarHC = '<center><table width="700" border="0" cellpadding="5">';
$mostrarHC .= '<tr>';
$mostrarHC .= '<td colspan="3" align="center"><span style="font-size:29px; color:#000;">TABLA Y GRAFICO 10. SEGUN CONSUMO DE DROGA ALUCINOGENA</span></td>';
$mostrarHC .= '</tr>';
$mostrarHC .= '<tr>';
$mostrarHC .= '<td width="3"></td>';
$mostrarHC .= '<td width="300">';
$mostrarHC .= '<table cellpadding="5" border="1">';
$mostrarHC .= '<tr style="background-color:#F2F2F2;" align="center">';
$mostrarHC .= '<td><b>CONSUMO DE DROGA</b></td>';
$mostrarHC .= '<td><b>Nro PERSONAS</b></td>';
$mostrarHC .= '<td><b>%</b></td>';
$mostrarHC .= '</tr>';
for($i=0;$i<$pRegistros;$i++){
    $mostrarHC .= '<tr>';
    $mostrarHC .= '<td>' . $arrResultado[$i]["ConsumoDroga"] . '</td>';
    $mostrarHC .= '<td align="center">' . $arrResultado[$i]["Personas"] .'</td>';
    $mostrarHC .= '<td align="center">' . number_format(($arrResultado[$i]["Personas"]/$totalPac)*100,2,".",",") . '</td>';
    $totalPorcentaje += number_format(($arrResultado[$i]["Personas"]/$totalPac)*100,2,".",",");
    $mostrarHC .= '</tr>';
}
$mostrarHC .= '<tr>';
$mostrarHC .= '<td>TOTAL</td>';
$mostrarHC .= '<td align="center">' . $totalPac .'</td>';
$mostrarHC .= '<td align="center">' . round($totalPorcentaje) . '</td>';
$mostrarHC .= '</tr>';
$mostrarHC .= '</table>';
$mostrarHC .= '</td>';
$mostrarHC .= '<td width="450" align="center">';
$mostrarHC .= '<img src="chart010.png" width="330" height="120"/>';
$mostrarHC .= '</td>';
$mostrarHC .= '</tr>';
$mostrarHC .= '</table></center>';
$pdf->writeHTML($mostrarHC, true, false, false, false, '');
unset($row);
unset($arrData);
unset($arrLabels);
unset($arrConsumoDroga);
unset($resConsumoDroga);
unset($arrResultado);

///////////////////////////////////////////////////
unset($row);
unset($arrData);
unset($arrLabels);
unset($arrPracticaDeporte);
unset($resPracticaDeporte);
unset($arrResultado);
$gBaseDatos = new ofiMySQLi();
$gBaseDatos->conectar();
$qry = "CALL sp_macroinformes_saludocupa002_infgen003('" . $pEmpresa . "','" . $pIPS . "','" . $pCliente . "','" . $pPlan . "','" . $pSubPlan . "','" . $pContrato . "',\"" . $pDesde . "\",\"" . $pHasta . "\")";
//echo $qry;
$gBaseDatos->QryID = @mysqli_query($gBaseDatos->ConexionID, $qry);
while ($row[] = @mysqli_fetch_assoc($gBaseDatos->QryID));
$gBaseDatos->liberar();
$gBaseDatos->cerrar();
$pRegistros = count($row);
$totalPac = 0;
$totalPorcentaje = 0;
for($i=0;$i<$pRegistros;$i++){
    if($row[$i]["Evolucion"] != null && $row[$i]["Evolucion"] != ""){
        $estructurahc = explode("¬",utf8_decode($row[$i]["Evolucion"]));
        $reg = count($estructurahc)-1;
        for ($j=0; $j<$reg; $j++){
            $contenidohc = explode("^~",$estructurahc[$j]);
            switch($contenidohc[1]){
                case "TRUE":
                    $txtContenido = "SI";
                    break;
                case "true":
                    $txtContenido = "SI";
                    break;

                case "FALSE":
                    $txtContenido = "NO";
                    break;
                case "false":
                    $txtContenido = "NO";
                    break;

                default:
                    $txtContenido = $contenidohc[1];
                    break;
            }
            if(substr($contenidohc[0],0,15) == "str229APDeporte"){ 
                if($txtContenido != null && $txtContenido != "" && $txtContenido != " "){
                    $arrPracticaDeporte[] = $txtContenido;
                }
            }
        }
    }
}
$resPracticaDeporte = array_values(array_unique($arrPracticaDeporte));
$pRegistros = count($resPracticaDeporte);
$arrResultado = array();
for($i=0;$i<$pRegistros;$i++){
    $arrResultado[$i] = array('PracticaDeporte'=>$resPracticaDeporte[$i], 'Personas'=>'0');
}
$pRegistros = count($arrResultado);
$PersonasNO = 0;
$PersonasSI = 0;
for($i=0;$i<$pRegistros;$i++){
    $arrResultado[$i]["Personas"] = DevolverElementos($arrPracticaDeporte,$arrResultado[$i]["PracticaDeporte"]);
    //echo $arrResultado[$i]["EstadoCivil"] . " : " . $arrResultado[$i]["Personas"] . " --- ";
    $arrData[] = $arrResultado[$i]["Personas"];
    $arrLabels[] = $arrResultado[$i]["PracticaDeporte"];
    if($arrResultado[$i]["PracticaDeporte"] == "SI"){
        $PersonasSI += $arrResultado[$i]["Personas"];
    }else{
        $PersonasNO += $arrResultado[$i]["Personas"];
    }
    $totalPac += $arrResultado[$i]["Personas"];
}
if($totalPac == 0){
    $totalPac = 1;
}
$mostrarHC = '<span style="font-size:33px; color:#000;"><b>3.11 DISTRIBUCION PORCENTUAL SEGUN PRACTICA ACTIVIDAD DEPORTIVA</b></span><br><br>';
if($PersonasNO > 0){
    $mostrarHC .= '<span style="font-size:29px; color:#000;">En cuanto al habito de practicar algún deporte observamos que el ' . number_format((($PersonasNO/$totalPac)*100),2,".",",") . '% de los examinados refiere no practicar ningun deporte</span>';
    if($PersonasSI > 0){
        $mostrarHC .= '<span style="font-size:29px; color:#000;">, y el ' . number_format((($PersonasSI/$totalPac)*100),2,".",",") . '% de los examinados actualmente practica deporte</span>';    
    }
    $mostrarHC .= '<span style="font-size:29px; color:#000;">.</span>';    
}else{
    if($PersonasSI > 0){
        $mostrarHC .= '<span style="font-size:29px; color:#000;">El ' . number_format((($PersonasSI/$totalPac)*100),2,".",",") . '% de los examinados actualmente practica deporte.</span>';    
    }
}
$pdf->writeHTML($mostrarHC, true, false, false, false, '');
if ($pdf->GetY() >= ($pdf->getPageHeight()-$pControlSalto)){
    EncabezadoPagina($pdf);
}
Draw003General($arrData,$arrLabels,"11");
$mostrarHC = '<center><table width="700" border="0" cellpadding="5">';
$mostrarHC .= '<tr>';
$mostrarHC .= '<td colspan="3" align="center"><span style="font-size:29px; color:#000;">TABLA Y GRAFICO 11. SEGUN PRACTICA ACTIVIDAD DEPORTIVA</span></td>';
$mostrarHC .= '</tr>';
$mostrarHC .= '<tr>';
$mostrarHC .= '<td width="3"></td>';
$mostrarHC .= '<td width="300">';
$mostrarHC .= '<table cellpadding="5" border="1">';
$mostrarHC .= '<tr style="background-color:#F2F2F2;" align="center">';
$mostrarHC .= '<td><b>CONSUMO DE DROGA</b></td>';
$mostrarHC .= '<td><b>Nro PERSONAS</b></td>';
$mostrarHC .= '<td><b>%</b></td>';
$mostrarHC .= '</tr>';
for($i=0;$i<$pRegistros;$i++){
    $mostrarHC .= '<tr>';
    $mostrarHC .= '<td>' . $arrResultado[$i]["PracticaDeporte"] . '</td>';
    $mostrarHC .= '<td align="center">' . $arrResultado[$i]["Personas"] .'</td>';
    $mostrarHC .= '<td align="center">' . number_format(($arrResultado[$i]["Personas"]/$totalPac)*100,2,".",",") . '</td>';
    $totalPorcentaje += number_format(($arrResultado[$i]["Personas"]/$totalPac)*100,2,".",",");
    $mostrarHC .= '</tr>';
}
$mostrarHC .= '<tr>';
$mostrarHC .= '<td>TOTAL</td>';
$mostrarHC .= '<td align="center">' . $totalPac .'</td>';
$mostrarHC .= '<td align="center">' . round($totalPorcentaje) . '</td>';
$mostrarHC .= '</tr>';
$mostrarHC .= '</table>';
$mostrarHC .= '</td>';
$mostrarHC .= '<td width="450" align="center">';
$mostrarHC .= '<img src="chart011.png" width="330" height="120"/>';
$mostrarHC .= '</td>';
$mostrarHC .= '</tr>';
$mostrarHC .= '</table></center>';
$pdf->writeHTML($mostrarHC, true, false, false, false, '');
unset($row);
unset($arrData);
unset($arrLabels);
unset($arrPracticaDeporte);
unset($resPracticaDeporte);
unset($arrResultado);

///////////////////////////////////////////////////
unset($row);
unset($arrData);
unset($arrLabels);
unset($arrCasosMorbilidad);
unset($resCasosMorbilidad);
unset($arrResultado);
$gBaseDatos = new ofiMySQLi();
$gBaseDatos->conectar();
$qry = "CALL sp_macroinformes_saludocupa002_infgen004('" . $pEmpresa . "','" . $pIPS . "','" . $pCliente . "','" . $pPlan . "','" . $pSubPlan . "','" . $pContrato . "',\"" . $pDesde . "\",\"" . $pHasta . "\")";
//echo $qry;
$gBaseDatos->QryID = @mysqli_query($gBaseDatos->ConexionID, $qry);
while ($row[] = @mysqli_fetch_assoc($gBaseDatos->QryID));
$gBaseDatos->liberar();
$gBaseDatos->cerrar();
$pRegistros = count($row);
$totalPac = 0;
$totalPorcentaje = 0;
$mostrarHC = '<span style="font-size:33px; color:#000;"><b>3.12 DISTRIBUCION PORCENTUAL SEGUN PRINCIPALES DIAGNOSTICOS</b></span><br><br>';
$mostrarHC .= '<span style="font-size:29px; color:#000;">Al evaluar los siguientes resultados debe tenerse en cuenta que se toman las 10 primeras causas de morbilidad y el numero puede superar el total de personas, debido a que puede presentarse más de un diagnostico en cada una de ellas.</span>';
$pdf->writeHTML($mostrarHC, true, false, false, false, '');
if ($pdf->GetY() >= ($pdf->getPageHeight()-$pControlSalto)){
    EncabezadoPagina($pdf);
}
for($i=0;$i<$pRegistros;$i++){
    if($row[$i]["Descripcion"] != null && $row[$i]["Descripcion"] != ""){
        $totalPac += $row[$i]["Casos"];
    }
}
if($totalPac == 0){
    $totalPac = 1;
}
$mostrarHC = '<center><table width="700" border="1" cellpadding="5">';
$mostrarHC .= '<tr>';
$mostrarHC .= '<td colspan="3" align="center" style="border-style: none;"><span style="font-size:29px; color:#000;">TABLA 12. SEGUN PRINCIPALES DIAGNOSTICOS</span></td>';
$mostrarHC .= '</tr>';
$mostrarHC .= '<tr>';
$mostrarHC .= '<td width="500" align="center"><b>DIAGNOSTICO</b></td>';
$mostrarHC .= '<td width="100" align="center"><b>Nro PERSONAS</b></td>';
$mostrarHC .= '<td width="100" align="center"><b>%</b></td>';
$mostrarHC .= '</tr>';
for($i=0;$i<$pRegistros;$i++){
    if($row[$i]["Descripcion"] != null && $row[$i]["Descripcion"] != ""){
        $mostrarHC .= '<tr>';
        $mostrarHC .= '<td>' . $row[$i]["Codigo"] . " - " . $row[$i]["Descripcion"] . '</td>';
        $mostrarHC .= '<td align="center">' . $row[$i]["Casos"] .'</td>';
        $mostrarHC .= '<td align="center">' . number_format(($row[$i]["Casos"]/$totalPac)*100,2,".",",") . '</td>';
        $totalPorcentaje += number_format(($row[$i]["Casos"]/$totalPac)*100,2,".",",");
        $mostrarHC .= '</tr>';
    }
}
$mostrarHC .= '<tr>';
$mostrarHC .= '<td>TOTAL</td>';
$mostrarHC .= '<td align="center">' . $totalPac .'</td>';
$mostrarHC .= '<td align="center">' . round($totalPorcentaje) . '</td>';
$mostrarHC .= '</tr>';
$mostrarHC .= '</table></center>';
$pdf->writeHTML($mostrarHC, true, false, false, false, '');
unset($row);
unset($arrData);
unset($arrLabels);
unset($arrCasosMorbilidad);
unset($resCasosMorbilidad);
unset($arrResultado);
///////////////////////////////////////////////////

$pdf->Output('infFinalSaludOcupacional.pdf', 'I');

function EncabezadoPagina(&$pdf){
    $pdf->AddPage();
    $pdf->Ln(0.5);
    //$img_file = "../../../empresas/" . $_SESSION['ID_EMPRESA'] . "/logo/fondofac.png";
    //$pdf->Image($img_file, $pdf->GetX()+45, $pdf->GetY()+95, 90, 50, '', '', '', false, 300, '', false, false, 0);
    $pdf->SetFont(PDF_FONT_NAME_MAIN, '', 7);
    $EncabezadoHTML = '<table cellspacing="0" border="0" style="font-size:24px; color:#000;">';
    $EncabezadoHTML .= '<tr>';
    $EncabezadoHTML .= '<td>';
    $EncabezadoHTML .= '<span style="font-size:44px; color:#000; font-weight:bold">' . utf8_decode($pdf->pNomEmpresa) . '</span><br>';
    if($pdf->pEspEmpresa != null || $pdf->pEspEmpresa != "")
            $EncabezadoHTML .= '<span style="font-size:34px; color:#000;">' . utf8_decode($pdf->pEspEmpresa) . '</span><br>';
    if($pdf->pTDocEmpresa == "NI"){
        $tipodoc = "NIT: ";
        $EncabezadoHTML .= '<span style="font-size:34px; color:#000;">' . $tipodoc . $pdf->pDocEmpresa . '</span><br>';
    }
    $EncabezadoHTML .= '<span style="font-size:34px; color:#000;">Cel: ' . $pdf->pTelEmpresa . '</span><br>';
    $EncabezadoHTML .= '<span style="font-size:34px; color:#000;">' . $pdf->pCiuEmpresa . '</span>';
    $EncabezadoHTML .= '</td>';

    //COL2
    $EncabezadoHTML .= '<td align="right">';
    if (file_exists("../../../empresas/" . $_SESSION['ID_EMPRESA'] . "/logo/logoenc.gif")) {
        $EncabezadoHTML .= '<img src="../../../empresas/' . $_SESSION['ID_EMPRESA'] . '/logo/logoenc.gif" align="right"/>';
        $EncabezadoHTML .= '<br>';
    }
    $EncabezadoHTML .= 'ANEXO RESULTADOS';
    $EncabezadoHTML .= '</td>';
    $EncabezadoHTML .= '</tr>';
    $EncabezadoHTML .= '</table>';
    $pdf->writeHTML($EncabezadoHTML, true, false, false, false, '');
}

?>