<?php
    set_time_limit(500);
    require_once('../../../../lib/tcpdf/config/lang/spa.php');
    require_once('../../../../lib/tcpdf/tcpdf.php');
    require("../../../../core/php/_database.php");
    require("../../../../core/php/php_functions.php");
    header('Content-type: application/pdf; charset: UTF-8');
    
    $estructura = explode("¬", $_REQUEST['param']);
    $pNomParametros = spNomParametrosMI($estructura,"NO");
    $NameParam = explode("¬", $pNomParametros);
    $pParametros = spParametrosMI($estructura,"NO");
    $DataParam = explode("¬", $pParametros);
    
    $items = count($NameParam);
    for ($i=0; $i<$items; $i++)
    {
        switch ($NameParam[$i]) 
        {
            case "intEmpresa":
                if ($DataParam[$i] == "" || $DataParam[$i] == null || $DataParam[$i] == "null")
                    $pEmpresa = 0;
                else
                    $pEmpresa = $DataParam[$i];
                break;
                
            case "intIPS":
                if ($DataParam[$i] == "" || $DataParam[$i] == null || $DataParam[$i] == "null")
                    $pIPS = 0;
                else
                    $pIPS = $DataParam[$i];
                break;
                
            case "intCliente":
                if ($DataParam[$i] == "" || $DataParam[$i] == null || $DataParam[$i] == "null")
                    $pCliente = 0;
                else
                    $pCliente = $DataParam[$i];
                break;
                
            case "intPlan":
                if ($DataParam[$i] == "" || $DataParam[$i] == null || $DataParam[$i] == "null")
                    $pPlan = 0;
                else
                    $pPlan = $DataParam[$i];
                break;
                
            case "intSubPlan":
                if ($DataParam[$i] == "" || $DataParam[$i] == null || $DataParam[$i] == "null")
                    $pSubPlan = 0;
                else
                    $pSubPlan = $DataParam[$i];
                break;
                
            case "fecDesde":
                if ($DataParam[$i] == "" || $DataParam[$i] == null || $DataParam[$i] == "null")
                {    
                    $pDesde = date('Y-m-d');
                }else{
                    $pDesde = $DataParam[$i];
                }
                break;
                
            case "fecHasta":
                if ($DataParam[$i] == "" || $DataParam[$i] == null || $DataParam[$i] == "null")
                {
                    $pHasta = date('Y-m-d');
                }else{
                    $pHasta = $DataParam[$i];
                }
                break;
                
            case "strCampo1":
                if ($DataParam[$i] == "" || $DataParam[$i] == null || $DataParam[$i] == "null")
                {
                    $pCampo1 = 'NO';
                }else{
                    $pCampo1 = $DataParam[$i];
                }
                break;
            
            case "strCampo2":
                if ($DataParam[$i] == "" || $DataParam[$i] == null || $DataParam[$i] == "null")
                {
                    $pCampo2 = 'NO';
                }else{
                    $pCampo2 = $DataParam[$i];
                }
                break;
            
            case "strCampo3":
                if ($DataParam[$i] == "" || $DataParam[$i] == null || $DataParam[$i] == "null")
                {
                    $pCampo3 = 'NO';
                }else{
                    $pCampo3 = $DataParam[$i];
                }
                break;
            
            case "intContrato":
                if ($DataParam[$i] == "" || $DataParam[$i] == null || $DataParam[$i] == "null")
                {
                    $pContrato = 0;
                }else{
                    $pContrato = $DataParam[$i];
                }
                break;
                
            case "strPaciente":
                if ($DataParam[$i] == "" || $DataParam[$i] == null || $DataParam[$i] == "null")
                {
                    $pPaciente = 'Todos';
                }else{
                    $pPaciente = $DataParam[$i];
                }
                break;
                
            case "strAutorizacion":
                if ($DataParam[$i] == "" || $DataParam[$i] == null || $DataParam[$i] == "null")
                {
                    $pAutorizacion = 'Todos';
                }else{
                    $pAutorizacion = $DataParam[$i];
                }
                break;
            
            default:
                break;
        }
    }
    $qry = "CALL sp_macroinformes_morbilidad_causas('" . $pEmpresa . "','" . $pIPS . "','" . $pCliente . "','" . $pPlan . "','" . $pSubPlan . "','" . $pContrato . "',\"" . $pPaciente . "\",\"" . $pAutorizacion . "\",\"" . $pDesde . "\",\"" . $pHasta . "\",\"" . $pCampo1 . "\",\"" . $pCampo2 . "\",\"" . $pCampo3 . "\")";
    // create new PDF document
    $pdf = new TCPDF("L", PDF_UNIT, "CARTA", true, 'UTF-8', false);
    // set document information
    $pdf->SetCreator(PDF_CREATOR);
    $pdf->SetAuthor('Sistemas Ofisalud © - 2006');
    $pdf->SetTitle('MORBILIDAD');
    $pdf->SetSubject('Informe Causas de Morbilidad');
    // set default header data
    session_start();
    $pdf->pAlineacionEncabezado = "L";
    $pdf->pTituloInforme = "CAUSAS DE MORBILIDAD";
    $pdf->pImprimeLogo = "NO";
    $pdf->pAnchoTxtPagina = 270;
    $pdf->pNomEmpresa = $_SESSION['NOM_EMPRESA'];
    $pdf->pNomSede = $_SESSION['NOM_SEDE'];
    $pdf->pNomIPS = $_SESSION['NOM_IPS'];
    $pdf->pMargenPie = -20;
    if($_SESSION['IdAplicacion'] == "OfiMedical"){
        $pdf->pLogoCliente = "../../../consultoriovirtual/" . $_SESSION['IDBD'] . "/logo/logoenc.gif";
    }else{
        $pdf->pLogoCliente = "../../../empresas/" . $_SESSION['ID_EMPRESA'] . "/logo/logoenc.gif";
    }
    $pdf->SetHeaderData($pdf->pLogoCliente, PDF_HEADER_LOGO_WIDTH, $pdf->pTituloInforme, PDF_HEADER_STRING);
    // set header and footer fonts
    $pdf->setHeaderFont(Array(PDF_FONT_NAME_MAIN, '', PDF_FONT_SIZE_MAIN));
    $pdf->setFooterFont(Array(PDF_FONT_NAME_DATA, '', PDF_FONT_SIZE_DATA));
    // set default monospaced font
    $pdf->SetDefaultMonospacedFont(PDF_FONT_MONOSPACED);
    //set margins
    $pdf->SetMargins(PDF_MARGIN_LEFT, PDF_MARGIN_TOP, PDF_MARGIN_RIGHT);
    $pdf->SetHeaderMargin(PDF_MARGIN_HEADER);
    $pdf->SetFooterMargin(PDF_MARGIN_FOOTER);
    //set auto page breaks
    $pdf->SetAutoPageBreak(FALSE, PDF_MARGIN_BOTTOM);
    //set image scale factor
    $pdf->setImageScale(PDF_IMAGE_SCALE_RATIO);
    //set some language-dependent strings
    $pdf->setLanguageArray($l);
    // set default font subsetting mode
    $pdf->setFontSubsetting(true);
    $pdf->SetFont('dejavusans', '', 14, '', true);

    $gBaseDatos = new ofiMySQLi();
    $gBaseDatos->conectar();
    $gBaseDatos->QryID = @mysqli_query($gBaseDatos->ConexionID, $qry);
    while ($row[] = @mysqli_fetch_assoc($gBaseDatos->QryID));
    $pRegistros = count($row)-1;
    $gBaseDatos->liberar();
    $gBaseDatos->cerrar();
    EncabezadoPagina($pdf, $row, $i, $rowcount, $contador, $pDesde, $pHasta);
    
    for($i=0;$i<$pRegistros;$i++)
    {
        if($row[$i]["Descripcion"] != ""){
            $rowcount = max($pdf->getNumLines(utf8_decode($row[$i]["Descripcion"]),203),1)*4;
            $pdf->SetFont(PDF_FONT_NAME_MAIN, '', 9);
            EscribeDetalle($pdf, $row, $i, $rowcount, $contador);
            if (($pdf->GetY()+$rowcount) > 195)
            {
                EncabezadoPagina($pdf, $row, $i, $rowcount, $contador, $pDesde, $pHasta);
            }
        }
    }
    $pdf->Output('infCausasMorbilidad.pdf', 'I');

    function EncabezadoPagina(&$pdf, &$row, &$i, &$rowcount, &$contador, &$pDesde, &$pHasta){
        $pdf->AddPage();
        $pdf->SetFont(PDF_FONT_NAME_MAIN,'B',11);
        $pdf->MultiCell(264,10,"Periodo: " . $pDesde . " - " . $pHasta ,0,'L',0,0);
        EncabezadoColumnas($pdf);
    }
   
    function EncabezadoColumnas(&$pdf)
    {
        $pdf->SetFillColor(242 , 236, 236);
        $pdf->Ln(4.5);
        $pdf->SetFont(PDF_FONT_NAME_MAIN,'B',9);
        $pdf->MultiCell(30,5,"Codigo",1,'C',1,0);
        $pdf->MultiCell(203,5,"Descripcion",1,'C',1,0);
        $pdf->MultiCell(30,5,"Casos",1,'C',1,0);
        $pdf->Ln();
    }
    function EscribeDetalle(&$pdf, &$row, &$i, &$rowcount, &$contador)
    {
        $pdf->writeHTMLCell(30, $rowcount, '', '', $row[$i]["Codigo"], 0, 0, 0, true, 'C', true);
        $pdf->writeHTMLCell(203, $rowcount, '', '', $row[$i]["Descripcion"], 0, 0, 0, true, 'L', true);
        $pdf->writeHTMLCell(30, $rowcount, '', '', number_format($row[$i]["Casos"],0,".",","), 0, 0, 0, true, 'C', true);
        $pdf->Ln();
    }
    
?>