<?php
    session_start();
    set_time_limit(500);
    require_once('../../../../lib/tcpdf/config/lang/spa.php');
    require_once('../../../../lib/tcpdf/tcpdf.php');
    require("../../../../core/php/_database.php");
    require("../../../../core/php/php_functions.php");
    require("../../asistencial/formatoshc/formatosincapacidad.php");
    //header('Content-type: application/pdf; charset: UTF-8');

    $pConsultorioVirtual = $_SESSION['IDBD'];
    $nomEmpresa = $_SESSION['NOM_EMPRESA'];
    $nomUsuario = $_SESSION['NOM_USUARIO'];

    $estructura = explode("¬", $_REQUEST['param']);
    $pNomParametros = spNomParametrosMI($estructura,"NO");
    $NameParam = explode("¬", $pNomParametros);
    $pParametros = spParametrosMI($estructura,"NO");
    $DataParam = explode("¬", $pParametros);

    $items = count($NameParam);
    for ($i=0; $i<$items; $i++)
    {
        switch ($NameParam[$i])
        {
            case "intEmpresa":
                if ($DataParam[$i] == "" || $DataParam[$i] == null || $DataParam[$i] == "null")
                    $pEmpresa = 0;
                else
                    $pEmpresa = $DataParam[$i];
                break;

            case "intNroConsultas":
                if ($DataParam[$i] == "" || $DataParam[$i] == null || $DataParam[$i] == "null")
                    $pNroConsultas = 0;
                else
                    $pNroConsultas = $DataParam[$i];
                break;

            case "intIPS":
                if ($DataParam[$i] == "" || $DataParam[$i] == null || $DataParam[$i] == "null")
                    $pIPS = 0;
                else
                    $pIPS = $DataParam[$i];
                break;

            case "intCliente":
                if ($DataParam[$i] == "" || $DataParam[$i] == null || $DataParam[$i] == "null")
                    $pCliente = 0;
                else
                    $pCliente = $DataParam[$i];
                break;

            case "intPlan":
                if ($DataParam[$i] == "" || $DataParam[$i] == null || $DataParam[$i] == "null")
                    $pPlan = 0;
                else
                    $pPlan = $DataParam[$i];
                break;

            case "intSubPlan":
                if ($DataParam[$i] == "" || $DataParam[$i] == null || $DataParam[$i] == "null")
                    $pSubPlan = 0;
                else
                    $pSubPlan = $DataParam[$i];
                break;

            case "fecDesde":
                if ($DataParam[$i] == "" || $DataParam[$i] == null || $DataParam[$i] == "null")
                {
                    $pDesde = date('Y-m-d');
                }else{
                    $pDesde = $DataParam[$i];
                }
                break;

            case "fecHasta":
                if ($DataParam[$i] == "" || $DataParam[$i] == null || $DataParam[$i] == "null")
                {
                    $pHasta = date('Y-m-d');
                }else{
                    $pHasta = $DataParam[$i];
                }
                break;

            case "strCampo1":
                if ($DataParam[$i] == "" || $DataParam[$i] == null || $DataParam[$i] == "null")
                {
                    $pCampo1 = 'NO';
                }else{
                    $pCampo1 = $DataParam[$i];
                }
                break;

            case "strCampo2":
                if ($DataParam[$i] == "" || $DataParam[$i] == null || $DataParam[$i] == "null")
                {
                    $pCampo2 = 'NO';
                }else{
                    $pCampo2 = $DataParam[$i];
                }
                break;

            case "strCampo3":
                if ($DataParam[$i] == "" || $DataParam[$i] == null || $DataParam[$i] == "null")
                {
                    $pCampo3 = 'NO';
                }else{
                    $pCampo3 = $DataParam[$i];
                }
                break;

            case "intContrato":
                if ($DataParam[$i] == "" || $DataParam[$i] == null || $DataParam[$i] == "null")
                {
                    $pContrato = 0;
                }else{
                    $pContrato = $DataParam[$i];
                }
                break;

            case "strPaciente":
                if ($DataParam[$i] == "" || $DataParam[$i] == null || $DataParam[$i] == "null")
                {
                    $pPaciente = 'Todos';
                }else{
                    $pPaciente = $DataParam[$i];
                }
                break;

            case "strAutorizacion":
                if ($DataParam[$i] == "" || $DataParam[$i] == null || $DataParam[$i] == "null")
                {
                    $pAutorizacion = 'Todos';
                }else{
                    $pAutorizacion = $DataParam[$i];
                }
                break;

            default:
                break;
        }
    }

    //Definicion de las Margenes
    $LeftMargin = PDF_MARGIN_LEFT;
    $TopMargin = 5;
    $RightMargin = PDF_MARGIN_RIGHT;
    $HeaderMargin = PDF_MARGIN_HEADER;
    $BottomMargin = 3;
    $FooterMargin = 5;
    $Alineacion = "P";
    $FormatoPagina = "CARTA";
    $UsaPiePagina = "SI";
    $pTipoEncabezado = "FVP";
    $pControlSalto = 30;

    //Inicializacion de la Clase
    $pdf = new TCPDF($Alineacion, PDF_UNIT, $FormatoPagina, true, 'UTF-8', false);
    //Inicializacion Variables de Control
    $pdf->pAlineacionEncabezado = $Alineacion;
    $pdf->pTituloInforme = "HISTORIA CLINICA";
    $pdf->pImprimeLogo = "NO";
    $pdf->pAnchoTxtPagina = 210;
    $pdf->pNomEmpresa = $_SESSION['NOM_EMPRESA'];
    $pdf->pTDocEmpresa = $_SESSION['EMPRESA_TDOC'];
    $pdf->pDocEmpresa = $_SESSION['EMPRESA_DOC'];
    $pdf->pDirEmpresa = $_SESSION['EMPRESA_DIR'];
    $pdf->pTelEmpresa = $_SESSION['EMPRESA_TEL'];
    $pdf->pCiuEmpresa = $_SESSION['EMPRESA_CIU'];
    $pdf->pEspEmpresa = $_SESSION['EMPRESA_ESP'];
    $pdf->pRegEmpresa = $_SESSION['EMPRESA_REGIMEN'];
    $pdf->pContribuyentes = $_SESSION['EMPRESA_CONTRIBUYENTE'];
    $pdf->pReteIVA  = $_SESSION['EMPRESA_RTEICA'];
    $pdf->pReteICA = $_SESSION['EMPRESA_RTEIVA'];

    $pdf->pTipoEncabezado = $pTipoEncabezado;
    $pdf->pNomSede = $_SESSION['EMPRESA_DOC'];
    $pdf->pNomIPS = $_SESSION['NOM_IPS'];
    $pdf->pMargenPie = -20;
    if($_SESSION['IdAplicacion'] == "OfiMedical"){
        $pdf->pLogoCliente = "../../../consultoriovirtual/" . $_SESSION['IDBD'] . "/logo/logoenc.gif";
    }else{
        $pdf->pLogoCliente = "../../../empresas/" . $_SESSION['ID_EMPRESA'] . "/logo/logoenc.gif";
    }
    $pdf->pPrefijo = 1; //$row[0]["Prefijo"];
    $pdf->pNroDocumento = 1; //str_pad($row[0]["NroDocumento"], 7, "0", STR_PAD_LEFT);
    $pdf->pNroResolucion = 1; //$row[0]["NroResolucion"];
    $pdf->pFechaDoc = 1; //$row[0]["FechaDocumento"];
    $pdf->pCAS = null;
    $pdf->pTratamiento = null;
    $pdf->pUsaPie = $UsaPiePagina;

    $pdf->SetCreator(PDF_CREATOR);
    $pdf->SetAuthor('Sistemas Ofisalud © - 2006');
    $pdf->SetTitle('OfiClinic©');
    $pdf->SetSubject('Soporte Historia Clinica');

    $pdf->SetHeaderData($pdf->pLogoCliente, PDF_HEADER_LOGO_WIDTH, $pdf->pTituloInforme, PDF_HEADER_STRING);
    $pdf->setHeaderFont(Array(PDF_FONT_NAME_MAIN, '', PDF_FONT_SIZE_MAIN));
    $pdf->setFooterFont(Array(PDF_FONT_NAME_DATA, '', PDF_FONT_SIZE_DATA));
    $pdf->SetDefaultMonospacedFont(PDF_FONT_MONOSPACED);
    $pdf->SetMargins($LeftMargin, $TopMargin, $RightMargin);
    $pdf->SetHeaderMargin($HeaderMargin);
    $pdf->SetFooterMargin($FooterMargin);
    // set bacground image

    $pdf->SetAutoPageBreak(TRUE, $BottomMargin);
    $pdf->setImageScale(PDF_IMAGE_SCALE_RATIO);
    $pdf->setLanguageArray($l);
    $pdf->setFontSubsetting(true);
    $pdf->SetFont('dejavusans', '', 14, '', true);

    $gBaseDatos = new ofiMySQLi();
    $gBaseDatos->conectar();
    $qry = "CALL sp_macroinformes_general_formatoincapacidad('" . $pEmpresa . "','" . $pIPS . "','" . $pCliente . "',\"" . $pPaciente . "\",\"" . $pDesde . "\",\"" . $pHasta . "\")";
    $gBaseDatos->QryID = @mysqli_query($gBaseDatos->ConexionID, $qry);
    while ($row[] = @mysqli_fetch_assoc($gBaseDatos->QryID));
    $gBaseDatos->liberar();
    $gBaseDatos->cerrar();
    $pRegistros = count($row);
    for($i=0;$i<$pRegistros;$i++){
        $nomImpresor = "FormatoGeneral";
        @call_user_func_array($nomImpresor, array(&$pdf, $row[$i]["Prestador"], $row[$i]["IPS"],$row[$i]["Paciente"],$row[$i]["ConsecutivoHC"],$_SESSION['IdAplicacion']));
    }

    $pdf->Output('infSoporteIncapacidad.pdf', 'I');

?>