<?php
    require_once('../../../../lib/tcpdf/config/lang/spa.php');
    require_once('../../../../lib/tcpdf/tcpdf.php');
    require("../../../../core/php/_database.php");
    require("../../../../core/php/php_functions.php");
    header('Content-type: application/pdf; charset: UTF-8');
    
    $estructura = explode("¬", $_REQUEST['param']);
    $pNomParametros = spNomParametrosMI($estructura,"NO");
    $NameParam = explode("¬", $pNomParametros);
    $pParametros = spParametrosMI($estructura,"NO");
    $DataParam = explode("¬", $pParametros);
    
    $items = count($NameParam);
    for ($i=0; $i<$items; $i++)
    {
        switch ($NameParam[$i]) 
        {
            case "intEmpresa":
                if ($DataParam[$i] == "" || $DataParam[$i] == null || $DataParam[$i] == "null")
                    $pEmpresa = 0;
                else
                    $pEmpresa = $DataParam[$i];
                break;
                
            case "intIPS":
                if ($DataParam[$i] == "" || $DataParam[$i] == null || $DataParam[$i] == "null")
                    $pIPS = 0;
                else
                    $pIPS = $DataParam[$i];
                break;
                
            case "intCliente":
                if ($DataParam[$i] == "" || $DataParam[$i] == null || $DataParam[$i] == "null")
                    $pCliente = 0;
                else
                    $pCliente = $DataParam[$i];
                break;
                
            case "intPlan":
                if ($DataParam[$i] == "" || $DataParam[$i] == null || $DataParam[$i] == "null")
                    $pPlan = 0;
                else
                    $pPlan = $DataParam[$i];
                break;
                
            case "intSubPlan":
                if ($DataParam[$i] == "" || $DataParam[$i] == null || $DataParam[$i] == "null")
                    $pSubPlan = 0;
                else
                    $pSubPlan = $DataParam[$i];
                break;
                
            case "fecDesde":
                if ($DataParam[$i] == "" || $DataParam[$i] == null || $DataParam[$i] == "null")
                {    
                    $pDesde = date('Y-m-d');
                }else{
                    $pDesde = $DataParam[$i];
                }
                break;
                
            case "fecHasta":
                if ($DataParam[$i] == "" || $DataParam[$i] == null || $DataParam[$i] == "null")
                {
                    $pHasta = date('Y-m-d');
                }else{
                    $pHasta = $DataParam[$i];
                }
                break;
                
            case "strCampo1":
                if ($DataParam[$i] == "" || $DataParam[$i] == null || $DataParam[$i] == "null")
                {
                    $pCampo1 = 'NO';
                }else{
                    $pCampo1 = $DataParam[$i];
                }
                break;
            
            case "strCampo2":
                if ($DataParam[$i] == "" || $DataParam[$i] == null || $DataParam[$i] == "null")
                {
                    $pCampo2 = 'NO';
                }else{
                    $pCampo2 = $DataParam[$i];
                }
                break;
            
            case "strCampo3":
                if ($DataParam[$i] == "" || $DataParam[$i] == null || $DataParam[$i] == "null")
                {
                    $pCampo3 = 'NO';
                }else{
                    $pCampo3 = $DataParam[$i];
                }
                break;
            
            case "intContrato":
                if ($DataParam[$i] == "" || $DataParam[$i] == null || $DataParam[$i] == "null")
                {
                    $pContrato = 0;
                }else{
                    $pContrato = $DataParam[$i];
                }
                break;
                
            case "strPaciente":
                if ($DataParam[$i] == "" || $DataParam[$i] == null || $DataParam[$i] == "null")
                {
                    $pPaciente = 'Todos';
                }else{
                    $pPaciente = $DataParam[$i];
                }
                break;
                
            case "strAutorizacion":
                if ($DataParam[$i] == "" || $DataParam[$i] == null || $DataParam[$i] == "null")
                {
                    $pAutorizacion = 'Todos';
                }else{
                    $pAutorizacion = $DataParam[$i];
                }
                break;
            
            default:
                break;
        }
    }
    $pImprimeTirilla = "NO";
    $LeftMargin = PDF_MARGIN_LEFT;
    $TopMargin = 5;
    $RightMargin = PDF_MARGIN_RIGHT;
    $HeaderMargin = PDF_MARGIN_HEADER;
    $BottomMargin = 3;
    $FooterMargin = 5;
    $Alineacion = "P";
    $FormatoPagina = "CARTA";
    $UsaPiePagina = "SI";
    $pTipoEncabezado = "SIN";
    
    $qry = "CALL sp_facturacion_reldetallefactura('" . $pIPS . "','" . $pCliente . "','" . $pPlan . "','" . $pSubPlan . "','" . $pContrato . "',\"" . $pDesde . "\",\"" . $pHasta . "\",\"" . $pCampo1 . "\",\"" . $pCampo2 . "\",\"" . $pCampo3 . "\")";
    //echo $qry;
    
    //Inicializacion de la Clase
    $pdf = new TCPDF($Alineacion, PDF_UNIT, $FormatoPagina, true, 'UTF-8', false);
    //$pdf = new TCPDF("P", PDF_UNIT, "CARTA", true, 'UTF-8', false);
    
    // set document information
    $pdf->SetCreator(PDF_CREATOR);
    $pdf->SetAuthor('Sistemas Ofisalud © - 2006');
    $pdf->SetTitle('FACTURACION');
    $pdf->SetSubject('CUENTA DE COBRO');

    // set default header data
    $qry = "CALL sp_facturacion_reldetallefactura('" . $pIPS . "','" . $pCliente . "','" . $pPlan . "','" . $pSubPlan . "','" . $pContrato . "',\"" . $pDesde . "\",\"" . $pHasta . "\",\"" . $pCampo1 . "\",\"" . $pCampo2 . "\",\"" . $pCampo3 . "\")";
    //echo $qry;
    session_start();
    $pdf->pAlineacionEncabezado = "P";
    $pdf->pTituloInforme = "RELACION DETALLE POR FACTURA DE VENTA";
    $pdf->pTipoEncabezado = $pTipoEncabezado;
    $pdf->pImprimeLogo = "NO";
    $pdf->pAnchoTxtPagina = 140;
    $pdf->pNomEmpresa = $_SESSION['NOM_EMPRESA'];
    $pdf->pNomSede = $_SESSION['NOM_SEDE'];
    $pdf->pNomIPS = $_SESSION['NOM_IPS'];
    $pdf->pMargenPie = -20;
    if($_SESSION['IdAplicacion'] == "OfiMedical"){
        $pdf->pLogoCliente = "../../../consultoriovirtual/" . $_SESSION['IDBD'] . "/logo/logoenc.gif";
    }else{
        $pdf->pLogoCliente = "../../../empresas/" . $_SESSION['ID_EMPRESA'] . "/logo/logoenc.gif";
    }
    $pdf->SetHeaderData($pdf->pLogoCliente, PDF_HEADER_LOGO_WIDTH, $pdf->pTituloInforme, PDF_HEADER_STRING);
    // set header and footer fonts
    $pdf->setHeaderFont(Array(PDF_FONT_NAME_MAIN, '', PDF_FONT_SIZE_MAIN));
    $pdf->setFooterFont(Array(PDF_FONT_NAME_DATA, '', PDF_FONT_SIZE_DATA));
    // set default monospaced font
    $pdf->SetDefaultMonospacedFont(PDF_FONT_MONOSPACED);
    //set margins
    $pdf->SetMargins(PDF_MARGIN_LEFT, PDF_MARGIN_TOP, PDF_MARGIN_RIGHT);
    $pdf->SetHeaderMargin(PDF_MARGIN_HEADER);
    $pdf->SetFooterMargin(PDF_MARGIN_FOOTER);
    //set auto page breaks
    $pdf->SetAutoPageBreak(FALSE, PDF_MARGIN_BOTTOM);
    //set image scale factor
    $pdf->setImageScale(PDF_IMAGE_SCALE_RATIO);
    //set some language-dependent strings
    $pdf->setLanguageArray($l);
    // set default font subsetting mode
    $pdf->setFontSubsetting(true);
    $pdf->SetFont('dejavusans', '', 14, '', true);

    $idConcepto = "-1";
    $totSubTotal_c = 0;
    $totIVA_c = 0;
    $totCopagos_c = 0;
    $totDescuentos_c = 0;
    $totNeto_c = 0;
    $contador = 0;
    $pImprimePieConcepto = "No";
    $pUltimoRegistro = "No";
    
    $gBaseDatos = new ofiMySQLi();
    $gBaseDatos->conectar();
    $qry = "CALL sp_facturacion_reldetallefactura('" . $pIPS . "','" . $pCliente . "','" . $pPlan . "','" . $pSubPlan . "','" . $pContrato . "',\"" . $pDesde . "\",\"" . $pHasta . "\",\"" . $pCampo1 . "\",\"" . $pCampo2 . "\",\"" . $pCampo3 . "\")";
    unset($row);
    $gBaseDatos->QryID = @mysqli_query($gBaseDatos->ConexionID, $qry);
    while ($row[] = @mysqli_fetch_assoc($gBaseDatos->QryID));
    $pRegistros = count($row)-1;
    $gBaseDatos->liberar(); 
    $gBaseDatos->cerrar();
    $ValorTotalCuenta = 0;
    for($i=0;$i<$pRegistros;$i++){
        $ValorTotalCuenta += $row[$i]["VlrNeto"];
    }
    $pdf->AddPage();
    $idConcepto = "";
    for($i=0;$i<$pRegistros;$i++){
        if($row[$i]["NroDocumento"] != ""){
            if ($idConcepto != $row[$i]["NroDocumento"]){
                $rowcount = 0;
                EncabezadoPagina($pdf, $row, $i, $rowcount, $contador, $pDesde, $pHasta,"NO");
            }else{
                if ($pdf->GetY() >= ($pdf->getPageHeight()-20)){
                    EncabezadoPagina($pdf, $row, $i, $rowcount, $contador, $pDesde, $pHasta,"SI");
                }
            }
            $contador ++;
            $pdf->SetFont(PDF_FONT_NAME_MAIN, '', 7);
            EscribeDetalle($pdf, $row, $i, $rowcount, $contador);
        }
        $idConcepto = $row[$i]["NroDocumento"];
    }
    $pdf->Ln();
    $pdf->Ln();
    $pdf->Output('infDetallexFacturaVenta.pdf', 'I');
    
    
    function EncabezadoPagina(&$pdf, &$row, &$i, &$rowcount, &$contador, &$pDesde, &$pHasta, $AddPagina){
        $pdf->SetFont(PDF_FONT_NAME_MAIN, '', 7);
        if($AddPagina == "SI"){
            $pdf->AddPage();
        }
        if ($pdf->GetY() >= ($pdf->getPageHeight()-40)){
            $pdf->AddPage();
        }
        if($rowcount == 0){
            $mostrarHC = '<table border="1" cellspacing="0" cellpadding="2">';
            $mostrarHC .= '<tr>';
            $mostrarHC .= '<td width="470">';
            $mostrarHC .= '<b>FACTURA: </b>' . $row[$i]["NroDocumento"] . '  - <b>FECHA: </b>' . $row[$i]["FechaDocumento"];
            $mostrarHC .= '</td>';
            $mostrarHC .= '<td width="110">';
            $mostrarHC .= '<b>TOTAL: </b>';
            $mostrarHC .= '</td>';
            $mostrarHC .= '<td align="rigth" width="140">';
            $mostrarHC .= '$ ' . number_format($row[$i]["TVlrTotal"],2,".",",");
            $mostrarHC .= '</td>';
            $mostrarHC .= '</tr>';
            $mostrarHC .= '<tr>';
            $mostrarHC .= '<td width="470">';
            $mostrarHC .= '<b>ENTIDAD: </b>' . $row[$i]["DesCliente"];
            $mostrarHC .= '</td>';
            $mostrarHC .= '<td width="110">';
            $mostrarHC .= '<b>IVA: </b>';
            $mostrarHC .= '</td>';
            $mostrarHC .= '<td align="rigth" width="140">';
            $mostrarHC .= '$ ' . number_format($row[$i]["TVlrIVA"],2,".",",");
            $mostrarHC .= '</td>';
            $mostrarHC .= '</tr>';
            $mostrarHC .= '<tr>';
            $mostrarHC .= '<td width="470">';
            $mostrarHC .= '<b>PLAN: </b>' . $row[$i]["DesPlan"];
            $mostrarHC .= '</td>';
            $mostrarHC .= '<td width="110">';
            $mostrarHC .= '<b>CUOTA MODERADORA: </b>';
            $mostrarHC .= '</td>';
            $mostrarHC .= '<td align="rigth" width="140">';
            $mostrarHC .= '$ ' . number_format($row[$i]["TCM"],2,".",",");
            $mostrarHC .= '</td>';
            $mostrarHC .= '</tr>';
            $mostrarHC .= '<tr>';
            $mostrarHC .= '<td width="470">';
            $mostrarHC .= '<b>SUBPLAN: </b>' . $row[$i]["DesSubPlan"];
            $mostrarHC .= '</td>';
            $mostrarHC .= '<td width="110">';
            $mostrarHC .= '<b>COPAGOS: </b>';
            $mostrarHC .= '</td>';
            $mostrarHC .= '<td align="rigth" width="140">';
            $mostrarHC .= '$ ' . number_format($row[$i]["TCOPAGOS"],2,".",",");
            $mostrarHC .= '</td>';
            $mostrarHC .= '</tr>';
            $mostrarHC .= '<tr>';
            $mostrarHC .= '<td width="470">';
            $mostrarHC .= '<b>PACIENTE: </b>' . $row[$i]["nomPaciente"];
            $mostrarHC .= '</td>';
            $mostrarHC .= '<td width="110">';
            $mostrarHC .= '<b>DESCUENTOS: </b>';
            $mostrarHC .= '</td>';
            $mostrarHC .= '<td align="rigth" width="140">';
            $mostrarHC .= '$ ' . number_format($row[$i]["TVlrDescuentos"],2,".",",");
            $mostrarHC .= '</td>';
            $mostrarHC .= '</tr>';
            $mostrarHC .= '<tr>';
            $mostrarHC .= '<td width="470">';
            $mostrarHC .= '<b>CAS: </b>' . $row[$i]["CAS"];
            $mostrarHC .= '</td>';
            $mostrarHC .= '<td width="110">';
            $mostrarHC .= '<b>NETO: </b>';
            $mostrarHC .= '</td>';
            $mostrarHC .= '<td align="rigth" width="140">';
            $mostrarHC .= '$ ' . number_format($row[$i]["TVlrNeto"],2,".",",");
            $mostrarHC .= '</td>';
            $mostrarHC .= '</tr>';
            $mostrarHC .= '</table>';
            $pdf->writeHTML($mostrarHC, true, false, false, false, '');
        }
        $pdf->Ln(-3);
        if ($pdf->GetY() >= ($pdf->getPageHeight()-20)){
            $pdf->AddPage();
        }
        $mostrarHC = '<table border="1" cellspacing="0" cellpadding="2">';
        if($rowcount == 1){
            $mostrarHC .= '<tr>';
            $mostrarHC .= '<td colspan="3" width="720">';
            $mostrarHC .= '<b>FACTURA: </b>' . $row[$i]["NroDocumento"] . '  - <b>FECHA: </b>' . $row[$i]["FechaDocumento"];
            $mostrarHC .= '</td>';
            $mostrarHC .= '</tr>';
        }
        $mostrarHC .= '<tr>';
        $mostrarHC .= '<td align="center" width="300"><b>DESCRIPCION</b></td>';
        $mostrarHC .= '<td align="center" width="40"><b>CANT</b></td>';
        $mostrarHC .= '<td align="center" width="100"><b>VLR UNITARIO</b></td>';
        $mostrarHC .= '<td align="center" width="105"><b>VLR TOTAL</b></td>';
        $mostrarHC .= '<td align="center" width="70"><b>CM/COPAGOS</b></td>';
        $mostrarHC .= '<td align="center" width="105"><b>NETO</b></td>';
        $mostrarHC .= '</tr>';
        $mostrarHC .= '</table>';
        $pdf->writeHTML($mostrarHC, true, false, false, false, '');
        $rowcount = 1;
    }
    
    function EscribeDetalle(&$pdf, &$row, &$i, &$rowcount, &$contador){
        if ($pdf->GetY() >= ($pdf->getPageHeight()-20)){
            EncabezadoPagina($pdf, $row, $i, $rowcount, $contador, $pDesde, $pHasta,"SI");
        }
        $pdf->SetFont(PDF_FONT_NAME_MAIN, '', 7);
        $pdf->Ln(-3);
        $AltoLinea = 0;
        $AltoLinea = max($pdf->getNumLines($row[$i]["CUPSCodigo"] . " - " . $row[$i]["DescProcedimiento"], 83),2)*5;
        $pdf->writeHTMLCell(85, $AltoLinea, '', '', $row[$i]["CUPSCodigo"] . " - " . $row[$i]["DescProcedimiento"], 0, 0, 0, true, 'L', true);
        $pdf->writeHTMLCell(11, $AltoLinea, '', '', $row[$i]["Cantidad"], 0, 0, 0, true, 'C', true);
        $pdf->writeHTMLCell(28, $AltoLinea, '', '', number_format($row[$i]["VlrActividad"],2,".",","), 0, 0, 0, true, 'R', true);
        $pdf->writeHTMLCell(30, $AltoLinea, '', '', number_format($row[$i]["VlrTotal"],2,".",","), 0, 0, 0, true, 'R', true);
        $pdf->writeHTMLCell(20, $AltoLinea, '', '', number_format(($row[$i]["VlrCuotaModeradora"] + $row[$i]["VlrCopagos"]),2,".",","), 0, 0, 0, true, 'R', true);
        $pdf->writeHTMLCell(30, $AltoLinea, '', '', number_format($row[$i]["VlrNeto"],2,".",","), 0, 0, 0, true, 'R', true);
        $pdf->Ln($AltoLinea);
        if ($pdf->GetY() >= ($pdf->getPageHeight()-20)){
            EncabezadoPagina($pdf, $row, $i, $rowcount, $contador, $pDesde, $pHasta,"SI");
        }
    }
        
?>
