<?php

set_time_limit(500);
require("../../../../core/php/_database.php");
require("../../../../core/php/php_functions.php");
require("../../../../core/php/constantes.php");

header("Content-Type: application/vnd.ms-excel");
header("Content-Disposition: attachment; filename=facturacionxtipoestudioxcliente.xls");
header("Pragma: no-cache");
header("Expires: 0");

session_start();
$nomEmpresa = $_SESSION['NOM_EMPRESA'];
$nomUsuario = $_SESSION['NOM_USUARIO'];

$estructura = explode("¬", $_REQUEST['param']);
$pNomParametros = spNomParametrosMI($estructura,"NO");
$NameParam = explode("¬", $pNomParametros);
$pParametros = spParametrosMI($estructura,"NO");
$DataParam = explode("¬", $pParametros);

$items = count($NameParam);
for ($i=0; $i<$items; $i++)
{
    switch ($NameParam[$i]) 
    {
        case "intEmpresa":
            if ($DataParam[$i] == "" || $DataParam[$i] == null || $DataParam[$i] == "null")
                $pEmpresa = 0;
            else
                $pEmpresa = $DataParam[$i];
            break;

        case "intIPS":
            if ($DataParam[$i] == "" || $DataParam[$i] == null || $DataParam[$i] == "null")
                $pIPS = 0;
            else
                $pIPS = $DataParam[$i];
            break;

        case "intCliente":
            if ($DataParam[$i] == "" || $DataParam[$i] == null || $DataParam[$i] == "null")
                $pCliente = 0;
            else
                $pCliente = $DataParam[$i];
            break;

        case "intPlan":
            if ($DataParam[$i] == "" || $DataParam[$i] == null || $DataParam[$i] == "null")
                $pPlan = 0;
            else
                $pPlan = $DataParam[$i];
            break;

        case "intSubPlan":
            if ($DataParam[$i] == "" || $DataParam[$i] == null || $DataParam[$i] == "null")
                $pSubPlan = 0;
            else
                $pSubPlan = $DataParam[$i];
            break;

        case "fecDesde":
            if ($DataParam[$i] == "" || $DataParam[$i] == null || $DataParam[$i] == "null")
            {    
                $pDesde = date('Y-m-d');
            }else{
                $pDesde = $DataParam[$i];
            }
            break;

        case "fecHasta":
            if ($DataParam[$i] == "" || $DataParam[$i] == null || $DataParam[$i] == "null")
            {
                $pHasta = date('Y-m-d');
            }else{
                $pHasta = $DataParam[$i];
            }
            break;

        case "strCampo1":
            if ($DataParam[$i] == "" || $DataParam[$i] == null || $DataParam[$i] == "null")
            {
                $pCampo1 = 'NO';
            }else{
                $pCampo1 = $DataParam[$i];
            }
            break;

        case "strCampo2":
            if ($DataParam[$i] == "" || $DataParam[$i] == null || $DataParam[$i] == "null")
            {
                $pCampo2 = 'NO';
            }else{
                $pCampo2 = $DataParam[$i];
            }
            break;

        case "strCampo3":
            if ($DataParam[$i] == "" || $DataParam[$i] == null || $DataParam[$i] == "null")
            {
                $pCampo3 = 'NO';
            }else{
                $pCampo3 = $DataParam[$i];
            }
            break;

        case "intProfesional":
            if ($DataParam[$i] == "" || $DataParam[$i] == null || $DataParam[$i] == "null")
            {
                $pProfesional = 0;
            }else{
                $pProfesional = $DataParam[$i];
            }
            break;

        case "intContrato":
            if ($DataParam[$i] == "" || $DataParam[$i] == null || $DataParam[$i] == "null")
            {
                $pContrato = 0;
            }else{
                $pContrato = $DataParam[$i];
            }
            break;

        case "strPaciente":
            if ($DataParam[$i] == "" || $DataParam[$i] == null || $DataParam[$i] == "null")
            {
                $pPaciente = 'Todos';
            }else{
                $pPaciente = $DataParam[$i];
            }
            break;

        case "strAutorizacion":
            if ($DataParam[$i] == "" || $DataParam[$i] == null || $DataParam[$i] == "null")
            {
                $pAutorizacion = 'Todos';
            }else{
                $pAutorizacion = $DataParam[$i];
            }
            break;
            
        case "strPlantillaHC":
            if ($DataParam[$i] == "" || $DataParam[$i] == null || $DataParam[$i] == "null")
            {
                $pPlantilla = 'Todos';
            }else{
                $pPlantilla = $DataParam[$i];
            }
            break;
            
        default:
            break;
    }
}
unset($row);
$gBaseDatos = new ofiMySQLi();
$gBaseDatos->conectar();
$qry = "CALL sp_macroinformes_facturacion_ventascec('" . $pIPS . "','" . $pCliente . "','" . $pPlan . "','" . $pSubPlan . "','" . $pContrato . "',\"" . $pDesde . "\",\"" . $pHasta . "\",\"" . $pCampo1 . "\",\"" . $pCampo2 . "\",\"" . $pCampo3 . "\")";
//echo $qry;
$gBaseDatos->QryID = @mysqli_query($gBaseDatos->ConexionID, $qry);
while ($row[] = @mysqli_fetch_assoc($gBaseDatos->QryID));
$gBaseDatos->liberar();
$gBaseDatos->cerrar();
$pRegistros = count($row);

echo "<table border=\"0\" align=\"left\">";
echo '<tr><td colspan = "6" style="color:#03F; font-size:20px">' . utf8_decode(ofiVERSION) . '</td></tr>';
echo '<tr><td colspan = "6">' . utf8_decode(ofiMAIL) . '</td></tr>';
echo '<tr><td colspan = "6" style="color:#03F; font-size:20px">RESUMEN DE VENTAS</td></tr>';
echo '<tr><td colspan = "6" style="color:#03F; font-size:18px">Periodo Desde: ' . $pDesde . ' - Hasta: ' . $pHasta . '</td></tr>';
echo '<tr><td colspan = "6" style="color:#900; font-size:16px">Empresa: ' . utf8_decode($nomEmpresa) . '</td></tr>';
echo '<tr><td colspan = "6" style="color:#900; font-size:14px">Usuario: ' . utf8_decode($nomUsuario) . '</td></tr>';
echo '<tr><td colspan = "6" style="color:#900; font-size:12px">Fecha/Hora: ' . date('d/m/Y h:i:s A') . '</td></tr>';
echo '<tr><td>&nbsp;</td></tr>';

echo "</table>";

echo "<table border=\"1\" align=\"left\">";
echo "<tr>";
echo "<th rowspan=\"2\">ENTIDAD</th>";
echo "<th rowspan=\"2\">FACT.No.</th>";
echo "<th rowspan=\"2\">RADICACION</th>";
echo "<th rowspan=\"2\">ESTUDIOS</th>";
echo "<th rowspan=\"2\">VALOR TOTAL</th>";
echo "<th rowspan=\"2\">COPAGOS</th>";
echo "<th rowspan=\"2\">VALOR NETO</th>";
echo "<th colspan=\"2\">BIOPSIA DE MAMA</th>"; //Aqui deben ser los tipos de estudio
echo "<th colspan=\"2\">BIOPSIA DE TIROIDES</th>"; //Aqui deben ser los tipos de estudio
echo "<th colspan=\"2\">OTRAS BIOPSIAS</th>"; //Aqui deben ser los tipos de estudio
echo "<th colspan=\"2\">DRENAJES ESPECIALES</th>"; //Aqui deben ser los tipos de estudio
echo "<th colspan=\"2\">ECODOPPLER</th>"; //Aqui deben ser los tipos de estudio
echo "<th colspan=\"2\">ECOGRAFIA</th>"; //Aqui deben ser los tipos de estudio
echo "<th colspan=\"2\">MAMOGRAFIA</th>"; //Aqui deben ser los tipos de estudio
echo "<th colspan=\"2\">RADIOLOGIA</th>"; //Aqui deben ser los tipos de estudio
echo "</tr>";
echo "<tr>";
echo "<td>ESTUDIOS</td>";
echo "<td>VALOR TOTAL</td>";
echo "<td>ESTUDIOS</td>";
echo "<td>VALOR TOTAL</td>";
echo "<td>ESTUDIOS</td>";
echo "<td>VALOR TOTAL</td>";
echo "<td>ESTUDIOS</td>";
echo "<td>VALOR TOTAL</td>";
echo "<td>ESTUDIOS</td>";
echo "<td>VALOR TOTAL</td>";
echo "<td>ESTUDIOS</td>";
echo "<td>VALOR TOTAL</td>";
echo "<td>ESTUDIOS</td>";
echo "<td>VALOR TOTAL</td>";
echo "<td>ESTUDIOS</td>";
echo "<td>VALOR TOTAL</td>";
echo "</tr>";
$NroFac = "na";
$Estudios = 0;
for($i=0;$i<$pRegistros;$i++){
    if($row[$i]["DesCliente"] != ""){
        echo "<tr>";
        if($row[$i]["DesCliente"] == "DOCUMENTO ANULADO"){
            echo "<td style=\"color: red;\">" . $row[$i]["DesCliente"] . "</td>";
            echo "<td style=\"color: red;\">" . $row[$i]["NroFactura"] . "</td>";
            echo "<td style=\"color: red;\">" . $row[$i]["FechaDocumento"] . "</td>";
        }else{
            echo "<td>" . $row[$i]["DesCliente"] . "</td>";
            echo "<td>" . $row[$i]["NroFactura"] . "</td>";
            echo "<td>" . $row[$i]["FechaDocumento"] . "</td>";
        }
        echo "<td>" . number_format($row[$i]["TEstudios"],0,".",",") . "</td>";
        echo "<td>" . number_format($row[$i]["TTotal"],2,".",",") . "</td>";
        echo "<td>" . number_format($row[$i]["TCopagos"],2,".",",") . "</td>";
        echo "<td>" . number_format($row[$i]["TNeto"],2,".",",") . "</td>";
        echo "<td>" . number_format($row[$i]["CantBIOPSIAMAMA"],0,".",",") . "</td>";
        echo "<td>" . number_format($row[$i]["ValorTBIOPSIAMAMA"],2,".",",") . "</td>";
        //echo "<td>" . PonerAcentosHTML($row[$i]["CopagosBIOPSIAMAMA"]) . "</td>";
        //echo "<td>" . PonerAcentosHTML($row[$i]["ValorNBIOPSIAMAMA"]) . "</td>";
        echo "<td>" . number_format($row[$i]["CantBIOPSIATIROIDES"],0,".",",") . "</td>";
        echo "<td>" . number_format($row[$i]["ValorTBIOPSIATIROIDES"],2,".",",") . "</td>";
        //echo "<td>" . PonerAcentosHTML($row[$i]["CopagosBIOPSIAMAMA"]) . "</td>";
        //echo "<td>" . PonerAcentosHTML($row[$i]["ValorNBIOPSIAMAMA"]) . "</td>";
        echo "<td>" . number_format($row[$i]["CantOTRASBIOPSIAS"],0,".",",") . "</td>";
        echo "<td>" . number_format($row[$i]["ValorTOTRASBIOPSIAS"],2,".",",") . "</td>";
        //echo "<td>" . PonerAcentosHTML($row[$i]["CopagosOTRASBIOPSIAS"]) . "</td>";
        //echo "<td>" . PonerAcentosHTML($row[$i]["ValorNOTRASBIOPSIAS"]) . "</td>";
        echo "<td>" . number_format($row[$i]["CantDRENAJESESPECIALES"],0,".",",") . "</td>";
        echo "<td>" . number_format($row[$i]["ValorTDRENAJESESPECIALES"],2,".",",") . "</td>";
        //echo "<td>" . PonerAcentosHTML($row[$i]["CopagosDRENAJESESPECIALES"]) . "</td>";
        //echo "<td>" . PonerAcentosHTML($row[$i]["ValorNDRENAJESESPECIALES"]) . "</td>";
        echo "<td>" . number_format($row[$i]["CantECODOPPLER"],0,".",",") . "</td>";
        echo "<td>" . number_format($row[$i]["ValorTECODOPPLER"],2,".",",") . "</td>";
        //echo "<td>" . PonerAcentosHTML($row[$i]["CopagosECODOPPLER"]) . "</td>";
        //echo "<td>" . PonerAcentosHTML($row[$i]["ValorNECODOPPLER"]) . "</td>";
        echo "<td>" . number_format($row[$i]["CantECOGRAFIA"],0,".",",") . "</td>";
        echo "<td>" . number_format($row[$i]["ValorTECOGRAFIA"],2,".",",") . "</td>";
        //echo "<td>" . PonerAcentosHTML($row[$i]["CopagosECOGRAFIA"]) . "</td>";
        //echo "<td>" . PonerAcentosHTML($row[$i]["ValorNECOGRAFIA"]) . "</td>";
        echo "<td>" . number_format($row[$i]["CantMAMOGRAFIA"],0,".",",") . "</td>";
        echo "<td>" . number_format($row[$i]["ValorTMAMOGRAFIA"],2,".",",") . "</td>";
        //echo "<td>" . PonerAcentosHTML($row[$i]["CopagosMAMOGRAFIA"]) . "</td>";
        //echo "<td>" . PonerAcentosHTML($row[$i]["ValorNMAMOGRAFIA"]) . "</td>";
        echo "<td>" . number_format($row[$i]["CantRADIOLOGIA"],0,".",",") . "</td>";
        echo "<td>" . number_format($row[$i]["ValorTRADIOLOGIA"],2,".",",") . "</td>";
        //echo "<td>" . PonerAcentosHTML($row[$i]["CopagosRADIOLOGIA"]) . "</td>";
        //echo "<td>" . PonerAcentosHTML($row[$i]["ValorNRADIOLOGIA"]) . "</td>";
        echo "</tr>";
    }
}
echo "</table>";

echo "<table border=\"0\" align=\"left\">";
echo '<tr><td>&nbsp;</td></tr>';
echo '<tr><td colspan = "5" style="color:#333; font-size:10px">' . utf8_decode(ofiCONFIDENCIALIDAD) . '</td></tr>';
echo "</table>";
$gBaseDatos->liberar();
$gBaseDatos->cerrar();

?>
