<?php
    require_once('../../../../lib/tcpdf/config/lang/spa.php');
    require_once('../../../../lib/tcpdf/tcpdf.php');
    require("../../../../core/php/_database.php");
    require("../../../../core/php/php_functions.php");
    header('Content-type: application/pdf; charset: UTF-8');
    
    $estructura = explode("¬", $_REQUEST['param']);
    $pNomParametros = spNomParametrosMI($estructura,"NO");
    $NameParam = explode("¬", $pNomParametros);
    $pParametros = spParametrosMI($estructura,"NO");
    $DataParam = explode("¬", $pParametros);
    
    $items = count($NameParam);
    for ($i=0; $i<$items; $i++)
    {
        switch ($NameParam[$i]) 
        {
            case "intEmpresa":
                if ($DataParam[$i] == "" || $DataParam[$i] == null || $DataParam[$i] == "null")
                    $pEmpresa = 0;
                else
                    $pEmpresa = $DataParam[$i];
                break;
                
            case "intIPS":
                if ($DataParam[$i] == "" || $DataParam[$i] == null || $DataParam[$i] == "null")
                    $pIPS = 0;
                else
                    $pIPS = $DataParam[$i];
                break;
                
            case "intCliente":
                if ($DataParam[$i] == "" || $DataParam[$i] == null || $DataParam[$i] == "null")
                    $pCliente = 0;
                else
                    $pCliente = $DataParam[$i];
                break;
                
            case "intPlan":
                if ($DataParam[$i] == "" || $DataParam[$i] == null || $DataParam[$i] == "null")
                    $pPlan = 0;
                else
                    $pPlan = $DataParam[$i];
                break;
                
            case "intSubPlan":
                if ($DataParam[$i] == "" || $DataParam[$i] == null || $DataParam[$i] == "null")
                    $pSubPlan = 0;
                else
                    $pSubPlan = $DataParam[$i];
                break;
                
            case "fecDesde":
                if ($DataParam[$i] == "" || $DataParam[$i] == null || $DataParam[$i] == "null")
                {    
                    $pDesde = date('Y-m-d');
                }else{
                    $pDesde = $DataParam[$i];
                }
                break;
                
            case "fecHasta":
                if ($DataParam[$i] == "" || $DataParam[$i] == null || $DataParam[$i] == "null")
                {
                    $pHasta = date('Y-m-d');
                }else{
                    $pHasta = $DataParam[$i];
                }
                break;
                
            case "strCampo1":
                if ($DataParam[$i] == "" || $DataParam[$i] == null || $DataParam[$i] == "null")
                {
                    $pCampo1 = 'NO';
                }else{
                    $pCampo1 = $DataParam[$i];
                }
                break;
            
            case "strCampo2":
                if ($DataParam[$i] == "" || $DataParam[$i] == null || $DataParam[$i] == "null")
                {
                    $pCampo2 = 'NO';
                }else{
                    $pCampo2 = $DataParam[$i];
                }
                break;
            
            case "strCampo3":
                if ($DataParam[$i] == "" || $DataParam[$i] == null || $DataParam[$i] == "null")
                {
                    $pCampo3 = 'NO';
                }else{
                    $pCampo3 = $DataParam[$i];
                }
                break;
            
            case "intContrato":
                if ($DataParam[$i] == "" || $DataParam[$i] == null || $DataParam[$i] == "null")
                {
                    $pContrato = 0;
                }else{
                    $pContrato = $DataParam[$i];
                }
                break;
                
            case "strPaciente":
                if ($DataParam[$i] == "" || $DataParam[$i] == null || $DataParam[$i] == "null")
                {
                    $pPaciente = 'Todos';
                }else{
                    $pPaciente = $DataParam[$i];
                }
                break;
                
            case "strAutorizacion":
                if ($DataParam[$i] == "" || $DataParam[$i] == null || $DataParam[$i] == "null")
                {
                    $pAutorizacion = 'Todos';
                }else{
                    $pAutorizacion = $DataParam[$i];
                }
                break;
            
            default:
                break;
        }
    }
    $pImprimeTirilla = "NO";
    $LeftMargin = PDF_MARGIN_LEFT;
    $TopMargin = 5;
    $RightMargin = PDF_MARGIN_RIGHT;
    $HeaderMargin = PDF_MARGIN_HEADER;
    $BottomMargin = 3;
    $FooterMargin = 5;
    $Alineacion = "P";
    $FormatoPagina = "CARTA";
    $UsaPiePagina = "SI";
    $pTipoEncabezado = "SIN";
    $pControlSalto = 20;
    
    //Inicializacion de la Clase
    $pdf = new TCPDF($Alineacion, PDF_UNIT, $FormatoPagina, true, 'UTF-8', false);
    //$pdf = new TCPDF("P", PDF_UNIT, "CARTA", true, 'UTF-8', false);
    
    // set document information
    $pdf->SetCreator(PDF_CREATOR);
    $pdf->SetAuthor('Sistemas Ofisalud © - 2006');
    $pdf->SetTitle('FACTURACION');
    $pdf->SetSubject('CUENTA DE COBRO');

    // set default header data
    $qry = "CALL sp_facturacion_cuentacobro_xfac('" . $pCliente . "','" . $pPlan . "','" . $pSubPlan . "','" . $pContrato . "',\"" . $pDesde . "\",\"" . $pHasta . "\",\"" . $pCampo1 . "\",\"" . $pCampo2 . "\",\"" . $pCampo3 . "\")";
    session_start();
    $pdf->pAlineacionEncabezado = "P";
    $pdf->pTituloInforme = "CUENTA DE COBRO";
    $pdf->pTipoEncabezado = $pTipoEncabezado;
    $pdf->pImprimeLogo = "NO";
    $pdf->pAnchoTxtPagina = 140;
    $pdf->pNomEmpresa = $_SESSION['NOM_EMPRESA'];
    $pdf->pNomSede = $_SESSION['NOM_SEDE'];
    $pdf->pNomIPS = $_SESSION['NOM_IPS'];
    $pdf->pMargenPie = -20;
    if($_SESSION['IdAplicacion'] == "OfiMedical"){
        $pdf->pLogoCliente = "../../../consultoriovirtual/" . $_SESSION['IDBD'] . "/logo/logoenc.gif";
    }else{
        $pdf->pLogoCliente = "../../../empresas/" . $_SESSION['ID_EMPRESA'] . "/logo/logoenc.gif";
    }
    $pdf->SetHeaderData($pdf->pLogoCliente, PDF_HEADER_LOGO_WIDTH, $pdf->pTituloInforme, PDF_HEADER_STRING);
    // set header and footer fonts
    $pdf->setHeaderFont(Array(PDF_FONT_NAME_MAIN, '', PDF_FONT_SIZE_MAIN));
    $pdf->setFooterFont(Array(PDF_FONT_NAME_DATA, '', PDF_FONT_SIZE_DATA));
    // set default monospaced font
    $pdf->SetDefaultMonospacedFont(PDF_FONT_MONOSPACED);
    //set margins
    $pdf->SetMargins(PDF_MARGIN_LEFT, PDF_MARGIN_TOP, PDF_MARGIN_RIGHT);
    $pdf->SetHeaderMargin(PDF_MARGIN_HEADER);
    $pdf->SetFooterMargin(PDF_MARGIN_FOOTER);
    //set auto page breaks
    $pdf->SetAutoPageBreak(FALSE, PDF_MARGIN_BOTTOM);
    //set image scale factor
    $pdf->setImageScale(PDF_IMAGE_SCALE_RATIO);
    //set some language-dependent strings
    $pdf->setLanguageArray($l);
    // set default font subsetting mode
    $pdf->setFontSubsetting(true);
    $pdf->SetFont('dejavusans', '', 14, '', true);

    $idConcepto = "-1";
    $totSubTotal_c = 0;
    $totIVA_c = 0;
    $totCopagos_c = 0;
    $totDescuentos_c = 0;
    $totNeto_c = 0;
    $contador = 0;
    $pImprimePieConcepto = "No";
    $pUltimoRegistro = "No";
    
    $gBaseDatos = new ofiMySQLi();
    $gBaseDatos->conectar();
    $qry = "CALL sp_facturacion_cuentacobro_xfac('" . $pCliente . "','" . $pPlan . "','" . $pSubPlan . "','" . $pContrato . "',\"" . $pDesde . "\",\"" . $pHasta . "\",\"" . $pCampo1 . "\",\"" . $pCampo2 . "\",\"" . $pCampo3 . "\")";
    unset($row);
    $gBaseDatos->QryID = @mysqli_query($gBaseDatos->ConexionID, $qry);
    while ($row[] = @mysqli_fetch_assoc($gBaseDatos->QryID));
    $pRegistros = count($row)-1;
    $gBaseDatos->liberar(); 
    $gBaseDatos->cerrar();
    $ValorTotalCuenta = 0;
    for($i=0;$i<$pRegistros;$i++)
    {
        $ValorTotalCuenta += $row[$i]["VlrNeto"];
    }
    $pdf->AddPage();
    $pdf->SetFont(PDF_FONT_NAME_MAIN, '', 11);
    $pdf->SetFillColor(242 , 236, 236);
    $pdf->Ln(16);
    $pdf->MultiCell(204,10,$row[0]["CiuPrestador"] . ", " . formatearFechaIdiomas( time(), $setting, 'medio'),0,'L',0,0);
    $pdf->Ln(16);
    $pdf->SetFont(PDF_FONT_NAME_MAIN,'B',11);
    $pdf->SetFillColor(242 , 236, 236);
    $pdf->MultiCell(204,10,$row[0]["DesCliente"],0,'C',0,0);
    $pdf->Ln(4);
    if($row[0]["TDocCliente"] == "NI"){
        $TdocCliente = "NIT";
    }else{
        $TdocCliente = $row[0]["TDocCliente"];
    }
    if($row[0]["DigverCliente"] != "" && $row[0]["DigverCliente"] != null){
        $DocCliente = $row[0]["DocCliente"] . "-" . $row[0]["DigverCliente"];
    }else{
        $DocCliente = $row[0]["DocCliente"];
    }
    $pdf->MultiCell(204,10,"(" . $TdocCliente . ": " . $DocCliente .")",0,'C',0,0);
    $pdf->Ln();
    $pdf->SetFont(PDF_FONT_NAME_MAIN,'',11);
    $pdf->MultiCell(204,10,"DEBE A:",0,'C',0,0);
    $pdf->Ln();
    $pdf->SetFont(PDF_FONT_NAME_MAIN,'B',11);
    $pdf->writeHTMLCell(204,10, '', '', '<span>' . $row[0]["NomPrestador"] . '</span>', 0, 0, 0, true, 'C', false);
    $pdf->Ln(4);
    if($row[0]["TdocPrestador"] == "NI"){
        $TdocPrestador = "NIT";
    }else{
        $TdocPrestador = $row[0]["TdocPrestador"];
    }
    $DocPrestador = $row[0]["DocPrestador"];
    $pdf->MultiCell(204,10,"(" . $TdocPrestador . ": " . $DocPrestador .")",0,'C',0,0);
    $pdf->Ln(8);
    $val = strtoupper(utf8_decode(numerotexto($ValorTotalCuenta)));
    $mostrarHC = '<table cellspacing="0">';
        $mostrarHC .= '<tr>';
            $mostrarHC .= '<td align="right" width="150">LA SUMA DE:<br></td>';
            $mostrarHC .= '<td width="554">';
                $mostrarHC .= " $" . number_format($ValorTotalCuenta,2,".",",");
            $mostrarHC .= '</td>';
        $mostrarHC .= '</tr>';
        $mostrarHC .= '<tr>';
            $mostrarHC .= '<td align="right" width="150">SON:<br></td>';
            $mostrarHC .= '<td width="554">';
                $mostrarHC .= '&nbsp;'. $val . ' PESOS M/CTE.';
            $mostrarHC .= '</td>';
        $mostrarHC .= '</tr>';
        $mostrarHC .= '<tr>';
        $mostrarHC .= '<td align="right" width="150">POR CONCEPTO DE:</td>';
        $mostrarHC .= '<td width="554">';
            $mostrarHC .= "&nbsp;Servicios especializados en el proceso y análisis de citologías, líquidos y anatomía patológica, los cuales fueron realizados a sus afiliados y beneficiarios.";
        $mostrarHC .= '</td>';
        $mostrarHC .= '</tr>';
    $mostrarHC .= '</table>';
    $pdf->writeHTML($mostrarHC, true, false, false, false, '');
    $pdf->Ln();
    $pdf->Ln(16);
    $pdf->writeHTML("__________________________________________", true, false, false, false, '');
    $pdf->writeHTML($row[0]["Quienfirma"], true, false, false, false, '');
    $pdf->writeHTML($row[0]["cargofirma"], true, false, false, false, '');
    $pdf->Output('infCuentaCobro.pdf', 'I');
    
?>
