<?php
    set_time_limit(500);
    require_once('../../../../lib/tcpdf/config/lang/spa.php');
    require_once('../../../../lib/tcpdf/tcpdf.php');
    require("../../../../core/php/_database.php");
    require("../../../../core/php/php_functions.php");
    header('Content-type: application/pdf; charset: UTF-8');
    
    $estructura = explode("¬", $_REQUEST['param']);
    $pNomParametros = spNomParametrosMI($estructura,"NO");
    $NameParam = explode("¬", $pNomParametros);
    $pParametros = spParametrosMI($estructura,"NO");
    $DataParam = explode("¬", $pParametros);
    
    $items = count($NameParam);
    for ($i=0; $i<$items; $i++)
    {
        switch ($NameParam[$i]) 
        {
            case "intBodegaVentaPOS":
                if ($DataParam[$i] == "" || $DataParam[$i] == null || $DataParam[$i] == "null")
                    $pBodega = 0;
                else
                    $pBodega = $DataParam[$i];
                break;
            
           case "intEmpresa":
                if ($DataParam[$i] == "" || $DataParam[$i] == null || $DataParam[$i] == "null")
                    $pEmpresa = 0;
                else
                    $pEmpresa = $DataParam[$i];
                break;
                
            case "intIPS":
                if ($DataParam[$i] == "" || $DataParam[$i] == null || $DataParam[$i] == "null")
                    $pIPS = 0;
                else
                    $pIPS = $DataParam[$i];
                break;
                
            case "fecDesde":
                if ($DataParam[$i] == "" || $DataParam[$i] == null || $DataParam[$i] == "null")
                {    
                    $pDesde = date('Y-m-d');
                }else{
                    $pDesde = $DataParam[$i];
                }
                break;
                
            case "fecHasta":
                if ($DataParam[$i] == "" || $DataParam[$i] == null || $DataParam[$i] == "null")
                {
                    $pFiltroFechas = 'n';
                }else{
                    $pHasta = $DataParam[$i];
                }
                break;
                
            default:
                break;
        }
    }
    
    $qry = "CALL sp_macroinformes_caja_comprobantediario01(\"" . $pDesde . "\",\"" . $pHasta . "\")";
    $gBaseDatos = new ofiMySQLi();
    $gBaseDatos->conectar();
    $gBaseDatos->QryID = @mysqli_query($gBaseDatos->ConexionID, $qry);
    while ($rowRDO01[] = @mysqli_fetch_assoc($gBaseDatos->QryID));
    $gBaseDatos->liberar();
    $gBaseDatos->cerrar();
    $pRegistros = count($rowRDO01);
    
    $LeftMargin = PDF_MARGIN_LEFT;
    $TopMargin = 5;
    $RightMargin = PDF_MARGIN_RIGHT;
    $HeaderMargin = PDF_MARGIN_HEADER;
    $BottomMargin = 3;
    $FooterMargin = 5;
    $Alineacion = "P";
    $FormatoPagina = "CARTA";
    $UsaPiePagina = "SI";
    $pTipoEncabezado = "FVP";
    $pControlSalto = 30;
    
    $pdf = new TCPDF($Alineacion, PDF_UNIT, $FormatoPagina, true, 'UTF-8', false);
    //Inicializacion Variables de Control
    $pdf->pAlineacionEncabezado = $Alineacion;
    $pdf->pTituloInforme = "COMPROBANTE INFORME DIARIO";
    $pdf->pImprimeLogo = "NO";
    $pdf->pAnchoTxtPagina = 210;
    $pdf->pNomEmpresa = $_SESSION['NOM_EMPRESA'];
    $pdf->pTDocEmpresa = $_SESSION['EMPRESA_TDOC'];
    $pdf->pDocEmpresa = $_SESSION['EMPRESA_DOC'];
    $pdf->pDirEmpresa = $_SESSION['EMPRESA_DIR'];
    $pdf->pTelEmpresa = $_SESSION['EMPRESA_TEL'];
    $pdf->pCiuEmpresa = $_SESSION['EMPRESA_CIU'];
    $pdf->pEspEmpresa = $_SESSION['EMPRESA_ESP'];
    $pdf->pRegEmpresa = $_SESSION['EMPRESA_REGIMEN'];
    $pdf->pContribuyentes = $_SESSION['EMPRESA_CONTRIBUYENTE'];
    $pdf->pReteIVA  = $_SESSION['EMPRESA_RTEICA'];
    $pdf->pReteICA = $_SESSION['EMPRESA_RTEIVA'];

    $pdf->pTipoEncabezado = $pTipoEncabezado;
    $pdf->pNomSede = $_SESSION['EMPRESA_DOC'];
    $pdf->pNomIPS = $_SESSION['NOM_IPS'];
    $pdf->pMargenPie = -20;
    if($_SESSION['IdAplicacion'] == "OfiMedical"){
        $pdf->pLogoCliente = "../../../consultoriovirtual/" . $_SESSION['IDBD'] . "/logo/logoenc.gif";
    }else{
        $pdf->pLogoCliente = "../../../empresas/" . $_SESSION['ID_EMPRESA'] . "/logo/logoenc.gif";
    }
    $pdf->pPrefijo = 1; //$row[0]["Prefijo"];
    $pdf->pNroDocumento = 1; //str_pad($row[0]["NroDocumento"], 7, "0", STR_PAD_LEFT);
    $pdf->pNroResolucion = 1; //$row[0]["NroResolucion"];
    $pdf->pFechaDoc = 1; //$row[0]["FechaDocumento"];
    $pdf->pCAS = null;
    $pdf->pTratamiento = null;
    $pdf->pUsaPie = $UsaPiePagina;
    if($_SESSION['IdAplicacion'] == "OfiMedical"){
        $pdf->pLogoCliente = "../../../consultoriovirtual/" . $_SESSION['IDBD'] . "/logo/logoenc.gif";
    }else{
        $pdf->pLogoCliente = "../../../empresas/" . $_SESSION['ID_EMPRESA'] . "/logo/logoenc.gif";
    }

    $pdf->SetCreator(PDF_CREATOR);
    $pdf->SetAuthor('Sistemas Ofisalud © - 2006');
    $pdf->SetTitle('OfiClinic©');
    $pdf->SetSubject('Comprobante Informe Diario');

    $pdf->SetHeaderData($pdf->pLogoCliente, PDF_HEADER_LOGO_WIDTH, $pdf->pTituloInforme, PDF_HEADER_STRING);
    $pdf->setHeaderFont(Array(PDF_FONT_NAME_MAIN, '', PDF_FONT_SIZE_MAIN));
    $pdf->setFooterFont(Array(PDF_FONT_NAME_DATA, '', PDF_FONT_SIZE_DATA));
    $pdf->SetDefaultMonospacedFont(PDF_FONT_MONOSPACED);
    $pdf->SetMargins($LeftMargin, $TopMargin, $RightMargin);
    $pdf->SetHeaderMargin($HeaderMargin);
    $pdf->SetFooterMargin($FooterMargin);
    // set bacground image

    $pdf->SetAutoPageBreak(TRUE, $BottomMargin);
    $pdf->setImageScale(PDF_IMAGE_SCALE_RATIO);
    $pdf->setLanguageArray($l);
    $pdf->setFontSubsetting(true);
    $pdf->SetFont('dejavusans', '', 14, '', true);
    
    EncabezadoPaginaGeneral($pdf, $rowRDO01, $i, $rowcount, $contador, $pDesde, $pHasta, $pNomAplicacion);
    $pdf->Ln(5);
    //FECHA DEL COMPROBANTE
    $pdf->writeHTMLCell(201, 5, '', '', "<b>FECHA DEL COMPROBANTE:</b>", 0, 0, 0, true, 'L', true);
    $pdf->Ln(4);
    $pdf->writeHTMLCell(201, 5, '', '', "- DESDE: " . $pDesde . " - HASTA: " . $pHasta, 0, 0, 0, true, 'L', true);
    $pdf->Ln(6);
    //NOMBRE DE LA MAQUINA REGISTRADORA
    $pdf->writeHTMLCell(201, 5, '', '', "<b>IDENTIFICACION DE LAS MAQUINAS O COMPUTADORES QUE EMITIERON EL DOCUMENTO EQUIVALENTE:</b>", 0, 0, 0, true, 'L', true);
    $pdf->Ln(4);
    $pdf->writeHTMLCell(50, 5, '', '', "MAQUINA/PC", 1, 0, 0, true, 'C', true);
    $pdf->writeHTMLCell(20, 5, '', '', "PREFIJO", 1, 0, 0, true, 'C', true);
    $pdf->writeHTMLCell(20, 5, '', '', "Nro INICIAL", 1, 0, 0, true, 'C', true);
    $pdf->writeHTMLCell(20, 5, '', '', "Nro FINAL", 1, 0, 0, true, 'C', true);
    $pdf->writeHTMLCell(40, 5, '', '', "CONCEPTO", 1, 0, 0, true, 'C', true);
    $pdf->writeHTMLCell(50, 5, '', '', "VLR. TOTAL", 1, 0, 0, true, 'C', true);
    $pdf->Ln();
    for($i=0;$i<$pRegistros;$i++){
        if($rowRDO01[$i]["Caja"] != ""){
            $pdf->writeHTMLCell(50, 5, '', '', "- PC_" . $rowRDO01[$i]["Caja"], 1, 0, 0, true, 'L', true);
            $pdf->writeHTMLCell(20, 5, '', '', $rowRDO01[$i]["Prefijo"], 1, 0, 0, true, 'C', true);
            $pdf->writeHTMLCell(20, 5, '', '', $rowRDO01[$i]["Minimo"], 1, 0, 0, true, 'C', true);
            $pdf->writeHTMLCell(20, 5, '', '', $rowRDO01[$i]["Maximo"], 1, 0, 0, true, 'C', true);
            $pdf->writeHTMLCell(40, 5, '', '', "SERVICIOS MEDICOS", 1, 0, 0, true, 'C', true);
            $pdf->writeHTMLCell(50, 5, '', '', "$" . number_format($rowRDO01[$i]["VlrNeto"],0,".",","), 1, 0, 0, true, 'C', true);
        }
    }
    $pdf->Ln(8);
    //MEDIOS DE PAGO
    $pdf->writeHTMLCell(201, 5, '', '', "<b>MEDIOS DE PAGO:</b>", 0, 0, 0, true, 'L', true);
    $pdf->Ln(4);
    $pdf->writeHTMLCell(201, 5, '', '', "- EFECTIVO: " . "$" . number_format($rowRDO01[0]["VlrNeto"],0,".",","), 0, 0, 0, true, 'L', true);
    $pdf->Ln(6);
    if ($pdf->GetY() < 180)
    {
        //$pdf->SetFont(PDF_FONT_NAME_MAIN,'B',11);
        $pdf->writeHTMLCell(201, 5, '', '', "<b>RESUMEN POR CLIENTE:</b>", 0, 0, 0, true, 'L', true);
        $pdf->Ln(4.5);
        //$pdf->SetFont(PDF_FONT_NAME_MAIN,'B',9);
        $pdf->MultiCell(85,5,"Cliente",1,'L',0,0);
        $pdf->MultiCell(40,5,"Vlr Recaudo",1,'R',0,0);
        $pdf->Ln();
    }else{
        $pdf->AddPage();
        //$pdf->SetFont(PDF_FONT_NAME_MAIN,'B',11);
        $pdf->writeHTMLCell(201, 5, '', '', "<b>RESUMEN POR CLIENTE:</b>", 0, 0, 0, true, 'L', true);
        $pdf->Ln(4.5);
        //$pdf->SetFont(PDF_FONT_NAME_MAIN,'B',9);
        $pdf->MultiCell(85,5,"Cliente",1,'L',1,0);
        $pdf->MultiCell(40,5,"Vlr Recaudo",1,'R',1,0);
        $pdf->Ln();
    }
    
    $qry = "CALL sp_macroinformes_caja_recaudosdiarios_02_cliente('" . $pEmpresa . "','" . $pIPS . "',\"" . $pDesde . "\",\"" . $pHasta . "\")";
    $gBaseDatos->conectar();
    $gBaseDatos->QryID = @mysqli_query($gBaseDatos->ConexionID, $qry);
    $vlrtot = 0;
    while ($row = @mysqli_fetch_row($gBaseDatos->QryID))
    {
        $arrfila = array();   
        $rowcount = 0;
        $fill = 0;
        $rowcount = max($pdf->getNumLines(utf8_decode($row[0]), 55),1) * 3;
        $pdf->SetFont(PDF_FONT_NAME_MAIN, '', 7);
        $vlrtot += $row[1];
        //Usuario
        //$pdf->MultiCell(85,$rowcount,utf8_decode($row[0]),1,'L',$fill,0);
        $pdf->writeHTMLCell(85, $rowcount, '', '', utf8_decode($row[0]), 1, 0, $fill, true, 'L', true);
        //Valor
        $pdf->MultiCell(40,$rowcount,number_format(utf8_decode($row[1]),2,".",","),1,'R',0,0);
        if ($pdf->GetY() < 180)
            $pdf->Ln();
        else
        {
            $pdf->AddPage();
            $pdf->SetFont(PDF_FONT_NAME_MAIN,'B',11);
            $pdf->MultiCell(264,10,"RESUMEN POR CLIENTE" ,0,'L',0,0);
            $pdf->Ln(4.5);
            $pdf->SetFont(PDF_FONT_NAME_MAIN,'B',9);
            $pdf->MultiCell(85,5,"CLIENTE",1,'L',1,0);
            $pdf->MultiCell(40,5,"Vlr Recaudo",1,'R',1,0);
            $pdf->Ln();
        }
    }
    $pdf->SetFillColor(242 , 236, 236);
    $pdf->MultiCell(85,5,"VALOR TOTAL",1,'R',1,0);
    $pdf->MultiCell(40,5,number_format($vlrtot,2,".",","),1,'R',1,0);
    $gBaseDatos->liberar();
    $gBaseDatos->cerrar();
    /*
    Origen.NomCaja AS Caja,
Origen.Prefijo,
MIN(Origen.NroDocumento) AS Minimo,
MAX(Origen.NroDocumento) AS Maximo,
Sum(Origen.VlrNeto) AS VlrNeto
    */
    
    $pdf->Output('infRecaudosDiario.pdf', 'I');

function EncabezadoPaginaGeneral(&$pdf, &$rowHC, &$i, &$rowcount, &$contador, &$pDesde, &$pHasta, $pNomAplicacion){
    //RAFAEL
    $Alineacion = "P";
    $FormatoPagina = "CARTA";
    if($rowHC[$i]["DireccionIPS"] != "" && $rowHC[$i]["DireccionIPS"] != null){
        $pdf->pDirEmpresa = $rowHC[$i]["DireccionIPS"] . "<br>";
    }
    if($rowHC[$i]["TelefonoIPS"] != "" && $rowHC[$i]["TelefonoIPS"] != null){
        $pdf->pTelEmpresa = $rowHC[$i]["TelefonoIPS"];
    }
    if($rowHC[$i]["DescMunicipioIPS"] != "" && $rowHC[$i]["DescMunicipioIPS"] != null){
        $pdf->pCiuEmpresa = $rowHC[$i]["DescMunicipioIPS"] . " - " . $rowHC[$i]["DescDeptoIPS"];
    }
    $pdf->AddPage($Alineacion,$FormatoPagina);
    $pdf->Ln(2);
    $pdf->SetFont(PDF_FONT_NAME_MAIN, '', 7);
    $EncabezadoHTML = '<table cellspacing="0" border="0" style="font-size:24px; color:#000;">';
    $EncabezadoHTML .= '<tr>';
    $EncabezadoHTML .= '<td>';
    $EncabezadoHTML .= '<span style="font-size:44px; color:#000; font-weight:bold">' . utf8_decode($pdf->pNomEmpresa) . '</span><br>';
    if($pdf->pEspEmpresa != null || $pdf->pEspEmpresa != "")
            $EncabezadoHTML .= '<span style="font-size:34px; color:#000;">' . utf8_decode($pdf->pEspEmpresa) . '</span><br>';
    if($pdf->pTDocEmpresa == "NI"){
        $tipodoc = "NIT: ";
        $EncabezadoHTML .= '<span style="font-size:34px; color:#000;">' . $tipodoc . $pdf->pDocEmpresa . '</span><br>';
    }
    $EncabezadoHTML .= '<span style="font-size:34px; color:#000;">' . $pdf->pDirEmpresa . ' - ' . $pdf->pTelEmpresa . '</span><br>';
    $EncabezadoHTML .= '<span style="font-size:34px; color:#000;">' . $pdf->pCiuEmpresa . '</span><br><br>';
    $EncabezadoHTML .= '</td>';

    //COL2
    $EncabezadoHTML .= '<td align="right">';
    if($pNomAplicacion == "OfiMedical"){
        if (file_exists("../../../consultoriovirtual/" . $_SESSION['IDBD'] . "/logo/logoenc.gif")) {
            $EncabezadoHTML .= '<img src="../../../consultoriovirtual/' . $_SESSION['IDBD'] . '/logo/logoenc.gif" align="right"/>';
            $EncabezadoHTML .= '<br>';
        }else{
            if (file_exists("../../../../consultoriovirtual/" . $_SESSION['IDBD'] . "/logo/logoenc.gif")) {
                $EncabezadoHTML .= '<img src="../../../../consultoriovirtual/' . $_SESSION['IDBD'] . '/logo/logoenc.gif" align="right"/>';
                $EncabezadoHTML .= '<br>';
            }
        }
    }else{
        if (file_exists("../../../empresas/" . $_SESSION['ID_EMPRESA'] . "/logo/logoenc.gif")) {
            $EncabezadoHTML .= '<img src="../../../empresas/' . $_SESSION['ID_EMPRESA'] . '/logo/logoenc.gif" align="right"/>';
            $EncabezadoHTML .= '<br>';
        }else{
            if (file_exists("../../../../empresas/" . $_SESSION['ID_EMPRESA'] . "/logo/logoenc.gif")) {
                $EncabezadoHTML .= '<img src="../../../../empresas/' . $_SESSION['ID_EMPRESA'] . '/logo/logoenc.gif" align="right"/>';
                $EncabezadoHTML .= '<br>';
            }
        }

    }
    $EncabezadoHTML .= '<span align="rigth" style="font-size:44px; color:#000; font-weight:bold">COMPROBANTE INFORME DIARIO</span><br>';
    if (file_exists('../../../consultoriovirtual/' . $_SESSION['IDBD']  . '/pacientes/' . $rowHC[$i]["Paciente"] . '/uploads/foto.jpg')) {
        $EncabezadoHTML .= '<br><img src="../../../consultoriovirtual/' . $_SESSION['IDBD']  . '/pacientes/' . $rowHC[$i]["Paciente"] . '/uploads/foto.jpg" width="130" height="100"/><br>';
    }else{
        if (file_exists('../../../empresas/' . $_SESSION['ID_EMPRESA']  . '/pacientes/' . $rowHC[$i]["Paciente"] . '/uploads/foto.jpg')) {
            $EncabezadoHTML .= '<br><img src="../../../empresas/' . $_SESSION['ID_EMPRESA']  . '/pacientes/' . $rowHC[$i]["Paciente"] . '/uploads/foto.jpg" width="130" height="100"/><br>';
        }
    }
    $EncabezadoHTML .= '<span align="rigth" style="font-size:26px; color:#000; font-weight:bold">Copia Controlada</span>';
    $EncabezadoHTML .= '</td>';
    $EncabezadoHTML .= '</tr>';
    $EncabezadoHTML .= '</table>';
    $EncabezadoHTML .= '<hr class="linea">';
    $pdf->writeHTML($EncabezadoHTML, true, false, false, false, '');
}

?>