<?php

/*
* @category    Controladora  Notificación Reparación
* @package     OfiClinic Web
* @author      Héctor Iván Ramírez Cardona<desarrollo@ofisalud.com>
* @copyright   2010 Jorge Ancizar GAleano Ruiz
* @version     OfiClinic Web 1.0
* @license     COMERCIAL
* @link        http://www.ofisalud.com
* @country     Colombia
* @telephone   3016398114
*/

require("../../../core/php/_database.php");
require("../../../core/php/php_functions.php");

$task = isset($_REQUEST['task'])?$_REQUEST['task']:0;

switch($task){
    case "LISTAR":
        Listar();
        break;
    case "MODIFICAR":
         Modificar();
        break;
    case "INSERTAR":
        Insertar();
        break;
    case "INSERTAR PROGRAMA":
        InsertarPrograma();
        break;    
    default:
        echo "{failure:true}";
        break;
}

function InsertarPrograma()
{
    $estructura = explode("¬", $_REQUEST['CAMPOS']);
    $gBaseDatos = new ofiMySQLi();
    $gBaseDatos->conectar();
    $qry = "CALL sp_kardexpaciente_insertar (" . spParametros($estructura,"NO") . ")";
    //echo $qry;
    if(@mysqli_query($gBaseDatos->ConexionID, $qry))
        echo "{success: true, requestedId:'1'}";
    else
       echo "{success: true, requestedId:'0'}";
    $gBaseDatos->cerrar();
}

function Modificar()
{
    $estructura = explode("¬", $_REQUEST['CAMPOS']);
    $gBaseDatos = new ofiMySQLi();
    $gBaseDatos->conectar();
    $qry = "CALL sp_kardex_paciente_actualizar(" . spParametros($estructura,"NO") . ")";
    if(@mysqli_query($gBaseDatos->ConexionID, $qry))
        echo "{success: true, requestedId:'1'}";
    else
       echo "{success: true, requestedId:'0'}";
    $gBaseDatos->cerrar();
}

function Insertar()
{
    $estructura = explode("¬", $_REQUEST['CAMPOS']);
    $gBaseDatos = new ofiMySQLi();
    $gBaseDatos->conectar();
    $qry = "CALL sp_seguimiento_insertar (" . spParametros($estructura,"NO") . ")";
    //echo $qry;
    if(@mysqli_query($gBaseDatos->ConexionID, $qry))
        echo "{success: true, requestedId:'1'}";
    else
       echo "{success: true, requestedId:'0'}";
    $gBaseDatos->cerrar();
}

function Listar()
{
    $gBaseDatos = new ofiMySQLi();
    $gBaseDatos->conectar();
    $pPrograma = isset($_REQUEST['pPrograma']) ? $_REQUEST['pPrograma'] : 0;
    if (is_null($pPrograma) || $pPrograma == "")
        $pPrograma= "";
    
    $pEstado = isset($_REQUEST['pEstado']) ? $_REQUEST['pEstado'] : 0;
    if (is_null($pEstado) || $pEstado == "")
        $pEstado= "";
    
    $pPrioridad= isset($_REQUEST['pPrioridad']) ? $_REQUEST['pPrioridad'] : 0;
    if (is_null($pPrioridad) || $pPrioridad == "")
        $pPrioridad= "";
    
    $pDesInscripcion= isset($_REQUEST['pDesInscripcion']) ? $_REQUEST['pDesInscripcion'] : 0;
    $pHasInscripcion= isset($_REQUEST['pHasInscripcion']) ? $_REQUEST['pHasInscripcion'] : 0;
    $pDesProCita= isset($_REQUEST['pDesProCita']) ? $_REQUEST['pDesProCita'] : 0;
    $pHasProCita= isset($_REQUEST['pHasProCita']) ? $_REQUEST['pHasProCita'] : 0;
    $pFecVaciaCita=isset($_REQUEST['pFecVaciaCita']) ? $_REQUEST['pFecVaciaCita'] : 0;
    if (is_null($pFecVaciaCita) || $pFecVaciaCita == "")
        $pFecVaciaCita= 0;
    
    $pPaciente=isset($_REQUEST['pPaciente']) ? $_REQUEST['pPaciente'] : 0;
    if (is_null($pPaciente) || $pPaciente == "")
        $pPaciente= 0;
    
    $pTipDocumento=isset($_REQUEST['pTipDocumento']) ? $_REQUEST['pTipDocumento'] : 0;
    $pNumIdentificacion=isset($_REQUEST['pNumIdentificacion']) ? $_REQUEST['pNumIdentificacion'] : 0;
    $pNomPaciente=isset($_REQUEST['pNomPaciente']) ? $_REQUEST['pNomPaciente'] : 0;                
    $pEdad=isset($_REQUEST['pEdad']) ? $_REQUEST['pEdad'] : 0;
    if (is_null($pEdad) || $pEdad == "")
        $pEdad= 0;
    
    $pEdadDesde=isset($_REQUEST['pEdadDesde']) ? $_REQUEST['pEdadDesde'] : 0;                
    $pEdadHasta=isset($_REQUEST['pEdadHasta']) ? $_REQUEST['pEdadHasta'] : 0;
    $pSexo=isset($_REQUEST['pSexo']) ? $_REQUEST['pSexo'] : 0;
    if (is_null($pSexo) || $pSexo == "")
        $pSexo= "";
    
    $pFecVaciaInscripcion=isset($_REQUEST['pFecVaciaInscripcion']) ? $_REQUEST['pFecVaciaInscripcion'] : 0;
     if (is_null($pFecVaciaInscripcion) || $pFecVaciaInscripcion == "")
        $pFecVaciaInscripcion= 0;
    
    $qry = "CALL sp_kardex_paciente_listar(\"" . $pPrograma . "\",'" . $pEstado . "','" . $pPrioridad . "',\"" . $pPaciente . "\",\"" . $pTipDocumento . "\",\"" . $pNumIdentificacion . "\",\"" . $pNomPaciente . "\",\"" . $pEdad . "\",\"" . $pEdadDesde . "\",\"" . $pEdadHasta . "\",\"" . $pSexo . "\",\"" . $pDesInscripcion . "\",\"" . $pHasInscripcion . "\",\"" . $pDesProCita . "\",\"" . $pHasProCita . "\",\"" . $pFecVaciaCita . "\",\"" . $pFecVaciaInscripcion . "\")";
    $CampoLlave = explode("^",$gBaseDatos->jasonSP_arreglo2011($qry));
    $nbrows = $CampoLlave[0];
    $gBaseDatos->liberar();
    $gBaseDatos->cerrar();
    if($nbrows>0){
        $gBaseDatos->conectar();
        $start = (integer) (isset($_POST['start']) ? $_POST['start'] : $_GET['start']);
        $end = (integer) (isset($_POST['limit']) ? $_POST['limit'] : $_GET['limit']);
        $qry = "CALL sp_kardex_paciente_listar_limit(\"" . $pPrograma . "\",'" . $pEstado . "','" . $pPrioridad . "',\"" . $pPaciente . "\",\"" . $pTipDocumento . "\",\"" . $pNumIdentificacion . "\",\"" . $pNomPaciente . "\",\"" . $pEdad . "\",\"" . $pEdadDesde . "\",\"" . $pEdadHasta . "\",\"" . $pSexo . "\",\"" . $pDesInscripcion . "\",\"" . $pHasInscripcion . "\",\"" . $pDesProCita . "\",\"" . $pHasProCita . "\",\"" . $pFecVaciaCita . "\",\"" . $pFecVaciaInscripcion . "\",'" . $start . "','" . $end . "')";
        $gBaseDatos->QryID = @mysqli_query($gBaseDatos->ConexionID, $qry);
        $arr = array();
        while($row = @mysqli_fetch_assoc($gBaseDatos->QryID))
        {
            $nRow = $row;
            foreach($row as $key => $val)
            {
                $nRow[$key] = PonerAcentosHTML($val);
            }
            $arr[] = $nRow;
        }
        $jsonresult = JEncode($arr);
        $gBaseDatos->liberar();
        $gBaseDatos->cerrar();
        echo '({"total":"'.$nbrows.'","results":'.$jsonresult.'})';
    } else {
        echo '({"total":"0", "results":""})';
    }
    $gBaseDatos->liberar();
    $gBaseDatos->cerrar();
}

?>