<?php
session_start();
require("../../../core/php/_database.php");
require("../../../core/php/php_functions.php");
ini_set("display_errors", true);
ini_set("html_errors", true);

class TreeNode {	
    public $text = "";
    public $id = "";
    public $iconCls = "";
    public $leaf = true;
    public $draggable = false;
    public $href = "#";
    public $hrefTarget = "";
    public $idIPS = "";
    public $idBodega = "";
    public $nomBodega = "";
    public $idZona = "";
    public $nomZona = "";
    public $idInventario = "";
    public $tipoInventario = "";
    public $fechaInventario = "";
    public $horaInicio = "";
    public $horaFin = "";
    public $anulado = "";
    public $fecAnulado = "";
    public $motivoAnulado = "";
    public $usuarioAnulado = "";
    public $actaApertura = "";
    public $actaCierre = "";
    public $estadoInventario = "";
    public $idConteo = "";
    public $estadoConteo = "";

    function  __construct($id,$text,$iconCls,$leaf,$draggable,$href,$hrefTarget,$idIPS,$idBodega,$idZona,$idInventario,$tipoInventario,$fechaInventario,$actaApertura,$actaCierre,$estadoInventario, $conteo, $horaInicio, $horaFin, $anulado, $fecAnulado, $usuarioAnulado, $motivoAnulado, $nomBodega, $nomZona, $estadoConteo){
        $this->id = $id;
        $this->text = $text;
        $this->iconCls = $iconCls;
        $this->leaf = $leaf;
        $this->draggable = $draggable;
        $this->href = $href;
        $this->hrefTarget = $hrefTarget;
        $this->idIPS = $idIPS;
        $this->idBodega = $idBodega;
        $this->idZona = $idZona;
        $this->nomBodega = $nomBodega;
        $this->nomZona = $nomZona;
        $this->idInventario = $idInventario;
        $this->tipoInventario = $tipoInventario;
        $this->fechaInventario = $fechaInventario;
        $this->actaApertura = $actaApertura;
        $this->actaCierre = $actaCierre;
        $this->estadoInventario = $estadoInventario;
        $this->idConteo = $conteo;
        $this->estadoConteo = $estadoConteo;
        $this->horaInicio = $horaInicio;
        $this->horaFin = $horaFin;
        $this->anulado = $anulado;
        $this->fecAnulado = $fecAnulado;
        $this->motivoAnulado = $motivoAnulado;
        $this->usuarioAnulado = $usuarioAnulado;
    }
}

class TreeNodes {
    protected $nodes = array();
    function add($id,$text,$iconCls,$leaf,$draggable,$href,$hrefTarget,$idIPS,$idBodega,$idZona,$idInventario,$tipoInventario,$fechaInventario,$actaApertura,$actaCierre,$estadoInventario, $conteo, $horaInicio, $horaFin, $anulado, $fecAnulado, $usuarioAnulado, $motivoAnulado, $nomBodega, $nomZona, $estadoConteo) {
        $n = new TreeNode($id,$text,$iconCls,$leaf,$draggable,$href,$hrefTarget,$idIPS,$idBodega,$idZona,$idInventario,$tipoInventario,$fechaInventario,$actaApertura,$actaCierre,$estadoInventario, $conteo, $horaInicio, $horaFin, $anulado, $fecAnulado, $usuarioAnulado, $motivoAnulado, $nomBodega, $nomZona, $estadoConteo);
        $this->nodes[] = $n;
    }
    function toJson() {
        return json_encode($this->nodes);
    }
}

$requestedNode = "";

if (isset($_REQUEST["node"])) {
    $requestedNode = $_REQUEST["node"];
}

ListarNodos($requestedNode);


function ListarNodos($requestedNode){
    $pEmpresa = isset($_SESSION['ID_EMPRESA']) ? $_SESSION['ID_EMPRESA']:0;
    $pIPS = isset($_SESSION['ID_IPS']) ? $_SESSION['ID_IPS']:0;
    $pBodega = isset($_REQUEST['qryBodega']) ? $_REQUEST['qryBodega']:0;
    if($pBodega == null || $pBodega == ""){
        $pBodega = 0;
    }
    $pZona = isset($_REQUEST['qryZona']) ? $_REQUEST['qryZona']:0;
    if($pZona == null || $pZona == ""){
        $pZona = 0;
    }
    $pInventario = isset($_REQUEST['qryInventario']) ? $_REQUEST['qryInventario']:0;
    if($pInventario == null || $pInventario == ""){
        $pInventario = 0;
    }
    $pEstado = isset($_REQUEST['qryEstado']) ? $_REQUEST['qryEstado']:"Todos";
    if($pEstado == null || $pEstado == ""){
        $pEstado = "Todos";
    }
    $treeNodes = new TreeNodes();
    $txtNodo = substr($requestedNode,0,8);
    $Params = explode("-", $requestedNode);
    $nomIconCls = "";   
    $qry = "";
    switch($txtNodo){
        case "nodeROT-":
            $qry = "CALL sp_inventario_gestion_arbol001('" . $pEmpresa . "','" . $pIPS . "','" . $pBodega . "','" . $pZona . "','" . $pInventario . "')";
            $nomIconCls = "icon-ips";
            break;
        case "nodeIPS-":
            $qry = "CALL sp_inventario_gestion_arbol002('" . $pEmpresa . "','" . $Params[1] . "','" . $pBodega . "','" . $pZona . "','" . $pInventario . "')"; 
            $nomIconCls = "icon-bodega";
            break;
        case "nodeBOD-":
            $qry = "CALL sp_inventario_gestion_arbol003('" . $pEmpresa . "','" . $Params[1] . "','" . $Params[2] . "','" . $pZona . "','" . $pInventario . "')"; 
            $nomIconCls = "icon-zona";
            break;
        case "nodeZON-":
            $qry = "CALL sp_inventario_gestion_arbol004('" . $pEmpresa . "','" . $Params[1] . "','" . $Params[2] . "','" . $Params[3] . "','" . $pInventario . "')"; 
            $nomIconCls = "icon-none";
            break;
        /*case "nodeEST-":
            $qry = "CALL sp_tree_casos_detalle('" . $Params[1] . "','" . $pCaso . "',\"" . $pDescripcion . "\",\"" . $Params[2] . "\")";
            $nomIconCls = "icon-none";
            break;*/
        default:
            break;
    }
    unset($row);
    //echo $qry;
    $gBaseDatos = new ofiMySQLi();
    $gBaseDatos->conectar();
    $gBaseDatos->QryID = @mysqli_query($gBaseDatos->ConexionID, $qry);
    while ($row[] = @mysqli_fetch_assoc($gBaseDatos->QryID));
    $gBaseDatos->liberar();
    $gBaseDatos->cerrar();
    $pRegistros = count($row)-1;
    for($i=0;$i<$pRegistros;$i++)
    {
        $leaf = ($row[$i]["leaf"]=='false' ? false : true);
        $IconCls = $nomIconCls;
        if($nomIconCls == "icon-estadoCasos"){
            switch($row[$i]["IdEstadoCaso"]){
                case "inicial":
                    $IconCls = "icon-CasoInicial";
                    break;
                case "tramite":
                    $IconCls = "icon-CasoTramite";
                    break;
                case "cerrado":
                    $IconCls = "icon-CasoCerrado";
                    break;    
                default:
                    break;
            }
        }
        //add($id,$text,$iconCls,$leaf,$draggable,$href,$hrefTarget,$idIPS,$idBodega,$idZona,$idInventario,$tipoInventario,$fechaInventario,$observacionInvnetario,$estadoInventario) {
        $treeNodes->add($row[$i]["idNodo"],$row[$i]["text"],$IconCls,$leaf,false,"","",$row[$i]["IPS"],$row[$i]["Bodega"],$row[$i]["Zona"],$row[$i]["IdConsecutivoInventario"],$row[$i]["TipoInventario"],$row[$i]["FecInventario"],$row[$i]["ActaApertura"],$row[$i]["ActaCierre"],$row[$i]["EstadoInventario"],$row[$i]["ConteoActual"],$row[$i]["HoraInicio"],$row[$i]["HoraFin"],$row[$i]["Anulado"],$row[$i]["FecAnulado"],$row[$i]["UsuarioAnulado"],$row[$i]["MotivoAnulado"],$row[$i]["nomBodega"],$row[$i]["nomZona"], $row[$i]["EstadoConteo"]);
    }
   echo $treeNodes->toJson();
}
?>