<?php
    require_once('../../../lib/tcpdf/config/lang/spa.php');
    require_once('../../../lib/tcpdf/tcpdf.php');
    require("../../../core/php/_database.php");
    require("../../../core/php/php_functions.php");
    require("../../../core/php/constantes.php");
    //header('Content-type: application/pdf; charset: UTF-8');
    
    session_start();
    $pImprimeTirilla = "NO";
    $pDocumento = isset($_REQUEST['pDocumento'])?$_REQUEST['pDocumento']:0;
    
    //Definicion de las Margenes
    $LeftMargin = PDF_MARGIN_LEFT;
    $TopMargin = 5;
    $RightMargin = PDF_MARGIN_RIGHT;
    $HeaderMargin = PDF_MARGIN_HEADER;
    $BottomMargin = 3;
    $FooterMargin = 5;
    $Alineacion = "P";
    $FormatoPagina = "CARTA";
    $UsaPiePagina = "NO";
    $pTipoEncabezado = "FVP";
      
    //Inicializacion de la Clase
    $pdf = new TCPDF($Alineacion, PDF_UNIT, $FormatoPagina, true, 'UTF-8', false);
    $pdf->pAlineacionEncabezado = $Alineacion;
    $pdf->pTituloInforme = "FACTURA DE VENTA";
    $pdf->pImprimeLogo = "NO";
    $pdf->pAnchoTxtPagina = 210;
    $pdf->pNomEmpresa = $_SESSION['NOM_EMPRESA'];
    $pdf->pTDocEmpresa = $_SESSION['EMPRESA_TDOC'];
    $pdf->pDocEmpresa = $_SESSION['EMPRESA_DOC'];
    $pdf->pDirEmpresa = $_SESSION['EMPRESA_DIR'];
    $pdf->pTelEmpresa = $_SESSION['EMPRESA_TEL'];
    $pdf->pCiuEmpresa = $_SESSION['EMPRESA_CIU'];
    $pdf->pEspEmpresa = $_SESSION['EMPRESA_ESP'];
    $pdf->pRegEmpresa = $_SESSION['EMPRESA_REGIMEN'];
    $pdf->pContribuyentes = $_SESSION['EMPRESA_CONTRIBUYENTE'];
    $pdf->pReteIVA  = $_SESSION['EMPRESA_RTEICA'];
    $pdf->pReteICA = $_SESSION['EMPRESA_RTEIVA'];
            
    $pdf->pTipoEncabezado = $pTipoEncabezado;
    $pdf->pNomSede = $_SESSION['EMPRESA_DOC'];
    $pdf->pNomIPS = $_SESSION['NOM_IPS'];
    $pdf->pMargenPie = -20;
    if($_SESSION['IdAplicacion'] == "OfiMedical"){
        $pdf->pLogoCliente = "../../../consultoriovirtual/" . $_SESSION['IDBD'] . "/logo/logoenc.gif";
    }else{
        $pdf->pLogoCliente = "../../../empresas/" . $_SESSION['ID_EMPRESA'] . "/logo/logoenc.gif";
    }
    $pdf->pPrefijo = $pPrefijo;
    $pdf->pNroDocumento = str_pad($pNroDocumento, 7, "0", STR_PAD_LEFT);
    $pdf->pNroResolucion = $pNroResolucion;
    $pdf->pFechaDoc = $pFechaDocumento;
    $pdf->pCAS = $pCAS;
    $pdf->pTratamiento = $pTratamiento;
    $pdf->pUsaPie = $UsaPiePagina;
        
    $pdf->SetCreator(PDF_CREATOR);
    $pdf->SetAuthor('Sistemas Ofisalud © - 2006');
    $pdf->SetTitle('FACTURACION');
    $pdf->SetSubject('Factura de Venta Institucional');

    $pdf->SetHeaderData($pdf->pLogoCliente, PDF_HEADER_LOGO_WIDTH, $pdf->pTituloInforme, PDF_HEADER_STRING);
    $pdf->setHeaderFont(Array(PDF_FONT_NAME_MAIN, '', PDF_FONT_SIZE_MAIN));
    $pdf->setFooterFont(Array(PDF_FONT_NAME_DATA, '', PDF_FONT_SIZE_DATA));
    $pdf->SetDefaultMonospacedFont(PDF_FONT_MONOSPACED);
    $pdf->SetMargins($LeftMargin, $TopMargin, $RightMargin);
    $pdf->SetHeaderMargin($HeaderMargin);
    $pdf->SetFooterMargin($FooterMargin);
    
    $pdf->SetAutoPageBreak(TRUE, $BottomMargin);
    $pdf->setImageScale(PDF_IMAGE_SCALE_RATIO);
    $pdf->setLanguageArray($l);
    $pdf->setFontSubsetting(true);
    $pdf->SetFont('dejavusans', '', 14, '', true);
            
    $gBaseDatos = new ofiMySQLi();
    $gBaseDatos->conectar();
    $qry = "CALL sp_facturacion_factura_resumen('" . $pDocumento . "')";
    $gBaseDatos->QryID = @mysqli_query($gBaseDatos->ConexionID, $qry);
    while ($row[] = @mysqli_fetch_assoc($gBaseDatos->QryID));
    $gBaseDatos->liberar();
    $gBaseDatos->cerrar();
    $pRegistros = count($row);
    
    $pdf->AddPage();
    if ($pAnulada == 1){
        $img_file = "../../../resources/varios/docanulado.png";
        $pdf->Image($img_file, 110, 8, 80, 50, '', '', '', false, 300, '', false, false, 0);
        $pdf->Image($img_file, 110, 215, 80, 50, '', '', '', false, 300, '', false, false, 0);
    }
    $pdf->Ln(2);
    $pdf->SetFont(PDF_FONT_NAME_MAIN, '', 7);
    $EncabezadoHTML = '<table cellspacing="0" border="0" style="font-size:24px; color:#000;">';
    $EncabezadoHTML .= '<tr><td></td><td height="5" style="font-size:14px; color:#000;" align="rigth">FACTURA POR COMPUTADOR</td></tr>';
    $EncabezadoHTML .= '<tr>';
    $EncabezadoHTML .= '<td>';
    $EncabezadoHTML .= '<span style="font-size:44px; color:#000; font-weight:bold">' . utf8_decode($pdf->pNomEmpresa) . '</span><br>';
    if($pdf->pEspEmpresa != null || $pdf->pEspEmpresa != "")
            $EncabezadoHTML .= '<span style="font-size:34px; color:#000;">' . utf8_decode($pdf->pEspEmpresa) . '</span><br>';
    if($pdf->pTDocEmpresa == "NI")
        $tipodoc = "NIT: ";
    else
        $tipodoc = $pdf->pTDocEmpresa . ": ";
    $EncabezadoHTML .= '<span style="font-size:34px; color:#000;">' . $tipodoc . $pdf->pDocEmpresa . '</span><br>';
    $EncabezadoHTML .= '<span style="font-size:34px; color:#000;">' . $pdf->pDirEmpresa . ' - ' . $pdf->pTelEmpresa . '</span><br>';
    $EncabezadoHTML .= '<span style="font-size:34px; color:#000;">' . $pdf->pCiuEmpresa . '</span><br>';
    if($pdf->pRegEmpresa != null && $pdf->pRegEmpresa != "")
        $EncabezadoHTML .= '<span style="font-size:17px; color:#000; font-weight:bold">' . $pdf->pRegEmpresa . '</span><br>';
    if($pdf->pContribuyentes != null && $pdf->pContribuyentes != "")
        $EncabezadoHTML .= '<span style="font-size:17px; color:#000; font-weight:bold">' . $pdf->pContribuyentes . '</span><br>';
    if($pdf->pReteIVA != null && $pdf->pReteIVA != "")
        $EncabezadoHTML .= '<span style="font-size:17px; color:#000; font-weight:bold">' . $pdf->pReteIVA . '</span><br>';
    if($pdf->pReteICA != null && $pdf->pReteICA != "")
        $EncabezadoHTML .= '<span style="font-size:16px; color:#000; font-weight:bold">' . $pdf->pReteICA . '</span>';
    $EncabezadoHTML .= '</td>';

    //COL2
    $EncabezadoHTML .= '<td>';
    $EncabezadoHTML .= '<span align="rigth" style="font-size:44px; color:#000; font-weight:bold">FACTURA DE VENTA</span><br>';
    $EncabezadoHTML .= '<span align="rigth" style="font-size:40px; color:#000; font-weight:bold">Nro: ' . $row[0]["Prefijo"] . "-" . $row[0]["NroDocumento"] . '</span><br>';
    $EncabezadoHTML .= '<span align="rigth" style="font-size:24px; color:#000;">' . $row[0]["NroResolucion"] . '</span><br>';
    $EncabezadoHTML .= '<span align="rigth" style="font-size:40px; color:#000; font-weight:bold">Fecha Factura: ' .  $row[0]["FechaDocumento"] . '</span><br>';
    $EncabezadoHTML .= '<span align="rigth" style="font-size:30px; color:#000; font-weight:bold">Fecha Vencimiento: ' . $row[0]["FechaVencimiento"] . '</span><br>';
    $EncabezadoHTML .= '</td>';

    $EncabezadoHTML .= '</tr>';
    $EncabezadoHTML .= '</table>';
    $EncabezadoHTML .= '<hr>';
    $pdf->writeHTML($EncabezadoHTML, true, false, false, false, '');
            
    $pdf->SetFont(PDF_FONT_NAME_MAIN,'',10);
    $pdf->MultiCell(17,5,"Cliente:",0,'L',0,0);
    $infoCliente = "";
    if($row[0]["Tdoc"]=="NI")
        $infoCliente .= "NIT: ";
    else
        $infoCliente .= $row[0]["Tdoc"] . ": ";
    $infoCliente .= $row[0]["Documento"];
    if($row[0]["Digitover"]!="" || $row[0]["Digitover"]!=null)
        $infoCliente .= "-" . $row[0]["Digitover"];
    
    $infoCliente .= " " . utf8_decode($row[0]["DescripcionFac"]);
    $rowcount = max($pdf->getNumLines($infoCliente),$pdf->getNumLines(utf8_decode($row[0]["Direccion"]))) * 3;
    $pdf->MultiCell(178,$rowcount,$infoCliente,0,'L',0,0);
    $pdf->Ln(4);
    $pdf->MultiCell(18,$rowcount,"Dirección:",0,'L',0,0);
    $pdf->MultiCell(78,$rowcount,utf8_decode($row[0]["Direccion"]),0,'L',0,0);
    $pdf->MultiCell(18,$rowcount,"Teléfono:",0,'L',0,0);
    $pdf->MultiCell(78,$rowcount,utf8_decode($row[0]["Telefono"]),0,'L',0,0);
    $pdf->Ln(4);
    $pdf->SetLineWidth(0.3); 
    $pdf->Line($pdf->GetX(), $pdf->GetY(), $pdf->GetX()+200, $pdf->GetY()); 
    if($row[0]["Capitacion"] == "1"){
        $pdf->SetFont(PDF_FONT_NAME_MAIN,'B',11);
        $pdf->MultiCell(194,5,"CONCEPTO",0,'C',0,0);
        $pdf->Ln(5);
        $pdf->SetLineWidth(0.3); 
        $pdf->Line($pdf->GetX(), $pdf->GetY(), $pdf->GetX()+200, $pdf->GetY()); 
        $pdf->Ln(2);
        $img_file = "../../../empresas/" . $_SESSION['ID_EMPRESA'] . "/logo/fondofac.png";
        $pdf->Image($img_file, $pdf->GetX()+60, $pdf->GetY()+35, 90, 50, '', '', '', false, 300, '', false, false, 0);
        $pdf->SetFont(PDF_FONT_NAME_MAIN,'',10);
        $pVlrTotal += $row[0]["TVlrTotal"];
        $pVlrIVA += $row[0]["TVlrIVA"];
        $pVlrCopagos += $row[0]["TCM"] + $row[0]["TCOPAGOS"];
        $pVlrDescuentos += $row[0]["TVlrDescuentos"];
        $pVlrNeto += $row[0]["TVlrNeto"];
        $pdf->MultiCell(194,20,strtoupper(utf8_decode($row[0]["ConceptoFac"])),0,'L',0,0);
        $pdf->Ln(25);
        $pdf->MultiCell(50,5,"Nro Usuarios:",0,'L',0,0);
        $pdf->MultiCell(25,5,number_format($row[0]["Poblacion"],0,".",","),0,'R',0,0);
        $pdf->Ln(4);
        $pdf->MultiCell(50,5,"Valor Promedio UPC:",0,'L',0,0);
        $pdf->MultiCell(25,5,"$" . number_format($row[0]["VlrUPC"],2,".",","),0,'R',0,0);
        /*$pdf->Ln(4);
        $pdf->MultiCell(50,5,"Desde:",0,'L',0,0);
        $pdf->MultiCell(25,5,$row[0]["PeriodoDesde"],0,'R',0,0);
        $pdf->Ln(4);
        $pdf->MultiCell(50,5,"Hasta:",0,'L',0,0);
        $pdf->MultiCell(25,5,$row[0]["PeriodoHasta"],0,'R',0,0);
        */
        while ($pdf->GetY() <= ($pdf->getPageHeight()-92)) {
            $pdf->Ln();
        }
        $pdf->Ln();
    }else{
        $pdf->SetFont(PDF_FONT_NAME_MAIN,'B',11);
        $pdf->MultiCell(20,5,"CODIGO",0,'C',0,0);
        $pdf->MultiCell(75,5,"DESCRIPCION",0,'C',0,0);
        $pdf->MultiCell(10,5,"IVA",0,'R',0,0);
        $pdf->MultiCell(25,5,"CANTIDAD",0,'R',0,0);
        $pdf->MultiCell(32,5,"VLR UNITARIO",0,'R',0,0);
        $pdf->MultiCell(32,5,"VLR TOTAL",0,'R',0,0);
        $pdf->Ln(5);
        $pdf->SetLineWidth(0.3); 
        $pdf->Line($pdf->GetX(), $pdf->GetY(), $pdf->GetX()+200, $pdf->GetY()); 
        $pdf->Ln(1);

        $img_file = "../../../empresas/" . $_SESSION['ID_EMPRESA'] . "/logo/fondofac.png";
        $pdf->Image($img_file, $pdf->GetX()+60, $pdf->GetY()+35, 90, 50, '', '', '', false, 300, '', false, false, 0);

        $pdf->SetFont(PDF_FONT_NAME_MAIN,'',10);
        $pVlrTotal = 0;
        $pVlrIVA = 0;
        $pVlrCopagos = 0;
        $pVlrDescuentos = 0;
        $pVlrNeto = 0;
        for($i=0;$i<$pRegistros;$i++)
        {
            if($row[$i]["DescProcedimiento"] != ""){
                if($row[$i]["VlrTotal"] != 0){
                    $pdf->SetFont(PDF_FONT_NAME_MAIN, '', 7);
                    $rowcount = 0;
                    $rowcount = $pdf->getNumLines(utf8_decode($row[$i]["DescProcedimiento"]), 75) * 3;
                    $pdf->MultiCell(20,$rowcount,utf8_decode($row[$i]["CUPSCodigo"]),0,'L',0,0);
                    $pdf->MultiCell(75,$rowcount,utf8_decode($row[$i]["DescProcedimiento"]),0,'L',0,0);
                    $pdf->MultiCell(10,$rowcount,number_format(0,0,".",","),0,'C',0,0);
                    $pdf->MultiCell(25,$rowcount,number_format($row[$i]["Cantidad"],0,".",","),0,'R',0,0);
                    $pdf->MultiCell(32,$rowcount,"$ " . number_format(($row[$i]["VlrTotal"]/$row[$i]["Cantidad"]),2,".",","),0,'R',0,0);
                    $pdf->MultiCell(32,$rowcount,"$ " . number_format($row[$i]["VlrTotal"],2,".",","),0,'R',0,0);
                    $pdf->Ln($rowcount+2);
                    if($pdf->GetY() >= ($pdf->getPageHeight()-62))
                    {
                        ImprimeEncabezadoFactura($pdf);
                    }
                }
                $pVlrTotal += $row[$i]["VlrTotal"];
                $pVlrIVA += $row[$i]["VlrIVA"];
                $pVlrCopagos += $row[$i]["CM"] + $row[$i]["COPAGOS"];
                $pVlrDescuentos += $row[$i]["VlrDescuentos"];
                $pVlrNeto += $row[$i]["VlrNeto"];
            }
        }
        
        $pdf->Ln($rowcount+2);
        $rowcount = 0;
        $rowcount = $pdf->getNumLines(utf8_decode($row[0]["ConceptoFac"]), 190) * 3;
        $pdf->MultiCell(190,$rowcount,utf8_decode($row[0]["Concepto"]),0,'L',0,0);
        while ($pdf->GetY() <= ($pdf->getPageHeight()-62)) {
            $pdf->Ln();
        }
        $pdf->Ln();
    }
    
    $pdf->SetFont(PDF_FONT_NAME_MAIN, '', 7);
    $val = strtoupper(utf8_decode(numerotexto($pVlrNeto)));
    $EncabezadoHTML = '
    <table border="1" cellspacing="0" >
        <tr>
            <td width="520">&nbsp;<br>&nbsp;SON: '. $val . ' PESOS M/CTE.</td>
            <td width="180">
                <table border="0" cellspacing="0">
                    <tr>
                        <td width="70">TOTAL:</td>
                        <td width="100" align="rigth">$ ' . number_format($pVlrTotal,2,".",",") . '</td>
                    </tr>
                    <tr>
                        <td>IVA:</td>
                        <td width="100" align="rigth">$ ' . number_format($pVlrIVA,2,".",",") . '</td>
                    </tr>
                    <tr>
                        <td>COPAGOS:</td>
                        <td width="100" align="rigth">$ ' . number_format($pVlrCopagos,2,".",",") . '</td>
                    </tr>
                    <tr>
                        <td>DESCUENTOS:</td>
                        <td width="100" align="rigth">$ ' . number_format($pVlrDescuentos,2,".",",") . '</td>
                    </tr>
                    <tr>
                        <td>NETO:</td>
                        <td width="100" align="rigth">$ ' . number_format($pVlrNeto,2,".",",") . '</td>
                    </tr>
                </table>
            </td>
        </tr>
        <tr>
            <td colspan="2">
                <table border="0" cellspacing="0">
                    <tr>
                        <td width="525">
                            <span style="font-size:29px; color:#000;">
                            AUTORIZADO A RECIBIR ESTA FACTURA
                            </span><br><br>
                            <span style="font-size:24px; color:#000;">
                            NOMBRES Y APELLIDOS:&nbsp;&nbsp;__________________________________________________
                            </span><br>
                            <span style="font-size:24px; color:#000;">
                            Nro. IDENTIFICACION:&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;__________________________________________________
                            </span><br>
                            <span style="font-size:24px; color:#000;">
                            FECHA DE RECIBIDO:&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;__________________________________________________
                            </span><br><br>
                            <span style="font-size:24px; color:#000;">
                            FIRMA Y SELLO
                            </span>
                        </td>
                        <td width="160" align="rigth">
                            <span style="font-size:25px; color:#000;">DESCUENTO PIE FACTURA PRONTO PAGO %_____</span><br><br>
                            <span style="font-size:19px; color:#000;">Sede:'. $_SESSION['NOM_SEDE'] . '<br>
                            IPS:'. $_SESSION['NOM_IPS'] . '</span><br><br><br><br>
                            <span style="font-size:16px; color:#000;">
                            SOFTWARE OFICLINIC© 2006 - Tel. 3016398114
                            </span>
                        </td>
                    </tr>
                </table>
            </td>
        </tr>
    </table>
    <span style="font-size:18px; color:#000;">ESTA FACTURA DE VENTA SE ASIMILA PARA TODOS SUS EFECTOS A LA LETRA DE CAMBIO ART. 779 DEL CODIGO DE COMERCIO Y ARTICULO 5 LEY 
1231 DE 2008. SE CAUSARA INTERES DE MORA POR CADA DIA DE LA TASA DEL (  ) MENSUAL SIN PERJUICIO DE LA ACCION LEGAL POR INCUMPLIMIENTO DE PAGO
    </span>';
    $pdf->writeHTML($EncabezadoHTML, true, false, false, false, '');
    $pdf->Output('FacturaVenta' . $row[0]["Prefijo"] . "-" . $row[0]["NroDocumento"] . '.pdf', 'I');

    function ImprimeEncabezadoFactura(&$pdf){
        $pdf->AddPage();
        $pdf->Ln(2);
        $pdf->SetFont(PDF_FONT_NAME_MAIN, '', 7);
        $EncabezadoHTML = '<table cellspacing="0" border="0" style="font-size:24px; color:#000;">';
        $EncabezadoHTML .= '<tr><td></td><td height="5" style="font-size:14px; color:#000;" align="rigth">FACTURA POR COMPUTADOR</td></tr>';
        $EncabezadoHTML .= '<tr>';
        $EncabezadoHTML .= '<td>';
        $EncabezadoHTML .= '<span style="font-size:44px; color:#000; font-weight:bold">' . utf8_decode($pdf->pNomEmpresa) . '</span><br>';
        if($pdf->pEspEmpresa != null || $pdf->pEspEmpresa != "")
                $EncabezadoHTML .= '<span style="font-size:34px; color:#000;">' . utf8_decode($pdf->pEspEmpresa) . '</span><br>';
        if($pdf->pTDocEmpresa == "NI")
            $tipodoc = "NIT: ";
        else
            $tipodoc = $pdf->pTDocEmpresa . ": ";
        $EncabezadoHTML .= '<span style="font-size:34px; color:#000;">' . $tipodoc . $pdf->pDocEmpresa . '</span><br>';
        $EncabezadoHTML .= '<span style="font-size:34px; color:#000;">' . $pdf->pDirEmpresa . ' - ' . $pdf->pTelEmpresa . '</span><br>';
        $EncabezadoHTML .= '<span style="font-size:34px; color:#000;">' . $pdf->pCiuEmpresa . '</span><br>';
        if($pdf->pRegEmpresa != null && $pdf->pRegEmpresa != "")
            $EncabezadoHTML .= '<span style="font-size:17px; color:#000; font-weight:bold">' . $pdf->pRegEmpresa . '</span><br>';
        if($pdf->pContribuyentes != null && $pdf->pContribuyentes != "")
            $EncabezadoHTML .= '<span style="font-size:17px; color:#000; font-weight:bold">' . $pdf->pContribuyentes . '</span><br>';
        if($pdf->pReteIVA != null && $pdf->pReteIVA != "")
            $EncabezadoHTML .= '<span style="font-size:17px; color:#000; font-weight:bold">' . $pdf->pReteIVA . '</span><br>';
        if($pdf->pReteICA != null && $pdf->pReteICA != "")
            $EncabezadoHTML .= '<span style="font-size:16px; color:#000; font-weight:bold">' . $pdf->pReteICA . '</span>';
        $EncabezadoHTML .= '</td>';

        //COL2
        $EncabezadoHTML .= '<td>';
        $EncabezadoHTML .= '<span align="rigth" style="font-size:44px; color:#000; font-weight:bold">FACTURA DE VENTA</span><br>';
        $EncabezadoHTML .= '<span align="rigth" style="font-size:40px; color:#000; font-weight:bold">Nro: ' . $row[0]["Prefijo"] . "-" . $row[0]["NroDocumento"] . '</span><br>';
        $EncabezadoHTML .= '<span align="rigth" style="font-size:40px; color:#000; font-weight:bold">Fecha: ' .  $row[0]["FechaDocumento"] . '</span><br>';
        $EncabezadoHTML .= '<span align="rigth" style="font-size:24px; color:#000;">' . $row[0]["NroResolucion"] . '</span><br>';
        $EncabezadoHTML .= '<span align="rigth" style="font-size:30px; color:#000; font-weight:bold">Fecha Vencimiento: ' . $row[0]["FechaVencimiento"] . '</span><br>';
        $EncabezadoHTML .= '</td>';

        $EncabezadoHTML .= '</tr>';
        $EncabezadoHTML .= '</table>';
        $EncabezadoHTML .= '<hr>';
        $img_file = "../../../empresas/" . $_SESSION['ID_EMPRESA'] . "/logo/fondofac.png";
        $pdf->Image($img_file, $pdf->GetX()+60, $pdf->GetY()+35, 90, 50, '', '', '', false, 300, '', false, false, 0);
    }
    
?>
