<?php
    require_once('../../../lib/tcpdf/config/lang/spa.php');
    require_once('../../../lib/tcpdf/tcpdf.php');
    require("../../../core/php/_database.php");
    require("../../../core/php/php_functions.php");
    require("../../../core/php/constantes.php");
    //header('Content-type: application/pdf; charset: UTF-8');
    
    session_start();
    $pImprimeTirilla = "NO";
    $pCAS = isset($_REQUEST['pCAS'])?$_REQUEST['pCAS']:0;
    
    //Definicion de las Margenes
    $LeftMargin = PDF_MARGIN_LEFT;
    $TopMargin = 5;
    $RightMargin = PDF_MARGIN_RIGHT;
    $HeaderMargin = PDF_MARGIN_HEADER;
    $BottomMargin = 3;
    $FooterMargin = 5;
    $Alineacion = "P";
    $FormatoPagina = "CARTA";
    $UsaPiePagina = "SI";
    $pTipoEncabezado = "FVP";
    $pControlSalto = 30;
      
    //Inicializacion de la Clase
    $pdf = new TCPDF($Alineacion, PDF_UNIT, $FormatoPagina, true, 'UTF-8', false);
    $pdf->pAlineacionEncabezado = $Alineacion;
    $pdf->pTituloInforme = "FACTURA DE VENTA";
    $pdf->pImprimeLogo = "NO";
    $pdf->pAnchoTxtPagina = 210;
    $pdf->pNomEmpresa = $_SESSION['NOM_EMPRESA'];
    $pdf->pTDocEmpresa = $_SESSION['EMPRESA_TDOC'];
    $pdf->pDocEmpresa = $_SESSION['EMPRESA_DOC'];
    $pdf->pDirEmpresa = $_SESSION['EMPRESA_DIR'];
    $pdf->pTelEmpresa = $_SESSION['EMPRESA_TEL'];
    $pdf->pCiuEmpresa = $_SESSION['EMPRESA_CIU'];
    $pdf->pEspEmpresa = $_SESSION['EMPRESA_ESP'];
    $pdf->pRegEmpresa = $_SESSION['EMPRESA_REGIMEN'];
    $pdf->pContribuyentes = $_SESSION['EMPRESA_CONTRIBUYENTE'];
    $pdf->pReteIVA  = $_SESSION['EMPRESA_RTEICA'];
    $pdf->pReteICA = $_SESSION['EMPRESA_RTEIVA'];
            
    $pdf->pTipoEncabezado = $pTipoEncabezado;
    $pdf->pNomSede = $_SESSION['EMPRESA_DOC'];
    $pdf->pNomIPS = $_SESSION['NOM_IPS'];
    $pdf->pMargenPie = -20;
    $pdf->pLogoCliente = "../../../empresas/" . $_SESSION['ID_EMPRESA'] . "/logo/logoenc.gif";
    $pdf->pPrefijo = $pPrefijo;
    $pdf->pNroDocumento = str_pad($pNroDocumento, 7, "0", STR_PAD_LEFT);
    $pdf->pNroResolucion = $pNroResolucion;
    $pdf->pFechaDoc = $pFechaDocumento;
    $pdf->pCAS = $pCAS;
    $pdf->pTratamiento = $pTratamiento;
    $pdf->pUsaPie = $UsaPiePagina;
        
    $pdf->SetCreator(PDF_CREATOR);
    $pdf->SetAuthor('Sistemas Ofisalud © - 2006');
    $pdf->SetTitle('RIPS');
    $pdf->SetSubject('Soporte RIPS');

    $pdf->SetHeaderData($pdf->pLogoCliente, PDF_HEADER_LOGO_WIDTH, $pdf->pTituloInforme, PDF_HEADER_STRING);
    $pdf->setHeaderFont(Array(PDF_FONT_NAME_MAIN, '', PDF_FONT_SIZE_MAIN));
    $pdf->setFooterFont(Array(PDF_FONT_NAME_DATA, '', PDF_FONT_SIZE_DATA));
    $pdf->SetDefaultMonospacedFont(PDF_FONT_MONOSPACED);
    $pdf->SetMargins($LeftMargin, $TopMargin, $RightMargin);
    $pdf->SetHeaderMargin($HeaderMargin);
    $pdf->SetFooterMargin($FooterMargin);
    
    $pdf->SetAutoPageBreak(TRUE, $BottomMargin);
    $pdf->setImageScale(PDF_IMAGE_SCALE_RATIO);
    $pdf->setLanguageArray($l);
    $pdf->setFontSubsetting(true);
    $pdf->SetFont('dejavusans', '', 14, '', true);
            
    $pdf->AddPage();
    if ($pAnulada == 1){
        $img_file = "../../../resources/varios/docanulado.png";
        $pdf->Image($img_file, 110, 8, 80, 50, '', '', '', false, 300, '', false, false, 0);
        $pdf->Image($img_file, 110, 215, 80, 50, '', '', '', false, 300, '', false, false, 0);
    }
    $pdf->Ln(2);
    $pdf->SetFont(PDF_FONT_NAME_MAIN, '', 7);
    $EncabezadoHTML = '<table cellspacing="0" border="0" style="font-size:24px; color:#000;">';
    $EncabezadoHTML .= '<tr>';
    $EncabezadoHTML .= '<td>';
    $EncabezadoHTML .= '<span style="font-size:44px; color:#000; font-weight:bold">' . utf8_decode($pdf->pNomEmpresa) . '</span><br>';
    if($pdf->pEspEmpresa != null || $pdf->pEspEmpresa != "")
            $EncabezadoHTML .= '<span style="font-size:34px; color:#000;">' . utf8_decode($pdf->pEspEmpresa) . '</span><br>';
    if($pdf->pTDocEmpresa == "NI")
        $tipodoc = "NIT: ";
    else
        $tipodoc = $pdf->pTDocEmpresa . ": ";
    $EncabezadoHTML .= '<span style="font-size:34px; color:#000;">' . $tipodoc . $pdf->pDocEmpresa . '</span><br>';
    $EncabezadoHTML .= '<span style="font-size:34px; color:#000;">' . $pdf->pDirEmpresa . ' - ' . $pdf->pTelEmpresa . '</span><br>';
    $EncabezadoHTML .= '<span style="font-size:34px; color:#000;">' . $pdf->pCiuEmpresa . '</span><br>';
    $EncabezadoHTML .= '</td>';

    //COL2
    $EncabezadoHTML .= '<td>';
    $EncabezadoHTML .= '<span align="rigth" style="font-size:44px; color:#000; font-weight:bold">SOPORTE RIPS</span><br>';
    $EncabezadoHTML .= '<span align="rigth" style="font-size:40px; color:#000; font-weight:bold">CAS: ' . $pCAS . '</span><br>';
    $EncabezadoHTML .= '</td>';
    $EncabezadoHTML .= '</tr>';
    $EncabezadoHTML .= '</table>';
    $pdf->writeHTML($EncabezadoHTML, true, false, false, false, '');
    $gBaseDatos = new ofiMySQLi();
    $gBaseDatos->conectar();
    $qry = "CALL sp_facturacion_ripsxcas('" . $pCAS . "')";
    $gBaseDatos->QryID = @mysqli_query($gBaseDatos->ConexionID, $qry);
    while ($row[] = @mysqli_fetch_assoc($gBaseDatos->QryID));
    $gBaseDatos->liberar();
    $gBaseDatos->cerrar();
    $pRegistros = count($row);
    $infoCliente = "";
    if($row[0]["Tdoc"]=="NI"){
        $infoCliente .= "NIT: ";
    }else{
        $infoCliente .= $row[0]["Tdoc"] . ": ";
    }
    $infoCliente .= $row[0]["Documento"];
    if($row[0]["Digitover"]!="" || $row[0]["Digitover"]!=null){
        $infoCliente .= "-" . $row[0]["Digitover"];
    }
    $infoCliente .= " " . utf8_decode($row[0]["DescripcionFac"]);
    $pdf->SetFont('dejavusans', '', 14, '', true);
    $myHTML = '<hr>';
    $myHTML = '<span style="font-size:34px"><b>ENTIDAD: </b>' . $infoCliente . '<b>&nbsp;&nbsp;- CODIGO: </b>' . $row[0]["CodigoSUPERSALUD"] . '</span><br><hr>';
    $myHTML .= '<span style="font-size:34px"><b>RIPS US - (USUARIOS)</b></span>';
    $pdf->writeHTML($myHTML, true, false, false, false, '');
    if($pdf->GetY() >= ($pdf->getPageHeight()-$pControlSalto)){
        ImprimeEncabezadoRIPS($pdf);
    }
    $myHTML = '<table border="0" cellspacing="0" style="font-size:34px">';
    $myHTML .= '<tr>';
    $myHTML .= '<td width="100"><b>TDoc: </b>' . utf8_decode($row[0]["TipDoc"]) . '</td>';
    $myHTML .= '<td width="250"><b>Documento: </b>' . utf8_decode($row[0]["Documento"]) . '</td>';
    $myHTML .= '<td width="100"><b>Genero: </b>' . utf8_decode($row[0]["Genero"]) . '</td>';
    $myHTML .= '<td width="150"><b>Tipo Usuario: </b>' . utf8_decode($row[0]["TipoAfiliado"]) . '</td>';
    $myHTML .= '</tr>';
    $myHTML .= '<tr>';
    $myHTML .= '<td width="180"><b>1er Apellido: </b><br>' . utf8_decode($row[0]["PrimerApellido"]) . '</td>';
    $myHTML .= '<td width="180"><b>2do Apellido: </b><br>' . utf8_decode($row[0]["SegundoApellido"]) . '</td>';
    $myHTML .= '<td width="180"><b>1er Nombre: </b><br>' . utf8_decode($row[0]["PrimerNombre"]) . '</td>';
    $myHTML .= '<td width="180"><b>2do Nombre: </b><br>' . utf8_decode($row[0]["SegundoNombre"]) . '</td>';
    $myHTML .= '</tr>';
    $myHTML .= '<tr>';
    $myHTML .= '<td width="300"><b>Edad: </b><br>' . CalcularEdadComleta($row[0]["FecNac"], $row[0]["Fecha"]) . '</td>';
    $myHTML .= '<td width="300"><b>Departamento - Municipio - Zona: </b><br>' . utf8_decode($row[0]["DeptoMunici"]) . ' - ' . utf8_decode($row[0]["Zona"]) . '</td>';
    $myHTML .= '</tr>';
    $myHTML .= '<tr>';
    $myHTML .= '<td><b>Direccion - Telefonos: </b><br>' . utf8_decode($row[0]["Direccion"]) . '&nbsp;&nbsp;,Tels:( ' . utf8_decode($row[0]["Telefono"]) . ' - ' . utf8_decode($row[0]["Telefono1"]) . ')</td>';
    $myHTML .= '</tr>';
    $myHTML .= '</table><hr>';
    $pdf->writeHTML($myHTML, true, false, false, false, '');
    if($pdf->GetY() >= ($pdf->getPageHeight()-$pControlSalto)){
        ImprimeEncabezadoRIPS($pdf);
    }
    //RIPS AC
    $qry = "CALL sp_facturacion_ripsxcas_ac('" . $pCAS . "')";
    $gBaseDatos = new ofiMySQLi();
    $gBaseDatos->conectar();
    $gBaseDatos->QryID = @mysqli_query($gBaseDatos->ConexionID, $qry);
    while ($rowAC[] = @mysqli_fetch_assoc($gBaseDatos->QryID));
    $gBaseDatos->liberar();
    $gBaseDatos->cerrar();
    $pRegistros = 0;
    $pRegistros = count($rowAC);
    if($pRegistros > 0){
        $myHTML = '<br><span style="font-size:34px"><b>RIPS AC - (CONSULTAS)</b></span>';
        $pdf->writeHTML($myHTML, true, false, false, false, '');
        if($pdf->GetY() >= ($pdf->getPageHeight()-$pControlSalto)){
            ImprimeEncabezadoRIPS($pdf);
        }
        for($i=0;$i<$pRegistros;$i++){
            if($rowAC[$i]["CUPSDescripcion"] != "" && $rowAC[$i]["CUPSDescripcion"] != null){
                $myHTML = '<table border="0" cellspacing="0" style="font-size:34px">';
                $myHTML .= '<tr>';
                $myHTML .= '<td width="130"><b>Fecha: </b>' . utf8_decode($rowAC[$i]["Fecha"]) . '</td>';
                $myHTML .= '<td width="300"><b>Autorizacion: </b>' . utf8_decode($rowAC[$i]["NroAutorizacion"]) . '</td>';
                $myHTML .= '</tr>';
                $myHTML .= '<tr>';
                $myHTML .= '<td width="650"><b>Codigo: </b>' . utf8_decode($rowAC[$i]["CUPSCodigo"]) . ' - ' . utf8_decode($rowAC[$i]["CUPSDescripcion"]) . '</td>';
                $myHTML .= '</tr>';
                $myHTML .= '<tr>';
                $myHTML .= '<td width="100"><b>Finalidad: </b>' . utf8_decode($rowAC[$i]["FinalidadConsulta"]) . '</td>';
                $myHTML .= '<td width="130"><b>Causa Externa: </b>' . utf8_decode($rowAC[$i]["CausaExterna"]) . '</td>';
                $myHTML .= '<td width="150"><b>Tipo Diagostico: </b>' . utf8_decode($rowAC[$i]["TipDagnostico"]) . '</td>';
                $myHTML .= '</tr>';
                $myHTML .= '<tr>';
                $myHTML .= '<td width="120"><b>Dx Ppal: </b>' . utf8_decode($rowAC[$i]["Diagnostico"]) . '</td>';
                $myHTML .= '<td width="120"><b>Dx Rel1: </b>' . utf8_decode($rowAC[$i]["Diagnostico1"]) . '</td>';
                $myHTML .= '<td width="120"><b>Dx Rel2: </b>' . utf8_decode($rowAC[$i]["Diagnostico2"]) . '</td>';
                $myHTML .= '<td width="120"><b>Dx Rel3: </b>' . utf8_decode($rowAC[$i]["Diagnostico3"]) . '</td>';
                $myHTML .= '</tr>';
                $myHTML .= '<tr>';
                $myHTML .= '<td width="200"><b>Total: </b>' . number_format($rowAC[$i]["VlrTotal"],2,".",",") . '</td>';
                $myHTML .= '<td width="280"><b>- Cuota Moderadora: </b>' . number_format($rowAC[$i]["VlrCuotaModeradora"],2,".",",") . '</td>';
                $myHTML .= '<td width="200"><b>Neto: </b>' . number_format($rowAC[$i]["VlrNeto"],2,".",",") . '</td>';
                $myHTML .= '</tr>';
                $myHTML .= '</table><hr>';
                $pdf->writeHTML($myHTML, true, false, false, false, '');
                if($pdf->GetY() >= ($pdf->getPageHeight()-$pControlSalto)){
                    ImprimeEncabezadoRIPS($pdf);
                }
            }
        }
    }
    //RIPS AP
    $qry = "CALL sp_facturacion_ripsxcas_ap('" . $pCAS . "')";
    $gBaseDatos = new ofiMySQLi();
    $gBaseDatos->conectar();
    $gBaseDatos->QryID = @mysqli_query($gBaseDatos->ConexionID, $qry);
    while ($rowAP[] = @mysqli_fetch_assoc($gBaseDatos->QryID));
    $gBaseDatos->liberar();
    $gBaseDatos->cerrar();
    $pRegistros = 0;
    $pRegistros = count($rowAP);
    if($rowAP[0]["CUPSDescripcion"] != "" && $rowAP[0]["CUPSDescripcion"] != null){
        $myHTML = '<br><span style="font-size:34px"><b>RIPS AP - (PROCEDIMIENTOS)</b></span>';
        $pdf->writeHTML($myHTML, true, false, false, false, '');
        if($pdf->GetY() >= ($pdf->getPageHeight()-$pControlSalto)){
            ImprimeEncabezadoRIPS($pdf);
        }
        for($i=0;$i<$pRegistros;$i++){
            if($rowAP[$i]["CUPSDescripcion"] != "" && $rowAP[$i]["CUPSDescripcion"] != null){
                $myHTML = '<table border="0" cellspacing="0" style="font-size:34px">';
                $myHTML .= '<tr>';
                if($rowAP[$i]["Fecha"] == "" || $rowAP[$i]["Fecha"] == null){
                    $myHTML .= '<td width="130"><b>Fecha: </b>' . utf8_decode($rowAP[$i]["FechaEstudio"]) . '</td>';
                }else{
                    $myHTML .= '<td width="130"><b>Fecha: </b>' . utf8_decode($rowAP[$i]["Fecha"]) . '</td>';
                }
                $myHTML .= '<td width="300"><b>Autorizacion: </b>' . utf8_decode($rowAP[$i]["NroAutorizacion"]) . '</td>';
                $myHTML .= '</tr>';
                $myHTML .= '<tr>';
                $myHTML .= '<td width="650"><b>Codigo: </b>' . utf8_decode($rowAP[$i]["CUPSCodigo"]) . ' - ' . utf8_decode($rowAP[$i]["CUPSDescripcion"]) . '</td>';
                $myHTML .= '</tr>';
                $myHTML .= '<tr>';
                $myHTML .= '<td width="100"><b>Ambito: </b>' . utf8_decode($rowAP[$i]["Ambito"]) . '</td>';
                $myHTML .= '<td width="130"><b>Finalidad: </b>' . utf8_decode($rowAP[$i]["Finalidad"]) . '</td>';
                $myHTML .= '<td width="150"><b>Personal Atiende: </b>' . utf8_decode($rowAP[$i]["PersonaAtiende"]) . '</td>';
                $myHTML .= '<td width="150"><b>Forma Acto: </b>' . utf8_decode($rowAP[$i]["FormaActo"]) . '</td>';
                $myHTML .= '</tr>';
                $myHTML .= '<tr>';
                $myHTML .= '<td width="120"><b>Dx Ppal: </b>' . utf8_decode($rowAP[$i]["Diagnostico"]) . '</td>';
                $myHTML .= '<td width="120"><b>Dx Rel1: </b>' . utf8_decode($rowAP[$i]["Diagnostico1"]) . '</td>';
                $myHTML .= '<td width="240"><b>Dx Complicacion: </b>' . utf8_decode($rowAP[$i]["Diagnostico2"]) . '</td>';
                $myHTML .= '</tr>';
                $myHTML .= '<tr>';
                $myHTML .= '<td width="200"><b>Total: </b>' . number_format($rowAP[$i]["VlrTotal"],2,".",",") . '</td>';
                $myHTML .= '<td width="200"><b>- Copagos: </b>' . number_format($rowAP[$i]["VlrCuotaModeradora"]+$rowAP[$i]["VlrCopagos"],2,".",",") . '</td>';
                $myHTML .= '<td width="200"><b>Neto: </b>' . number_format($rowAP[$i]["VlrNeto"],2,".",",") . '</td>';
                $myHTML .= '</tr>';
                $myHTML .= '</table><hr>';
                $pdf->writeHTML($myHTML, true, false, false, false, '');
                if($pdf->GetY() >= ($pdf->getPageHeight()-$pControlSalto)){
                    ImprimeEncabezadoRIPS($pdf);
                }
            }
        }
    }
    //RIPS AU
    $qry = "CALL sp_facturacion_ripsxcas_au('" . $pCAS . "')";
    $gBaseDatos = new ofiMySQLi();
    $gBaseDatos->conectar();
    $gBaseDatos->QryID = @mysqli_query($gBaseDatos->ConexionID, $qry);
    while ($rowAU[] = @mysqli_fetch_assoc($gBaseDatos->QryID));
    $gBaseDatos->liberar();
    $gBaseDatos->cerrar();
    $pRegistros = 0;
    $pRegistros = count($rowAU);
    if($rowAU[0]["FechaIngreso"] != "" && $rowAU[0]["FechaIngreso"] != null){
        $myHTML = '<br><span style="font-size:34px"><b>RIPS AU - (URGENCIAS)</b></span>';
        $pdf->writeHTML($myHTML, true, false, false, false, '');
        if($pdf->GetY() >= ($pdf->getPageHeight()-$pControlSalto)){
            ImprimeEncabezadoRIPS($pdf);
        }
        for($i=0;$i<$pRegistros;$i++){
            if($rowAU[$i]["FechaIngreso"] != "" && $rowAU[$i]["FechaIngreso"] != null){
                $myHTML = '<table border="0" cellspacing="0" style="font-size:34px">';
                $myHTML .= '<tr>';
                $myHTML .= '<td width="200"><b>Fecha Ingreso: </b>' . utf8_decode($rowAU[$i]["FechaIngreso"]) . '</td>';
                $myHTML .= '<td width="200"><b>Hora Ingreso: </b>' . utf8_decode($rowAU[$i]["HoraIngreso"]) . '</td>';
                $myHTML .= '<td width="300"><b>Autorizacion: </b>' . utf8_decode($rowAU[$i]["NroAutorizacion"]) . '</td>';
                $myHTML .= '</tr>';
                $myHTML .= '<tr>';
                $myHTML .= '<td width="150"><b>Causa Externa: </b>' . utf8_decode($rowAU[$i]["CausaExterna"]) . '</td>';
                $myHTML .= '<td width="180"><b>Salida - Dx Ppal: </b>' . utf8_decode($rowAU[$i]["DiagnosticoSalida"]) . '</td>';
                $myHTML .= '<td width="120"><b>Dx Rel1: </b>' . utf8_decode($rowAU[$i]["DiagnosticoSalidaRel1"]) . '</td>';
                $myHTML .= '<td width="120"><b>Dx Rel2: </b>' . utf8_decode($rowAU[$i]["DiagnosticoSalidaRel2"]) . '</td>';
                $myHTML .= '<td width="120"><b>Dx Rel3: </b>' . utf8_decode($rowAU[$i]["DiagnosticoSalidaRel3"]) . '</td>';
                $myHTML .= '</tr>';
                $myHTML .= '<tr>';
                if($rowAU[$i]["DestinoSalida"] == "" || $rowAU[$i]["DestinoSalida"] == null){
                    $myHTML .= '<td width="120"><b>Destino: </b>1</td>';
                }else{
                    $myHTML .= '<td width="120"><b>Destino: </b>' . utf8_decode($rowAU[$i]["DestinoSalida"]) . '</td>';
                }
                if($rowAU[$i]["EstadoSalida"] == "" || $rowAU[$i]["EstadoSalida"] == null){
                    $myHTML .= '<td width="120"><b>Estado: </b>1</td>';
                }else{
                    $myHTML .= '<td width="120"><b>Estado: </b>' . utf8_decode($rowAU[$i]["EstadoSalida"]) . '</td>';
                }
                if($rowAU[$i]["EstadoSalida"] == "2" || $rowAU[$i]["EstadoSalida"] == 2){
                    $myHTML .= '<td width="120"><b>Causa Muerte: </b>' . utf8_decode($rowAU[$i]["CausaMuerte"]) . '</td>';
                }
                $myHTML .= '</tr>';
                $myHTML .= '<tr>';
                $myHTML .= '<td width="200"><b>Fecha Salida: </b>' . utf8_decode($rowAU[$i]["FechaSalida"]) . '</td>';
                $myHTML .= '<td width="200"><b>Hora Salida: </b>' . utf8_decode($rowAU[$i]["HoraSalida"]) . '</td>';
                $myHTML .= '</tr>';
                $myHTML .= '</table><hr>';
                $pdf->writeHTML($myHTML, true, false, false, false, '');
                if($pdf->GetY() >= ($pdf->getPageHeight()-$pControlSalto)){
                    ImprimeEncabezadoRIPS($pdf);
                }
            }
        }
    }
    //RIPS AH
    $qry = "CALL sp_facturacion_ripsxcas_ah('" . $pCAS . "')";
    $gBaseDatos = new ofiMySQLi();
    $gBaseDatos->conectar();
    $gBaseDatos->QryID = @mysqli_query($gBaseDatos->ConexionID, $qry);
    while ($rowAH[] = @mysqli_fetch_assoc($gBaseDatos->QryID));
    $gBaseDatos->liberar();
    $gBaseDatos->cerrar();
    $pRegistros = 0;
    $pRegistros = count($rowAU);
    if($rowAH[0]["FechaIngreso"] != "" && $rowAH[0]["FechaIngreso"] != null){
        $myHTML = '<br><span style="font-size:34px"><b>RIPS AH - (HOSPITALIZACION)</b></span>';
        $pdf->writeHTML($myHTML, true, false, false, false, '');
        if($pdf->GetY() >= ($pdf->getPageHeight()-$pControlSalto)){
            ImprimeEncabezadoRIPS($pdf);
        }
        for($i=0;$i<$pRegistros;$i++){
            if($rowAH[$i]["FechaIngreso"] != "" && $rowAH[$i]["FechaIngreso"] != null){
                $myHTML = '<table border="0" cellspacing="0" style="font-size:34px">';
                $myHTML .= '<tr>';
                $myHTML .= '<td width="200"><b>Fecha Ingreso: </b>' . utf8_decode($rowAH[$i]["FechaIngreso"]) . '</td>';
                $myHTML .= '<td width="200"><b>Hora Ingreso: </b>' . utf8_decode($rowAH[$i]["HoraIngreso"]) . '</td>';
                $myHTML .= '<td width="300"><b>Autorizacion: </b>' . utf8_decode($rowAH[$i]["NroAutorizacion"]) . '</td>';
                $myHTML .= '</tr>';
                $myHTML .= '<tr>';
                $myHTML .= '<td width="150"><b>Causa Externa: </b>' . utf8_decode($rowAH[$i]["CausaExterna"]) . '</td>';
                $myHTML .= '<td width="150"><b>Dx Ingreso: </b>' . utf8_decode($rowAH[$i]["DiagnosticoIngreso"]) . '</td>';
                $myHTML .= '</tr>';
                $myHTML .= '<tr>';
                $myHTML .= '<td width="180"><b>Salida - Dx Ppal: </b>' . utf8_decode($rowAH[$i]["DiagnosticoSalida"]) . '</td>';
                $myHTML .= '<td width="120"><b>Dx Rel1: </b>' . utf8_decode($rowAH[$i]["DiagnosticoSalidaRel1"]) . '</td>';
                $myHTML .= '<td width="120"><b>Dx Rel2: </b>' . utf8_decode($rowAH[$i]["DiagnosticoSalidaRel2"]) . '</td>';
                $myHTML .= '<td width="120"><b>Dx Rel3: </b>' . utf8_decode($rowAH[$i]["DiagnosticoSalidaRel3"]) . '</td>';
                $myHTML .= '<td width="180"><b>Dx Complicacion: </b>' . utf8_decode($rowAH[$i]["DiagnosticoComplica"]) . '</td>';
                $myHTML .= '</tr>';
                $myHTML .= '<tr>';
                if($rowAH[$i]["EstadoSalida"] == "" || $rowAH[$i]["EstadoSalida"] == null){
                    $myHTML .= '<td width="120"><b>Estado: </b>1</td>';
                }else{
                    $myHTML .= '<td width="120"><b>Estado: </b>' . utf8_decode($rowAH[$i]["EstadoSalida"]) . '</td>';
                }
                if($rowAH[$i]["EstadoSalida"] == "2" || $rowAH[$i]["EstadoSalida"] == 2){
                    $myHTML .= '<td width="120"><b>Causa Muerte: </b>' . utf8_decode($rowAH[$i]["CausaMuerte"]) . '</td>';
                }
                $myHTML .= '</tr>';
                $myHTML .= '<tr>';
                $myHTML .= '<td width="200"><b>Fecha Salida: </b>' . utf8_decode($rowAH[$i]["FechaSalida"]) . '</td>';
                $myHTML .= '<td width="200"><b>Hora Salida: </b>' . utf8_decode($rowAH[$i]["HoraSalida"]) . '</td>';
                $myHTML .= '</tr>';
                $myHTML .= '</table><hr>';
                $pdf->writeHTML($myHTML, true, false, false, false, '');
                if($pdf->GetY() >= ($pdf->getPageHeight()-$pControlSalto)){
                    ImprimeEncabezadoRIPS($pdf);
                }
            }
        }
    }
    $pdf->Output('SoporteRIPS.pdf', 'I');

    function ImprimeEncabezadoRIPS(&$pdf){
        $pdf->AddPage();
        $pdf->Ln(2);
        $pdf->SetFont(PDF_FONT_NAME_MAIN, '', 7);
        $EncabezadoHTML = '<table cellspacing="0" border="0" style="font-size:24px; color:#000;">';
        $EncabezadoHTML .= '<tr>';
        $EncabezadoHTML .= '<td>';
        $EncabezadoHTML .= '<span style="font-size:44px; color:#000; font-weight:bold">' . utf8_decode($pdf->pNomEmpresa) . '</span><br>';
        if($pdf->pEspEmpresa != null || $pdf->pEspEmpresa != "")
                $EncabezadoHTML .= '<span style="font-size:34px; color:#000;">' . utf8_decode($pdf->pEspEmpresa) . '</span><br>';
        if($pdf->pTDocEmpresa == "NI")
            $tipodoc = "NIT: ";
        else
            $tipodoc = $pdf->pTDocEmpresa . ": ";
        $EncabezadoHTML .= '<span style="font-size:34px; color:#000;">' . $tipodoc . $pdf->pDocEmpresa . '</span><br>';
        $EncabezadoHTML .= '<span style="font-size:34px; color:#000;">' . $pdf->pDirEmpresa . ' - ' . $pdf->pTelEmpresa . '</span><br>';
        $EncabezadoHTML .= '<span style="font-size:34px; color:#000;">' . $pdf->pCiuEmpresa . '</span><br>';
        $EncabezadoHTML .= '</td>';
        //COL2
        $EncabezadoHTML .= '<td>';
        $EncabezadoHTML .= '<span align="rigth" style="font-size:44px; color:#000; font-weight:bold">SOPORTE RIPS</span><br>';
        $EncabezadoHTML .= '<span align="rigth" style="font-size:40px; color:#000; font-weight:bold">CAS: ' . $pdf->pCAS . '</span><br>';
        $EncabezadoHTML .= '</td>';
        $EncabezadoHTML .= '</tr>';
        $EncabezadoHTML .= '</table>';
        $EncabezadoHTML .= '<hr>';
        $pdf->writeHTML($EncabezadoHTML, true, false, false, false, '');
        $pdf->Ln(4);
    }
    
?>
