<?php
    require_once('../../../lib/tcpdf/config/lang/spa.php');
    require_once('../../../lib/tcpdf/tcpdf.php');
    require("../../../core/php/_database.php");
    require("../../../core/php/php_functions.php");
    require("../../../core/php/constantes.php");
    //header('Content-type: application/pdf; charset: UTF-8');
    
    session_start();
    $pImprimeTirilla = "NO";
    $pDocumento = isset($_REQUEST['pFactura'])?$_REQUEST['pFactura']:0;
    
    //Definicion de las Margenes
    $LeftMargin = PDF_MARGIN_LEFT;
    $TopMargin = 5;
    $RightMargin = PDF_MARGIN_RIGHT;
    $HeaderMargin = PDF_MARGIN_HEADER;
    $BottomMargin = 3;
    $FooterMargin = 5;
    $Alineacion = "P";
    $FormatoPagina = "CARTA";
    $UsaPiePagina = "NO";
    $pTipoEncabezado = "FVP";
      

    //Inicializacion de la Clase
    $pdf = new TCPDF($Alineacion, PDF_UNIT, $FormatoPagina, true, 'UTF-8', false);
    $pdf->pAlineacionEncabezado = $Alineacion;
    $pdf->pTituloInforme = "FACTURA DE VENTA";
    $pdf->pImprimeLogo = "NO";
    $pdf->pAnchoTxtPagina = 210;
    $pdf->pNomEmpresa = $_SESSION['NOM_EMPRESA'];
    $pdf->pTDocEmpresa = $_SESSION['EMPRESA_TDOC'];
    $pdf->pDocEmpresa = $_SESSION['EMPRESA_DOC'];
    $pdf->pDirEmpresa = $_SESSION['EMPRESA_DIR'];
    $pdf->pTelEmpresa = $_SESSION['EMPRESA_TEL'];
    $pdf->pCiuEmpresa = $_SESSION['EMPRESA_CIU'];
    $pdf->pEspEmpresa = $_SESSION['EMPRESA_ESP'];
    $pdf->pRegEmpresa = $_SESSION['EMPRESA_REGIMEN'];
    $pdf->pContribuyentes = $_SESSION['EMPRESA_CONTRIBUYENTE'];
    $pdf->pReteIVA  = $_SESSION['EMPRESA_RTEICA'];
    $pdf->pReteICA = $_SESSION['EMPRESA_RTEIVA'];
            
    $pdf->pTipoEncabezado = $pTipoEncabezado;
    $pdf->pNomSede = $_SESSION['EMPRESA_DOC'];
    $pdf->pNomIPS = $_SESSION['NOM_IPS'];
    $pdf->pMargenPie = -20;
    $pdf->pLogoCliente = "../../../empresas/" . $_SESSION['ID_EMPRESA'] . "/logo/logoenc.gif";
    $pdf->pPrefijo = $pPrefijo;
    $pdf->pNroDocumento = str_pad($pNroDocumento, 7, "0", STR_PAD_LEFT);
    $pdf->pNroResolucion = $pNroResolucion;
    $pdf->pFechaDoc = $pFechaDocumento;
    $pdf->pCAS = $pCAS;
    $pdf->pTratamiento = $pTratamiento;
    $pdf->pUsaPie = $UsaPiePagina;
        
    $pdf->SetCreator(PDF_CREATOR);
    $pdf->SetAuthor('Sistemas Ofisalud © - 2006');
    $pdf->SetTitle('FACTURACION');
    $pdf->SetSubject('Factura de Venta Institucional');

    $pdf->SetHeaderData($pdf->pLogoCliente, PDF_HEADER_LOGO_WIDTH, $pdf->pTituloInforme, PDF_HEADER_STRING);
    $pdf->setHeaderFont(Array(PDF_FONT_NAME_MAIN, '', PDF_FONT_SIZE_MAIN));
    $pdf->setFooterFont(Array(PDF_FONT_NAME_DATA, '', PDF_FONT_SIZE_DATA));
    $pdf->SetDefaultMonospacedFont(PDF_FONT_MONOSPACED);
    $pdf->SetMargins($LeftMargin, $TopMargin, $RightMargin);
    $pdf->SetHeaderMargin($HeaderMargin);
    $pdf->SetFooterMargin($FooterMargin);
    
    $pdf->SetAutoPageBreak(TRUE, $BottomMargin);
    $pdf->setImageScale(PDF_IMAGE_SCALE_RATIO);
    $pdf->setLanguageArray($l);
    $pdf->setFontSubsetting(true);
    $pdf->SetFont('dejavusans', '', 14, '', true);
            
    for($fac = 1904; $fac <=1904; $fac++){
        $pAnulada = 1;
        if($row[0]["IPSDireccion"] != "" && $row[0]["IPSDireccion"] != null){
            $pdf->pDirEmpresa = $row[0]["IPSDireccion"];
        }
        if($row[0]["IPSTelefono"] != "" && $row[0]["IPSTelefono"] != null){
            $pdf->pTelEmpresa = $row[0]["IPSTelefono"];
        }
        if($row[0]["IPSMunicipio"] != "" && $row[0]["IPSMunicipio"] != null){
            $pdf->pCiuEmpresa = $row[0]["IPSMunicipio"] . " - " . $row[0]["IPSDepto"];
        }
        $pdf->AddPage();
        if ($pAnulada == 1){
            $img_file = "../../../resources/varios/docanulado.png";
            $pdf->Image($img_file, 110, 8, 80, 50, '', '', '', false, 300, '', false, false, 0);
            $pdf->Image($img_file, 110, 215, 80, 50, '', '', '', false, 300, '', false, false, 0);
        }
        $pdf->Ln(2);
        $pdf->SetFont(PDF_FONT_NAME_MAIN, '', 7);
        $EncabezadoHTML = '<table cellspacing="0" border="0" style="font-size:24px; color:#000;">';
        $EncabezadoHTML .= '<tr><td></td><td height="5" style="font-size:14px; color:#000;" align="rigth">FACTURA POR COMPUTADOR</td></tr>';
        $EncabezadoHTML .= '<tr>';
        $EncabezadoHTML .= '<td>';
        $EncabezadoHTML .= '<span style="font-size:44px; color:#000; font-weight:bold">' . utf8_decode($pdf->pNomEmpresa) . '</span><br>';
        if($pdf->pEspEmpresa != null || $pdf->pEspEmpresa != "")
                $EncabezadoHTML .= '<span style="font-size:34px; color:#000;">' . utf8_decode($pdf->pEspEmpresa) . '</span><br>';
        if($pdf->pTDocEmpresa == "NI")
            $tipodoc = "NIT: ";
        else
            $tipodoc = $pdf->pTDocEmpresa . ": ";
        $EncabezadoHTML .= '<span style="font-size:34px; color:#000;">' . $tipodoc . $pdf->pDocEmpresa . '</span><br>';
        $EncabezadoHTML .= '<span style="font-size:34px; color:#000;">' . $pdf->pDirEmpresa . ' - ' . $pdf->pTelEmpresa . '</span><br>';
        $EncabezadoHTML .= '<span style="font-size:34px; color:#000;">' . $pdf->pCiuEmpresa . '</span><br>';
        if($pdf->pRegEmpresa != null && $pdf->pRegEmpresa != "")
            $EncabezadoHTML .= '<span style="font-size:17px; color:#000; font-weight:bold">' . $pdf->pRegEmpresa . '</span><br>';
        if($pdf->pContribuyentes != null && $pdf->pContribuyentes != "")
            $EncabezadoHTML .= '<span style="font-size:17px; color:#000; font-weight:bold">' . $pdf->pContribuyentes . '</span><br>';
        if($pdf->pReteIVA != null && $pdf->pReteIVA != "")
            $EncabezadoHTML .= '<span style="font-size:17px; color:#000; font-weight:bold">' . $pdf->pReteIVA . '</span><br>';
        if($pdf->pReteICA != null && $pdf->pReteICA != "")
            $EncabezadoHTML .= '<span style="font-size:16px; color:#000; font-weight:bold">' . $pdf->pReteICA . '</span>';
        if($_SESSION['IMPUESTO_CREE'] != null && $_SESSION['IMPUESTO_CREE'] != "")
            $EncabezadoHTML .= '<span style="font-size:14px; color:#000; font-weight:bold">' . $_SESSION['IMPUESTO_CREE'] . '</span>';
        $EncabezadoHTML .= '</td>';

        //COL2
        $EncabezadoHTML .= '<td>';
        $EncabezadoHTML .= '<span align="rigth" style="font-size:44px; color:#000; font-weight:bold">FACTURA DE VENTA</span><br>';
        $EncabezadoHTML .= '<span align="rigth" style="font-size:40px; color:#000; font-weight:bold">Nro: MON-' . $fac . '</span><br>';
        $EncabezadoHTML .= '<span align="rigth" style="font-size:24px; color:#000;">RESOLUCION 100000058673 HABILITA FECHA 14/01/2011Desde 1 Hasta: 100000</span><br>';
        $EncabezadoHTML .= '<span align="rigth" style="font-size:40px; color:#000; font-weight:bold">Fecha Factura: 2012-11-19</span><br>';
        $EncabezadoHTML .= '<span align="rigth" style="font-size:30px; color:#000; font-weight:bold">Fecha Vencimiento: 2012-11-19</span><br>';
        $EncabezadoHTML .= '</td>';

        $EncabezadoHTML .= '</tr>';
        $EncabezadoHTML .= '</table>';
        $EncabezadoHTML .= '<hr>';
        $pdf->writeHTML($EncabezadoHTML, true, false, false, false, '');

        $pdf->SetFont(PDF_FONT_NAME_MAIN,'',10);
        $pdf->MultiCell(17,5,"Cliente:",0,'L',0,0);
        $infoCliente = "";
        $infoCliente .= "999 - PRUEBAS DEL SISTEMA";
                $rowcount = max($pdf->getNumLines($infoCliente),1) * 3;
        $pdf->MultiCell(178,$rowcount,$infoCliente,0,'L',0,0);
        $pdf->Ln(4);
        $pdf->MultiCell(18,$rowcount,"Dirección:",0,'L',0,0);
        $pdf->MultiCell(78,$rowcount,"",0,'L',0,0);
        $pdf->MultiCell(18,$rowcount,"Teléfono:",0,'L',0,0);
        $pdf->MultiCell(78,$rowcount,"",0,'L',0,0);
        $pdf->Ln(4);
        $pdf->SetLineWidth(0.3); 
        $pdf->Line($pdf->GetX(), $pdf->GetY(), $pdf->GetX()+200, $pdf->GetY()); 
        $pdf->SetFont(PDF_FONT_NAME_MAIN,'B',11);
        $pdf->MultiCell(20,5,"CODIGO",0,'C',0,0);
        $pdf->MultiCell(75,5,"DESCRIPCION",0,'C',0,0);
        $pdf->MultiCell(10,5,"IVA",0,'R',0,0);
        $pdf->MultiCell(25,5,"CANTIDAD",0,'R',0,0);
        $pdf->MultiCell(32,5,"VLR UNITARIO",0,'R',0,0);
        $pdf->MultiCell(32,5,"VLR TOTAL",0,'R',0,0);
        $pdf->Ln(5);
        $pdf->SetLineWidth(0.3);
        $pdf->Line($pdf->GetX(), $pdf->GetY(), $pdf->GetX()+200, $pdf->GetY());
        $pdf->Ln(1);

        $img_file = "../../../empresas/" . $_SESSION['ID_EMPRESA'] . "/logo/fondofac.png";
        $pdf->Image($img_file, $pdf->GetX()+60, $pdf->GetY()+35, 90, 50, '', '', '', false, 300, '', false, false, 0);

        $pdf->SetFont(PDF_FONT_NAME_MAIN,'',10);

        $pdf->Ln($rowcount+2);
        $rowcount = 0;
        $rowcount = $pdf->getNumLines("PRUEBA DEL SISTEMA", 190) * 3;
        $pdf->MultiCell(190,$rowcount,"PRUEBA DEL SISTEMA",0,'L',0,0);
        $pdf->Ln($rowcount+5);
        $pdf->MultiCell(190,$rowcount,"FECHA ANULACION: 2012-11-19",0,'L',0,0);
        $pdf->Ln($rowcount+2);
        $pdf->MultiCell(190,$rowcount,"MOTIVO ANULACION: PRUEBA DEL SISTEMA",0,'L',0,0);
        $pdf->Ln($rowcount+2);
        while ($pdf->GetY() <= ($pdf->getPageHeight()-62)) {
            $pdf->Ln();
        }
        $pdf->Ln();


        $pdf->SetFont(PDF_FONT_NAME_MAIN, '', 7);
        $val = strtoupper(utf8_decode(numerotexto(0)));
        $EncabezadoHTML = '
        <table border="1" cellspacing="0" >
            <tr>
                <td width="520">&nbsp;<br>&nbsp;SON: '. $val . ' PESOS M/CTE.</td>
                <td width="180">
                    <table border="0" cellspacing="0">
                        <tr>
                            <td width="70">TOTAL:</td>
                            <td width="100" align="rigth">$ 0</td>
                        </tr>
                        <tr>
                            <td>IVA:</td>
                            <td width="100" align="rigth">$ 0</td>
                        </tr>
                        <tr>
                            <td>COPAGOS:</td>
                            <td width="100" align="rigth">$ 0</td>
                        </tr>
                        <tr>
                            <td>DESCUENTOS:</td>
                            <td width="100" align="rigth">$ 0</td>
                        </tr>
                        <tr>
                            <td>NETO:</td>
                            <td width="100" align="rigth">$ 0</td>
                        </tr>
                    </table>
                </td>
            </tr>
            <tr>
                <td colspan="2">
                    <table border="0" cellspacing="0">
                        <tr>
                            <td width="525">
                                <span style="font-size:29px; color:#000;">
                                AUTORIZADO A RECIBIR ESTA FACTURA
                                </span><br><br>
                                <span style="font-size:24px; color:#000;">
                                NOMBRES Y APELLIDOS:&nbsp;&nbsp;__________________________________________________
                                </span><br>
                                <span style="font-size:24px; color:#000;">
                                Nro. IDENTIFICACION:&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;__________________________________________________
                                </span><br>
                                <span style="font-size:24px; color:#000;">
                                FECHA DE RECIBIDO:&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;__________________________________________________
                                </span><br><br>
                                <span style="font-size:24px; color:#000;">
                                FIRMA Y SELLO
                                </span>
                            </td>
                            <td width="160" align="rigth">
                                <span style="font-size:25px; color:#000;">DESCUENTO PIE FACTURA PRONTO PAGO %_____</span><br><br></span><br><br><br><br>
                                <span style="font-size:16px; color:#000;">
                                SOFTWARE OFICLINIC© 2006 - Tel. 3016398114
                                </span>
                            </td>
                        </tr>
                    </table>
                </td>
            </tr>
        </table>
        <span style="font-size:18px; color:#000;">ESTA FACTURA DE VENTA SE ASIMILA PARA TODOS SUS EFECTOS A LA LETRA DE CAMBIO ART. 779 DEL CODIGO DE COMERCIO Y ARTICULO 5 LEY 
    1231 DE 2008. SE CAUSARA INTERES DE MORA POR CADA DIA DE LA TASA DEL (  ) MENSUAL SIN PERJUICIO DE LA ACCION LEGAL POR INCUMPLIMIENTO DE PAGO
        </span>';
        $pdf->writeHTML($EncabezadoHTML, true, false, false, false, '');
    }
    $pdf->Output('FacturaVenta' . $row[0]["Prefijo"] . "-" . $row[0]["NroDocumento"] . '.pdf', 'I');

    function ImprimeEncabezadoFactura(&$pdf){
        $pdf->AddPage();
        $pdf->Ln(2);
        $pdf->SetFont(PDF_FONT_NAME_MAIN, '', 7);
        $EncabezadoHTML = '<table cellspacing="0" border="0" style="font-size:24px; color:#000;">';
        $EncabezadoHTML .= '<tr><td></td><td height="5" style="font-size:14px; color:#000;" align="rigth">FACTURA POR COMPUTADOR</td></tr>';
        $EncabezadoHTML .= '<tr>';
        $EncabezadoHTML .= '<td>';
        $EncabezadoHTML .= '<span style="font-size:44px; color:#000; font-weight:bold">' . utf8_decode($pdf->pNomEmpresa) . '</span><br>';
        if($pdf->pEspEmpresa != null || $pdf->pEspEmpresa != "")
                $EncabezadoHTML .= '<span style="font-size:34px; color:#000;">' . utf8_decode($pdf->pEspEmpresa) . '</span><br>';
        if($pdf->pTDocEmpresa == "NI")
            $tipodoc = "NIT: ";
        else
            $tipodoc = $pdf->pTDocEmpresa . ": ";
        $EncabezadoHTML .= '<span style="font-size:34px; color:#000;">' . $tipodoc . $pdf->pDocEmpresa . '</span><br>';
        $EncabezadoHTML .= '<span style="font-size:34px; color:#000;">' . $pdf->pDirEmpresa . ' - ' . $pdf->pTelEmpresa . '</span><br>';
        $EncabezadoHTML .= '<span style="font-size:34px; color:#000;">' . $pdf->pCiuEmpresa . '</span><br>';
        if($pdf->pRegEmpresa != null && $pdf->pRegEmpresa != "")
            $EncabezadoHTML .= '<span style="font-size:17px; color:#000; font-weight:bold">' . $pdf->pRegEmpresa . '</span><br>';
        if($pdf->pContribuyentes != null && $pdf->pContribuyentes != "")
            $EncabezadoHTML .= '<span style="font-size:17px; color:#000; font-weight:bold">' . $pdf->pContribuyentes . '</span><br>';
        if($pdf->pReteIVA != null && $pdf->pReteIVA != "")
            $EncabezadoHTML .= '<span style="font-size:17px; color:#000; font-weight:bold">' . $pdf->pReteIVA . '</span><br>';
        if($pdf->pReteICA != null && $pdf->pReteICA != "")
            $EncabezadoHTML .= '<span style="font-size:16px; color:#000; font-weight:bold">' . $pdf->pReteICA . '</span>';
        if($_SESSION['IMPUESTO_CREE'] != null && $_SESSION['IMPUESTO_CREE'] != "")
            $EncabezadoHTML .= '<span style="font-size:14px; color:#000; font-weight:bold">' . $_SESSION['IMPUESTO_CREE'] . '</span>';
        $EncabezadoHTML .= '</td>';

        //COL2
        $EncabezadoHTML .= '<td>';
        $EncabezadoHTML .= '<span align="rigth" style="font-size:44px; color:#000; font-weight:bold">FACTURA DE VENTA</span><br>';
        $EncabezadoHTML .= '<span align="rigth" style="font-size:40px; color:#000; font-weight:bold">Nro: ' . $row[0]["Prefijo"] . "-" . $row[0]["NroDocumento"] . '</span><br>';
        $EncabezadoHTML .= '<span align="rigth" style="font-size:40px; color:#000; font-weight:bold">Fecha: ' .  $row[0]["FechaDocumento"] . '</span><br>';
        $EncabezadoHTML .= '<span align="rigth" style="font-size:24px; color:#000;">' . $row[0]["NroResolucion"] . '</span><br>';
        $EncabezadoHTML .= '<span align="rigth" style="font-size:30px; color:#000; font-weight:bold">Fecha Vencimiento: ' . $row[0]["FechaVencimiento"] . '</span><br>';
        $EncabezadoHTML .= '</td>';

        $EncabezadoHTML .= '</tr>';
        $EncabezadoHTML .= '</table>';
        $EncabezadoHTML .= '<hr>';
        $img_file = "../../../empresas/" . $_SESSION['ID_EMPRESA'] . "/logo/fondofac.png";
        $pdf->Image($img_file, $pdf->GetX()+60, $pdf->GetY()+35, 90, 50, '', '', '', false, 300, '', false, false, 0);
    }
    
?>
