<?php
    require_once('../../../lib/tcpdf/config/lang/spa.php');
    require_once('../../../lib/tcpdf/tcpdf.php');
    require("../../../core/php/_database.php");
    require("../../../core/php/php_functions.php");
    require("../../../core/php/constantes.php");
    header('Content-type: application/pdf; charset: UTF-8');
    
    session_start();
    //Variables;
    $pImprimeTirilla = 0;
    $pDocumento = isset($_REQUEST['pDocumento'])?$_REQUEST['pDocumento']:0;
    $pDocumentoFac = isset($_REQUEST['pDocumentoFac'])?$_REQUEST['pDocumentoFac']:0;
    $pControlSalto = 30;
    
    //Definicion de las Margenes
    $LeftMargin = PDF_MARGIN_LEFT;
    $TopMargin = PDF_MARGIN_TOP;
    $RightMargin = PDF_MARGIN_RIGHT;
    $HeaderMargin = PDF_MARGIN_HEADER;
    $BottomMargin = PDF_MARGIN_BOTTOM;
    $FooterMargin = PDF_MARGIN_FOOTER;
    $Alineacion = "P";
    $FormatoPagina = "CARTA";
    $UsaPiePagina = "SI";
    
    $gBaseDatos = new ofiMySQLi(); //CARGAR DATOS DE LA IPS
    $gBaseDatos->conectar();
    $qry = "CALL sp_ips_getdatabasico('" . $_SESSION['ID_IPS']. "')";
    $gBaseDatos->QryID = @mysqli_query($gBaseDatos->ConexionID, $qry);
    while ($rowIPS[] = @mysqli_fetch_assoc($gBaseDatos->QryID));
    $gBaseDatos->liberar();
    $gBaseDatos->cerrar();
    $ipsNOM = $rowIPS[0]["Descripcion"];
    $ipsCODMUNI = $rowIPS[0]["IdMunicipio"];
    $ipsDIR = $rowIPS[0]["Direccion"];
    $ipsTEL = $rowIPS[0]["Telefono"];
        
    $gBaseDatos = new ofiMySQLi(); //CARGAR DATOS DE LA IPS
    $gBaseDatos->conectar();
    $qry = "CALL sp_facturacion_print_notadc('" . $pDocumento . "')";
    $gBaseDatos->QryID = @mysqli_query($gBaseDatos->ConexionID, $qry);
    while ($row[] = @mysqli_fetch_assoc($gBaseDatos->QryID));
    $gBaseDatos->liberar();
    $gBaseDatos->cerrar();
    
    if($_SESSION['ImprimeRCTirilla']==0){
        //Inicializacion de la Clase
        $FormatoPagina = "MEDIACARTA";
        $Alineacion = "L";
        $UsaPiePagina = "SI";
        $pTipoEncabezado = "MC";
        $pTipoEncabezado = "FVP";
        $pdf = new TCPDF($Alineacion, PDF_UNIT, $FormatoPagina, true, 'UTF-8', false);
        //Inicializacion Variables de Control
        $pdf->pAlineacionEncabezado = $Alineacion;
        //$pdf->pTituloInforme = "RECIBO PROVISIONAL DE CAJA";
        $pdf->pTituloInforme = "RECIBO PROVISIONAL DE CAJA";
        $pdf->pImprimeLogo = "NO";
        $pdf->pAnchoTxtPagina = 210;
        $pdf->pNomEmpresa = $_SESSION['NOM_EMPRESA'];
        $pdf->pTDocEmpresa = $_SESSION['EMPRESA_TDOC'];
        $pdf->pDocEmpresa = $_SESSION['EMPRESA_DOC'];
        $pdf->pDirEmpresa = $ipsDIR;
        $pdf->pTelEmpresa = $ipsTEL;
        $pdf->pCiuEmpresa = $ipsNOM;
        $pdf->pEspEmpresa = $_SESSION['EMPRESA_ESP'];
        $pdf->pTipoEncabezado = $pTipoEncabezado;
        $pdf->pNomSede = $_SESSION['EMPRESA_DOC'];
        $pdf->pNomIPS = $_SESSION['NOM_IPS'];
        $pdf->pMargenPie = -20;
        $pdf->pLogoCliente = "../../../empresas/" . $_SESSION['ID_EMPRESA'] . "/logo/logoenc.gif";
        $pdf->pPrefijo = $pPrefijo;
        $pdf->pNroDocumento = $pNroDocumento;
        $pdf->pFechaDoc = $pFechaDocumento;
        $pdf->pCAS = $pCAS;
        $pdf->pTratamiento = $pTratamiento;
        $pdf->pUsaPie = $UsaPiePagina;

        $pdf->SetCreator(PDF_CREATOR);
        $pdf->SetAuthor('Sistemas Ofisalud © - 2006');
        $pdf->SetTitle('NOTA CONTABLE');
        $pdf->SetSubject('NOTA CONTABLE');

        $pdf->SetHeaderData($pdf->pLogoCliente, PDF_HEADER_LOGO_WIDTH, $pdf->pTituloInforme, PDF_HEADER_STRING);
        $pdf->setHeaderFont(Array(PDF_FONT_NAME_MAIN, '', PDF_FONT_SIZE_MAIN));
        $pdf->setFooterFont(Array(PDF_FONT_NAME_DATA, '', PDF_FONT_SIZE_DATA));
        $pdf->SetDefaultMonospacedFont(PDF_FONT_MONOSPACED);
        $pdf->SetMargins($LeftMargin, $TopMargin, $RightMargin);
        $pdf->SetHeaderMargin($HeaderMargin);
        $pdf->SetFooterMargin($FooterMargin);
        $pdf->SetAutoPageBreak(TRUE, $BottomMargin);
        $pdf->setImageScale(PDF_IMAGE_SCALE_RATIO);
        $pdf->setLanguageArray($l);
        $pdf->setFontSubsetting(true);
        $pdf->SetFont('dejavusans', '', 14, '', true);
        
        EncabezadoPagina($pdf, $row);
        
        // Cargar Detalle CAS
        $gBaseDatos->conectar();
        $qry = "CALL sp_facturacion_factura_resumen('" . $pDocumentoFac . "')";
        $gBaseDatos->QryID = @mysqli_query($gBaseDatos->ConexionID, $qry);
        while ($rowFac[] = @mysqli_fetch_assoc($gBaseDatos->QryID));
        $gBaseDatos->liberar();
        $gBaseDatos->cerrar();
        
        $mostrarHC = '<span style="font-size:34px; color:#000;"><b>Nro. FACTURA:</b> ' . utf8_decode($rowFac[0]["Prefijo"]) . "-" . utf8_decode($rowFac[0]["NroDocumento"]) . '</span><br>';
        $mostrarHC .= '<span style="font-size:34px; color:#000;"><b>FECHA FACTURA:</b> ' . utf8_decode($rowFac[0]["FechaDocumento"]) . '</span><br>';
        $pdf->writeHTML($mostrarHC, true, false, false, false, '');
        if ($pdf->GetY() >= ($pdf->getPageHeight()-$pControlSalto)){
            EncabezadoPagina($pdf, $row);
        }
        $pdf->Ln(2);
        $mostrarHC = '<span style="font-size:34px; color:#000;"><b>CONCEPTO NOTA:</b> ' . utf8_decode($row[0]["Concepto"]) . '</span><br>';
        $pdf->writeHTML($mostrarHC, true, false, false, false, '');
        if ($pdf->GetY() >= ($pdf->getPageHeight()-$pControlSalto)){
            EncabezadoPagina($pdf, $row);
        }
        $pdf->MultiCell(160,5,"VALOR TOTAL:",0,'R',0,0);
        $pdf->MultiCell(38,5,"$" .number_format($row[0]["TVlrTotal"],2,".",","),0,'R',0,0);
        if ($pdf->GetY() >= ($pdf->getPageHeight()-$pControlSalto)){
            EncabezadoPagina($pdf, $row);
        }
        $pdf->Ln(4);
        $pdf->MultiCell(160,5,"VALOR CUOTA MODERADORA:",0,'R',0,0);
        $pdf->MultiCell(38,5,"$" .number_format($row[0]["TCM"],2,".",","),0,'R',0,0);
        if ($pdf->GetY() >= ($pdf->getPageHeight()-$pControlSalto)){
            EncabezadoPagina($pdf, $row);
        }
        $pdf->Ln(4);
        $pdf->MultiCell(160,5,"VALOR COPAGOS:",0,'R',0,0);
        $pdf->MultiCell(38,5,"$" .number_format($row[0]["TCOPAGOS"],2,".",","),0,'R',0,0);
        if ($pdf->GetY() >= ($pdf->getPageHeight()-$pControlSalto)){
            EncabezadoPagina($pdf, $row);
        }
        $pdf->Ln(4);
        $pdf->MultiCell(160,5,"VALOR DESCUENTOS:",0,'R',0,0);
        $pdf->MultiCell(38,5,"$" .number_format($row[0]["TVlrDescuentos"],2,".",","),0,'R',0,0);
        if ($pdf->GetY() >= ($pdf->getPageHeight()-$pControlSalto)){
            EncabezadoPagina($pdf, $row);
        }
        $pdf->Ln(4);
        $pdf->MultiCell(160,5,"VALOR NETO:",0,'R',0,0);
        $pdf->MultiCell(38,5,"$" .number_format($row[0]["TVlrNeto"],2,".",","),0,'R',0,0);
        if ($pdf->GetY() >= ($pdf->getPageHeight()-$pControlSalto)){
            EncabezadoPagina($pdf, $row);
        }
        $pdf->Ln(4);
        if ($pdf->GetY() >= ($pdf->getPageHeight()-$pControlSalto)){
            EncabezadoPagina($pdf, $row);
        }
        $val = strtoupper(utf8_decode(numerotexto($row[0]["TVlrNeto"])));
        $pdf->MultiCell(198,10,"SON: " . $val . " PESOS MCTE.",0,'L',0,0);
        if ($pdf->GetY() >= ($pdf->getPageHeight()-$pControlSalto)){
            EncabezadoPagina($pdf, $row);
        }
        $pdf->Output('NotaContable.pdf', 'I');
    }
    
    function EncabezadoPagina(&$pdf, $row){
        $pdf->AddPage();
        if ($pAnulada == 1){
            $img_file = "../../../resources/varios/docanulado.png";
            $pdf->Image($img_file, 110, 8, 80, 50, '', '', '', false, 300, '', false, false, 0);
            //$pdf->Image($img_file, 110, 215, 80, 50, '', '', '', false, 300, '', false, false, 0);
        }
        $pdf->Ln(-12);
        $pdf->SetFont(PDF_FONT_NAME_MAIN, '', 7);
        $EncabezadoHTML = '<table cellspacing="0" border="0" style="font-size:24px; color:#000;">';
        $EncabezadoHTML .= '<tr><td></td><td height="5" style="font-size:14px; color:#000;" align="rigth"></td></tr>';
        $EncabezadoHTML .= '<tr>';
        $EncabezadoHTML .= '<td>';
        $EncabezadoHTML .= '<span style="font-size:44px; color:#000; font-weight:bold">' . ($pdf->pNomEmpresa) . '</span><br>';
        if($pdf->pEspEmpresa != null || $pdf->pEspEmpresa != "")
                $EncabezadoHTML .= '<span style="font-size:34px; color:#000;">' . utf8_decode($pdf->pEspEmpresa) . '</span><br>';
        if($pdf->pTDocEmpresa == "NI")
            $tipodoc = "NIT: ";
        else
            $tipodoc = $pdf->pTDocEmpresa . ": ";
        $EncabezadoHTML .= '<span style="font-size:34px; color:#000;">' . $tipodoc . $pdf->pDocEmpresa . '</span><br>';
        $EncabezadoHTML .= '<span style="font-size:34px; color:#000;">' . $pdf->pDirEmpresa . ' - ' . $pdf->pTelEmpresa . '</span><br>';
        $EncabezadoHTML .= '<span style="font-size:34px; color:#000;">' . $pdf->pCiuEmpresa . '</span><br>';
        $EncabezadoHTML .= '</td>';

        //COL2
        $EncabezadoHTML .= '<td>';
        $EncabezadoHTML .= '<span align="rigth" style="font-size:44px; color:#000; font-weight:bold">' . utf8_decode($row[0]["TipoLegalizacion"]) . '</span><br>';
        $EncabezadoHTML .= '<span align="rigth" style="font-size:40px; color:#000; font-weight:bold">Nro: ' . utf8_decode($row[0]["NroDocumento"]) . '</span><br>';
        $EncabezadoHTML .= '<span align="rigth" style="font-size:40px; color:#000; font-weight:bold">Fecha:' . utf8_decode($row[0]["FechaDocumento"]) . '</span><br>';
        $EncabezadoHTML .= '</td>';

        $EncabezadoHTML .= '</tr>';
        $EncabezadoHTML .= '</table>';
        $EncabezadoHTML .= '<hr>';
        $pdf->writeHTML($EncabezadoHTML, true, false, false, false, '');
        // Cargar Datos del Cliente
        $EncabezadoHTML = '<span style="font-size:34px; color:#000; font-weight:bold">Entidad: ' . utf8_decode($row[0]["Tdoc"]) . " " . utf8_decode($row[0]["Documento"]) .  "-" . utf8_decode($row[0]["Digitover"]) . " " .utf8_decode($row[0]["DescripcionFac"]) . '</span>';
        $pdf->writeHTML($EncabezadoHTML, true, false, false, false, '');
        $pdf->Ln(4);
        $pdf->SetLineWidth(0.3); 
        $pdf->Line($pdf->GetX(), $pdf->GetY(), $pdf->GetX()+200, $pdf->GetY()); 
        $pdf->SetFont(PDF_FONT_NAME_MAIN,'B',11);
        $pdf->MultiCell(200,5,"DETALLE",0,'C',0,0);
        $pdf->Ln(4);
        $pdf->SetLineWidth(0.3); 
        $pdf->Line($pdf->GetX(), $pdf->GetY(), $pdf->GetX()+200, $pdf->GetY()); 
        $pdf->SetFont(PDF_FONT_NAME_MAIN,'',10);
        $pdf->Ln(3);
    }
?>