<?php

/*
* @category    Controlador Profesionales
* @package     OfiClinic Web
* @author      Jorge Ancizar Galeano Ruiz<desarrollo@ofisalud.com>
* @copyright   2010 Jorge Ancizar Galeano Ruiz
* @version     OfiClinic Web 1.0
* @license     COMERCIAL
* @link        http://www.ofisalud.com
* @country     Colombia
* @telephone   3016398114
*/
require("../../../core/php/_database.php");
require("../../../core/php/php_functions.php");
session_start();

$task = '';
if ( isset($_POST['task'])){
  $task = $_POST['task'];
}
switch($task){
    case "GENERAR_FACTURA":
        GenerarFactura();
        break;
    case "GENERAR_RIPS":
        GenerarRIPS();
        break;
    case "BUSCAR_RCxFACTURA":
        BuscarDocumentoCruce();
        break;
    case "ANULAR_FACTURA":
        AnularFactura();
        break;
    case "GENERAR_FACTURA_PACIENTE":
        GenerarFacturaPaciente();
        break;
    default:
        echo "{failure:true}";
        break;
}

function AnularFactura(){
    $pEmpresa = isset($_REQUEST['pEmpresa'])?$_REQUEST['pEmpresa']:0;
    $pCliente = isset($_REQUEST['pCliente'])?$_REQUEST['pCliente']:0;
    $pFactura = isset($_REQUEST['pFactura'])?$_REQUEST['pFactura']:0;
    $pUsuario =  isset($_REQUEST['pUsuario'])?$_REQUEST['pUsuario']:0;
    $pFecha = isset($_REQUEST['pFecha'])?$_REQUEST['pFecha']:null;
    $pMotivo = isset($_REQUEST['pMotivo'])?$_REQUEST['pMotivo']:null;
    $gBaseDatos = new ofiMySQLi();
    $gBaseDatos->conectar();
    $qry = "CALL sp_facturacion_anularfactura('" . $pEmpresa . "','" . $pCliente . "','" . $pFactura . "',\"" . $pFecha . "\",\"" . $pMotivo . "\",'" . $pUsuario . "')";
    //echo $qry;
    if(@mysqli_query($gBaseDatos->ConexionID, $qry))
        echo '1';
    else
        echo '0';
    $gBaseDatos->cerrar();
}

function BuscarDocumentoCruce(){
    $pDocumentoCruce = isset($_REQUEST['pDocumentoCruce'])?$_REQUEST['pDocumentoCruce']:-1;
    $gBaseDatos = new ofiMySQLi();
    $gBaseDatos->conectar();
    $qry = "CALL sp_facturacion_buscardoccruce('" . $pDocumentoCruce . "')";
    echo $gBaseDatos->jasonSP_arreglo($qry);
    $gBaseDatos->liberar();
    $gBaseDatos->cerrar();
}

function GenerarRIPS(){
    set_time_limit(700);
    /*$directorio = opendir("c:\\eoficlinic\\rips");
    while ($archivo = readdir($directorio)){
        if($archivo != "." && $archivo != "..")
            unlink("c:\\eoficlinic\\rips\\" . $archivo);
    }
    closedir($directorio);
    */
    $pEmpresa = isset($_REQUEST['pEmpresa'])?$_REQUEST['pEmpresa']:0;
    $pCliente = isset($_REQUEST['pCliente'])?$_REQUEST['pCliente']:0;
    $pParticular = isset($_REQUEST['pParticular'])?$_REQUEST['pParticular']:"N";
    $pTipoEstudio = isset($_REQUEST['pTipoEstudio'])?$_REQUEST['pTipoEstudio']:0;
    $pFactura = isset($_REQUEST['pFactura'])?$_REQUEST['pFactura']:0;
    if($pFactura == null || $pFactura == "")
        $pFactura = 0;
    $pDesde = isset($_REQUEST['pDesde'])?$_REQUEST['pDesde']:null;
    if($pDesde == null || $pDesde == "")
        $pDesde = null;
    $pHasta = isset($_REQUEST['pHasta'])?$_REQUEST['pHasta']:null;
    if($pHasta == null || $pHasta == "")
        $pHasta = null;
    $pConsecutivo = isset($_REQUEST['pConsecutivo'])?$_REQUEST['pConsecutivo']:mt_rand(1,100000);
    if($pConsecutivo == null || $pConsecutivo == "" || $pConsecutivo == 0)
        $pConsecutivo = mt_rand(1,100000);
    $pConsecutivo = str_pad($pConsecutivo, 6, "0", STR_PAD_LEFT);
    $gBaseDatos = new ofiMySQLi();
    $gBaseDatos->conectar();
    $qry = "CALL sp_rips_002_generar(\"" . $pParticular . "\",'" . $pEmpresa . "','" . $pCliente . "','" . $pFactura . "',\"" . $pDesde . "\",\"" . $pHasta . "\",\"" . $pConsecutivo . "\")";
    //echo $qry;
    if(@mysqli_query($gBaseDatos->ConexionID, $qry)){
        //RIPS AC
        $gBaseDatos->cerrar();
        //$pNomArch = "C:\\eoficlinic\\rips\\AC" . $pConsecutivo . ".txt";
        $pNomArch = "../../../rips/AC" . $pConsecutivo . ".txt";
        if (file_exists($pNomArch)) {
            unlink($pNomArch);
            $tipoArch = "a";
        }else
            $tipoArch = "w+";
        if (!$gestor = fopen($pNomArch, $tipoArch)){
            echo "0";
        }else{
            $gBaseDatos->conectar();
            $qry = "select * from e_ac";
            $gBaseDatos->QryID = @mysqli_query($gBaseDatos->ConexionID, $qry);
            $contenido = "";
            while ($row = @mysqli_fetch_assoc($gBaseDatos->QryID))
            {
                $finfo = @mysqli_fetch_fields($gBaseDatos->QryID);
                $contenido = "";
                foreach ($finfo as $val)
                {
                    $contenido .= str_replace(",", ".", PonerAcentosHTML(utf8_decode($row[$val->name]))) . ",";
                }
                $NewContenido = substr($contenido, 0, (strlen($contenido)-1));
                $NewContenido .= "\r\n";
                if (fwrite($gestor, $NewContenido) === FALSE) {
                    $gBaseDatos->liberar();
                    $gBaseDatos->cerrar();
                    echo "0";
                }
            }
            $gBaseDatos->liberar();
            $gBaseDatos->cerrar();
            fclose($gestor); 
            if($contenido == "")
                unlink($pNomArch);
            
        }
        
        //RIPS AP
        //$pNomArch = "C:\\eoficlinic\\rips\\AP" . $pConsecutivo . ".txt";
        $pNomArch = "../../../rips/AP" . $pConsecutivo . ".txt";
        if (file_exists($pNomArch)) {
            unlink($pNomArch);
            $tipoArch = "a";
        }else
            $tipoArch = "w+";
        if (!$gestor = fopen($pNomArch, $tipoArch)){
            echo "0";
        }else{
            $gBaseDatos->conectar();
            $qry = "select * from e_ap";
            $gBaseDatos->QryID = @mysqli_query($gBaseDatos->ConexionID, $qry);
            $contenido = "";
            while ($row = @mysqli_fetch_assoc($gBaseDatos->QryID))
            {
                $finfo = @mysqli_fetch_fields($gBaseDatos->QryID);
                $contenido = "";
                foreach ($finfo as $val)
                {
                    $contenido .= str_replace(",", ".", PonerAcentosHTML(utf8_decode($row[$val->name]))) . ",";
                }
                $NewContenido = substr($contenido, 0, (strlen($contenido)-1));
                $NewContenido .= "\r\n";
                if (fwrite($gestor, $NewContenido) === FALSE) {
                    $gBaseDatos->liberar();
                    $gBaseDatos->cerrar();
                    echo "0";
                }
            }
            $gBaseDatos->liberar();
            $gBaseDatos->cerrar();
            fclose($gestor); 
            if($contenido == "")
                unlink($pNomArch);
        }
        
        //RIPS AM
        //$pNomArch = "C:\\eoficlinic\\rips\\AM" . $pConsecutivo . ".txt";
        $pNomArch = "../../../rips/AM" . $pConsecutivo . ".txt";
        if (file_exists($pNomArch)) {
            unlink($pNomArch);
            $tipoArch = "a";
        }else
            $tipoArch = "w+";
        if (!$gestor = fopen($pNomArch, $tipoArch)){
            echo "0";
        }else{
            $gBaseDatos->conectar();
            $qry = "select * from e_am";
            $gBaseDatos->QryID = @mysqli_query($gBaseDatos->ConexionID, $qry);
            $contenido = "";
            while ($row = @mysqli_fetch_assoc($gBaseDatos->QryID))
            {
                $finfo = @mysqli_fetch_fields($gBaseDatos->QryID);
                $contenido = "";
                foreach ($finfo as $val)
                {
                    $contenido .= str_replace(",", ".", PonerAcentosHTML(utf8_decode($row[$val->name]))) . ",";
                }
                $NewContenido = substr($contenido, 0, (strlen($contenido)-1));
                $NewContenido .= "\r\n";
                if (fwrite($gestor, $NewContenido) === FALSE) {
                    $gBaseDatos->liberar();
                    $gBaseDatos->cerrar();
                    echo "0";
                }
            }
            $gBaseDatos->liberar();
            $gBaseDatos->cerrar();
            fclose($gestor); 
            if($contenido == "")
                unlink($pNomArch);
        }
        
        //RIPS AT
        $pNomArch = "../../../rips/AT" . $pConsecutivo . ".txt";
        if (file_exists($pNomArch)) {
            unlink($pNomArch);
            $tipoArch = "a";
        }else
            $tipoArch = "w+";
        if (!$gestor = fopen($pNomArch, $tipoArch)){
            echo "0";
        }else{
            $gBaseDatos->conectar();
            $qry = "select a.Factura, a.Prestador, a.Tdoc, a.Documento, a.Autoriza, a.TipoServicio, a.CodigoServicio, a.NombreServicio, a.Cantidad, a.ValorUnitario, a.ValorTotal from e_at a";
            $gBaseDatos->QryID = @mysqli_query($gBaseDatos->ConexionID, $qry);
            $contenido = "";
            while ($row = @mysqli_fetch_assoc($gBaseDatos->QryID))
            {
                $finfo = @mysqli_fetch_fields($gBaseDatos->QryID);
                $contenido = "";
                foreach ($finfo as $val)
                {
                    $contenido .= str_replace(",", ".", PonerAcentosHTML(utf8_decode($row[$val->name]))) . ",";
                }
                $NewContenido = substr($contenido, 0, (strlen($contenido)-1));
                $NewContenido .= "\r\n";
                if (fwrite($gestor, $NewContenido) === FALSE) {
                    $gBaseDatos->liberar();
                    $gBaseDatos->cerrar();
                    echo "0";
                }
            }
            $gBaseDatos->liberar();
            $gBaseDatos->cerrar();
            fclose($gestor); 
            if($contenido == "")
                unlink($pNomArch);
        }
        
        //RIPS US
        $pNomArch = "../../../rips/US" . $pConsecutivo . ".txt";
        if (file_exists($pNomArch)) {
            unlink($pNomArch);
            $tipoArch = "a";
        }else
            $tipoArch = "w+";
        if (!$gestor = fopen($pNomArch, $tipoArch)){
            echo "0";
        }else{
            $gBaseDatos->conectar();
            $qry = "select * from e_us";
            $gBaseDatos->QryID = @mysqli_query($gBaseDatos->ConexionID, $qry);
            $contenido = "";
            while ($row = @mysqli_fetch_assoc($gBaseDatos->QryID))
            {
                $finfo = @mysqli_fetch_fields($gBaseDatos->QryID);
                $contenido = "";
                foreach ($finfo as $val)
                {
                    $contenido .= str_replace(",", ".", PonerAcentosHTML(utf8_decode($row[$val->name]))) . ",";
                }
                $NewContenido = substr($contenido, 0, (strlen($contenido)-1));
                $NewContenido .= "\r\n";
                if (fwrite($gestor, $NewContenido) === FALSE) {
                    $gBaseDatos->liberar();
                    $gBaseDatos->cerrar();
                    echo "0";
                }
            }
            $gBaseDatos->liberar();
            $gBaseDatos->cerrar();
            fclose($gestor); 
            if($contenido == "")
                unlink($pNomArch);
        }
                
        //RIPS AF
        $pNomArch = "../../../rips/AF" . $pConsecutivo . ".txt";
        if (file_exists($pNomArch)) {
            unlink($pNomArch);
            $tipoArch = "a";
        }else
            $tipoArch = "w+";
        if (!$gestor = fopen($pNomArch, $tipoArch)){
            echo "0";
        }else{
            $gBaseDatos->conectar();
            $qry = "select * from e_af";
            $gBaseDatos->QryID = @mysqli_query($gBaseDatos->ConexionID, $qry);
            $contenido = "";
            while ($row = @mysqli_fetch_assoc($gBaseDatos->QryID))
            {
                $finfo = @mysqli_fetch_fields($gBaseDatos->QryID);
                $contenido = "";
                foreach ($finfo as $val)
                {
                    $contenido .= str_replace(",", ".", PonerAcentosHTML(utf8_decode($row[$val->name]))) . ",";
                }
                $NewContenido = substr($contenido, 0, (strlen($contenido)-1));
                $NewContenido .= "\r\n";
                if (fwrite($gestor, $NewContenido) === FALSE) {
                    $gBaseDatos->liberar();
                    $gBaseDatos->cerrar();
                    echo "0";
                }
            }
            $gBaseDatos->liberar();
            $gBaseDatos->cerrar();
            fclose($gestor); 
            if($contenido == "")
                unlink($pNomArch);
        }
        //RIPS CT
        $pNomArch = "../../../rips/CT" . $pConsecutivo . ".txt";
        if (file_exists($pNomArch)) {
            unlink($pNomArch);
            $tipoArch = "a";
        }else
            $tipoArch = "w+";
        if (!$gestor = fopen($pNomArch, $tipoArch)){
            echo "0";
        }else{
            $gBaseDatos->conectar();
            $qry = "select * from e_ct";
            $gBaseDatos->QryID = @mysqli_query($gBaseDatos->ConexionID, $qry);
            $contenido = "";
            while ($row = @mysqli_fetch_assoc($gBaseDatos->QryID))
            {
                $finfo = @mysqli_fetch_fields($gBaseDatos->QryID);
                $contenido = "";
                foreach ($finfo as $val)
                {
                    $contenido .= str_replace(",", ".", PonerAcentosHTML(utf8_decode($row[$val->name]))) . ",";
                }
                $NewContenido = substr($contenido, 0, (strlen($contenido)-1));
                $NewContenido .= "\r\n";
                if (fwrite($gestor, $NewContenido) === FALSE) {
                    $gBaseDatos->liberar();
                    $gBaseDatos->cerrar();
                    echo "0";
                }
            }
            $gBaseDatos->liberar();
            $gBaseDatos->cerrar();
            fclose($gestor); 
            if($contenido == "")
                unlink($pNomArch);
        }
        /*@copy('../../../rips/AC' . $pConsecutivo . '.txt', 'C:\\eoficlinic\\rips\\AC' . $pConsecutivo . '.txt');
        @copy('../../../rips/AP' . $pConsecutivo . '.txt', 'C:\\eoficlinic\\rips\\AP' . $pConsecutivo . '.txt');
        @copy('../../../rips/AM' . $pConsecutivo . '.txt', 'C:\\eoficlinic\\rips\\AM' . $pConsecutivo . '.txt');
        @copy('../../../rips/AT' . $pConsecutivo . '.txt', 'C:\\eoficlinic\\rips\\AT' . $pConsecutivo . '.txt');
        @copy('../../../rips/AF' . $pConsecutivo . '.txt', 'C:\\eoficlinic\\rips\\AF' . $pConsecutivo . '.txt');
        @copy('../../../rips/CT' . $pConsecutivo . '.txt', 'C:\\eoficlinic\\rips\\CT' . $pConsecutivo . '.txt');
        @copy('../../../rips/US' . $pConsecutivo . '.txt', 'C:\\eoficlinic\\rips\\US' . $pConsecutivo . '.txt');
        */
        echo "1";
    }else{
        $gBaseDatos->cerrar();
        echo "0";
    }
    
}

function GenerarFactura(){
    set_time_limit(700);
    $pImprimeTirilla = "NO";
    $pEmpresa = isset($_REQUEST['pEmpresa'])?$_REQUEST['pEmpresa']:1;
    $pIPS = isset($_REQUEST['pIPS'])?$_REQUEST['pIPS']:0;
    $pUsuario =  isset($_REQUEST['pUsuario'])?$_REQUEST['pUsuario']:0;
    $pPaciente = isset($_REQUEST['pPaciente'])?$_REQUEST['pPaciente']:0;
    $pPorPaciente = isset($_REQUEST['pPorPaciente'])?$_REQUEST['pPorPaciente']:"NO";
    if($pPaciente == null || $pPaciente == "")
        $pPaciente = 0;
    $pProcedimiento = isset($_REQUEST['pProcedimiento'])?$_REQUEST['pProcedimiento']:0;
    if($pProcedimiento == null || $pProcedimiento == "")
        $pProcedimiento = 0;
    $pCliente = isset($_REQUEST['pCliente'])?$_REQUEST['pCliente']:0;
    $pPlan = isset($_REQUEST['pPlan'])?$_REQUEST['pPlan']:0;
    if($pPlan == null || $pPlan == "")
        $pPlan = 0;
    $pSubplan = isset($_REQUEST['pSubplan'])?$_REQUEST['pSubplan']:0;
    if($pSubplan == null || $pSubplan == "")
        $pSubplan = 0;
    $pContrato =  isset($_REQUEST['pContrato'])?$_REQUEST['pContrato']:0;
    $pTipoEstudio = isset($_REQUEST['pTipoEstudio'])?$_REQUEST['pTipoEstudio']:0;
    if($pTipoEstudio == null || $pTipoEstudio == "")
        $pTipoEstudio = 0;
    $pCampo1 = isset($_REQUEST['pCampo1'])?$_REQUEST['pCampo1']:"NO";
    if($pCampo1 == null || $pCampo1 == "")
        $pCampo1 = "NO";
    $pCampo2 = isset($_REQUEST['pCampo2'])?$_REQUEST['pCampo2']:"NO";
    if($pCampo2 == null || $pCampo2 == "")
        $pCampo2 = "NO";
    $pCampo3 = isset($_REQUEST['pCampo3'])?$_REQUEST['pCampo2']:"NO";
    if($pCampo3 == null || $pCampo3 == "")
        $pCampo3 = "NO";
    $pDesde = isset($_REQUEST['pDesde'])?$_REQUEST['pDesde']:null;
    if($pDesde == null || $pDesde == "")
        $pDesde = null;
    $pHasta = isset($_REQUEST['pHasta'])?$_REQUEST['pHasta']:null;
    if($pHasta == null || $pHasta == "")
        $pHasta = null;
    $pFechaFac = isset($_REQUEST['pFechaFac'])?$_REQUEST['pFechaFac']:null;
    if($pFechaFac == null || $pFechaFac == "")
        $pFechaFac = null;
    $pNroPacientes= isset($_REQUEST['pNroPacientes'])?$_REQUEST['pNroPacientes']:0;
    $pPorFechaEstudio = isset($_REQUEST['pPorFechaEstudio'])?$_REQUEST['pPorFechaEstudio']:"NO";
    $pCapitacion = isset($_REQUEST['pCapitacion'])?$_REQUEST['pCapitacion']:"NO";
    $pVlrUPC = isset($_REQUEST['pVlrUPC'])?$_REQUEST['pVlrUPC']:0;
    $pAfiliados = isset($_REQUEST['pAfiliados'])?$_REQUEST['pAfiliados']:0;
    $pVlrTotalCapita = isset($_REQUEST['pVlrTotalCapita'])?$_REQUEST['pVlrTotalCapita']:0;
    $pCopagosCapita = isset($_REQUEST['pCopagosCapita'])?$_REQUEST['pCopagosCapita']:0;
    $pNetoCapita = isset($_REQUEST['pNetoCapita'])?$_REQUEST['pNetoCapita']:0;
    $pConceptoFactura = isset($_REQUEST['pConceptoFactura'])?$_REQUEST['pConceptoFactura']:null;
    if($pConceptoFactura == null || $pConceptoFactura == "")
        $pConceptoFactura = null;
    $pAnulada = isset($_REQUEST['pAnulada'])?$_REQUEST['pAnulada']:0;
    $pAutorizacion = "Todos";   
    $gBaseDatos = new ofiMySQLi();
    $gBaseDatos->conectar();
    $qry = "CALL sp_facturacion_prefa_resumen('" . $pEmpresa . "','" . $pIPS . "','" . $pCliente . "','" . $pPlan . "','" . $pSubplan . "','" . $pContrato . "','" . $pPaciente . "',\"" . $pAutorizacion . "\",\"" . $pPorFechaEstudio . "\",\"" . $pDesde . "\",\"" . $pHasta . "\",'" . $pProcedimiento . "','" . $pTipoEstudio . "',\"" . $pCampo1 . "\",\"" . $pCampo2 . "\",\"" . $pCampo3 . "\")";
    //echo $qry;
    $gBaseDatos->QryID = @mysqli_query($gBaseDatos->ConexionID, $qry);
    $pSeguir = false;
    while($row = @mysqli_fetch_assoc($gBaseDatos->QryID))
    {
        $pSeguir = true;
        break;
    }
    $gBaseDatos->liberar();
    $gBaseDatos->cerrar();
    if($pPorPaciente == "NO"){
        if($pSeguir){
            $gBaseDatos->conectar();
            $CodInsercion = "PRS-" .  $_SESSION['ID_EMPRESA'] . "-SED-" . $_SESSION['ID_SEDE'] .  "-IPS-" . $_SESSION['ID_IPS'] . "-USR-" . $_SESSION['ID_USUARIO'] . "-CONS-" . mt_rand(0,100000) . "-" . date("His");
            $qry = "CALL sp_facturacion_generar_documento(\"" . $CodInsercion . "\",'" . $pEmpresa . "','" . $pIPS . "','" . $pCliente . "','" . $pPlan . "','" . $pSubplan . "','" . $pContrato . "','" . $pPaciente . "',\"" . $pAutorizacion . "\",\"" . $pPorFechaEstudio . "\",\"" . $pDesde . "\",\"" . $pHasta . "\",'" . $pProcedimiento . "','" . $pTipoEstudio . "',\"" . $pCampo1 . "\",\"" . $pCampo2 . "\",\"" . $pCampo3 . "\",\"" . $pConceptoFactura . "\",'" . $_SESSION['ID_USUARIO'] . "',\"" . $pFechaFac . "\",\"" . $pCapitacion . "\",'" . $pVlrUPC . "','" . $pAfiliados . "','" . $pVlrTotalCapita . "','" . $pCopagosCapita . "','" . $pNetoCapita . "')";
            //echo $qry;
            $CampoLlave = explode("^",$gBaseDatos->jasonSP_arreglo2011($qry));
            $gBaseDatos->cerrar();
            echo $CampoLlave[0];
        }else{
            echo "0";
        }
    }else{
        if($pSeguir){
            //Extraer los pacientes que deben cumplir los criterios
            $qry = "CALL sp_facturacion_prefa_resumen_pac('" . $pEmpresa . "','" . $pIPS . "','" . $pCliente . "','" . $pPlan . "','" . $pSubplan . "','" . $pContrato . "','" . $pPaciente . "',\"" . $pAutorizacion . "\",\"" . $pPorFechaEstudio . "\",\"" . $pDesde . "\",\"" . $pHasta . "\",'" . $pProcedimiento . "','" . $pTipoEstudio . "',\"" . $pCampo1 . "\",\"" . $pCampo2 . "\",\"" . $pCampo3 . "\")";
            //echo $qry;
            $gBaseDatos->conectar();
            $gBaseDatos->QryID = @mysqli_query($gBaseDatos->ConexionID, $qry);
            while ($row[] = @mysqli_fetch_assoc($gBaseDatos->QryID));
            $gBaseDatos->liberar();
            $gBaseDatos->cerrar();
            $pRegistros = count($row);
            $NroFacturas = "";
            for($i=0;$i<$pRegistros;$i++)
            {
                if ($row[$i]["Paciente"] != null && $row[$i]["Paciente"] != 0){
                    $gBaseDatos->conectar();
                    $CodInsercion = "PRS-" . $i . "-" . $_SESSION['ID_EMPRESA'] . "-SED-" . $_SESSION['ID_SEDE'] .  "-IPS-" . $_SESSION['ID_IPS'] . "-USR-" . $_SESSION['ID_USUARIO'] . "-CONS-" . mt_rand(0,100000) . "-" . date("His");
                    $qry = "CALL sp_facturacion_generar_documento(\"" . $CodInsercion . "\",'" . $pEmpresa . "','" . $pIPS . "','" . $pCliente . "','" . $pPlan . "','" . $pSubplan . "','" . $pContrato . "','" . $row[$i]["Paciente"] . "',\"" . $pAutorizacion . "\",\"" . $pPorFechaEstudio . "\",\"" . $pDesde . "\",\"" . $pHasta . "\",'" . $pProcedimiento . "','" . $pTipoEstudio . "',\"" . $pCampo1 . "\",\"" . $pCampo2 . "\",\"" . $pCampo3 . "\",\"" . $pConceptoFactura . "\",'" . $_SESSION['ID_USUARIO'] . "',\"" . $pFechaFac . "\",\"" . $pCapitacion . "\",'" . $pVlrUPC . "','" . $pAfiliados . "','" . $pVlrTotalCapita . "','" . $pCopagosCapita . "','" . $pNetoCapita . "')";
                    //echo $qry;
                    $CampoLlave = explode("^",$gBaseDatos->jasonSP_arreglo2011($qry));
                    $gBaseDatos->cerrar();
                    if ($i == 0){
                        $NroFacturas = "Factura Desde: " . $CampoLlave[0];
                    }else{
                        if ($i == ($pRegistros-1)){
                            $NroFacturas .= "Factura Hasta: " . $CampoLlave[0];
                        }
                    }
                }
            }
            echo $NroFacturas;
        }else{
            echo "0";
        }
    }
}

function GenerarFacturaPaciente(){
    set_time_limit(700);
    $pEmpresa = isset($_REQUEST['pEmpresa'])?$_REQUEST['pEmpresa']:1;
    $pIPS = isset($_REQUEST['pIPS'])?$_REQUEST['pIPS']:0;
    $pUsuario =  isset($_REQUEST['pUsuario'])?$_REQUEST['pUsuario']:0;
    $pPaciente = isset($_REQUEST['pPaciente'])?$_REQUEST['pPaciente']:0;
    $pCAS = isset($_REQUEST['pCAS'])?$_REQUEST['pCAS']:0;
    $pPorPaciente = isset($_REQUEST['pPorPaciente'])?$_REQUEST['pPorPaciente']:"NO";
    if($pPaciente == null || $pPaciente == ""){
        $pPaciente = 0;
    }
    $pFechaFac = isset($_REQUEST['pFechaFac'])?$_REQUEST['pFechaFac']:null;
    if($pFechaFac == null || $pFechaFac == ""){
        $pFechaFac = null;
    }
    $CodInsercion = "PRS-" . $i . "-CAS:" . $pCAS . "-" . $_SESSION['ID_EMPRESA'] . "-SED-" . $_SESSION['ID_SEDE'] .  "-IPS-" . $_SESSION['ID_IPS'] . "-USR-" . $_SESSION['ID_USUARIO'] . "-CONS-" . mt_rand(0,100000) . "-" . date("His");
    $qry = "CALL sp_facturacion_generar_documento_paciente(\"" . $CodInsercion . "\",'" . $pEmpresa . "','" . $pIPS . "','" . $pCAS . "','" . $pPaciente . "','" . $_SESSION['ID_USUARIO'] . "',\"" . $pFechaFac . "\")";
    $gBaseDatos = new ofiMySQLi();
    $gBaseDatos->conectar();
    $CampoLlave = explode("^",$gBaseDatos->jasonSP_arreglo2011($qry));
    $gBaseDatos->cerrar();
    echo $CampoLlave[0];
}

?>
