<?php

/*
* @category    Controlador Plantillas HC
* @package     OfiClinic Web
* @author      Jorge Ancizar Galeano Ruiz<desarrollo@ofisalud.com>
* @copyright   2010 Jorge Ancizar Galeano Ruiz
* @version     OfiClinic Web 1.0
* @license     COMERCIAL
* @link        http://www.ofisalud.com
* @country     Colombia
* @telephone   3016398114
*/
header("Content-Type: text/plain; charset=UTF-8");
require("../../../core/php/_database.php");
require("../../../core/php/php_functions.php");
session_start();

$task = '';
if ( isset($_POST['task'])){
  $task = $_POST['task'];
}
switch($task){
    case "PARTISALUD_SALIR_VALORACIONMEDICA":
        CerrarValoracionMedicaSinGuardar();
        break;
    case "guardar":
        GuardarHC("HC");
        break;
    case "modificar":
        ModificarHC("HC");
        break;
    case "guardar_anexo":
        GuardarHC("ANEXO");
        break;
    case "modificar_anexo":
        ModificarHC("ANEXO");
        break;
    case "VerHistorialxPaciente":
        VerHistorialHCxPaciente();
        break;
    case "VerHistorialxPacienteFiltro":
        VerHistorialHCxPacienteFiltro();
        break;
    case "VerHistorialAtencionesSaludOcupacional":
        VerHistorialAtencionesSaludOcupacional();
        break;
    case "VerHistorialxPacienteSinEvolucionar":
        VerHistorialHCxPacienteSinEvolucionar();
        break;
    case "GUARDAR_HISTORIAL_LABORAL":
        GuardarHistorialLaboral();
        break;
    case "ELIMINAR_HISTORIAL_LABORAL":
        EliminarHistorialLaboral();
        break;
    case "VerHistorialLaboral":
        VerHistorialLaboral();
        break;
    case "BorrarESTUDIOSSinEvolucionar":
        BorrarEstudiosVacios();
        break;
    case "CAMBIAR_UBICACION_TOMASIGNOS":
        CambiarUbicacionActual("TOMASIGNOS");
        break;
    case "CAMBIAR_UBICACION_VALMEDICA":
        CambiarUbicacionActual("VALMEDICA");
        break;
    case "CAMBIAR_UBICACION_TOMAMUESTRAS":
        CambiarUbicacionActual("TOMAMUESTRAS");
        break;
    case "CAMBIAR_UBICACION_TOMALABO":
        CambiarUbicacionActual("RESULTLABO");
        break;
    case "CAMBIAR_UBICACION_FONOAUDIOLOGIA":
        CambiarUbicacionActual("FONOAUDIOLOGIA");
        break;
    case "PARTISALUD_TOMASIGNOS":
        GuardarTomaSignos();
        break;
    case "SALUDOCUPA_TOMASIGNOS":
        GuardarTomaSignosSO();
        break;
    case "PARTISALUD_TOMAMUESTRAS":
        GuardarTomaMuestras();
        break;
    case "PARTISALUD_RESULTLABO":
        GuardarResultadoLaboratorio();
        break;
    case "PARTISALUD_FONOAUDIOLOGIA":
        GuardarFonoaudiologia();
        break;
    case "PARTISALUD_VALORACIONMEDICA":
        GuardarValoracionMedica();
        break;
    case "SALUDOCUPA_VALORACIONMEDICA":
        GuardarValoracionMedicaSO();
        break;
    case "SALUDOCUPACIONAL001_CARGAR":
        CargarDataFormulario("SaludOcupacional001");
        break;
    case "SALUDOCUPACIONAL001_ANEXO_CARGAR":
        CargarDataFormulario("SaludOcupacional001_Anexo");
        break;
    case "SALUDOCUPACIONAL001_CARGAR_HCANTERIOR":
        CargarDataFormulario("SaludOcupacional001_HCANTERIOR");
        break;
    case "SALUDOCUPACIONAL001_CARGAR_HCANEXOANTERIOR":
        CargarDataFormulario("SaludOcupacional001_ANEXOANTERIOR");
        break;
    case "PARTISALUD_CARGAR_DATA_TOMASIGNOS":
        CargarDataFormulario("TomaSignos");
        break;
    case "SALUDOCUPA_CARGAR_DATA_TOMASIGNOS":
        CargarDataFormulario("TomaSignosSO");
        break;
    case "PARTISALUD_CARGAR_DATA_VALORACIONMEDICA":
        CargarDataFormulario("ValoracionMedica");
        break;
    case "SALUDOCUPA_CARGAR_DATA_VALORACIONMEDICA":
        CargarDataFormulario("ValoracionMedicaSO");
        break;
    case "PARTISALUD_CARGAR_DATA_VALORACIONMEDICA_BASICO":
        CargarDataFormulario("ValoracionMedicaBasico"); 
        break;
    case "PARTISALUD_CARGAR_DATA_VALORACIONMEDICA_ANTECEDENTES":
        CargarDataFormulario("ValoracionMedicaAntecedentes");
        break;
    case "PARTISALUD_CARGAR_DATA_FONOAUDIOLOGIA":
        CargarDataFormulario("Fonoaudiologia");
        break;
    case "PARTISALUD_CARGAR_DATA_TOMAMUESTRAS":
        CargarDataFormulario("TomaMuestras");
        break;
    case "PARTISALUD_CARGAR_DATA_RESULTLABO":
        CargarDataFormulario("ResultLaboratorio");
        break;
    case "PARTISALUD_ELIMINAR_PROCESO":
        EliminarProceso();
        break;
    case "PARTISALUD_CERRAR_PROCESO":
        CerrarProceso();
        break;
    case "PARTISALUD_DESBLOQUEAR_PROCESO":
        DesbloquearProceso();
        break;
    case "ELIMINAR_HISTORIASO":
        EliminarHistoriaSO();
        break;
    default:
        echo "{failure:true}";
        break;
}
function EliminarHistoriaSO(){
    $pCAS = isset($_REQUEST['pCAS'])?$_REQUEST['pCAS']:0;
    $gBaseDatos = new ofiMySQLi();
    $gBaseDatos->conectar();
    $qry = "CALL sp_asistencial_saludocupacional001_del('" . $pCAS . "')";
    //echo $qry;
    if(@mysqli_query($gBaseDatos->ConexionID, $qry))
        echo '1';
    else
        echo '0';
    $gBaseDatos->cerrar();
}
function DesbloquearProceso(){
    $pCAS = isset($_REQUEST['pCAS'])?$_REQUEST['pCAS']:0;
    $pProceso = isset($_REQUEST['pProceso'])?$_REQUEST['pProceso']:null;
    $qry = "CALL sp_asistencial_partisalud_updateproceso('" . $pCAS . "',\"" . $pProceso . "\")";
    $gBaseDatos = new ofiMySQLi();
    $gBaseDatos->conectar();
    if(@mysqli_query($gBaseDatos->ConexionID, $qry))
        echo "{success: true, requestedId:'1'}";
    else
       echo "{success: true, requestedId:'0'}";
    $gBaseDatos->cerrar();
}

function CerrarProceso(){
    $pCAS = isset($_REQUEST['pCAS'])?$_REQUEST['pCAS']:0;
    $pUsuario = isset($_REQUEST['pUsuario'])?$_REQUEST['pUsuario']:0;
    $pConcepto = isset($_REQUEST['pConcepto'])?$_REQUEST['pConcepto']:null;
    $qry = "CALL sp_asistencial_partisalud_closeproceso('" . $pCAS . "','" . $pUsuario . "',\"" . $pConcepto . "\")";
    $gBaseDatos = new ofiMySQLi();
    $gBaseDatos->conectar();
    if(@mysqli_query($gBaseDatos->ConexionID, $qry))
        echo "{success: true, requestedId:'1'}";
    else
       echo "{success: true, requestedId:'0'}";
    $gBaseDatos->cerrar();
}

function EliminarProceso(){
    $pCAS = isset($_REQUEST['pCAS'])?$_REQUEST['pCAS']:0;
    $pMotivo = isset($_REQUEST['pMotivo'])?$_REQUEST['pMotivo']:null;
    $gBaseDatos = new ofiMySQLi();
    $gBaseDatos->conectar();
    $qry = "CALL sp_asistencial_partisalud_delproceso('" . $pCAS . "',\"" . $pMotivo . "\")";
    //echo $qry;
    if(@mysqli_query($gBaseDatos->ConexionID, $qry))
        echo "{success: true, requestedId:'1'}";
    else
        echo "{success: true, requestedId:'0'}";
    $gBaseDatos->cerrar();
}

function CargarDataFormulario($pFormulario){
    //echo '{"success":true,"data":{"intTomaSignosTalla":"90","memTomaSignosObservaciones":"PRUEBA DE CARGA DATA"}}'; 
    $pCAS = isset($_REQUEST['pCAS'])?$_REQUEST['pCAS']:0;
    $pPaciente = isset($_REQUEST['pPaciente'])?$_REQUEST['pPaciente']:0;
    $pConsecutivo = isset($_REQUEST['pConsecutivo'])?$_REQUEST['pConsecutivo']:0;
    $qry = "";
    switch ($pFormulario){
        case "TomaSignos":
            $qry = "CALL sp_asistencial_partisalud_load_tomasignos('" . $pCAS . "','" . $pConsecutivo . "')";
            break;
        case "TomaSignosSO":
            $qry = "CALL sp_asistencial_saludocupa_load_tomasignos('" . $pCAS . "','" . $pConsecutivo . "')";
            break;
        case "ValoracionMedicaBasico":
            $qry = "CALL sp_asistencial_partisalud_load_valoramedica_basico('" . $pCAS . "','" . $pConsecutivo . "')";
            break;
        case "ValoracionMedicaAntecedentes":
            $qry = "CALL sp_asistencial_partisalud_load_valoramedica_antecedentes('" . $pCAS . "','" . $pPaciente . "')";
            break;
        case "ValoracionMedicaSO":
            $qry = "CALL sp_asistencial_saludocupa_load_valoramedica('" . $pCAS . "','" . $pConsecutivo . "')";
            //$qry = "CALL sp_asistencial_partisalud_load_valoramedica_basico('" . $pCAS . "','" . $pConsecutivo . "')";
            break;
        case "ValoracionMedica":
            $qry = "CALL sp_asistencial_partisalud_load_valoramedica('" . $pCAS . "','" . $pConsecutivo . "')";
            //$qry = "CALL sp_asistencial_partisalud_load_valoramedica_basico('" . $pCAS . "','" . $pConsecutivo . "')";
            break;
        case "TomaMuestras":
            $qry = "CALL sp_asistencial_partisalud_load_tomamuestras('" . $pCAS . "','" . $pConsecutivo . "')";
            break;
        case "Fonoaudiologia":
            $qry = "CALL sp_asistencial_partisalud_load_fonoaudiologia('" . $pCAS . "','" . $pConsecutivo . "')";
            break;
        case "SaludOcupacional001":
            $qry = "CALL sp_asistencial_saludocupacional001_load('" . $pCAS . "','" . $pConsecutivo . "')";
            break;
        case "SaludOcupacional001_Anexo":
            $qry = "CALL sp_asistencial_saludocupacional001_anexo_load('" . $pPaciente . "','" . $pConsecutivo . "')";
            break;
        case "ResultLaboratorio":
            $qry = "CALL sp_asistencial_partisalud_load_laboratorio('" . $pCAS . "','" . $pConsecutivo . "')";
            break;
        case "SaludOcupacional001_HCANTERIOR":
            $qry = "CALL sp_asistencial_saludocupacional001_load_hcanterior('" . $pCAS . "','" . $pPaciente . "')";
            break;
        case "SaludOcupacional001_ANEXOANTERIOR":
            $qry = "CALL sp_asistencial_saludocupacional001_load_anexoanterior('" . $pCAS . "','" . $pPaciente . "')";
            break;
        default:
            break;
    }
    $gBaseDatos = new ofiMySQLi();
    $gBaseDatos->conectar();
    //echo $qry;
    //$res = PonerAcentosHTML($gBaseDatos->jsonSP($qry,"D"));
    $resY = str_replace("<BR \/><br \/>","",PonerAcentosHTML($gBaseDatos->jsonSP($qry,"D")));
    $res = str_replace("<br \/>","",$resY);
    $numreg = 
    $gBaseDatos->liberar();
    $gBaseDatos->cerrar();
    $res1 = str_replace("[", "", $res);
    $res = str_replace("]", "", $res1);
    echo $res; //rafa
}

function GuardarFonoaudiologia(){
    $estructura = explode("¬", $_REQUEST['CAMPOS']);
    $pCAS = isset($_REQUEST['pCAS'])?$_REQUEST['pCAS']:0;
    $pConsecutivoHC = isset($_REQUEST['pConsecutivoHC'])?$_REQUEST['pConsecutivoHC']:0;
    $pProfesional = isset($_REQUEST['pProfesional'])?$_REQUEST['pProfesional']:0;
    $qry = "CALL sp_asistencial_partisalud_update_fonoaudiologia('" . $pCAS . "','" . $pConsecutivoHC . "','" . $pProfesional . "'," . stripslashes(spParametros($estructura,"NO")) . ")";
    //echo $qry;
    $gBaseDatos = new ofiMySQLi();
    $gBaseDatos->conectar();
    if(@mysqli_query($gBaseDatos->ConexionID, $qry))
        echo "{success: true, requestedId:'1'}";
    else
       echo "{success: true, requestedId:'0'}";
    $gBaseDatos->cerrar();
}

function GuardarValoracionMedica(){
    $estructura = explode("¬", $_REQUEST['CAMPOS']);
    $pCAS = isset($_REQUEST['pCAS'])?$_REQUEST['pCAS']:0;
    $pConsecutivoHC = isset($_REQUEST['pConsecutivoHC'])?$_REQUEST['pConsecutivoHC']:0;
    $pProfesional = isset($_REQUEST['pProfesional'])?$_REQUEST['pProfesional']:0;
    $pDiagppal = isset($_REQUEST['pDiagppal'])?$_REQUEST['pDiagppal']:null;
    $pDiagrel1 = isset($_REQUEST['pDiagrel1'])?$_REQUEST['pDiagrel1']:null;
    $pDiagrel2 = isset($_REQUEST['pDiagrel2'])?$_REQUEST['pDiagrel2']:null;
    $pDiagrel3 = isset($_REQUEST['pDiagrel3'])?$_REQUEST['pDiagrel3']:null;
    $pTipodiag = isset($_REQUEST['pTipodiag'])?$_REQUEST['pTipodiag']:null;
    $pFinalidad = isset($_REQUEST['pFinalidad'])?$_REQUEST['pFinalidad']:null;
    $pCausa = isset($_REQUEST['pCausa'])?$_REQUEST['pCausa']:null;
    $qry = "CALL sp_asistencial_partisalud_update_valoramedica('" . $pCAS . "','" . $pConsecutivoHC . "','" . $pProfesional . "',\"" . $pDiagppal . "\",\"" . $pDiagrel1 . "\",\"" . $pDiagrel2 . "\",\"" . $pDiagrel3 . "\",\"" . $pTipodiag . "\",\"" . $pFinalidad . "\",\"" . $pCausa . "\"," . stripslashes(spParametros($estructura,"NO")) . ")";
    //echo $qry;
    $gBaseDatos = new ofiMySQLi();
    $gBaseDatos->conectar();
    if(@mysqli_query($gBaseDatos->ConexionID, $qry))
        echo "{success: true, requestedId:'1'}";
    else
       echo "{success: true, requestedId:'0'}";
    $gBaseDatos->cerrar();           
}

function GuardarValoracionMedicaSO(){
    $estructura = explode("¬", $_REQUEST['CAMPOS']);
    $pCAS = isset($_REQUEST['pCAS'])?$_REQUEST['pCAS']:0;
    $pConsecutivoHC = isset($_REQUEST['pConsecutivoHC'])?$_REQUEST['pConsecutivoHC']:0;
    $pProfesional = isset($_REQUEST['pProfesional'])?$_REQUEST['pProfesional']:0;
    $pDiagppal = isset($_REQUEST['pDiagppal'])?$_REQUEST['pDiagppal']:null;
    $pDiagrel1 = isset($_REQUEST['pDiagrel1'])?$_REQUEST['pDiagrel1']:null;
    $pDiagrel2 = isset($_REQUEST['pDiagrel2'])?$_REQUEST['pDiagrel2']:null;
    $pDiagrel3 = isset($_REQUEST['pDiagrel3'])?$_REQUEST['pDiagrel3']:null;
    $pTipodiag = isset($_REQUEST['pTipodiag'])?$_REQUEST['pTipodiag']:null;
    $pFinalidad = isset($_REQUEST['pFinalidad'])?$_REQUEST['pFinalidad']:null;
    $pCausa = isset($_REQUEST['pCausa'])?$_REQUEST['pCausa']:null;
    $qry = "CALL sp_asistencial_saludocupa_update_valoramedica('" . $pCAS . "','" . $pConsecutivoHC . "','" . $pProfesional . "',\"" . $pDiagppal . "\",\"" . $pDiagrel1 . "\",\"" . $pDiagrel2 . "\",\"" . $pDiagrel3 . "\",\"" . $pTipodiag . "\",\"" . $pFinalidad . "\",\"" . $pCausa . "\"," . stripslashes(spParametros($estructura,"NO")) . ")";
    //echo $qry;
    $gBaseDatos = new ofiMySQLi();
    $gBaseDatos->conectar();
    if(@mysqli_query($gBaseDatos->ConexionID, $qry))
        echo "{success: true, requestedId:'1'}";
    else
       echo "{success: true, requestedId:'0'}";
    $gBaseDatos->cerrar();
}

function CerrarValoracionMedicaSinGuardar(){
    $pCAS = isset($_REQUEST['pCAS'])?$_REQUEST['pCAS']:0;
    $pConsecutivoHC = isset($_REQUEST['pConsecutivoHC'])?$_REQUEST['pConsecutivoHC']:0;
    $qry = "CALL sp_asistencial_partisalud_close_valoramedica('" . $pCAS . "','" . $pConsecutivoHC . "')";
    //echo $qry;
    $gBaseDatos = new ofiMySQLi();
    $gBaseDatos->conectar();
    if(@mysqli_query($gBaseDatos->ConexionID, $qry))
        echo "{success: true, requestedId:'1'}";
    else
       echo "{success: true, requestedId:'0'}";
    $gBaseDatos->cerrar();    
}

function GuardarTomaMuestras(){
    $estructura = explode("¬", $_REQUEST['CAMPOS']);
    $pCAS = isset($_REQUEST['pCAS'])?$_REQUEST['pCAS']:0;
    $pConsecutivoHC = isset($_REQUEST['pConsecutivoHC'])?$_REQUEST['pConsecutivoHC']:0;
    $pProfesional = isset($_REQUEST['pProfesional'])?$_REQUEST['pProfesional']:0;
    $qry = "CALL sp_asistencial_partisalud_update_tomamuestras('" . $pCAS . "','" . $pConsecutivoHC . "','" . $pProfesional . "'," . stripslashes(spParametros($estructura,"NO")) . ")";
    //echo $qry;
    $gBaseDatos = new ofiMySQLi();
    $gBaseDatos->conectar();
    if(@mysqli_query($gBaseDatos->ConexionID, $qry))
        echo "{success: true, requestedId:'1'}";
    else
       echo "{success: true, requestedId:'0'}";
    $gBaseDatos->cerrar();
}

function GuardarResultadoLaboratorio(){
    $estructura = explode("¬", $_REQUEST['CAMPOS']);
    $pCAS = isset($_REQUEST['pCAS'])?$_REQUEST['pCAS']:0;
    $pConsecutivoHC = isset($_REQUEST['pConsecutivoHC'])?$_REQUEST['pConsecutivoHC']:0;
    $pProfesional = isset($_REQUEST['pProfesional'])?$_REQUEST['pProfesional']:0;
    $qry = "CALL sp_asistencial_partisalud_update_laboratorio('" . $pCAS . "','" . $pConsecutivoHC . "','" . $pProfesional . "'," . stripslashes(spParametros($estructura,"NO")) . ")";
    //echo $qry;
    $gBaseDatos = new ofiMySQLi();
    $gBaseDatos->conectar();
    if(@mysqli_query($gBaseDatos->ConexionID, $qry))
        echo "{success: true, requestedId:'1'}";
    else
       echo "{success: true, requestedId:'0'}";
    $gBaseDatos->cerrar();   
}

function GuardarTomaSignos(){
    $estructura = explode("¬", $_REQUEST['CAMPOS']);
    $pCAS = isset($_REQUEST['pCAS'])?$_REQUEST['pCAS']:0;
    $pConsecutivoHC = isset($_REQUEST['pConsecutivoHC'])?$_REQUEST['pConsecutivoHC']:0;
    $pProfesional = isset($_REQUEST['pProfesional'])?$_REQUEST['pProfesional']:0;
    $qry = "CALL sp_asistencial_partisalud_update_tomasignos('" . $pCAS . "','" . $pConsecutivoHC . "','" . $pProfesional . "'," . stripslashes(spParametros($estructura,"NO")) . ")";
    //echo $qry;
    $gBaseDatos = new ofiMySQLi();
    $gBaseDatos->conectar();
    if(@mysqli_query($gBaseDatos->ConexionID, $qry))
        echo "{success: true, requestedId:'1'}";
    else
       echo "{success: true, requestedId:'0'}";
    $gBaseDatos->cerrar();       
}

function GuardarTomaSignosSO(){
    $estructura = explode("¬", $_REQUEST['CAMPOS']);
    $pCAS = isset($_REQUEST['pCAS'])?$_REQUEST['pCAS']:0;
    $pConsecutivoHC = isset($_REQUEST['pConsecutivoHC'])?$_REQUEST['pConsecutivoHC']:0;
    $pProfesional = isset($_REQUEST['pProfesional'])?$_REQUEST['pProfesional']:0;
    $qry = "CALL sp_asistencial_saludocupa_update_tomasignos('" . $pCAS . "','" . $pConsecutivoHC . "','" . $pProfesional . "'," . stripslashes(spParametros($estructura,"NO")) . ")";
    //echo $qry;
    $gBaseDatos = new ofiMySQLi();
    $gBaseDatos->conectar();
    if(@mysqli_query($gBaseDatos->ConexionID, $qry))
        echo "{success: true, requestedId:'1'}";
    else
       echo "{success: true, requestedId:'0'}";
    $gBaseDatos->cerrar();       
}

function CambiarUbicacionActual($ParamUbicacion){
    $pConsecutivoHC = isset($_REQUEST['pConsecutivoHC'])?$_REQUEST['pConsecutivoHC']:0;
    $pUbicacion = isset($_REQUEST['pUbicacion'])?$_REQUEST['pUbicacion']:"RECEPCION";
    $pProceso = isset($_REQUEST['pProceso'])?$_REQUEST['pProceso']:"SIN DEFINIR";
    $qry = " ";
    switch($ParamUbicacion){
        case "VALMEDICA":
            $qry = "CALL sp_asistencial_partisalud_change_estado_valmedica('" . $pConsecutivoHC . "',\"" . $pUbicacion . "\",\"" . $pProceso . "\")";
            break;
        case "TOMASIGNOS":
            $qry = "CALL sp_asistencial_partisalud_change_estado_tomasignos('" . $pConsecutivoHC . "',\"" . $pUbicacion . "\",\"" . $pProceso . "\")";
            break;
        case "RESULTLABO":
            $qry = "CALL sp_asistencial_partisalud_change_estado_laboratorio('" . $pConsecutivoHC . "',\"" . $pUbicacion . "\",\"" . $pProceso . "\")";
            break;
        case "TOMAMUESTRAS":
            $qry = "CALL sp_asistencial_partisalud_change_estado_tomamuestras('" . $pConsecutivoHC . "',\"" . $pUbicacion . "\",\"" . $pProceso . "\")";
            break;
        case "FONOAUDIOLOGIA":
            $qry = "CALL sp_asistencial_partisalud_change_estado_fono('" . $pConsecutivoHC . "',\"" . $pUbicacion . "\",\"" . $pProceso . "\")";
            break;

        default:
            break;
    }
    $gBaseDatos = new ofiMySQLi();
    $gBaseDatos->conectar();
    //echo $qry;
    echo $gBaseDatos->jasonSP_arreglo($qry);
    $gBaseDatos->liberar();
    $gBaseDatos->cerrar();
}

function VerHistorialLaboral(){
    $pPaciente = isset($_REQUEST['pPaciente'])?$_REQUEST['pPaciente']:0;
    $gBaseDatos = new ofiMySQLi();
    $gBaseDatos->conectar();
    $qry = "CALL sp_asistencial_saludocupacional001_historiallaboral('" . $pPaciente . "')";
    $gBaseDatos->QryID = @mysqli_query($gBaseDatos->ConexionID, $qry);
    $arr = array();
    while($row = @mysqli_fetch_assoc($gBaseDatos->QryID))
    {
        $nRow = $row;
        foreach($row as $key => $val)
        {
            $nRow[$key] = PonerAcentosHTML(utf8_decode(str_replace("\n\n", "\n",preg_replace('/\<br(\s*)?\/?\>/i', "\n",$val))));
        }
        $arr[] = $nRow;
    }
    $gBaseDatos->liberar();
    $gBaseDatos->cerrar();
    $jsonresult = JEncode($arr);
    if (!is_null($jsonresult))
        echo '({"total":"0","results":'. $jsonresult .'})';
}

function BorrarEstudiosVacios(){
    $pEmpresa = isset($_REQUEST['pEmpresa'])?$_REQUEST['pEmpresa']:0;
    $pIPS = isset($_REQUEST['pIPS'])?$_REQUEST['pIPS']:0;
    $pPaciente = isset($_REQUEST['pPaciente'])?$_REQUEST['pPaciente']:0;
    $gBaseDatos = new ofiMySQLi();
    $gBaseDatos->conectar();
    $qry = "CALL sp_asistencial_saludocupacional001_delevolucion_empty('" . $pEmpresa . "','" . $pIPS . "','" . $pPaciente . "')";
    //echo $qry;
    echo $gBaseDatos->jasonSP_arreglo($qry);
    $gBaseDatos->liberar();
    $gBaseDatos->cerrar();
}

function GuardarHistorialLaboral(){

    $estructura = explode("¬", $_REQUEST['CAMPOS']);
    $pProceso = isset($_REQUEST['pProceso'])?$_REQUEST['pProceso']:"NA";
    $qry = "CALL sp_asistencial_saludocupacional001_historiallaboral_add(" . stripslashes(spParametros($estructura,"NO")) . ")";
    //echo $qry;
    $gBaseDatos = new ofiMySQLi();
    $gBaseDatos->conectar();
    if(@mysqli_query($gBaseDatos->ConexionID, $qry))
        echo "{success: true, requestedId:'1'}";
    else
       echo "{success: true, requestedId:'0'}";
    $gBaseDatos->cerrar();   
}

function EliminarHistorialLaboral()
{
    $pIdHistorial = isset($_REQUEST['pIdHistorial'])?$_REQUEST['pIdHistorial']:0;
    $gBaseDatos = new ofiMySQLi();
    $gBaseDatos->conectar();
    $qry = "CALL sp_asistencial_saludocupacional001_historiallaboral_del('" . $pIdHistorial . "')";
    if(@mysqli_query($gBaseDatos->ConexionID, $qry))
        echo '1';
    else
        echo '0';
    $gBaseDatos->cerrar();
}



function VerHistorialHCxPacienteFiltro(){
    $pEmpresa = isset($_REQUEST['pEmpresa'])?$_REQUEST['pEmpresa']:0;
    $pPaciente = isset($_REQUEST['pPaciente'])?$_REQUEST['pPaciente']:0;
    $pProfesional = isset($_REQUEST['pProfesional'])?$_REQUEST['pProfesional']:0;
    $pDesde = isset($_REQUEST['pDesde'])?$_REQUEST['pDesde']:null;
    $pHasta = isset($_REQUEST['pHasta'])?$_REQUEST['pHasta']:null;
    if ($pDesde == "" || $pDesde == null)
        $pFiltroFec = "N";
    else
        $pFiltroFec = "S";
    $gBaseDatos = new ofiMySQLi();
    $gBaseDatos->conectar();
    $qry = "CALL sp_asistencial_evolucionesxpaciente_filtro('" . $pEmpresa . "','" . $pPaciente . "','" . $pProfesional . "',\"" . $pDesde . "\",\"" . $pHasta . "\",\"" . $pFiltroFec . "\")";
    //echo $qry;
    $gBaseDatos->QryID = @mysqli_query($gBaseDatos->ConexionID, $qry);
    $arr = array();
    while($row = @mysqli_fetch_assoc($gBaseDatos->QryID))
    {
        $nRow = $row;
        foreach($row as $key => $val)
        {
            $nRow[$key] = utf8_decode($val);
        }
        $arr[] = $nRow;
    }
    $gBaseDatos->liberar();
    $gBaseDatos->cerrar();
    $jsonresult = JEncode($arr);
    if (!is_null($jsonresult))
        echo '({"total":"0","results":'. $jsonresult .'})';
}
   
function VerHistorialAtencionesSaludOcupacional(){
    $pEmpresa = isset($_REQUEST['pEmpresa'])?$_REQUEST['pEmpresa']:0;
    $pPaciente = isset($_REQUEST['pPaciente'])?$_REQUEST['pPaciente']:0;
    $gBaseDatos = new ofiMySQLi();
    $gBaseDatos->conectar();
    $qry = "CALL sp_asistencial_saludocupacional001_historialatenciones('" . $pEmpresa . "','" . $pPaciente . "')";
    $gBaseDatos->QryID = @mysqli_query($gBaseDatos->ConexionID, $qry);
    $arr = array();
    while($row = @mysqli_fetch_assoc($gBaseDatos->QryID))
    {
        $nRow = $row;
        foreach($row as $key => $val)
        {
            $nRow[$key] = utf8_decode($val);
        }
        $arr[] = $nRow;
    }
    $gBaseDatos->liberar();
    $gBaseDatos->cerrar();
    $jsonresult = JEncode($arr);
    if (!is_null($jsonresult))
        echo '({"total":"0","results":'. $jsonresult .'})';   
}

function VerHistorialHCxPaciente(){
    $pEmpresa = isset($_REQUEST['pEmpresa'])?$_REQUEST['pEmpresa']:0;
    $pPaciente = isset($_REQUEST['pPaciente'])?$_REQUEST['pPaciente']:0;
    $gBaseDatos = new ofiMySQLi();
    $gBaseDatos->conectar();
    $qry = "CALL sp_asistencial_evolucionesxpaciente('" . $pEmpresa . "','" . $pPaciente . "')";
    $gBaseDatos->QryID = @mysqli_query($gBaseDatos->ConexionID, $qry);
    $arr = array();
    while($row = @mysqli_fetch_assoc($gBaseDatos->QryID))
    {
        $nRow = $row;
        foreach($row as $key => $val)
        {
            $nRow[$key] = utf8_decode($val);
        }
        $arr[] = $nRow;
    }
    $gBaseDatos->liberar();
    $gBaseDatos->cerrar();
    $jsonresult = JEncode($arr);
    if (!is_null($jsonresult))
        echo '({"total":"0","results":'. $jsonresult .'})';
}

function GuardarHC($Origen)
{
    
    $pEmpresa = isset($_REQUEST['pEmpresa'])?$_REQUEST['pEmpresa']:0;
    $estructura = explode("¬", $_REQUEST['CAMPOS']);
    $pIPS = isset($_REQUEST['pIPS'])?$_REQUEST['pIPS']:0;
    $pPaciente = isset($_REQUEST['pPaciente'])?$_REQUEST['pPaciente']:0;
    //$pProfesional = isset($_REQUEST['pProfesional'])?$_REQUEST['pProfesional']:0;
    $pProfesional = $_SESSION['ID_PROFESIONAL_HC'];
    $pidPlantillaHC = isset($_REQUEST['pidPlantillaHC'])?$_REQUEST['pidPlantillaHC']:0;
    $pCAS = isset($_REQUEST['pCAS'])?$_REQUEST['pCAS']:0;
    $pConsecutivoDetalle = isset($_REQUEST['pConsecutivoDetalle'])?$_REQUEST['pConsecutivoDetalle']:0;
    $pFechaAtencion = isset($_REQUEST['pFechaAtencion'])?$_REQUEST['pFechaAtencion']:null;
    $pHoraApertura = isset($_REQUEST['pHoraApertura'])?$_REQUEST['pHoraApertura']:null;
    $pActividad = isset($_REQUEST['pActividad'])?$_REQUEST['pActividad']:null;
    $pPlantilla = isset($_REQUEST['pPlantilla'])?$_REQUEST['pPlantilla']:null;
    $contenido = isset($_REQUEST['CAMPOS'])?$_REQUEST['CAMPOS']:null;
    $pEvolucion = utf8_encode(str_replace('"', '""',nl2br($contenido)));
    $pDiagppal = isset($_REQUEST['pDiagppal'])?$_REQUEST['pDiagppal']:null;
    $pDiagrel1 = isset($_REQUEST['pDiagrel1'])?$_REQUEST['pDiagrel1']:null;
    $pDiagrel2 = isset($_REQUEST['pDiagrel2'])?$_REQUEST['pDiagrel2']:null;
    $pDiagrel3 = isset($_REQUEST['pDiagrel3'])?$_REQUEST['pDiagrel3']:null;
    $pTipodiag = isset($_REQUEST['pTipodiag'])?$_REQUEST['pTipodiag']:null;
    $pFinalidad = isset($_REQUEST['pFinalidad'])?$_REQUEST['pFinalidad']:null;
    $pCausa = isset($_REQUEST['pCausa'])?$_REQUEST['pCausa']:null;
    $pUsuario = isset($_REQUEST['pUsuario'])?$_REQUEST['pUsuario']:0;
    $pIdCliente = isset($_REQUEST['pIdCliente'])?$_REQUEST['pIdCliente']:0;
    $pIdPlan = isset($_REQUEST['pIdPlan'])?$_REQUEST['pIdPlan']:0;
    $pIdSubPlan = isset($_REQUEST['pIdSubPlan'])?$_REQUEST['pIdSubPlan']:0;
    $pIdContrato = isset($_REQUEST['pIdContrato'])?$_REQUEST['pIdContrato']:0;
    $gBaseDatos = new ofiMySQLi();
    $gBaseDatos->conectar();
    if($Origen == "HC"){
        $qry = "CALL sp_asistencial_saludocupacional001_add('" . $pEmpresa . "','" . $pIPS . "','" . $pPaciente . "','" . $pProfesional . "','" . $pCAS . "','" . $pConsecutivoDetalle . "',\"" . $pFechaAtencion . "\",\"" . $pHoraApertura . "\",\"" . $pActividad . "\",\"" . $pPlantilla . "\",\"" . $pDiagppal . "\",\"" . $pDiagrel1 . "\",\"" . $pDiagrel2 . "\",\"" . $pDiagrel3 . "\",\"" . $pTipodiag . "\",\"" . $pFinalidad . "\",\"" . $pCausa . "\",'" . $pUsuario . "','" . $pIdCliente . "','" . $pIdPlan . "','" . $pIdSubPlan . "','" . $pIdContrato . "','" . $pidPlantillaHC . "'," . stripslashes(spParametros($estructura,"SI")) . ")";
    }else{
        $qry = "CALL sp_asistencial_saludocupacional001_anexo_add('" . $pPaciente . "','" . $pConsecutivoDetalle . "',"  . stripslashes(spParametros($estructura,"SI")) . ")";
    }
    //echo $qry;
    if(@mysqli_query($gBaseDatos->ConexionID, $qry))
        echo "{success: true, requestedId:'1'}";
    else
       echo "{success: true, requestedId:'0'}";
    $gBaseDatos->cerrar();   
}

function ModificarPartisalud(){
    $pEmpresa = isset($_REQUEST['pEmpresa'])?$_REQUEST['pEmpresa']:0;
    $estructura = explode("¬", $_REQUEST['CAMPOS']);
    $pIPS = isset($_REQUEST['pIPS'])?$_REQUEST['pIPS']:0;
    $pPaciente = isset($_REQUEST['pPaciente'])?$_REQUEST['pPaciente']:0;
    //$pProfesional = isset($_REQUEST['pProfesional'])?$_REQUEST['pProfesional']:0;
    $pProfesional = $_SESSION['ID_PROFESIONAL_HC'];
    $pCAS = isset($_REQUEST['pCAS'])?$_REQUEST['pCAS']:0;
    $pConsecutivoDetalle = isset($_REQUEST['pConsecutivoDetalle'])?$_REQUEST['pConsecutivoDetalle']:0;
    $pFechaAtencion = isset($_REQUEST['pFechaAtencion'])?$_REQUEST['pFechaAtencion']:null;
    $pHoraApertura = isset($_REQUEST['pHoraApertura'])?$_REQUEST['pHoraApertura']:null;
    $pActividad = isset($_REQUEST['pActividad'])?$_REQUEST['pActividad']:null;
    $pPlantilla = isset($_REQUEST['pPlantilla'])?$_REQUEST['pPlantilla']:null;
    $contenido = isset($_REQUEST['CAMPOS'])?$_REQUEST['CAMPOS']:null;
    $pEvolucion = utf8_encode(str_replace('"', '""',nl2br($contenido)));
    $pDiagppal = isset($_REQUEST['pDiagppal'])?$_REQUEST['pDiagppal']:null;
    $pDiagrel1 = isset($_REQUEST['pDiagrel1'])?$_REQUEST['pDiagrel1']:null;
    $pDiagrel2 = isset($_REQUEST['pDiagrel2'])?$_REQUEST['pDiagrel2']:null;
    $pDiagrel3 = isset($_REQUEST['pDiagrel3'])?$_REQUEST['pDiagrel3']:null;
    $pTipodiag = isset($_REQUEST['pTipodiag'])?$_REQUEST['pTipodiag']:null;
    $pFinalidad = isset($_REQUEST['pFinalidad'])?$_REQUEST['pFinalidad']:null;
    $pCausa = isset($_REQUEST['pCausa'])?$_REQUEST['pCausa']:null;
    $pUsuario = isset($_REQUEST['pUsuario'])?$_REQUEST['pUsuario']:0;
    $pIdCliente = isset($_REQUEST['pIdCliente'])?$_REQUEST['pIdCliente']:0;
    $pIdPlan = isset($_REQUEST['pIdPlan'])?$_REQUEST['pIdPlan']:0;
    $pIdSubPlan = isset($_REQUEST['pIdSubPlan'])?$_REQUEST['pIdSubPlan']:0;
    $pIdContrato = isset($_REQUEST['pIdContrato'])?$_REQUEST['pIdContrato']:0;
    $gBaseDatos = new ofiMySQLi();
    $gBaseDatos->conectar();
    $qry = "CALL sp_asistencial_partisalud_update_valoramedica('" . $pCAS . "','" . $pConsecutivoHC . "','" . $pProfesional . "'," . stripslashes(spParametros($estructura,"NO")) . ")";
    //echo $qry;
    if(@mysqli_query($gBaseDatos->ConexionID, $qry))
        echo "{success: true, requestedId:'1'}";
    else
       echo "{success: true, requestedId:'0'}";
    $gBaseDatos->cerrar();
}

function ModificarHC($pOrigen)
{

    $pEmpresa = isset($_REQUEST['pEmpresa'])?$_REQUEST['pEmpresa']:0;
    $estructura = explode("¬", $_REQUEST['CAMPOS']);
    $pIPS = isset($_REQUEST['pIPS'])?$_REQUEST['pIPS']:0;
    $pPaciente = isset($_REQUEST['pPaciente'])?$_REQUEST['pPaciente']:0;
    //$pProfesional = isset($_REQUEST['pProfesional'])?$_REQUEST['pProfesional']:0;
    $pProfesional = $_SESSION['ID_PROFESIONAL_HC'];
    $pCAS = isset($_REQUEST['pCAS'])?$_REQUEST['pCAS']:0;
    $pConsecutivoDetalle = isset($_REQUEST['pConsecutivoDetalle'])?$_REQUEST['pConsecutivoDetalle']:0;
    $pFechaAtencion = isset($_REQUEST['pFechaAtencion'])?$_REQUEST['pFechaAtencion']:null;
    $pHoraApertura = isset($_REQUEST['pHoraApertura'])?$_REQUEST['pHoraApertura']:null;
    $pActividad = isset($_REQUEST['pActividad'])?$_REQUEST['pActividad']:null;
    $pPlantilla = isset($_REQUEST['pPlantilla'])?$_REQUEST['pPlantilla']:null;
    $contenido = isset($_REQUEST['CAMPOS'])?$_REQUEST['CAMPOS']:null;
    $pEvolucion = utf8_encode(str_replace('"', '""',nl2br($contenido)));
    $pDiagppal = isset($_REQUEST['pDiagppal'])?$_REQUEST['pDiagppal']:null;
    $pDiagrel1 = isset($_REQUEST['pDiagrel1'])?$_REQUEST['pDiagrel1']:null;
    $pDiagrel2 = isset($_REQUEST['pDiagrel2'])?$_REQUEST['pDiagrel2']:null;
    $pDiagrel3 = isset($_REQUEST['pDiagrel3'])?$_REQUEST['pDiagrel3']:null;
    $pTipodiag = isset($_REQUEST['pTipodiag'])?$_REQUEST['pTipodiag']:null;
    $pFinalidad = isset($_REQUEST['pFinalidad'])?$_REQUEST['pFinalidad']:null;
    $pCausa = isset($_REQUEST['pCausa'])?$_REQUEST['pCausa']:null;
    $pUsuario = isset($_REQUEST['pUsuario'])?$_REQUEST['pUsuario']:0;
    $pIdCliente = isset($_REQUEST['pIdCliente'])?$_REQUEST['pIdCliente']:0;
    $pIdPlan = isset($_REQUEST['pIdPlan'])?$_REQUEST['pIdPlan']:0;
    $pIdSubPlan = isset($_REQUEST['pIdSubPlan'])?$_REQUEST['pIdSubPlan']:0;
    $pIdContrato = isset($_REQUEST['pIdContrato'])?$_REQUEST['pIdContrato']:0;
    $gBaseDatos = new ofiMySQLi();
    $gBaseDatos->conectar();
    if($pOrigen == "HC"){
        $qry = "CALL sp_asistencial_saludocupacional001_edit('" . $pEmpresa . "','" . $pIPS . "','" . $pPaciente . "','" . $pProfesional . "','" . $pCAS . "','" . $pConsecutivoDetalle . "',\"" . $pFechaAtencion . "\",\"" . $pHoraApertura . "\",\"" . $pActividad . "\",\"" . $pPlantilla . "\",\"" . $pDiagppal . "\",\"" . $pDiagrel1 . "\",\"" . $pDiagrel2 . "\",\"" . $pDiagrel3 . "\",\"" . $pTipodiag . "\",\"" . $pFinalidad . "\",\"" . $pCausa . "\",'" . $pUsuario . "','" . $pIdCliente . "','" . $pIdPlan . "','" . $pIdSubPlan . "','" . $pIdContrato . "'," . stripslashes(spParametros($estructura,"SI")) . ")";
    }else{
        $qry = "CALL sp_asistencial_saludocupacional001_anexo_edit('" . $pPaciente . "','" . $pConsecutivoDetalle . "',"  . stripslashes(spParametros($estructura,"SI")) . ")";
    }
    //echo $qry;
    if(@mysqli_query($gBaseDatos->ConexionID, $qry))
        echo "{success: true, requestedId:'1'}";
    else
       echo "{success: true, requestedId:'0'}";
    $gBaseDatos->cerrar();
}