<?php

set_time_limit(500);
require_once('../../../../lib/tcpdf/config/lang/spa.php');
require_once('../../../../lib/tcpdf/tcpdf.php');
require_once('audiograma.php');
require("../../../../core/php/_database.php");
require("../../../../core/php/php_functions.php");
//header('Content-type: application/pdf; charset: UTF-8');

    session_start();
    $pConsultorioVirtual = $_SESSION['IDBD'];
    $nomEmpresa = $_SESSION['NOM_EMPRESA'];
    $nomUsuario = $_SESSION['NOM_USUARIO'];
    $pEmpresa = isset($_REQUEST['pEmpresa'])?$_REQUEST['pEmpresa']:1;
    $pIPS = isset($_REQUEST['pIPS'])?$_REQUEST['pIPS']:1;
    $pPaciente = isset($_REQUEST['pPaciente'])?$_REQUEST['pPaciente']:0;
    $pEvolucion = isset($_REQUEST['pEvolucion'])?$_REQUEST['pEvolucion']:0;

    $gBaseDatos = new ofiMySQLi();
    $gBaseDatos->conectar();
    $qry = "CALL sp_asistencial_saludocupa_printhc('" . $pEmpresa . "','" . $pIPS . "','" . $pPaciente . "','" . $pEvolucion . "')";
    $gBaseDatos->QryID = @mysqli_query($gBaseDatos->ConexionID, $qry);
    while ($row[] = @mysqli_fetch_assoc($gBaseDatos->QryID));
    $gBaseDatos->liberar();
    $gBaseDatos->cerrar();
    $pRegistros = count($row);

    //Definicion de las Margenes
    $LeftMargin = PDF_MARGIN_LEFT;
    $TopMargin = 5;
    $RightMargin = PDF_MARGIN_RIGHT;
    $HeaderMargin = PDF_MARGIN_HEADER;
    $BottomMargin = 3;
    $FooterMargin = 5;
    $Alineacion = "P";
    $FormatoPagina = "CARTA";
    $UsaPiePagina = "SI";
    $pTipoEncabezado = "FVP";
    $pControlSalto = 40;
    $styleBarCode = array(
        'position' => 'R',
        'align' => 'R',
        'stretch' => false,
        'fitwidth' => true,
        'cellfitalign' => 'R',
        'border' => true,
        'hpadding' => 'auto',
        'vpadding' => 'auto',
        'fgcolor' => array(0,0,0),
        'bgcolor' => false, //array(255,255,255),
        'text' => true,
        'font' => 'helvetica',
        'fontsize' => 7,
        'stretchtext' => 4
    );
    //Inicializacion de la Clase
    $pdf = new TCPDF($Alineacion, PDF_UNIT, $FormatoPagina, true, 'UTF-8', false);
    //Inicializacion Variables de Control
    $pdf->pAlineacionEncabezado = $Alineacion;
    $pdf->pTituloInforme = "AUDIOMETRIA";
    $pdf->pImprimeLogo = "NO";
    $pdf->pAnchoTxtPagina = 210;
    $pdf->pNomEmpresa = $_SESSION['NOM_EMPRESA'];
    $pdf->pTDocEmpresa = $_SESSION['EMPRESA_TDOC'];
    $pdf->pDocEmpresa = $_SESSION['EMPRESA_DOC'];
    $pdf->pDirEmpresa = $_SESSION['EMPRESA_DIR'];
    $pdf->pTelEmpresa = $_SESSION['EMPRESA_TEL'];
    $pdf->pCiuEmpresa = $_SESSION['EMPRESA_CIU'];
    $pdf->pEspEmpresa = $_SESSION['EMPRESA_ESP'];
    $pdf->pRegEmpresa = $_SESSION['EMPRESA_REGIMEN'];
    $pdf->pContribuyentes = $_SESSION['EMPRESA_CONTRIBUYENTE'];
    $pdf->pReteIVA  = $_SESSION['EMPRESA_RTEICA'];
    $pdf->pReteICA = $_SESSION['EMPRESA_RTEIVA'];

    $pdf->pTipoEncabezado = $pTipoEncabezado;
    $pdf->pNomSede = $_SESSION['EMPRESA_DOC'];
    $pdf->pNomIPS = $_SESSION['NOM_IPS'];
    $pdf->pMargenPie = -20;
    $pdf->pLogoCliente = "../../../empresas/" . $_SESSION['I_EMPRESA'] . "/logo/logoenc.gif";
    $pdf->pPrefijo = 1; //$row[0]["Prefijo"];
    $pdf->pNroDocumento = 1; //str_pad($row[0]["NroDocumento"], 7, "0", STR_PAD_LEFT);
    $pdf->pNroResolucion = 1; //$row[0]["NroResolucion"];
    $pdf->pFechaDoc = 1; //$row[0]["FechaDocumento"];
    $pdf->pCAS = null;
    $pdf->pTratamiento = null;
    $pdf->pUsaPie = $UsaPiePagina;

    $pdf->SetCreator(PDF_CREATOR);
    $pdf->SetAuthor('Sistemas Ofisalud © - 2011');
    $pdf->SetTitle('Ofimedical©');
    $pdf->SetSubject('Soporte Audiometria');

    $pdf->SetHeaderData($pdf->pLogoCliente, PDF_HEADER_LOGO_WIDTH, $pdf->pTituloInforme, PDF_HEADER_STRING);
    $pdf->setHeaderFont(Array(PDF_FONT_NAME_MAIN, '', PDF_FONT_SIZE_MAIN));
    $pdf->setFooterFont(Array(PDF_FONT_NAME_DATA, '', PDF_FONT_SIZE_DATA));
    $pdf->SetDefaultMonospacedFont(PDF_FONT_MONOSPACED);
    $pdf->SetMargins($LeftMargin, $TopMargin, $RightMargin);
    $pdf->SetHeaderMargin($HeaderMargin);
    $pdf->SetFooterMargin($FooterMargin);
    // set bacground image

    $pdf->SetAutoPageBreak(TRUE, $BottomMargin);
    $pdf->setImageScale(PDF_IMAGE_SCALE_RATIO);
    $pdf->setLanguageArray($l);
    $pdf->setFontSubsetting(true);
    $pdf->SetFont('dejavusans', '', 14, '', true);

    for($i=0;$i<$pRegistros;$i++)
    {
        if($row[$i]["nomPaciente"] != ""){
            if ($idPaciente != $row[$i]["nomPaciente"])
            {
                EncabezadoPagina($pdf, $row, $i, $rowcount, $contador, $pDesde, $pHasta);
            }
            $pdf->SetFont(PDF_FONT_NAME_MAIN, '', 7);
            $pdf->Ln(0.5);
            
            $mostrarHC = '<table><tr><td width="80" style="font-size:30px; font-weight:bolder;">FECHA:</td><td>' . utf8_decode($row[$i]["Fecha"]);
            if(utf8_decode($row[$i]["HoraInicioFono"]) != "" && utf8_decode($row[$i]["HoraInicioFono"]) != null){
                $mostrarHC .= '&nbsp;&nbsp;-&nbsp;<b>HORA:</b>&nbsp;' . utf8_decode($row[$i]["HoraInicioFono"]);
            } 
            $mostrarHC .= '</td></tr>';
            //$mostrarHC .= '<tr><td style="font-size:30px; font-weight:bolder;">EMPRESA:</td><td>' . utf8_decode($row[$i]["Empresa"]) . '</td></tr>';
            $mostrarHC .= '<tr><td style="font-size:30px; font-weight:bolder;">CIUDAD:</td><td>' . utf8_decode($row[$i]["Muni"]) . " - " . utf8_decode($row[$i]["Depto"]) . '</td></tr></table>';
            $pdf->writeHTML($mostrarHC, true, false, false, false, '');
            if ($pdf->GetY() >= ($pdf->getPageHeight()-$pControlSalto))
            {
                EncabezadoPagina($pdf, $row, $i, $rowcount, $contador, $pDesde, $pHasta);
            }
            
            $mostrarHC = '<table><tr><td colspan="4" style="font-size:30px; font-weight:bolder;">DATOS PERSONALES:</td></tr>';
            $mostrarHC .= '<tr><td width="145" style="font-size:30px; font-weight:bolder;">NOMBRES Y APELLIDOS:</td><td width="300">' . utf8_decode($row[$i]["Nom1"]) . " " . utf8_decode($row[$i]["Nom2"]) . " " . utf8_decode($row[$i]["Ape1"]) . " " . utf8_decode($row[$i]["Ape2"]) . '</td>';
            $mostrarHC .= '<td></td></tr>';
            $mostrarHC .= '<tr><td style="font-size:30px; font-weight:bolder;">IDENTIFICACION:</td><td>' . utf8_decode($row[$i]["TipDoc"]) . " - " . utf8_decode($row[$i]["Documento"]) . '</td><td width="100" style="font-size:30px; font-weight:bolder;"></td><td></td></tr>';
            $mostrarHC .= '<tr><td style="font-size:30px; font-weight:bolder;">FECHA DE NACIMIENTO:</td><td>' . utf8_decode($row[$i]["FecNac"]) . '</td><td width="100" style="font-size:30px; font-weight:bolder;">SEXO:</td><td>' . utf8_decode($row[$i]["Genero"]) . '</td></tr>';
            $mostrarHC .= '<tr><td style="font-size:30px; font-weight:bolder;">ESTADO CIVIL:</td><td>' . utf8_decode($row[$i]["EstadoCivil"]) . '</td><td width="100" style="font-size:30px; font-weight:bolder;">EDAD:</td><td align = "left">' . utf8_decode($row[0]["EdadPaciente"]) . '</td></tr>';
            $mostrarHC .= '<tr><td style="font-size:30px; font-weight:bolder;">DIRECCION:</td><td>' . utf8_decode($row[$i]["Direccion"]) . '</td><td width="100" style="font-size:30px; font-weight:bolder;">TELEFONO:</td><td>' . utf8_decode($row[$i]["Telefono"]) . " - " . utf8_decode($row[$i]["Telefono1"]) . '</td></tr>';
            $mostrarHC .= '<tr><td style="font-size:30px; font-weight:bolder;">ESCOLARIDAD:</td><td>' . utf8_decode($row[$i]["Escolaridad"]) . '</td><td width="100" style="font-size:30px; font-weight:bolder;">PROFESION:</td><td>' . utf8_decode($row[$i]["Ocupacion"]) . '</td></tr>';
            //$mostrarHC .= '<tr><td style="font-size:30px; font-weight:bolder;">CARGO ACTUAL:</td><td>' . utf8_decode($row[$i]["CargoActual"]) . '</td><td width="100" style="font-size:30px; font-weight:bolder;">FECHA INGRESO:</td><td>' . utf8_decode($row[$i]["FechaIngreso"]) . '</td></tr>';
            //$mostrarHC .= '<tr><td style="font-size:30px; font-weight:bolder;">FACTORES RIESGO:</td><td colspan="3">' . utf8_decode($row[$i]["FactorRiesgoActual"]) . '</td></tr>';
            $mostrarHC .= '</table>';
            $pdf->writeHTML($mostrarHC, true, false, false, false, '');
            if ($pdf->GetY() >= ($pdf->getPageHeight()-$pControlSalto))
            {
                EncabezadoPagina($pdf, $row, $i, $rowcount, $contador, $pDesde, $pHasta);
            }
            if($row[0]["ConceptoFonoaudiologia"] != "SIN DEFINIR"){
                $mostrarHC = '<table>';
                $mostrarHC .= '<tr>';
                $mostrarHC .= '<td width="700" style="font-size:30px;" align="center"><b>ANTECEDENTES OTOLOGICOS</b></td>';
                $mostrarHC .= '</tr>';
                $mostrarHC .= '<tr>';
                $mostrarHC .= '<td width="175" align="left" style="font-size:28px;">';
                if (utf8_decode($row[0]["FonoAO_Otalqia"]) != "" && utf8_decode($row[0]["FonoAO_Otalqia"]) != null){
                    $mostrarHC .= '&#8226;&nbsp;OTALGIA: ' . utf8_decode($row[0]["FonoAO_Otalqia"]) . '<br>';
                }
                if (utf8_decode($row[0]["FonoAO_Vertigo"]) != "" && utf8_decode($row[0]["FonoAO_Vertigo"]) != null){
                    $mostrarHC .= '&#8226;&nbsp;VERTIGO: ' . utf8_decode($row[0]["FonoAO_Vertigo"]) . '<br>';
                }
                $mostrarHC .= '</td>';
                
                $mostrarHC .= '<td width="175" align="left" style="font-size:28px;">';
                if (utf8_decode($row[0]["FonoAO_OtitisExterna"]) != "" && utf8_decode($row[0]["FonoAO_OtitisExterna"]) != null){
                    $mostrarHC .= '&#8226;&nbsp;OTITIS EXTERNA: ' . utf8_decode($row[0]["FonoAO_OtitisExterna"]) . '<br>';
                }
                if (utf8_decode($row[0]["FonoAO_Otorrea"]) != "" && utf8_decode($row[0]["FonoAO_Otorrea"]) != null){
                    $mostrarHC .= '&#8226;&nbsp;OTORREA: ' . utf8_decode($row[0]["FonoAO_Otorrea"]) . '<br>';
                }
                
                $mostrarHC .= '</td>';
                
                $mostrarHC .= '<td width="175" align="left" style="font-size:28px;">';
                if (utf8_decode($row[0]["FonoAO_OtitisMedia"]) != "" && utf8_decode($row[0]["FonoAO_OtitisMedia"]) != null){
                    $mostrarHC .= '&#8226;&nbsp;OTITIS MEDIA: ' . utf8_decode($row[0]["FonoAO_OtitisMedia"]) . '<br>';
                }
                if (utf8_decode($row[0]["FonoAO_Otorragia"]) != "" && utf8_decode($row[0]["FonoAO_Otorragia"]) != null){
                    $mostrarHC .= '&#8226;&nbsp;OTORRAGIA: ' . utf8_decode($row[0]["FonoAO_Otorragia"]) . '<br>';
                }
                $mostrarHC .= '</td>';
                
                $mostrarHC .= '<td width="175" align="left" style="font-size:28px;">';
                if (utf8_decode($row[0]["FonoAO_Acufenos"]) != "" && utf8_decode($row[0]["FonoAO_Acufenos"]) != null){
                    $mostrarHC .= '&#8226;&nbsp;ACUFENOS: ' . utf8_decode($row[0]["FonoAO_Acufenos"]) . '<br>';
                }
                if (utf8_decode($row[0]["FonoAO_Otros"]) != "" && utf8_decode($row[0]["FonoAO_Otros"]) != null){
                    $mostrarHC .= '&#8226;&nbsp;OTROS: ' . utf8_decode($row[0]["FonoAO_Otros"]);
                }
                $mostrarHC .= '</td>';
                $mostrarHC .= '</tr>';
                $mostrarHC .= '</table>';
                $pdf->writeHTML($mostrarHC, true, false, false, false, '');
                if ($pdf->GetY() >= ($pdf->getPageHeight()-$pControlSalto))
                {
                    EncabezadoPagina($pdf, $row, $i, $rowcount, $contador, $pDesde, $pHasta);
                }
                $pdf->Ln(-4);
                
                if (utf8_decode($row[0]["FonoAntecedentesFamiliares"]) != "" && utf8_decode($row[0]["FonoAntecedentesFamiliares"]) != null){
                    $mostrarHC = '<table>';
                    $mostrarHC .= '<tr>';
                    $mostrarHC .= '<td width="700" style="font-size:30px;" align="center"><b>ANTECEDENTES FAMILIARES</b></td>';
                    $mostrarHC .= '</tr>';
                    $mostrarHC .= '<tr>';
                    $mostrarHC .= '<td width="175" align="left" style="font-size:28px;">';
                    $mostrarHC .= utf8_decode($row[0]["FonoAntecedentesFamiliares"]);
                    $mostrarHC .= '</td>';
                    $mostrarHC .= '</tr>';
                    $mostrarHC .= '</table>';
                    $pdf->writeHTML($mostrarHC, true, false, false, false, '');
                    if ($pdf->GetY() >= ($pdf->getPageHeight()-$pControlSalto))
                    {
                        EncabezadoPagina($pdf, $row, $i, $rowcount, $contador, $pDesde, $pHasta);
                    }
                    $pdf->Ln(-4);
                }
                
                $mostrarHC = '<table>';
                $mostrarHC .= '<tr>';
                $mostrarHC .= '<td width="700" style="font-size:30px;" align="center"><b>EXPOSICIÓN A OTROS</b></td>';
                $mostrarHC .= '</tr>';
                $mostrarHC .= '<tr>';
                $mostrarHC .= '<td width="175" align="left" style="font-size:28px;">'; //COL1
                if (utf8_decode($row[0]["ExpoOtros_ServicioMilitar"]) != "" && utf8_decode($row[0]["ExpoOtros_ServicioMilitar"]) != null){
                    $mostrarHC .= '&#8226;&nbsp;SERVICIO MILITAR: ' . utf8_decode($row[0]["ExpoOtros_ServicioMilitar"]) . '<br>';
                }
                $mostrarHC .= '</td>';
                $mostrarHC .= '<td width="175" align="left" style="font-size:28px;">'; //COL2
                if (utf8_decode($row[0]["ExpoOtros_Moto"]) != "" && utf8_decode($row[0]["ExpoOtros_Moto"]) != null){
                    $mostrarHC .= '&#8226;&nbsp;MOTO: ' . utf8_decode($row[0]["ExpoOtros_Moto"]) . '<br>';
                }
                $mostrarHC .= '</td>';
                $mostrarHC .= '<td width="175" align="left" style="font-size:28px;">'; //COL3
                if (utf8_decode($row[0]["ExpoOtros_DispSonido"]) != "" && utf8_decode($row[0]["ExpoOtros_DispSonido"]) != null){
                    $mostrarHC .= '&#8226;&nbsp;DISPOSITIVOS DE SONIDO: ' . utf8_decode($row[0]["ExpoOtros_DispSonido"]) . '<br>';
                }
                $mostrarHC .= '</td>';
                $mostrarHC .= '<td width="175" align="left" style="font-size:28px;">'; //COL4
                if (utf8_decode($row[0]["ExpoOtros_Otros"]) != "" && utf8_decode($row[0]["ExpoOtros_Otros"]) != null){
                    $mostrarHC .= '&#8226;&nbsp;OTROS: ' . utf8_decode($row[0]["ExpoOtros_Otros"]) . '<br>';
                }
                $mostrarHC .= '</td>';
                $mostrarHC .= '</tr>';
                $mostrarHC .= '</table>';
                $pdf->writeHTML($mostrarHC, true, false, false, false, '');
                if ($pdf->GetY() >= ($pdf->getPageHeight()-$pControlSalto))
                {
                    EncabezadoPagina($pdf, $row, $i, $rowcount, $contador, $pDesde, $pHasta);
                }
                $pdf->Ln(-4);
                        
                $mostrarHC = '<table>';
                $mostrarHC .= '<tr>';
                $mostrarHC .= '<td width="700" style="font-size:30px;" align="center"><b>EXPLORACIÓN CLINICA OIDO DERECHO</b></td>';
                $mostrarHC .= '</tr>';
                $mostrarHC .= '<tr>';
                $mostrarHC .= '<td width="233" align="left" style="font-size:28px;">'; //COL1
                if (utf8_decode($row[0]["OD_Otoscopia"]) != "" && utf8_decode($row[0]["OD_Otoscopia"]) != null){
                    $mostrarHC .= '&#8226;&nbsp;OTOSCOPIA: ' . utf8_decode($row[0]["OD_Otoscopia"]) . '<br>';
                }
                if (utf8_decode($row[0]["OD_TaponCerumen"]) != "" && utf8_decode($row[0]["OD_TaponCerumen"]) != null){
                    $mostrarHC .= '&#8226;&nbsp;TAPON CERUMEN: ' . utf8_decode($row[0]["OD_TaponCerumen"]);
                }
                $mostrarHC .= '</td>';
                $mostrarHC .= '<td width="233" align="left" style="font-size:28px;">'; //COL2
                if (utf8_decode($row[0]["OD_PabellonAuricular"]) != "" && utf8_decode($row[0]["OD_PabellonAuricular"]) != null){
                    $mostrarHC .= '&#8226;&nbsp;PABELLON AURICULAR: ' . utf8_decode($row[0]["OD_PabellonAuricular"]) . '<br>';
                }
                if (utf8_decode($row[0]["OD_membranaTimpanica"]) != "" && utf8_decode($row[0]["OD_membranaTimpanica"]) != null){
                    $mostrarHC .= '&#8226;&nbsp;MEMBRANA TIMPANICA: ' . utf8_decode($row[0]["OD_membranaTimpanica"]);
                }
                $mostrarHC .= '</td>';
                $mostrarHC .= '<td width="233" align="left" style="font-size:28px;">'; //COL3
                if (utf8_decode($row[0]["OD_ConductoAuditivoExterno"]) != "" && utf8_decode($row[0]["OD_ConductoAuditivoExterno"]) != null){
                    $mostrarHC .= '&#8226;&nbsp;CONDUCTO AUDITIVO EXTERNO: ' . utf8_decode($row[0]["OD_ConductoAuditivoExterno"]) . '<br>';
                }
                if (utf8_decode($row[0]["OD_Otros"]) != "" && utf8_decode($row[0]["OD_Otros"]) != null){
                    $mostrarHC .= '&#8226;&nbsp;OTROS: ' . utf8_decode($row[0]["OD_Otros"]);
                }
                $mostrarHC .= '</td>';
                $mostrarHC .= '</tr>';
                $mostrarHC .= '</table>';
                $pdf->writeHTML($mostrarHC, true, false, false, false, '');
                if ($pdf->GetY() >= ($pdf->getPageHeight()-$pControlSalto))
                {
                    EncabezadoPagina($pdf, $row, $i, $rowcount, $contador, $pDesde, $pHasta);
                }
                        
                $mostrarHC = '<table>';
                $mostrarHC .= '<tr>';
                $mostrarHC .= '<td width="700" style="font-size:30px;" align="center"><b>EXPLORACIÓN CLINICA OIDO IZQUIERDO</b></td>';
                $mostrarHC .= '</tr>';
                $mostrarHC .= '<tr>';
                $mostrarHC .= '<td width="233" align="left" style="font-size:28px;">'; //COL1
                if (utf8_decode($row[0]["OI_Otoscopia"]) != "" && utf8_decode($row[0]["OI_Otoscopia"]) != null){
                    $mostrarHC .= '&#8226;&nbsp;OTOSCOPIA: ' . utf8_decode($row[0]["OI_Otoscopia"]) . '<br>';
                }
                if (utf8_decode($row[0]["OI_TaponCerumen"]) != "" && utf8_decode($row[0]["OI_TaponCerumen"]) != null){
                    $mostrarHC .= '&#8226;&nbsp;TAPON CERUMEN: ' . utf8_decode($row[0]["OI_TaponCerumen"]);
                }
                $mostrarHC .= '</td>';
                $mostrarHC .= '<td width="233" align="left" style="font-size:28px;">'; //COL2
                if (utf8_decode($row[0]["OI_PabellonAuricular"]) != "" && utf8_decode($row[0]["OI_PabellonAuricular"]) != null){
                    $mostrarHC .= '&#8226;&nbsp;PABELLON AURICULAR: ' . utf8_decode($row[0]["OI_PabellonAuricular"]) . '<br>';
                }
                if (utf8_decode($row[0]["OI_membranaTimpanica"]) != "" && utf8_decode($row[0]["OI_membranaTimpanica"]) != null){
                    $mostrarHC .= '&#8226;&nbsp;MEMBRANA TIMPANICA: ' . utf8_decode($row[0]["OI_membranaTimpanica"]);
                }
                $mostrarHC .= '</td>';
                $mostrarHC .= '<td width="233" align="left" style="font-size:28px;">'; //COL3
                if (utf8_decode($row[0]["OI_ConductoAuditivoExterno"]) != "" && utf8_decode($row[0]["OI_ConductoAuditivoExterno"]) != null){
                    $mostrarHC .= '&#8226;&nbsp;CONDUCTO AUDITIVO EXTERNO: ' . utf8_decode($row[0]["OI_ConductoAuditivoExterno"]) . '<br>';
                }
                if (utf8_decode($row[0]["OI_Otros"]) != "" && utf8_decode($row[0]["OI_Otros"]) != null){
                    $mostrarHC .= '&#8226;&nbsp;OTROS: ' . utf8_decode($row[0]["OI_Otros"]);
                }
                $mostrarHC .= '</td>';
                $mostrarHC .= '</tr>';
                $mostrarHC .= '</table>';
                $pdf->writeHTML($mostrarHC, true, false, false, false, '');
                if ($pdf->GetY() >= ($pdf->getPageHeight()-$pControlSalto))
                {
                    EncabezadoPagina($pdf, $row, $i, $rowcount, $contador, $pDesde, $pHasta);
                }
                
                $mostrarHC = '<table border="1">';
                $mostrarHC .= '<tr>';
                $mostrarHC .= '<td width="700" style="font-size:30px;" align="center"><b>EVALUACION AUDIOMETRICA VIA AEREA</b></td>';
                $mostrarHC .= '</tr>';
                $mostrarHC .= '<tr>';
                $mostrarHC .= '<td width="100" align="center" style="font-size:28px;"><b>Frecuencia</b></td>'; //COL1
                $mostrarHC .= '<td width="50" align="center" style="font-size:28px;"><b>OD</b></td>'; //COL2
                $mostrarHC .= '<td width="50" align="center" style="font-size:28px;"><b>OI</b></td>'; //COL3
                $mostrarHC .= '<td width="500" align="center" style="font-size:28px;" rowspan="10"><b>AUDIOGRAMA</b><br>';
                DrawAudiograma($mostrarHC, utf8_decode($row[0]["AudiogramaVA_OD250"]),utf8_decode($row[0]["AudiogramaVA_OD500"]),utf8_decode($row[0]["AudiogramaVA_OD1000"]),utf8_decode($row[0]["AudiogramaVA_OD2000"]),utf8_decode($row[0]["AudiogramaVA_OD3000"]),utf8_decode($row[0]["AudiogramaVA_OD4000"]),utf8_decode($row[0]["AudiogramaVA_OD6000"]),utf8_decode($row[0]["AudiogramaVA_OD8000"]),utf8_decode($row[0]["AudiogramaVA_OI250"]),utf8_decode($row[0]["AudiogramaVA_OI500"]),utf8_decode($row[0]["AudiogramaVA_OI1000"]),utf8_decode($row[0]["AudiogramaVA_OI2000"]),utf8_decode($row[0]["AudiogramaVA_OI3000"]),utf8_decode($row[0]["AudiogramaVA_OI4000"]),utf8_decode($row[0]["AudiogramaVA_OI6000"]),utf8_decode($row[0]["AudiogramaVA_OI8000"]));
                $mostrarHC .= '</td>'; //COL4
                $mostrarHC .= '</tr>';
                $mostrarHC .= '<tr>';
                $mostrarHC .= '<td width="100" align="center" style="font-size:28px;"><b>250</b></td>'; //COL1
                $mostrarHC .= '<td width="50" align="center" style="font-size:28px;">' . utf8_decode($row[0]["AudiogramaVA_OD250"]) . '</td>'; //COL2
                $mostrarHC .= '<td width="50" align="center" style="font-size:28px;">' . utf8_decode($row[0]["AudiogramaVA_OI250"]) . '</td>'; //COL3
                $mostrarHC .= '</tr>';
                $mostrarHC .= '<tr>';
                $mostrarHC .= '<td width="100" align="center" style="font-size:28px;"><b>500</b></td>'; //COL1
                $mostrarHC .= '<td width="50" align="center" style="font-size:28px;">' . utf8_decode($row[0]["AudiogramaVA_OD500"]) . '</td>'; //COL2
                $mostrarHC .= '<td width="50" align="center" style="font-size:28px;">' . utf8_decode($row[0]["AudiogramaVA_OI500"]) . '</td>'; //COL3
                $mostrarHC .= '</tr>';
                $mostrarHC .= '<tr>';
                $mostrarHC .= '<td width="100" align="center" style="font-size:28px;"><b>1000</b></td>'; //COL1
                $mostrarHC .= '<td width="50" align="center" style="font-size:28px;">' . utf8_decode($row[0]["AudiogramaVA_OD1000"]) . '</td>'; //COL2
                $mostrarHC .= '<td width="50" align="center" style="font-size:28px;">' . utf8_decode($row[0]["AudiogramaVA_OI1000"]) . '</td>'; //COL3
                $mostrarHC .= '</tr>';
                $mostrarHC .= '<tr>';
                $mostrarHC .= '<td width="100" align="center" style="font-size:28px;"><b>2000</b></td>'; //COL1
                $mostrarHC .= '<td width="50" align="center" style="font-size:28px;">' . utf8_decode($row[0]["AudiogramaVA_OD2000"]) . '</td>'; //COL2
                $mostrarHC .= '<td width="50" align="center" style="font-size:28px;">' . utf8_decode($row[0]["AudiogramaVA_OI2000"]) . '</td>'; //COL3
                $mostrarHC .= '</tr>';
                $mostrarHC .= '<tr>';
                $mostrarHC .= '<td width="100" align="center" style="font-size:28px;"><b>3000</b></td>'; //COL1
                $mostrarHC .= '<td width="50" align="center" style="font-size:28px;">' . utf8_decode($row[0]["AudiogramaVA_OD3000"]) . '</td>'; //COL2
                $mostrarHC .= '<td width="50" align="center" style="font-size:28px;">' . utf8_decode($row[0]["AudiogramaVA_OI3000"]) . '</td>'; //COL3
                $mostrarHC .= '</tr>';
                $mostrarHC .= '<tr>';
                $mostrarHC .= '<td width="100" align="center" style="font-size:28px;"><b>4000</b></td>'; //COL1
                $mostrarHC .= '<td width="50" align="center" style="font-size:28px;">' . utf8_decode($row[0]["AudiogramaVA_OD4000"]) . '</td>'; //COL2
                $mostrarHC .= '<td width="50" align="center" style="font-size:28px;">' . utf8_decode($row[0]["AudiogramaVA_OI4000"]) . '</td>'; //COL3
                $mostrarHC .= '</tr>';
                $mostrarHC .= '<tr>';
                $mostrarHC .= '<td width="100" align="center" style="font-size:28px;"><b>6000</b></td>'; //COL1
                $mostrarHC .= '<td width="50" align="center" style="font-size:28px;">' . utf8_decode($row[0]["AudiogramaVA_OD6000"]) . '</td>'; //COL2
                $mostrarHC .= '<td width="50" align="center" style="font-size:28px;">' . utf8_decode($row[0]["AudiogramaVA_OI6000"]) . '</td>'; //COL3
                $mostrarHC .= '</tr>';
                $mostrarHC .= '<tr>';
                $mostrarHC .= '<td width="100" align="center" style="font-size:28px;"><b>8000</b></td>'; //COL1
                $mostrarHC .= '<td width="50" align="center" style="font-size:28px;">' . utf8_decode($row[0]["AudiogramaVA_OD8000"]) . '</td>'; //COL2
                $mostrarHC .= '<td width="50" align="center" style="font-size:28px;">' . utf8_decode($row[0]["AudiogramaVA_OI8000"]) . '</td>'; //COL3
                $mostrarHC .= '</tr>';
                $mostrarHC .= '<tr>';
                $mostrarHC .= '<td width="100" align="center" style="font-size:28px;"></td>'; //COL1
                $mostrarHC .= '<td width="50" align="center" style="font-size:28px;"></td>'; //COL2
                $mostrarHC .= '<td width="50" align="center" style="font-size:28px;"></td>'; //COL3
                $mostrarHC .= '</tr>';
                
                //$mostrarHC .= '<td width="500" align="left" style="font-size:28px;">'; //COL1
                //$mostrarHC .= '</td>';
                
                $mostrarHC .= '</table>';
                $pdf->writeHTML($mostrarHC, true, false, false, false, '');
                if ($pdf->GetY() >= ($pdf->getPageHeight()-$pControlSalto))
                {
                    EncabezadoPagina($pdf, $row, $i, $rowcount, $contador, $pDesde, $pHasta);
                }
                                                
                $mostrarHC = '<table><tr><td valign="middle" width="500" style="font-size:30px;"><b>TAMIZAJE:</b><br><span style="text-align:justify;">' . utf8_decode($row[$i]["Audiometria"]) .'</span></td>';
                $mostrarHC .= '<td width="20"></td>';
                $mostrarHC .= '<td width="200">';
                if (file_exists('../../../../empresas/' . $_SESSION['ID_EMPRESA']  . '/firmas/' . $row[0]["ProfesionalFonoaudiologia"] . '.png')) {
                    $mostrarHC .= '<img src="../../../../empresas/' . $_SESSION['ID_EMPRESA'] . '/firmas/' . $row[0]["ProfesionalFonoaudiologia"] . '.png" width="100" height="25"/><br>';
                }
                $mostrarHC .= '<span>' . $row[0]['NomProfeFono'] . '</span><br>';
                $mostrarHC .= '<span>' . $row[0]['DocProfeFono'] . '</span><br>';
                $mostrarHC .= '<span>' . $row[0]['RegProfeFono'] . '</span><br>';
                $mostrarHC .= '</td>';
                $mostrarHC .= '</tr>';
                $mostrarHC .= '</table><hr><br>';
                $pdf->writeHTML($mostrarHC, true, false, false, false, '');
                if ($pdf->GetY() >= ($pdf->getPageHeight()-$pControlSalto))
                {
                    EncabezadoPagina($pdf, $row, $i, $rowcount, $contador, $pDesde, $pHasta);
                }
            }
        }
    }
    /*
    $mostrarHC = '<table border="1" style="padding:3px; border-top-width: 0.5px; border-right-width: 0.5px; border-bottom-width: 0.5px; border-left-width: 0.5px;"><tr><td colspan="2" align="center" style="font-size:24px; font-weight:bolder;">CONSENTIMIENTO INFORMADO</td></tr>';
    $mostrarHC .= '<tr><td width="600" style="text-align:justify; font-size:20px; color:#000;">De acuerdo a Resolución 2346 de 2007, modificado por la Resolución 1918 de 2009. Manifiesto he sido informado por parte del Personal asistencial de ' . $_SESSION['NOM_EMPRESA'] . ' a cerca de los exámenes que me van a ser realizados Historia Clínica Ocupacional y/o otros como Ej. Audiometría, Tamizaje visual, Exámenes de Laboratorio (ej. Serología, perfil lipídico, prueba de embarazo, glucometría, cuadro hemático, creatinina, nitrógeno ureico, transaminasas, bilirrubinas, parcial de orina), enfermería, odontología, psicología y promoción de la salud (crecimiento y desarrollo, electrocardiograma, afinamientos) por parte del grupo asistencial de ' . $_SESSION['NOM_EMPRESA'] . ', comprendo y estoy de acuerdo, en consecuencia doy mi consentimiento para la realización de estos y autorizo al personal de ' . $_SESSION['NOM_EMPRESA'] . ' a que proceda con la realización. Autorizo a que se suministre la información necesaria a las personas o entidades contempladas en la legislación para dar cumplimiento al programa de salud ocupacional o aquellas personas según lo contemple la ley o que yo autorice por escrito para la entrega de mis reportes e historia clínica, teniendo en cuenta la reserva de historia clínica que está contemplado en el decreto 1995 de 1999. Además estoy de acuerdo y aseguro que toda la información que he suministrado para la realización de esta historia clínica es verdadera y que no he ocultado información relevante para mi condición de salud.</td>';
    if($_SESSION['IdAplicacion'] == "OfiMedical"){
        $pImgHuella = '../../../../consultoriovirtual/' . $_SESSION['IDBD']  . '/pacientes/' . $pPaciente . '/uploads/huella.gif';
    }else{
       $pImgHuella = '../../../../empresas/' . $_SESSION['ID_EMPRESA']  . '/pacientes/' . $pPaciente . '/uploads/huella.gif'; 
    }
    if (file_exists($pImgHuella)) {
        $mostrarHC .= '<td width="108"><img src="' . $pImgHuella . '" width="90" height="80"></td>';
    }
    $mostrarHC .= '</tr></table>';
    */
    $pdf->writeHTML($mostrarHC, true, false, false, false, '');
    if ($pdf->GetY() >= ($pdf->getPageHeight()-$pControlSalto)){
        EncabezadoPagina($pdf, $row, $i, $rowcount, $contador, $pDesde, $pHasta);
    }
    $pdf->Output('infAudiometria.pdf', 'I');

    function EncabezadoPagina(&$pdf, &$row, &$i, &$rowcount, &$contador, &$pDesde, &$pHasta){
        $pdf->AddPage();
        $pdf->Ln(0.5);
        $img_file = "../../../../empresas/" . $_SESSION['ID_EMPRESA'] . "/logo/fondofac.png";
        $pdf->Image($img_file, $pdf->GetX()+45, $pdf->GetY()+95, 90, 50, '', '', '', false, 300, '', false, false, 0);
        $pdf->SetFont(PDF_FONT_NAME_MAIN, '', 7);
        $styleBarCode['position'] = 'R';
        $pdf->write1DBarcode($row["CAS"] . "-" . $row["ConceptoFinal"], 'EAN13', '', '', '', 5, 0.4, $styleBarCode, 'N');
        $pdf->SetFont(PDF_FONT_NAME_MAIN, '', 7);
        $EncabezadoHTML = '<table cellspacing="0" border="0" style="font-size:24px; color:#000;">';
        $EncabezadoHTML .= '<tr>';
        $EncabezadoHTML .= '<td>';
        $EncabezadoHTML .= '<span style="font-size:44px; color:#000; font-weight:bold">' . utf8_decode($pdf->pNomEmpresa) . '</span><br>';
        if($pdf->pEspEmpresa != null || $pdf->pEspEmpresa != "")
                $EncabezadoHTML .= '<span style="font-size:34px; color:#000;">' . utf8_decode($pdf->pEspEmpresa) . '</span><br>';
        if($pdf->pTDocEmpresa == "NI"){
            $tipodoc = "NIT: ";
            $EncabezadoHTML .= '<span style="font-size:34px; color:#000;">' . $tipodoc . $pdf->pDocEmpresa . '</span><br>';
        }
        $EncabezadoHTML .= '<span style="font-size:34px; color:#000;">Cel: ' . $pdf->pTelEmpresa . '</span><br>';
        $EncabezadoHTML .= '<span style="font-size:34px; color:#000;">' . $pdf->pCiuEmpresa . '</span>';
        $EncabezadoHTML .= '</td>';

        //COL2
        $EncabezadoHTML .= '<td align="right">';
        if (file_exists("../../../../empresas/" . $_SESSION['ID_EMPRESA'] . "/logo/logoenc.gif")) {
            $EncabezadoHTML .= '<img src="../../../../empresas/' . $_SESSION['ID_EMPRESA'] . '/logo/logoenc.gif" align="right"/>';
            $EncabezadoHTML .= '<br>';
        }
        $EncabezadoHTML .= '<span align="rigth" style="font-size:44px; color:#000; font-weight:bold">AUDIOMETRIA</span><br>';
        //$EncabezadoHTML .= '<span align="rigth" style="font-size:26px; color:#000; font-weight:bold">(Resolución 2346 de 2007)</span>';
        if (file_exists('../../../../empresas/' . $_SESSION['ID_EMPRESA']  . '/pacientes/' . $row[$i]["Paciente"] . '/uploads/foto.jpg')) {
            $EncabezadoHTML .= '<br><img src="../../../../empresas/' . $_SESSION['ID_EMPRESA']  . '/pacientes/' . $row[$i]["Paciente"] . '/uploads/foto.jpg" width="130" height="100"/><br>';
        }
        $EncabezadoHTML .= '</td>';
        $EncabezadoHTML .= '</tr>';
        $EncabezadoHTML .= '</table>';
        $pdf->writeHTML($EncabezadoHTML, true, false, false, false, '');
    }

?>