<?php

    set_time_limit(500);
    require_once('../../../lib/tcpdf/config/lang/spa.php');
    require_once('../../../lib/tcpdf/tcpdf.php');
    require("../../../core/php/_database.php");
    require("../../../core/php/php_functions.php");
    header('Content-type: application/pdf; charset: UTF-8');

    session_start();
    $pConsultorioVirtual = $_SESSION['IDBD'];
    $nomEmpresa = $_SESSION['NOM_EMPRESA'];
    $nomUsuario = $_SESSION['NOM_USUARIO'];
    $pEmpresa = isset($_REQUEST['pEmpresa'])?$_REQUEST['pEmpresa']:0;
    $pIPS = isset($_REQUEST['pIPS'])?$_REQUEST['pIPS']:0;
    $pPaciente = isset($_REQUEST['pPaciente'])?$_REQUEST['pPaciente']:0;
    $pCAS = isset($_REQUEST['pCAS'])?$_REQUEST['pCAS']:0;
    $pItems = isset($_REQUEST['pItems'])?$_REQUEST['pItems']:'0';
    $tmp = str_replace("[", "", $pItems);
    $pItems = $tmp;
    $tmp = str_replace("]", "", $pItems);
    $pItems = $tmp;
    $tmp = str_replace("\"", "", $pItems);
    $pItems = $tmp;
    $data = explode(",", $pItems);
    
    //Definicion de las Margenes
    $LeftMargin = PDF_MARGIN_LEFT;
    $TopMargin = 5;
    $RightMargin = PDF_MARGIN_RIGHT;
    $HeaderMargin = PDF_MARGIN_HEADER;
    $BottomMargin = 3;
    $FooterMargin = 5;
    $Alineacion = "L";
    $FormatoPagina = "MEDIACARTA";
    $UsaPiePagina = "NO";
    $pTipoEncabezado = "FVP";
    $pControlSalto = 10;

    //Inicializacion de la Clase
    $pdf = new TCPDF($Alineacion, PDF_UNIT, $FormatoPagina, true, 'UTF-8', false);
    //Inicializacion Variables de Control
    $pdf->pAlineacionEncabezado = $Alineacion;
    $pdf->pTituloInforme = "ORDENAMIENTOS";
    $pdf->pImprimeLogo = "NO";
    $pdf->pAnchoTxtPagina = 210;
    $pdf->pNomEmpresa = $_SESSION['NOM_EMPRESA'];
    $pdf->pTDocEmpresa = $_SESSION['EMPRESA_TDOC'];
    $pdf->pDocEmpresa = $_SESSION['EMPRESA_DOC'];
    $pdf->pDirEmpresa = $_SESSION['EMPRESA_DIR'];
    $pdf->pTelEmpresa = $_SESSION['EMPRESA_TEL'];
    $pdf->pCiuEmpresa = $_SESSION['EMPRESA_CIU'];
    $pdf->pEspEmpresa = $_SESSION['EMPRESA_ESP'];
    $pdf->pRegEmpresa = $_SESSION['EMPRESA_REGIMEN'];
    $pdf->pContribuyentes = $_SESSION['EMPRESA_CONTRIBUYENTE'];
    $pdf->pReteIVA  = $_SESSION['EMPRESA_RTEICA'];
    $pdf->pReteICA = $_SESSION['EMPRESA_RTEIVA'];
    $pdf->pTipoEncabezado = $pTipoEncabezado;
    $pdf->pNomSede = $_SESSION['EMPRESA_DOC'];
    $pdf->pNomIPS = $_SESSION['NOM_IPS'];
    $pdf->pMargenPie = -20;
    if($_SESSION['IdAplicacion'] == "OfiMedical"){
        $pdf->pLogoCliente = "../../../consultoriovirtual/" . $_SESSION['IDBD'] . "/logo/logoordexa.png";
    }else{
        $pdf->pLogoCliente = "../../../empresas/" . $_SESSION['ID_EMPRESA'] . "/logo/logoordexa.png";
    }
    $pdf->pPrefijo = 1; //$row[0]["Prefijo"];
    $pdf->pNroDocumento = 1; //str_pad($row[0]["NroDocumento"], 7, "0", STR_PAD_LEFT);
    $pdf->pNroResolucion = 1; //$row[0]["NroResolucion"];
    $pdf->pFechaDoc = 1; //$row[0]["FechaDocumento"];
    $pdf->pCAS = null;
    $pdf->pTratamiento = null;
    $pdf->pUsaPie = $UsaPiePagina;

    $pdf->SetCreator(PDF_CREATOR);
    $pdf->SetAuthor('Sistemas Ofisalud © - 2011');
    $pdf->SetTitle('Ofimedical©');
    $pdf->SetSubject('Ordenamientos');

    $pdf->SetHeaderData($pdf->pLogoCliente, PDF_HEADER_LOGO_WIDTH, $pdf->pTituloInforme, PDF_HEADER_STRING);
    $pdf->setHeaderFont(Array(PDF_FONT_NAME_MAIN, '', PDF_FONT_SIZE_MAIN));
    $pdf->setFooterFont(Array(PDF_FONT_NAME_DATA, '', PDF_FONT_SIZE_DATA));
    $pdf->SetDefaultMonospacedFont(PDF_FONT_MONOSPACED);
    $pdf->SetMargins($LeftMargin, $TopMargin, $RightMargin);
    $pdf->SetHeaderMargin($HeaderMargin);
    $pdf->SetFooterMargin($FooterMargin);
    // set bacground image
    $pdf->SetAutoPageBreak(TRUE, $BottomMargin);
    $pdf->setImageScale(PDF_IMAGE_SCALE_RATIO);
    $pdf->setLanguageArray($l);
    $pdf->setFontSubsetting(true);
    $pdf->SetFont('dejavusans', '', 14, '', true);

    for ($j = 0; ($j < count($data)); $j++) {
        unset($row);
        $gBaseDatos = new ofiMySQLi();
        $gBaseDatos->conectar();
        //$qry = "CALL sp_ecopetrol_printhc_ordenes_exa('" . $pEmpresa . "','" . $pIPS . "','" . $pPaciente . "','" . $pCAS . "','" . $pConsecutivoDetalle . "')";
        $qry = "CALL sp_ecopetrol_printhc_ordenes_exaitem('" . $pEmpresa . "','" . $pIPS . "','" . $pPaciente . "','" . $pCAS . "','" . $data[$j] . "')";
        //echo $qry;
        $gBaseDatos->QryID = @mysqli_query($gBaseDatos->ConexionID, $qry);
        while ($row[] = @mysqli_fetch_assoc($gBaseDatos->QryID));
        $gBaseDatos->liberar();
        $gBaseDatos->cerrar();
        $pRegistros = count($row);
        //EncabezadoPagina($pdf, $row, $i, $rowcount, $contador, $pDesde, $pHasta, "SI");
        //$pdf->writeHTMLCell(230, 6, '', '', $qry, 0, 0, 0, true, 'L', true);
        
        $ContadorFilas = 0;
        for($i=0;$i<$pRegistros;$i++){
            if($row[$i]["nomPaciente"] != ""){
                if ($row[$i]["GrupoImpresion"] != $idGrupo){
                    EncabezadoPagina($pdf, $row, $i, $rowcount, $contador, $pDesde, $pHasta, "SI");
                    $ContadorFilas = 0;
                    $pie = $row[$i]["GrupoImpresion"];
                    $pdf->Ln(-4);
                }
                $ContadorFilas ++;
                $pdf->SetFont(PDF_FONT_NAME_MAIN, '', 8);
                $pdf->Ln();
                $pdf->writeHTMLCell(30, 6, '', '', utf8_decode($row[$i]["CodProced"]) . " - " . utf8_decode($row[$i]["CUPSCodigo"]), 0, 0, 0, true, 'L', true);
                //$pdf->writeHTMLCell(160, 6, '', '', substr(utf8_decode($row[$i]["descConcepto"]), 0, 93), 0, 0, 0, true, 'L', true);
                $infoConcepto = "";
                $infoConcepto = utf8_decode($row[$i]["descConcepto"]);
                if(utf8_decode($row[$i]["notasProveedor"]) != "" && utf8_decode($row[$i]["notasProveedor"]) != null){
                    $infoConcepto .= " - (" . utf8_decode($row[$i]["notasProveedor"]) . ")";
                }
                $pdf->writeHTMLCell(160, 6, '', '', substr($infoConcepto, 0, 93), 0, 0, 0, true, 'L', true);
                if ($ContadorFilas > 7){
                    $pdf->Ln();
                    $mostrarHTML = '<table width="710" cellpadding="5" cellspacing="0" border="0" style="border-style: solid; border-top-width: 1px; border-right-width: 1px; border-bottom-width: 1px; border-left-width: 1px; font-size:24px; color:#000;">';
                    $mostrarHTML .= '<tr>';
                    $mostrarHTML .= '<td width="100">';
                    $mostrarHTML .= '<span align="center" style="font-size:25px;"><b>TOTAL</b></span>';
                    $mostrarHTML .= '</td>';
                    $mostrarHTML .= '<td width="460">';
                    $mostrarHTML .= '<span align="center" style="font-size:25px;"><b>N° SERVICIOS/ SUMINISTROS:&nbsp;</b>' . $ContadorFilas . '</span>';
                    $mostrarHTML .= '</td>';
                    $mostrarHTML .= '<td width="150"></td>';
                    $mostrarHTML .= '</tr>';
                    $mostrarHTML .= '</table>';
                    $pdf->writeHTML($mostrarHTML, true, false, false, false, '');
                    $pdf->Ln(-3.5);
                    $mostrarHTML = '<table width="710" cellpadding="5" cellspacing="0" border="0" style="border-style: solid; border-top-width: 1px; border-right-width: 1px; border-bottom-width: 1px; border-left-width: 1px; font-size:24px; color:#000;">';
                    $mostrarHTML .= '<tr>';
                    $mostrarHTML .= '<td colspan="3">';
                    $mostrarHTML .= '<span align="left" style="font-size:25px;"><b>OBSERVACIONES:</b></span>';
                    $mostrarHTML .= '</td>';
                    $mostrarHTML .= '</tr>';
                    $mostrarHTML .= '</table>';
                    $pdf->writeHTML($mostrarHTML, true, false, false, false, '');
                    $pdf->Ln(-3.5);
                    $mostrarHTML = '<table width="710" cellpadding="5" cellspacing="0" border="0" style="border-style: solid; border-top-width: 1px; border-right-width: 1px; border-bottom-width: 1px; border-left-width: 1px; font-size:24px; color:#000;">';
                    $mostrarHTML .= '<tr>';
                    $mostrarHTML .= '<td width="340">';
                    if($_SESSION['IdAplicacion'] == "OfiMedical"){
                        if (file_exists('../../../consultoriovirtual/' . $_SESSION['IDBD']  . '/firmas/' . $row[0]["Profesional"] . '.png')) {
                            $mostrarHTML .= '<img src="../../../consultoriovirtual/' . $_SESSION['IDBD'] . '/firmas/' . $row[0]["Profesional"] . '.png" width="190" height="35"/>';
                        }
                    }else{
                        if (file_exists('../../../empresas/' . $_SESSION['ID_EMPRESA']  . '/firmas/' . $row[0]["Profesional"] . '.png')) {
                            $mostrarHTML .= '<img src="../../../empresas/' . $_SESSION['ID_EMPRESA'] . '/firmas/' . $row[0]["Profesional"] . '.png" width="190" height="35"/>';
                        } 
                    }
                    $mostrarHTML .= '<br>FIRMA AUTORIZADA';
                    $mostrarHTML .= '</td>';
                    $mostrarHTML .= '<td width="30"></td>';
                    $mostrarHTML .= '<td width="340">';
                    $mostrarHTML .= '<br><br><br><br><hr>FIRMA PACIENTE';
                    $mostrarHTML .= '</td>';
                    $mostrarHTML .= '</tr>';
                    $mostrarHTML .= '</table>';
                    $pdf->writeHTML($mostrarHTML, true, false, false, false, '');
                    $ContadorFilas = 0;
                    EncabezadoPagina($pdf, $row, $i, $rowcount, $contador, $pDesde, $pHasta, "SI");
                    $pie = $row[$i]["GrupoImpresion"];
                    $pdf->Ln(-4);
                }else{
                    if ($row[$i+1]["GrupoImpresion"] != $pie){
                        for($k=$ContadorFilas;$k<8;$k++){
                            //$ContadorFilas ++;
                            $pdf->SetFont(PDF_FONT_NAME_MAIN, '', 8);
                            $pdf->Ln();
                            $pdf->writeHTMLCell(30, 6, '', '',"&nbsp;", 0, 0, 0, true, 'L', true);
                            $pdf->writeHTMLCell(160, 6, '', '', "&nbsp;", 0, 0, 0, true, 'L', true);
                        }
                        $pdf->Ln();
                        $mostrarHTML = '<table width="710" cellpadding="5" cellspacing="0" border="0" style="border-style: solid; border-top-width: 1px; border-right-width: 1px; border-bottom-width: 1px; border-left-width: 1px; font-size:24px; color:#000;">';
                        $mostrarHTML .= '<tr>';
                        $mostrarHTML .= '<td width="100">';
                        $mostrarHTML .= '<span align="center" style="font-size:25px;"><b>TOTAL</b></span>';
                        $mostrarHTML .= '</td>';
                        $mostrarHTML .= '<td width="460">';
                        $mostrarHTML .= '<span align="center" style="font-size:25px;"><b>N° SERVICIOS/ SUMINISTROS:&nbsp;</b>' . $ContadorFilas . '</span>';
                        $mostrarHTML .= '</td>';
                        $mostrarHTML .= '<td width="150"></td>';
                        $mostrarHTML .= '</tr>';
                        $mostrarHTML .= '</table>';
                        $pdf->writeHTML($mostrarHTML, true, false, false, false, '');
                        $pdf->Ln(-3.5);
                        $mostrarHTML = '<table width="710" cellpadding="5" cellspacing="0" border="0" style="border-style: solid; border-top-width: 1px; border-right-width: 1px; border-bottom-width: 1px; border-left-width: 1px; font-size:24px; color:#000;">';
                        $mostrarHTML .= '<tr>';
                        $mostrarHTML .= '<td colspan="3">';
                        $mostrarHTML .= '<span align="left" style="font-size:25px;"><b>OBSERVACIONES:</b></span>';
                        $mostrarHTML .= '</td>';
                        $mostrarHTML .= '</tr>';
                        $mostrarHTML .= '</table>';
                        $pdf->writeHTML($mostrarHTML, true, false, false, false, '');
                        $pdf->Ln(-3.5);
                        $mostrarHTML = '<table width="710" cellpadding="5" cellspacing="0" border="0" style="border-style: solid; border-top-width: 1px; border-right-width: 1px; border-bottom-width: 1px; border-left-width: 1px; font-size:24px; color:#000;">';
                        $mostrarHTML .= '<tr>';
                        $mostrarHTML .= '<td width="340">';
                        if($_SESSION['IdAplicacion'] == "OfiMedical"){
                            if (file_exists('../../../consultoriovirtual/' . $_SESSION['IDBD']  . '/firmas/' . $row[0]["Profesional"] . '.png')) {
                                $mostrarHTML .= '<img src="../../../consultoriovirtual/' . $_SESSION['IDBD'] . '/firmas/' . $row[0]["Profesional"] . '.png" width="190" height="35"/>';
                            }
                        }else{
                            if (file_exists('../../../empresas/' . $_SESSION['ID_EMPRESA']  . '/firmas/' . $row[0]["Profesional"] . '.png')) {
                                $mostrarHTML .= '<img src="../../../empresas/' . $_SESSION['ID_EMPRESA'] . '/firmas/' . $row[0]["Profesional"] . '.png" width="190" height="35"/>';
                            } 
                        }
                        $mostrarHTML .= '<br>FIRMA AUTORIZADA';
                        $mostrarHTML .= '</td>';
                        $mostrarHTML .= '<td width="30"></td>';
                        $mostrarHTML .= '<td width="340">';
                        $mostrarHTML .= '<br><br><br><br><hr>FIRMA PACIENTE';
                        $mostrarHTML .= '</td>';
                        $mostrarHTML .= '</tr>';
                        $mostrarHTML .= '</table>';
                        $pdf->writeHTML($mostrarHTML, true, false, false, false, '');
                    }
                }
                $idGrupo = $row[$i]["GrupoImpresion"];
            }
        }
    }
    $pdf->Output('infOrdenamientos.pdf', 'I');
    

    function EncabezadoPagina(&$pdf, &$row, &$i, &$rowcount, &$contador, &$pDesde, &$pHasta, $pNuevo="SI"){
        if($pNuevo == "SI"){
            $pdf->AddPage();
        }
        $pdf->SetFont(PDF_FONT_NAME_MAIN, '', 9);
        $EncabezadoHTML = '<table cellpadding="5" cellspacing="0" border="1" style="font-size:24px; color:#000;">';
        $EncabezadoHTML .= '<tr>';
        $EncabezadoHTML .= '<td width="100"><span align="center" valign="center">';
        if($_SESSION['IdAplicacion'] == "OfiMedical"){
            if (file_exists("../../../consultoriovirtual/" . $_SESSION['IDBD'] . "/logo/logoordexa.png")) {
                $EncabezadoHTML .= '<img src="../../../consultoriovirtual/' . $_SESSION['IDBD'] . '/logo/logoordexa.png" align="center"/>';
                $EncabezadoHTML .= '<br>';
            }
        }else{
            if (file_exists("../../../empresas/" . $_SESSION['ID_EMPRESA'] . "/logo/logoordexa.png")) {
                $EncabezadoHTML .= '<img src="../../../empresas/' . $_SESSION['ID_EMPRESA'] . '/logo/logoordexa.png" align="center"/>';
                $EncabezadoHTML .= '<br>';
            }
        }
        $EncabezadoHTML .= '</span></td>';
        $EncabezadoHTML .= '<td width="460">';
        $EncabezadoHTML .= '<span align="center" style="font-size:44px; color:#000; font-weight:bold">UNIDAD DE SERVICIOS DE SALUD</span><br>';
        $EncabezadoHTML .= '<span align="center" style="font-size:40px; color:#000; font-weight:bold">FORMATO DE DECISIONES CLINICAS</span><br>';
        $EncabezadoHTML .= '</td>';
        $EncabezadoHTML .= '<td align="center" width="150">';
        $EncabezadoHTML .= '<b>ORDEN DE SERVICIO</b>';
        $EncabezadoHTML .= '<br><br>' . $row[$i]["CAS"] . '<br>';
        $EncabezadoHTML .= '</td>';
        $EncabezadoHTML .= '</tr>';
        $EncabezadoHTML .= '<tr>';
        $EncabezadoHTML .= '<td width="560" colspan="2">';
        $EncabezadoHTML .= '<span style="font-size:30px;"><b>PACIENTE:&nbsp;</b>' . utf8_decode($row[$i]["TipDoc"]) . ' ' . utf8_decode($row[$i]["Documento"]) . ' - ' . utf8_decode($row[$i]["Nom1"]) . ' ' . utf8_decode($row[$i]["Nom2"]) . ' ' . utf8_decode($row[$i]["Ape1"]) . ' ' . utf8_decode($row[$i]["Ape2"]) . '</span><br>';
        if (utf8_decode($row[$i]["Genero"]) == "M"){
            $EncabezadoHTML .= '<span style="font-size:30px; color:#000;"><b>GENERO:&nbsp;&nbsp;</b>&nbsp;&nbsp;MASCULINO&nbsp;&nbsp;&nbsp;&nbsp;<b>FECHA NACIMIENTO:&nbsp;&nbsp;&nbsp;&nbsp;</b>' . $row[$i]["FecNac"] . '</span>';
        }else{
            $EncabezadoHTML .= '<span style="font-size:30px; color:#000;"><b>GENERO:&nbsp;&nbsp;</b>FEMENINO&nbsp;&nbsp;&nbsp;&nbsp;<b>FECHA NACIMIENTO:&nbsp;&nbsp;</b>' . $row[$i]["FecNac"] . '</span>';
        }
        $EncabezadoHTML .= '</td>';
        $EncabezadoHTML .= '<td width="150">';
        $EncabezadoHTML .= '<span style="font-size:30px;"><b>N° HISTORIA:&nbsp;</b><br>' . utf8_decode($row[$i]["Documento"]) . '</span>';
        $EncabezadoHTML .= '</td>';
        $EncabezadoHTML .= '</tr>';
        $EncabezadoHTML .= '<tr>';
        $EncabezadoHTML .= '<td width="560" colspan="2">';
        $EncabezadoHTML .= '<span style="font-size:30px;"><b>REMITIDO POR:&nbsp;</b>' . utf8_decode($row[0]["NomProfesional"]) . '</span>';
        $EncabezadoHTML .= '</td>';
        $EncabezadoHTML .= '<td width="150">';
        $EncabezadoHTML .= '<span style="font-size:30px;"><b>FECHA:&nbsp;</b>' . utf8_decode($row[$i]["Fecha"]) . '</span>';
        $EncabezadoHTML .= '</td>';
        $EncabezadoHTML .= '</tr>';
        $EncabezadoHTML .= '<tr>';
        $EncabezadoHTML .= '<td width="300">';
        $EncabezadoHTML .= '<span style="font-size:30px;"><b>REMITIDO A:&nbsp;</b></span>';
        $EncabezadoHTML .= '</td>';
        $EncabezadoHTML .= '<td width="260">';
        $EncabezadoHTML .= '<span style="font-size:18px;"><b>DIRECCION:&nbsp;</b></span>';
        $EncabezadoHTML .= '</td>';
        $EncabezadoHTML .= '<td width="150">';
        $EncabezadoHTML .= '<span style="font-size:18px;"><b>TELEFONO:&nbsp;</b></span>';
        $EncabezadoHTML .= '</td>';
        $EncabezadoHTML .= '</tr>';
        $EncabezadoHTML .= '</table>';
        $pdf->writeHTML($EncabezadoHTML, true, false, false, false, '');
        $pdf->Ln(-4);
        $EncabezadoHTML = '<table width="710" cellpadding="5" cellspacing="0" border="0" style="border-style: solid; border-top-width: 1px; border-right-width: 1px; border-bottom-width: 1px; border-left-width: 1px; font-size:24px; color:#000;">';
        $EncabezadoHTML .= '<tr>';
        $EncabezadoHTML .= '<td colspan="3">';
        $EncabezadoHTML .= '<span align="center" style="font-size:22px;">ATENTAMENTE SOLICITAMOS A USTED PRECTICAR A NUESTRO PACIENTE EL SERVICIO / SUMINISTRO</span>';
        $EncabezadoHTML .= '</td>';
        $EncabezadoHTML .= '</tr>';
        $EncabezadoHTML .= '<tr>';
        $EncabezadoHTML .= '<td width="100">';
        $EncabezadoHTML .= '<span align="center" style="font-size:30px;"><b>CODIGO</b></span>';
        $EncabezadoHTML .= '</td>';
        $EncabezadoHTML .= '<td width="460">';
        $EncabezadoHTML .= '<span align="center" style="font-size:30px;"><b>DESCRIPCION</b></span>';
        $EncabezadoHTML .= '</td>';
        $EncabezadoHTML .= '<td width="150">';
        $EncabezadoHTML .= '<span align="rigth" style="font-size:30px;"><b>VALOR</b></span>';
        $EncabezadoHTML .= '</td>';
        $EncabezadoHTML .= '</tr>';
        $EncabezadoHTML .= '</table>';
        $pdf->writeHTML($EncabezadoHTML, true, false, false, false, '');
    }
?>