<?php

set_time_limit(500);
require_once('../../../lib/tcpdf/config/lang/spa.php');
require_once('../../../lib/tcpdf/tcpdf.php');
require("../../../core/php/_database.php");
require("../../../core/php/php_functions.php");
header('Content-type: application/pdf; charset: UTF-8');

    session_start();
    $pConsultorioVirtual = $_SESSION['IDBD'];
    $nomEmpresa = $_SESSION['NOM_EMPRESA'];
    $nomUsuario = $_SESSION['NOM_USUARIO'];
    $pEmpresa = isset($_REQUEST['pEmpresa'])?$_REQUEST['pEmpresa']:0;
    $pIPS = isset($_REQUEST['pIPS'])?$_REQUEST['pIPS']:0;
    $pPaciente = isset($_REQUEST['pPaciente'])?$_REQUEST['pPaciente']:0;
    $pCAS = isset($_REQUEST['pCAS'])?$_REQUEST['pCAS']:0;
    $pConsecutivoDetalle = isset($_REQUEST['pConsecutivoDetalle'])?$_REQUEST['pConsecutivoDetalle']:0;
    
    $gBaseDatos = new ofiMySQLi();
    $gBaseDatos->conectar();
    if($pConsecutivoDetalle != 0){
        $qry = "CALL sp_asistencial_printhc_ordenes_ofimedical002('" . $pEmpresa . "','" . $pIPS . "','" . $pPaciente . "','" . $pCAS . "','" . $pConsecutivoDetalle . "')";
    }else{
        $qry = "CALL sp_asistencial_printhc_ordenes_ofimedical('" . $pEmpresa . "','" . $pIPS . "','" . $pPaciente . "','" . $pCAS . "')";
    }
    
    $gBaseDatos->QryID = @mysqli_query($gBaseDatos->ConexionID, $qry);
    while ($row[] = @mysqli_fetch_assoc($gBaseDatos->QryID));
    $gBaseDatos->liberar();
    $gBaseDatos->cerrar();
    $pRegistros = count($row);
    if($_SESSION['IMPRIME_ORD_TIRILLA']==0){
        //Definicion de las Margenes
        $LeftMargin = PDF_MARGIN_LEFT;
        $TopMargin = 5;
        $RightMargin = PDF_MARGIN_RIGHT;
        $HeaderMargin = PDF_MARGIN_HEADER;
        $BottomMargin = 3;
        $FooterMargin = 5;
        $Alineacion = "L";
        $FormatoPagina = "MEDIACARTA";
        $UsaPiePagina = "SI";
        $pTipoEncabezado = "FVP";
        $pControlSalto = 40;

        //Inicializacion de la Clase
        $pdf = new TCPDF($Alineacion, PDF_UNIT, $FormatoPagina, true, 'UTF-8', false);
        //Inicializacion Variables de Control
        $pdf->pAlineacionEncabezado = $Alineacion;
        $pdf->pTituloInforme = "ORDENAMIENTOS - AUTORIZACIONES";
        $pdf->pImprimeLogo = "NO";
        $pdf->pAnchoTxtPagina = 210;
        $pdf->pNomEmpresa = $_SESSION['NOM_EMPRESA'];
        $pdf->pTDocEmpresa = $_SESSION['EMPRESA_TDOC'];
        $pdf->pDocEmpresa = $_SESSION['EMPRESA_DOC'];
        $pdf->pDirEmpresa = $_SESSION['EMPRESA_DIR'];
        $pdf->pTelEmpresa = $_SESSION['EMPRESA_TEL'];
        $pdf->pCiuEmpresa = $_SESSION['EMPRESA_CIU'];
        $pdf->pEspEmpresa = $_SESSION['EMPRESA_ESP'];
        $pdf->pRegEmpresa = $_SESSION['EMPRESA_REGIMEN'];
        $pdf->pContribuyentes = $_SESSION['EMPRESA_CONTRIBUYENTE'];
        $pdf->pReteIVA  = $_SESSION['EMPRESA_RTEICA'];
        $pdf->pReteICA = $_SESSION['EMPRESA_RTEIVA'];

        $pdf->pTipoEncabezado = $pTipoEncabezado;
        $pdf->pNomSede = $_SESSION['EMPRESA_DOC'];
        $pdf->pNomIPS = $_SESSION['NOM_IPS'];
        $pdf->pMargenPie = -20;
        if($_SESSION['IdAplicacion'] == "OfiMedical"){
            $pdf->pLogoCliente = "../../../consultoriovirtual/" . $_SESSION['IDBD'] . "/logo/logoenc.gif";
        }else{
            $pdf->pLogoCliente = "../../../empresas/" . $_SESSION['ID_EMPRESA'] . "/logo/logoenc.gif";
        }
        $pdf->pPrefijo = 1; //$row[0]["Prefijo"];
        $pdf->pNroDocumento = 1; //str_pad($row[0]["NroDocumento"], 7, "0", STR_PAD_LEFT);
        $pdf->pNroResolucion = 1; //$row[0]["NroResolucion"];
        $pdf->pFechaDoc = 1; //$row[0]["FechaDocumento"];
        $pdf->pCAS = null;
        $pdf->pTratamiento = null;
        $pdf->pUsaPie = $UsaPiePagina;

        $pdf->SetCreator(PDF_CREATOR);
        $pdf->SetAuthor('Sistemas Ofisalud © - 2011');
        $pdf->SetTitle('Ofimedical©');
        $pdf->SetSubject('Ordenamientos');

        $pdf->SetHeaderData($pdf->pLogoCliente, PDF_HEADER_LOGO_WIDTH, $pdf->pTituloInforme, PDF_HEADER_STRING);
        $pdf->setHeaderFont(Array(PDF_FONT_NAME_MAIN, '', PDF_FONT_SIZE_MAIN));
        $pdf->setFooterFont(Array(PDF_FONT_NAME_DATA, '', PDF_FONT_SIZE_DATA));
        $pdf->SetDefaultMonospacedFont(PDF_FONT_MONOSPACED);
        $pdf->SetMargins($LeftMargin, $TopMargin, $RightMargin);
        $pdf->SetHeaderMargin($HeaderMargin);
        $pdf->SetFooterMargin($FooterMargin);
        // set bacground image
        $pdf->SetAutoPageBreak(TRUE, $BottomMargin);
        $pdf->setImageScale(PDF_IMAGE_SCALE_RATIO);
        $pdf->setLanguageArray($l);
        $pdf->setFontSubsetting(true);
        
        $pdf->SetFont('dejavusans', '', 14, '', true);
        $idFecSolicitud = "";
        $idGrupo = "";
        
        //$pdf->AddPage();
        //$pdf->writeHTML($qry, true, false, false, false, '');
        
        for($i=0;$i<$pRegistros;$i++){
            if($row[$i]["nomPaciente"] != ""){
                if($row[$i]["Origen"] == "SOLICITUD"){
                    imprimeSolicitud($pdf, $row, $i, $idFecSolicitud, $idGrupo, $pRegistros, $pControlSalto);
                }else{
                    imprimeAutorizacion($pdf, $row, $i, $idFecSolicitud, $idGrupo, $pRegistros, $pControlSalto);
                }
            }
        }
        $pdf->Output('infOrdenamientos.pdf', 'I');
    }else{
        $FormatoPagina = "TIRILLA";
        //Definicion de las Margenes
        $LeftMargin = 1;
        $TopMargin = 5; //Este Margen es para empezar nueva pagina
        $RightMargin = 1;
        $HeaderMargin = 0.5;
        $BottomMargin = 1;
        $FooterMargin = 3.5;
        $Alineacion = "P";
        $UsaPiePagina = "NO";
        $pTipoEncabezado = "FVP";
        $pControlSalto = 0;

        //Inicializacion de la Clase
        $pdf = new TCPDF($Alineacion, PDF_UNIT, $FormatoPagina, true, 'UTF-8', false);
        //Inicializacion Variables de Control
        $pdf->pAlineacionEncabezado = $Alineacion;
        $pdf->pTituloInforme = "ORDENAMIENTOS";
        $pdf->pImprimeLogo = "NO";
        $pdf->pAnchoTxtPagina = 210;
        $pdf->pNomEmpresa = $_SESSION['NOM_EMPRESA'];
        $pdf->pTDocEmpresa = $_SESSION['EMPRESA_TDOC'];
        $pdf->pDocEmpresa = $_SESSION['EMPRESA_DOC'];
        $pdf->pDirEmpresa = $_SESSION['EMPRESA_DIR'];
        $pdf->pTelEmpresa = $_SESSION['EMPRESA_TEL'];
        $pdf->pCiuEmpresa = $_SESSION['EMPRESA_CIU'];
        $pdf->pEspEmpresa = $_SESSION['EMPRESA_ESP'];
        $pdf->pRegEmpresa = $_SESSION['EMPRESA_REGIMEN'];
        $pdf->pContribuyentes = $_SESSION['EMPRESA_CONTRIBUYENTE'];
        $pdf->pReteIVA  = $_SESSION['EMPRESA_RTEICA'];
        $pdf->pReteICA = $_SESSION['EMPRESA_RTEIVA'];

        $pdf->pTipoEncabezado = $pTipoEncabezado;
        $pdf->pNomSede = $_SESSION['EMPRESA_DOC'];
        $pdf->pNomIPS = $_SESSION['NOM_IPS'];
        $pdf->pMargenPie = -20;
        if($_SESSION['IdAplicacion'] == "OfiMedical"){
            $pdf->pLogoCliente = "../../../consultoriovirtual/" . $_SESSION['IDBD'] . "/logo/logoenc.gif";
        }else{
            $pdf->pLogoCliente = "../../../empresas/" . $_SESSION['ID_EMPRESA'] . "/logo/logoenc.gif";
        }
        $pdf->pPrefijo = 1; //$row[0]["Prefijo"];
        $pdf->pNroDocumento = 1; //str_pad($row[0]["NroDocumento"], 7, "0", STR_PAD_LEFT);
        $pdf->pNroResolucion = 1; //$row[0]["NroResolucion"];
        $pdf->pFechaDoc = 1; //$row[0]["FechaDocumento"];
        $pdf->pCAS = null;
        $pdf->pTratamiento = null;
        $pdf->pUsaPie = $UsaPiePagina;

        $pdf->SetCreator(PDF_CREATOR);
        $pdf->SetAuthor('Sistemas Ofisalud © - 2011');
        $pdf->SetTitle('OfiClinic©');
        $pdf->SetSubject('Ordenamientos');

        $pdf->SetHeaderData($pdf->pLogoCliente, PDF_HEADER_LOGO_WIDTH, $pdf->pTituloInforme, PDF_HEADER_STRING);
        $pdf->setHeaderFont(Array(PDF_FONT_NAME_MAIN, '', PDF_FONT_SIZE_MAIN));
        $pdf->setFooterFont(Array(PDF_FONT_NAME_DATA, '', PDF_FONT_SIZE_DATA));
        $pdf->SetDefaultMonospacedFont(PDF_FONT_MONOSPACED);
        $pdf->SetMargins($LeftMargin, $TopMargin, $RightMargin);
        $pdf->SetHeaderMargin($HeaderMargin);
        $pdf->SetFooterMargin($FooterMargin);
        // set bacground image

        $pdf->SetAutoPageBreak(TRUE, $BottomMargin);
        $pdf->setImageScale(PDF_IMAGE_SCALE_RATIO);
        $pdf->setLanguageArray($l);
        $pdf->setFontSubsetting(true);
        $pdf->SetFont('helvetica', 'B', 14);
        for($i=0;$i<$pRegistros;$i++){
            if($row[$i]["nomPaciente"] != ""){
                if ($row[$i]["grupoConcepto"] != $idGrupo){
                    $pdf->AddPage();
                    $mostrarHC = '<table cellspacing="0" border="0" style="font-size:22px; color:#000;">';
                    $mostrarHC .= '<tr>';
                    $mostrarHC .= '<td>';
                    $mostrarHC .= '<span style="font-size:36px; color:#000;">' . utf8_decode($pdf->pNomEmpresa) . '</span><br>';
                    if($pdf->pEspEmpresa != null || $pdf->pEspEmpresa != "")
                            $mostrarHC .= '<span style="font-size:33px; color:#000;">' . utf8_decode($pdf->pEspEmpresa) . '</span><br>';
                    if($pdf->pTDocEmpresa == "NI"){
                        $tipodoc = "NIT: ";
                        $mostrarHC .= '<span style="font-size:30px; color:#000;">' . $tipodoc . $pdf->pDocEmpresa . '</span><br>';
                    }
                    $mostrarHC .= '<span style="font-size:30px; color:#000;">' . $pdf->pDirEmpresa . ' - Tel: ' . $pdf->pTelEmpresa . '</span><br>';
                    $mostrarHC .= '<span style="font-size:30px; color:#000;">' . $pdf->pCiuEmpresa . '</span><br>';
                    $mostrarHC .= '<hr class="linea">';
                    $mostrarHC .= '<span align="center" style="font-size:44px; color:#000;">ORDENAMIENTOS</span><br>';
                    $mostrarHC .= '<span align="center" style="font-size:44px; color:#000;">' . $row[$i]["grupoConcepto"] . '</span><br>';
        
                    $mostrarHC .= '<span align="center" style="font-size:36px; color:#000;">Nro. ' . utf8_decode($row[0]["CAS"]) . '</span><br>';

                    $mostrarHC .= '<hr class="linea">';
                    $mostrarHC .= '<span style="font-size:34px; color:#000;">PACIENTE:&nbsp;&nbsp;' . utf8_decode($row[0]["TipDoc"]) . ' ' . utf8_decode($row[0]["Documento"]) . ' - ' . utf8_decode($row[0]["Nom1"]) . ' ' . utf8_decode($row[0]["Nom2"]) . ' ' . utf8_decode($row[0]["Ape1"]) . ' ' . utf8_decode($row[0]["Ape2"]) . '</span><br>';
                    if (utf8_decode($row[0]["Genero"]) == "M")
                        $mostrarHC .= '<span style="font-size:34px; color:#000;">GENERO:&nbsp;&nbsp;&nbsp;MASCULINO</span><br>';
                    else
                        $mostrarHC .= '<span style="font-size:34px; color:#000;">GENERO:&nbsp;FEMENINO</span><br>';

                    $mostrarHC .= '<span style="font-size:34px; color:#000;">FECHA NACIMIENTO:&nbsp;' . $row[0]["FecNac"] . '</span>';
                    $mostrarHC .= '<hr class="linea">';
                    $mostrarHC .= '<span style="font-size:34px; color:#000;">Entidad: ' . utf8_decode($row[0]["Cliente"]) . '</span><br>';
                    $mostrarHC .= '<span style="font-size:34px; color:#000;">Profesional: ' . utf8_decode($row[0]["NomProfesional"]) . '</span><br><br>';
                    $mostrarHC .= '<span style="font-size:34px; color:#000;">Fecha: ' . utf8_decode($row[0]["Fecha"]) . '</span><br>';
                    $mostrarHC .= '<span style="font-size:34px; color:#000;">CAS: ' . utf8_decode($row[0]["CAS"]) . '</span><br>';
                    $mostrarHC .= '<span style="font-size:34px; color:#000;">Diagnosticos: ' . utf8_decode($row[0]["Diagppal"]) . ' - ' . utf8_decode($row[0]["Diagrel1"]) . ' - ' . utf8_decode($row[0]["Diagrel2"])  . ' - ' . utf8_decode($row[0]["Diagrel3"]) . '</span>';
                    $mostrarHC .= '<hr class="linea">';
                    $mostrarHC .= '</td>';
                    $mostrarHC .= '</tr>';
                    $mostrarHC .= '</table>';
                    $pie = $row[$i]["grupoConcepto"];
                    $pdf->writeHTML($mostrarHC, true, false, false, false, '');
                }
                $mostrarHC = '<table cellspacing="0" border="0">';
                $mostrarHC .= '<tr>';
                $mostrarHC .= '<td>';
                $mostrarHC .= '<span style="font-size:36px; color:#000;">';
                $mostrarHC .=  "- " . utf8_decode($row[$i]["descConcepto"]) . "<br>";
                $mostrarHC .=  "&nbsp;&nbsp;CANT:&nbsp;(" . utf8_decode($row[$i]["Cantidad"]) . ")<br>";
                $mostrarHC .=  "&nbsp;&nbsp;" . utf8_decode($row[$i]["notasProveedor"]);
                $mostrarHC .= '</span>';
                $mostrarHC .= '</td>';
                $mostrarHC .= '</tr>';
                $mostrarHC .= '</table>';
                $idGrupo = $row[$i]["grupoConcepto"];
                if ($row[$i+1]["grupoConcepto"] != $pie){
                    // Solo para Ofimedical
                    if($_SESSION['IdAplicacion'] == "OfiMedical"){
                        if (file_exists('../../../consultoriovirtual/' . $_SESSION['IDBD']  . '/firmas/' . $row[0]["Profesional"] . '.png')) {
                            $mostrarHC .= '<img src="../../../consultoriovirtual/' . $_SESSION['IDBD'] . '/firmas/' . $row[0]["Profesional"] . '.png" width="190" height="45"/><br>';
                        }
                    }else{
                        if (file_exists('../../../empresas/' . $_SESSION['ID_EMPRESA']  . '/firmas/' . $row[0]["Profesional"] . '.png')) {
                            $mostrarHC .= '<img src="../../../empresas/' . $_SESSION['ID_EMPRESA'] . '/firmas/' . $row[0]["Profesional"] . '.png" width="190" height="45"/><br>';
                        } 
                    }
                    $mostrarHC .= '<span style="font-size:34px; color:#000;">';
                    $mostrarHC .= utf8_decode($row[0]["NomProfesional"]) . '<br>';
                    $mostrarHC .= utf8_decode($row[0]["DocProfesional"]) . '<br>';
                    $mostrarHC .= utf8_decode($row[0]["nomEspecialidad"]) . '<br>';
                    $mostrarHC .= 'Nro. Registro:' . utf8_decode($row[0]["RegistroProfesional"]);
                    $mostrarHC .= '</span>';
                }
                $pdf->writeHTML($mostrarHC, true, false, false, false, '');
            }
        }
        $pdf->Output('infOrdenamientos.pdf', 'I');
    }

    function EncabezadoPagina(&$pdf, &$row, &$i, &$rowcount, &$contador, &$pDesde, &$pHasta, $pNuevo="SI"){
        if($pNuevo == "SI"){
            $pdf->AddPage();
        }
        $pdf->Ln(2);
        $pdf->SetFont(PDF_FONT_NAME_MAIN, '', 7);
        $EncabezadoHTML = '<table cellspacing="0" border="0" style="font-size:24px; color:#000;">';
        $EncabezadoHTML .= '<tr>';
        $EncabezadoHTML .= '<td width="500">';
        $EncabezadoHTML .= '<span style="font-size:44px; color:#000; font-weight:bold">' . utf8_decode($pdf->pNomEmpresa) . '</span><br>';
        if($pdf->pEspEmpresa != null || $pdf->pEspEmpresa != "")
                $EncabezadoHTML .= '<span style="font-size:34px; color:#000;">' . utf8_decode($pdf->pEspEmpresa) . '</span><br>';
        if($pdf->pTDocEmpresa == "NI"){
            $tipodoc = "NIT: ";
            $EncabezadoHTML .= '<span style="font-size:34px; color:#000;">' . $tipodoc . $pdf->pDocEmpresa . '</span><br>';
        }
        $EncabezadoHTML .= '<span style="font-size:28px; color:#000;">' . $pdf->pDirEmpresa . ' - Tel: ' . $pdf->pTelEmpresa . '</span><br>';
        $EncabezadoHTML .= '<span style="font-size:28px; color:#000;">' . $pdf->pCiuEmpresa . '</span><br><br>';
        $EncabezadoHTML .= '<span style="font-size:34px; color:#000;"><b>PACIENTE:&nbsp;&nbsp;</b>' . utf8_decode($row[$i]["TipDoc"]) . ' ' . utf8_decode($row[$i]["Documento"]) . ' - ' . utf8_decode($row[$i]["Nom1"]) . ' ' . utf8_decode($row[$i]["Nom2"]) . ' ' . utf8_decode($row[$i]["Ape1"]) . ' ' . utf8_decode($row[$i]["Ape2"]) . '</span><br>';
        if (utf8_decode($row[$i]["Genero"]) == "M")
            $EncabezadoHTML .= '<span style="font-size:34px; color:#000;"><b>GENERO:&nbsp;&nbsp;</b>&nbsp;&nbsp;MASCULINO&nbsp;&nbsp;&nbsp;&nbsp;<b>FECHA NACIMIENTO:&nbsp;&nbsp;&nbsp;&nbsp;</b>' . $row[$i]["FecNac"] . '</span><br>';
        else
            $EncabezadoHTML .= '<span style="font-size:34px; color:#000;"><b>GENERO:&nbsp;&nbsp;</b>FEMENINO&nbsp;&nbsp;&nbsp;&nbsp;<b>FECHA NACIMIENTO:&nbsp;&nbsp;</b>' . $row[$i]["FecNac"] . '</span><br>';
        $EncabezadoHTML .= '</td>';

        //COL2
        $EncabezadoHTML .= '<td width="215" align="right">';
        if($_SESSION['IdAplicacion'] == "OfiMedical"){
            if (file_exists("../../../consultoriovirtual/" . $_SESSION['IDBD'] . "/logo/logoenc.gif")) {
                $EncabezadoHTML .= '<img src="../../../consultoriovirtual/' . $_SESSION['IDBD'] . '/logo/logoenc.gif" align="right"/>';
                $EncabezadoHTML .= '<br>';
            }
        }else{
            if (file_exists("../../../empresas/" . $_SESSION['ID_EMPRESA'] . "/logo/logoenc.gif")) {
                $EncabezadoHTML .= '<img src="../../../empresas/' . $_SESSION['ID_EMPRESA'] . '/logo/logoenc.gif" align="right"/>';
                $EncabezadoHTML .= '<br>';
            }
        }
        $EncabezadoHTML .= '<span align="rigth" style="font-size:44px; color:#000; font-weight:bold">SOLICITUD: ' . $row[$i]["FechaSolicitud"] . '</span><br>';
        $EncabezadoHTML .= '<span align="rigth" style="font-size:44px; color:#000; font-weight:bold">' . $row[$i]["grupoConcepto"] . '</span><br>';
        $EncabezadoHTML .= '</td>';
        $EncabezadoHTML .= '</tr>';
        $EncabezadoHTML .= '</table>';
        $EncabezadoHTML .= '<hr class="linea">';
        $pdf->writeHTML($EncabezadoHTML, true, false, false, false, '');
        $pdf->Ln(0.1);
        $mostrarHC = '<span colspan="2" style="font-size:30px; color:#0B0B61; font-weight:bolder;">Fecha y Hora de Atención: ' . utf8_decode($row[$i]["Fecha"]) . ' - ' . utf8_decode($row[$i]["HoraApertura"]) . '&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;CAS:' . utf8_decode($row[$i]["CAS"]) . '</span><br>';
        $mostrarHC .= '<span colspan="2" style="font-size:30px; color:#000;"><b>Entidad: </b>' . utf8_decode($row[$i]["Cliente"]) . '</span><br>';
        //$mostrarHC .= '<span colspan="2" style="font-size:30px; color:#000;"><b>Profesional Tratante: </b>' . utf8_decode($row[0]["NomProfesional"]) . '</span><br>';
        $mostrarHC .= '<span colspan="2" style="font-size:30px; color:#000;"><b>Diagnosticos: </b>' . utf8_decode($row[$i]["Diagppal"]) . ' - ' . utf8_decode($row[$i]["Diagrel1"]) . ' - ' . utf8_decode($row[$i]["Diagrel2"])  . ' - ' . utf8_decode($row[$i]["Diagrel3"]) . '</span>';
        if($row[$i]["Cliente"] == "NUEVA EPS" && $row[$i]["grupoConcepto"] == "LABORATORIO CLINICO"){
            $mostrarHC .= '<br><span colspan="2" style="font-size:32px; color:#000;"><b>LA CITA PARA TOMA DE MUESTRAS DE LABORATORIO, SE ASIGNARÁ DE MANERA EXCLUSIVA POR MEDIO DEL WHATSAPP 3164458580</b></span>';
        }
        $mostrarHC .= '<hr>';
        $pdf->writeHTML($mostrarHC, true, false, false, false, '');
    }
    
    function EncabezadoAutorizacion(&$pdf, &$row, &$i, &$rowcount, &$contador, &$pDesde, &$pHasta, $pNuevo="SI"){
        if($row[$i]["CAS"] != ""){
            if($pNuevo == "SI"){
                $pdf->AddPage();
            }
            $pdf->Ln(-3);
            $pdf->SetFont(PDF_FONT_NAME_MAIN, '', 7);
            $EncabezadoHTML = '<table cellspacing="0" border="0" style="font-size:24px; color:#000;">';
            $EncabezadoHTML .= '<tr>';
            $EncabezadoHTML .= '<td width="500">';
            $EncabezadoHTML .= '<span style="font-size:44px; color:#000; font-weight:bold">' . utf8_decode($pdf->pNomEmpresa) . '</span><br>';
            if($pdf->pEspEmpresa != null || $pdf->pEspEmpresa != "")
                    $EncabezadoHTML .= '<span style="font-size:34px; color:#000;">' . utf8_decode($pdf->pEspEmpresa) . '</span><br>';
            if($pdf->pTDocEmpresa == "NI"){
                $tipodoc = "NIT: ";
                $EncabezadoHTML .= '<span style="font-size:34px; color:#000;">' . $tipodoc . $pdf->pDocEmpresa . '</span><br>';
            }
            $EncabezadoHTML .= '<span style="font-size:28px; color:#000;">' . $pdf->pDirEmpresa . ' - Tel: ' . $pdf->pTelEmpresa . '</span><br>';
            $EncabezadoHTML .= '<span style="font-size:28px; color:#000;">' . $pdf->pCiuEmpresa . '</span><br><br>';
            $EncabezadoHTML .= '<span style="font-size:34px; color:#000;"><b>PACIENTE:&nbsp;&nbsp;</b>' . utf8_decode($row[$i]["TipDoc"]) . ' ' . utf8_decode($row[$i]["Documento"]) . ' - ' . utf8_decode($row[$i]["Nom1"]) . ' ' . utf8_decode($row[$i]["Nom2"]) . ' ' . utf8_decode($row[$i]["Ape1"]) . ' ' . utf8_decode($row[$i]["Ape2"]) . '</span><br>';
            if (utf8_decode($row[$i]["Genero"]) == "M")
                $EncabezadoHTML .= '<span style="font-size:34px; color:#000;"><b>GENERO:&nbsp;&nbsp;</b>&nbsp;&nbsp;MASCULINO&nbsp;&nbsp;&nbsp;&nbsp;<b>FECHA NACIMIENTO:&nbsp;&nbsp;&nbsp;&nbsp;</b>' . $row[$i]["FecNac"] . '</span><br>';
            else
                $EncabezadoHTML .= '<span style="font-size:34px; color:#000;"><b>GENERO:&nbsp;&nbsp;</b>FEMENINO&nbsp;&nbsp;&nbsp;&nbsp;<b>FECHA NACIMIENTO:&nbsp;&nbsp;</b>' . $row[$i]["FecNac"] . '</span><br>';
            $EncabezadoHTML .= '</td>';

            //COL2
            $EncabezadoHTML .= '<td width="215" align="right">';
            if($_SESSION['IdAplicacion'] == "OfiMedical"){
                if (file_exists("../../../consultoriovirtual/" . $_SESSION['IDBD'] . "/logo/logoenc.gif")) {
                    $EncabezadoHTML .= '<img src="../../../consultoriovirtual/' . $_SESSION['IDBD'] . '/logo/logoenc.gif" align="right"/>';
                    $EncabezadoHTML .= '<br>';
                }
            }else{
                if (file_exists("../../../empresas/" . $_SESSION['ID_EMPRESA'] . "/logo/logoenc.gif")) {
                    $EncabezadoHTML .= '<img src="../../../empresas/' . $_SESSION['ID_EMPRESA'] . '/logo/logoenc.gif" align="right"/>';
                    $EncabezadoHTML .= '<br>';
                }
            }
            $EncabezadoHTML .= '<span align="rigth" style="font-size:36px; color:#000; font-weight:bold">AUTORIZACION DE SERVICIOS</span><br>';
            $EncabezadoHTML .= '<span align="rigth" style="font-size:36px; color:#000; font-weight:bold">ORDEN: ' . $_SESSION['ID_IPS'] . '-' . $row[$i]["CAS"] . '</span><br>';
            $EncabezadoHTML .= '<span align="rigth" style="font-size:36px; color:#000; font-weight:bold">FECHA: ' . $row[$i]["FechaSolicitud"] . '</span><br>';
            $EncabezadoHTML .= '<span align="rigth" style="font-size:22px; color:#000;">Exenta de Pago</span>';
            $EncabezadoHTML .= '</td>';
            $EncabezadoHTML .= '</tr>';
            $EncabezadoHTML .= '</table>';
            $pdf->writeHTML($EncabezadoHTML, true, false, false, false, '');
            $pdf->Ln(-5);
            $mostrarHC = '<hr>';
            $mostrarHC .= '<span colspan="2" style="font-size:30px; color:#0B0B61; font-weight:bolder;">Fecha: ' . utf8_decode($row[$i]["FechaSolicitud"]) . '&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;CAS:' . utf8_decode($row[0]["CAS"]) . '&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;PROGRAMA: ' . utf8_decode($row[$i]["nomPrograma"]) . '</span>';
            $pdf->writeHTML($mostrarHC, true, false, false, false, '');
            $mostrarHC = '<span colspan="2" style="font-size:30px; color:#000;"><b>Entidad: </b>' . utf8_decode($row[0]["Cliente"]) . '</span><br>';
            $pdf->writeHTML($mostrarHC, true, false, false, false, '');
            $mostrarHC = '<hr>';
            
            unset($rowProveedor);
            $gBaseDatos = new ofiMySQLi();
            $gBaseDatos->conectar();
            $qry = "CALL sp_proveedor_databasico('" . $row[$i]["Proveedor"] . "')";
            $gBaseDatos->QryID = @mysqli_query($gBaseDatos->ConexionID, $qry);
            while ($rowProveedor[] = @mysqli_fetch_assoc($gBaseDatos->QryID));
            $gBaseDatos->liberar();
            $gBaseDatos->cerrar();
    
            $mostrarHC .= '<span style="font-size:30px; color:#0B0B61; font-weight:bolder;">PROVEEDOR: ' . utf8_decode($rowProveedor[0]["TdocProv"] . " " . $rowProveedor[0]["DocumentoProv"] . " - " . $rowProveedor[0]["NomProv"]) . '</span><br>';
            $mostrarHC .= '<span style="font-size:30px; color:#0B0B61; font-weight:bolder;">DIRECCION: ' . utf8_decode($rowProveedor[0]["DirProv"] . " -Tel: " . $rowProveedor[0]["TelProv"]) . '</span>';
            if($row[$i]["Cliente"] == "NUEVA EPS" && $row[$i]["grupoConcepto"] == "LABORATORIO CLINICO"){
                $mostrarHC .= '<br><span colspan="2" style="font-size:32px; color:#000;"><b>LA CITA PARA TOMA DE MUESTRAS DE LABORATORIO, SE ASIGNARÁ DE MANERA EXCLUSIVA POR MEDIO DEL WHATSAPP 3164458580</b></span>';
            }
            $mostrarHC .= '<hr>';
            $mostrarHC .= '<span align="center" style="font-size:30px; font-weight:bolder;">DETALLE SERVICIOS AUTORIZADOS</span>';
            $mostrarHC .= '<hr>';
            $pdf->writeHTML($mostrarHC, true, false, false, false, '');
            $pdf->Ln(-3);
        }
    }
    
    function imprimeSolicitud(&$pdf, &$row, &$i, &$idFecSolicitud, &$idGrupo, &$pRegistros, &$pControlSalto){
        $pie = $row[$i]["grupoConcepto"];
        $idFecSolicitud = $row[$i]["FechaSolicitud"];
        if ($row[$i]["FechaSolicitud"] != $idFecSolicitud){
            EncabezadoPagina($pdf, $row, $i, $rowcount, $contador, $pDesde, $pHasta);
            $pie = $row[$i]["grupoConcepto"];
        }else{
            if ($row[$i]["grupoConcepto"] != $idGrupo){
                EncabezadoPagina($pdf, $row, $i, $rowcount, $contador, $pDesde, $pHasta);
                $pie = $row[$i]["grupoConcepto"];
            }
        }
        $pdf->SetFont(PDF_FONT_NAME_MAIN, '', 9);
        $pdf->Ln(0.5);
        $mostrarHC = '<table cellspacing="0">';
        $mostrarHC .= '<tr>';
        $mostrarHC .= '<td width="650">';
        //$mostrarHC .=  utf8_decode($row[$i]["descConcepto"]) . "  -  Cant.(" . utf8_decode($row[$i]["Cantidad"]) . ")";
        //utf8_decode($row[$i]["descConcepto"])
        //$NomProced = @preg_replace(" ","< O:P>",$row[$i]["descConcepto"]);
        //$NomProced1 = preg_replace('',"<O:P>",$NomProced);
        $mostrarHC .=  '<b>' . utf8_decode($row[$i]["descConcepto"]) . '</b>';
        $mostrarHC .= '</td>';
        $mostrarHC .= '<td widht="50">';
        $mostrarHC .=  "# (" . utf8_decode($row[$i]["Cantidad"]) . ")";
        $mostrarHC .= '</td>';
        $mostrarHC .= '</tr>';
        if($row[$i]["notasProveedor"] != "" && $row[$i]["notasProveedor"] != null){
            $mostrarHC .= '<tr>';
            $mostrarHC .= '<td widht="650">';
            $mostrarHC .=  utf8_decode($row[$i]["notasProveedor"]);
            $mostrarHC .= '</td>';
            $mostrarHC .= '</tr>';
        }
        $mostrarHC .= '</table>';
        $xx = $pdf->GetY();
        //$pdf->writeHTML($pdf->GetY() . " - " . $xx, true, false, false, false, '');
        //$pdf->writeHTML($mostrarHC . " - " . $xx, true, false, false, false, '');
        $pdf->writeHTML($mostrarHC, true, false, false, false, '');
        //if($pdf->GetY() > 98 && $pRegistros < 4){
        if($pdf->GetY() > 117 && $i < ($pRegistros - 1)){
            EncabezadoPagina($pdf, $row, $i, $rowcount, $contador, $pDesde, $pHasta);
        }else{
            if ($pdf->GetY() >= ($pdf->getPageHeight()-$pControlSalto)){
                EncabezadoPagina($pdf, $row, $i, $rowcount, $contador, $pDesde, $pHasta);
            }
        }
        
        $idProveedor = $row[$i]["Proveedor"];
        $idGrupo = $row[$i]["grupoConcepto"];
        $idFecSolicitud = $row[$i]["FechaSolicitud"];
        
        if ($row[$i+1]["grupoConcepto"] != $pie){
            // Solo para Ofimedical
            $mostrarHC = '<br><br><br><table border="0" cellspacing="0">';
            if($_SESSION['IdAplicacion'] == "OfiMedical"){
                if (file_exists('../../../consultoriovirtual/' . $_SESSION['IDBD']  . '/firmas/' . $row[0]["Profesional"] . '.png')) {
                    $mostrarHC .= '<tr>';
                    $mostrarHC .= '<td width="500">&nbsp;</td>';
                    $mostrarHC .= '<td width="200" valign="middle" align="left"><img src="../../../consultoriovirtual/' . $_SESSION['IDBD'] . '/firmas/' . $row[0]["Profesional"] . '.png" c/></td>';
                    $mostrarHC .= '</tr>';
                }
            }else{
                if (file_exists('../../../empresas/' . $_SESSION['ID_EMPRESA']  . '/firmas/' . $row[0]["Profesional"] . '.png')) {
                    $mostrarHC .= '<tr>';
                    $mostrarHC .= '<td width="500">&nbsp;</td>';
                    $mostrarHC .= '<td width="200" valign="middle" align="left"><img src="../../../empresas/' . $_SESSION['ID_EMPRESA'] . '/firmas/' . $row[0]["Profesional"] . '.png" width="190" height="45"/></td>';
                    $mostrarHC .= '</tr>';
                } 
            }
            $mostrarHC .= '<tr>';
            $mostrarHC .= '<td width="500">&nbsp;</td>';
            $mostrarHC .= '<td width="200" align="left" style="border-top-width: 1px; border-top-style: solid;">' . utf8_decode($row[0]["NomProfesional"]) . '</td>';
            $mostrarHC .= '</tr>';
            $mostrarHC .= '<tr>';
            $mostrarHC .= '<td>&nbsp;</td>';
            $mostrarHC .= '<td align="left">' . utf8_decode($row[0]["nomEspecialidad"]) . '</td>';
            $mostrarHC .= '</tr>';
            $mostrarHC .= '<tr>';
            $mostrarHC .= '<td>&nbsp;</td>';
            $mostrarHC .= '<td align="left">Nro. Registro:' . utf8_decode($row[0]["RegistroProfesional"]) . '</td>';
            $mostrarHC .= '</tr>';
            $mostrarHC .= '</table>';
            $pdf->writeHTML($mostrarHC, true, false, false, false, '');
            $xx = ($pdf->getPageHeight()-$pControlSalto);
            //$pdf->writeHTML($pdf->GetY() . " - " . $xx, true, false, false, false, '');
        }else{
            if ($row[$i+1]["FechaSolicitud"] != $idFecSolicitud){
                // Solo para Ofimedical
                $mostrarHC = '<br><br><br><table border="0" cellspacing="0">';
                if($_SESSION['IdAplicacion'] == "OfiMedical"){
                    if (file_exists('../../../consultoriovirtual/' . $_SESSION['IDBD']  . '/firmas/' . $row[0]["Profesional"] . '.png')) {
                        $mostrarHC .= '<tr>';
                        $mostrarHC .= '<td width="500">&nbsp;</td>';
                        $mostrarHC .= '<td width="200" valign="middle" align="left"><img src="../../../consultoriovirtual/' . $_SESSION['IDBD'] . '/firmas/' . $row[0]["Profesional"] . '.png" c/></td>';
                        $mostrarHC .= '</tr>';
                    }
                }else{
                    if (file_exists('../../../empresas/' . $_SESSION['ID_EMPRESA']  . '/firmas/' . $row[0]["Profesional"] . '.png')) {
                        $mostrarHC .= '<tr>';
                        $mostrarHC .= '<td width="500">&nbsp;</td>';
                        $mostrarHC .= '<td width="200" valign="middle" align="left"><img src="../../../empresas/' . $_SESSION['ID_EMPRESA'] . '/firmas/' . $row[0]["Profesional"] . '.png" width="190" height="45"/></td>';
                        $mostrarHC .= '</tr>';
                    } 
                }
                $mostrarHC .= '<tr>';
                $mostrarHC .= '<td width="500">&nbsp;</td>';
                $mostrarHC .= '<td width="200" align="left" style="border-top-width: 1px; border-top-style: solid;">' . utf8_decode($row[0]["NomProfesional"]) . '</td>';
                $mostrarHC .= '</tr>';
                $mostrarHC .= '<tr>';
                $mostrarHC .= '<td>&nbsp;</td>';
                $mostrarHC .= '<td align="left">' . utf8_decode($row[0]["nomEspecialidad"]) . '</td>';
                $mostrarHC .= '</tr>';
                $mostrarHC .= '<tr>';
                $mostrarHC .= '<td>&nbsp;</td>';
                $mostrarHC .= '<td align="left">Nro. Registro:' . utf8_decode($row[0]["RegistroProfesional"]) . '</td>';
                $mostrarHC .= '</tr>';
                $mostrarHC .= '</table>';
                $pdf->writeHTML($mostrarHC, true, false, false, false, '');
                $xx = ($pdf->getPageHeight()-$pControlSalto);
                //$pdf->writeHTML($pdf->GetY() . " - " . $xx, true, false, false, false, '');
            }
        }
        if ($pdf->GetY() >= ($pdf->getPageHeight()-$pControlSalto)){
            if(($i + 1) < ($pRegistros - 1)){
                //$xx = "i: " . $i . " Reg: " . $pRegistros . " - " . $pdf->GetY();
                //$pdf->writeHTML($xx, true, false, false, false, '');
                if ($row[$i+1]["grupoConcepto"] == $pie){
                    EncabezadoPagina($pdf, $row, $i, $rowcount, $contador, $pDesde, $pHasta);
                }
            }
        }
    }
    
    function imprimeAutorizacion(&$pdf, &$row, &$i, &$idFecSolicitud, &$idGrupo, &$pRegistros, &$pControlSalto){
        $pie = $row[$i]["grupoConcepto"];
        if ($row[$i]["FechaSolicitud"] != $idFecSolicitud){
            EncabezadoAutorizacion($pdf, $row, $i, $rowcount, $contador, $pDesde, $pHasta);
            $pie = $row[$i]["grupoConcepto"];
        }else{
            if ($row[$i]["grupoConcepto"] != $idGrupo){
                EncabezadoAutorizacion($pdf, $row, $i, $rowcount, $contador, $pDesde, $pHasta);
                $pie = $row[$i]["grupoConcepto"];
            }
        }
        $pdf->SetFont(PDF_FONT_NAME_MAIN, '', 9);
        $pdf->Ln(0.5);
        $mostrarHC = '<table cellspacing="0">';
        $mostrarHC .= '<tr>';
        $mostrarHC .= '<td width="650">';
        $mostrarHC .= utf8_decode($row[$i]["descConcepto"]);
        $mostrarHC .= '</td>';
        $mostrarHC .= '<td width="50">';
        $mostrarHC .=  "# (" . utf8_decode($row[$i]["Cantidad"]) . ")";
        $mostrarHC .= '</td>';
        $mostrarHC .= '</tr>';
        if(utf8_decode($row[$i]["notasProveedor"])!=""){
            $mostrarHC .= '<tr>';
            $mostrarHC .= '<td colspan="2">';
            $mostrarHC .=  utf8_decode($row[$i]["notasProveedor"]);
            $mostrarHC .= '</td>';
            $mostrarHC .= '</tr>';
        }
        $mostrarHC .= '</table>';
        $pdf->writeHTML($mostrarHC, true, false, false, false, '');
        if($pdf->GetY() > 117 && $i < ($pRegistros - 1)){
            EncabezadoAutorizacion($pdf, $row, $i, $rowcount, $contador, $pDesde, $pHasta,"SI");
        }else{
            if ($pdf->GetY() >= ($pdf->getPageHeight()-$pControlSalto)){
                EncabezadoAutorizacion($pdf, $row, $i, $rowcount, $contador, $pDesde, $pHasta,"SI");
            }
        }
            
        $idProveedor = $row[$i]["Proveedor"];
        $idGrupo = $row[$i]["grupoConcepto"];
        $idFecSolicitud = $row[$i]["FechaSolicitud"];
        
        if ($row[$i+1]["grupoConcepto"] != $pie){
            // Solo para Ofimedical
            $mostrarHC = '<br><br><br><table border="0" cellspacing="0">';
            if($_SESSION['IdAplicacion'] == "OfiMedical"){
                if (file_exists('../../../consultoriovirtual/' . $_SESSION['IDBD']  . '/firmas/' . $row[0]["Profesional"] . '.png')) {
                    $mostrarHC .= '<tr>';
                    $mostrarHC .= '<td width="500">&nbsp;</td>';
                    $mostrarHC .= '<td width="200" valign="middle" align="left"><img src="../../../consultoriovirtual/' . $_SESSION['IDBD'] . '/firmas/' . $row[0]["Profesional"] . '.png" c/></td>';
                    $mostrarHC .= '</tr>';
                }
            }else{
                if (file_exists('../../../empresas/' . $_SESSION['ID_EMPRESA']  . '/firmas/' . $row[0]["Profesional"] . '.png')) {
                    $mostrarHC .= '<tr>';
                    $mostrarHC .= '<td width="500">&nbsp;</td>';
                    $mostrarHC .= '<td width="200" valign="middle" align="left"><img src="../../../empresas/' . $_SESSION['ID_EMPRESA'] . '/firmas/' . $row[0]["Profesional"] . '.png" width="190" height="45"/></td>';
                    $mostrarHC .= '</tr>';
                } 
            }
            $mostrarHC .= '<tr>';
            $mostrarHC .= '<td width="500">&nbsp;</td>';
            $mostrarHC .= '<td width="200" align="left" style="border-top-width: 1px; border-top-style: solid;">Elaboro: ' . utf8_decode($row[0]["NomProfesional"]) . '</td>';
            $mostrarHC .= '</tr>';
            $mostrarHC .= '<tr>';
            $mostrarHC .= '<td>&nbsp;</td>';
            $mostrarHC .= '<td align="left">' . utf8_decode($row[0]["nomEspecialidad"]) . '</td>';
            $mostrarHC .= '</tr>';
            $mostrarHC .= '<tr>';
            $mostrarHC .= '<td>&nbsp;</td>';
            $mostrarHC .= '<td align="left">Nro. Registro:' . utf8_decode($row[0]["RegistroProfesional"]) . '</td>';
            $mostrarHC .= '</tr>';
            $mostrarHC .= '</table>';
            $pdf->writeHTML($mostrarHC, true, false, false, false, '');
            $xx = ($pdf->getPageHeight()-$pControlSalto);
            //$pdf->writeHTML($pdf->GetY() . " - " . $xx, true, false, false, false, '');
        }else{
            if ($row[$i+1]["FechaSolicitud"] != $idFecSolicitud){
                // Solo para Ofimedical
                $mostrarHC = '<br><br><br><table border="0" cellspacing="0">';
                if($_SESSION['IdAplicacion'] == "OfiMedical"){
                    if (file_exists('../../../consultoriovirtual/' . $_SESSION['IDBD']  . '/firmas/' . $row[0]["Profesional"] . '.png')) {
                        $mostrarHC .= '<tr>';
                        $mostrarHC .= '<td width="500">&nbsp;</td>';
                        $mostrarHC .= '<td width="200" valign="middle" align="left"><img src="../../../consultoriovirtual/' . $_SESSION['IDBD'] . '/firmas/' . $row[0]["Profesional"] . '.png" c/></td>';
                        $mostrarHC .= '</tr>';
                    }
                }else{
                    if (file_exists('../../../empresas/' . $_SESSION['ID_EMPRESA']  . '/firmas/' . $row[0]["Profesional"] . '.png')) {
                        $mostrarHC .= '<tr>';
                        $mostrarHC .= '<td width="500">&nbsp;</td>';
                        $mostrarHC .= '<td width="200" valign="middle" align="left"><img src="../../../empresas/' . $_SESSION['ID_EMPRESA'] . '/firmas/' . $row[0]["Profesional"] . '.png" width="190" height="45"/></td>';
                        $mostrarHC .= '</tr>';
                    } 
                }
                $mostrarHC .= '<tr>';
                $mostrarHC .= '<td width="500">&nbsp;</td>';
                $mostrarHC .= '<td width="200" align="left" style="border-top-width: 1px; border-top-style: solid;">' . utf8_decode($row[0]["NomProfesional"]) . '</td>';
                $mostrarHC .= '</tr>';
                $mostrarHC .= '<tr>';
                $mostrarHC .= '<td>&nbsp;</td>';
                $mostrarHC .= '<td align="left">' . utf8_decode($row[0]["nomEspecialidad"]) . '</td>';
                $mostrarHC .= '</tr>';
                $mostrarHC .= '<tr>';
                $mostrarHC .= '<td>&nbsp;</td>';
                $mostrarHC .= '<td align="left">Nro. Registro:' . utf8_decode($row[0]["RegistroProfesional"]) . '</td>';
                $mostrarHC .= '</tr>';
                $mostrarHC .= '</table>';
                $pdf->writeHTML($mostrarHC, true, false, false, false, '');
                $xx = ($pdf->getPageHeight()-$pControlSalto);
                //$pdf->writeHTML($pdf->GetY() . " - " . $xx, true, false, false, false, '');
            }
        }
        if ($pdf->GetY() >= ($pdf->getPageHeight()-$pControlSalto)){
            if(($i + 1) < ($pRegistros - 1)){
                //$xx = "i: " . $i . " Reg: " . $pRegistros . " - " . $pdf->GetY();
                //$pdf->writeHTML($xx, true, false, false, false, '');
                if ($row[$i+1]["grupoConcepto"] == $pie){
                    EncabezadoAutorizacion($pdf, $row, $i, $rowcount, $contador, $pDesde, $pHasta);
                }
            }
        }
    }
    
?>