<?php

/*
* @category    Controlador Plantillas HC - Ofimedical
* @package     OfiClinic Web
* @author      Jorge Ancizar Galeano Ruiz<desarrollo@ofisalud.com>
* @copyright   2010 Jorge Ancizar Galeano Ruiz
* @version     OfiClinic Web 1.0
* @license     COMERCIAL
* @link        http://www.ofisalud.com
* @country     Colombia
* @telephone   3016398114
*/
header("Content-Type: text/plain; charset=UTF-8");
require("../../../core/php/_database.php");
require("../../../core/php/php_functions.php");
session_start();

$task = '';
if ( isset($_POST['task'])){
  $task = $_POST['task'];
}
switch($task){
    case "guardar":
        GuardarHC();
        break;
    case "VerHistorialxPacienteGral":
        VerHistorialxPacienteGral();
        break;
    case "VerHistorialxPacienteGralUAMOdo":
        VerHistorialxPacienteGralUAMOdo();
        break;
    case "VerHistorialxPaciente":
        VerHistorialHCxPaciente();
        break;
    case "VerHistorialxPacienteFiltro":
        VerHistorialHCxPacienteFiltro();
        break;
    case "VerHistorialxPacienteSinEvolucionar":
        VerHistorialHCxPacienteSinEvolucionar();
        break;
    case "crear_resumen_neurodesarrollo":
        CrearResumenNeurodesarrollo();
        break;
    case "ver_resumen_neurodesarrollo":
        VerResumenNeurodesarrollo();
        break;
    case "guardar_resumen_neurodesarrollo":
        GuardarResumenNeurodesarrollo();
        break;
    case "CrearESTUDIOS":
        CrearEstudios();
        break;
    case "CrearESTUDIOS002":
        CrearEstudios002();
        break;
    case "CrearESTUDIOSAIEPI":
        CrearEstudiosAIEPI();
        break;
    case "BorrarESTUDIOSSinEvolucionar":
        BorrarEstudiosVacios();
        break;
    case "CargarParametrosAddEvolucion":
        CargarParametrosAddEvolucion();
        break;
    default:
        echo "{failure:true}";
        break;
}

function CargarParametrosAddEvolucion(){
    $pIPS = isset($_REQUEST['pIPS'])?$_REQUEST['pIPS']:0;
    $qry = "CALL sp_asistencial_ofimedical_addevolucion_load('" . $pIPS . "')";
    $gBaseDatos = new ofiMySQLi();
    $gBaseDatos->conectar();
    $resY = str_replace("<BR \/><br \/>","",PonerAcentosHTML($gBaseDatos->jsonSP($qry,"D")));
    $res = str_replace("<br \/>","",$resY);
    $gBaseDatos->liberar();
    $gBaseDatos->cerrar();
    $res1 = str_replace("[", "", $res);
    $res = str_replace("]", "", $res1);
    echo $res;
}

function BorrarEstudiosVacios(){
    $pEmpresa = isset($_REQUEST['pEmpresa'])?$_REQUEST['pEmpresa']:0;
    $pIPS = isset($_REQUEST['pIPS'])?$_REQUEST['pIPS']:0;
    $pPaciente = isset($_REQUEST['pPaciente'])?$_REQUEST['pPaciente']:0;
    $gBaseDatos = new ofiMySQLi();
    $gBaseDatos->conectar();
    $qry = "CALL sp_asistencial_ofimedical_delevolucion_empty('" . $pEmpresa . "','" . $pIPS . "','" . $pPaciente . "')";
    //echo $qry;
    echo $gBaseDatos->jasonSP_arreglo($qry);
    $gBaseDatos->liberar();
    $gBaseDatos->cerrar();
}

function CrearEstudiosAIEPI(){
    $CodInsercion = "PRS-" .  $_SESSION['ID_EMPRESA'] . "-SED-" . $_SESSION['ID_SEDE'] .  "-IPS-" . $_SESSION['ID_IPS'] . "-USR-" . $_SESSION['ID_USUARIO'] . "-CONS-" . mt_rand(0,100000) . "-" . date("His");
    $pEmpresa = isset($_REQUEST['pEmpresa'])?$_REQUEST['pEmpresa']:0;
    $pConsultorio = isset($_REQUEST['pConsultorio'])?$_REQUEST['pConsultorio']:0;
    $pCliente = isset($_REQUEST['pCliente'])?$_REQUEST['pCliente']:0;
    $pFecha = isset($_REQUEST['pFecha'])?$_REQUEST['pFecha']:"";
    $pProfesional = isset($_REQUEST['pProfesional'])?$_REQUEST['pProfesional']:0;
    $pPaciente = isset($_REQUEST['pPaciente'])?$_REQUEST['pPaciente']:0;
    $pEdadPaciente = isset($_REQUEST['pEdadPaciente'])?$_REQUEST['pEdadPaciente']:"";
    $pDeptoMunici = isset($_REQUEST['pDeptoMunici'])?$_REQUEST['pDeptoMunici']:"17001";
    $pIdProcedimiento = isset($_REQUEST['pIdProcedimiento'])?$_REQUEST['pIdProcedimiento']:0;
    $pCodProcedimiento = isset($_REQUEST['pCodProcedimiento'])?$_REQUEST['pCodProcedimiento']:"";
    $pDesProcedimiento = isset($_REQUEST['pDesProcedimiento'])?$_REQUEST['pDesProcedimiento']:"";
    $pAutorizacion = isset($_REQUEST['pAutorizacion'])?$_REQUEST['pAutorizacion']:"NA";
    if($pAutorizacion == null || $pAutorizacion == ""){
        $pAutorizacion = "NA";
    }
    $pUsuario = isset($_REQUEST['pUsuario'])?$_REQUEST['pUsuario']:0;
    $gBaseDatos = new ofiMySQLi();
    $gBaseDatos->conectar();
    $qry = "CALL sp_asistencial_ofimedical_aiepi_addevolucion(\"" . $CodInsercion . "\",'" . $pEmpresa . "','" . $pConsultorio . "','" . $pCliente . "',\"" . $pFecha . "\",'" . $pProfesional . "','" . $pPaciente . "',\"" . $pEdadPaciente . "\",\"" . $pDeptoMunici . "\",'" . $pIdProcedimiento . "',\"" . $pCodProcedimiento . "\",\"" . $pDesProcedimiento . "\",'" . $pUsuario . "',\"" . $pAutorizacion . "\")";
    //echo $qry;
    echo $gBaseDatos->jasonSP_arreglo($qry);
    $gBaseDatos->liberar();
    $gBaseDatos->cerrar();
}

function CrearEstudios(){
    $CodInsercion = "PRS-" .  $_SESSION['ID_EMPRESA'] . "-SED-" . $_SESSION['ID_SEDE'] .  "-IPS-" . $_SESSION['ID_IPS'] . "-USR-" . $_SESSION['ID_USUARIO'] . "-CONS-" . mt_rand(0,100000) . "-" . date("His");
    $pEmpresa = isset($_REQUEST['pEmpresa'])?$_REQUEST['pEmpresa']:0;
    $pConsultorio = isset($_REQUEST['pConsultorio'])?$_REQUEST['pConsultorio']:0;
    $pCliente = isset($_REQUEST['pCliente'])?$_REQUEST['pCliente']:0;
    $pFecha = isset($_REQUEST['pFecha'])?$_REQUEST['pFecha']:"";
    $pProfesional = isset($_REQUEST['pProfesional'])?$_REQUEST['pProfesional']:0;
    $pPaciente = isset($_REQUEST['pPaciente'])?$_REQUEST['pPaciente']:0;
    $pEdadPaciente = isset($_REQUEST['pEdadPaciente'])?$_REQUEST['pEdadPaciente']:"";
    $pDeptoMunici = isset($_REQUEST['pDeptoMunici'])?$_REQUEST['pDeptoMunici']:"17001";
    $pIdProcedimiento = isset($_REQUEST['pIdProcedimiento'])?$_REQUEST['pIdProcedimiento']:0;
    $pCodProcedimiento = isset($_REQUEST['pCodProcedimiento'])?$_REQUEST['pCodProcedimiento']:"";
    $pDesProcedimiento = isset($_REQUEST['pDesProcedimiento'])?$_REQUEST['pDesProcedimiento']:"";
    $pAutorizacion = isset($_REQUEST['pAutorizacion'])?$_REQUEST['pAutorizacion']:"NA";
    if($pAutorizacion == null || $pAutorizacion == ""){
        $pAutorizacion = "NA";
    }
    $pUsuario = isset($_REQUEST['pUsuario'])?$_REQUEST['pUsuario']:0;
    $gBaseDatos = new ofiMySQLi();
    $gBaseDatos->conectar();
    $qry = "CALL sp_asistencial_ofimedical_addevolucion(\"" . $CodInsercion . "\",'" . $pEmpresa . "','" . $pConsultorio . "','" . $pCliente . "',\"" . $pFecha . "\",'" . $pProfesional . "','" . $pPaciente . "',\"" . $pEdadPaciente . "\",\"" . $pDeptoMunici . "\",'" . $pIdProcedimiento . "',\"" . $pCodProcedimiento . "\",\"" . $pDesProcedimiento . "\",'" . $pUsuario . "',\"" . $pAutorizacion . "\")";
    //echo $qry;
    echo $gBaseDatos->jasonSP_arreglo($qry);
    $gBaseDatos->liberar();
    $gBaseDatos->cerrar();
}

function CrearEstudios002(){
    $CodInsercion = "PRS-" .  $_SESSION['ID_EMPRESA'] . "-SED-" . $_SESSION['ID_SEDE'] .  "-IPS-" . $_SESSION['ID_IPS'] . "-USR-" . $_SESSION['ID_USUARIO'] . "-CONS-" . mt_rand(0,100000) . "-" . date("His");
    $pEmpresa = isset($_REQUEST['pEmpresa'])?$_REQUEST['pEmpresa']:0;
    $pConsultorio = isset($_REQUEST['pConsultorio'])?$_REQUEST['pConsultorio']:0;
    $pCliente = isset($_REQUEST['pCliente'])?$_REQUEST['pCliente']:null;
    $pPlan = isset($_REQUEST['pPlan'])?$_REQUEST['pPlan']:null;
    $pSubPlan = isset($_REQUEST['pSubPlan'])?$_REQUEST['pSubPlan']:null;
    $pContrato = isset($_REQUEST['pContrato'])?$_REQUEST['pContrato']:null;
    $pFecha = isset($_REQUEST['pFecha'])?$_REQUEST['pFecha']:"";
    $pProfesional = isset($_REQUEST['pProfesional'])?$_REQUEST['pProfesional']:null;
    $pPaciente = isset($_REQUEST['pPaciente'])?$_REQUEST['pPaciente']:0;
    $pEdadPaciente = isset($_REQUEST['pEdadPaciente'])?$_REQUEST['pEdadPaciente']:null;
    $pDeptoMunici = isset($_REQUEST['pDeptoMunici'])?$_REQUEST['pDeptoMunici']:"17001";
    $pIdProcedimiento = isset($_REQUEST['pIdProcedimiento'])?$_REQUEST['pIdProcedimiento']:null;
    $pCodProcedimiento = isset($_REQUEST['pCodProcedimiento'])?$_REQUEST['pCodProcedimiento']:null;
    $pDesProcedimiento = isset($_REQUEST['pDesProcedimiento'])?$_REQUEST['pDesProcedimiento']:null;
    $pVlrProcedimiento = isset($_REQUEST['pVlrProcedimiento'])?$_REQUEST['pVlrProcedimiento']:0;
    $pAutorizacion = isset($_REQUEST['pAutorizacion'])?$_REQUEST['pAutorizacion']:"NA";
    if($pAutorizacion == null || $pAutorizacion == ""){
        $pAutorizacion = "NA";
    }
    $pUsuario = isset($_REQUEST['pUsuario'])?$_REQUEST['pUsuario']:0;
    $gBaseDatos = new ofiMySQLi();
    $gBaseDatos->conectar();
    $qry = "CALL sp_asistencial_ofimedical_addevolucion002(\"" . $CodInsercion . "\",'" . $pEmpresa . "','" . $_SESSION['ID_SEDE'] .  "','" . $_SESSION['ID_IPS'] .  "','" . $pConsultorio . "','" . $pCliente . "','" . $pPlan . "','" . $pSubPlan . "','" . $pContrato . "',\"" . $pFecha . "\",'" . $pProfesional . "','" . $pPaciente . "',\"" . $pEdadPaciente . "\",\"" . $pDeptoMunici . "\",'" . $pIdProcedimiento . "',\"" . $pCodProcedimiento . "\",\"" . $pDesProcedimiento . "\",'" . $pVlrProcedimiento . "','" . $pUsuario . "',\"" . $pAutorizacion . "\")";
    //echo $qry;
    echo $gBaseDatos->jasonSP_arreglo($qry);
    $gBaseDatos->liberar();
    $gBaseDatos->cerrar();
}

function VerHistorialxPacienteGralUAMOdo(){
    $pEmpresa = isset($_REQUEST['pEmpresa'])?$_REQUEST['pEmpresa']:0;
    $pPaciente = isset($_REQUEST['pPaciente'])?$_REQUEST['pPaciente']:0;
    $gBaseDatos = new ofiMySQLi();
    $gBaseDatos->conectar();
    $qry = "CALL sp_asistencial_ofimedical_evolucionesuamodo('" . $pPaciente . "')";
    $gBaseDatos->QryID = @mysqli_query($gBaseDatos->ConexionID, $qry);
    $arr = array();
    while($row = @mysqli_fetch_assoc($gBaseDatos->QryID))
    {
        $nRow = $row;
        foreach($row as $key => $val)
        {
            if(substr($val,0,7) != "memHTML"){
                $nRow[$key] = utf8_decode(str_replace("\n\n", "\n",preg_replace('/\<br(\s*)?\/?\>/i', "\n",$val)));
            }else{
                $nRow[$key] = utf8_decode($val);
            }
        }
        $arr[] = $nRow;
    }
    $gBaseDatos->liberar();
    $gBaseDatos->cerrar();
    $jsonresult = JEncode($arr);
    if (!is_null($jsonresult))
        echo '({"total":"0","results":'. $jsonresult .'})';
}

function VerHistorialxPacienteGral(){
    $pEmpresa = isset($_REQUEST['pEmpresa'])?$_REQUEST['pEmpresa']:0;
    $pPaciente = isset($_REQUEST['pPaciente'])?$_REQUEST['pPaciente']:0;
    $gBaseDatos = new ofiMySQLi();
    $gBaseDatos->conectar();
    $qry = "CALL sp_asistencial_ofimedical_evolucionesgral('" . $pPaciente . "')";
    $gBaseDatos->QryID = @mysqli_query($gBaseDatos->ConexionID, $qry);
    $arr = array();
    while($row = @mysqli_fetch_assoc($gBaseDatos->QryID))
    {
        $nRow = $row;
        foreach($row as $key => $val)
        {
            if(substr($val,0,7) != "memHTML"){
                $nRow[$key] = utf8_decode(str_replace("\n\n", "\n",preg_replace('/\<br(\s*)?\/?\>/i', "\n",$val)));
            }else{
                $nRow[$key] = utf8_decode($val);
            }
        }
        $arr[] = $nRow;
    }
    $gBaseDatos->liberar();
    $gBaseDatos->cerrar();
    $jsonresult = JEncode($arr);
    if (!is_null($jsonresult))
        echo '({"total":"0","results":'. $jsonresult .'})';
}


function GuardarResumenNeurodesarrollo(){

    $estructura = explode("¬", $_REQUEST['CAMPOS']);
    $pProceso = isset($_REQUEST['pProceso'])?$_REQUEST['pProceso']:"NA";
    $qry = "CALL sp_neurodesa_resumenhc_update(\"" . $pProceso . "\"," . spParametros($estructura,"NO") . ")";
    //echo $qry;
    $gBaseDatos = new ofiMySQLi();
    $gBaseDatos->conectar();
    if(@mysqli_query($gBaseDatos->ConexionID, $qry))
        echo "{success: true, requestedId:'1'}";
    else
       echo "{success: true, requestedId:'0'}";
    $gBaseDatos->cerrar();   
}

function VerResumenNeurodesarrollo(){
    $pEmpresa = isset($_REQUEST['pEmpresa'])?$_REQUEST['pEmpresa']:0;
    $pIPS = isset($_REQUEST['pIPS'])?$_REQUEST['pIPS']:0;
    $pPaciente = isset($_REQUEST['pPaciente'])?$_REQUEST['pPaciente']:0;
    $gBaseDatos = new ofiMySQLi();
    $gBaseDatos->conectar();
    $qry = "CALL sp_neurodesa_resumenhc_listar('" . $pEmpresa . "','" . $pIPS . "','" . $pPaciente . "')";
    //echo $qry;
    $gBaseDatos->QryID = @mysqli_query($gBaseDatos->ConexionID, $qry);
    $arr = array();
    while($row = @mysqli_fetch_assoc($gBaseDatos->QryID))
    {
        $nRow = $row;
        foreach($row as $key => $val)
        {
            $nRow[$key] = utf8_decode(str_replace("\n\n", "\n",preg_replace('/\<br(\s*)?\/?\>/i', "\n",$val)));
        }
        $arr[] = $nRow;
    }
    $gBaseDatos->liberar();
    $gBaseDatos->cerrar();
    $jsonresult = JEncode($arr);
    if (!is_null($jsonresult))
        echo '({"total":"0","results":'. $jsonresult .'})';
}

function CrearResumenNeurodesarrollo(){
    $pEmpresa = isset($_REQUEST['pEmpresa'])?$_REQUEST['pEmpresa']:0;
    $pIPS = isset($_REQUEST['pIPS'])?$_REQUEST['pIPS']:0;
    $pPaciente = isset($_REQUEST['pPaciente'])?$_REQUEST['pPaciente']:0;
    $pCliente = isset($_REQUEST['pCliente'])?$_REQUEST['pCliente']:0;
    $pAno = isset($_REQUEST['pAno'])?$_REQUEST['pAno']:0;
    $pMes = isset($_REQUEST['pMes'])?$_REQUEST['pMes']:0;
    $gBaseDatos = new ofiMySQLi();
    $gBaseDatos->conectar();
    $qry = "CALL sp_neurodesa_resumenhc_crear('" . $pEmpresa . "','" . $pIPS . "','" . $pPaciente . "','" . $pCliente . "','" . $pAno . "',\"" . $pMes . "\")";
    //echo $qry;
    if(@mysqli_query($gBaseDatos->ConexionID, $qry))
        echo "{success: true, requestedId:'1'}";
    else
       echo "{success: true, requestedId:'0'}";
    $gBaseDatos->cerrar();   
}

function VerHistorialHCxPacienteSinEvolucionar(){
    $pEmpresa = isset($_REQUEST['pEmpresa'])?$_REQUEST['pEmpresa']:0;
    $pIPS = isset($_REQUEST['pIPS'])?$_REQUEST['pIPS']:0;
    $pPaciente = isset($_REQUEST['pPaciente'])?$_REQUEST['pPaciente']:0;
    $pProfesional = isset($_REQUEST['pProfesional'])?$_REQUEST['pProfesional']:0;
    $pDesde = isset($_REQUEST['pDesde'])?$_REQUEST['pDesde']:null;
    $pHasta = isset($_REQUEST['pHasta'])?$_REQUEST['pHasta']:null;
    if ($pDesde == "" || $pDesde == null)
        $pFiltroFec = "N";
    else
        $pFiltroFec = "S";
    $gBaseDatos = new ofiMySQLi();
    $gBaseDatos->conectar();
    $qry = "CALL sp_pacientes_hc_sinevolucionar('" . $pEmpresa . "','" . $pIPS . "','" . $pPaciente . "','" . $pProfesional . "')";
    //echo $qry;
    @mysqli_query("\"SET NAMES UTF8\"");
    $gBaseDatos->QryID = @mysqli_query($gBaseDatos->ConexionID, $qry);
    $arr = array();
    while($row = @mysqli_fetch_assoc($gBaseDatos->QryID))
    {
        $nRow = $row;
        foreach($row as $key => $val)
        {
            $nRow[$key] = utf8_decode($val);
        }
        $arr[] = $nRow;
    }
    $gBaseDatos->liberar();
    $gBaseDatos->cerrar();
    $jsonresult = JEncode($arr);
    if (!is_null($jsonresult))
        echo '({"total":"0","results":'. $jsonresult .'})';
}

function VerHistorialHCxPacienteFiltro(){
    $pEmpresa = isset($_REQUEST['pEmpresa'])?$_REQUEST['pEmpresa']:0;
    $pPaciente = isset($_REQUEST['pPaciente'])?$_REQUEST['pPaciente']:0;
    $pProfesional = isset($_REQUEST['pProfesional'])?$_REQUEST['pProfesional']:0;
    $pDesde = isset($_REQUEST['pDesde'])?$_REQUEST['pDesde']:null;
    $pHasta = isset($_REQUEST['pHasta'])?$_REQUEST['pHasta']:null;
    if ($pDesde == "" || $pDesde == null)
        $pFiltroFec = "N";
    else
        $pFiltroFec = "S";
    $gBaseDatos = new ofiMySQLi();
    $gBaseDatos->conectar();
    $qry = "CALL sp_asistencial_evolucionesxpaciente_filtro('" . $pEmpresa . "','" . $pPaciente . "','" . $pProfesional . "',\"" . $pDesde . "\",\"" . $pHasta . "\",\"" . $pFiltroFec . "\")";
    //echo $qry;
    $gBaseDatos->QryID = @mysqli_query($gBaseDatos->ConexionID, $qry);
    $arr = array();
    while($row = @mysqli_fetch_assoc($gBaseDatos->QryID))
    {
        $nRow = $row;
        foreach($row as $key => $val)
        {
            $nRow[$key] = utf8_decode($val);
        }
        $arr[] = $nRow;
    }
    $gBaseDatos->liberar();
    $gBaseDatos->cerrar();
    $jsonresult = JEncode($arr);
    if (!is_null($jsonresult))
        echo '({"total":"0","results":'. $jsonresult .'})';
}
        
function VerHistorialHCxPaciente(){
    $pEmpresa = isset($_REQUEST['pEmpresa'])?$_REQUEST['pEmpresa']:0;
    $pPaciente = isset($_REQUEST['pPaciente'])?$_REQUEST['pPaciente']:0;
    $gBaseDatos = new ofiMySQLi();
    $gBaseDatos->conectar();
    $qry = "CALL sp_asistencial_evolucionesxpaciente('" . $pEmpresa . "','" . $pPaciente . "')";
    $gBaseDatos->QryID = @mysqli_query($gBaseDatos->ConexionID, $qry);
    $arr = array();
    while($row = @mysqli_fetch_assoc($gBaseDatos->QryID))
    {
        $nRow = $row;
        foreach($row as $key => $val)
        {
            $nRow[$key] = utf8_decode($val);
        }
        $arr[] = $nRow;
    }
    $gBaseDatos->liberar();
    $gBaseDatos->cerrar();
    $jsonresult = JEncode($arr);
    if (!is_null($jsonresult))
        echo '({"total":"0","results":'. $jsonresult .'})';
}

function GuardarHC()
{
    
    $pEmpresa = isset($_REQUEST['pEmpresa'])?$_REQUEST['pEmpresa']:0;
    $pIPS = isset($_REQUEST['pIPS'])?$_REQUEST['pIPS']:0;
    $pPaciente = isset($_REQUEST['pPaciente'])?$_REQUEST['pPaciente']:0;
    //$pProfesional = isset($_REQUEST['pProfesional'])?$_REQUEST['pProfesional']:0;
    $pProfesional = $_SESSION['ID_PROFESIONAL_HC'];
    $pCAS = isset($_REQUEST['pCAS'])?$_REQUEST['pCAS']:0;
    $pConsecutivoDetalle = isset($_REQUEST['pConsecutivoDetalle'])?$_REQUEST['pConsecutivoDetalle']:0;
    $pFechaAtencion = isset($_REQUEST['pFechaAtencion'])?$_REQUEST['pFechaAtencion']:null;
    $pHoraApertura = isset($_REQUEST['pHoraApertura'])?$_REQUEST['pHoraApertura']:null;
    $pActividad = isset($_REQUEST['pActividad'])?$_REQUEST['pActividad']:null;
    $pPlantilla = isset($_REQUEST['pPlantilla'])?$_REQUEST['pPlantilla']:null;
    $pRutaRptHC = isset($_REQUEST['pRutaRptHC'])?$_REQUEST['pRutaRptHC']:null;
    $pRutaRptMx = isset($_REQUEST['pRutaRptMx'])?$_REQUEST['pRutaRptMx']:null;
    $pRutaRptExa = isset($_REQUEST['pRutaRptExa'])?$_REQUEST['pRutaRptExa']:null;
    $pRutaRptRem = isset($_REQUEST['pRutaRptRem'])?$_REQUEST['pRutaRptRem']:null;
    $contenido = isset($_REQUEST['CAMPOS'])?$_REQUEST['CAMPOS']:null;
    $pEvolucion = stripslashes(utf8_encode(str_replace('"', '""',nl2br($contenido))));
    $pDiagppal = isset($_REQUEST['pDiagppal'])?$_REQUEST['pDiagppal']:null;
    $pDiagrel1 = isset($_REQUEST['pDiagrel1'])?$_REQUEST['pDiagrel1']:null;
    $pDiagrel2 = isset($_REQUEST['pDiagrel2'])?$_REQUEST['pDiagrel2']:null;
    $pDiagrel3 = isset($_REQUEST['pDiagrel3'])?$_REQUEST['pDiagrel3']:null;
    $pTipodiag = isset($_REQUEST['pTipodiag'])?$_REQUEST['pTipodiag']:null;
    $pFinalidad = isset($_REQUEST['pFinalidad'])?$_REQUEST['pFinalidad']:null;
    $pCausa = isset($_REQUEST['pCausa'])?$_REQUEST['pCausa']:null;
    $pUsuario = isset($_REQUEST['pUsuario'])?$_REQUEST['pUsuario']:0;
    $pIdCliente = isset($_REQUEST['pIdCliente'])?$_REQUEST['pIdCliente']:0;
    $pIdPlan = isset($_REQUEST['pIdPlan'])?$_REQUEST['pIdPlan']:0;
    $pIdSubPlan = isset($_REQUEST['pIdSubPlan'])?$_REQUEST['pIdSubPlan']:0;
    $pIdContrato = isset($_REQUEST['pIdContrato'])?$_REQUEST['pIdContrato']:0;
    $pFormulacion = isset($_REQUEST['pFormulacion'])?$_REQUEST['pFormulacion']:1;
    if($pFormulacion == null || $pFormulacion == ""){
        $pFormulacion = 1;
    }
    $gBaseDatos = new ofiMySQLi();
    $gBaseDatos->conectar();
    $qry = "CALL sp_asistencial_add_evolucion('" . $pEmpresa . "','" . $pIPS . "','" . $pPaciente . "','" . $pProfesional . "','" . $pCAS . "','" . $pConsecutivoDetalle . "',\"" . $pFechaAtencion . "\",\"" . $pHoraApertura . "\",\"" . $pActividad . "\",\"" . $pPlantilla . "\",\"" . $pRutaRptHC . "\",\"" . $pRutaRptMx . "\",\"" . $pRutaRptExa . "\",\"" . $pRutaRptRem . "\",\"" . $pEvolucion . "\",\"" . $pDiagppal . "\",\"" . $pDiagrel1 . "\",\"" . $pDiagrel2 . "\",\"" . $pDiagrel3 . "\",\"" . $pTipodiag . "\",\"" . $pFinalidad . "\",\"" . $pCausa . "\",'" . $pUsuario . "','" . $pIdCliente . "','" . $pIdPlan . "','" . $pIdSubPlan . "','" . $pIdContrato . "')";
    //echo $qry;
    if(@mysqli_query($gBaseDatos->ConexionID, $qry))
        echo "{success: true, requestedId:'1'}";
    else
       echo "{success: true, requestedId:'0'}";
    $gBaseDatos->cerrar();   
}