<?php
    set_time_limit(700);
    require_once('../../../lib/tcpdf/config/lang/spa.php');
    require_once('../../../lib/tcpdf/tcpdf.php');
    require("../../../core/php/_database.php");
    require("../../../core/php/php_functions.php");
    header('Content-type: application/pdf; charset: UTF-8');
    session_start();
    $nomEmpresa = $_SESSION['NOM_EMPRESA'];
    $nomUsuario = $_SESSION['NOM_USUARIO'];
    $estructura = isset($_REQUEST['param'])?explode("¬", $_REQUEST['param']):"NA";
    if($estructura != "NA")
    {
        $pNomParametros = spNomParametrosMI($estructura,"NO");
        $NameParam = explode("¬", $pNomParametros);
        $pParametros = spParametrosMI($estructura,"NO");
        $DataParam = explode("¬", $pParametros);
        $pConsecutivoHC = 0;
        $items = count($NameParam);
        for ($i=0; $i<$items; $i++)
        {
            switch ($NameParam[$i]) 
            {
                case "intEmpresa":
                    if ($DataParam[$i] == "" || $DataParam[$i] == null || $DataParam[$i] == "null")
                        $pEmpresa = 0;
                    else
                        $pEmpresa = $DataParam[$i];
                    break;

                case "intIPS":
                    if ($DataParam[$i] == "" || $DataParam[$i] == null || $DataParam[$i] == "null")
                        $pIPS = 0;
                    else
                        $pIPS = $DataParam[$i];
                    break;

                case "intCliente":
                    if ($DataParam[$i] == "" || $DataParam[$i] == null || $DataParam[$i] == "null")
                        $pCliente = 0;
                    else
                        $pCliente = $DataParam[$i];
                    break;
                
                case "intAno":
                    if ($DataParam[$i] == "" || $DataParam[$i] == null || $DataParam[$i] == "null")
                        $pAno = 0;
                    else
                        $pAno = $DataParam[$i];
                    break;
                
                case "strPeriodo":
                    if ($DataParam[$i] == "" || $DataParam[$i] == null || $DataParam[$i] == "null")
                    {
                        $pMes = "0";
                    }else{
                        $pMes = $DataParam[$i];
                    }
                    break;
                    
                case "strPaciente":
                    if ($DataParam[$i] == "" || $DataParam[$i] == null || $DataParam[$i] == "null")
                    {
                        $pPaciente = 'Todos';
                    }else{
                        $pPaciente = $DataParam[$i];
                    }
                    break;

                default:
                    break;
            }
        }
    }else{
        $pEmpresa = isset($_REQUEST['pEmpresa'])?$_REQUEST['pEmpresa']:null;
        $pIPS = isset($_REQUEST['pIPS'])?$_REQUEST['pIPS']:null;
        $pConsecutivoHC = isset($_REQUEST['pConsecutivoHC'])?$_REQUEST['pConsecutivoHC']:0;
        $pCliente = isset($_REQUEST['pCliente'])?$_REQUEST['pCliente']:0;
        $pPaciente = isset($_REQUEST['pPaciente'])?$_REQUEST['pPaciente']:"Todos";
        $pAno = isset($_REQUEST['pAno'])?$_REQUEST['pAno']:0;
        $pMes = isset($_REQUEST['pMes'])?$_REQUEST['pMes']:"0";
    }
   
    //create new PDF document
    $pdf = new TCPDF("P", PDF_UNIT, "CARTA", true, 'UTF-8', false);
    $pdf->SetCreator(PDF_CREATOR);
    $pdf->SetAuthor('Sistemas Ofisalud © - 2011');
    $pdf->SetTitle('ASISTENCIAL');
    $pdf->SetSubject('Informe Mensual de Terapia Neurodesarrollo');

    // set default header data
    $pdf->pAlineacionEncabezado = "P";
    $pdf->pTituloInforme = "INFORME MENSUAL DE TERAPIA DE NEURODESARROLLO";
    $pdf->pImprimeLogo = "NO";
    $pdf->pAnchoTxtPagina = 270;
    $pdf->pNomEmpresa = $_SESSION['NOM_EMPRESA'];
    $pdf->pNomSede = $_SESSION['NOM_SEDE'];
    $pdf->pNomIPS = $_SESSION['NOM_IPS'];
    $pdf->pMargenPie = -20;
    $pdf->pLogoCliente = "../../../empresas/" . $_SESSION['ID_EMPRESA'] . "/logo/logoenc.gif";

    $pdf->SetHeaderData($pdf->pLogoCliente, PDF_HEADER_LOGO_WIDTH, $pdf->pTituloInforme, PDF_HEADER_STRING);
    // set header and footer fonts
    $pdf->setHeaderFont(Array(PDF_FONT_NAME_MAIN, '', PDF_FONT_SIZE_MAIN));
    $pdf->setFooterFont(Array(PDF_FONT_NAME_DATA, '', PDF_FONT_SIZE_DATA));
    // set default monospaced font
    $pdf->SetDefaultMonospacedFont(PDF_FONT_MONOSPACED);
    //set margins
    $pdf->SetMargins(PDF_MARGIN_LEFT, PDF_MARGIN_TOP, PDF_MARGIN_RIGHT);
    $pdf->SetHeaderMargin(PDF_MARGIN_HEADER);
    $pdf->SetFooterMargin(PDF_MARGIN_FOOTER);
    //set auto page breaks
    $pdf->SetAutoPageBreak(TRUE, PDF_MARGIN_BOTTOM);
    //set image scale factor
    $pdf->setImageScale(PDF_IMAGE_SCALE_RATIO);
    //set some language-dependent strings
    $pdf->setLanguageArray($l);
    // set default font subsetting mode
    
    $gBaseDatos = new ofiMySQLi();
    // Cargar Datos del Paciente
    $gBaseDatos->conectar();
    $qry = "CALL sp_neurodesa_resumenhc_print('" . $pEmpresa . "','" . $pIPS . "','" . $pConsecutivoHC . "','" . $pCliente . "','" . $pPaciente . "','" . $pAno . "',\"" . $pMes . "\")";
    $gBaseDatos->QryID = @mysqli_query($gBaseDatos->ConexionID, $qry);
    while ($row = @mysqli_fetch_assoc($gBaseDatos->QryID))
    {
        $pPaciente = $row["TipDoc"] . " " . $row["Documento"] . " - " . utf8_decode($row["PrimerNombre"]) . " " . utf8_decode($row["SegundoNombre"]) . " " . utf8_decode($row["PrimerApellido"]) . " " . utf8_decode($row["SegundoApellido"]) . " Genero: (" . $row["Genero"] . ") FechaNac: (" . $row["FecNac"] . ")";
        $pCliente = utf8_decode($row["Cliente"]);
        $pPeriodo = utf8_decode($row["Periodo"]);
        $pEvolucionTerapiaFisica = utf8_decode($row["EvaluacionTerapiaFisica"]);
        $pProfeEvolucionTerapiaFisica = utf8_decode($row["ProfesionalFonoaudiologia"]);
        $pNomProfeEvolucionTerapiaFisica = utf8_decode($row["profeTerapiaFisicaNom"]);
        $pEvolucionFonoaudiologia = utf8_decode($row["EvaluacionFonoaudiologia"]);
        $pProfeEvolucionFonoaudiologia = utf8_decode($row["ProfesionalFonoaudiologia"]);
        $pNomProfeEvolucionFonoaudiologia = utf8_decode($row["profeTerapiaFonoNom"]);
        $pEvolucionTerapiaOcupacional = utf8_decode($row["EvaluacionTerapiaOcupacional"]);
        $pProfeTerapiaOcupacional = utf8_decode($row["ProfesionalTerapiaOcupacional"]);
        $pNomProfeTerapiaOcupacional = utf8_decode($row["profeTerapiaOcupaNom"]);
        $pEvolucionConclusiones = utf8_decode($row["Conlusiones"]);
        $pProfeConclusiones = utf8_decode($row["ProfesionalConclusiones"]);
        $pNomProfeConclusiones = utf8_decode($row["profeTerapiaConclusionNom"]);
        
        $pdf->setFontSubsetting(true);
        $pdf->SetFont('dejavusans', '', 14, '', true);

        $pdf->AddPage();
        $pdf->Ln(6.5);
        $pdf->SetFont(PDF_FONT_NAME_MAIN, '', 7);
        $mostrarHC = '<table border="0" style="font-size:24px; color:#000;">';
        $mostrarHC .= '<tr>';
        $mostrarHC .= '<td width="60">Paciente:</td>';
        $mostrarHC .= '<td>' . $pPaciente  . '</td>';
        $mostrarHC .= '</tr>';
        $mostrarHC .= '<tr>';
        $mostrarHC .= '<td>Cliente:</td>';
        $mostrarHC .= '<td>' . $pCliente . '</td>';
        $mostrarHC .= '</tr>';
        $mostrarHC .= '<tr>';
        $mostrarHC .= '<td>Periodo:</td>';
        $mostrarHC .= '<td>' . $pPeriodo . '</td>';
        $mostrarHC .= '</tr>';
        $mostrarHC .= '</table><hr>';

        $mostrarHC .= '<span style="text-decoration:underline; font-size:24px; color:#000; font-weight:bolder">EVALUACION FINAL TERAPIA FISICA:</span><br>';
        $mostrarHC .= '<span style="font-size:24px; color:#000;">' . $pEvolucionTerapiaFisica . '</span><br><br>';
        if (file_exists('../../../empresas/' . $_SESSION['ID_EMPRESA'] . '/firmas/' . $pProfeEvolucionTerapiaFisica . '.png')) 
            $mostrarHC .= '<img src="../../../empresas/' . $_SESSION['ID_EMPRESA'] . '/firmas/' . $pProfeEvolucionTerapiaFisica . '.png" align="left" width="80" height="20" /><br>';
        $mostrarHC .= '<span style="font-size:24px; color:#000;">Responsable: ' . $pNomProfeEvolucionTerapiaFisica . '</span><br><br>';

        $mostrarHC .= '<span style="text-decoration:underline; font-size:24px; color:#000; font-weight:bolder">EVALUACION FINAL FONOAUDIOLOGIA:</span><br>';
        $mostrarHC .= '<span style="font-size:24px; color:#000;">' . $pEvolucionFonoaudiologia . '</span><br><br>';
        if (file_exists('../../../empresas/' . $_SESSION['ID_EMPRESA'] . '/firmas/' . $pProfeEvolucionFonoaudiologia . '.png')) 
            $mostrarHC .= '<img src="../../../empresas/' . $_SESSION['ID_EMPRESA'] . '/firmas/' . $pProfeEvolucionFonoaudiologia . '.png" align="left" width="80" height="20" /><br>';
        $mostrarHC .= '<span style="font-size:24px; color:#000;">Responsable: ' . $pNomProfeEvolucionFonoaudiologia . '</span><br><br>';

        $mostrarHC .= '<span style="text-decoration:underline; font-size:24px; color:#000; font-weight:bolder">EVALUACION FINAL TERAPIA OCUPACIONAL:</span><br>';
        $mostrarHC .= '<span style="font-size:24px; color:#000;">' . $pEvolucionTerapiaOcupacional . '</span><br><br>';
        if (file_exists('../../../empresas/' . $_SESSION['ID_EMPRESA'] . '/firmas/' . $pProfeEvolucionTerapiaOcupacional . '.png')) 
            $mostrarHC .= '<img src="../../../empresas/' . $_SESSION['ID_EMPRESA'] . '/firmas/' . $pProfeEvolucionTerapiaOcupacional . '.png" align="left" width="80" height="20"/><br>';
        $mostrarHC .= '<span style="font-size:24px; color:#000;">Responsable: ' . $pNomProfeTerapiaOcupacional . '</span><br><br>';

        $mostrarHC .= '<span style="text-decoration:underline; font-size:24px; color:#000; font-weight:bolder">CONCLUSIONES:</span><br>';
        $mostrarHC .= '<span style="font-size:24px; color:#000;">' . $pEvolucionConclusiones . '</span><br><br>';
        if (file_exists('../../../empresas/' . $_SESSION['ID_EMPRESA'] . '/firmas/' . $pProfeConclusiones . '.png')) 
            $mostrarHC .= '<img src="../../../empresas/' . $_SESSION['ID_EMPRESA'] . '/firmas/' . $pProfeConclusiones . '.png" align="left" width="80" height="20" /><br>';
        $mostrarHC .= '<span style="font-size:24px; color:#000;">Responsable: ' . $pNomProfeConclusiones . '</span>';
        $pdf->writeHTML($mostrarHC, true, false, false, false, '');
    
    }
    $gBaseDatos->liberar();
    $gBaseDatos->cerrar();
    $pdf->Output('InformeMensualNeurodesarrollo.pdf', 'I');
    
?>
