<?php

function FormatoDemanda001(&$pdf, &$pProfesional, &$pNomProfesional, &$pnomEspecialidad, &$pRegistroProfesional, &$pImprimeFirmas, $pPrestador, $pIPS, $pPaciente, $pConsecutivoHC, $pNomAplicacion, $IdContador, $pCAS=0){ //Formato General de Impresion de Historia Clinica
    if($pPaciente != null || $pPaciente != ""){
        $pControlSalto = 30;
        //Creacion Pagina de Demanda Inducida y Seguimiento
        unset($rowHC);
        $gBaseDatos = new ofiMySQLi();
        $gBaseDatos->conectar();
        $qry = "CALL sp_demandasegto_grid('" . $pPaciente . "')";
        $gBaseDatos->QryID = @mysqli_query($gBaseDatos->ConexionID, $qry);
        while ($rowHC[] = @mysqli_fetch_assoc($gBaseDatos->QryID));
        $gBaseDatos->liberar();
        $gBaseDatos->cerrar();
        $pRegistros = count($rowHC);
        $pdf->SetFont('dejavusans', '', 14, '', true);
        $nomPrograma = "";
        $i = 0;
        if($pRegistros > 0){
            EncabezadoDemanda($pdf, $rowHC, $i, $rowcount, $contador, $pDesde, $pHasta, $pNomAplicacion);
            for($i=0;$i<$pRegistros;$i++){
                if($rowHC[$i]["nomPaciente"] != ""){
                    if($nomPrograma != $rowHC[$i]["Programa"]){
                        if ($pdf->GetY() >= ($pdf->getPageHeight()-$pControlSalto)){
                            EncabezadoDemanda($pdf, $rowHC, $i, $rowcount, $contador, $pDesde, $pHasta, $pNomAplicacion);
                        }else{
                            $pdf->writeHTML('<br><hr>', true, false, false, false, '');
                            if ($pdf->GetY() >= ($pdf->getPageHeight()-$pControlSalto)){
                                EncabezadoDemanda($pdf, $rowHC, $i, $rowcount, $contador, $pDesde, $pHasta, $pNomAplicacion);
                            }
                        }
                        $pdf->SetFont(PDF_FONT_NAME_MAIN, '', 7);
                        $pdf->Ln(2);
                        $mostrarHC = '<span colspan="2" style="font-size:32px; color:darkblue; font-weight:bolder;">PROGRAMA: ' . utf8_decode($rowHC[$i]["Programa"]) . '</span><br><hr>';
                        $pdf->writeHTML($mostrarHC, true, false, false, false, '');
                        if ($pdf->GetY() >= ($pdf->getPageHeight()-$pControlSalto)){
                            EncabezadoDemanda($pdf, $rowHC, $i, $rowcount, $contador, $pDesde, $pHasta, $pNomAplicacion);
                        }
                        $mostrarHC = '<table border="1" cellpadding="3">';
                        $mostrarHC .= '<tr>';
                        $mostrarHC .= '<td width="70" style="font-size:30px; font-weight:bolder;" bgcolor="#F2F2F2">Fecha:</td>';
                        $mostrarHC .= '<td width="100" style="font-size:30px; font-weight:bolder;" bgcolor="#F2F2F2">Tipo Contacto:</td>';
                        $mostrarHC .= '<td width="60" style="font-size:30px; font-weight:bolder;" bgcolor="#F2F2F2">Efectivo:</td>';
                        $mostrarHC .= '<td width="110" style="font-size:30px; font-weight:bolder;" bgcolor="#F2F2F2">Persona Contacto:</td>';
                        $mostrarHC .= '<td width="200" style="font-size:30px; font-weight:bolder;" bgcolor="#F2F2F2">Observaciones:</td>';
                        $mostrarHC .= '<td width="200" style="font-size:30px; font-weight:bolder;" bgcolor="#F2F2F2">Proximo Contacto:</td>';
                        $mostrarHC .= '<td width="190" style="font-size:30px; font-weight:bolder;" bgcolor="#F2F2F2">Responsable:</td>';
                        $mostrarHC .= '</tr>';
                        $mostrarHC .= '</table>';
                        $pdf->writeHTML($mostrarHC, true, false, false, false, '');
                        if ($pdf->GetY() >= ($pdf->getPageHeight()-$pControlSalto)){
                            EncabezadoDemanda($pdf, $rowHC, $i, $rowcount, $contador, $pDesde, $pHasta, $pNomAplicacion);
                        }
                        $pdf->Ln(-3);
                    }
                    $nomPrograma = $rowHC[$i]["Programa"];
                    $mostrarHC = '<table border="1" cellpadding="3">';
                    $mostrarHC .= '<tr>';
                    $mostrarHC .= '<td width="70" style="font-size:30px;">' . $rowHC[$i]["FechaContacto"] . '<br>' . $rowHC[$i]["HoraContacto"] . '</td>';
                    $mostrarHC .= '<td width="100" style="font-size:30px;">' . $rowHC[$i]["TipoContacto"] . '</td>';
                    $mostrarHC .= '<td width="60" style="font-size:30px;">' . $rowHC[$i]["ContactoEfectivo"] . '</td>';
                    if($rowHC[$i]["Parentesco"] != "" && $rowHC[$i]["Parentesco"] != null){
                        $mostrarHC .= '<td width="110" style="font-size:30px;">' . $rowHC[$i]["PersonaContacto"] . '<br>' . $rowHC[$i]["Parentesco"] . '</td>';
                    }else{
                        $mostrarHC .= '<td width="110" style="font-size:30px;">' . $rowHC[$i]["PersonaContacto"] . '</td>';
                    }
                    if($rowHC[$i]["CAS"] != "" && $rowHC[$i]["CAS"] != null && $rowHC[$i]["CAS"] != 0){
                        $mostrarHC .= '<td width="200" style="font-size:30px;">' . $rowHC[$i]["TipoRegistro"] . '<br>' . $rowHC[$i]["Observacion"] . '<br><br><b>CAS proxima cita: ' . $rowHC[$i]["CAS"] . '</b></td>';
                    }else{
                        $mostrarHC .= '<td width="200" style="font-size:30px;">' . $rowHC[$i]["TipoRegistro"] . '<br>' . $rowHC[$i]["Observacion"] . '</td>';
                    }
                    if($rowHC[$i]["ProximoContacto"] != "0000-00-00"){
                        $mostrarHC .= '<td width="200" style="font-size:30px;">' . $rowHC[$i]["ProximoContacto"] . ' - '  . $rowHC[$i]["MotivoProximoContacto"] . '</td>';
                    }else{
                        $mostrarHC .= '<td width="200" style="font-size:30px;">' . $rowHC[$i]["RealizaProximoContrato"] . '</td>';
                    }
                    $mostrarHC .= '<td width="190" style="font-size:30px;">' . $rowHC[$i]["Usuario"] . '</td>';
                    $mostrarHC .= '</tr>';
                    $mostrarHC .= '</table>';
                    $pdf->writeHTML($mostrarHC, true, false, false, false, '');
                    if($pdf->GetY() >= ($pdf->getPageHeight()-$pControlSalto)){
                        EncabezadoDemanda($pdf, $rowHC, $i, $rowcount, $contador, $pDesde, $pHasta, $pNomAplicacion);
                    }
                    $pdf->Ln(-3);
                }
            }
        }
    }
}

function EncabezadoDemanda(&$pdf, &$rowHC, &$i, &$rowcount, &$contador, &$pDesde, &$pHasta, $pNomAplicacion){
    //RAFAEL
    $Alineacion = "L";
    $FormatoPagina = "CARTA";
    if($rowHC[$i]["DireccionIPS"] != "" && $rowHC[$i]["DireccionIPS"] != null){
        $pdf->pDirEmpresa = $rowHC[$i]["DireccionIPS"] . "<br>";
    }
    if($rowHC[$i]["TelefonoIPS"] != "" && $rowHC[$i]["TelefonoIPS"] != null){
        $pdf->pTelEmpresa = $rowHC[$i]["TelefonoIPS"];
    }
    if($rowHC[$i]["DescMunicipioIPS"] != "" && $rowHC[$i]["DescMunicipioIPS"] != null){
        $pdf->pCiuEmpresa = $rowHC[$i]["DescMunicipioIPS"] . " - " . $rowHC[$i]["DescDeptoIPS"];
    }
    $pdf->AddPage($Alineacion,$FormatoPagina);
    $pdf->Ln(2);
    $pdf->SetFont(PDF_FONT_NAME_MAIN, '', 7);
    $EncabezadoHTML = '<table cellspacing="0" border="0" style="font-size:24px; color:#000;">';
    $EncabezadoHTML .= '<tr>';
    $EncabezadoHTML .= '<td>';
    $EncabezadoHTML .= '<span style="font-size:44px; color:#000; font-weight:bold">' . utf8_decode($pdf->pNomEmpresa) . '</span><br>';
    if($pdf->pEspEmpresa != null || $pdf->pEspEmpresa != "")
            $EncabezadoHTML .= '<span style="font-size:34px; color:#000;">' . utf8_decode($pdf->pEspEmpresa) . '</span><br>';
    if($pdf->pTDocEmpresa == "NI"){
        $tipodoc = "NIT: ";
        $EncabezadoHTML .= '<span style="font-size:34px; color:#000;">' . $tipodoc . $pdf->pDocEmpresa . '</span><br>';
    }
    $EncabezadoHTML .= '<span style="font-size:34px; color:#000;">' . $pdf->pDirEmpresa . ' - ' . $pdf->pTelEmpresa . '</span><br>';
    $EncabezadoHTML .= '<span style="font-size:34px; color:#000;">' . $pdf->pCiuEmpresa . '</span><br><br>';
    $EncabezadoHTML .= '<span style="font-size:29px; color:#000;"><b>PACIENTE:&nbsp;&nbsp;</b>' . utf8_decode($rowHC[$i]["TipDoc"]) . ' ' . utf8_decode($rowHC[$i]["Documento"]) . ' - ' . utf8_decode($rowHC[$i]["Nom1"]) . ' ' . utf8_decode($rowHC[$i]["Nom2"]) . ' ' . utf8_decode($rowHC[$i]["Ape1"]) . ' ' . utf8_decode($rowHC[$i]["Ape2"]) . '</span><br>';
    if (utf8_decode($rowHC[$i]["Genero"]) == "M"){
        $EncabezadoHTML .= '<span style="font-size:29px; color:#000;"><b>GENERO:&nbsp;&nbsp;</b>MASCULINO</span><br>';
    }else if (utf8_decode($rowHC[$i]["Genero"]) == "F"){
        $EncabezadoHTML .= '<span style="font-size:29px; color:#000;"><b>GENERO:&nbsp;&nbsp;</b>FEMENINO</span><br>';
    }
    $EncabezadoHTML .= '<span style="font-size:29px; color:#000;"><b>FECHA NACIMIENTO:&nbsp;&nbsp;</b>' . $rowHC[$i]["FecNac"];
    $EdadCompleta = "";
	
    $EdadCompleta = CalcularEdadComleta( $rowHC[$i]["FecNac"], date('Y-m-d'));
    if($EdadCompleta != "" && $EdadCompleta != null){
        if((int)substr($rowHC[$i]["FecNac"], 0, 4) > 1900){
            $EncabezadoHTML .= ' - Edad: ' . $EdadCompleta;
        }
    }
    $EncabezadoHTML .= '</span>';
    $EncabezadoHTML .= '</td>';

    //COL2
    $EncabezadoHTML .= '<td align="right">';
    if($pNomAplicacion == "OfiMedical"){
        if (file_exists("../../../consultoriovirtual/" . $_SESSION['IDBD'] . "/logo/logoenc.gif")) {
            $EncabezadoHTML .= '<img src="../../../consultoriovirtual/' . $_SESSION['IDBD'] . '/logo/logoenc.gif" align="right"/>';
            $EncabezadoHTML .= '<br>';
        }else{
            if (file_exists("../../../../consultoriovirtual/" . $_SESSION['IDBD'] . "/logo/logoenc.gif")) {
                $EncabezadoHTML .= '<img src="../../../../consultoriovirtual/' . $_SESSION['IDBD'] . '/logo/logoenc.gif" align="right"/>';
                $EncabezadoHTML .= '<br>';
            }
        }
    }else{
        if (file_exists("../../../empresas/" . $_SESSION['ID_EMPRESA'] . "/logo/logoenc.gif")) {
            $EncabezadoHTML .= '<img src="../../../empresas/' . $_SESSION['ID_EMPRESA'] . '/logo/logoenc.gif" align="right"/>';
            $EncabezadoHTML .= '<br>';
        }else{
            if (file_exists("../../../../empresas/" . $_SESSION['ID_EMPRESA'] . "/logo/logoenc.gif")) {
                $EncabezadoHTML .= '<img src="../../../../empresas/' . $_SESSION['ID_EMPRESA'] . '/logo/logoenc.gif" align="right"/>';
                $EncabezadoHTML .= '<br>';
            }
        }

    }
    $EncabezadoHTML .= '<span align="rigth" style="font-size:44px; color:#000; font-weight:bold">DEMANDA INDUCIDA Y SEGUIMIENTO</span><br>';
    if (file_exists('../../../consultoriovirtual/' . $_SESSION['IDBD']  . '/pacientes/' . $rowHC[$i]["Paciente"] . '/uploads/foto.jpg')) {
        $EncabezadoHTML .= '<br><img src="../../../consultoriovirtual/' . $_SESSION['IDBD']  . '/pacientes/' . $rowHC[$i]["Paciente"] . '/uploads/foto.jpg" width="130" height="100"/><br>';
    }else{
        if (file_exists('../../../empresas/' . $_SESSION['ID_EMPRESA']  . '/pacientes/' . $rowHC[$i]["Paciente"] . '/uploads/foto.jpg')) {
            $EncabezadoHTML .= '<br><img src="../../../empresas/' . $_SESSION['ID_EMPRESA']  . '/pacientes/' . $rowHC[$i]["Paciente"] . '/uploads/foto.jpg" width="130" height="100"/><br>';
        }
    }
    $EncabezadoHTML .= '<span align="rigth" style="font-size:26px; color:#000; font-weight:bold">Copia Controlada</span>';
    $EncabezadoHTML .= '<br><span align="rigth" style="font-size:20px; color:#000;">' . $_SESSION['COD_USUARIO'] . ' - ' . date('Y-m-d H:i') . '</span>';
    $EncabezadoHTML .= '</td>';
    $EncabezadoHTML .= '</tr>';
    $EncabezadoHTML .= '</table>';
    // $EncabezadoHTML .= '<hr class="linea">';
    $pdf->writeHTML($EncabezadoHTML, true, false, false, false, '');
}

?>