<?php

/*
* @category    Controlador Plantillas HC
* @package     OfiClinic Web
* @author      Jorge Ancizar Galeano Ruiz<desarrollo@ofisalud.com>
* @copyright   2010 Jorge Ancizar Galeano Ruiz
* @version     OfiClinic Web 1.0
* @license     COMERCIAL
* @link        http://www.ofisalud.com
* @country     Colombia
* @telephone   3016398114
*/
header("Content-Type: text/plain; charset=UTF-8");
require("../../../core/php/_database.php");
require("../../../core/php/php_functions.php");
session_start();

$task = '';
if ( isset($_POST['task'])){
  $task = $_POST['task'];
}
switch($task){
    case "ImportarUltimaAtencion":
        ImportarUltimaAtencion();
        break;
    case "ImportarAntecedentesPersonalesOfiClinic001":
        ImportarAntecedentesOfiClinic("PersonalesOfiClinic001");
        break;
    case "ImportarAntecedentesFamiliares":
        ImportarAntecedentes("Familiares");
        break;
    case "ImportarAntecedentesPersonales":
        ImportarAntecedentes("Personales");
        break;
    case "ImportarVariablesAntropometricas":
        ImportarAntecedentes("VariablesAntropometricas");
        break;
    case "ImportarVariablesAntropometricas2013":
        ImportarAntecedentes("VariablesAntropometricas2013");
        break;
    case "ImportarUltimaFormula":
        ImportarUltimaFormula();
        break;
    case "VerRemSolicitadosxHC_ofimedical":
        VerRemSolicitadosxHC_ofimedical();
        break;
    case "VerMxSolicitadosxHC_ofimedical":
        VerMxSolicitadosxHC_ofimedical();
        break;
    case "VerExaSolicitadosxHC_ofimedical":
        VerExaSolicitadosxHC_ofimedical();
        break;
    case "guardar_tomacitologia":
        GuardarTomaCitologia();
        break;
    case "modificar_tomacitologia":
        ModificarTomaCitologia();
        break;
    case "guardar":
        GuardarHC();
        break;
    case "guardar_pediatria":
        GuardarPediatriaHC();
        break;
    case "guardarAnotacionHC":
        GuardarAnotacionHC();
        break;
    case "modificar_pediatria":
        ModificarPediatriaHC();
        break;
    case "modificar":
        ModificarHC();
        break;
    case "modificarAnotacionHC":
        ModificarAnotacionHC();
        break;
    case "guardar_proc":
        GuardarProc();
        break;
    case "modificar_proc":
        ModificarProc();
        break;
    case "guardar_barthel":
        GuardarBarthelHC();
        break;
    case "guardar_hachinski":
        GuardarHachinskiHC();
        break;
    case "guardar_folstein":
        GuardarFolsteinHC();
        break;
    case "guardar_lawton":
        GuardarLawtonHC();
        break;
    case "guardar_yesavage":
        GuardarYesavageHC();
        break;
    case "VerHistorialxPaciente":
        VerHistorialHCxPaciente();
        break;
    case "VerHistorialxPacienteFiltro":
        VerHistorialHCxPacienteFiltro();
        break;
    case "VerHistorialxPacienteSinEvolucionar":
        VerHistorialHCxPacienteSinEvolucionar();
        break;
    case "crear_resumen_neurodesarrollo":
        CrearResumenNeurodesarrollo();
        break;
    case "ver_resumen_neurodesarrollo":
        VerResumenNeurodesarrollo();
        break;
    case "guardar_resumen_neurodesarrollo":
        GuardarResumenNeurodesarrollo();
        break;
    case "VerHistorialMedicamentosxPaciente":
        VerHistorialMedicamentosxPaciente();
        break;
    case "CARGAR_ULTIMO_DIAGNOSTICO":
        CargarUltimoDiagnostico();
        break;
    case "CARGAR_ULTIMO_INFORME_MANSUAL_NEURODESA":
        CargarUltimoInformeMensualNeuroDesarrollo();
        break;
    case "VER_PACIENTES_OBSERVACION_HOSPITALIZA":
        VerPacientesObservacionHospitalizacion();
        break;
    case "RIPSAU_INGRESO_LOAD":
        ripsauLoad();
        break;
    case "RIPSAH_INGRESO_LOAD":
        ripsahLoad();
        break;
    case "RIPSAU_INGRESO_VERIFICA":
        ripsauVerifica();
        break;
    case "RIPSAH_INGRESO_VERIFICA":
        ripsahVerifica();
        break;
    case "RIPSAU_INGRESO_GUARDAR":
        ripsauGuardar("Ingreso");
        break;
    case "RIPSAH_INGRESO_GUARDAR":
        ripsahGuardar("Ingreso");
        break;
    case "RIPSAU_EGRESO_GUARDAR":
        ripsauGuardar("Egreso");
        break;
    case "RIPSAH_EGRESO_GUARDAR":
        ripsahGuardar("Egreso");
        break;
    case "RIPSAN_INGRESO_GUARDAR":
        ripsanGuardar();
        break;
    case "RIPSAN_INGRESO_LOAD":
        ripsanLoad();
        break;
    case "VerReporteParaclinicosxPaciente":
        VerReporteParaclinicosxPaciente();
        break;
    case "ELIMINAR_REPORTEEXA":
        EliminarReporteParaclinicosxPacientexId();
        break;
    case "GUARDAR_REPORTE_PARACLINICOS":
        GuardarReporteParaclinicosxPaciente();
        break;
    case "LISTAR_CONTROL_SIGNOS_VITALES":
        ListarControlSignosVitales();
        break;
    case "CREAR_SIGNOS_VITALES":
        CrearSignosVitales();
        break;
    default:
        echo "{failure:true}";
        break;
}

function ListarControlSignosVitales(){
    $pPaciente = isset($_REQUEST['pPaciente'])?$_REQUEST['pPaciente']:0;
    $pCAS = isset($_REQUEST['pCAS'])?$_REQUEST['pCAS']:0;
    if($pPaciente == "" || $pPaciente == null){
        $pPaciente = 0;
    }
    $pIPS = isset($_REQUEST['pIPS'])?$_REQUEST['pIPS']:0;
    $gBaseDatos = new ofiMySQLi();
    $gBaseDatos->conectar();
    $qry = "CALL sp_asistencial_tomasignos_hosp_listar('" . $pPaciente . "','" . $pIPS . "','" . $pCAS . "')";
    //echo $qry;
    @mysqli_query("\"SET NAMES UTF8\"");
    $gBaseDatos->QryID = @mysqli_query($gBaseDatos->ConexionID, $qry);
    $arr = array();
    while($row = @mysqli_fetch_assoc($gBaseDatos->QryID))
    {
        $nRow = $row;
        foreach($row as $key => $val)
        {
            $nRow[$key] = utf8_decode($val);
        }
        $arr[] = $nRow;
    }
    $gBaseDatos->liberar();
    $gBaseDatos->cerrar();
    $jsonresult = JEncode($arr);
    if (!is_null($jsonresult))
        echo '({"total":"0","results":'. $jsonresult .'})';
}

function CrearSignosVitales(){
    $pEmpresa = isset($_REQUEST['pEmpresa'])?$_REQUEST['pEmpresa']:0;
    $pIPS = isset($_REQUEST['pIPS'])?$_REQUEST['pIPS']:0;
    $pPaciente = isset($_REQUEST['pPaciente'])?$_REQUEST['pPaciente']:0;
    $pProfesional = isset($_REQUEST['pProfesional'])?$_REQUEST['pProfesional']:0;
    $pFechaAtencion = isset($_REQUEST['pFechaAtencion'])?$_REQUEST['pFechaAtencion']:null;
    $pHoraAtencion = isset($_REQUEST['pHoraAtencion'])?$_REQUEST['pHoraAtencion']:null;
    $pCAS = isset($_REQUEST['pCAS'])?$_REQUEST['pCAS']:0;
    $pTASIS = isset($_REQUEST['pTASIS'])?$_REQUEST['pTASIS']:0;
    $pTADIAS = isset($_REQUEST['pTADIAS'])?$_REQUEST['pTADIAS']:0;
    $pTemperatura = isset($_REQUEST['pTemperatura'])?$_REQUEST['pTemperatura']:0;
    $pSpO2 = isset($_REQUEST['pSpO2'])?$_REQUEST['pSpO2']:0;
    $pGlucometria = isset($_REQUEST['pGlucometria'])?$_REQUEST['pGlucometria']:0;
    $pFC = isset($_REQUEST['pFC'])?$_REQUEST['pFC']:0;
    $pFR = isset($_REQUEST['pFR'])?$_REQUEST['pFR']:0;
    $pLiquidosEliminacion = isset($_REQUEST['pLiquidosEliminacion'])?$_REQUEST['pLiquidosEliminacion']:0;
    $pLiquidosAdministrados = isset($_REQUEST['pLiquidosAdministrados'])?$_REQUEST['pLiquidosAdministrados']:0;
    $pLiquidosBalance = isset($_REQUEST['pLiquidosBalance'])?$_REQUEST['pLiquidosBalance']:0;
    $pDeposiciones = isset($_REQUEST['pDeposiciones'])?$_REQUEST['pDeposiciones']:null;
    $pObservaciones = isset($_REQUEST['pObservaciones'])?$_REQUEST['pObservaciones']:null;
    $pUsuario = isset($_REQUEST['pUsuario'])?$_REQUEST['pUsuario']:0;
    $gBaseDatos = new ofiMySQLi();
    $gBaseDatos->conectar();
    $qry = "CALL sp_asistencial_tomasignos_hosp_add('" . $pEmpresa . "','" . $pIPS . "','" . $pPaciente . "','" . $pProfesional . "',\"" . $pFechaAtencion . "\",'" . $pHoraAtencion . "','" . $pCAS . "','" . $pTASIS . "','" . $pTADIAS . "','" . $pTemperatura . "','" . $pSpO2 . "','" . $pGlucometria . "','" . $pFC . "','" . $pFR . "','" . $pLiquidosEliminacion . "','" . $pLiquidosAdministrados . "','" . $pLiquidosBalance . "','" . $pDeposiciones . "','" . $pObservaciones . "','" . $pUsuario . "')";
    //echo $qry;
    if(@mysqli_query($gBaseDatos->ConexionID, $qry))
        echo "{success: true, requestedId:'1'}";
    else
       echo "{success: true, requestedId:'0'}";
    $gBaseDatos->cerrar();   
}

function GuardarReporteParaclinicosxPaciente(){
    $pPaciente = isset($_REQUEST['pPaciente']) ? $_REQUEST['pPaciente'] :0;
    $pCAS = isset($_REQUEST['pCAS']) ? $_REQUEST['pCAS'] :0;
    $pUsuario = isset($_REQUEST['pUsuario']) ? $_REQUEST['pUsuario'] :0;
    $pIdConsecutivo = isset($_REQUEST['pIdConsecutivo']) ? $_REQUEST['pIdConsecutivo'] :0;
    $pConceptoOfiMedical = isset($_REQUEST['pConceptoOfiMedical']) ? $_REQUEST['pConceptoOfiMedical'] :0;
    $pNomConceptoOfiMedical = isset($_REQUEST['pNomConceptoOfiMedical']) ? $_REQUEST['pNomConceptoOfiMedical'] :null;
    $pNomQuienSolicita = isset($_REQUEST['pNomQuienSolicita']) ? $_REQUEST['pNomQuienSolicita'] :null;
    $pFecSolicitud = isset($_REQUEST['pFecSolicitud']) ? $_REQUEST['pFecSolicitud'] :null;
    $pFecRealizacion = isset($_REQUEST['pFecRealizacion']) ? $_REQUEST['pFecRealizacion'] :null;
    $pResultado = isset($_REQUEST['pResultado']) ? $_REQUEST['pResultado'] :null;
    $pValor = isset($_REQUEST['pValor']) ? $_REQUEST['pValor'] :null;
    $pClasificacion = isset($_REQUEST['pClasificacion']) ? $_REQUEST['pClasificacion'] :null;
    $pObservaciones = isset($_REQUEST['pObservaciones']) ? $_REQUEST['pObservaciones'] :null;
    $qry = "CALL sp_reporteparaclinicos_add('" . $pPaciente . "','" . $pCAS . "','" . $pUsuario . "','" . $pIdConsecutivo . "','" . $pConceptoOfiMedical . "',\"" . $pNomConceptoOfiMedical . "\",\"" . $pNomQuienSolicita . "\",\"" . $pFecSolicitud . "\",\"" . $pFecRealizacion . "\",\"" . $pResultado . "\",'" . $pValor . "',\"" . $pClasificacion . "\",\"" . $pObservaciones . "\")";
    //echo $qry;
    $gBaseDatos = new ofiMySQLi();
    $gBaseDatos->conectar();
    if(@mysqli_query($gBaseDatos->ConexionID, $qry))
        echo "{success: true, requestedId:'1'}";
    else
       echo "{success: true, requestedId:'0'}";
    $gBaseDatos->cerrar();
}

function EliminarReporteParaclinicosxPacientexId(){
    $pIdReporte = isset($_REQUEST['pIdReporte'])?$_REQUEST['pIdReporte']:0;
    $gBaseDatos = new ofiMySQLi();
    $gBaseDatos->conectar();
    $qry = "CALL sp_reporteparaclinicos_del('" . $pIdReporte . "')";
    if(@mysqli_query($gBaseDatos->ConexionID, $qry))
        echo '1';
    else
        echo '0';
    $gBaseDatos->cerrar();
}

function VerReporteParaclinicosxPaciente(){
    $pPaciente = isset($_REQUEST['pPaciente'])?$_REQUEST['pPaciente']:0;
    $paramP1 = isset($_REQUEST['paramP1'])?$_REQUEST['paramP1']:0;
    if($pPaciente == "" || $pPaciente == null){
        $pPaciente = 0;
    }
    if($pPaciente == 0){
        $pPaciente = $paramP1;
    }
    $pServicio = isset($_REQUEST['query'])?$_REQUEST['query']:null;
    $gBaseDatos = new ofiMySQLi();
    $gBaseDatos->conectar();
    $qry = "CALL sp_reporteparaclinicos_listar('" . $pPaciente . "',\"" . $pServicio . "\")";
    //echo $qry;
    @mysqli_query("\"SET NAMES UTF8\"");
    $gBaseDatos->QryID = @mysqli_query($gBaseDatos->ConexionID, $qry);
    $arr = array();
    while($row = @mysqli_fetch_assoc($gBaseDatos->QryID))
    {
        $nRow = $row;
        foreach($row as $key => $val)
        {
            $nRow[$key] = utf8_decode($val);
        }
        $arr[] = $nRow;
    }
    $gBaseDatos->liberar();
    $gBaseDatos->cerrar();
    $jsonresult = JEncode($arr);
    if (!is_null($jsonresult))
        echo '({"total":"0","results":'. $jsonresult .'})';
}

function GuardarAnotacionHC(){
    $pEmpresa = isset($_REQUEST['pEmpresa'])?$_REQUEST['pEmpresa']:0;
    $pIPS = isset($_REQUEST['pIPS'])?$_REQUEST['pIPS']:0;
    $pPaciente = isset($_REQUEST['pPaciente'])?$_REQUEST['pPaciente']:0;
    $pProfesional = isset($_REQUEST['pProfesional'])?$_REQUEST['pProfesional']:0;
    //$pProfesional = $_SESSION['ID_PROFESIONAL_HC'];
    $pCAS = isset($_REQUEST['pCAS'])?$_REQUEST['pCAS']:0;
    $pConsecutivoDetalle = isset($_REQUEST['pConsecutivoDetalle'])?$_REQUEST['pConsecutivoDetalle']:0;
    $pidPlantillaHC = isset($_REQUEST['pidPlantillaHC'])?$_REQUEST['pidPlantillaHC']:0;
    $pFechaAtencion = isset($_REQUEST['pFechaAtencion'])?$_REQUEST['pFechaAtencion']:null;
    $pHoraApertura = isset($_REQUEST['pHoraApertura'])?$_REQUEST['pHoraApertura']:null;
    $pActividad = isset($_REQUEST['pActividad'])?$_REQUEST['pActividad']:null;
    $pPlantilla = isset($_REQUEST['pPlantilla'])?$_REQUEST['pPlantilla']:null;
    $pRutaRptHC = isset($_REQUEST['pRutaRptHC'])?$_REQUEST['pRutaRptHC']:null;
    $pRutaRptMx = isset($_REQUEST['pRutaRptMx'])?$_REQUEST['pRutaRptMx']:null;
    $pRutaRptExa = isset($_REQUEST['pRutaRptExa'])?$_REQUEST['pRutaRptExa']:null;
    $pRutaRptRem = isset($_REQUEST['pRutaRptRem'])?$_REQUEST['pRutaRptRem']:null;
    $contenido = isset($_REQUEST['CAMPOS'])?$_REQUEST['CAMPOS']:null;
    $pEvolucion = stripslashes(utf8_encode(str_replace('"', '""',nl2br($contenido))));
    $pDiagppal = isset($_REQUEST['pDiagppal'])?$_REQUEST['pDiagppal']:null;
    $pDiagrel1 = isset($_REQUEST['pDiagrel1'])?$_REQUEST['pDiagrel1']:null;
    $pDiagrel2 = isset($_REQUEST['pDiagrel2'])?$_REQUEST['pDiagrel2']:null;
    $pDiagrel3 = isset($_REQUEST['pDiagrel3'])?$_REQUEST['pDiagrel3']:null;
    $pTipodiag = isset($_REQUEST['pTipodiag'])?$_REQUEST['pTipodiag']:null;
    $pFinalidad = isset($_REQUEST['pFinalidad'])?$_REQUEST['pFinalidad']:null;
    $pCausa = isset($_REQUEST['pCausa'])?$_REQUEST['pCausa']:null;
    $pAmbito = isset($_REQUEST['pAmbito'])?$_REQUEST['pAmbito']:null;
    $pFinalidadProced = isset($_REQUEST['pFinalidadProced'])?$_REQUEST['pFinalidadProced']:null;
    $pPersonalAtiende = isset($_REQUEST['pPersonalAtiende'])?$_REQUEST['pPersonalAtiende']:null;
    $pFormaActo = isset($_REQUEST['pFormaActo'])?$_REQUEST['pFormaActo']:null;
    $pUsuario = isset($_REQUEST['pUsuario'])?$_REQUEST['pUsuario']:0;
    $pIdCliente = isset($_REQUEST['pIdCliente'])?$_REQUEST['pIdCliente']:0;
    $pIdPlan = isset($_REQUEST['pIdPlan'])?$_REQUEST['pIdPlan']:0;
    $pIdSubPlan = isset($_REQUEST['pIdSubPlan'])?$_REQUEST['pIdSubPlan']:0;
    $pIdContrato = isset($_REQUEST['pIdContrato'])?$_REQUEST['pIdContrato']:0;
    $pAutorizacion = isset($_REQUEST['pAutorizacion'])?$_REQUEST['pAutorizacion']:null;
    if($pAutorizacion == null || $pAutorizacion == ""){
        $pAutorizacion = "NA";
    }
    $pCambiaCliente = isset($_REQUEST['pCambiaCliente'])?$_REQUEST['pCambiaCliente']:"NA";
    $pGuardarSignos = isset($_REQUEST['pGuardarSignos'])?$_REQUEST['pGuardarSignos']:"NO";
    $pTalla = isset($_REQUEST['pTalla'])?$_REQUEST['pTalla']:null;
    $pPeso = isset($_REQUEST['pPeso'])?$_REQUEST['pPeso']:null;
    $pIMC = isset($_REQUEST['pIMC'])?$_REQUEST['pIMC']:null;
    $pIMCClasifica = isset($_REQUEST['pIMCClasifica'])?$_REQUEST['pIMCClasifica']:null;
    $pTE = isset($_REQUEST['pTE'])?$_REQUEST['pTE']:null;
    $pPerimetroCefalico = isset($_REQUEST['pPerimetroCefalico'])?$_REQUEST['pPerimetroCefalico']:null;
    $pPerimetroToraxico = isset($_REQUEST['pPerimetroToraxico'])?$_REQUEST['pPerimetroToraxico']:null;
    $pTASIS = isset($_REQUEST['pTASIS'])?$_REQUEST['pTASIS']:null;
    $pTADIAS = isset($_REQUEST['pTADIAS'])?$_REQUEST['pTADIAS']:null;
    $pAnios = isset($_REQUEST['pAnios'])?$_REQUEST['pAnios']:null;
    $pMeses = isset($_REQUEST['pMeses'])?$_REQUEST['pMeses']:null;
    $pFormulacion = isset($_REQUEST['pFormulacion'])?$_REQUEST['pFormulacion']:1;
    if($pFormulacion == null || $pFormulacion == ""){
        $pFormulacion = 1;
    }
    
    $pOcupacion4505 = isset($_REQUEST['pOcupacion4505'])?$_REQUEST['pOcupacion4505']:null;
    $pEtnia4505 = isset($_REQUEST['pEtnia4505'])?$_REQUEST['pEtnia4505']:null;
    $pEscolaridad4505 = isset($_REQUEST['pEscolaridad4505'])?$_REQUEST['pEscolaridad4505']:null;
    $pGestacion4505 = isset($_REQUEST['pGestacion4505'])?$_REQUEST['pGestacion4505']:null;
    $pSifilisGestacional4505 = isset($_REQUEST['pSifilisGestacional4505'])?$_REQUEST['pSifilisGestacional4505']:null;
    $pHipertencionGestacional4505 = isset($_REQUEST['pHipertencionGestacional4505'])?$_REQUEST['pHipertencionGestacional4505']:null;
    $pHipotiroidismoCongenito4505 = isset($_REQUEST['pHipotiroidismoCongenito4505'])?$_REQUEST['pHipotiroidismoCongenito4505']:null;
    $pTuberculosisMultidrogoresistente4505 = isset($_REQUEST['pTuberculosisMultidrogoresistente4505'])?$_REQUEST['pTuberculosisMultidrogoresistente4505']:null;
    $pLepra4505 = isset($_REQUEST['pLepra4505'])?$_REQUEST['pLepra4505']:null;
    $pVictimaMaltrato4505 = isset($_REQUEST['pVictimaMaltrato4505'])?$_REQUEST['pVictimaMaltrato4505']:null;
    $pViolenciaSexual4505 = isset($_REQUEST['pViolenciaSexual4505'])?$_REQUEST['pViolenciaSexual4505']:null;
    $pFluorosisDental4505 = isset($_REQUEST['pFluorosisDental4505'])?$_REQUEST['pFluorosisDental4505']:null;
    $pTensionArterialSistolicaPie = isset($_REQUEST['pTensionArterialSistolicaPie'])?$_REQUEST['pTensionArterialSistolicaPie']:null;
    $pTensionArterialDiastolicaPie = isset($_REQUEST['pTensionArterialDiastolicaPie'])?$_REQUEST['pTensionArterialDiastolicaPie']:null;
    $pPerimetroAbdominal = isset($_REQUEST['pPerimetroAbdominal'])?$_REQUEST['pPerimetroAbdominal']:null;
    $pAlturaUterina = isset($_REQUEST['pAlturaUterina'])?$_REQUEST['pAlturaUterina']:null;
    $pFetocardiaFetal = isset($_REQUEST['pFetocardiaFetal'])?$_REQUEST['pFetocardiaFetal']:null;
    $pFC = isset($_REQUEST['pFC'])?$_REQUEST['pFC']:null;
    $pFR = isset($_REQUEST['pFR'])?$_REQUEST['pFR']:null;
    $pPostTestVIH4505 = isset($_REQUEST['pPostTestVIH4505'])?$_REQUEST['pPostTestVIH4505']:null;
    $pPreTestVIH4505 = isset($_REQUEST['pPreTestVIH4505'])?$_REQUEST['pPreTestVIH4505']:null;
    $pAdultoPrimeraVez4505 = isset($_REQUEST['pAdultoPrimeraVez4505'])?$_REQUEST['pAdultoPrimeraVez4505']:null;
    $pJovenPrimeraVez4505 = isset($_REQUEST['pJovenPrimeraVez4505'])?$_REQUEST['pJovenPrimeraVez4505']:null;
    $pCyDPrimeraVez4505 = isset($_REQUEST['pCyDPrimeraVez4505'])?$_REQUEST['pCyDPrimeraVez4505']:null;
    $pPsicologia4505 = isset($_REQUEST['pPsicologia4505'])?$_REQUEST['pPsicologia4505']:null;
    $pNutricion4505 = isset($_REQUEST['pNutricion4505'])?$_REQUEST['pNutricion4505']:null;
    $pConsultaViolenciaSexual4505 = isset($_REQUEST['pConsultaViolenciaSexual4505'])?$_REQUEST['pConsultaViolenciaSexual4505']:null;
    $pMaltrato4505 = isset($_REQUEST['pMaltrato4505'])?$_REQUEST['pMaltrato4505']:null;
    $pOftalmologia4505 = isset($_REQUEST['pOftalmologia4505'])?$_REQUEST['pOftalmologia4505']:null;
    $pAgudezaVisual4505 = isset($_REQUEST['pAgudezaVisual4505'])?$_REQUEST['pAgudezaVisual4505']:null;
    $pPrenatalControl4505 = isset($_REQUEST['pPrenatalControl4505'])?$_REQUEST['pPrenatalControl4505']:null;
    $pPrenatalPrimeraVez4505 = isset($_REQUEST['pPrenatalPrimeraVez4505'])?$_REQUEST['pPrenatalPrimeraVez4505']:null;
    $pPlanificacion4505 = isset($_REQUEST['pPlanificacion4505'])?$_REQUEST['pPlanificacion4505']:null;
    $pCodIPSTomaBiopsiaSeno4505 = isset($_REQUEST['pCodIPSTomaBiopsiaSeno4505'])?$_REQUEST['pCodIPSTomaBiopsiaSeno4505']:null;
    $pResultadoBiopsiaSeno4505 = isset($_REQUEST['pResultadoBiopsiaSeno4505'])?$_REQUEST['pResultadoBiopsiaSeno4505']:null;
    $pCodIPSTomaMamografia4505 = isset($_REQUEST['pCodIPSTomaMamografia4505'])?$_REQUEST['pCodIPSTomaMamografia4505']:null;
    $pResultadoMamografia4505 = isset($_REQUEST['pResultadoMamografia4505'])?$_REQUEST['pResultadoMamografia4505']:null;
    $pCodIPSTomaBiopsiaCervical4505 = isset($_REQUEST['pCodIPSTomaBiopsiaCervical4505'])?$_REQUEST['pCodIPSTomaBiopsiaCervical4505']:null;
    $pCodIPSTomaColposcopia4505 = isset($_REQUEST['pCodIPSTomaColposcopia4505'])?$_REQUEST['pCodIPSTomaColposcopia4505']:null;
    $pResultadoBiopsiaCervical4505 = isset($_REQUEST['pResultadoBiopsiaCervical4505'])?$_REQUEST['pResultadoBiopsiaCervical4505']:null;
    $pCodIPSTomaCitologia4505 = isset($_REQUEST['pCodIPSTomaCitologia4505'])?$_REQUEST['pCodIPSTomaCitologia4505']:null;
    $pCalidadMuestraCitologia4505 = isset($_REQUEST['pCalidadMuestraCitologia4505'])?$_REQUEST['pCalidadMuestraCitologia4505']:null;
    $pResultadoCitologia4505 = isset($_REQUEST['pResultadoCitologia4505'])?$_REQUEST['pResultadoCitologia4505']:null;
    $pCitologia4505 = isset($_REQUEST['pCitologia4505'])?$_REQUEST['pCitologia4505']:null;
    $pColposcopia4505 = isset($_REQUEST['pColposcopia4505'])?$_REQUEST['pColposcopia4505']:null;
    $pBiopsiaCervical4505 = isset($_REQUEST['pBiopsiaCervical4505'])?$_REQUEST['pBiopsiaCervical4505']:null;
    $pMamografia4505 = isset($_REQUEST['pMamografia4505'])?$_REQUEST['pMamografia4505']:null;
    $pBiopsiaSeno4505 = isset($_REQUEST['pBiopsiaSeno4505'])?$_REQUEST['pBiopsiaSeno4505']:null;
    $pTomaHemoglobina = isset($_REQUEST['pTomaHemoglobina'])?$_REQUEST['pTomaHemoglobina']:null;
    $pResultadoHemoglobina = isset($_REQUEST['pResultadoHemoglobina'])?$_REQUEST['pResultadoHemoglobina']:null;
    $pTomaCreatinina = isset($_REQUEST['pTomaCreatinina'])?$_REQUEST['pTomaCreatinina']:null;
    $pResultadoCreatinina = isset($_REQUEST['pResultadoCreatinina'])?$_REQUEST['pResultadoCreatinina']:null;
    $pTomaHemoglobinaGlicosilada = isset($_REQUEST['pTomaHemoglobinaGlicosilada'])?$_REQUEST['pTomaHemoglobinaGlicosilada']:null;
    $pResultadoHemoglobinaGlicosilada = isset($_REQUEST['pResultadoHemoglobinaGlicosilada'])?$_REQUEST['pResultadoHemoglobinaGlicosilada']:null;
    $pTomaGlicemia = isset($_REQUEST['pTomaGlicemia'])?$_REQUEST['pTomaGlicemia']:null;
    $pTomaMicroalbuminuria = isset($_REQUEST['pTomaMicroalbuminuria'])?$_REQUEST['pTomaMicroalbuminuria']:null;
    $pTomaHDL = isset($_REQUEST['pTomaHDL'])?$_REQUEST['pTomaHDL']:null;
    $pTomaBaciloscopiaDiagnostica = isset($_REQUEST['pTomaBaciloscopiaDiagnostica'])?$_REQUEST['pTomaBaciloscopiaDiagnostica']:null;
    $pResultadoBaciloscopiaDiagnostica = isset($_REQUEST['pResultadoBaciloscopiaDiagnostica'])?$_REQUEST['pResultadoBaciloscopiaDiagnostica']:null;
    $pSerologia = isset($_REQUEST['pSerologia'])?$_REQUEST['pSerologia']:null;
    $pResultadoSerologia = isset($_REQUEST['pResultadoSerologia'])?$_REQUEST['pResultadoSerologia']:null;
    $pTomaElisaVIH = isset($_REQUEST['pTomaElisaVIH'])?$_REQUEST['pTomaElisaVIH']:null;
    $pResultadoElisaVIH = isset($_REQUEST['pResultadoElisaVIH'])?$_REQUEST['pResultadoElisaVIH']:null;
    $pTSHNeonatal = isset($_REQUEST['pTSHNeonatal'])?$_REQUEST['pTSHNeonatal']:null;
    $pResultadoTSHNeonatal = isset($_REQUEST['pResultadoTSHNeonatal'])?$_REQUEST['pResultadoTSHNeonatal']:null;
    $pBCG = isset($_REQUEST['pBCG'])?$_REQUEST['pBCG']:null;
    $pHepatitisB = isset($_REQUEST['pHepatitisB'])?$_REQUEST['pHepatitisB']:null;
    $pPentavalente = isset($_REQUEST['pPentavalente'])?$_REQUEST['pPentavalente']:null;
    $pPolio = isset($_REQUEST['pPolio'])?$_REQUEST['pPolio']:null;
    $pDPT = isset($_REQUEST['pDPT'])?$_REQUEST['pDPT']:null;
    $pRotavirus = isset($_REQUEST['pRotavirus'])?$_REQUEST['pRotavirus']:null;
    $pNeumococo = isset($_REQUEST['pNeumococo'])?$_REQUEST['pNeumococo']:null;
    $pInfluenza = isset($_REQUEST['pInfluenza'])?$_REQUEST['pInfluenza']:null;
    $pFiebreAmarilla = isset($_REQUEST['pFiebreAmarilla'])?$_REQUEST['pFiebreAmarilla']:null;
    $pHepatitisA = isset($_REQUEST['pHepatitisA'])?$_REQUEST['pHepatitisA']:null;
    $pTripleViral = isset($_REQUEST['pTripleViral'])?$_REQUEST['pTripleViral']:null;
    $pVPH = isset($_REQUEST['pVPH'])?$_REQUEST['pVPH']:null;
    $pTD = isset($_REQUEST['pTD'])?$_REQUEST['pTD']:null;
    
    //$qry = "CALL sp_asistencial_add_notaevolucion('" . $pEmpresa . "','" . $pIPS . "','" . $pPaciente . "','" . $pProfesional . "','" . $pCAS . "','" . $pConsecutivoDetalle . "','" . $pidPlantillaHC . "',\"" . $pFechaAtencion . "\",\"" . $pHoraApertura . "\",\"" . $pActividad . "\",\"" . $pPlantilla . "\",\"" . $pRutaRptHC . "\",\"" . $pRutaRptMx . "\",\"" . $pRutaRptExa . "\",\"" . $pRutaRptRem . "\",\"" . $pEvolucion . "\",\"" . $pDiagppal . "\",\"" . $pDiagrel1 . "\",\"" . $pDiagrel2 . "\",\"" . $pDiagrel3 . "\",\"" . $pTipodiag . "\",\"" . $pFinalidad . "\",\"" . $pCausa . "\",\"" . $pAmbito . "\",\"" . $pFinalidadProced . "\",\"" . $pPersonalAtiende . "\",\"" . $pFormaActo . "\",'" . $pUsuario . "','" . $pIdCliente . "','" . $pIdPlan . "','" . $pIdSubPlan . "','" . $pIdContrato . "',\"" . $pAutorizacion . "\",\"" . $pCambiaCliente . "\",'" . $pFormulacion . "')";
    $qry = "CALL sp_asistencial_notahc_add('" . $pEmpresa . "','" . $pIPS . "','" . $pPaciente . "','" . $pProfesional . "','" . $pCAS . "','" . $pConsecutivoDetalle . "','" . $pidPlantillaHC . "',\"" . $pFechaAtencion . "\",\"" . $pHoraApertura . "\",\"" . $pActividad . "\",\"" . $pPlantilla . "\",\"" . $pRutaRptHC . "\",\"" . $pRutaRptMx . "\",\"" . $pRutaRptExa . "\",\"" . $pRutaRptRem . "\",\"" . $pEvolucion . "\",\"" . $pDiagppal . "\",\"" . $pDiagrel1 . "\",\"" . $pDiagrel2 . "\",\"" . $pDiagrel3 . "\",\"" . $pTipodiag . "\",\"" . $pFinalidad . "\",\"" . $pCausa . "\",\"" . $pAmbito . "\",\"" . $pFinalidadProced . "\",\"" . $pPersonalAtiende . "\",\"" . $pFormaActo . "\",'" . $pUsuario . "','" . $pIdCliente . "','" . $pIdPlan . "','" . $pIdSubPlan . "','" . $pIdContrato . "',\"" . $pAutorizacion . "\",\"" . $pCambiaCliente . "\",'" . $pFormulacion . "')";
    $gBaseDatos = new ofiMySQLi();
    $gBaseDatos->conectar();
    if(@mysqli_query($gBaseDatos->ConexionID, $qry))
        echo "{success: true, requestedId:'1'}";
    else
       echo "{success: true, requestedId:'0'}";
    $gBaseDatos->cerrar();
}

function ModificarAnotacionHC(){
    $pEmpresa = isset($_REQUEST['pEmpresa'])?$_REQUEST['pEmpresa']:0;
    $pIPS = isset($_REQUEST['pIPS'])?$_REQUEST['pIPS']:0;
    $pPaciente = isset($_REQUEST['pPaciente'])?$_REQUEST['pPaciente']:0;
    $pProfesional = isset($_REQUEST['pProfesional'])?$_REQUEST['pProfesional']:0;
    //$pProfesional = $_SESSION['ID_PROFESIONAL_HC'];
    $pCAS = isset($_REQUEST['pCAS'])?$_REQUEST['pCAS']:0;
    $pConsecutivoDetalle = isset($_REQUEST['pConsecutivoDetalle'])?$_REQUEST['pConsecutivoDetalle']:0;
    $pFechaAtencion = isset($_REQUEST['pFechaAtencion'])?$_REQUEST['pFechaAtencion']:null;
    $pHoraApertura = isset($_REQUEST['pHoraApertura'])?$_REQUEST['pHoraApertura']:null;
    $pActividad = isset($_REQUEST['pActividad'])?$_REQUEST['pActividad']:null;
    $pPlantilla = isset($_REQUEST['pPlantilla'])?$_REQUEST['pPlantilla']:null;
    $pRutaRptHC = isset($_REQUEST['pRutaRptHC'])?$_REQUEST['pRutaRptHC']:null;
    $pRutaRptMx = isset($_REQUEST['pRutaRptMx'])?$_REQUEST['pRutaRptMx']:null;
    $pRutaRptExa = isset($_REQUEST['pRutaRptExa'])?$_REQUEST['pRutaRptExa']:null;
    $pRutaRptRem = isset($_REQUEST['pRutaRptRem'])?$_REQUEST['pRutaRptRem']:null;
    $contenido = isset($_REQUEST['CAMPOS'])?$_REQUEST['CAMPOS']:null;
    $pEvolucion = stripslashes(utf8_encode(str_replace('"', '""',nl2br($contenido))));
    $pDiagppal = isset($_REQUEST['pDiagppal'])?$_REQUEST['pDiagppal']:null;
    $pDiagrel1 = isset($_REQUEST['pDiagrel1'])?$_REQUEST['pDiagrel1']:null;
    $pDiagrel2 = isset($_REQUEST['pDiagrel2'])?$_REQUEST['pDiagrel2']:null;
    $pDiagrel3 = isset($_REQUEST['pDiagrel3'])?$_REQUEST['pDiagrel3']:null;
    $pTipodiag = isset($_REQUEST['pTipodiag'])?$_REQUEST['pTipodiag']:null;
    $pFinalidad = isset($_REQUEST['pFinalidad'])?$_REQUEST['pFinalidad']:null;
    $pCausa = isset($_REQUEST['pCausa'])?$_REQUEST['pCausa']:null;
    $pAmbito = isset($_REQUEST['pAmbito'])?$_REQUEST['pAmbito']:null;
    $pFinalidadProced = isset($_REQUEST['pFinalidadProced'])?$_REQUEST['pFinalidadProced']:null;
    $pPersonalAtiende = isset($_REQUEST['pPersonalAtiende'])?$_REQUEST['pPersonalAtiende']:null;
    $pFormaActo = isset($_REQUEST['pFormaActo'])?$_REQUEST['pFormaActo']:null;
    $pUsuario = isset($_REQUEST['pUsuario'])?$_REQUEST['pUsuario']:0;
    $pIdCliente = isset($_REQUEST['pIdCliente'])?$_REQUEST['pIdCliente']:0;
    $pIdPlan = isset($_REQUEST['pIdPlan'])?$_REQUEST['pIdPlan']:0;
    $pIdSubPlan = isset($_REQUEST['pIdSubPlan'])?$_REQUEST['pIdSubPlan']:0;
    $pIdContrato = isset($_REQUEST['pIdContrato'])?$_REQUEST['pIdContrato']:0;
    $pAutorizacion = isset($_REQUEST['pAutorizacion'])?$_REQUEST['pAutorizacion']:null;
    if($pAutorizacion == null || $pAutorizacion == ""){
        $pAutorizacion = "NA";
    }
    $pFormulacion = isset($_REQUEST['pFormulacion'])?$_REQUEST['pFormulacion']:1;
    if($pFormulacion == null || $pFormulacion == ""){
        $pFormulacion = 1;
    }
    $pCambiaCliente = isset($_REQUEST['pCambiaCliente'])?$_REQUEST['pCambiaCliente']:"NA";
    $pTalla = isset($_REQUEST['pTalla'])?$_REQUEST['pTalla']:null;
    $pPeso = isset($_REQUEST['pPeso'])?$_REQUEST['pPeso']:null;
    $pIMC = isset($_REQUEST['pIMC'])?$_REQUEST['pIMC']:null;
    $pIMCClasifica = isset($_REQUEST['pIMCClasifica'])?$_REQUEST['pIMCClasifica']:null;
    $pTE = isset($_REQUEST['pTE'])?$_REQUEST['pTE']:null;
    $pPerimetroCefalico = isset($_REQUEST['pPerimetroCefalico'])?$_REQUEST['pPerimetroCefalico']:null;
    $pPerimetroToraxico = isset($_REQUEST['pPerimetroToraxico'])?$_REQUEST['pPerimetroToraxico']:null;
    $pTASIS = isset($_REQUEST['pTASIS'])?$_REQUEST['pTASIS']:null;
    $pTADIAS = isset($_REQUEST['pTADIAS'])?$_REQUEST['pTADIAS']:null;
    $pAnios = isset($_REQUEST['pAnios'])?$_REQUEST['pAnios']:null;
    $pMeses = isset($_REQUEST['pMeses'])?$_REQUEST['pMeses']:null;
    $pOcupacion4505 = isset($_REQUEST['pOcupacion4505'])?$_REQUEST['pOcupacion4505']:null;
    $pEtnia4505 = isset($_REQUEST['pEtnia4505'])?$_REQUEST['pEtnia4505']:null;
    $pEscolaridad4505 = isset($_REQUEST['pEscolaridad4505'])?$_REQUEST['pEscolaridad4505']:null;
    $pGestacion4505 = isset($_REQUEST['pGestacion4505'])?$_REQUEST['pGestacion4505']:null;
    $pSifilisGestacional4505 = isset($_REQUEST['pSifilisGestacional4505'])?$_REQUEST['pSifilisGestacional4505']:null;
    $pHipertencionGestacional4505 = isset($_REQUEST['pHipertencionGestacional4505'])?$_REQUEST['pHipertencionGestacional4505']:null;
    $pHipotiroidismoCongenito4505 = isset($_REQUEST['pHipotiroidismoCongenito4505'])?$_REQUEST['pHipotiroidismoCongenito4505']:null;
    $pTuberculosisMultidrogoresistente4505 = isset($_REQUEST['pTuberculosisMultidrogoresistente4505'])?$_REQUEST['pTuberculosisMultidrogoresistente4505']:null;
    $pLepra4505 = isset($_REQUEST['pLepra4505'])?$_REQUEST['pLepra4505']:null;
    $pVictimaMaltrato4505 = isset($_REQUEST['pVictimaMaltrato4505'])?$_REQUEST['pVictimaMaltrato4505']:null;
    $pViolenciaSexual4505 = isset($_REQUEST['pViolenciaSexual4505'])?$_REQUEST['pViolenciaSexual4505']:null;
    $pFluorosisDental4505 = isset($_REQUEST['pFluorosisDental4505'])?$_REQUEST['pFluorosisDental4505']:null;
    $pTensionArterialSistolicaPie = isset($_REQUEST['pTensionArterialSistolicaPie'])?$_REQUEST['pTensionArterialSistolicaPie']:null;
    $pTensionArterialDiastolicaPie = isset($_REQUEST['pTensionArterialDiastolicaPie'])?$_REQUEST['pTensionArterialDiastolicaPie']:null;
    $pPerimetroAbdominal = isset($_REQUEST['pPerimetroAbdominal'])?$_REQUEST['pPerimetroAbdominal']:null;
    $pAlturaUterina = isset($_REQUEST['pAlturaUterina'])?$_REQUEST['pAlturaUterina']:null;
    $pFetocardiaFetal = isset($_REQUEST['pFetocardiaFetal'])?$_REQUEST['pFetocardiaFetal']:null;
    $pFC = isset($_REQUEST['pFC'])?$_REQUEST['pFC']:null;
    $pFR = isset($_REQUEST['pFR'])?$_REQUEST['pFR']:null;
    $pGuardarSignos = isset($_REQUEST['pGuardarSignos'])?$_REQUEST['pGuardarSignos']:null;
    $pPostTestVIH4505 = isset($_REQUEST['pPostTestVIH4505'])?$_REQUEST['pPostTestVIH4505']:null;
    $pPreTestVIH4505 = isset($_REQUEST['pPreTestVIH4505'])?$_REQUEST['pPreTestVIH4505']:null;
    $pAdultoPrimeraVez4505 = isset($_REQUEST['pAdultoPrimeraVez4505'])?$_REQUEST['pAdultoPrimeraVez4505']:null;
    $pJovenPrimeraVez4505 = isset($_REQUEST['pJovenPrimeraVez4505'])?$_REQUEST['pJovenPrimeraVez4505']:null;
    $pCyDPrimeraVez4505 = isset($_REQUEST['pCyDPrimeraVez4505'])?$_REQUEST['pCyDPrimeraVez4505']:null;
    $pPsicologia4505 = isset($_REQUEST['pPsicologia4505'])?$_REQUEST['pPsicologia4505']:null;
    $pNutricion4505 = isset($_REQUEST['pNutricion4505'])?$_REQUEST['pNutricion4505']:null;
    $pConsultaViolenciaSexual4505 = isset($_REQUEST['pConsultaViolenciaSexual4505'])?$_REQUEST['pConsultaViolenciaSexual4505']:null;
    $pMaltrato4505 = isset($_REQUEST['pMaltrato4505'])?$_REQUEST['pMaltrato4505']:null;
    $pOftalmologia4505 = isset($_REQUEST['pOftalmologia4505'])?$_REQUEST['pOftalmologia4505']:null;
    $pAgudezaVisual4505 = isset($_REQUEST['pAgudezaVisual4505'])?$_REQUEST['pAgudezaVisual4505']:null;
    $pPrenatalControl4505 = isset($_REQUEST['pPrenatalControl4505'])?$_REQUEST['pPrenatalControl4505']:null;
    $pPrenatalPrimeraVez4505 = isset($_REQUEST['pPrenatalPrimeraVez4505'])?$_REQUEST['pPrenatalPrimeraVez4505']:null;
    $pPlanificacion4505 = isset($_REQUEST['pPlanificacion4505'])?$_REQUEST['pPlanificacion4505']:null;
    $pCodIPSTomaBiopsiaSeno4505 = isset($_REQUEST['pCodIPSTomaBiopsiaSeno4505'])?$_REQUEST['pCodIPSTomaBiopsiaSeno4505']:null;
    $pResultadoBiopsiaSeno4505 = isset($_REQUEST['pResultadoBiopsiaSeno4505'])?$_REQUEST['pResultadoBiopsiaSeno4505']:null;
    $pCodIPSTomaMamografia4505 = isset($_REQUEST['pCodIPSTomaMamografia4505'])?$_REQUEST['pCodIPSTomaMamografia4505']:null;
    $pResultadoMamografia4505 = isset($_REQUEST['pResultadoMamografia4505'])?$_REQUEST['pResultadoMamografia4505']:null;
    $pCodIPSTomaBiopsiaCervical4505 = isset($_REQUEST['pCodIPSTomaBiopsiaCervical4505'])?$_REQUEST['pCodIPSTomaBiopsiaCervical4505']:null;
    $pCodIPSTomaColposcopia4505 = isset($_REQUEST['pCodIPSTomaColposcopia4505'])?$_REQUEST['pCodIPSTomaColposcopia4505']:null;
    $pResultadoBiopsiaCervical4505 = isset($_REQUEST['pResultadoBiopsiaCervical4505'])?$_REQUEST['pResultadoBiopsiaCervical4505']:null;
    $pCodIPSTomaCitologia4505 = isset($_REQUEST['pCodIPSTomaCitologia4505'])?$_REQUEST['pCodIPSTomaCitologia4505']:null;
    $pCalidadMuestraCitologia4505 = isset($_REQUEST['pCalidadMuestraCitologia4505'])?$_REQUEST['pCalidadMuestraCitologia4505']:null;
    $pResultadoCitologia4505 = isset($_REQUEST['pResultadoCitologia4505'])?$_REQUEST['pResultadoCitologia4505']:null;
    $pCitologia4505 = isset($_REQUEST['pCitologia4505'])?$_REQUEST['pCitologia4505']:null;
    $pColposcopia4505 = isset($_REQUEST['pColposcopia4505'])?$_REQUEST['pColposcopia4505']:null;
    $pBiopsiaCervical4505 = isset($_REQUEST['pBiopsiaCervical4505'])?$_REQUEST['pBiopsiaCervical4505']:null;
    $pMamografia4505 = isset($_REQUEST['pMamografia4505'])?$_REQUEST['pMamografia4505']:null;
    $pBiopsiaSeno4505 = isset($_REQUEST['pBiopsiaSeno4505'])?$_REQUEST['pBiopsiaSeno4505']:null;
    $pTomaHemoglobina = isset($_REQUEST['pTomaHemoglobina'])?$_REQUEST['pTomaHemoglobina']:null;
    $pResultadoHemoglobina = isset($_REQUEST['pResultadoHemoglobina'])?$_REQUEST['pResultadoHemoglobina']:null;
    $pTomaCreatinina = isset($_REQUEST['pTomaCreatinina'])?$_REQUEST['pTomaCreatinina']:null;
    $pResultadoCreatinina = isset($_REQUEST['pResultadoCreatinina'])?$_REQUEST['pResultadoCreatinina']:null;
    $pTomaHemoglobinaGlicosilada = isset($_REQUEST['pTomaHemoglobinaGlicosilada'])?$_REQUEST['pTomaHemoglobinaGlicosilada']:null;
    $pResultadoHemoglobinaGlicosilada = isset($_REQUEST['pResultadoHemoglobinaGlicosilada'])?$_REQUEST['pResultadoHemoglobinaGlicosilada']:null;
    $pTomaGlicemia = isset($_REQUEST['pTomaGlicemia'])?$_REQUEST['pTomaGlicemia']:null;
    $pTomaMicroalbuminuria = isset($_REQUEST['pTomaMicroalbuminuria'])?$_REQUEST['pTomaMicroalbuminuria']:null;
    $pTomaHDL = isset($_REQUEST['pTomaHDL'])?$_REQUEST['pTomaHDL']:null;
    $pTomaBaciloscopiaDiagnostica = isset($_REQUEST['pTomaBaciloscopiaDiagnostica'])?$_REQUEST['pTomaBaciloscopiaDiagnostica']:null;
    $pResultadoBaciloscopiaDiagnostica = isset($_REQUEST['pResultadoBaciloscopiaDiagnostica'])?$_REQUEST['pResultadoBaciloscopiaDiagnostica']:null;
    $pSerologia = isset($_REQUEST['pSerologia'])?$_REQUEST['pSerologia']:null;
    $pResultadoSerologia = isset($_REQUEST['pResultadoSerologia'])?$_REQUEST['pResultadoSerologia']:null;
    $pTomaElisaVIH = isset($_REQUEST['pTomaElisaVIH'])?$_REQUEST['pTomaElisaVIH']:null;
    $pResultadoElisaVIH = isset($_REQUEST['pResultadoElisaVIH'])?$_REQUEST['pResultadoElisaVIH']:null;
    $pTSHNeonatal = isset($_REQUEST['pTSHNeonatal'])?$_REQUEST['pTSHNeonatal']:null;
    $pResultadoTSHNeonatal = isset($_REQUEST['pResultadoTSHNeonatal'])?$_REQUEST['pResultadoTSHNeonatal']:null;
    $pBCG = isset($_REQUEST['pBCG'])?$_REQUEST['pBCG']:null;
    $pHepatitisB = isset($_REQUEST['pHepatitisB'])?$_REQUEST['pHepatitisB']:null;
    $pPentavalente = isset($_REQUEST['pPentavalente'])?$_REQUEST['pPentavalente']:null;
    $pPolio = isset($_REQUEST['pPolio'])?$_REQUEST['pPolio']:null;
    $pDPT = isset($_REQUEST['pDPT'])?$_REQUEST['pDPT']:null;
    $pRotavirus = isset($_REQUEST['pRotavirus'])?$_REQUEST['pRotavirus']:null;
    $pNeumococo = isset($_REQUEST['pNeumococo'])?$_REQUEST['pNeumococo']:null;
    $pInfluenza = isset($_REQUEST['pInfluenza'])?$_REQUEST['pInfluenza']:null;
    $pFiebreAmarilla = isset($_REQUEST['pFiebreAmarilla'])?$_REQUEST['pFiebreAmarilla']:null;
    $pHepatitisA = isset($_REQUEST['pHepatitisA'])?$_REQUEST['pHepatitisA']:null;
    $pTripleViral = isset($_REQUEST['pTripleViral'])?$_REQUEST['pTripleViral']:null;
    $pVPH = isset($_REQUEST['pVPH'])?$_REQUEST['pVPH']:null;
    $pTD = isset($_REQUEST['pTD'])?$_REQUEST['pTD']:null;
    $gBaseDatos = new ofiMySQLi();
    $gBaseDatos->conectar();
    $qry = "CALL sp_asistencial_notahc_edit('" . $pEmpresa . "','" . $pIPS . "','" . $pPaciente . "','" . $pProfesional . "','" . $pCAS . "','" . $pConsecutivoDetalle . "',\"" . $pFechaAtencion . "\",\"" . $pHoraApertura . "\",\"" . $pActividad . "\",\"" . $pPlantilla . "\",\"" . $pEvolucion . "\",\"" . $pDiagppal . "\",\"" . $pDiagrel1 . "\",\"" . $pDiagrel2 . "\",\"" . $pDiagrel3 . "\",\"" . $pTipodiag . "\",\"" . $pFinalidad . "\",\"" . $pCausa . "\",\"" . $pAmbito . "\",\"" . $pFinalidadProced . "\",\"" . $pPersonalAtiende . "\",\"" . $pFormaActo . "\",'" . $pUsuario . "','" . $pIdCliente . "','" . $pIdPlan . "','" . $pIdSubPlan . "','" . $pIdContrato . "',\"" . $pAutorizacion . "\",\"" . $pCambiaCliente . "\",'" . $pFormulacion . "')";
    //echo $qry;
    if(@mysqli_query($gBaseDatos->ConexionID, $qry)){
        $gBaseDatos->cerrar();
        echo "{success: true, requestedId:'1'}";
    }else{
        $gBaseDatos->cerrar();
        echo "{success: true, requestedId:'0'}";
    }
}

function ripsanGuardar(){
    $pCAS = isset($_REQUEST['pCAS']) ? $_REQUEST['pCAS'] :0;
    $pUsuario = isset($_REQUEST['pUsuario']) ? $_REQUEST['pUsuario'] :0;
    $estructura = explode("¬", $_REQUEST['CAMPOS']);
    $qry = "CALL sp_estudios_ripsan_ingresosave('" . $pCAS . "','" . $pUsuario . "'," . spParametros($estructura,"NO") . ")";
    //echo $qry;
    $gBaseDatos = new ofiMySQLi();
    $gBaseDatos->conectar();
    if(@mysqli_query($gBaseDatos->ConexionID, $qry))
        echo "{success: true, requestedId:'1'}";
    else
       echo "{success: true, requestedId:'0'}";
    $gBaseDatos->cerrar();
}

function ripsahGuardar($pOpcion){
    $pCAS = isset($_REQUEST['pCAS']) ? $_REQUEST['pCAS'] :0;
    $pUsuario = isset($_REQUEST['pUsuario']) ? $_REQUEST['pUsuario'] :0;
    $estructura = explode("¬", $_REQUEST['CAMPOS']);
    $qry = "";
    switch ($pOpcion){
        case "Ingreso":
            $qry = "CALL sp_estudios_ripsah_ingresosave('" . $pCAS . "','" . $pUsuario . "'," . spParametros($estructura,"NO") . ")";
            break;
        case "Egreso":
            $qry = "CALL sp_estudios_ripsah_egresosave('" . $pCAS . "','" . $pUsuario . "'," . spParametros($estructura,"NO") . ")";
            break;
        default:
            break;
    }
    //echo $qry;
    $gBaseDatos = new ofiMySQLi();
    $gBaseDatos->conectar();
    if(@mysqli_query($gBaseDatos->ConexionID, $qry))
        echo "{success: true, requestedId:'1'}";
    else
       echo "{success: true, requestedId:'0'}";
    $gBaseDatos->cerrar();
}

function ripsauGuardar($pOpcion){
    $pCAS = isset($_REQUEST['pCAS']) ? $_REQUEST['pCAS'] :0;
    $pUsuario = isset($_REQUEST['pUsuario']) ? $_REQUEST['pUsuario'] :0;
    $estructura = explode("¬", $_REQUEST['CAMPOS']);
    $qry = "";
    switch ($pOpcion){
        case "Ingreso":
            $qry = "CALL sp_estudios_ripsau_ingresosave('" . $pCAS . "','" . $pUsuario . "'," . spParametros($estructura,"NO") . ")";
            break;
        case "Egreso":
            $qry = "CALL sp_estudios_ripsau_egresosave('" . $pCAS . "','" . $pUsuario . "'," . spParametros($estructura,"NO") . ")";
            break;
        default:
            break;
    }
    //echo $qry;
    $gBaseDatos = new ofiMySQLi();
    $gBaseDatos->conectar();
    if(@mysqli_query($gBaseDatos->ConexionID, $qry))
        echo "{success: true, requestedId:'1'}";
    else
       echo "{success: true, requestedId:'0'}";
    $gBaseDatos->cerrar();
}

function ripsahLoad(){
    $gBaseDatos = new ofiMySQLi();
    $gBaseDatos->conectar();
    $pCAS = isset($_REQUEST['pCAS']) ? $_REQUEST['pCAS'] :0;
    $qry = "CALL sp_estudios_ripsah_load('" . $pCAS . "')";
    echo $gBaseDatos->jasonSP_arreglo($qry);
}

function ripsanLoad(){
    $gBaseDatos = new ofiMySQLi();
    $gBaseDatos->conectar();
    $pCAS = isset($_REQUEST['pCAS']) ? $_REQUEST['pCAS'] :0;
    $qry = "CALL sp_estudios_ripsan_load('" . $pCAS . "')";
    echo $gBaseDatos->jasonSP_arreglo($qry);
}

function ripsauLoad(){
    $gBaseDatos = new ofiMySQLi();
    $gBaseDatos->conectar();
    $pCAS = isset($_REQUEST['pCAS']) ? $_REQUEST['pCAS'] :0;
    $qry = "CALL sp_estudios_ripsau_load('" . $pCAS . "')";
    echo $gBaseDatos->jasonSP_arreglo($qry);
}

function ripsauVerifica(){
    $gBaseDatos = new ofiMySQLi();
    $gBaseDatos->conectar();
    $pCAS = isset($_REQUEST['pCAS']) ? $_REQUEST['pCAS'] :0;
    $qry = "CALL sp_estudios_ripsau_verifica('" . $pCAS . "')";
    echo $gBaseDatos->jasonSP_arreglo($qry);
}

function ripsahVerifica(){
    $gBaseDatos = new ofiMySQLi();
    $gBaseDatos->conectar();
    $pCAS = isset($_REQUEST['pCAS']) ? $_REQUEST['pCAS'] :0;
    $qry = "CALL sp_estudios_ripsah_verifica('" . $pCAS . "')";
    echo $gBaseDatos->jasonSP_arreglo($qry);
}
    
function VerPacientesObservacionHospitalizacion(){
    //$pEmpresa = isset($_REQUEST['pEmpresa'])?$_REQUEST['pEmpresa']:0;
    //$pIPS = isset($_REQUEST['pIPS'])?$_REQUEST['pIPS']:0;
    $pPaciente = isset($_REQUEST['pPaciente'])?$_REQUEST['pPaciente']:0;
    if($pPaciente == "" || $pPaciente == null){
        $pPaciente = 0;
    }
    $pServicio = isset($_REQUEST['pServicio'])?$_REQUEST['pServicio']:"T";
    if($pServicio == "" || $pServicio == null){
        $pServicio = "T";
    }
    $gBaseDatos = new ofiMySQLi();
    $gBaseDatos->conectar();
    $qry = "CALL sp_asistencial_observahospitaliza_listarpac('" . $pPaciente . "',\"" . $pServicio . "\")";
    //echo $qry;
    @mysqli_query("\"SET NAMES UTF8\"");
    $gBaseDatos->QryID = @mysqli_query($gBaseDatos->ConexionID, $qry);
    $arr = array();
    while($row = @mysqli_fetch_assoc($gBaseDatos->QryID))
    {
        $nRow = $row;
        foreach($row as $key => $val)
        {
            $nRow[$key] = utf8_decode($val);
        }
        $arr[] = $nRow;
    }
    $gBaseDatos->liberar();
    $gBaseDatos->cerrar();
    $jsonresult = JEncode($arr);
    if (!is_null($jsonresult))
        echo '({"total":"0","results":'. $jsonresult .'})';
}

function CargarUltimoInformeMensualNeuroDesarrollo(){
    $pPaciente = isset($_REQUEST['pPaciente'])?$_REQUEST['pPaciente']:0;
    $qry = "CALL sp_neurodesa_resumenhc_load_ultimo('" . $pPaciente . "')";
    $gBaseDatos = new ofiMySQLi();
    $gBaseDatos->conectar();
    //echo $qry;
    //$res = PonerAcentosHTML($gBaseDatos->jsonSP($qry,"D"));
    $resY = str_replace("<BR \/><br \/>","",PonerAcentosHTML($gBaseDatos->jsonSP($qry,"D")));
    $res = str_replace("<br \/>","",$resY);
    $gBaseDatos->liberar();
    $gBaseDatos->cerrar();
    echo $res;
}

function CargarUltimoDiagnostico(){
    $pPaciente = isset($_REQUEST['pPaciente'])?$_REQUEST['pPaciente']:0;
    $pCAS = isset($_REQUEST['pCAS'])?$_REQUEST['pCAS']:0;
    $qry = "CALL sp_asistencial_load_ultdiagnostico('" . $pPaciente . "','" . $pCAS . "')";
    $gBaseDatos = new ofiMySQLi();
    $gBaseDatos->conectar();
    //echo $qry;
    //$res = PonerAcentosHTML($gBaseDatos->jsonSP($qry,"D"));
    $resY = str_replace("<BR \/><br \/>","",PonerAcentosHTML($gBaseDatos->jsonSP($qry,"D")));
    $res = str_replace("<br \/>","",$resY);
    $gBaseDatos->liberar();
    $gBaseDatos->cerrar();
    echo $res;
}

function ImportarAntecedentesOfiClinic($pTipo){
    $pPaciente = isset($_REQUEST['pPaciente'])?$_REQUEST['pPaciente']:0;
    $pCAS = isset($_REQUEST['pCAS'])?$_REQUEST['pCAS']:0;
    switch ($pTipo){
        case "PersonalesOfiClinic001":
            $qry = "CALL sp_oficlinic_load_antecedentespersonales('" . $pPaciente . "','" . $pCAS . "')";
            break;
        default:
            break;
    }
    $gBaseDatos = new ofiMySQLi();
    $gBaseDatos->conectar();
    $resY = str_replace("<BR \/><br \/>","",PonerAcentosHTML($gBaseDatos->jsonSP($qry,"D")));
    $res = str_replace("<br \/>","",$resY);
    $gBaseDatos->liberar();
    $gBaseDatos->cerrar();
    $res1 = str_replace("[", "", $res);
    $res = str_replace("]", "", $res1);
    echo $res;
}

function ImportarUltimaAtencion(){
    $pCAS = isset($_REQUEST['pCAS'])?$_REQUEST['pCAS']:0;
    $pPaciente = isset($_REQUEST['pPaciente'])?$_REQUEST['pPaciente']:0;
    $qry = "";
    $qry = "CALL sp_ofimedical_load_ultimaatencion('" . $pPaciente . "','" . $pCAS . "')";
    //echo $qry;
    $gBaseDatos = new ofiMySQLi();
    $gBaseDatos->conectar();
    $resY = str_replace("<BR \/><br \/>","",PonerAcentosHTML($gBaseDatos->jsonSP($qry,"D")));
    $res = str_replace("<br \/>","",$resY);
    $gBaseDatos->liberar();
    $gBaseDatos->cerrar();
    //$res1 = str_replace("[", "", $res);
    //$res = str_replace("]", "", $res1);
    echo $res;
}

function ImportarAntecedentes($pTipo){
    $pCAS = isset($_REQUEST['pCAS'])?$_REQUEST['pCAS']:0;
    $pPaciente = isset($_REQUEST['pPaciente'])?$_REQUEST['pPaciente']:0;
    $qry = "";
    switch ($pTipo){
        case "Familiares":
            $qry = "CALL sp_ofimedical_load_antecedentesfamiliares('" . $pPaciente . "','" . $pCAS . "')";
            break;
        case "Personales":
            $qry = "CALL sp_ofimedical_load_antecedentespersonales('" . $pPaciente . "','" . $pCAS . "')";
            break;
        case "PersonalesOfiClinic001":
            $qry = "CALL sp_oficlinic_load_antecedentespersonales('" . $pPaciente . "','" . $pCAS . "')";
            break;
        case "VariablesAntropometricas":
            $qry = "CALL sp_oficlinic_load_variablesantropometricas2014('" . $pPaciente . "','" . $pCAS . "')";
            break;
        case "VariablesAntropometricas2013":
            $qry = "CALL sp_oficlinic_load_variablesantropometricas('" . $pPaciente . "','" . $pCAS . "')";
            break;
        default:
            break;
    }
    //echo $qry;
    $gBaseDatos = new ofiMySQLi();
    $gBaseDatos->conectar();
    $resY = str_replace("<BR \/><br \/>","",PonerAcentosHTML($gBaseDatos->jsonSP($qry,"D")));
    $res = str_replace("<br \/>","",$resY);
    $gBaseDatos->liberar();
    $gBaseDatos->cerrar();
    $res1 = str_replace("[", "", $res);
    $res = str_replace("]", "", $res1);
    echo $res;
}

function ImportarUltimaFormula(){
    $pPaciente = isset($_REQUEST['pPaciente'])?$_REQUEST['pPaciente']:0;
    $pCAS = isset($_REQUEST['pCAS'])?$_REQUEST['pCAS']:0;
    $pUsuario = isset($_REQUEST['pUsuario'])?$_REQUEST['pUsuario']:0;
    $gBaseDatos = new ofiMySQLi();
    $gBaseDatos->conectar();
    $qry = "CALL sp_asistencial_formula_loadlast('" . $pPaciente . "','" . $pCAS . "','" . $pUsuario . "')";
    echo $gBaseDatos->jasonSP_arreglo($qry);
    $gBaseDatos->liberar();
    $gBaseDatos->cerrar();
}

function VerRemSolicitadosxHC_ofimedical(){
    $pEmpresa = isset($_REQUEST['pEmpresa'])?$_REQUEST['pEmpresa']:0;
    $pIPS = isset($_REQUEST['pIPS'])?$_REQUEST['pIPS']:0;
    $pPaciente = isset($_REQUEST['pPaciente'])?$_REQUEST['pPaciente']:0;
    $pCAS = isset($_REQUEST['pCAS'])?$_REQUEST['pCAS']:0;
    //$pDesde = isset($_REQUEST['pDesde'])?$_REQUEST['pDesde']:null;
    //$pHasta = isset($_REQUEST['pHasta'])?$_REQUEST['pHasta']:null;
    //if ($pDesde == "" || $pDesde == null)
    //    $pFiltroFec = "N";
    //else
    //    $pFiltroFec = "S";
    $gBaseDatos = new ofiMySQLi();
    $gBaseDatos->conectar();
    $qry = "CALL sp_asistencial_hc_serviciossolicitados_ofimedical(\"R\",'" . $pEmpresa . "','" . $pIPS . "','" . $pPaciente . "','" . $pCAS . "')";
    //echo $qry;
    @mysqli_query("\"SET NAMES UTF8\"");
    $gBaseDatos->QryID = @mysqli_query($gBaseDatos->ConexionID, $qry);
    $arr = array();
    while($row = @mysqli_fetch_assoc($gBaseDatos->QryID))
    {
        $nRow = $row;
        foreach($row as $key => $val)
        {
            $nRow[$key] = utf8_decode($val);
        }
        $arr[] = $nRow;
    }
    $gBaseDatos->liberar();
    $gBaseDatos->cerrar();
    $jsonresult = JEncode($arr);
    if (!is_null($jsonresult))
        echo '({"total":"0","results":'. $jsonresult .'})';
}

function VerExaSolicitadosxHC_ofimedical(){
    $pEmpresa = isset($_REQUEST['pEmpresa'])?$_REQUEST['pEmpresa']:0;
    $pIPS = isset($_REQUEST['pIPS'])?$_REQUEST['pIPS']:0;
    $pPaciente = isset($_REQUEST['pPaciente'])?$_REQUEST['pPaciente']:0;
    $pCAS = isset($_REQUEST['pCAS'])?$_REQUEST['pCAS']:0;
    //$pDesde = isset($_REQUEST['pDesde'])?$_REQUEST['pDesde']:null;
    //$pHasta = isset($_REQUEST['pHasta'])?$_REQUEST['pHasta']:null;
    //if ($pDesde == "" || $pDesde == null)
    //    $pFiltroFec = "N";
    //else
    //    $pFiltroFec = "S";
    $gBaseDatos = new ofiMySQLi();
    $gBaseDatos->conectar();
    $qry = "CALL sp_asistencial_hc_serviciossolicitados_ofimedical(\"E\",'" . $pEmpresa . "','" . $pIPS . "','" . $pPaciente . "','" . $pCAS . "')";
    //echo $qry;
    @mysqli_query("\"SET NAMES UTF8\"");
    $gBaseDatos->QryID = @mysqli_query($gBaseDatos->ConexionID, $qry);
    $arr = array();
    while($row = @mysqli_fetch_assoc($gBaseDatos->QryID))
    {
        $nRow = $row;
        foreach($row as $key => $val)
        {
            $nRow[$key] = utf8_decode($val);
        }
        $arr[] = $nRow;
    }
    $gBaseDatos->liberar();
    $gBaseDatos->cerrar();
    $jsonresult = JEncode($arr);
    if (!is_null($jsonresult))
        echo '({"total":"0","results":'. $jsonresult .'})';
}

function VerMxSolicitadosxHC_ofimedical(){
    $pEmpresa = isset($_REQUEST['pEmpresa'])?$_REQUEST['pEmpresa']:0;
    $pIPS = isset($_REQUEST['pIPS'])?$_REQUEST['pIPS']:0;
    $pPaciente = isset($_REQUEST['pPaciente'])?$_REQUEST['pPaciente']:0;
    $pCAS = isset($_REQUEST['pCAS'])?$_REQUEST['pCAS']:0;
    //$pDesde = isset($_REQUEST['pDesde'])?$_REQUEST['pDesde']:null;
    //$pHasta = isset($_REQUEST['pHasta'])?$_REQUEST['pHasta']:null;
    //if ($pDesde == "" || $pDesde == null)
    //    $pFiltroFec = "N";
    //else
    //    $pFiltroFec = "S";
    $gBaseDatos = new ofiMySQLi();
    $gBaseDatos->conectar();
    $qry = "CALL sp_asistencial_hc_serviciossolicitados_ofimedical(\"M\",'" . $pEmpresa . "','" . $pIPS . "','" . $pPaciente . "','" . $pCAS . "')";
    //echo $qry;
    @mysqli_query("\"SET NAMES UTF8\"");
    $gBaseDatos->QryID = @mysqli_query($gBaseDatos->ConexionID, $qry);
    $arr = array();
    while($row = @mysqli_fetch_assoc($gBaseDatos->QryID))
    {
        $nRow = $row;
        foreach($row as $key => $val)
        {
            $nRow[$key] = utf8_decode($val);
        }
        $arr[] = $nRow;
    }
    $gBaseDatos->liberar();
    $gBaseDatos->cerrar();
    $jsonresult = JEncode($arr);
    if (!is_null($jsonresult))
        echo '({"total":"0","results":'. $jsonresult .'})';
}

function GuardarResumenNeurodesarrollo(){

    $estructura = explode("¬", $_REQUEST['CAMPOS']);
    $pProceso = isset($_REQUEST['pProceso'])?$_REQUEST['pProceso']:"NA";
    $qry = "CALL sp_neurodesa_resumenhc_update(\"" . $pProceso . "\"," . spParametros($estructura,"NO") . ")";
    //echo $qry;
    $gBaseDatos = new ofiMySQLi();
    $gBaseDatos->conectar();
    if(@mysqli_query($gBaseDatos->ConexionID, $qry))
        echo "{success: true, requestedId:'1'}";
    else
       echo "{success: true, requestedId:'0'}";
    $gBaseDatos->cerrar();   
}

function VerResumenNeurodesarrollo(){
    $pEmpresa = isset($_REQUEST['pEmpresa'])?$_REQUEST['pEmpresa']:0;
    $pIPS = isset($_REQUEST['pIPS'])?$_REQUEST['pIPS']:0;
    $pPaciente = isset($_REQUEST['pPaciente'])?$_REQUEST['pPaciente']:0;
    $gBaseDatos = new ofiMySQLi();
    $gBaseDatos->conectar();
    $qry = "CALL sp_neurodesa_resumenhc_listar('" . $pEmpresa . "','" . $pIPS . "','" . $pPaciente . "')";
    //echo $qry;
    $gBaseDatos->QryID = @mysqli_query($gBaseDatos->ConexionID, $qry);
    $arr = array();
    while($row = @mysqli_fetch_assoc($gBaseDatos->QryID))
    {
        $nRow = $row;
        foreach($row as $key => $val)
        {
            $nRow[$key] = utf8_decode(str_replace("\n\n", "\n",preg_replace('/\<br(\s*)?\/?\>/i', "\n",$val)));
        }
        $arr[] = $nRow;
    }
    $gBaseDatos->liberar();
    $gBaseDatos->cerrar();
    $jsonresult = JEncode($arr);
    if (!is_null($jsonresult))
        echo '({"total":"0","results":'. $jsonresult .'})';
}

function CrearResumenNeurodesarrollo(){
    $pEmpresa = isset($_REQUEST['pEmpresa'])?$_REQUEST['pEmpresa']:0;
    $pIPS = isset($_REQUEST['pIPS'])?$_REQUEST['pIPS']:0;
    $pPaciente = isset($_REQUEST['pPaciente'])?$_REQUEST['pPaciente']:0;
    $pCliente = isset($_REQUEST['pCliente'])?$_REQUEST['pCliente']:0;
    $pAno = isset($_REQUEST['pAno'])?$_REQUEST['pAno']:0;
    $pMes = isset($_REQUEST['pMes'])?$_REQUEST['pMes']:0;
    $gBaseDatos = new ofiMySQLi();
    $gBaseDatos->conectar();
    $qry = "CALL sp_neurodesa_resumenhc_crear('" . $pEmpresa . "','" . $pIPS . "','" . $pPaciente . "','" . $pCliente . "','" . $pAno . "',\"" . $pMes . "\")";
    //echo $qry;
    if(@mysqli_query($gBaseDatos->ConexionID, $qry))
        echo "{success: true, requestedId:'1'}";
    else
       echo "{success: true, requestedId:'0'}";
    $gBaseDatos->cerrar();   
}

function VerHistorialHCxPacienteSinEvolucionar(){
    $pEmpresa = isset($_REQUEST['pEmpresa'])?$_REQUEST['pEmpresa']:0;
    $pIPS = isset($_REQUEST['pIPS'])?$_REQUEST['pIPS']:0;
    $pPaciente = isset($_REQUEST['pPaciente'])?$_REQUEST['pPaciente']:0;
    $pProfesional = isset($_REQUEST['pProfesional'])?$_REQUEST['pProfesional']:0;
    $pDesde = isset($_REQUEST['pDesde'])?$_REQUEST['pDesde']:null;
    $pHasta = isset($_REQUEST['pHasta'])?$_REQUEST['pHasta']:null;
    if ($pDesde == "" || $pDesde == null)
        $pFiltroFec = "N";
    else
        $pFiltroFec = "S";
    $gBaseDatos = new ofiMySQLi();
    $gBaseDatos->conectar();
    $qry = "CALL sp_pacientes_hc_sinevolucionar('" . $pEmpresa . "','" . $pIPS . "','" . $pPaciente . "','" . $pProfesional . "')";
    //echo $qry;
    @mysqli_query("\"SET NAMES UTF8\"");
    $gBaseDatos->QryID = @mysqli_query($gBaseDatos->ConexionID, $qry);
    $arr = array();
    while($row = @mysqli_fetch_assoc($gBaseDatos->QryID))
    {
        $nRow = $row;
        foreach($row as $key => $val)
        {
            $nRow[$key] = utf8_decode($val);
        }
        $arr[] = $nRow;
    }
    $gBaseDatos->liberar();
    $gBaseDatos->cerrar();
    $jsonresult = JEncode($arr);
    if (!is_null($jsonresult))
        echo '({"total":"0","results":'. $jsonresult .'})';
}

function VerHistorialHCxPacienteFiltro(){
    $pEmpresa = isset($_REQUEST['pEmpresa'])?$_REQUEST['pEmpresa']:0;
    $pPaciente = isset($_REQUEST['pPaciente'])?$_REQUEST['pPaciente']:0;
    $pProfesional = isset($_REQUEST['pProfesional'])?$_REQUEST['pProfesional']:0;
    $pDesde = isset($_REQUEST['pDesde'])?$_REQUEST['pDesde']:null;
    $pHasta = isset($_REQUEST['pHasta'])?$_REQUEST['pHasta']:null;
    if ($pDesde == "" || $pDesde == null)
        $pFiltroFec = "N";
    else
        $pFiltroFec = "S";
    $gBaseDatos = new ofiMySQLi();
    $gBaseDatos->conectar();
    $qry = "CALL sp_asistencial_evolucionesxpaciente_filtro('" . $pEmpresa . "','" . $pPaciente . "','" . $pProfesional . "',\"" . $pDesde . "\",\"" . $pHasta . "\",\"" . $pFiltroFec . "\")";
    //echo $qry;
    $gBaseDatos->QryID = @mysqli_query($gBaseDatos->ConexionID, $qry);
    $arr = array();
    while($row = @mysqli_fetch_assoc($gBaseDatos->QryID))
    {
        $nRow = $row;
        foreach($row as $key => $val)
        {
            $nRow[$key] = utf8_decode($val);
        }
        $arr[] = $nRow;
    }
    $gBaseDatos->liberar();
    $gBaseDatos->cerrar();
    $jsonresult = JEncode($arr);
    if (!is_null($jsonresult))
        echo '({"total":"0","results":'. $jsonresult .'})';
}
        
function VerHistorialHCxPaciente(){
    $pEmpresa = isset($_REQUEST['pEmpresa'])?$_REQUEST['pEmpresa']:0;
    $pPaciente = isset($_REQUEST['pPaciente'])?$_REQUEST['pPaciente']:0;
    $gBaseDatos = new ofiMySQLi();
    $gBaseDatos->conectar();
    $qry = "CALL sp_asistencial_evolucionesxpaciente('" . $pEmpresa . "','" . $pPaciente . "')";
    $gBaseDatos->QryID = @mysqli_query($gBaseDatos->ConexionID, $qry);
    $arr = array();
    while($row = @mysqli_fetch_assoc($gBaseDatos->QryID))
    {
        $nRow = $row;
        foreach($row as $key => $val)
        {
            $nRow[$key] = utf8_decode($val);
        }
        $arr[] = $nRow;
    }
    $gBaseDatos->liberar();
    $gBaseDatos->cerrar();
    $jsonresult = JEncode($arr);
    if (!is_null($jsonresult))
        echo '({"total":"0","results":'. $jsonresult .'})';
}

function GuardarHC(){
    $pEmpresa = isset($_REQUEST['pEmpresa'])?$_REQUEST['pEmpresa']:0;
    $pIPS = isset($_REQUEST['pIPS'])?$_REQUEST['pIPS']:0;
    $pPaciente = isset($_REQUEST['pPaciente'])?$_REQUEST['pPaciente']:0;
    //$pProfesional = isset($_REQUEST['pProfesional'])?$_REQUEST['pProfesional']:0;
    $pProfesional = $_SESSION['ID_PROFESIONAL_HC'];
    $pCAS = isset($_REQUEST['pCAS'])?$_REQUEST['pCAS']:0;
    $pConsecutivoDetalle = isset($_REQUEST['pConsecutivoDetalle'])?$_REQUEST['pConsecutivoDetalle']:0;
    $pidPlantillaHC = isset($_REQUEST['pidPlantillaHC'])?$_REQUEST['pidPlantillaHC']:0;
    $pFechaAtencion = isset($_REQUEST['pFechaAtencion'])?$_REQUEST['pFechaAtencion']:null;
    $pHoraApertura = isset($_REQUEST['pHoraApertura'])?$_REQUEST['pHoraApertura']:null;
    $pActividad = isset($_REQUEST['pActividad'])?$_REQUEST['pActividad']:null;
    $pPlantilla = isset($_REQUEST['pPlantilla'])?$_REQUEST['pPlantilla']:null;
    $pRutaRptHC = isset($_REQUEST['pRutaRptHC'])?$_REQUEST['pRutaRptHC']:null;
    $pRutaRptMx = isset($_REQUEST['pRutaRptMx'])?$_REQUEST['pRutaRptMx']:null;
    $pRutaRptExa = isset($_REQUEST['pRutaRptExa'])?$_REQUEST['pRutaRptExa']:null;
    $pRutaRptRem = isset($_REQUEST['pRutaRptRem'])?$_REQUEST['pRutaRptRem']:null;
    $contenido = isset($_REQUEST['CAMPOS'])?$_REQUEST['CAMPOS']:null;
    $pEvolucion = stripslashes(utf8_encode(str_replace('"', '""',nl2br($contenido))));
    $pDiagppal = isset($_REQUEST['pDiagppal'])?$_REQUEST['pDiagppal']:null;
    $pDiagrel1 = isset($_REQUEST['pDiagrel1'])?$_REQUEST['pDiagrel1']:null;
    $pDiagrel2 = isset($_REQUEST['pDiagrel2'])?$_REQUEST['pDiagrel2']:null;
    $pDiagrel3 = isset($_REQUEST['pDiagrel3'])?$_REQUEST['pDiagrel3']:null;
    $pTipodiag = isset($_REQUEST['pTipodiag'])?$_REQUEST['pTipodiag']:null;
    $pFinalidad = isset($_REQUEST['pFinalidad'])?$_REQUEST['pFinalidad']:null;
    $pCausa = isset($_REQUEST['pCausa'])?$_REQUEST['pCausa']:null;
    $pAmbito = isset($_REQUEST['pAmbito'])?$_REQUEST['pAmbito']:null;
    $pFinalidadProced = isset($_REQUEST['pFinalidadProced'])?$_REQUEST['pFinalidadProced']:null;
    $pPersonalAtiende = isset($_REQUEST['pPersonalAtiende'])?$_REQUEST['pPersonalAtiende']:null;
    $pFormaActo = isset($_REQUEST['pFormaActo'])?$_REQUEST['pFormaActo']:null;
    $pUsuario = isset($_REQUEST['pUsuario'])?$_REQUEST['pUsuario']:0;
    $pIdCliente = isset($_REQUEST['pIdCliente'])?$_REQUEST['pIdCliente']:0;
    $pIdPlan = isset($_REQUEST['pIdPlan'])?$_REQUEST['pIdPlan']:0;
    $pIdSubPlan = isset($_REQUEST['pIdSubPlan'])?$_REQUEST['pIdSubPlan']:0;
    $pIdContrato = isset($_REQUEST['pIdContrato'])?$_REQUEST['pIdContrato']:0;
    $pAutorizacion = isset($_REQUEST['pAutorizacion'])?$_REQUEST['pAutorizacion']:null;
    if($pAutorizacion == null || $pAutorizacion == ""){
        $pAutorizacion = "NA";
    }
    $pCambiaCliente = isset($_REQUEST['pCambiaCliente'])?$_REQUEST['pCambiaCliente']:"NA";
    $pGuardarSignos = isset($_REQUEST['pGuardarSignos'])?$_REQUEST['pGuardarSignos']:"NO";
    $pTalla = isset($_REQUEST['pTalla'])?$_REQUEST['pTalla']:null;
    $pPeso = isset($_REQUEST['pPeso'])?$_REQUEST['pPeso']:null;
    $pIMC = isset($_REQUEST['pIMC'])?$_REQUEST['pIMC']:null;
    $pIMCClasifica = isset($_REQUEST['pIMCClasifica'])?$_REQUEST['pIMCClasifica']:null;
    $pTE = isset($_REQUEST['pTE'])?$_REQUEST['pTE']:null;
    $pPerimetroCefalico = isset($_REQUEST['pPerimetroCefalico'])?$_REQUEST['pPerimetroCefalico']:null;
    $pPerimetroToraxico = isset($_REQUEST['pPerimetroToraxico'])?$_REQUEST['pPerimetroToraxico']:null;
    $pTASIS = isset($_REQUEST['pTASIS'])?$_REQUEST['pTASIS']:null;
    $pTADIAS = isset($_REQUEST['pTADIAS'])?$_REQUEST['pTADIAS']:null;
    $pAnios = isset($_REQUEST['pAnios'])?$_REQUEST['pAnios']:null;
    $pMeses = isset($_REQUEST['pMeses'])?$_REQUEST['pMeses']:null;
    $pFormulacion = isset($_REQUEST['pFormulacion'])?$_REQUEST['pFormulacion']:1;
    if($pFormulacion == null || $pFormulacion == ""){
        $pFormulacion = 1;
    }
    
    $pOcupacion4505 = isset($_REQUEST['pOcupacion4505'])?$_REQUEST['pOcupacion4505']:null;
    $pEtnia4505 = isset($_REQUEST['pEtnia4505'])?$_REQUEST['pEtnia4505']:null;
    $pEscolaridad4505 = isset($_REQUEST['pEscolaridad4505'])?$_REQUEST['pEscolaridad4505']:null;
    $pGestacion4505 = isset($_REQUEST['pGestacion4505'])?$_REQUEST['pGestacion4505']:null;
    $pSifilisGestacional4505 = isset($_REQUEST['pSifilisGestacional4505'])?$_REQUEST['pSifilisGestacional4505']:null;
    $pHipertencionGestacional4505 = isset($_REQUEST['pHipertencionGestacional4505'])?$_REQUEST['pHipertencionGestacional4505']:null;
    $pHipotiroidismoCongenito4505 = isset($_REQUEST['pHipotiroidismoCongenito4505'])?$_REQUEST['pHipotiroidismoCongenito4505']:null;
    $pTuberculosisMultidrogoresistente4505 = isset($_REQUEST['pTuberculosisMultidrogoresistente4505'])?$_REQUEST['pTuberculosisMultidrogoresistente4505']:null;
    $pLepra4505 = isset($_REQUEST['pLepra4505'])?$_REQUEST['pLepra4505']:null;
    $pVictimaMaltrato4505 = isset($_REQUEST['pVictimaMaltrato4505'])?$_REQUEST['pVictimaMaltrato4505']:null;
    $pViolenciaSexual4505 = isset($_REQUEST['pViolenciaSexual4505'])?$_REQUEST['pViolenciaSexual4505']:null;
    $pFluorosisDental4505 = isset($_REQUEST['pFluorosisDental4505'])?$_REQUEST['pFluorosisDental4505']:null;
    $pTensionArterialSistolicaPie = isset($_REQUEST['pTensionArterialSistolicaPie'])?$_REQUEST['pTensionArterialSistolicaPie']:null;
    $pTensionArterialDiastolicaPie = isset($_REQUEST['pTensionArterialDiastolicaPie'])?$_REQUEST['pTensionArterialDiastolicaPie']:null;
    $pPerimetroAbdominal = isset($_REQUEST['pPerimetroAbdominal'])?$_REQUEST['pPerimetroAbdominal']:null;
    $pAlturaUterina = isset($_REQUEST['pAlturaUterina'])?$_REQUEST['pAlturaUterina']:null;
    $pFetocardiaFetal = isset($_REQUEST['pFetocardiaFetal'])?$_REQUEST['pFetocardiaFetal']:null;
    $pFC = isset($_REQUEST['pFC'])?$_REQUEST['pFC']:null;
    $pFR = isset($_REQUEST['pFR'])?$_REQUEST['pFR']:null;
    $pPostTestVIH4505 = isset($_REQUEST['pPostTestVIH4505'])?$_REQUEST['pPostTestVIH4505']:null;
    $pPreTestVIH4505 = isset($_REQUEST['pPreTestVIH4505'])?$_REQUEST['pPreTestVIH4505']:null;
    $pAdultoPrimeraVez4505 = isset($_REQUEST['pAdultoPrimeraVez4505'])?$_REQUEST['pAdultoPrimeraVez4505']:null;
    $pJovenPrimeraVez4505 = isset($_REQUEST['pJovenPrimeraVez4505'])?$_REQUEST['pJovenPrimeraVez4505']:null;
    $pCyDPrimeraVez4505 = isset($_REQUEST['pCyDPrimeraVez4505'])?$_REQUEST['pCyDPrimeraVez4505']:null;
    $pPsicologia4505 = isset($_REQUEST['pPsicologia4505'])?$_REQUEST['pPsicologia4505']:null;
    $pNutricion4505 = isset($_REQUEST['pNutricion4505'])?$_REQUEST['pNutricion4505']:null;
    $pConsultaViolenciaSexual4505 = isset($_REQUEST['pConsultaViolenciaSexual4505'])?$_REQUEST['pConsultaViolenciaSexual4505']:null;
    $pMaltrato4505 = isset($_REQUEST['pMaltrato4505'])?$_REQUEST['pMaltrato4505']:null;
    $pOftalmologia4505 = isset($_REQUEST['pOftalmologia4505'])?$_REQUEST['pOftalmologia4505']:null;
    $pAgudezaVisual4505 = isset($_REQUEST['pAgudezaVisual4505'])?$_REQUEST['pAgudezaVisual4505']:null;
    $pPrenatalControl4505 = isset($_REQUEST['pPrenatalControl4505'])?$_REQUEST['pPrenatalControl4505']:null;
    $pPrenatalPrimeraVez4505 = isset($_REQUEST['pPrenatalPrimeraVez4505'])?$_REQUEST['pPrenatalPrimeraVez4505']:null;
    $pPlanificacion4505 = isset($_REQUEST['pPlanificacion4505'])?$_REQUEST['pPlanificacion4505']:null;
    $pCodIPSTomaBiopsiaSeno4505 = isset($_REQUEST['pCodIPSTomaBiopsiaSeno4505'])?$_REQUEST['pCodIPSTomaBiopsiaSeno4505']:null;
    $pResultadoBiopsiaSeno4505 = isset($_REQUEST['pResultadoBiopsiaSeno4505'])?$_REQUEST['pResultadoBiopsiaSeno4505']:null;
    $pCodIPSTomaMamografia4505 = isset($_REQUEST['pCodIPSTomaMamografia4505'])?$_REQUEST['pCodIPSTomaMamografia4505']:null;
    $pResultadoMamografia4505 = isset($_REQUEST['pResultadoMamografia4505'])?$_REQUEST['pResultadoMamografia4505']:null;
    $pCodIPSTomaBiopsiaCervical4505 = isset($_REQUEST['pCodIPSTomaBiopsiaCervical4505'])?$_REQUEST['pCodIPSTomaBiopsiaCervical4505']:null;
    $pCodIPSTomaColposcopia4505 = isset($_REQUEST['pCodIPSTomaColposcopia4505'])?$_REQUEST['pCodIPSTomaColposcopia4505']:null;
    $pResultadoBiopsiaCervical4505 = isset($_REQUEST['pResultadoBiopsiaCervical4505'])?$_REQUEST['pResultadoBiopsiaCervical4505']:null;
    $pCodIPSTomaCitologia4505 = isset($_REQUEST['pCodIPSTomaCitologia4505'])?$_REQUEST['pCodIPSTomaCitologia4505']:null;
    $pCalidadMuestraCitologia4505 = isset($_REQUEST['pCalidadMuestraCitologia4505'])?$_REQUEST['pCalidadMuestraCitologia4505']:null;
    $pResultadoCitologia4505 = isset($_REQUEST['pResultadoCitologia4505'])?$_REQUEST['pResultadoCitologia4505']:null;
    $pCitologia4505 = isset($_REQUEST['pCitologia4505'])?$_REQUEST['pCitologia4505']:null;
    $pColposcopia4505 = isset($_REQUEST['pColposcopia4505'])?$_REQUEST['pColposcopia4505']:null;
    $pBiopsiaCervical4505 = isset($_REQUEST['pBiopsiaCervical4505'])?$_REQUEST['pBiopsiaCervical4505']:null;
    $pMamografia4505 = isset($_REQUEST['pMamografia4505'])?$_REQUEST['pMamografia4505']:null;
    $pBiopsiaSeno4505 = isset($_REQUEST['pBiopsiaSeno4505'])?$_REQUEST['pBiopsiaSeno4505']:null;
    $pTomaHemoglobina = isset($_REQUEST['pTomaHemoglobina'])?$_REQUEST['pTomaHemoglobina']:null;
    $pResultadoHemoglobina = isset($_REQUEST['pResultadoHemoglobina'])?$_REQUEST['pResultadoHemoglobina']:null;
    $pTomaCreatinina = isset($_REQUEST['pTomaCreatinina'])?$_REQUEST['pTomaCreatinina']:null;
    $pResultadoCreatinina = isset($_REQUEST['pResultadoCreatinina'])?$_REQUEST['pResultadoCreatinina']:null;
    $pTomaHemoglobinaGlicosilada = isset($_REQUEST['pTomaHemoglobinaGlicosilada'])?$_REQUEST['pTomaHemoglobinaGlicosilada']:null;
    $pResultadoHemoglobinaGlicosilada = isset($_REQUEST['pResultadoHemoglobinaGlicosilada'])?$_REQUEST['pResultadoHemoglobinaGlicosilada']:null;
    $pTomaGlicemia = isset($_REQUEST['pTomaGlicemia'])?$_REQUEST['pTomaGlicemia']:null;
    $pTomaMicroalbuminuria = isset($_REQUEST['pTomaMicroalbuminuria'])?$_REQUEST['pTomaMicroalbuminuria']:null;
    $pTomaHDL = isset($_REQUEST['pTomaHDL'])?$_REQUEST['pTomaHDL']:null;
    $pTomaBaciloscopiaDiagnostica = isset($_REQUEST['pTomaBaciloscopiaDiagnostica'])?$_REQUEST['pTomaBaciloscopiaDiagnostica']:null;
    $pResultadoBaciloscopiaDiagnostica = isset($_REQUEST['pResultadoBaciloscopiaDiagnostica'])?$_REQUEST['pResultadoBaciloscopiaDiagnostica']:null;
    $pSerologia = isset($_REQUEST['pSerologia'])?$_REQUEST['pSerologia']:null;
    $pResultadoSerologia = isset($_REQUEST['pResultadoSerologia'])?$_REQUEST['pResultadoSerologia']:null;
    $pTomaElisaVIH = isset($_REQUEST['pTomaElisaVIH'])?$_REQUEST['pTomaElisaVIH']:null;
    $pResultadoElisaVIH = isset($_REQUEST['pResultadoElisaVIH'])?$_REQUEST['pResultadoElisaVIH']:null;
    $pTSHNeonatal = isset($_REQUEST['pTSHNeonatal'])?$_REQUEST['pTSHNeonatal']:null;
    $pResultadoTSHNeonatal = isset($_REQUEST['pResultadoTSHNeonatal'])?$_REQUEST['pResultadoTSHNeonatal']:null;
    $pBCG = isset($_REQUEST['pBCG'])?$_REQUEST['pBCG']:null;
    $pHepatitisB = isset($_REQUEST['pHepatitisB'])?$_REQUEST['pHepatitisB']:null;
    $pPentavalente = isset($_REQUEST['pPentavalente'])?$_REQUEST['pPentavalente']:null;
    $pPolio = isset($_REQUEST['pPolio'])?$_REQUEST['pPolio']:null;
    $pDPT = isset($_REQUEST['pDPT'])?$_REQUEST['pDPT']:null;
    $pRotavirus = isset($_REQUEST['pRotavirus'])?$_REQUEST['pRotavirus']:null;
    $pNeumococo = isset($_REQUEST['pNeumococo'])?$_REQUEST['pNeumococo']:null;
    $pInfluenza = isset($_REQUEST['pInfluenza'])?$_REQUEST['pInfluenza']:null;
    $pFiebreAmarilla = isset($_REQUEST['pFiebreAmarilla'])?$_REQUEST['pFiebreAmarilla']:null;
    $pHepatitisA = isset($_REQUEST['pHepatitisA'])?$_REQUEST['pHepatitisA']:null;
    $pTripleViral = isset($_REQUEST['pTripleViral'])?$_REQUEST['pTripleViral']:null;
    $pVPH = isset($_REQUEST['pVPH'])?$_REQUEST['pVPH']:null;
    $pTD = isset($_REQUEST['pTD'])?$_REQUEST['pTD']:null;
    
    $gBaseDatos = new ofiMySQLi();
    $gBaseDatos->conectar();
    $qry = "CALL sp_asistencial_add_evolucion2013('" . $pEmpresa . "','" . $pIPS . "','" . $pPaciente . "','" . $pProfesional . "','" . $pCAS . "','" . $pConsecutivoDetalle . "','" . $pidPlantillaHC . "',\"" . $pFechaAtencion . "\",\"" . $pHoraApertura . "\",\"" . $pActividad . "\",\"" . $pPlantilla . "\",\"" . $pRutaRptHC . "\",\"" . $pRutaRptMx . "\",\"" . $pRutaRptExa . "\",\"" . $pRutaRptRem . "\",\"" . $pEvolucion . "\",\"" . $pDiagppal . "\",\"" . $pDiagrel1 . "\",\"" . $pDiagrel2 . "\",\"" . $pDiagrel3 . "\",\"" . $pTipodiag . "\",\"" . $pFinalidad . "\",\"" . $pCausa . "\",\"" . $pAmbito . "\",\"" . $pFinalidadProced . "\",\"" . $pPersonalAtiende . "\",\"" . $pFormaActo . "\",'" . $pUsuario . "','" . $pIdCliente . "','" . $pIdPlan . "','" . $pIdSubPlan . "','" . $pIdContrato . "',\"" . $pAutorizacion . "\",\"" . $pCambiaCliente . "\",'" . $pFormulacion . "')";
    //echo $qry;
    if(@mysqli_query($gBaseDatos->ConexionID, $qry)){
        $gBaseDatos->cerrar();
        if($pGuardarSignos === "SI"){
            $gBaseDatos = new ofiMySQLi();
            $gBaseDatos->conectar();
            $qry = "CALL sp_asistencial_add_tomasignos('" . $pEmpresa . "','" . $pIPS . "','" . $pPaciente . "','" . $pProfesional . "',\"" . $pFechaAtencion . "\",'" . $pCAS . "','" . $pAnios . "','" . $pMeses . "','" . $pTalla . "','" . $pPeso . "','" . $pIMC . "',\"" . $pIMCClasifica . "\",'" . $pTE . "','" . $pPerimetroCefalico . "','" . $pPerimetroToraxico . "','" . $pTASIS . "','" . $pTADIAS . "','" . $pOcupacion4505 . "','" . $pEtnia4505 . "','" . $pEscolaridad4505 . "','" . $pGestacion4505 . "','" . $pSifilisGestacional4505 . "','" . $pHipertencionGestacional4505 . "','" . $pHipotiroidismoCongenito4505 . "','" . $pTuberculosisMultidrogoresistente4505 . "','" . $pLepra4505 . "','" . $pVictimaMaltrato4505 . "','" . $pViolenciaSexual4505 . "','" . $pFluorosisDental4505 . "','" . $pTensionArterialSistolicaPie . "','" . $pTensionArterialDiastolicaPie . "','" . $pPerimetroAbdominal . "','" . $pAlturaUterina . "','" . $pFetocardiaFetal . "','" . $pFC . "','" . $pFR . "',\"" . $pPostTestVIH4505 . "\",\"" . $pPreTestVIH4505 . "\",\"" . $pAdultoPrimeraVez4505 . "\",\"" . $pJovenPrimeraVez4505 . "\",\"" . $pCyDPrimeraVez4505 . "\",\"" . $pPsicologia4505 . "\",\"" . $pNutricion4505 . "\",\"" . $pConsultaViolenciaSexual4505 . "\",\"" . $pMaltrato4505 . "\",\"" . $pOftalmologia4505 . "\",\"" . $pAgudezaVisual4505 . "\",\"" . $pPrenatalControl4505 . "\",\"" . $pPrenatalPrimeraVez4505 . "\",\"" . $pPlanificacion4505 . "\",\"" . $pBiopsiaSeno4505 . "\",\"" . $pMamografia4505 . "\",\"" . $pBiopsiaCervical4505 . "\",\"" . $pColposcopia4505  . "\",\"" . $pCitologia4505 . "\",'" . $pResultadoCitologia4505 . "','" . $pCalidadMuestraCitologia4505 . "','" . $pCodIPSTomaCitologia4505 . "','" . $pCodIPSTomaColposcopia4505 . "','" . $pResultadoBiopsiaCervical4505 . "','" . $pCodIPSTomaBiopsiaCervical4505 . "','" . $pResultadoMamografia4505 . "','" . $pCodIPSTomaMamografia4505 . "','" . $pResultadoBiopsiaSeno4505 . "','" . $pCodIPSTomaBiopsiaSeno4505 . "',\"" . $pTomaHemoglobina . "\",'" . $pResultadoHemoglobina . "',\"" . $pTomaCreatinina . "\",'" . $pResultadoCreatinina . "',\"" . $pTomaHemoglobinaGlicosilada . "\",'" . $pResultadoHemoglobinaGlicosilada . "',\"" . $pTomaGlicemia . "\",\"" . $pTomaMicroalbuminuria . "\",\"" . $pTomaHDL . "\",\"" . $pTomaBaciloscopiaDiagnostica . "\",'" . $pResultadoBaciloscopiaDiagnostica . "',\"" . $pSerologia . "\",'" . $pResultadoSerologia . "',\"" . $pTomaElisaVIH . "\",'" . $pResultadoElisaVIH . "',\"" . $pTSHNeonatal . "\",'" . $pResultadoTSHNeonatal . "','" . $pBCG . "','" . $pHepatitisB . "','" . $pPentavalente . "','" . $pPolio . "','" . $pDPT . "','" . $pRotavirus . "','" . $pNeumococo . "','" . $pInfluenza . "','" . $pFiebreAmarilla . "','" . $pHepatitisA . "','" . $pTripleViral . "','" . $pVPH . "','" . $pTD . "')";
            //echo $qry;
            @mysqli_query($gBaseDatos->ConexionID, $qry);
            $gBaseDatos->cerrar();
        }
        echo "{success: true, requestedId:'1'}";
    }else{
       echo "{success: true, requestedId:'0'}";
       $gBaseDatos->cerrar();   
    }
}

function ModificarHC(){
    $pEmpresa = isset($_REQUEST['pEmpresa'])?$_REQUEST['pEmpresa']:0;
    $pIPS = isset($_REQUEST['pIPS'])?$_REQUEST['pIPS']:0;
    $pPaciente = isset($_REQUEST['pPaciente'])?$_REQUEST['pPaciente']:0;
    //$pProfesional = isset($_REQUEST['pProfesional'])?$_REQUEST['pProfesional']:0;
    $pProfesional = $_SESSION['ID_PROFESIONAL_HC'];
    $pCAS = isset($_REQUEST['pCAS'])?$_REQUEST['pCAS']:0;
    $pConsecutivoDetalle = isset($_REQUEST['pConsecutivoDetalle'])?$_REQUEST['pConsecutivoDetalle']:0;
    $pFechaAtencion = isset($_REQUEST['pFechaAtencion'])?$_REQUEST['pFechaAtencion']:null;
    $pHoraApertura = isset($_REQUEST['pHoraApertura'])?$_REQUEST['pHoraApertura']:null;
    $pActividad = isset($_REQUEST['pActividad'])?$_REQUEST['pActividad']:null;
    $pPlantilla = isset($_REQUEST['pPlantilla'])?$_REQUEST['pPlantilla']:null;
    $pRutaRptHC = isset($_REQUEST['pRutaRptHC'])?$_REQUEST['pRutaRptHC']:null;
    $pRutaRptMx = isset($_REQUEST['pRutaRptMx'])?$_REQUEST['pRutaRptMx']:null;
    $pRutaRptExa = isset($_REQUEST['pRutaRptExa'])?$_REQUEST['pRutaRptExa']:null;
    $pRutaRptRem = isset($_REQUEST['pRutaRptRem'])?$_REQUEST['pRutaRptRem']:null;
    $contenido = isset($_REQUEST['CAMPOS'])?$_REQUEST['CAMPOS']:null;
    $pEvolucion = stripslashes(utf8_encode(str_replace('"', '""',nl2br($contenido))));
    $pDiagppal = isset($_REQUEST['pDiagppal'])?$_REQUEST['pDiagppal']:null;
    $pDiagrel1 = isset($_REQUEST['pDiagrel1'])?$_REQUEST['pDiagrel1']:null;
    $pDiagrel2 = isset($_REQUEST['pDiagrel2'])?$_REQUEST['pDiagrel2']:null;
    $pDiagrel3 = isset($_REQUEST['pDiagrel3'])?$_REQUEST['pDiagrel3']:null;
    $pTipodiag = isset($_REQUEST['pTipodiag'])?$_REQUEST['pTipodiag']:null;
    $pFinalidad = isset($_REQUEST['pFinalidad'])?$_REQUEST['pFinalidad']:null;
    $pCausa = isset($_REQUEST['pCausa'])?$_REQUEST['pCausa']:null;
    $pAmbito = isset($_REQUEST['pAmbito'])?$_REQUEST['pAmbito']:null;
    $pFinalidadProced = isset($_REQUEST['pFinalidadProced'])?$_REQUEST['pFinalidadProced']:null;
    $pPersonalAtiende = isset($_REQUEST['pPersonalAtiende'])?$_REQUEST['pPersonalAtiende']:null;
    $pFormaActo = isset($_REQUEST['pFormaActo'])?$_REQUEST['pFormaActo']:null;
    $pUsuario = isset($_REQUEST['pUsuario'])?$_REQUEST['pUsuario']:0;
    $pIdCliente = isset($_REQUEST['pIdCliente'])?$_REQUEST['pIdCliente']:0;
    $pIdPlan = isset($_REQUEST['pIdPlan'])?$_REQUEST['pIdPlan']:0;
    $pIdSubPlan = isset($_REQUEST['pIdSubPlan'])?$_REQUEST['pIdSubPlan']:0;
    $pIdContrato = isset($_REQUEST['pIdContrato'])?$_REQUEST['pIdContrato']:0;
    $pAutorizacion = isset($_REQUEST['pAutorizacion'])?$_REQUEST['pAutorizacion']:null;
    if($pAutorizacion == null || $pAutorizacion == ""){
        $pAutorizacion = "NA";
    }
    $pFormulacion = isset($_REQUEST['pFormulacion'])?$_REQUEST['pFormulacion']:1;
    if($pFormulacion == null || $pFormulacion == ""){
        $pFormulacion = 1;
    }
    $pCambiaCliente = isset($_REQUEST['pCambiaCliente'])?$_REQUEST['pCambiaCliente']:"NA";
    $pTalla = isset($_REQUEST['pTalla'])?$_REQUEST['pTalla']:null;
    $pPeso = isset($_REQUEST['pPeso'])?$_REQUEST['pPeso']:null;
    $pIMC = isset($_REQUEST['pIMC'])?$_REQUEST['pIMC']:null;
    $pIMCClasifica = isset($_REQUEST['pIMCClasifica'])?$_REQUEST['pIMCClasifica']:null;
    $pTE = isset($_REQUEST['pTE'])?$_REQUEST['pTE']:null;
    $pPerimetroCefalico = isset($_REQUEST['pPerimetroCefalico'])?$_REQUEST['pPerimetroCefalico']:null;
    $pPerimetroToraxico = isset($_REQUEST['pPerimetroToraxico'])?$_REQUEST['pPerimetroToraxico']:null;
    $pTASIS = isset($_REQUEST['pTASIS'])?$_REQUEST['pTASIS']:null;
    $pTADIAS = isset($_REQUEST['pTADIAS'])?$_REQUEST['pTADIAS']:null;
    $pAnios = isset($_REQUEST['pAnios'])?$_REQUEST['pAnios']:null;
    $pMeses = isset($_REQUEST['pMeses'])?$_REQUEST['pMeses']:null;
    $pOcupacion4505 = isset($_REQUEST['pOcupacion4505'])?$_REQUEST['pOcupacion4505']:null;
    $pEtnia4505 = isset($_REQUEST['pEtnia4505'])?$_REQUEST['pEtnia4505']:null;
    $pEscolaridad4505 = isset($_REQUEST['pEscolaridad4505'])?$_REQUEST['pEscolaridad4505']:null;
    $pGestacion4505 = isset($_REQUEST['pGestacion4505'])?$_REQUEST['pGestacion4505']:null;
    $pSifilisGestacional4505 = isset($_REQUEST['pSifilisGestacional4505'])?$_REQUEST['pSifilisGestacional4505']:null;
    $pHipertencionGestacional4505 = isset($_REQUEST['pHipertencionGestacional4505'])?$_REQUEST['pHipertencionGestacional4505']:null;
    $pHipotiroidismoCongenito4505 = isset($_REQUEST['pHipotiroidismoCongenito4505'])?$_REQUEST['pHipotiroidismoCongenito4505']:null;
    $pTuberculosisMultidrogoresistente4505 = isset($_REQUEST['pTuberculosisMultidrogoresistente4505'])?$_REQUEST['pTuberculosisMultidrogoresistente4505']:null;
    $pLepra4505 = isset($_REQUEST['pLepra4505'])?$_REQUEST['pLepra4505']:null;
    $pVictimaMaltrato4505 = isset($_REQUEST['pVictimaMaltrato4505'])?$_REQUEST['pVictimaMaltrato4505']:null;
    $pViolenciaSexual4505 = isset($_REQUEST['pViolenciaSexual4505'])?$_REQUEST['pViolenciaSexual4505']:null;
    $pFluorosisDental4505 = isset($_REQUEST['pFluorosisDental4505'])?$_REQUEST['pFluorosisDental4505']:null;
    $pTensionArterialSistolicaPie = isset($_REQUEST['pTensionArterialSistolicaPie'])?$_REQUEST['pTensionArterialSistolicaPie']:null;
    $pTensionArterialDiastolicaPie = isset($_REQUEST['pTensionArterialDiastolicaPie'])?$_REQUEST['pTensionArterialDiastolicaPie']:null;
    $pPerimetroAbdominal = isset($_REQUEST['pPerimetroAbdominal'])?$_REQUEST['pPerimetroAbdominal']:null;
    $pAlturaUterina = isset($_REQUEST['pAlturaUterina'])?$_REQUEST['pAlturaUterina']:null;
    $pFetocardiaFetal = isset($_REQUEST['pFetocardiaFetal'])?$_REQUEST['pFetocardiaFetal']:null;
    $pFC = isset($_REQUEST['pFC'])?$_REQUEST['pFC']:null;
    $pFR = isset($_REQUEST['pFR'])?$_REQUEST['pFR']:null;
    $pGuardarSignos = isset($_REQUEST['pGuardarSignos'])?$_REQUEST['pGuardarSignos']:null;
    $pPostTestVIH4505 = isset($_REQUEST['pPostTestVIH4505'])?$_REQUEST['pPostTestVIH4505']:null;
    $pPreTestVIH4505 = isset($_REQUEST['pPreTestVIH4505'])?$_REQUEST['pPreTestVIH4505']:null;
    $pAdultoPrimeraVez4505 = isset($_REQUEST['pAdultoPrimeraVez4505'])?$_REQUEST['pAdultoPrimeraVez4505']:null;
    $pJovenPrimeraVez4505 = isset($_REQUEST['pJovenPrimeraVez4505'])?$_REQUEST['pJovenPrimeraVez4505']:null;
    $pCyDPrimeraVez4505 = isset($_REQUEST['pCyDPrimeraVez4505'])?$_REQUEST['pCyDPrimeraVez4505']:null;
    $pPsicologia4505 = isset($_REQUEST['pPsicologia4505'])?$_REQUEST['pPsicologia4505']:null;
    $pNutricion4505 = isset($_REQUEST['pNutricion4505'])?$_REQUEST['pNutricion4505']:null;
    $pConsultaViolenciaSexual4505 = isset($_REQUEST['pConsultaViolenciaSexual4505'])?$_REQUEST['pConsultaViolenciaSexual4505']:null;
    $pMaltrato4505 = isset($_REQUEST['pMaltrato4505'])?$_REQUEST['pMaltrato4505']:null;
    $pOftalmologia4505 = isset($_REQUEST['pOftalmologia4505'])?$_REQUEST['pOftalmologia4505']:null;
    $pAgudezaVisual4505 = isset($_REQUEST['pAgudezaVisual4505'])?$_REQUEST['pAgudezaVisual4505']:null;
    $pPrenatalControl4505 = isset($_REQUEST['pPrenatalControl4505'])?$_REQUEST['pPrenatalControl4505']:null;
    $pPrenatalPrimeraVez4505 = isset($_REQUEST['pPrenatalPrimeraVez4505'])?$_REQUEST['pPrenatalPrimeraVez4505']:null;
    $pPlanificacion4505 = isset($_REQUEST['pPlanificacion4505'])?$_REQUEST['pPlanificacion4505']:null;
    $pCodIPSTomaBiopsiaSeno4505 = isset($_REQUEST['pCodIPSTomaBiopsiaSeno4505'])?$_REQUEST['pCodIPSTomaBiopsiaSeno4505']:null;
    $pResultadoBiopsiaSeno4505 = isset($_REQUEST['pResultadoBiopsiaSeno4505'])?$_REQUEST['pResultadoBiopsiaSeno4505']:null;
    $pCodIPSTomaMamografia4505 = isset($_REQUEST['pCodIPSTomaMamografia4505'])?$_REQUEST['pCodIPSTomaMamografia4505']:null;
    $pResultadoMamografia4505 = isset($_REQUEST['pResultadoMamografia4505'])?$_REQUEST['pResultadoMamografia4505']:null;
    $pCodIPSTomaBiopsiaCervical4505 = isset($_REQUEST['pCodIPSTomaBiopsiaCervical4505'])?$_REQUEST['pCodIPSTomaBiopsiaCervical4505']:null;
    $pCodIPSTomaColposcopia4505 = isset($_REQUEST['pCodIPSTomaColposcopia4505'])?$_REQUEST['pCodIPSTomaColposcopia4505']:null;
    $pResultadoBiopsiaCervical4505 = isset($_REQUEST['pResultadoBiopsiaCervical4505'])?$_REQUEST['pResultadoBiopsiaCervical4505']:null;
    $pCodIPSTomaCitologia4505 = isset($_REQUEST['pCodIPSTomaCitologia4505'])?$_REQUEST['pCodIPSTomaCitologia4505']:null;
    $pCalidadMuestraCitologia4505 = isset($_REQUEST['pCalidadMuestraCitologia4505'])?$_REQUEST['pCalidadMuestraCitologia4505']:null;
    $pResultadoCitologia4505 = isset($_REQUEST['pResultadoCitologia4505'])?$_REQUEST['pResultadoCitologia4505']:null;
    $pCitologia4505 = isset($_REQUEST['pCitologia4505'])?$_REQUEST['pCitologia4505']:null;
    $pColposcopia4505 = isset($_REQUEST['pColposcopia4505'])?$_REQUEST['pColposcopia4505']:null;
    $pBiopsiaCervical4505 = isset($_REQUEST['pBiopsiaCervical4505'])?$_REQUEST['pBiopsiaCervical4505']:null;
    $pMamografia4505 = isset($_REQUEST['pMamografia4505'])?$_REQUEST['pMamografia4505']:null;
    $pBiopsiaSeno4505 = isset($_REQUEST['pBiopsiaSeno4505'])?$_REQUEST['pBiopsiaSeno4505']:null;
    $pTomaHemoglobina = isset($_REQUEST['pTomaHemoglobina'])?$_REQUEST['pTomaHemoglobina']:null;
    $pResultadoHemoglobina = isset($_REQUEST['pResultadoHemoglobina'])?$_REQUEST['pResultadoHemoglobina']:null;
    $pTomaCreatinina = isset($_REQUEST['pTomaCreatinina'])?$_REQUEST['pTomaCreatinina']:null;
    $pResultadoCreatinina = isset($_REQUEST['pResultadoCreatinina'])?$_REQUEST['pResultadoCreatinina']:null;
    $pTomaHemoglobinaGlicosilada = isset($_REQUEST['pTomaHemoglobinaGlicosilada'])?$_REQUEST['pTomaHemoglobinaGlicosilada']:null;
    $pResultadoHemoglobinaGlicosilada = isset($_REQUEST['pResultadoHemoglobinaGlicosilada'])?$_REQUEST['pResultadoHemoglobinaGlicosilada']:null;
    $pTomaGlicemia = isset($_REQUEST['pTomaGlicemia'])?$_REQUEST['pTomaGlicemia']:null;
    $pTomaMicroalbuminuria = isset($_REQUEST['pTomaMicroalbuminuria'])?$_REQUEST['pTomaMicroalbuminuria']:null;
    $pTomaHDL = isset($_REQUEST['pTomaHDL'])?$_REQUEST['pTomaHDL']:null;
    $pTomaBaciloscopiaDiagnostica = isset($_REQUEST['pTomaBaciloscopiaDiagnostica'])?$_REQUEST['pTomaBaciloscopiaDiagnostica']:null;
    $pResultadoBaciloscopiaDiagnostica = isset($_REQUEST['pResultadoBaciloscopiaDiagnostica'])?$_REQUEST['pResultadoBaciloscopiaDiagnostica']:null;
    $pSerologia = isset($_REQUEST['pSerologia'])?$_REQUEST['pSerologia']:null;
    $pResultadoSerologia = isset($_REQUEST['pResultadoSerologia'])?$_REQUEST['pResultadoSerologia']:null;
    $pTomaElisaVIH = isset($_REQUEST['pTomaElisaVIH'])?$_REQUEST['pTomaElisaVIH']:null;
    $pResultadoElisaVIH = isset($_REQUEST['pResultadoElisaVIH'])?$_REQUEST['pResultadoElisaVIH']:null;
    $pTSHNeonatal = isset($_REQUEST['pTSHNeonatal'])?$_REQUEST['pTSHNeonatal']:null;
    $pResultadoTSHNeonatal = isset($_REQUEST['pResultadoTSHNeonatal'])?$_REQUEST['pResultadoTSHNeonatal']:null;
    $pBCG = isset($_REQUEST['pBCG'])?$_REQUEST['pBCG']:null;
    $pHepatitisB = isset($_REQUEST['pHepatitisB'])?$_REQUEST['pHepatitisB']:null;
    $pPentavalente = isset($_REQUEST['pPentavalente'])?$_REQUEST['pPentavalente']:null;
    $pPolio = isset($_REQUEST['pPolio'])?$_REQUEST['pPolio']:null;
    $pDPT = isset($_REQUEST['pDPT'])?$_REQUEST['pDPT']:null;
    $pRotavirus = isset($_REQUEST['pRotavirus'])?$_REQUEST['pRotavirus']:null;
    $pNeumococo = isset($_REQUEST['pNeumococo'])?$_REQUEST['pNeumococo']:null;
    $pInfluenza = isset($_REQUEST['pInfluenza'])?$_REQUEST['pInfluenza']:null;
    $pFiebreAmarilla = isset($_REQUEST['pFiebreAmarilla'])?$_REQUEST['pFiebreAmarilla']:null;
    $pHepatitisA = isset($_REQUEST['pHepatitisA'])?$_REQUEST['pHepatitisA']:null;
    $pTripleViral = isset($_REQUEST['pTripleViral'])?$_REQUEST['pTripleViral']:null;
    $pVPH = isset($_REQUEST['pVPH'])?$_REQUEST['pVPH']:null;
    $pTD = isset($_REQUEST['pTD'])?$_REQUEST['pTD']:null;
    $gBaseDatos = new ofiMySQLi();
    $gBaseDatos->conectar();
    $qry = "CALL sp_asistencial_edit_evolucion2013('" . $pEmpresa . "','" . $pIPS . "','" . $pPaciente . "','" . $pProfesional . "','" . $pCAS . "','" . $pConsecutivoDetalle . "',\"" . $pFechaAtencion . "\",\"" . $pHoraApertura . "\",\"" . $pActividad . "\",\"" . $pPlantilla . "\",\"" . $pEvolucion . "\",\"" . $pDiagppal . "\",\"" . $pDiagrel1 . "\",\"" . $pDiagrel2 . "\",\"" . $pDiagrel3 . "\",\"" . $pTipodiag . "\",\"" . $pFinalidad . "\",\"" . $pCausa . "\",\"" . $pAmbito . "\",\"" . $pFinalidadProced . "\",\"" . $pPersonalAtiende . "\",\"" . $pFormaActo . "\",'" . $pUsuario . "','" . $pIdCliente . "','" . $pIdPlan . "','" . $pIdSubPlan . "','" . $pIdContrato . "',\"" . $pAutorizacion . "\",\"" . $pCambiaCliente . "\",'" . $pFormulacion . "')";
    //echo $qry;
    if(@mysqli_query($gBaseDatos->ConexionID, $qry)){
        $gBaseDatos->cerrar();
        if($pGuardarSignos == "SI"){
            $gBaseDatos = new ofiMySQLi();
            $gBaseDatos->conectar();
            $qry = "CALL sp_asistencial_edit_tomasignos('" . $pEmpresa . "','" . $pIPS . "','" . $pPaciente . "','" . $pProfesional . "',\"" . $pFechaAtencion . "\",'" . $pCAS . "','" . $pAnios . "','" . $pMeses . "','" . $pTalla . "','" . $pPeso . "','" . $pIMC . "',\"" . $pIMCClasifica . "\",'" . $pTE . "','" . $pPerimetroCefalico . "','" . $pPerimetroToraxico . "','" . $pTASIS . "','" . $pTADIAS . "','" . $pOcupacion4505 . "','" . $pEtnia4505 . "','" . $pEscolaridad4505 . "','" . $pGestacion4505 . "','" . $pSifilisGestacional4505 . "','" . $pHipertencionGestacional4505 . "','" . $pHipotiroidismoCongenito4505 . "','" . $pTuberculosisMultidrogoresistente4505 . "','" . $pLepra4505 . "','" . $pVictimaMaltrato4505 . "','" . $pViolenciaSexual4505 . "','" . $pFluorosisDental4505 . "','" . $pTensionArterialSistolicaPie . "','" . $pTensionArterialDiastolicaPie . "','" . $pPerimetroAbdominal . "','" . $pAlturaUterina . "','" . $pFetocardiaFetal . "','" . $pFC . "','" . $pFR . "',\"" . $pPostTestVIH4505 . "\",\"" . $pPreTestVIH4505 . "\",\"" . $pAdultoPrimeraVez4505 . "\",\"" . $pJovenPrimeraVez4505 . "\",\"" . $pCyDPrimeraVez4505 . "\",\"" . $pPsicologia4505 . "\",\"" . $pNutricion4505 . "\",\"" . $pConsultaViolenciaSexual4505 . "\",\"" . $pMaltrato4505 . "\",\"" . $pOftalmologia4505 . "\",\"" . $pAgudezaVisual4505 . "\",\"" . $pPrenatalControl4505 . "\",\"" . $pPrenatalPrimeraVez4505 . "\",\"" . $pPlanificacion4505 . "\",\"" . $pBiopsiaSeno4505 . "\",\"" . $pMamografia4505 . "\",\"" . $pBiopsiaCervical4505 . "\",\"" . $pColposcopia4505  . "\",\"" . $pCitologia4505 . "\",'" . $pResultadoCitologia4505 . "','" . $pCalidadMuestraCitologia4505 . "','" . $pCodIPSTomaCitologia4505 . "','" . $pCodIPSTomaColposcopia4505 . "','" . $pResultadoBiopsiaCervical4505 . "','" . $pCodIPSTomaBiopsiaCervical4505 . "','" . $pResultadoMamografia4505 . "','" . $pCodIPSTomaMamografia4505 . "','" . $pResultadoBiopsiaSeno4505 . "','" . $pCodIPSTomaBiopsiaSeno4505 . "',\"" . $pTomaHemoglobina . "\",'" . $pResultadoHemoglobina . "',\"" . $pTomaCreatinina . "\",'" . $pResultadoCreatinina . "',\"" . $pTomaHemoglobinaGlicosilada . "\",'" . $pResultadoHemoglobinaGlicosilada . "',\"" . $pTomaGlicemia . "\",\"" . $pTomaMicroalbuminuria . "\",\"" . $pTomaHDL . "\",\"" . $pTomaBaciloscopiaDiagnostica . "\",'" . $pResultadoBaciloscopiaDiagnostica . "',\"" . $pSerologia . "\",'" . $pResultadoSerologia . "',\"" . $pTomaElisaVIH . "\",'" . $pResultadoElisaVIH . "',\"" . $pTSHNeonatal . "\",'" . $pResultadoTSHNeonatal . "','" . $pBCG . "','" . $pHepatitisB . "','" . $pPentavalente . "','" . $pPolio . "','" . $pDPT . "','" . $pRotavirus . "','" . $pNeumococo . "','" . $pInfluenza . "','" . $pFiebreAmarilla . "','" . $pHepatitisA . "','" . $pTripleViral . "','" . $pVPH . "','" . $pTD . "')";
            //echo $qry;
            @mysqli_query($gBaseDatos->ConexionID, $qry);
            $gBaseDatos->cerrar();
        }
        echo "{success: true, requestedId:'1'}";
    }else{
       echo "{success: true, requestedId:'0'}";
        $gBaseDatos->cerrar();
    }
}

function GuardarPediatriaHC(){
    $pEmpresa = isset($_REQUEST['pEmpresa'])?$_REQUEST['pEmpresa']:0;
    $pIPS = isset($_REQUEST['pIPS'])?$_REQUEST['pIPS']:0;
    $pPaciente = isset($_REQUEST['pPaciente'])?$_REQUEST['pPaciente']:0;
    //$pProfesional = isset($_REQUEST['pProfesional'])?$_REQUEST['pProfesional']:0;
    $pProfesional = $_SESSION['ID_PROFESIONAL_HC'];
    $pCAS = isset($_REQUEST['pCAS'])?$_REQUEST['pCAS']:0;
    $pConsecutivoDetalle = isset($_REQUEST['pConsecutivoDetalle'])?$_REQUEST['pConsecutivoDetalle']:0;
    $pidPlantillaHC = isset($_REQUEST['pidPlantillaHC'])?$_REQUEST['pidPlantillaHC']:0;
    $pFechaAtencion = isset($_REQUEST['pFechaAtencion'])?$_REQUEST['pFechaAtencion']:null;
    $pHoraApertura = isset($_REQUEST['pHoraApertura'])?$_REQUEST['pHoraApertura']:null;
    $pActividad = isset($_REQUEST['pActividad'])?$_REQUEST['pActividad']:null;
    $pPlantilla = isset($_REQUEST['pPlantilla'])?$_REQUEST['pPlantilla']:null;
    $pRutaRptHC = isset($_REQUEST['pRutaRptHC'])?$_REQUEST['pRutaRptHC']:null;
    $pRutaRptMx = isset($_REQUEST['pRutaRptMx'])?$_REQUEST['pRutaRptMx']:null;
    $pRutaRptExa = isset($_REQUEST['pRutaRptExa'])?$_REQUEST['pRutaRptExa']:null;
    $pRutaRptRem = isset($_REQUEST['pRutaRptRem'])?$_REQUEST['pRutaRptRem']:null;
    $contenido = isset($_REQUEST['CAMPOS'])?$_REQUEST['CAMPOS']:null;
    $pEvolucion = stripslashes(utf8_encode(str_replace('"', '""',nl2br($contenido))));
    $pDiagppal = isset($_REQUEST['pDiagppal'])?$_REQUEST['pDiagppal']:null;
    $pDiagrel1 = isset($_REQUEST['pDiagrel1'])?$_REQUEST['pDiagrel1']:null;
    $pDiagrel2 = isset($_REQUEST['pDiagrel2'])?$_REQUEST['pDiagrel2']:null;
    $pDiagrel3 = isset($_REQUEST['pDiagrel3'])?$_REQUEST['pDiagrel3']:null;
    $pTipodiag = isset($_REQUEST['pTipodiag'])?$_REQUEST['pTipodiag']:null;
    $pFinalidad = isset($_REQUEST['pFinalidad'])?$_REQUEST['pFinalidad']:null;
    $pCausa = isset($_REQUEST['pCausa'])?$_REQUEST['pCausa']:null;
    $pAmbito = isset($_REQUEST['pAmbito'])?$_REQUEST['pAmbito']:null;
    $pFinalidadProced = isset($_REQUEST['pFinalidadProced'])?$_REQUEST['pFinalidadProced']:null;
    $pPersonalAtiende = isset($_REQUEST['pPersonalAtiende'])?$_REQUEST['pPersonalAtiende']:null;
    $pFormaActo = isset($_REQUEST['pFormaActo'])?$_REQUEST['pFormaActo']:null;
    $pUsuario = isset($_REQUEST['pUsuario'])?$_REQUEST['pUsuario']:0;
    $pIdCliente = isset($_REQUEST['pIdCliente'])?$_REQUEST['pIdCliente']:0;
    $pIdPlan = isset($_REQUEST['pIdPlan'])?$_REQUEST['pIdPlan']:0;
    $pIdSubPlan = isset($_REQUEST['pIdSubPlan'])?$_REQUEST['pIdSubPlan']:0;
    $pIdContrato = isset($_REQUEST['pIdContrato'])?$_REQUEST['pIdContrato']:0;
    $pAutorizacion = isset($_REQUEST['pAutorizacion'])?$_REQUEST['pAutorizacion']:null;
    if($pAutorizacion == null || $pAutorizacion == ""){
        $pAutorizacion = "NA";
    }
    $pCambiaCliente = isset($_REQUEST['pCambiaCliente'])?$_REQUEST['pCambiaCliente']:"NA";
    $pGuardarSignos = isset($_REQUEST['pGuardarSignos'])?$_REQUEST['pGuardarSignos']:"NO";
    $pTalla = isset($_REQUEST['pTalla'])?$_REQUEST['pTalla']:null;
    $pPeso = isset($_REQUEST['pPeso'])?$_REQUEST['pPeso']:null;
    $pIMC = isset($_REQUEST['pIMC'])?$_REQUEST['pIMC']:null;
    $pIMCClasifica = isset($_REQUEST['pICMClas'])?$_REQUEST['pICMClas']:null;
    $pTE = isset($_REQUEST['pTE'])?$_REQUEST['pTE']:null;
    $pPerimetroCefalico = isset($_REQUEST['pPCefalico'])?$_REQUEST['pPCefalico']:null;
    $pPerimetroToraxico = isset($_REQUEST['pPerimetroToraxico'])?$_REQUEST['pPerimetroToraxico']:null;
    $pTASIS = isset($_REQUEST['pTASIS'])?$_REQUEST['pTASIS']:null;
    $pTADIAS = isset($_REQUEST['pTADIAS'])?$_REQUEST['pTADIAS']:null;
    $pAnios = isset($_REQUEST['pAnios'])?$_REQUEST['pAnios']:null;
    $pMeses = isset($_REQUEST['pMeses'])?$_REQUEST['pMeses']:null;
    $pFormulacion = isset($_REQUEST['pFormulacion'])?$_REQUEST['pFormulacion']:1;
    if($pFormulacion == null || $pFormulacion == ""){
        $pFormulacion = 1;
    }
    
    $pOcupacion4505 = isset($_REQUEST['pOcupacion4505'])?$_REQUEST['pOcupacion4505']:null;
    $pEtnia4505 = isset($_REQUEST['pEtnia4505'])?$_REQUEST['pEtnia4505']:null;
    $pEscolaridad4505 = isset($_REQUEST['pEscolaridad4505'])?$_REQUEST['pEscolaridad4505']:null;
    $pGestacion4505 = isset($_REQUEST['pGestacion4505'])?$_REQUEST['pGestacion4505']:null;
    $pSifilisGestacional4505 = isset($_REQUEST['pSifilisGestacional4505'])?$_REQUEST['pSifilisGestacional4505']:null;
    $pHipertencionGestacional4505 = isset($_REQUEST['pHipertencionGestacional4505'])?$_REQUEST['pHipertencionGestacional4505']:null;
    $pHipotiroidismoCongenito4505 = isset($_REQUEST['pHipotiroidismoCongenito4505'])?$_REQUEST['pHipotiroidismoCongenito4505']:null;
    $pTuberculosisMultidrogoresistente4505 = isset($_REQUEST['pTuberculosisMultidrogoresistente4505'])?$_REQUEST['pTuberculosisMultidrogoresistente4505']:null;
    $pLepra4505 = isset($_REQUEST['pLepra4505'])?$_REQUEST['pLepra4505']:null;
    $pVictimaMaltrato4505 = isset($_REQUEST['pVictimaMaltrato4505'])?$_REQUEST['pVictimaMaltrato4505']:null;
    $pViolenciaSexual4505 = isset($_REQUEST['pViolenciaSexual4505'])?$_REQUEST['pViolenciaSexual4505']:null;
    $pFluorosisDental4505 = isset($_REQUEST['pFluorosisDental4505'])?$_REQUEST['pFluorosisDental4505']:null;
    $pTensionArterialSistolicaPie = isset($_REQUEST['pTensionArterialSistolicaPie'])?$_REQUEST['pTensionArterialSistolicaPie']:null;
    $pTensionArterialDiastolicaPie = isset($_REQUEST['pTensionArterialDiastolicaPie'])?$_REQUEST['pTensionArterialDiastolicaPie']:null;
    $pPerimetroAbdominal = isset($_REQUEST['pPerimetroAbdominal'])?$_REQUEST['pPerimetroAbdominal']:null;
    $pAlturaUterina = isset($_REQUEST['pAlturaUterina'])?$_REQUEST['pAlturaUterina']:null;
    $pFetocardiaFetal = isset($_REQUEST['pFetocardiaFetal'])?$_REQUEST['pFetocardiaFetal']:null;
    $pFC = isset($_REQUEST['pFC'])?$_REQUEST['pFC']:null;
    $pFR = isset($_REQUEST['pFR'])?$_REQUEST['pFR']:null;
    $pPostTestVIH4505 = isset($_REQUEST['pPostTestVIH4505'])?$_REQUEST['pPostTestVIH4505']:null;
    $pPreTestVIH4505 = isset($_REQUEST['pPreTestVIH4505'])?$_REQUEST['pPreTestVIH4505']:null;
    $pAdultoPrimeraVez4505 = isset($_REQUEST['pAdultoPrimeraVez4505'])?$_REQUEST['pAdultoPrimeraVez4505']:null;
    $pJovenPrimeraVez4505 = isset($_REQUEST['pJovenPrimeraVez4505'])?$_REQUEST['pJovenPrimeraVez4505']:null;
    $pCyDPrimeraVez4505 = isset($_REQUEST['pCyDPrimeraVez4505'])?$_REQUEST['pCyDPrimeraVez4505']:null;
    $pPsicologia4505 = isset($_REQUEST['pPsicologia4505'])?$_REQUEST['pPsicologia4505']:null;
    $pNutricion4505 = isset($_REQUEST['pNutricion4505'])?$_REQUEST['pNutricion4505']:null;
    $pConsultaViolenciaSexual4505 = isset($_REQUEST['pConsultaViolenciaSexual4505'])?$_REQUEST['pConsultaViolenciaSexual4505']:null;
    $pMaltrato4505 = isset($_REQUEST['pMaltrato4505'])?$_REQUEST['pMaltrato4505']:null;
    $pOftalmologia4505 = isset($_REQUEST['pOftalmologia4505'])?$_REQUEST['pOftalmologia4505']:null;
    $pAgudezaVisual4505 = isset($_REQUEST['pAgudezaVisual4505'])?$_REQUEST['pAgudezaVisual4505']:null;
    $pPrenatalControl4505 = isset($_REQUEST['pPrenatalControl4505'])?$_REQUEST['pPrenatalControl4505']:null;
    $pPrenatalPrimeraVez4505 = isset($_REQUEST['pPrenatalPrimeraVez4505'])?$_REQUEST['pPrenatalPrimeraVez4505']:null;
    $pPlanificacion4505 = isset($_REQUEST['pPlanificacion4505'])?$_REQUEST['pPlanificacion4505']:null;
    $pCodIPSTomaBiopsiaSeno4505 = isset($_REQUEST['pCodIPSTomaBiopsiaSeno4505'])?$_REQUEST['pCodIPSTomaBiopsiaSeno4505']:null;
    $pResultadoBiopsiaSeno4505 = isset($_REQUEST['pResultadoBiopsiaSeno4505'])?$_REQUEST['pResultadoBiopsiaSeno4505']:null;
    $pCodIPSTomaMamografia4505 = isset($_REQUEST['pCodIPSTomaMamografia4505'])?$_REQUEST['pCodIPSTomaMamografia4505']:null;
    $pResultadoMamografia4505 = isset($_REQUEST['pResultadoMamografia4505'])?$_REQUEST['pResultadoMamografia4505']:null;
    $pCodIPSTomaBiopsiaCervical4505 = isset($_REQUEST['pCodIPSTomaBiopsiaCervical4505'])?$_REQUEST['pCodIPSTomaBiopsiaCervical4505']:null;
    $pCodIPSTomaColposcopia4505 = isset($_REQUEST['pCodIPSTomaColposcopia4505'])?$_REQUEST['pCodIPSTomaColposcopia4505']:null;
    $pResultadoBiopsiaCervical4505 = isset($_REQUEST['pResultadoBiopsiaCervical4505'])?$_REQUEST['pResultadoBiopsiaCervical4505']:null;
    $pCodIPSTomaCitologia4505 = isset($_REQUEST['pCodIPSTomaCitologia4505'])?$_REQUEST['pCodIPSTomaCitologia4505']:null;
    $pCalidadMuestraCitologia4505 = isset($_REQUEST['pCalidadMuestraCitologia4505'])?$_REQUEST['pCalidadMuestraCitologia4505']:null;
    $pResultadoCitologia4505 = isset($_REQUEST['pResultadoCitologia4505'])?$_REQUEST['pResultadoCitologia4505']:null;
    $pCitologia4505 = isset($_REQUEST['pCitologia4505'])?$_REQUEST['pCitologia4505']:null;
    $pColposcopia4505 = isset($_REQUEST['pColposcopia4505'])?$_REQUEST['pColposcopia4505']:null;
    $pBiopsiaCervical4505 = isset($_REQUEST['pBiopsiaCervical4505'])?$_REQUEST['pBiopsiaCervical4505']:null;
    $pMamografia4505 = isset($_REQUEST['pMamografia4505'])?$_REQUEST['pMamografia4505']:null;
    $pBiopsiaSeno4505 = isset($_REQUEST['pBiopsiaSeno4505'])?$_REQUEST['pBiopsiaSeno4505']:null;
    $pTomaHemoglobina = isset($_REQUEST['pTomaHemoglobina'])?$_REQUEST['pTomaHemoglobina']:null;
    $pResultadoHemoglobina = isset($_REQUEST['pResultadoHemoglobina'])?$_REQUEST['pResultadoHemoglobina']:null;
    $pTomaCreatinina = isset($_REQUEST['pTomaCreatinina'])?$_REQUEST['pTomaCreatinina']:null;
    $pResultadoCreatinina = isset($_REQUEST['pResultadoCreatinina'])?$_REQUEST['pResultadoCreatinina']:null;
    $pTomaHemoglobinaGlicosilada = isset($_REQUEST['pTomaHemoglobinaGlicosilada'])?$_REQUEST['pTomaHemoglobinaGlicosilada']:null;
    $pResultadoHemoglobinaGlicosilada = isset($_REQUEST['pResultadoHemoglobinaGlicosilada'])?$_REQUEST['pResultadoHemoglobinaGlicosilada']:null;
    $pTomaGlicemia = isset($_REQUEST['pTomaGlicemia'])?$_REQUEST['pTomaGlicemia']:null;
    $pTomaMicroalbuminuria = isset($_REQUEST['pTomaMicroalbuminuria'])?$_REQUEST['pTomaMicroalbuminuria']:null;
    $pTomaHDL = isset($_REQUEST['pTomaHDL'])?$_REQUEST['pTomaHDL']:null;
    $pTomaBaciloscopiaDiagnostica = isset($_REQUEST['pTomaBaciloscopiaDiagnostica'])?$_REQUEST['pTomaBaciloscopiaDiagnostica']:null;
    $pResultadoBaciloscopiaDiagnostica = isset($_REQUEST['pResultadoBaciloscopiaDiagnostica'])?$_REQUEST['pResultadoBaciloscopiaDiagnostica']:null;
    $pSerologia = isset($_REQUEST['pSerologia'])?$_REQUEST['pSerologia']:null;
    $pResultadoSerologia = isset($_REQUEST['pResultadoSerologia'])?$_REQUEST['pResultadoSerologia']:null;
    $pTomaElisaVIH = isset($_REQUEST['pTomaElisaVIH'])?$_REQUEST['pTomaElisaVIH']:null;
    $pResultadoElisaVIH = isset($_REQUEST['pResultadoElisaVIH'])?$_REQUEST['pResultadoElisaVIH']:null;
    $pTSHNeonatal = isset($_REQUEST['pTSHNeonatal'])?$_REQUEST['pTSHNeonatal']:null;
    $pResultadoTSHNeonatal = isset($_REQUEST['pResultadoTSHNeonatal'])?$_REQUEST['pResultadoTSHNeonatal']:null;
    $pBCG = isset($_REQUEST['pBCG'])?$_REQUEST['pBCG']:null;
    $pHepatitisB = isset($_REQUEST['pHepatitisB'])?$_REQUEST['pHepatitisB']:null;
    $pPentavalente = isset($_REQUEST['pPentavalente'])?$_REQUEST['pPentavalente']:null;
    $pPolio = isset($_REQUEST['pPolio'])?$_REQUEST['pPolio']:null;
    $pDPT = isset($_REQUEST['pDPT'])?$_REQUEST['pDPT']:null;
    $pRotavirus = isset($_REQUEST['pRotavirus'])?$_REQUEST['pRotavirus']:null;
    $pNeumococo = isset($_REQUEST['pNeumococo'])?$_REQUEST['pNeumococo']:null;
    $pInfluenza = isset($_REQUEST['pInfluenza'])?$_REQUEST['pInfluenza']:null;
    $pFiebreAmarilla = isset($_REQUEST['pFiebreAmarilla'])?$_REQUEST['pFiebreAmarilla']:null;
    $pHepatitisA = isset($_REQUEST['pHepatitisA'])?$_REQUEST['pHepatitisA']:null;
    $pTripleViral = isset($_REQUEST['pTripleViral'])?$_REQUEST['pTripleViral']:null;
    $pVPH = isset($_REQUEST['pVPH'])?$_REQUEST['pVPH']:null;
    $pTD = isset($_REQUEST['pTD'])?$_REQUEST['pTD']:null;
    
    $gBaseDatos = new ofiMySQLi();
    $gBaseDatos->conectar();
    $qry = "CALL sp_asistencial_add_evolucion2013('" . $pEmpresa . "','" . $pIPS . "','" . $pPaciente . "','" . $pProfesional . "','" . $pCAS . "','" . $pConsecutivoDetalle . "','" . $pidPlantillaHC . "',\"" . $pFechaAtencion . "\",\"" . $pHoraApertura . "\",\"" . $pActividad . "\",\"" . $pPlantilla . "\",\"" . $pRutaRptHC . "\",\"" . $pRutaRptMx . "\",\"" . $pRutaRptExa . "\",\"" . $pRutaRptRem . "\",\"" . $pEvolucion . "\",\"" . $pDiagppal . "\",\"" . $pDiagrel1 . "\",\"" . $pDiagrel2 . "\",\"" . $pDiagrel3 . "\",\"" . $pTipodiag . "\",\"" . $pFinalidad . "\",\"" . $pCausa . "\",\"" . $pAmbito . "\",\"" . $pFinalidadProced . "\",\"" . $pPersonalAtiende . "\",\"" . $pFormaActo . "\",'" . $pUsuario . "','" . $pIdCliente . "','" . $pIdPlan . "','" . $pIdSubPlan . "','" . $pIdContrato . "',\"" . $pAutorizacion . "\",\"" . $pCambiaCliente . "\",'" . $pFormulacion . "')";
    //echo $qry;
    if(@mysqli_query($gBaseDatos->ConexionID, $qry)){
        $gBaseDatos->cerrar();
        if($pGuardarSignos === "SI"){
            $gBaseDatos = new ofiMySQLi();
            $gBaseDatos->conectar();
            $qry = "CALL sp_asistencial_add_tomasignos_ped('" . $pEmpresa . "','" . $pIPS . "','" . $pPaciente . "','" . $pProfesional . "',\"" . $pFechaAtencion . "\",'" . $pCAS . "','" . $pTalla . "','" . $pPeso . "','" . $pIMC . "',\"" . $pIMCClasifica . "\",'" . $pTE . "','" . $pPerimetroCefalico . "')";
            //echo $qry;
            @mysqli_query($gBaseDatos->ConexionID, $qry);
            $gBaseDatos->cerrar();
        }
        echo "{success: true, requestedId:'1'}";
    }else{
       echo "{success: true, requestedId:'0'}";
       $gBaseDatos->cerrar();   
    }
}

function ModificarPediatriaHC(){
    $pEmpresa = isset($_REQUEST['pEmpresa'])?$_REQUEST['pEmpresa']:0;
    $pIPS = isset($_REQUEST['pIPS'])?$_REQUEST['pIPS']:0;
    $pPaciente = isset($_REQUEST['pPaciente'])?$_REQUEST['pPaciente']:0;
    //$pProfesional = isset($_REQUEST['pProfesional'])?$_REQUEST['pProfesional']:0;
    $pProfesional = $_SESSION['ID_PROFESIONAL_HC'];
    $pCAS = isset($_REQUEST['pCAS'])?$_REQUEST['pCAS']:0;
    $pConsecutivoDetalle = isset($_REQUEST['pConsecutivoDetalle'])?$_REQUEST['pConsecutivoDetalle']:0;
    $pFechaAtencion = isset($_REQUEST['pFechaAtencion'])?$_REQUEST['pFechaAtencion']:null;
    $pHoraApertura = isset($_REQUEST['pHoraApertura'])?$_REQUEST['pHoraApertura']:null;
    $pActividad = isset($_REQUEST['pActividad'])?$_REQUEST['pActividad']:null;
    $pPlantilla = isset($_REQUEST['pPlantilla'])?$_REQUEST['pPlantilla']:null;
    $pRutaRptHC = isset($_REQUEST['pRutaRptHC'])?$_REQUEST['pRutaRptHC']:null;
    $pRutaRptMx = isset($_REQUEST['pRutaRptMx'])?$_REQUEST['pRutaRptMx']:null;
    $pRutaRptExa = isset($_REQUEST['pRutaRptExa'])?$_REQUEST['pRutaRptExa']:null;
    $pRutaRptRem = isset($_REQUEST['pRutaRptRem'])?$_REQUEST['pRutaRptRem']:null;
    $contenido = isset($_REQUEST['CAMPOS'])?$_REQUEST['CAMPOS']:null;
    $pEvolucion = stripslashes(utf8_encode(str_replace('"', '""',nl2br($contenido))));
    $pDiagppal = isset($_REQUEST['pDiagppal'])?$_REQUEST['pDiagppal']:null;
    $pDiagrel1 = isset($_REQUEST['pDiagrel1'])?$_REQUEST['pDiagrel1']:null;
    $pDiagrel2 = isset($_REQUEST['pDiagrel2'])?$_REQUEST['pDiagrel2']:null;
    $pDiagrel3 = isset($_REQUEST['pDiagrel3'])?$_REQUEST['pDiagrel3']:null;
    $pTipodiag = isset($_REQUEST['pTipodiag'])?$_REQUEST['pTipodiag']:null;
    $pFinalidad = isset($_REQUEST['pFinalidad'])?$_REQUEST['pFinalidad']:null;
    $pCausa = isset($_REQUEST['pCausa'])?$_REQUEST['pCausa']:null;
    $pAmbito = isset($_REQUEST['pAmbito'])?$_REQUEST['pAmbito']:null;
    $pFinalidadProced = isset($_REQUEST['pFinalidadProced'])?$_REQUEST['pFinalidadProced']:null;
    $pPersonalAtiende = isset($_REQUEST['pPersonalAtiende'])?$_REQUEST['pPersonalAtiende']:null;
    $pFormaActo = isset($_REQUEST['pFormaActo'])?$_REQUEST['pFormaActo']:null;
    $pUsuario = isset($_REQUEST['pUsuario'])?$_REQUEST['pUsuario']:0;
    $pIdCliente = isset($_REQUEST['pIdCliente'])?$_REQUEST['pIdCliente']:0;
    $pIdPlan = isset($_REQUEST['pIdPlan'])?$_REQUEST['pIdPlan']:0;
    $pIdSubPlan = isset($_REQUEST['pIdSubPlan'])?$_REQUEST['pIdSubPlan']:0;
    $pIdContrato = isset($_REQUEST['pIdContrato'])?$_REQUEST['pIdContrato']:0;
    $pAutorizacion = isset($_REQUEST['pAutorizacion'])?$_REQUEST['pAutorizacion']:null;
    if($pAutorizacion == null || $pAutorizacion == ""){
        $pAutorizacion = "NA";
    }
    $pFormulacion = isset($_REQUEST['pFormulacion'])?$_REQUEST['pFormulacion']:1;
    if($pFormulacion == null || $pFormulacion == ""){
        $pFormulacion = 1;
    }
    $pCambiaCliente = isset($_REQUEST['pCambiaCliente'])?$_REQUEST['pCambiaCliente']:"NA";
    $pGuardarSignos = isset($_REQUEST['pGuardarSignos'])?$_REQUEST['pGuardarSignos']:"NO";
    $pTalla = isset($_REQUEST['pTalla'])?$_REQUEST['pTalla']:null;
    $pPeso = isset($_REQUEST['pPeso'])?$_REQUEST['pPeso']:null;
    $pIMC = isset($_REQUEST['pIMC'])?$_REQUEST['pIMC']:null;
    $pIMCClasifica = isset($_REQUEST['pICMClas'])?$_REQUEST['pICMClas']:null;
    $pTE = isset($_REQUEST['pTE'])?$_REQUEST['pTE']:null;
    $pPerimetroCefalico = isset($_REQUEST['pPCefalico'])?$_REQUEST['pPCefalico']:null;
    $pPerimetroToraxico = isset($_REQUEST['pPerimetroToraxico'])?$_REQUEST['pPerimetroToraxico']:null;
    $pTASIS = isset($_REQUEST['pTASIS'])?$_REQUEST['pTASIS']:null;
    $pTADIAS = isset($_REQUEST['pTADIAS'])?$_REQUEST['pTADIAS']:null;
    $pAnios = isset($_REQUEST['pAnios'])?$_REQUEST['pAnios']:null;
    $pMeses = isset($_REQUEST['pMeses'])?$_REQUEST['pMeses']:null;
    $pOcupacion4505 = isset($_REQUEST['pOcupacion4505'])?$_REQUEST['pOcupacion4505']:null;
    $pEtnia4505 = isset($_REQUEST['pEtnia4505'])?$_REQUEST['pEtnia4505']:null;
    $pEscolaridad4505 = isset($_REQUEST['pEscolaridad4505'])?$_REQUEST['pEscolaridad4505']:null;
    $pGestacion4505 = isset($_REQUEST['pGestacion4505'])?$_REQUEST['pGestacion4505']:null;
    $pSifilisGestacional4505 = isset($_REQUEST['pSifilisGestacional4505'])?$_REQUEST['pSifilisGestacional4505']:null;
    $pHipertencionGestacional4505 = isset($_REQUEST['pHipertencionGestacional4505'])?$_REQUEST['pHipertencionGestacional4505']:null;
    $pHipotiroidismoCongenito4505 = isset($_REQUEST['pHipotiroidismoCongenito4505'])?$_REQUEST['pHipotiroidismoCongenito4505']:null;
    $pTuberculosisMultidrogoresistente4505 = isset($_REQUEST['pTuberculosisMultidrogoresistente4505'])?$_REQUEST['pTuberculosisMultidrogoresistente4505']:null;
    $pLepra4505 = isset($_REQUEST['pLepra4505'])?$_REQUEST['pLepra4505']:null;
    $pVictimaMaltrato4505 = isset($_REQUEST['pVictimaMaltrato4505'])?$_REQUEST['pVictimaMaltrato4505']:null;
    $pViolenciaSexual4505 = isset($_REQUEST['pViolenciaSexual4505'])?$_REQUEST['pViolenciaSexual4505']:null;
    $pFluorosisDental4505 = isset($_REQUEST['pFluorosisDental4505'])?$_REQUEST['pFluorosisDental4505']:null;
    $pTensionArterialSistolicaPie = isset($_REQUEST['pTensionArterialSistolicaPie'])?$_REQUEST['pTensionArterialSistolicaPie']:null;
    $pTensionArterialDiastolicaPie = isset($_REQUEST['pTensionArterialDiastolicaPie'])?$_REQUEST['pTensionArterialDiastolicaPie']:null;
    $pPerimetroAbdominal = isset($_REQUEST['pPerimetroAbdominal'])?$_REQUEST['pPerimetroAbdominal']:null;
    $pAlturaUterina = isset($_REQUEST['pAlturaUterina'])?$_REQUEST['pAlturaUterina']:null;
    $pFetocardiaFetal = isset($_REQUEST['pFetocardiaFetal'])?$_REQUEST['pFetocardiaFetal']:null;
    $pFC = isset($_REQUEST['pFC'])?$_REQUEST['pFC']:null;
    $pFR = isset($_REQUEST['pFR'])?$_REQUEST['pFR']:null;
    $pGuardarSignos = isset($_REQUEST['pGuardarSignos'])?$_REQUEST['pGuardarSignos']:null;
    $pPostTestVIH4505 = isset($_REQUEST['pPostTestVIH4505'])?$_REQUEST['pPostTestVIH4505']:null;
    $pPreTestVIH4505 = isset($_REQUEST['pPreTestVIH4505'])?$_REQUEST['pPreTestVIH4505']:null;
    $pAdultoPrimeraVez4505 = isset($_REQUEST['pAdultoPrimeraVez4505'])?$_REQUEST['pAdultoPrimeraVez4505']:null;
    $pJovenPrimeraVez4505 = isset($_REQUEST['pJovenPrimeraVez4505'])?$_REQUEST['pJovenPrimeraVez4505']:null;
    $pCyDPrimeraVez4505 = isset($_REQUEST['pCyDPrimeraVez4505'])?$_REQUEST['pCyDPrimeraVez4505']:null;
    $pPsicologia4505 = isset($_REQUEST['pPsicologia4505'])?$_REQUEST['pPsicologia4505']:null;
    $pNutricion4505 = isset($_REQUEST['pNutricion4505'])?$_REQUEST['pNutricion4505']:null;
    $pConsultaViolenciaSexual4505 = isset($_REQUEST['pConsultaViolenciaSexual4505'])?$_REQUEST['pConsultaViolenciaSexual4505']:null;
    $pMaltrato4505 = isset($_REQUEST['pMaltrato4505'])?$_REQUEST['pMaltrato4505']:null;
    $pOftalmologia4505 = isset($_REQUEST['pOftalmologia4505'])?$_REQUEST['pOftalmologia4505']:null;
    $pAgudezaVisual4505 = isset($_REQUEST['pAgudezaVisual4505'])?$_REQUEST['pAgudezaVisual4505']:null;
    $pPrenatalControl4505 = isset($_REQUEST['pPrenatalControl4505'])?$_REQUEST['pPrenatalControl4505']:null;
    $pPrenatalPrimeraVez4505 = isset($_REQUEST['pPrenatalPrimeraVez4505'])?$_REQUEST['pPrenatalPrimeraVez4505']:null;
    $pPlanificacion4505 = isset($_REQUEST['pPlanificacion4505'])?$_REQUEST['pPlanificacion4505']:null;
    $pCodIPSTomaBiopsiaSeno4505 = isset($_REQUEST['pCodIPSTomaBiopsiaSeno4505'])?$_REQUEST['pCodIPSTomaBiopsiaSeno4505']:null;
    $pResultadoBiopsiaSeno4505 = isset($_REQUEST['pResultadoBiopsiaSeno4505'])?$_REQUEST['pResultadoBiopsiaSeno4505']:null;
    $pCodIPSTomaMamografia4505 = isset($_REQUEST['pCodIPSTomaMamografia4505'])?$_REQUEST['pCodIPSTomaMamografia4505']:null;
    $pResultadoMamografia4505 = isset($_REQUEST['pResultadoMamografia4505'])?$_REQUEST['pResultadoMamografia4505']:null;
    $pCodIPSTomaBiopsiaCervical4505 = isset($_REQUEST['pCodIPSTomaBiopsiaCervical4505'])?$_REQUEST['pCodIPSTomaBiopsiaCervical4505']:null;
    $pCodIPSTomaColposcopia4505 = isset($_REQUEST['pCodIPSTomaColposcopia4505'])?$_REQUEST['pCodIPSTomaColposcopia4505']:null;
    $pResultadoBiopsiaCervical4505 = isset($_REQUEST['pResultadoBiopsiaCervical4505'])?$_REQUEST['pResultadoBiopsiaCervical4505']:null;
    $pCodIPSTomaCitologia4505 = isset($_REQUEST['pCodIPSTomaCitologia4505'])?$_REQUEST['pCodIPSTomaCitologia4505']:null;
    $pCalidadMuestraCitologia4505 = isset($_REQUEST['pCalidadMuestraCitologia4505'])?$_REQUEST['pCalidadMuestraCitologia4505']:null;
    $pResultadoCitologia4505 = isset($_REQUEST['pResultadoCitologia4505'])?$_REQUEST['pResultadoCitologia4505']:null;
    $pCitologia4505 = isset($_REQUEST['pCitologia4505'])?$_REQUEST['pCitologia4505']:null;
    $pColposcopia4505 = isset($_REQUEST['pColposcopia4505'])?$_REQUEST['pColposcopia4505']:null;
    $pBiopsiaCervical4505 = isset($_REQUEST['pBiopsiaCervical4505'])?$_REQUEST['pBiopsiaCervical4505']:null;
    $pMamografia4505 = isset($_REQUEST['pMamografia4505'])?$_REQUEST['pMamografia4505']:null;
    $pBiopsiaSeno4505 = isset($_REQUEST['pBiopsiaSeno4505'])?$_REQUEST['pBiopsiaSeno4505']:null;
    $pTomaHemoglobina = isset($_REQUEST['pTomaHemoglobina'])?$_REQUEST['pTomaHemoglobina']:null;
    $pResultadoHemoglobina = isset($_REQUEST['pResultadoHemoglobina'])?$_REQUEST['pResultadoHemoglobina']:null;
    $pTomaCreatinina = isset($_REQUEST['pTomaCreatinina'])?$_REQUEST['pTomaCreatinina']:null;
    $pResultadoCreatinina = isset($_REQUEST['pResultadoCreatinina'])?$_REQUEST['pResultadoCreatinina']:null;
    $pTomaHemoglobinaGlicosilada = isset($_REQUEST['pTomaHemoglobinaGlicosilada'])?$_REQUEST['pTomaHemoglobinaGlicosilada']:null;
    $pResultadoHemoglobinaGlicosilada = isset($_REQUEST['pResultadoHemoglobinaGlicosilada'])?$_REQUEST['pResultadoHemoglobinaGlicosilada']:null;
    $pTomaGlicemia = isset($_REQUEST['pTomaGlicemia'])?$_REQUEST['pTomaGlicemia']:null;
    $pTomaMicroalbuminuria = isset($_REQUEST['pTomaMicroalbuminuria'])?$_REQUEST['pTomaMicroalbuminuria']:null;
    $pTomaHDL = isset($_REQUEST['pTomaHDL'])?$_REQUEST['pTomaHDL']:null;
    $pTomaBaciloscopiaDiagnostica = isset($_REQUEST['pTomaBaciloscopiaDiagnostica'])?$_REQUEST['pTomaBaciloscopiaDiagnostica']:null;
    $pResultadoBaciloscopiaDiagnostica = isset($_REQUEST['pResultadoBaciloscopiaDiagnostica'])?$_REQUEST['pResultadoBaciloscopiaDiagnostica']:null;
    $pSerologia = isset($_REQUEST['pSerologia'])?$_REQUEST['pSerologia']:null;
    $pResultadoSerologia = isset($_REQUEST['pResultadoSerologia'])?$_REQUEST['pResultadoSerologia']:null;
    $pTomaElisaVIH = isset($_REQUEST['pTomaElisaVIH'])?$_REQUEST['pTomaElisaVIH']:null;
    $pResultadoElisaVIH = isset($_REQUEST['pResultadoElisaVIH'])?$_REQUEST['pResultadoElisaVIH']:null;
    $pTSHNeonatal = isset($_REQUEST['pTSHNeonatal'])?$_REQUEST['pTSHNeonatal']:null;
    $pResultadoTSHNeonatal = isset($_REQUEST['pResultadoTSHNeonatal'])?$_REQUEST['pResultadoTSHNeonatal']:null;
    $pBCG = isset($_REQUEST['pBCG'])?$_REQUEST['pBCG']:null;
    $pHepatitisB = isset($_REQUEST['pHepatitisB'])?$_REQUEST['pHepatitisB']:null;
    $pPentavalente = isset($_REQUEST['pPentavalente'])?$_REQUEST['pPentavalente']:null;
    $pPolio = isset($_REQUEST['pPolio'])?$_REQUEST['pPolio']:null;
    $pDPT = isset($_REQUEST['pDPT'])?$_REQUEST['pDPT']:null;
    $pRotavirus = isset($_REQUEST['pRotavirus'])?$_REQUEST['pRotavirus']:null;
    $pNeumococo = isset($_REQUEST['pNeumococo'])?$_REQUEST['pNeumococo']:null;
    $pInfluenza = isset($_REQUEST['pInfluenza'])?$_REQUEST['pInfluenza']:null;
    $pFiebreAmarilla = isset($_REQUEST['pFiebreAmarilla'])?$_REQUEST['pFiebreAmarilla']:null;
    $pHepatitisA = isset($_REQUEST['pHepatitisA'])?$_REQUEST['pHepatitisA']:null;
    $pTripleViral = isset($_REQUEST['pTripleViral'])?$_REQUEST['pTripleViral']:null;
    $pVPH = isset($_REQUEST['pVPH'])?$_REQUEST['pVPH']:null;
    $pTD = isset($_REQUEST['pTD'])?$_REQUEST['pTD']:null;
    $gBaseDatos = new ofiMySQLi();
    $gBaseDatos->conectar();
    $qry = "CALL sp_asistencial_edit_evolucion2013('" . $pEmpresa . "','" . $pIPS . "','" . $pPaciente . "','" . $pProfesional . "','" . $pCAS . "','" . $pConsecutivoDetalle . "',\"" . $pFechaAtencion . "\",\"" . $pHoraApertura . "\",\"" . $pActividad . "\",\"" . $pPlantilla . "\",\"" . $pEvolucion . "\",\"" . $pDiagppal . "\",\"" . $pDiagrel1 . "\",\"" . $pDiagrel2 . "\",\"" . $pDiagrel3 . "\",\"" . $pTipodiag . "\",\"" . $pFinalidad . "\",\"" . $pCausa . "\",\"" . $pAmbito . "\",\"" . $pFinalidadProced . "\",\"" . $pPersonalAtiende . "\",\"" . $pFormaActo . "\",'" . $pUsuario . "','" . $pIdCliente . "','" . $pIdPlan . "','" . $pIdSubPlan . "','" . $pIdContrato . "',\"" . $pAutorizacion . "\",\"" . $pCambiaCliente . "\",'" . $pFormulacion . "')";
    //echo $qry;
    if(@mysqli_query($gBaseDatos->ConexionID, $qry)){
        $gBaseDatos->cerrar();
        //echo "SIGNOS: " . $pGuardarSignos;
        if($pGuardarSignos == "SI"){
            $gBaseDatos = new ofiMySQLi();
            $gBaseDatos->conectar();
            $qry = "CALL sp_asistencial_edit_tomasignos_ped('" . $pEmpresa . "','" . $pIPS . "','" . $pPaciente . "','" . $pProfesional . "',\"" . $pFechaAtencion . "\",'" . $pCAS . "','" . $pTalla . "','" . $pPeso . "','" . $pIMC . "',\"" . $pIMCClasifica . "\",'" . $pTE . "','" . $pPerimetroCefalico . "')";
            @mysqli_query($gBaseDatos->ConexionID, $qry);
            $gBaseDatos->cerrar();
        }
        echo "{success: true, requestedId:'1'}";
    }else{
       echo "{success: true, requestedId:'0'}";
        $gBaseDatos->cerrar();
    }
}

function GuardarBarthelHC()
{
    $pEmpresa = isset($_REQUEST['pEmpresa'])?$_REQUEST['pEmpresa']:0;
    $pIPS = isset($_REQUEST['pIPS'])?$_REQUEST['pIPS']:0;
    $pCAS = isset($_REQUEST['pCAS'])?$_REQUEST['pCAS']:0;
    $pConsecutivoDetalle = isset($_REQUEST['pConsecutivoDetalle'])?$_REQUEST['pConsecutivoDetalle']:0;
    $pResultadoBarthel = isset($_REQUEST['pResultadoBarthel'])?$_REQUEST['pResultadoBarthel']:null;
    $contenido = isset($_REQUEST['CAMPOS'])?$_REQUEST['CAMPOS']:null;
    $pEvolucion = stripslashes(utf8_encode(str_replace('"', '""',nl2br($contenido))));
    $gBaseDatos = new ofiMySQLi();
    $gBaseDatos->conectar();
    $qry = "CALL sp_asistencial_edit_evolucion_barthel('" . $pEmpresa . "','" . $pIPS . "','" . $pCAS . "','" . $pConsecutivoDetalle . "',\"" . $pResultadoBarthel . "\",\"" . $pEvolucion . "\")";
    //echo $qry;
    if(@mysqli_query($gBaseDatos->ConexionID, $qry))
        echo "{success: true, requestedId:'1'}";
    else
       echo "{success: true, requestedId:'0'}";
    $gBaseDatos->cerrar();
}

function GuardarHachinskiHC()
{
    $pEmpresa = isset($_REQUEST['pEmpresa'])?$_REQUEST['pEmpresa']:0;
    $pIPS = isset($_REQUEST['pIPS'])?$_REQUEST['pIPS']:0;
    $pCAS = isset($_REQUEST['pCAS'])?$_REQUEST['pCAS']:0;
    $pConsecutivoDetalle = isset($_REQUEST['pConsecutivoDetalle'])?$_REQUEST['pConsecutivoDetalle']:0;
    $pResultadoClasifica = isset($_REQUEST['pResultadoClasifica'])?$_REQUEST['pResultadoClasifica']:null;
    $contenido = isset($_REQUEST['CAMPOS'])?$_REQUEST['CAMPOS']:null;
    $pEvolucion = stripslashes(utf8_encode(str_replace('"', '""',nl2br($contenido))));
    $gBaseDatos = new ofiMySQLi();
    $gBaseDatos->conectar();
    $qry = "CALL sp_asistencial_edit_evolucion_hachinski('" . $pEmpresa . "','" . $pIPS . "','" . $pCAS . "','" . $pConsecutivoDetalle . "',\"" . $pResultadoClasifica . "\",\"" . $pEvolucion . "\")";
    //echo $qry;
    if(@mysqli_query($gBaseDatos->ConexionID, $qry))
        echo "{success: true, requestedId:'1'}";
    else
       echo "{success: true, requestedId:'0'}";
    $gBaseDatos->cerrar();
}

function GuardarFolsteinHC(){
    $pEmpresa = isset($_REQUEST['pEmpresa'])?$_REQUEST['pEmpresa']:0;
    $pIPS = isset($_REQUEST['pIPS'])?$_REQUEST['pIPS']:0;
    $pCAS = isset($_REQUEST['pCAS'])?$_REQUEST['pCAS']:0;
    $pConsecutivoDetalle = isset($_REQUEST['pConsecutivoDetalle'])?$_REQUEST['pConsecutivoDetalle']:0;
    $pResultadoClasifica = isset($_REQUEST['pResultadoClasifica'])?$_REQUEST['pResultadoClasifica']:null;
    $contenido = isset($_REQUEST['CAMPOS'])?$_REQUEST['CAMPOS']:null;
    $pEvolucion = stripslashes(utf8_encode(str_replace('"', '""',nl2br($contenido))));
    $gBaseDatos = new ofiMySQLi();
    $gBaseDatos->conectar();
    $qry = "CALL sp_asistencial_edit_evolucion_folstein('" . $pEmpresa . "','" . $pIPS . "','" . $pCAS . "','" . $pConsecutivoDetalle . "',\"" . $pResultadoClasifica . "\",\"" . $pEvolucion . "\")";
    //echo $qry;
    if(@mysqli_query($gBaseDatos->ConexionID, $qry))
        echo "{success: true, requestedId:'1'}";
    else
       echo "{success: true, requestedId:'0'}";
    $gBaseDatos->cerrar();
}

function GuardarLawtonHC(){
    $pEmpresa = isset($_REQUEST['pEmpresa'])?$_REQUEST['pEmpresa']:0;
    $pIPS = isset($_REQUEST['pIPS'])?$_REQUEST['pIPS']:0;
    $pCAS = isset($_REQUEST['pCAS'])?$_REQUEST['pCAS']:0;
    $pConsecutivoDetalle = isset($_REQUEST['pConsecutivoDetalle'])?$_REQUEST['pConsecutivoDetalle']:0;
    $pResultadoClasifica = isset($_REQUEST['pResultadoClasifica'])?$_REQUEST['pResultadoClasifica']:null;
    $contenido = isset($_REQUEST['CAMPOS'])?$_REQUEST['CAMPOS']:null;
    $pEvolucion = stripslashes(utf8_encode(str_replace('"', '""',nl2br($contenido))));
    $gBaseDatos = new ofiMySQLi();
    $gBaseDatos->conectar();
    $qry = "CALL sp_asistencial_edit_evolucion_lawton('" . $pEmpresa . "','" . $pIPS . "','" . $pCAS . "','" . $pConsecutivoDetalle . "',\"" . $pResultadoClasifica . "\",\"" . $pEvolucion . "\")";
    //echo $qry;
    if(@mysqli_query($gBaseDatos->ConexionID, $qry))
        echo "{success: true, requestedId:'1'}";
    else
       echo "{success: true, requestedId:'0'}";
    $gBaseDatos->cerrar();
}

function GuardarYesavageHC(){
    $pEmpresa = isset($_REQUEST['pEmpresa'])?$_REQUEST['pEmpresa']:0;
    $pIPS = isset($_REQUEST['pIPS'])?$_REQUEST['pIPS']:0;
    $pCAS = isset($_REQUEST['pCAS'])?$_REQUEST['pCAS']:0;
    $pConsecutivoDetalle = isset($_REQUEST['pConsecutivoDetalle'])?$_REQUEST['pConsecutivoDetalle']:0;
    $pResultadoClasifica = isset($_REQUEST['pResultadoClasifica'])?$_REQUEST['pResultadoClasifica']:null;
    $contenido = isset($_REQUEST['CAMPOS'])?$_REQUEST['CAMPOS']:null;
    $pEvolucion = stripslashes(utf8_encode(str_replace('"', '""',nl2br($contenido))));
    $gBaseDatos = new ofiMySQLi();
    $gBaseDatos->conectar();
    $qry = "CALL sp_asistencial_edit_evolucion_yesavage('" . $pEmpresa . "','" . $pIPS . "','" . $pCAS . "','" . $pConsecutivoDetalle . "',\"" . $pResultadoClasifica . "\",\"" . $pEvolucion . "\")";
    //echo $qry;
    if(@mysqli_query($gBaseDatos->ConexionID, $qry))
        echo "{success: true, requestedId:'1'}";
    else
       echo "{success: true, requestedId:'0'}";
    $gBaseDatos->cerrar();
}


function GuardarProc()
{
    $pEmpresa = isset($_REQUEST['pEmpresa'])?$_REQUEST['pEmpresa']:0;
    $pIPS = isset($_REQUEST['pIPS'])?$_REQUEST['pIPS']:0;
    $pPaciente = isset($_REQUEST['pPaciente'])?$_REQUEST['pPaciente']:0;
    $pProfesional = $_SESSION['ID_PROFESIONAL_HC'];
    $pCAS = isset($_REQUEST['pCAS'])?$_REQUEST['pCAS']:0;
    $pConsecutivoDetalle = isset($_REQUEST['pConsecutivoDetalle'])?$_REQUEST['pConsecutivoDetalle']:0;
    $pidPlantillaHC = isset($_REQUEST['pidPlantillaHC'])?$_REQUEST['pidPlantillaHC']:0;
    $pFechaAtencion = isset($_REQUEST['pFechaAtencion'])?$_REQUEST['pFechaAtencion']:null;
    $pHoraApertura = isset($_REQUEST['pHoraApertura'])?$_REQUEST['pHoraApertura']:null;
    $pActividad = isset($_REQUEST['pActividad'])?$_REQUEST['pActividad']:null;
    $pPlantilla = isset($_REQUEST['pPlantilla'])?$_REQUEST['pPlantilla']:null;
    $pRutaRptHC = isset($_REQUEST['pRutaRptHC'])?$_REQUEST['pRutaRptHC']:null;
    $pRutaRptMx = isset($_REQUEST['pRutaRptMx'])?$_REQUEST['pRutaRptMx']:null;
    $pRutaRptExa = isset($_REQUEST['pRutaRptExa'])?$_REQUEST['pRutaRptExa']:null;
    $pRutaRptRem = isset($_REQUEST['pRutaRptRem'])?$_REQUEST['pRutaRptRem']:null;
    $contenido = isset($_REQUEST['CAMPOS'])?$_REQUEST['CAMPOS']:null;
    $pEvolucion = stripslashes(utf8_encode(str_replace('"', '""',nl2br($contenido))));
    $pDiagppal = isset($_REQUEST['pDiagppal'])?$_REQUEST['pDiagppal']:null;
    $pDiagrel1 = isset($_REQUEST['pDiagrel1'])?$_REQUEST['pDiagrel1']:null;
    $pDiagrel2 = isset($_REQUEST['pDiagrel2'])?$_REQUEST['pDiagrel2']:null;
    $pDiagrel3 = isset($_REQUEST['pDiagrel3'])?$_REQUEST['pDiagrel3']:null;
    $pAmbito = isset($_REQUEST['pAmbito'])?$_REQUEST['pAmbito']:1;
    $pFinalidad = isset($_REQUEST['pFinalidad'])?$_REQUEST['pFinalidad']:1;
    $pPersona = isset($_REQUEST['pPersona'])?$_REQUEST['pPersona']:5;
    $pForma = isset($_REQUEST['pForma'])?$_REQUEST['pForma']:1;
    $pUsuario = isset($_REQUEST['pUsuario'])?$_REQUEST['pUsuario']:0;
    $pIdCliente = isset($_REQUEST['pIdCliente'])?$_REQUEST['pIdCliente']:0;
    $pIdPlan = isset($_REQUEST['pIdPlan'])?$_REQUEST['pIdPlan']:0;
    $pIdSubPlan = isset($_REQUEST['pIdSubPlan'])?$_REQUEST['pIdSubPlan']:0;
    $pIdContrato = isset($_REQUEST['pIdContrato'])?$_REQUEST['pIdContrato']:0;
    
    $gBaseDatos = new ofiMySQLi();
    $gBaseDatos->conectar();
    $qry = "CALL sp_asistencial_add_proced('" . $pEmpresa . "','" . $pIPS . "','" . $pPaciente . "','" . $pProfesional . "','" . $pCAS . "','" . $pConsecutivoDetalle . "','" . $pidPlantillaHC . "',\"" . $pFechaAtencion . "\",\"" . $pHoraApertura . "\",\"" . $pActividad . "\",\"" . $pPlantilla . "\",\"" . $pRutaRptHC . "\",\"" . $pRutaRptMx . "\",\"" . $pRutaRptExa . "\",\"" . $pRutaRptRem . "\",\"" . $pEvolucion . "\",\"" . $pDiagppal . "\",\"" . $pDiagrel1 . "\",\"" . $pDiagrel2 . "\",\"" . $pAmbito . "\",\"" . $pFinalidad . "\",\"" . $pPersona . "\",\"" . $pForma . "\",'" . $pUsuario . "','" . $pIdCliente . "','" . $pIdPlan . "','" . $pIdSubPlan . "','" . $pIdContrato . "')";
    //echo $qry;
    if(@mysqli_query($gBaseDatos->ConexionID, $qry))
        echo "{success: true, requestedId:'1'}";
    else
       echo "{success: true, requestedId:'0'}";
    $gBaseDatos->cerrar();   
}

function ModificarProc()
{
    $pEmpresa = isset($_REQUEST['pEmpresa'])?$_REQUEST['pEmpresa']:0;
    $pIPS = isset($_REQUEST['pIPS'])?$_REQUEST['pIPS']:0;
    $pPaciente = isset($_REQUEST['pPaciente'])?$_REQUEST['pPaciente']:0;
    $pProfesional = $_SESSION['ID_PROFESIONAL_HC'];
    $pCAS = isset($_REQUEST['pCAS'])?$_REQUEST['pCAS']:0;
    $pConsecutivoDetalle = isset($_REQUEST['pConsecutivoDetalle'])?$_REQUEST['pConsecutivoDetalle']:0;
    $pFechaAtencion = isset($_REQUEST['pFechaAtencion'])?$_REQUEST['pFechaAtencion']:null;
    $pHoraApertura = isset($_REQUEST['pHoraApertura'])?$_REQUEST['pHoraApertura']:null;
    $pActividad = isset($_REQUEST['pActividad'])?$_REQUEST['pActividad']:null;
    $pPlantilla = isset($_REQUEST['pPlantilla'])?$_REQUEST['pPlantilla']:null;
    $pRutaRptHC = isset($_REQUEST['pRutaRptHC'])?$_REQUEST['pRutaRptHC']:null;
    $pRutaRptMx = isset($_REQUEST['pRutaRptMx'])?$_REQUEST['pRutaRptMx']:null;
    $pRutaRptExa = isset($_REQUEST['pRutaRptExa'])?$_REQUEST['pRutaRptExa']:null;
    $pRutaRptRem = isset($_REQUEST['pRutaRptRem'])?$_REQUEST['pRutaRptRem']:null;
    $contenido = isset($_REQUEST['CAMPOS'])?$_REQUEST['CAMPOS']:null;
    $pEvolucion = stripslashes(utf8_encode(str_replace('"', '""',nl2br($contenido))));
    $pDiagppal = isset($_REQUEST['pDiagppal'])?$_REQUEST['pDiagppal']:null;
    $pDiagrel1 = isset($_REQUEST['pDiagrel1'])?$_REQUEST['pDiagrel1']:null;
    $pDiagrel2 = isset($_REQUEST['pDiagrel2'])?$_REQUEST['pDiagrel2']:null;
    $pDiagrel3 = isset($_REQUEST['pDiagrel3'])?$_REQUEST['pDiagrel3']:null;
    $pAmbito = isset($_REQUEST['pAmbito'])?$_REQUEST['pAmbito']:1;
    $pFinalidad = isset($_REQUEST['pFinalidad'])?$_REQUEST['pFinalidad']:1;
    $pPersona = isset($_REQUEST['pPersona'])?$_REQUEST['pPersona']:5;
    $pForma = isset($_REQUEST['pForma'])?$_REQUEST['pForma']:1;
    $pUsuario = isset($_REQUEST['pUsuario'])?$_REQUEST['pUsuario']:0;
    $pIdCliente = isset($_REQUEST['pIdCliente'])?$_REQUEST['pIdCliente']:0;
    $pIdPlan = isset($_REQUEST['pIdPlan'])?$_REQUEST['pIdPlan']:0;
    $pIdSubPlan = isset($_REQUEST['pIdSubPlan'])?$_REQUEST['pIdSubPlan']:0;
    $pIdContrato = isset($_REQUEST['pIdContrato'])?$_REQUEST['pIdContrato']:0;
    
    $gBaseDatos = new ofiMySQLi();
    $gBaseDatos->conectar();
    $qry = "CALL sp_asistencial_edit_proced('" . $pEmpresa . "','" . $pIPS . "','" . $pPaciente . "','" . $pProfesional . "','" . $pCAS . "','" . $pConsecutivoDetalle . "','" . $pidPlantillaHC . "',\"" . $pFechaAtencion . "\",\"" . $pHoraApertura . "\",\"" . $pActividad . "\",\"" . $pPlantilla . "\",\"" . $pRutaRptHC . "\",\"" . $pRutaRptMx . "\",\"" . $pRutaRptExa . "\",\"" . $pRutaRptRem . "\",\"" . $pEvolucion . "\",\"" . $pDiagppal . "\",\"" . $pDiagrel1 . "\",\"" . $pDiagrel2 . "\",\"" . $pAmbito . "\",\"" . $pFinalidad . "\",\"" . $pPersona . "\",\"" . $pForma . "\",'" . $pUsuario . "','" . $pIdCliente . "','" . $pIdPlan . "','" . $pIdSubPlan . "','" . $pIdContrato . "')";
    //echo $qry;
    if(@mysqli_query($gBaseDatos->ConexionID, $qry))
        echo "{success: true, requestedId:'1'}";
    else
       echo "{success: true, requestedId:'0'}";
    $gBaseDatos->cerrar();
}

function GuardarTomaCitologia()
{
    
    $pEmpresa = isset($_REQUEST['pEmpresa'])?$_REQUEST['pEmpresa']:0;
    $pIPS = isset($_REQUEST['pIPS'])?$_REQUEST['pIPS']:0;
    $pPaciente = isset($_REQUEST['pPaciente'])?$_REQUEST['pPaciente']:0;
    $pProfesional = $_SESSION['ID_PROFESIONAL_HC'];
    $pCAS = isset($_REQUEST['pCAS'])?$_REQUEST['pCAS']:0;
    $pConsecutivoDetalle = isset($_REQUEST['pConsecutivoDetalle'])?$_REQUEST['pConsecutivoDetalle']:0;
    $pidPlantillaHC = isset($_REQUEST['pidPlantillaHC'])?$_REQUEST['pidPlantillaHC']:0;
    $pFechaAtencion = isset($_REQUEST['pFechaAtencion'])?$_REQUEST['pFechaAtencion']:null;
    $pHoraApertura = isset($_REQUEST['pHoraApertura'])?$_REQUEST['pHoraApertura']:null;
    $pActividad = isset($_REQUEST['pActividad'])?$_REQUEST['pActividad']:null;
    $pPlantilla = isset($_REQUEST['pPlantilla'])?$_REQUEST['pPlantilla']:null;
    $pRutaRptHC = isset($_REQUEST['pRutaRptHC'])?$_REQUEST['pRutaRptHC']:null;
    $pRutaRptMx = isset($_REQUEST['pRutaRptMx'])?$_REQUEST['pRutaRptMx']:null;
    $pRutaRptExa = isset($_REQUEST['pRutaRptExa'])?$_REQUEST['pRutaRptExa']:null;
    $pRutaRptRem = isset($_REQUEST['pRutaRptRem'])?$_REQUEST['pRutaRptRem']:null;
    $contenido = isset($_REQUEST['CAMPOS'])?$_REQUEST['CAMPOS']:null;
    $pEvolucion = utf8_encode(str_replace('"', '""',nl2br($contenido)));
    $pDiagppal = isset($_REQUEST['pDiagppal'])?$_REQUEST['pDiagppal']:null;
    $pDiagrel1 = isset($_REQUEST['pDiagrel1'])?$_REQUEST['pDiagrel1']:null;
    $pDiagrel2 = isset($_REQUEST['pDiagrel2'])?$_REQUEST['pDiagrel2']:null;
    $pDiagrel3 = isset($_REQUEST['pDiagrel3'])?$_REQUEST['pDiagrel3']:null;
    $pTipodiag = isset($_REQUEST['pTipodiag'])?$_REQUEST['pTipodiag']:null;
    $pFinalidad = isset($_REQUEST['pFinalidad'])?$_REQUEST['pFinalidad']:null;
    $pCausa = isset($_REQUEST['pCausa'])?$_REQUEST['pCausa']:null;
    $pAmbito = isset($_REQUEST['pAmbito'])?$_REQUEST['pAmbito']:null;
    $pFinalidadProced = isset($_REQUEST['pFinalidadProced'])?$_REQUEST['pFinalidadProced']:null;
    $pPersonalAtiende = isset($_REQUEST['pPersonalAtiende'])?$_REQUEST['pPersonalAtiende']:null;
    $pFormaActo = isset($_REQUEST['pFormaActo'])?$_REQUEST['pFormaActo']:null;
    $pUsuario = isset($_REQUEST['pUsuario'])?$_REQUEST['pUsuario']:0;
    $pIdCliente = isset($_REQUEST['pIdCliente'])?$_REQUEST['pIdCliente']:0;
    $pIdPlan = isset($_REQUEST['pIdPlan'])?$_REQUEST['pIdPlan']:0;
    $pIdSubPlan = isset($_REQUEST['pIdSubPlan'])?$_REQUEST['pIdSubPlan']:0;
    $pIdContrato = isset($_REQUEST['pIdContrato'])?$_REQUEST['pIdContrato']:0;
    $pAutorizacion = isset($_REQUEST['pAutorizacion'])?$_REQUEST['pAutorizacion']:null;
    $pCITFecCitologia = isset($_REQUEST['pCITFecCitologia'])?$_REQUEST['pCITFecCitologia']:null;
    $pCITLactancia = isset($_REQUEST['pCITLactancia'])?$_REQUEST['pCITLactancia']:null;
    $pCITFecUltMestruacion = isset($_REQUEST['pCITFecUltMestruacion'])?$_REQUEST['pCITFecUltMestruacion']:null;
    $pCITGestaciones = isset($_REQUEST['pCITGestaciones'])?$_REQUEST['pCITGestaciones']:null;
    $pCITPartos = isset($_REQUEST['pCITPartos'])?$_REQUEST['pCITPartos']:null;
    $pCITAbortos = isset($_REQUEST['pCITAbortos'])?$_REQUEST['pCITAbortos']:null;
    $pCITEmbarazoActual = isset($_REQUEST['pCITEmbarazoActual'])?$_REQUEST['pCITEmbarazoActual']:null;
    $pCITMetodoPlanifica = isset($_REQUEST['pCITMetodoPlanifica'])?$_REQUEST['pCITMetodoPlanifica']:null;
    $pCITTiempoUso = isset($_REQUEST['pCITTiempoUso'])?$_REQUEST['pCITTiempoUso']:null;
    $pCITFecUltCitologia = isset($_REQUEST['pCITFecUltCitologia'])?$_REQUEST['pCITFecUltCitologia']:null;
    $pCITResultadoCitologia = isset($_REQUEST['pCITResultadoCitologia'])?$_REQUEST['pCITResultadoCitologia']:null;
    $pCITCauterizacion = isset($_REQUEST['pCITCauterizacion'])?$_REQUEST['pCITCauterizacion']:null;
    $pCITCauterizacionFec = isset($_REQUEST['pCITCauterizacionFec'])?$_REQUEST['pCITCauterizacionFec']:null;
    $pCITHisterectomia = isset($_REQUEST['pCITHisterectomia'])?$_REQUEST['pCITHisterectomia']:null;
    $pCITHisterectomiaFec = isset($_REQUEST['pCITHisterectomiaFec'])?$_REQUEST['pCITHisterectomiaFec']:null;
    $pCITVaporizacion = isset($_REQUEST['pCITVaporizacion'])?$_REQUEST['pCITVaporizacion']:null;
    $pCITVaporizacionFec = isset($_REQUEST['pCITVaporizacionFec'])?$_REQUEST['pCITVaporizacionFec']:null;
    $pCITConizacion = isset($_REQUEST['pCITConizacion'])?$_REQUEST['pCITConizacion']:null;
    $pCITConizacionFec = isset($_REQUEST['pCITConizacionFec'])?$_REQUEST['pCITConizacionFec']:null;
    $pCITCrioterapia = isset($_REQUEST['pCITCrioterapia'])?$_REQUEST['pCITCrioterapia']:null;
    $pCITCrioterapiaFec = isset($_REQUEST['pCITCrioterapiaFec'])?$_REQUEST['pCITCrioterapiaFec']:null;
    $pCITRadioterapia = isset($_REQUEST['pCITRadioterapia'])?$_REQUEST['pCITRadioterapia']:null;
    $pCITRadioterapiaFec = isset($_REQUEST['pCITRadioterapiaFec'])?$_REQUEST['pCITRadioterapiaFec']:null;
    $pCITTtoHormonal = isset($_REQUEST['pCITTtoHormonal'])?$_REQUEST['pCITTtoHormonal']:null;
    $pCITTtoHormonalFec = isset($_REQUEST['pCITTtoHormonalFec'])?$_REQUEST['pCITTtoHormonalFec']:null;
    $pCITBiopsia = isset($_REQUEST['pCITBiopsia'])?$_REQUEST['pCITBiopsia']:null;
    $pCITBiopsiaFec = isset($_REQUEST['pCITBiopsiaFec'])?$_REQUEST['pCITBiopsiaFec']:null;
    $pCITColposcopia = isset($_REQUEST['pCITColposcopia'])?$_REQUEST['pCITColposcopia']:null;
    $pCITColposcopiaFec = isset($_REQUEST['pCITColposcopiaFec'])?$_REQUEST['pCITColposcopiaFec']:null;
    $pCITAusente = isset($_REQUEST['pCITAusente'])?$_REQUEST['pCITAusente']:null;
    $pCITSano = isset($_REQUEST['pCITSano'])?$_REQUEST['pCITSano']:null;
    $pCITAtrofico = isset($_REQUEST['pCITAtrofico'])?$_REQUEST['pCITAtrofico']:null;
    $pCITCongestivo = isset($_REQUEST['pCITCongestivo'])?$_REQUEST['pCITCongestivo']:null;
    $pCITUlcerado = isset($_REQUEST['pCITUlcerado'])?$_REQUEST['pCITUlcerado']:null;
    $pCITPolipo = isset($_REQUEST['pCITPolipo'])?$_REQUEST['pCITPolipo']:null;
    $pCITMasa = isset($_REQUEST['pCITMasa'])?$_REQUEST['pCITMasa']:null;
    $pCITObservacionesToma = isset($_REQUEST['pCITObservacionesToma'])?$_REQUEST['pCITObservacionesToma']:null;
    $pCITCalidad1 = isset($_REQUEST['pCITCalidad1'])?$_REQUEST['pCITCalidad1']:null;
    $pCITCalidad2 = isset($_REQUEST['pCITCalidad2'])?$_REQUEST['pCITCalidad2']:null;
    $pCITCalidad3 = isset($_REQUEST['pCITCalidad3'])?$_REQUEST['pCITCalidad3']:null;
    $pCITCalidad4 = isset($_REQUEST['pCITCalidad4'])?$_REQUEST['pCITCalidad4']:null;
    $pCITCausa = isset($_REQUEST['pCITCausa'])?$_REQUEST['pCITCausa']:null;
    $pCITCategorizacion1 = isset($_REQUEST['pCITCategorizacion1'])?$_REQUEST['pCITCategorizacion1']:null;
    $pCITCategorizacion2 = isset($_REQUEST['pCITCategorizacion2'])?$_REQUEST['pCITCategorizacion2']:null;
    $pCITMicroorganismos1 = isset($_REQUEST['pCITMicroorganismos1'])?$_REQUEST['pCITMicroorganismos1']:null;
    $pCITMicroorganismos2 = isset($_REQUEST['pCITMicroorganismos2'])?$_REQUEST['pCITMicroorganismos2']:null;
    $pCITMicroorganismos3 = isset($_REQUEST['pCITMicroorganismos3'])?$_REQUEST['pCITMicroorganismos3']:null;
    $pCITMicroorganismos4 = isset($_REQUEST['pCITMicroorganismos4'])?$_REQUEST['pCITMicroorganismos4']:null;
    $pCITMicroorganismos5 = isset($_REQUEST['pCITMicroorganismos5'])?$_REQUEST['pCITMicroorganismos5']:null;
    $pCITMicroorganismos6 = isset($_REQUEST['pCITMicroorganismos6'])?$_REQUEST['pCITMicroorganismos6']:null;
    $pCITOtrosHallazgos1 = isset($_REQUEST['pCITOtrosHallazgos1'])?$_REQUEST['pCITOtrosHallazgos1']:null;
    $pCITOtrosHallazgos2 = isset($_REQUEST['pCITOtrosHallazgos2'])?$_REQUEST['pCITOtrosHallazgos2']:null;
    $pCITOtrosHallazgos3 = isset($_REQUEST['pCITOtrosHallazgos3'])?$_REQUEST['pCITOtrosHallazgos3']:null;
    $pCITOtrosHallazgos4 = isset($_REQUEST['pCITOtrosHallazgos4'])?$_REQUEST['pCITOtrosHallazgos4']:null;
    $pCITOtrosHallazgos5 = isset($_REQUEST['pCITOtrosHallazgos5'])?$_REQUEST['pCITOtrosHallazgos5']:null;
    $pCITOtrosHallazgos6 = isset($_REQUEST['pCITOtrosHallazgos6'])?$_REQUEST['pCITOtrosHallazgos6']:null;
    $pCITAnormalidades1 = isset($_REQUEST['pCITAnormalidades1'])?$_REQUEST['pCITAnormalidades1']:null;
    $pCITAnormalidades2 = isset($_REQUEST['pCITAnormalidades2'])?$_REQUEST['pCITAnormalidades2']:null;
    $pCITAnormalidades3 = isset($_REQUEST['pCITAnormalidades3'])?$_REQUEST['pCITAnormalidades3']:null;
    $pCITAnormalidades4 = isset($_REQUEST['pCITAnormalidades4'])?$_REQUEST['pCITAnormalidades4']:null;
    $pCITAnormalidades5 = isset($_REQUEST['pCITAnormalidades5'])?$_REQUEST['pCITAnormalidades5']:null;
    $pCITAnormalidades6 = isset($_REQUEST['pCITAnormalidades6'])?$_REQUEST['pCITAnormalidades6']:null;
    $pCITAnormalidadesGlandulares1 = isset($_REQUEST['pCITAnormalidadesGlandulares1'])?$_REQUEST['pCITAnormalidadesGlandulares1']:null;
    $pCITAnormalidadesGlandulares2 = isset($_REQUEST['pCITAnormalidadesGlandulares2'])?$_REQUEST['pCITAnormalidadesGlandulares2']:null;
    $pCITAnormalidadesGlandulares3 = isset($_REQUEST['pCITAnormalidadesGlandulares3'])?$_REQUEST['pCITAnormalidadesGlandulares3']:null;
    $pCITAnormalidadesGlandulares4 = isset($_REQUEST['pCITAnormalidadesGlandulares4'])?$_REQUEST['pCITAnormalidadesGlandulares4']:null;
    $pCITAnormalidadesGlandulares5 = isset($_REQUEST['pCITAnormalidadesGlandulares5'])?$_REQUEST['pCITAnormalidadesGlandulares5']:null;
    $pCITAnormalidadesGlandulares6 = isset($_REQUEST['pCITAnormalidadesGlandulares6'])?$_REQUEST['pCITAnormalidadesGlandulares6']:null;
    $pCITAnormalidadesGlandulares7 = isset($_REQUEST['pCITAnormalidadesGlandulares7'])?$_REQUEST['pCITAnormalidadesGlandulares7']:null;
    $pCITAnormalidadesGlandulares8 = isset($_REQUEST['pCITAnormalidadesGlandulares8'])?$_REQUEST['pCITAnormalidadesGlandulares8']:null;
    $pCITAnormalidadesGlandulares9 = isset($_REQUEST['pCITAnormalidadesGlandulares9'])?$_REQUEST['pCITAnormalidadesGlandulares9']:null;
    $pCITAnormalidadesGlandulares10 = isset($_REQUEST['pCITAnormalidadesGlandulares10'])?$_REQUEST['pCITAnormalidadesGlandulares10']:null;
    $pCITAnormalidadesGlandulares11 = isset($_REQUEST['pCITAnormalidadesGlandulares11'])?$_REQUEST['pCITAnormalidadesGlandulares11']:null;
    $pCITObservacionesRes = isset($_REQUEST['pCITObservacionesRes'])?$_REQUEST['pCITObservacionesRes']:null;
    $pCITProflectura = isset($_REQUEST['pCITProflectura'])?$_REQUEST['pCITProflectura']:null;
    $pCITNombreLectura = isset($_REQUEST['pCITNombreLectura'])?$_REQUEST['pCITNombreLectura']:null;
    $pCITRegistroLectura = isset($_REQUEST['pCITRegistroLectura'])?$_REQUEST['pCITRegistroLectura']:null;
    $pCITFechaLectura = isset($_REQUEST['pCITFechaLectura'])?$_REQUEST['pCITFechaLectura']:null;
    $pCITProflectura2 = isset($_REQUEST['pCITProflectura2'])?$_REQUEST['pCITProflectura2']:null;
    $pCITNombreLectura2 = isset($_REQUEST['pCITNombreLectura2'])?$_REQUEST['pCITNombreLectura2']:null;
    $pCITRegistroLectura2 = isset($_REQUEST['pCITRegistroLectura2'])?$_REQUEST['pCITRegistroLectura2']:null;
    $pCITFechaLectura2 = isset($_REQUEST['pCITFechaLectura2'])?$_REQUEST['pCITFechaLectura2']:null;
    $pCITFechaEntregaRes = isset($_REQUEST['pCITFechaEntregaRes'])?$_REQUEST['pCITFechaEntregaRes']:null;
    $pUsuario = isset($_REQUEST['pUsuario'])?$_REQUEST['pUsuario']:null;
    if($pAutorizacion == null || $pAutorizacion == ""){
        $pAutorizacion = "NA";
    }
    $pFormulacion = isset($_REQUEST['pFormulacion'])?$_REQUEST['pFormulacion']:1;
    if($pFormulacion == null || $pFormulacion == ""){
        $pFormulacion = 1;
    }
    
    $pCambiaCliente = isset($_REQUEST['pCambiaCliente'])?$_REQUEST['pCambiaCliente']:"NA";
    $gBaseDatos = new ofiMySQLi();
    $gBaseDatos->conectar();
    $qry = "CALL sp_asistencial_add_evolucion('" . $pEmpresa . "','" . $pIPS . "','" . $pPaciente . "','" . $pProfesional . "','" . $pCAS . "','" . $pConsecutivoDetalle . "','" . $pidPlantillaHC . "',\"" . $pFechaAtencion . "\",\"" . $pHoraApertura . "\",\"" . $pActividad . "\",\"" . $pPlantilla . "\",\"" . $pRutaRptHC . "\",\"" . $pRutaRptMx . "\",\"" . $pRutaRptExa . "\",\"" . $pRutaRptRem . "\",\"" . $pEvolucion . "\",\"" . $pDiagppal . "\",\"" . $pDiagrel1 . "\",\"" . $pDiagrel2 . "\",\"" . $pDiagrel3 . "\",\"" . $pTipodiag . "\",\"" . $pFinalidad . "\",\"" . $pCausa . "\",\"" . $pAmbito . "\",\"" . $pFinalidadProced . "\",\"" . $pPersonalAtiende . "\",\"" . $pFormaActo . "\",'" . $pUsuario . "','" . $pIdCliente . "','" . $pIdPlan . "','" . $pIdSubPlan . "','" . $pIdContrato . "',\"" . $pAutorizacion . "\",\"" . $pCambiaCliente . "\",'" . $pFormulacion . "')";
    //echo $qry;
    if(@mysqli_query($gBaseDatos->ConexionID, $qry)){
        $gBaseDatos->cerrar();
        $gBaseDatos = new ofiMySQLi();
        $gBaseDatos->conectar();
        $qry = "CALL sp_asistencial_add_evolucion_citologia('" . $pPaciente . "','" . $pCAS . "','" . $pConsecutivoDetalle . "',\"" . $pCITFecCitologia . "\",\"" . $pCITLactancia . "\",\"" . $pCITFecUltMestruacion . "\",'" . $pCITGestaciones . "','" . $pCITPartos . "','" . $pCITAbortos . "',\"" . $pCITEmbarazoActual . "\",\"" . $pCITMetodoPlanifica . "\",\"" . $pCITTiempoUso . "\",\"" . $pCITFecUltCitologia . "\",\"" . $pCITResultadoCitologia . "\",\"" . $pCITCauterizacion . "\",\"" . $pCITCauterizacionFec . "\",\"" . $pCITHisterectomia . "\",\"" . $pCITHisterectomiaFec . "\",\"" . $pCITVaporizacion . "\",\"" . $pCITVaporizacionFec . "\",\"" . $pCITConizacion . "\",\"" . $pCITConizacionFec . "\",\"" . $pCITCrioterapia . "\",\"" . $pCITCrioterapiaFec . "\",\"" . $pCITRadioterapia . "\",\"" . $pCITRadioterapiaFec . "\",\"" . $pCITTtoHormonal . "\",\"" . $pCITTtoHormonalFec . "\",\"" . $pCITBiopsia . "\",\"" . $pCITBiopsiaFec . "\",\"" . $pCITColposcopia . "\",\"" . $pCITColposcopiaFec . "\",\"" . $pCITAusente . "\",\"" . $pCITSano . "\",\"" . $pCITAtrofico . "\",\"" . $pCITCongestivo . "\",\"" . $pCITUlcerado . "\",\"" . $pCITPolipo . "\",\"" . $pCITMasa . "\",\"" . $pCITObservacionesToma . "\",\"" . $pCITCalidad1 . "\",\"" . $pCITCalidad2 . "\",\"" . $pCITCalidad3 . "\",\"" . $pCITCalidad4 . "\",\"" . $pCITCausa . "\",\"" . $pCITCategorizacion1 . "\",\"" . $pCITCategorizacion2 . "\",\"" . $pCITMicroorganismos1 . "\",\"" . $pCITMicroorganismos2 . "\",\"" . $pCITMicroorganismos3 . "\",\"" . $pCITMicroorganismos4 . "\",\"" . $pCITMicroorganismos5 . "\",\"" . $pCITMicroorganismos6 . "\",\"" . $pCITOtrosHallazgos1 . "\",\"" . $pCITOtrosHallazgos2 . "\",\"" . $pCITOtrosHallazgos3 . "\",\"" . $pCITOtrosHallazgos4 . "\",\"" . $pCITOtrosHallazgos5 . "\",\"" . $pCITOtrosHallazgos6 . "\",\"" . $pCITAnormalidades1 . "\",\"" . $pCITAnormalidades2 . "\",\"" . $pCITAnormalidades3 . "\",\"" . $pCITAnormalidades4 . "\",\"" . $pCITAnormalidades5 . "\",\"" . $pCITAnormalidades6 . "\",\"" . $pCITAnormalidadesGlandulares1 . "\",\"" . $pCITAnormalidadesGlandulares2 . "\",\"" . $pCITAnormalidadesGlandulares3 . "\",\"" . $pCITAnormalidadesGlandulares4 . "\",\"" . $pCITAnormalidadesGlandulares5 . "\",\"" . $pCITAnormalidadesGlandulares6 . "\",\"" . $pCITAnormalidadesGlandulares7 . "\",\"" . $pCITAnormalidadesGlandulares8 . "\",\"" . $pCITAnormalidadesGlandulares9 . "\",\"" . $pCITAnormalidadesGlandulares10 . "\",\"" . $pCITAnormalidadesGlandulares11 . "\",\"" . $pCITObservacionesRes . "\",\"" . $pCITProflectura . "\",\"" . $pCITNombreLectura . "\",\"" . $pCITRegistroLectura . "\",\"" . $pCITFechaLectura . "\",\"" . $pCITProflectura2 . "\",\"" . $pCITNombreLectura2 . "\",\"" . $pCITRegistroLectura2 . "\",\"" . $pCITFechaLectura2 . "\",\"" . $pCITFechaEntregaRes . "\",'" . $pUsuario . "')";
        //echo $qry;
        if(@mysqli_query($gBaseDatos->ConexionID, $qry)){
            echo "{success: true, requestedId:'1'}";
            $gBaseDatos->cerrar();
        }else{
            echo "{success: true, requestedId:'0'}";
            $gBaseDatos->cerrar();
        }
    }else{
       echo "{success: true, requestedId:'0'}";
       $gBaseDatos->cerrar();
    }
}

function ModificarTomaCitologia()
{

    $pEmpresa = isset($_REQUEST['pEmpresa'])?$_REQUEST['pEmpresa']:0;
    $pIPS = isset($_REQUEST['pIPS'])?$_REQUEST['pIPS']:0;
    $pPaciente = isset($_REQUEST['pPaciente'])?$_REQUEST['pPaciente']:0;
    //$pProfesional = isset($_REQUEST['pProfesional'])?$_REQUEST['pProfesional']:0;
    $pProfesional = $_SESSION['ID_PROFESIONAL_HC'];
    $pCAS = isset($_REQUEST['pCAS'])?$_REQUEST['pCAS']:0;
    $pConsecutivoDetalle = isset($_REQUEST['pConsecutivoDetalle'])?$_REQUEST['pConsecutivoDetalle']:0;
    $pFechaAtencion = isset($_REQUEST['pFechaAtencion'])?$_REQUEST['pFechaAtencion']:null;
    $pHoraApertura = isset($_REQUEST['pHoraApertura'])?$_REQUEST['pHoraApertura']:null;
    $pActividad = isset($_REQUEST['pActividad'])?$_REQUEST['pActividad']:null;
    $pPlantilla = isset($_REQUEST['pPlantilla'])?$_REQUEST['pPlantilla']:null;
    $pRutaRptHC = isset($_REQUEST['pRutaRptHC'])?$_REQUEST['pRutaRptHC']:null;
    $pRutaRptMx = isset($_REQUEST['pRutaRptMx'])?$_REQUEST['pRutaRptMx']:null;
    $pRutaRptExa = isset($_REQUEST['pRutaRptExa'])?$_REQUEST['pRutaRptExa']:null;
    $pRutaRptRem = isset($_REQUEST['pRutaRptRem'])?$_REQUEST['pRutaRptRem']:null;
    $contenido = isset($_REQUEST['CAMPOS'])?$_REQUEST['CAMPOS']:null;
    $pEvolucion = utf8_encode(str_replace('"', '""',nl2br($contenido)));
    $pDiagppal = isset($_REQUEST['pDiagppal'])?$_REQUEST['pDiagppal']:null;
    $pDiagrel1 = isset($_REQUEST['pDiagrel1'])?$_REQUEST['pDiagrel1']:null;
    $pDiagrel2 = isset($_REQUEST['pDiagrel2'])?$_REQUEST['pDiagrel2']:null;
    $pDiagrel3 = isset($_REQUEST['pDiagrel3'])?$_REQUEST['pDiagrel3']:null;
    $pTipodiag = isset($_REQUEST['pTipodiag'])?$_REQUEST['pTipodiag']:null;
    $pFinalidad = isset($_REQUEST['pFinalidad'])?$_REQUEST['pFinalidad']:null;
    $pCausa = isset($_REQUEST['pCausa'])?$_REQUEST['pCausa']:null;
    $pAmbito = isset($_REQUEST['pAmbito'])?$_REQUEST['pAmbito']:null;
    $pFinalidadProced = isset($_REQUEST['pFinalidadProced'])?$_REQUEST['pFinalidadProced']:null;
    $pPersonalAtiende = isset($_REQUEST['pPersonalAtiende'])?$_REQUEST['pPersonalAtiende']:null;
    $pFormaActo = isset($_REQUEST['pFormaActo'])?$_REQUEST['pFormaActo']:null;
    $pUsuario = isset($_REQUEST['pUsuario'])?$_REQUEST['pUsuario']:0;
    $pIdCliente = isset($_REQUEST['pIdCliente'])?$_REQUEST['pIdCliente']:0;
    $pIdPlan = isset($_REQUEST['pIdPlan'])?$_REQUEST['pIdPlan']:0;
    $pIdSubPlan = isset($_REQUEST['pIdSubPlan'])?$_REQUEST['pIdSubPlan']:0;
    $pIdContrato = isset($_REQUEST['pIdContrato'])?$_REQUEST['pIdContrato']:0;
    $pAutorizacion = isset($_REQUEST['pAutorizacion'])?$_REQUEST['pAutorizacion']:null;
    $pCITFecCitologia = isset($_REQUEST['pCITFecCitologia'])?$_REQUEST['pCITFecCitologia']:null;
    $pCITLactancia = isset($_REQUEST['pCITLactancia'])?$_REQUEST['pCITLactancia']:null;
    $pCITFecUltMestruacion = isset($_REQUEST['pCITFecUltMestruacion'])?$_REQUEST['pCITFecUltMestruacion']:null;
    $pCITGestaciones = isset($_REQUEST['pCITGestaciones'])?$_REQUEST['pCITGestaciones']:null;
    $pCITPartos = isset($_REQUEST['pCITPartos'])?$_REQUEST['pCITPartos']:null;
    $pCITAbortos = isset($_REQUEST['pCITAbortos'])?$_REQUEST['pCITAbortos']:null;
    $pCITEmbarazoActual = isset($_REQUEST['pCITEmbarazoActual'])?$_REQUEST['pCITEmbarazoActual']:null;
    $pCITMetodoPlanifica = isset($_REQUEST['pCITMetodoPlanifica'])?$_REQUEST['pCITMetodoPlanifica']:null;
    $pCITTiempoUso = isset($_REQUEST['pCITTiempoUso'])?$_REQUEST['pCITTiempoUso']:null;
    $pCITFecUltCitologia = isset($_REQUEST['pCITFecUltCitologia'])?$_REQUEST['pCITFecUltCitologia']:null;
    $pCITResultadoCitologia = isset($_REQUEST['pCITResultadoCitologia'])?$_REQUEST['pCITResultadoCitologia']:null;
    $pCITCauterizacion = isset($_REQUEST['pCITCauterizacion'])?$_REQUEST['pCITCauterizacion']:null;
    $pCITCauterizacionFec = isset($_REQUEST['pCITCauterizacionFec'])?$_REQUEST['pCITCauterizacionFec']:null;
    $pCITHisterectomia = isset($_REQUEST['pCITHisterectomia'])?$_REQUEST['pCITHisterectomia']:null;
    $pCITHisterectomiaFec = isset($_REQUEST['pCITHisterectomiaFec'])?$_REQUEST['pCITHisterectomiaFec']:null;
    $pCITVaporizacion = isset($_REQUEST['pCITVaporizacion'])?$_REQUEST['pCITVaporizacion']:null;
    $pCITVaporizacionFec = isset($_REQUEST['pCITVaporizacionFec'])?$_REQUEST['pCITVaporizacionFec']:null;
    $pCITConizacion = isset($_REQUEST['pCITConizacion'])?$_REQUEST['pCITConizacion']:null;
    $pCITConizacionFec = isset($_REQUEST['pCITConizacionFec'])?$_REQUEST['pCITConizacionFec']:null;
    $pCITCrioterapia = isset($_REQUEST['pCITCrioterapia'])?$_REQUEST['pCITCrioterapia']:null;
    $pCITCrioterapiaFec = isset($_REQUEST['pCITCrioterapiaFec'])?$_REQUEST['pCITCrioterapiaFec']:null;
    $pCITRadioterapia = isset($_REQUEST['pCITRadioterapia'])?$_REQUEST['pCITRadioterapia']:null;
    $pCITRadioterapiaFec = isset($_REQUEST['pCITRadioterapiaFec'])?$_REQUEST['pCITRadioterapiaFec']:null;
    $pCITTtoHormonal = isset($_REQUEST['pCITTtoHormonal'])?$_REQUEST['pCITTtoHormonal']:null;
    $pCITTtoHormonalFec = isset($_REQUEST['pCITTtoHormonalFec'])?$_REQUEST['pCITTtoHormonalFec']:null;
    $pCITBiopsia = isset($_REQUEST['pCITBiopsia'])?$_REQUEST['pCITBiopsia']:null;
    $pCITBiopsiaFec = isset($_REQUEST['pCITBiopsiaFec'])?$_REQUEST['pCITBiopsiaFec']:null;
    $pCITColposcopia = isset($_REQUEST['pCITColposcopia'])?$_REQUEST['pCITColposcopia']:null;
    $pCITColposcopiaFec = isset($_REQUEST['pCITColposcopiaFec'])?$_REQUEST['pCITColposcopiaFec']:null;
    $pCITAusente = isset($_REQUEST['pCITAusente'])?$_REQUEST['pCITAusente']:null;
    $pCITSano = isset($_REQUEST['pCITSano'])?$_REQUEST['pCITSano']:null;
    $pCITAtrofico = isset($_REQUEST['pCITAtrofico'])?$_REQUEST['pCITAtrofico']:null;
    $pCITCongestivo = isset($_REQUEST['pCITCongestivo'])?$_REQUEST['pCITCongestivo']:null;
    $pCITUlcerado = isset($_REQUEST['pCITUlcerado'])?$_REQUEST['pCITUlcerado']:null;
    $pCITPolipo = isset($_REQUEST['pCITPolipo'])?$_REQUEST['pCITPolipo']:null;
    $pCITMasa = isset($_REQUEST['pCITMasa'])?$_REQUEST['pCITMasa']:null;
    $pCITObservacionesToma = isset($_REQUEST['pCITObservacionesToma'])?$_REQUEST['pCITObservacionesToma']:null;
    $pCITCalidad1 = isset($_REQUEST['pCITCalidad1'])?$_REQUEST['pCITCalidad1']:null;
    $pCITCalidad2 = isset($_REQUEST['pCITCalidad2'])?$_REQUEST['pCITCalidad2']:null;
    $pCITCalidad3 = isset($_REQUEST['pCITCalidad3'])?$_REQUEST['pCITCalidad3']:null;
    $pCITCalidad4 = isset($_REQUEST['pCITCalidad4'])?$_REQUEST['pCITCalidad4']:null;
    $pCITCausa = isset($_REQUEST['pCITCausa'])?$_REQUEST['pCITCausa']:null;
    $pCITCategorizacion1 = isset($_REQUEST['pCITCategorizacion1'])?$_REQUEST['pCITCategorizacion1']:null;
    $pCITCategorizacion2 = isset($_REQUEST['pCITCategorizacion2'])?$_REQUEST['pCITCategorizacion2']:null;
    $pCITMicroorganismos1 = isset($_REQUEST['pCITMicroorganismos1'])?$_REQUEST['pCITMicroorganismos1']:null;
    $pCITMicroorganismos2 = isset($_REQUEST['pCITMicroorganismos2'])?$_REQUEST['pCITMicroorganismos2']:null;
    $pCITMicroorganismos3 = isset($_REQUEST['pCITMicroorganismos3'])?$_REQUEST['pCITMicroorganismos3']:null;
    $pCITMicroorganismos4 = isset($_REQUEST['pCITMicroorganismos4'])?$_REQUEST['pCITMicroorganismos4']:null;
    $pCITMicroorganismos5 = isset($_REQUEST['pCITMicroorganismos5'])?$_REQUEST['pCITMicroorganismos5']:null;
    $pCITMicroorganismos6 = isset($_REQUEST['pCITMicroorganismos6'])?$_REQUEST['pCITMicroorganismos6']:null;
    $pCITOtrosHallazgos1 = isset($_REQUEST['pCITOtrosHallazgos1'])?$_REQUEST['pCITOtrosHallazgos1']:null;
    $pCITOtrosHallazgos2 = isset($_REQUEST['pCITOtrosHallazgos2'])?$_REQUEST['pCITOtrosHallazgos2']:null;
    $pCITOtrosHallazgos3 = isset($_REQUEST['pCITOtrosHallazgos3'])?$_REQUEST['pCITOtrosHallazgos3']:null;
    $pCITOtrosHallazgos4 = isset($_REQUEST['pCITOtrosHallazgos4'])?$_REQUEST['pCITOtrosHallazgos4']:null;
    $pCITOtrosHallazgos5 = isset($_REQUEST['pCITOtrosHallazgos5'])?$_REQUEST['pCITOtrosHallazgos5']:null;
    $pCITOtrosHallazgos6 = isset($_REQUEST['pCITOtrosHallazgos6'])?$_REQUEST['pCITOtrosHallazgos6']:null;
    $pCITAnormalidades1 = isset($_REQUEST['pCITAnormalidades1'])?$_REQUEST['pCITAnormalidades1']:null;
    $pCITAnormalidades2 = isset($_REQUEST['pCITAnormalidades2'])?$_REQUEST['pCITAnormalidades2']:null;
    $pCITAnormalidades3 = isset($_REQUEST['pCITAnormalidades3'])?$_REQUEST['pCITAnormalidades3']:null;
    $pCITAnormalidades4 = isset($_REQUEST['pCITAnormalidades4'])?$_REQUEST['pCITAnormalidades4']:null;
    $pCITAnormalidades5 = isset($_REQUEST['pCITAnormalidades5'])?$_REQUEST['pCITAnormalidades5']:null;
    $pCITAnormalidades6 = isset($_REQUEST['pCITAnormalidades6'])?$_REQUEST['pCITAnormalidades6']:null;
    $pCITAnormalidadesGlandulares1 = isset($_REQUEST['pCITAnormalidadesGlandulares1'])?$_REQUEST['pCITAnormalidadesGlandulares1']:null;
    $pCITAnormalidadesGlandulares2 = isset($_REQUEST['pCITAnormalidadesGlandulares2'])?$_REQUEST['pCITAnormalidadesGlandulares2']:null;
    $pCITAnormalidadesGlandulares3 = isset($_REQUEST['pCITAnormalidadesGlandulares3'])?$_REQUEST['pCITAnormalidadesGlandulares3']:null;
    $pCITAnormalidadesGlandulares4 = isset($_REQUEST['pCITAnormalidadesGlandulares4'])?$_REQUEST['pCITAnormalidadesGlandulares4']:null;
    $pCITAnormalidadesGlandulares5 = isset($_REQUEST['pCITAnormalidadesGlandulares5'])?$_REQUEST['pCITAnormalidadesGlandulares5']:null;
    $pCITAnormalidadesGlandulares6 = isset($_REQUEST['pCITAnormalidadesGlandulares6'])?$_REQUEST['pCITAnormalidadesGlandulares6']:null;
    $pCITAnormalidadesGlandulares7 = isset($_REQUEST['pCITAnormalidadesGlandulares7'])?$_REQUEST['pCITAnormalidadesGlandulares7']:null;
    $pCITAnormalidadesGlandulares8 = isset($_REQUEST['pCITAnormalidadesGlandulares8'])?$_REQUEST['pCITAnormalidadesGlandulares8']:null;
    $pCITAnormalidadesGlandulares9 = isset($_REQUEST['pCITAnormalidadesGlandulares9'])?$_REQUEST['pCITAnormalidadesGlandulares9']:null;
    $pCITAnormalidadesGlandulares10 = isset($_REQUEST['pCITAnormalidadesGlandulares10'])?$_REQUEST['pCITAnormalidadesGlandulares10']:null;
    $pCITAnormalidadesGlandulares11 = isset($_REQUEST['pCITAnormalidadesGlandulares11'])?$_REQUEST['pCITAnormalidadesGlandulares11']:null;
    $pCITObservacionesRes = isset($_REQUEST['pCITObservacionesRes'])?$_REQUEST['pCITObservacionesRes']:null;
    $pCITProflectura = isset($_REQUEST['pCITProflectura'])?$_REQUEST['pCITProflectura']:null;
    $pCITNombreLectura = isset($_REQUEST['pCITNombreLectura'])?$_REQUEST['pCITNombreLectura']:null;
    $pCITRegistroLectura = isset($_REQUEST['pCITRegistroLectura'])?$_REQUEST['pCITRegistroLectura']:null;
    $pCITFechaLectura = isset($_REQUEST['pCITFechaLectura'])?$_REQUEST['pCITFechaLectura']:null;
    $pCITProflectura2 = isset($_REQUEST['pCITProflectura2'])?$_REQUEST['pCITProflectura2']:null;
    $pCITNombreLectura2 = isset($_REQUEST['pCITNombreLectura2'])?$_REQUEST['pCITNombreLectura2']:null;
    $pCITRegistroLectura2 = isset($_REQUEST['pCITRegistroLectura2'])?$_REQUEST['pCITRegistroLectura2']:null;
    $pCITFechaLectura2 = isset($_REQUEST['pCITFechaLectura2'])?$_REQUEST['pCITFechaLectura2']:null;
    $pCITFechaEntregaRes = isset($_REQUEST['pCITFechaEntregaRes'])?$_REQUEST['pCITFechaEntregaRes']:null;
    $pUsuario = isset($_REQUEST['pUsuario'])?$_REQUEST['pUsuario']:null;
    if($pAutorizacion == null || $pAutorizacion == ""){
        $pAutorizacion = "NA";
    }
    $pFormulacion = isset($_REQUEST['pFormulacion'])?$_REQUEST['pFormulacion']:1;
    if($pFormulacion == null || $pFormulacion == ""){
        $pFormulacion = 1;
    }
    $pCambiaCliente = isset($_REQUEST['pCambiaCliente'])?$_REQUEST['pCambiaCliente']:"NA";
    $gBaseDatos = new ofiMySQLi();
    $gBaseDatos->conectar();
    $qry = "CALL sp_asistencial_edit_evolucion('" . $pEmpresa . "','" . $pIPS . "','" . $pPaciente . "','" . $pProfesional . "','" . $pCAS . "','" . $pConsecutivoDetalle . "',\"" . $pFechaAtencion . "\",\"" . $pHoraApertura . "\",\"" . $pActividad . "\",\"" . $pPlantilla . "\",\"" . $pEvolucion . "\",\"" . $pDiagppal . "\",\"" . $pDiagrel1 . "\",\"" . $pDiagrel2 . "\",\"" . $pDiagrel3 . "\",\"" . $pTipodiag . "\",\"" . $pFinalidad . "\",\"" . $pCausa . "\",\"" . $pAmbito . "\",\"" . $pFinalidadProced . "\",\"" . $pPersonalAtiende . "\",\"" . $pFormaActo . "\",'" . $pUsuario . "','" . $pIdCliente . "','" . $pIdPlan . "','" . $pIdSubPlan . "','" . $pIdContrato . "',\"" . $pAutorizacion . "\",\"" . $pCambiaCliente . "\",'" . $pFormulacion . "')";
    //echo $qry;
    if(@mysqli_query($gBaseDatos->ConexionID, $qry)){
        $gBaseDatos->cerrar();
        $gBaseDatos = new ofiMySQLi();
        $gBaseDatos->conectar();
        $qry = "CALL sp_asistencial_edit_evolucion_citologia('" . $pPaciente . "','" . $pCAS . "','" . $pConsecutivoDetalle . "',\"" . $pCITFecCitologia . "\",\"" . $pCITLactancia . "\",\"" . $pCITFecUltMestruacion . "\",'" . $pCITGestaciones . "','" . $pCITPartos . "','" . $pCITAbortos . "',\"" . $pCITEmbarazoActual . "\",\"" . $pCITMetodoPlanifica . "\",\"" . $pCITTiempoUso . "\",\"" . $pCITFecUltCitologia . "\",\"" . $pCITResultadoCitologia . "\",\"" . $pCITCauterizacion . "\",\"" . $pCITCauterizacionFec . "\",\"" . $pCITHisterectomia . "\",\"" . $pCITHisterectomiaFec . "\",\"" . $pCITVaporizacion . "\",\"" . $pCITVaporizacionFec . "\",\"" . $pCITConizacion . "\",\"" . $pCITConizacionFec . "\",\"" . $pCITCrioterapia . "\",\"" . $pCITCrioterapiaFec . "\",\"" . $pCITRadioterapia . "\",\"" . $pCITRadioterapiaFec . "\",\"" . $pCITTtoHormonal . "\",\"" . $pCITTtoHormonalFec . "\",\"" . $pCITBiopsia . "\",\"" . $pCITBiopsiaFec . "\",\"" . $pCITColposcopia . "\",\"" . $pCITColposcopiaFec . "\",\"" . $pCITAusente . "\",\"" . $pCITSano . "\",\"" . $pCITAtrofico . "\",\"" . $pCITCongestivo . "\",\"" . $pCITUlcerado . "\",\"" . $pCITPolipo . "\",\"" . $pCITMasa . "\",\"" . $pCITObservacionesToma . "\",\"" . $pCITCalidad1 . "\",\"" . $pCITCalidad2 . "\",\"" . $pCITCalidad3 . "\",\"" . $pCITCalidad4 . "\",\"" . $pCITCausa . "\",\"" . $pCITCategorizacion1 . "\",\"" . $pCITCategorizacion2 . "\",\"" . $pCITMicroorganismos1 . "\",\"" . $pCITMicroorganismos2 . "\",\"" . $pCITMicroorganismos3 . "\",\"" . $pCITMicroorganismos4 . "\",\"" . $pCITMicroorganismos5 . "\",\"" . $pCITMicroorganismos6 . "\",\"" . $pCITOtrosHallazgos1 . "\",\"" . $pCITOtrosHallazgos2 . "\",\"" . $pCITOtrosHallazgos3 . "\",\"" . $pCITOtrosHallazgos4 . "\",\"" . $pCITOtrosHallazgos5 . "\",\"" . $pCITOtrosHallazgos6 . "\",\"" . $pCITAnormalidades1 . "\",\"" . $pCITAnormalidades2 . "\",\"" . $pCITAnormalidades3 . "\",\"" . $pCITAnormalidades4 . "\",\"" . $pCITAnormalidades5 . "\",\"" . $pCITAnormalidades6 . "\",\"" . $pCITAnormalidadesGlandulares1 . "\",\"" . $pCITAnormalidadesGlandulares2 . "\",\"" . $pCITAnormalidadesGlandulares3 . "\",\"" . $pCITAnormalidadesGlandulares4 . "\",\"" . $pCITAnormalidadesGlandulares5 . "\",\"" . $pCITAnormalidadesGlandulares6 . "\",\"" . $pCITAnormalidadesGlandulares7 . "\",\"" . $pCITAnormalidadesGlandulares8 . "\",\"" . $pCITAnormalidadesGlandulares9 . "\",\"" . $pCITAnormalidadesGlandulares10 . "\",\"" . $pCITAnormalidadesGlandulares11 . "\",\"" . $pCITObservacionesRes . "\",\"" . $pCITProflectura . "\",\"" . $pCITNombreLectura . "\",\"" . $pCITRegistroLectura . "\",\"" . $pCITFechaLectura . "\",\"" . $pCITProflectura2 . "\",\"" . $pCITNombreLectura2 . "\",\"" . $pCITRegistroLectura2 . "\",\"" . $pCITFechaLectura2 . "\",\"" . $pCITFechaEntregaRes . "\",'" . $pUsuario . "')";
        if(@mysqli_query($gBaseDatos->ConexionID, $qry)){
            echo "{success: true, requestedId:'1'}";
            $gBaseDatos->cerrar();
        }
    }else{
       echo "{success: true, requestedId:'0'}";
        $gBaseDatos->cerrar();
    }
}
function VerHistorialMedicamentosxPaciente(){
    $pPaciente = isset($_REQUEST['pPaciente'])?$_REQUEST['pPaciente']:0;
    $gBaseDatos = new ofiMySQLi();
    $gBaseDatos->conectar();
    $qry = "CALL sp_grid_medicamentoshc_paciente('" . $pPaciente . "')";
    //echo $qry;
    $gBaseDatos->QryID = @mysqli_query($gBaseDatos->ConexionID, $qry);
    $arr = array();
    while($row = @mysqli_fetch_assoc($gBaseDatos->QryID))
    {
        $nRow = $row;
        foreach($row as $key => $val)
        {
            $nRow[$key] = PonerAcentosHTML($val);
        }
        $arr[] = $nRow;
    }
    $gBaseDatos->liberar();
    $gBaseDatos->cerrar();
    $jsonresult = JEncode($arr);
    if (!is_null($jsonresult))
        echo '({"total":"0","results":'. $jsonresult .'})';
}
