<?php

/*
* @category    Controlador Plantillas HC
* @package     OfiClinic Web
* @author      Jorge Ancizar Galeano Ruiz<desarrollo@ofisalud.com>
* @copyright   2010 Jorge Ancizar Galeano Ruiz
* @version     OfiClinic Web 1.0
* @license     COMERCIAL
* @link        http://www.ofisalud.com
* @country     Colombia
* @telephone   3016398114
*/
ini_set('memory_limit', '-1'); 
header("Content-Type: text/plain; charset=UTF-8");
require("../../../core/php/_database.php");
require("../../../core/php/php_functions.php");
session_start();

$task = '';
if ( isset($_POST['task'])){
  $task = $_POST['task'];
}
switch($task){
    case "ImportarUltimaAtencion":
        ImportarUltimaAtencion();
        break;
    case "ImportarAntecedentesPersonalesOfiClinic001":
        ImportarAntecedentesOfiClinic("PersonalesOfiClinic001");
        break;
    case "ImportarAntecedentesPersonalesOfiClinic002":
        ImportarAntecedentesOfiClinic("PersonalesOfiClinic002");
        break;
    case "ImportarAntecedentesFamiliares":
        ImportarAntecedentes("Familiares");
        break;
    case "ImportarAntecedentesPersonales":
        ImportarAntecedentes("Personales");
        break;
    case "ImportarUltimaFormula":
        ImportarUltimaFormula();
        break;
    case "VerRemSolicitadosxHC_ofimedical":
        VerRemSolicitadosxHC_ofimedical();
        break;
    case "VerMxSolicitadosxHC":
        VerMxSolicitadosxHC_ofimedical();
        break;
    case "VerMxSolicitadosxHC_ofimedical":
        VerMxSolicitadosxHC_ofimedical();
        break;
    case "MX_IPS_BASICA":
        VerMxSolicitadosxHC_ofimedical(); //OJO
        break;
    case "VerExaSolicitadosxHC":
        VerExaSolicitadosxHC_ofimedical();
        break;
    case "VerExaSolicitadosxHC_ofimedical":
        VerExaSolicitadosxHC_ofimedical();
        break;
    case "guardar_tomacitologia":
        GuardarTomaCitologia();
        break;
    case "modificar_tomacitologia":
        ModificarTomaCitologia();
        break;
    case "guardartomasignos":
        GuardarHCTomaSignos();
        break;
    case "modificartomasignos":
        ModificarHCTomaSignos();
        break;
    case "guardar":
        GuardarHC();
        break;
    case "modificar":
        ModificarHC();
        break;
    case "guardar_proc":
        GuardarProc();
        break;
    case "guardar_vacunacion":
        GuardarProc();
        break;
    case "modificar_vacunacion":
        ModificarProc();
        break;
    case "modificar_proc":
        ModificarProc();
        break;
    case "guardar_barthel":
        GuardarBarthelHC();
        break;
    case "guardar_hachinski":
        GuardarHachinskiHC();
        break;
    case "guardar_folstein":
        GuardarFolsteinHC();
        break;
    case "guardar_lawton":
        GuardarLawtonHC();
        break;
    case "guardar_yesavage":
        GuardarYesavageHC();
        break;
    case "VerHistorialxPaciente":
        VerHistorialHCxPaciente();
        break;
    case "VerHistorialxPacienteFiltro":
        VerHistorialHCxPacienteFiltro();
        break;
    case "VerHistorialxPacienteSinEvolucionar":
        VerHistorialHCxPacienteSinEvolucionar();
        break;
    case "crear_resumen_neurodesarrollo":
        CrearResumenNeurodesarrollo();
        break;
    case "ver_resumen_neurodesarrollo":
        VerResumenNeurodesarrollo();
        break;
    case "guardar_resumen_neurodesarrollo":
        GuardarResumenNeurodesarrollo();
        break;
    case "VerHistorialMedicamentosxPaciente":
        VerHistorialMedicamentosxPaciente();
        break;
    case "VerHistorialFormulacionxPaciente":
        VerHistorialFormulacionxPaciente();
        break;
    case "VerHistorialOrdenamientosxPaciente":
        VerHistorialOrdenamientosxPaciente();
        break;
    default:
        echo "{failure:true}";
        break;
}

function VerHistorialOrdenamientosxPaciente(){
    $pEmpresa = isset($_REQUEST['pEmpresa'])?$_REQUEST['pEmpresa']:0;
    $pPaciente = isset($_REQUEST['pPaciente'])?$_REQUEST['pPaciente']:0;
    $gBaseDatos = new ofiMySQLi();
    $gBaseDatos->conectar();
    $qry = "CALL sp_asistencial_ordenamientosxpaciente('" . $pEmpresa . "','" . $pPaciente . "')";
    //echo $qry;
    $gBaseDatos->QryID = @mysqli_query($gBaseDatos->ConexionID, $qry);
    $arr = array();
    while($row = @mysqli_fetch_assoc($gBaseDatos->QryID))
    {
        $nRow = $row;
        foreach($row as $key => $val)
        {
            $nRow[$key] = utf8_decode($val);
        }
        $arr[] = $nRow;
    }
    $gBaseDatos->liberar();
    $gBaseDatos->cerrar();
    $jsonresult = JEncode($arr);
    if (!is_null($jsonresult))
        echo '({"total":"0","results":'. $jsonresult .'})';
}

function VerHistorialFormulacionxPaciente(){
    $pEmpresa = isset($_REQUEST['pEmpresa'])?$_REQUEST['pEmpresa']:0;
    $pPaciente = isset($_REQUEST['pPaciente'])?$_REQUEST['pPaciente']:0;
    $gBaseDatos = new ofiMySQLi();
    $gBaseDatos->conectar();
    $qry = "CALL sp_asistencial_formulacionesxpaciente('" . $pEmpresa . "','" . $pPaciente . "')";
    //echo $qry;
    $gBaseDatos->QryID = @mysqli_query($gBaseDatos->ConexionID, $qry);
    $arr = array();
    while($row = @mysqli_fetch_assoc($gBaseDatos->QryID))
    {
        $nRow = $row;
        foreach($row as $key => $val)
        {
            $nRow[$key] = utf8_decode($val);
        }
        $arr[] = $nRow;
    }
    $gBaseDatos->liberar();
    $gBaseDatos->cerrar();
    $jsonresult = JEncode($arr);
    if (!is_null($jsonresult))
        echo '({"total":"0","results":'. $jsonresult .'})';
}

function ImportarAntecedentesOfiClinic($pTipo){
    $pPaciente = isset($_REQUEST['pPaciente'])?$_REQUEST['pPaciente']:0;
    $pCAS = isset($_REQUEST['pCAS'])?$_REQUEST['pCAS']:0;
    $qry = "";
    switch ($pTipo){
        case "PersonalesOfiClinic001":
            $qry = "CALL sp_oficlinic_load_antecedentespersonales001('" . $pPaciente . "','" . $pCAS . "')";
            break;
        case "PersonalesOfiClinic002":
            $qry = "CALL sp_oficlinic_load_antecedentespersonales003('" . $pPaciente . "','" . $pCAS . "')";
            break;
        default:
            break;
    }
    //echo $qry;
    $gBaseDatos = new ofiMySQLi();
    $gBaseDatos->conectar();
    $resY = str_replace("<BR \/><br \/>","",PonerAcentosHTML($gBaseDatos->jsonSP($qry,"D")));
    $res = str_replace("<br \/>","",$resY);
    $gBaseDatos->liberar();
    $gBaseDatos->cerrar();
    $res1 = str_replace("[", "", $res);
    $res = str_replace("]", "", $res1);
    echo $res;
}

function ImportarUltimaAtencion(){
    $pCAS = isset($_REQUEST['pCAS'])?$_REQUEST['pCAS']:0;
    $pPaciente = isset($_REQUEST['pPaciente'])?$_REQUEST['pPaciente']:0;
    $qry = "";
    $qry = "CALL sp_ofimedical_load_ultimaatencion('" . $pPaciente . "','" . $pCAS . "')";
    //echo $qry;
    $gBaseDatos = new ofiMySQLi();
    $gBaseDatos->conectar();
    $resY = str_replace("<BR \/><br \/>","",PonerAcentosHTML($gBaseDatos->jsonSP($qry,"D")));
    $res = str_replace("<br \/>","",$resY);
    $gBaseDatos->liberar();
    $gBaseDatos->cerrar();
    $res1 = str_replace("[", "", $res);
    $res = str_replace("]", "", $res1);
    echo $res;
}

function ImportarAntecedentes($pTipo){
    $pCAS = isset($_REQUEST['pCAS'])?$_REQUEST['pCAS']:0;
    $pPaciente = isset($_REQUEST['pPaciente'])?$_REQUEST['pPaciente']:0;
    $qry = "";
    switch ($pTipo){
        case "Familiares":
            $qry = "CALL sp_ofimedical_load_antecedentesfamiliares('" . $pPaciente . "','" . $pCAS . "')";
            break;
        case "Personales":
            $qry = "CALL sp_ofimedical_load_antecedentespersonales('" . $pPaciente . "','" . $pCAS . "')";
            break;
        case "PersonalesOfiClinic001":
            $qry = "CALL sp_oficlinic_load_antecedentespersonales('" . $pPaciente . "','" . $pCAS . "')";
            break;
        default:
            break;
    }
    //echo $qry;
    $gBaseDatos = new ofiMySQLi();
    $gBaseDatos->conectar();
    $resY = str_replace("<BR \/><br \/>","",PonerAcentosHTML($gBaseDatos->jsonSP($qry,"D")));
    $res = str_replace("<br \/>","",$resY);
    $gBaseDatos->liberar();
    $gBaseDatos->cerrar();
    $res1 = str_replace("[", "", $res);
    $res = str_replace("]", "", $res1);
    echo $res;
}

function ImportarUltimaFormula(){
    $pPaciente = isset($_REQUEST['pPaciente'])?$_REQUEST['pPaciente']:0;
    $pCAS = isset($_REQUEST['pCAS'])?$_REQUEST['pCAS']:0;
    $pUsuario = isset($_REQUEST['pUsuario'])?$_REQUEST['pUsuario']:0;
    $gBaseDatos = new ofiMySQLi();
    $gBaseDatos->conectar();
    $qry = "CALL sp_asistencial_formula_loadlast('" . $pPaciente . "','" . $pCAS . "','" . $pUsuario . "')";
    echo $gBaseDatos->jasonSP_arreglo($qry);
    $gBaseDatos->liberar();
    $gBaseDatos->cerrar();
}

function VerRemSolicitadosxHC_ofimedical(){
    $pEmpresa = isset($_REQUEST['pEmpresa'])?$_REQUEST['pEmpresa']:0;
    $pIPS = isset($_REQUEST['pIPS'])?$_REQUEST['pIPS']:0;
    $pPaciente = isset($_REQUEST['pPaciente'])?$_REQUEST['pPaciente']:0;
    $pCAS = isset($_REQUEST['pCAS'])?$_REQUEST['pCAS']:0;
    $pConsecutivoDetalle = isset($_REQUEST['pConsecutivoDetalle'])?$_REQUEST['pConsecutivoDetalle']:0;
    //$pDesde = isset($_REQUEST['pDesde'])?$_REQUEST['pDesde']:null;
    //$pHasta = isset($_REQUEST['pHasta'])?$_REQUEST['pHasta']:null;
    //if ($pDesde == "" || $pDesde == null)
    //    $pFiltroFec = "N";
    //else
    //    $pFiltroFec = "S";
    $gBaseDatos = new ofiMySQLi();
    $gBaseDatos->conectar();
    if($pConsecutivoDetalle != 0){
        $qry = "CALL sp_asistencial_hc_serviciossolicitados_ofimedical002(\"R\",'" . $pEmpresa . "','" . $pIPS . "','" . $pPaciente . "','" . $pCAS . "','" . $pConsecutivoDetalle . "')";
    }else{
        $qry = "CALL sp_asistencial_hc_serviciossolicitados_ofimedical(\"R\",'" . $pEmpresa . "','" . $pIPS . "','" . $pPaciente . "','" . $pCAS . "')";
    }
    //echo $qry;
    @mysqli_query("\"SET NAMES UTF8\"");
    $gBaseDatos->QryID = @mysqli_query($gBaseDatos->ConexionID, $qry);
    $arr = array();
    while($row = @mysqli_fetch_assoc($gBaseDatos->QryID))
    {
        $nRow = $row;
        foreach($row as $key => $val)
        {
            $nRow[$key] = utf8_decode($val);
        }
        $arr[] = $nRow;
    }
    $gBaseDatos->liberar();
    $gBaseDatos->cerrar();
    $jsonresult = JEncode($arr);
    if (!is_null($jsonresult))
        echo '({"total":"0","results":'. $jsonresult .'})';
}

function VerExaSolicitadosxHC_ofimedical(){
    $pEmpresa = isset($_REQUEST['pEmpresa'])?$_REQUEST['pEmpresa']:0;
    $pIPS = isset($_REQUEST['pIPS'])?$_REQUEST['pIPS']:0;
    $pPaciente = isset($_REQUEST['pPaciente'])?$_REQUEST['pPaciente']:0;
    $pCAS = isset($_REQUEST['pCAS'])?$_REQUEST['pCAS']:0;
    $pConsecutivoDetalle = isset($_REQUEST['pConsecutivoDetalle'])?$_REQUEST['pConsecutivoDetalle']:0;
    //$pDesde = isset($_REQUEST['pDesde'])?$_REQUEST['pDesde']:null;
    //$pHasta = isset($_REQUEST['pHasta'])?$_REQUEST['pHasta']:null;
    //if ($pDesde == "" || $pDesde == null)
    //    $pFiltroFec = "N";
    //else
    //    $pFiltroFec = "S";
    $gBaseDatos = new ofiMySQLi();
    $gBaseDatos->conectar();
    if($pConsecutivoDetalle != 0){
        $qry = "CALL sp_asistencial_hc_serviciossolicitados_ofimedical002(\"E\",'" . $pEmpresa . "','" . $pIPS . "','" . $pPaciente . "','" . $pCAS . "','" . $pConsecutivoDetalle . "')";
    }else{
        $qry = "CALL sp_asistencial_hc_serviciossolicitados_ofimedical(\"E\",'" . $pEmpresa . "','" . $pIPS . "','" . $pPaciente . "','" . $pCAS . "')";
    }
    //echo $qry;
    @mysqli_query("\"SET NAMES UTF8\"");
    $gBaseDatos->QryID = @mysqli_query($gBaseDatos->ConexionID, $qry);
    $arr = array();
    while($row = @mysqli_fetch_assoc($gBaseDatos->QryID))
    {
        $nRow = $row;
        foreach($row as $key => $val)
        {
            $nRow[$key] = utf8_decode($val);
        }
        $arr[] = $nRow;
    }
    $gBaseDatos->liberar();
    $gBaseDatos->cerrar();
    $jsonresult = JEncode($arr);
    if (!is_null($jsonresult))
        echo '({"total":"0","results":'. $jsonresult .'})';
}

function VerMxSolicitadosxHC_ofimedical(){
    $pEmpresa = isset($_REQUEST['pEmpresa'])?$_REQUEST['pEmpresa']:0;
    $pIPS = isset($_REQUEST['pIPS'])?$_REQUEST['pIPS']:0;
    $pPaciente = isset($_REQUEST['pPaciente'])?$_REQUEST['pPaciente']:0;
    $pCAS = isset($_REQUEST['pCAS'])?$_REQUEST['pCAS']:0;
    $pConsecutivoDetalle = isset($_REQUEST['pConsecutivoDetalle'])?$_REQUEST['pConsecutivoDetalle']:0;
    //$pDesde = isset($_REQUEST['pDesde'])?$_REQUEST['pDesde']:null;
    //$pHasta = isset($_REQUEST['pHasta'])?$_REQUEST['pHasta']:null;
    //if ($pDesde == "" || $pDesde == null)
    //    $pFiltroFec = "N";
    //else
    //    $pFiltroFec = "S";
    $gBaseDatos = new ofiMySQLi();
    $gBaseDatos->conectar();
    if($pConsecutivoDetalle != 0){
        $qry = "CALL sp_asistencial_hc_serviciossolicitados_ofimedical002(\"M\",'" . $pEmpresa . "','" . $pIPS . "','" . $pPaciente . "','" . $pCAS . "','" . $pConsecutivoDetalle . "')";
    }else{
        $qry = "CALL sp_asistencial_hc_serviciossolicitados_ofimedical(\"M\",'" . $pEmpresa . "','" . $pIPS . "','" . $pPaciente . "','" . $pCAS . "')";
    }
    //echo $qry;
    @mysqli_query("\"SET NAMES UTF8\"");
    $gBaseDatos->QryID = @mysqli_query($gBaseDatos->ConexionID, $qry);
    $arr = array();
    while($row = @mysqli_fetch_assoc($gBaseDatos->QryID))
    {
        $nRow = $row;
        foreach($row as $key => $val)
        {
            $nRow[$key] = utf8_decode($val);
        }
        $arr[] = $nRow;
    }
    $gBaseDatos->liberar();
    $gBaseDatos->cerrar();
    $jsonresult = JEncode($arr);
    if (!is_null($jsonresult))
        echo '({"total":"0","results":'. $jsonresult .'})';
}

function GuardarResumenNeurodesarrollo(){

    $estructura = explode("¬", $_REQUEST['CAMPOS']);
    $pProceso = isset($_REQUEST['pProceso'])?$_REQUEST['pProceso']:"NA";
    $qry = "CALL sp_neurodesa_resumenhc_update(\"" . $pProceso . "\"," . spParametros($estructura,"NO") . ")";
    //echo $qry;
    $gBaseDatos = new ofiMySQLi();
    $gBaseDatos->conectar();
    if(@mysqli_query($gBaseDatos->ConexionID, $qry))
        echo "{success: true, requestedId:'1'}";
    else
       echo "{success: true, requestedId:'0'}";
    $gBaseDatos->cerrar();   
}

function VerResumenNeurodesarrollo(){
    $pEmpresa = isset($_REQUEST['pEmpresa'])?$_REQUEST['pEmpresa']:0;
    $pIPS = isset($_REQUEST['pIPS'])?$_REQUEST['pIPS']:0;
    $pPaciente = isset($_REQUEST['pPaciente'])?$_REQUEST['pPaciente']:0;
    $gBaseDatos = new ofiMySQLi();
    $gBaseDatos->conectar();
    $qry = "CALL sp_neurodesa_resumenhc_listar('" . $pEmpresa . "','" . $pIPS . "','" . $pPaciente . "')";
    //echo $qry;
    $gBaseDatos->QryID = @mysqli_query($gBaseDatos->ConexionID, $qry);
    $arr = array();
    while($row = @mysqli_fetch_assoc($gBaseDatos->QryID))
    {
        $nRow = $row;
        foreach($row as $key => $val)
        {
            $nRow[$key] = utf8_decode(str_replace("\n\n", "\n",preg_replace('/\<br(\s*)?\/?\>/i', "\n",$val)));
        }
        $arr[] = $nRow;
    }
    $gBaseDatos->liberar();
    $gBaseDatos->cerrar();
    $jsonresult = JEncode($arr);
    if (!is_null($jsonresult))
        echo '({"total":"0","results":'. $jsonresult .'})';
}

function CrearResumenNeurodesarrollo(){
    $pEmpresa = isset($_REQUEST['pEmpresa'])?$_REQUEST['pEmpresa']:0;
    $pIPS = isset($_REQUEST['pIPS'])?$_REQUEST['pIPS']:0;
    $pPaciente = isset($_REQUEST['pPaciente'])?$_REQUEST['pPaciente']:0;
    $pCliente = isset($_REQUEST['pCliente'])?$_REQUEST['pCliente']:0;
    $pAno = isset($_REQUEST['pAno'])?$_REQUEST['pAno']:0;
    $pMes = isset($_REQUEST['pMes'])?$_REQUEST['pMes']:0;
    $gBaseDatos = new ofiMySQLi();
    $gBaseDatos->conectar();
    $qry = "CALL sp_neurodesa_resumenhc_crear('" . $pEmpresa . "','" . $pIPS . "','" . $pPaciente . "','" . $pCliente . "','" . $pAno . "',\"" . $pMes . "\")";
    //echo $qry;
    if(@mysqli_query($gBaseDatos->ConexionID, $qry))
        echo "{success: true, requestedId:'1'}";
    else
       echo "{success: true, requestedId:'0'}";
    $gBaseDatos->cerrar();   
}

function VerHistorialHCxPacienteSinEvolucionar(){
    $pEmpresa = isset($_REQUEST['pEmpresa'])?$_REQUEST['pEmpresa']:0;
    $pIPS = isset($_REQUEST['pIPS'])?$_REQUEST['pIPS']:0;
    $pPaciente = isset($_REQUEST['pPaciente'])?$_REQUEST['pPaciente']:0;
    $pProfesional = isset($_REQUEST['pProfesional'])?$_REQUEST['pProfesional']:0;
    $pDesde = isset($_REQUEST['pDesde'])?$_REQUEST['pDesde']:null;
    $pHasta = isset($_REQUEST['pHasta'])?$_REQUEST['pHasta']:null;
    if ($pDesde == "" || $pDesde == null)
        $pFiltroFec = "N";
    else
        $pFiltroFec = "S";
    $gBaseDatos = new ofiMySQLi();
    $gBaseDatos->conectar();
    $qry = "CALL sp_pacientes_hc_sinevolucionar('" . $pEmpresa . "','" . $pIPS . "','" . $pPaciente . "','" . $pProfesional . "')";
    //echo $qry;
    @mysqli_query("\"SET NAMES UTF8\"");
    $gBaseDatos->QryID = @mysqli_query($gBaseDatos->ConexionID, $qry);
    $arr = array();
    while($row = @mysqli_fetch_assoc($gBaseDatos->QryID))
    {
        $nRow = $row;
        foreach($row as $key => $val)
        {
            $nRow[$key] = utf8_decode($val);
        }
        $arr[] = $nRow;
    }
    $gBaseDatos->liberar();
    $gBaseDatos->cerrar();
    $jsonresult = JEncode($arr);
    if (!is_null($jsonresult))
        echo '({"total":"0","results":'. $jsonresult .'})';
}

function VerHistorialHCxPacienteFiltro(){
    $pEmpresa = isset($_REQUEST['pEmpresa'])?$_REQUEST['pEmpresa']:0;
    $pPaciente = isset($_REQUEST['pPaciente'])?$_REQUEST['pPaciente']:0;
    $pProfesional = isset($_REQUEST['pProfesional'])?$_REQUEST['pProfesional']:0;
    $pDesde = isset($_REQUEST['pDesde'])?$_REQUEST['pDesde']:null;
    $pHasta = isset($_REQUEST['pHasta'])?$_REQUEST['pHasta']:null;
    if ($pDesde == "" || $pDesde == null)
        $pFiltroFec = "N";
    else
        $pFiltroFec = "S";
    $gBaseDatos = new ofiMySQLi();
    $gBaseDatos->conectar();
    $qry = "CALL sp_asistencial_evolucionesxpaciente_filtro('" . $pEmpresa . "','" . $pPaciente . "','" . $pProfesional . "',\"" . $pDesde . "\",\"" . $pHasta . "\",\"" . $pFiltroFec . "\")";
    //echo $qry;
    $gBaseDatos->QryID = @mysqli_query($gBaseDatos->ConexionID, $qry);
    $arr = array();
    while($row = @mysqli_fetch_assoc($gBaseDatos->QryID))
    {
        $nRow = $row;
        foreach($row as $key => $val)
        {
            $nRow[$key] = utf8_decode($val);
        }
        $arr[] = $nRow;
    }
    $gBaseDatos->liberar();
    $gBaseDatos->cerrar();
    $jsonresult = JEncode($arr);
    if (!is_null($jsonresult))
        echo '({"total":"0","results":'. $jsonresult .'})';
}
        
function VerHistorialHCxPaciente(){
    $pEmpresa = isset($_REQUEST['pEmpresa'])?$_REQUEST['pEmpresa']:0;
    $pPaciente = isset($_REQUEST['pPaciente'])?$_REQUEST['pPaciente']:0;
    $gBaseDatos = new ofiMySQLi();
    $gBaseDatos->conectar();
    $qry = "CALL sp_asistencial_evolucionesxpaciente('" . $pEmpresa . "','" . $pPaciente . "')";
    //echo $qry;
    $gBaseDatos->QryID = @mysqli_query($gBaseDatos->ConexionID, $qry);
    $arr = array();
    while($row = @mysqli_fetch_assoc($gBaseDatos->QryID))
    {
        $nRow = $row;
        foreach($row as $key => $val)
        {
            $nRow[$key] = utf8_decode($val);
        }
        $arr[] = $nRow;
    }
    $gBaseDatos->liberar();
    $gBaseDatos->cerrar();
    $jsonresult = JEncode($arr);
    if (!is_null($jsonresult))
        echo '({"total":"0","results":'. $jsonresult .'})';
}

function GuardarHCTomaSignos()
{
    $pEmpresa = isset($_REQUEST['pEmpresa'])?$_REQUEST['pEmpresa']:0;
    $pIPS = isset($_REQUEST['pIPS'])?$_REQUEST['pIPS']:0;
    $pPaciente = isset($_REQUEST['pPaciente'])?$_REQUEST['pPaciente']:0;
    //$pProfesional = isset($_REQUEST['pProfesional'])?$_REQUEST['pProfesional']:0;
    $pProfesional = $_SESSION['ID_PROFESIONAL_HC'];
    $pCAS = isset($_REQUEST['pCAS'])?$_REQUEST['pCAS']:0;
    $pConsecutivoDetalle = isset($_REQUEST['pConsecutivoDetalle'])?$_REQUEST['pConsecutivoDetalle']:0;
    $pidPlantillaHC = isset($_REQUEST['pidPlantillaHC'])?$_REQUEST['pidPlantillaHC']:0;
    $pFechaAtencion = isset($_REQUEST['pFechaAtencion'])?$_REQUEST['pFechaAtencion']:null;
    $pHoraApertura = isset($_REQUEST['pHoraApertura'])?$_REQUEST['pHoraApertura']:null;
    $pActividad = isset($_REQUEST['pActividad'])?$_REQUEST['pActividad']:null;
    $pPlantilla = isset($_REQUEST['pPlantilla'])?$_REQUEST['pPlantilla']:null;
    $pRutaRptHC = isset($_REQUEST['pRutaRptHC'])?$_REQUEST['pRutaRptHC']:null;
    $pRutaRptMx = isset($_REQUEST['pRutaRptMx'])?$_REQUEST['pRutaRptMx']:null;
    $pRutaRptExa = isset($_REQUEST['pRutaRptExa'])?$_REQUEST['pRutaRptExa']:null;
    $pRutaRptRem = isset($_REQUEST['pRutaRptRem'])?$_REQUEST['pRutaRptRem']:null;
    $contenido = isset($_REQUEST['CAMPOS'])?$_REQUEST['CAMPOS']:null;
    $pEvolucion = stripslashes(utf8_encode(str_replace('"', '""',nl2br($contenido))));
    $pDiagppal = isset($_REQUEST['pDiagppal'])?$_REQUEST['pDiagppal']:null;
    $pDiagrel1 = isset($_REQUEST['pDiagrel1'])?$_REQUEST['pDiagrel1']:null;
    $pDiagrel2 = isset($_REQUEST['pDiagrel2'])?$_REQUEST['pDiagrel2']:null;
    $pDiagrel3 = isset($_REQUEST['pDiagrel3'])?$_REQUEST['pDiagrel3']:null;
    $pTipodiag = isset($_REQUEST['pTipodiag'])?$_REQUEST['pTipodiag']:null;
    $pFinalidad = isset($_REQUEST['pFinalidad'])?$_REQUEST['pFinalidad']:null;
    $pCausa = isset($_REQUEST['pCausa'])?$_REQUEST['pCausa']:null;
    $pAmbito = isset($_REQUEST['pAmbito'])?$_REQUEST['pAmbito']:null;
    $pFinalidadProced = isset($_REQUEST['pFinalidadProced'])?$_REQUEST['pFinalidadProced']:null;
    $pPersonalAtiende = isset($_REQUEST['pPersonalAtiende'])?$_REQUEST['pPersonalAtiende']:null;
    $pFormaActo = isset($_REQUEST['pFormaActo'])?$_REQUEST['pFormaActo']:null;
    $pUsuario = isset($_REQUEST['pUsuario'])?$_REQUEST['pUsuario']:0;
    $pIdCliente = isset($_REQUEST['pIdCliente'])?$_REQUEST['pIdCliente']:0;
    $pIdPlan = isset($_REQUEST['pIdPlan'])?$_REQUEST['pIdPlan']:0;
    $pIdSubPlan = isset($_REQUEST['pIdSubPlan'])?$_REQUEST['pIdSubPlan']:0;
    $pIdContrato = isset($_REQUEST['pIdContrato'])?$_REQUEST['pIdContrato']:0;
    $pAutorizacion = isset($_REQUEST['pAutorizacion'])?$_REQUEST['pAutorizacion']:null;
    if($pAutorizacion == null || $pAutorizacion == ""){
        $pAutorizacion = "NA";
    }
    $pCambiaCliente = isset($_REQUEST['pCambiaCliente'])?$_REQUEST['pCambiaCliente']:"NA";
    $pGuardarSignos = isset($_REQUEST['pGuardarSignos'])?$_REQUEST['pGuardarSignos']:"NO";
    $pTalla = isset($_REQUEST['pTalla'])?$_REQUEST['pTalla']:null;
    $pPeso = isset($_REQUEST['pPeso'])?$_REQUEST['pPeso']:null;
    $pIMC = isset($_REQUEST['pIMC'])?$_REQUEST['pIMC']:null;
    $pIMCClasifica = isset($_REQUEST['pIMCClasifica'])?$_REQUEST['pIMCClasifica']:null;
    $pTE = isset($_REQUEST['pTE'])?$_REQUEST['pTE']:null;
    $pPerimetroCefalico = isset($_REQUEST['pPerimetroCefalico'])?$_REQUEST['pPerimetroCefalico']:null;
    $pPerimetroToraxico = isset($_REQUEST['pPerimetroToraxico'])?$_REQUEST['pPerimetroToraxico']:null;
    $pTASIS = isset($_REQUEST['pTASIS'])?$_REQUEST['pTASIS']:null;
    $pTADIAS = isset($_REQUEST['pTADIAS'])?$_REQUEST['pTADIAS']:null;
    $pAnios = isset($_REQUEST['pAnios'])?$_REQUEST['pAnios']:null;
    $pMeses = isset($_REQUEST['pMeses'])?$_REQUEST['pMeses']:null;
    
    $gBaseDatos = new ofiMySQLi();
    $gBaseDatos->conectar();
    $qry = "CALL sp_asistencial_add_evolucion_tomasignos('" . $pEmpresa . "','" . $pIPS . "','" . $pPaciente . "','" . $pProfesional . "','" . $pCAS . "','" . $pConsecutivoDetalle . "','" . $pidPlantillaHC . "',\"" . $pFechaAtencion . "\",\"" . $pHoraApertura . "\",\"" . $pActividad . "\",\"" . $pPlantilla . "\",\"" . $pRutaRptHC . "\",\"" . $pRutaRptMx . "\",\"" . $pRutaRptExa . "\",\"" . $pRutaRptRem . "\",\"" . $pEvolucion . "\",\"" . $pDiagppal . "\",\"" . $pDiagrel1 . "\",\"" . $pDiagrel2 . "\",\"" . $pDiagrel3 . "\",\"" . $pTipodiag . "\",\"" . $pFinalidad . "\",\"" . $pCausa . "\",\"" . $pAmbito . "\",\"" . $pFinalidadProced . "\",\"" . $pPersonalAtiende . "\",\"" . $pFormaActo . "\",'" . $pUsuario . "','" . $pIdCliente . "','" . $pIdPlan . "','" . $pIdSubPlan . "','" . $pIdContrato . "',\"" . $pAutorizacion . "\",\"" . $pCambiaCliente . "\")";
    //echo $qry;
    if(@mysqli_query($gBaseDatos->ConexionID, $qry)){
        $gBaseDatos->cerrar();
        if($pGuardarSignos == "SI"){
            $gBaseDatos = new ofiMySQLi();
            $gBaseDatos->conectar();
            $qry = "CALL sp_asistencial_add_tomasignos('" . $pEmpresa . "','" . $pIPS . "','" . $pPaciente . "','" . $pProfesional . "',\"" . $pFechaAtencion . "\",'" . $pCAS . "','" . $pAnios . "','" . $pMeses . "','" . $pTalla . "','" . $pPeso . "','" . $pIMC . "',\"" . $pIMCClasifica . "\",'" . $pTE . "','" . $pPerimetroCefalico . "','" . $pPerimetroToraxico . "','" . $pTASIS . "','" . $pTADIAS . "')";
            @mysqli_query($gBaseDatos->ConexionID, $qry);
            $gBaseDatos->cerrar();
        }
        echo "{success: true, requestedId:'1'}";
    }else{
       echo "{success: true, requestedId:'0'}";
       $gBaseDatos->cerrar();   
    }
    
}

function ModificarHCTomaSignos()
{
    $pEmpresa = isset($_REQUEST['pEmpresa'])?$_REQUEST['pEmpresa']:0;
    $pIPS = isset($_REQUEST['pIPS'])?$_REQUEST['pIPS']:0;
    $pPaciente = isset($_REQUEST['pPaciente'])?$_REQUEST['pPaciente']:0;
    //$pProfesional = isset($_REQUEST['pProfesional'])?$_REQUEST['pProfesional']:0;
    $pProfesional = $_SESSION['ID_PROFESIONAL_HC'];
    $pCAS = isset($_REQUEST['pCAS'])?$_REQUEST['pCAS']:0;
    $pConsecutivoDetalle = isset($_REQUEST['pConsecutivoDetalle'])?$_REQUEST['pConsecutivoDetalle']:0;
    $pFechaAtencion = isset($_REQUEST['pFechaAtencion'])?$_REQUEST['pFechaAtencion']:null;
    $pHoraApertura = isset($_REQUEST['pHoraApertura'])?$_REQUEST['pHoraApertura']:null;
    $pActividad = isset($_REQUEST['pActividad'])?$_REQUEST['pActividad']:null;
    $pPlantilla = isset($_REQUEST['pPlantilla'])?$_REQUEST['pPlantilla']:null;
    $pRutaRptHC = isset($_REQUEST['pRutaRptHC'])?$_REQUEST['pRutaRptHC']:null;
    $pRutaRptMx = isset($_REQUEST['pRutaRptMx'])?$_REQUEST['pRutaRptMx']:null;
    $pRutaRptExa = isset($_REQUEST['pRutaRptExa'])?$_REQUEST['pRutaRptExa']:null;
    $pRutaRptRem = isset($_REQUEST['pRutaRptRem'])?$_REQUEST['pRutaRptRem']:null;
    $contenido = isset($_REQUEST['CAMPOS'])?$_REQUEST['CAMPOS']:null;
    $pEvolucion = stripslashes(utf8_encode(str_replace('"', '""',nl2br($contenido))));
    $pDiagppal = isset($_REQUEST['pDiagppal'])?$_REQUEST['pDiagppal']:null;
    $pDiagrel1 = isset($_REQUEST['pDiagrel1'])?$_REQUEST['pDiagrel1']:null;
    $pDiagrel2 = isset($_REQUEST['pDiagrel2'])?$_REQUEST['pDiagrel2']:null;
    $pDiagrel3 = isset($_REQUEST['pDiagrel3'])?$_REQUEST['pDiagrel3']:null;
    $pTipodiag = isset($_REQUEST['pTipodiag'])?$_REQUEST['pTipodiag']:null;
    $pFinalidad = isset($_REQUEST['pFinalidad'])?$_REQUEST['pFinalidad']:null;
    $pCausa = isset($_REQUEST['pCausa'])?$_REQUEST['pCausa']:null;
    $pAmbito = isset($_REQUEST['pAmbito'])?$_REQUEST['pAmbito']:null;
    $pFinalidadProced = isset($_REQUEST['pFinalidadProced'])?$_REQUEST['pFinalidadProced']:null;
    $pPersonalAtiende = isset($_REQUEST['pPersonalAtiende'])?$_REQUEST['pPersonalAtiende']:null;
    $pFormaActo = isset($_REQUEST['pFormaActo'])?$_REQUEST['pFormaActo']:null;
    $pUsuario = isset($_REQUEST['pUsuario'])?$_REQUEST['pUsuario']:0;
    $pIdCliente = isset($_REQUEST['pIdCliente'])?$_REQUEST['pIdCliente']:0;
    $pIdPlan = isset($_REQUEST['pIdPlan'])?$_REQUEST['pIdPlan']:0;
    $pIdSubPlan = isset($_REQUEST['pIdSubPlan'])?$_REQUEST['pIdSubPlan']:0;
    $pIdContrato = isset($_REQUEST['pIdContrato'])?$_REQUEST['pIdContrato']:0;
    $pAutorizacion = isset($_REQUEST['pAutorizacion'])?$_REQUEST['pAutorizacion']:null;
    if($pAutorizacion == null || $pAutorizacion == ""){
        $pAutorizacion = "NA";
    }
    $pCambiaCliente = isset($_REQUEST['pCambiaCliente'])?$_REQUEST['pCambiaCliente']:"NA";
    $pGuardarSignos = isset($_REQUEST['pGuardarSignos'])?$_REQUEST['pGuardarSignos']:"NO";
    $pTalla = isset($_REQUEST['pTalla'])?$_REQUEST['pTalla']:null;
    $pPeso = isset($_REQUEST['pPeso'])?$_REQUEST['pPeso']:null;
    $pIMC = isset($_REQUEST['pIMC'])?$_REQUEST['pIMC']:null;
    $pIMCClasifica = isset($_REQUEST['pIMCClasifica'])?$_REQUEST['pIMCClasifica']:null;
    $pTE = isset($_REQUEST['pTE'])?$_REQUEST['pTE']:null;
    $pPerimetroCefalico = isset($_REQUEST['pPerimetroCefalico'])?$_REQUEST['pPerimetroCefalico']:null;
    $pPerimetroToraxico = isset($_REQUEST['pPerimetroToraxico'])?$_REQUEST['pPerimetroToraxico']:null;
    $pTASIS = isset($_REQUEST['pTASIS'])?$_REQUEST['pTASIS']:null;
    $pTADIAS = isset($_REQUEST['pTADIAS'])?$_REQUEST['pTADIAS']:null;
    $pAnios = isset($_REQUEST['pAnios'])?$_REQUEST['pAnios']:null;
    $pMeses = isset($_REQUEST['pMeses'])?$_REQUEST['pMeses']:null;
    $gBaseDatos = new ofiMySQLi();
    $gBaseDatos->conectar();
    $qry = "CALL sp_asistencial_edit_evolucion_tomasignos('" . $pEmpresa . "','" . $pIPS . "','" . $pPaciente . "','" . $pProfesional . "','" . $pCAS . "','" . $pConsecutivoDetalle . "',\"" . $pFechaAtencion . "\",\"" . $pHoraApertura . "\",\"" . $pActividad . "\",\"" . $pPlantilla . "\",\"" . $pEvolucion . "\",\"" . $pDiagppal . "\",\"" . $pDiagrel1 . "\",\"" . $pDiagrel2 . "\",\"" . $pDiagrel3 . "\",\"" . $pTipodiag . "\",\"" . $pFinalidad . "\",\"" . $pCausa . "\",\"" . $pAmbito . "\",\"" . $pFinalidadProced . "\",\"" . $pPersonalAtiende . "\",\"" . $pFormaActo . "\",'" . $pUsuario . "','" . $pIdCliente . "','" . $pIdPlan . "','" . $pIdSubPlan . "','" . $pIdContrato . "',\"" . $pAutorizacion . "\",\"" . $pCambiaCliente . "\")";
    //echo $qry;
    if(@mysqli_query($gBaseDatos->ConexionID, $qry)){
        $gBaseDatos->cerrar();
        if($pGuardarSignos == "SI"){
            $gBaseDatos = new ofiMySQLi();
            $gBaseDatos->conectar();
            $qry = "CALL sp_asistencial_edit_tomasignos('" . $pEmpresa . "','" . $pIPS . "','" . $pPaciente . "','" . $pProfesional . "',\"" . $pFechaAtencion . "\",'" . $pCAS . "','" . $pAnios . "','" . $pMeses . "','" . $pTalla . "','" . $pPeso . "','" . $pIMC . "',\"" . $pIMCClasifica . "\",'" . $pTE . "','" . $pPerimetroCefalico . "','" . $pPerimetroToraxico . "','" . $pTASIS . "','" . $pTADIAS . "')";
            @mysqli_query($gBaseDatos->ConexionID, $qry);
            $gBaseDatos->cerrar();
        }
        echo "{success: true, requestedId:'1'}";
    }else{
       echo "{success: true, requestedId:'0'}";
        $gBaseDatos->cerrar();
    }
}

function GuardarHC()
{
    $pEmpresa = isset($_REQUEST['pEmpresa'])?$_REQUEST['pEmpresa']:0;
    $pIPS = isset($_REQUEST['pIPS'])?$_REQUEST['pIPS']:0;
    $pPaciente = isset($_REQUEST['pPaciente'])?$_REQUEST['pPaciente']:0;
    //$pProfesional = isset($_REQUEST['pProfesional'])?$_REQUEST['pProfesional']:0;
    $pProfesional = $_SESSION['ID_PROFESIONAL_HC'];
    $pCAS = isset($_REQUEST['pCAS'])?$_REQUEST['pCAS']:0;
    $pConsecutivoDetalle = isset($_REQUEST['pConsecutivoDetalle'])?$_REQUEST['pConsecutivoDetalle']:0;
    $pidPlantillaHC = isset($_REQUEST['pidPlantillaHC'])?$_REQUEST['pidPlantillaHC']:0;
    $pFechaAtencion = isset($_REQUEST['pFechaAtencion'])?$_REQUEST['pFechaAtencion']:null;
    $pHoraApertura = isset($_REQUEST['pHoraApertura'])?$_REQUEST['pHoraApertura']:null;
    $pActividad = isset($_REQUEST['pActividad'])?$_REQUEST['pActividad']:null;
    $pPlantilla = isset($_REQUEST['pPlantilla'])?$_REQUEST['pPlantilla']:null;
    $pRutaRptHC = isset($_REQUEST['pRutaRptHC'])?$_REQUEST['pRutaRptHC']:null;
    $pRutaRptMx = isset($_REQUEST['pRutaRptMx'])?$_REQUEST['pRutaRptMx']:null;
    $pRutaRptExa = isset($_REQUEST['pRutaRptExa'])?$_REQUEST['pRutaRptExa']:null;
    $pRutaRptRem = isset($_REQUEST['pRutaRptRem'])?$_REQUEST['pRutaRptRem']:null;
    $contenido = isset($_REQUEST['CAMPOS'])?$_REQUEST['CAMPOS']:null;
    $pEvolucion = stripslashes(utf8_encode(str_replace('"', '""',nl2br($contenido))));
    $pDiagppal = isset($_REQUEST['pDiagppal'])?$_REQUEST['pDiagppal']:null;
    $pDiagrel1 = isset($_REQUEST['pDiagrel1'])?$_REQUEST['pDiagrel1']:null;
    $pDiagrel2 = isset($_REQUEST['pDiagrel2'])?$_REQUEST['pDiagrel2']:null;
    $pDiagrel3 = isset($_REQUEST['pDiagrel3'])?$_REQUEST['pDiagrel3']:null;
    $pTipodiag = isset($_REQUEST['pTipodiag'])?$_REQUEST['pTipodiag']:null;
    $pFinalidad = isset($_REQUEST['pFinalidad'])?$_REQUEST['pFinalidad']:null;
    $pCausa = isset($_REQUEST['pCausa'])?$_REQUEST['pCausa']:null;
    $pAmbito = isset($_REQUEST['pAmbito'])?$_REQUEST['pAmbito']:null;
    $pFinalidadProced = isset($_REQUEST['pFinalidadProced'])?$_REQUEST['pFinalidadProced']:null;
    $pPersonalAtiende = isset($_REQUEST['pPersonalAtiende'])?$_REQUEST['pPersonalAtiende']:null;
    $pFormaActo = isset($_REQUEST['pFormaActo'])?$_REQUEST['pFormaActo']:null;
    $pUsuario = isset($_REQUEST['pUsuario'])?$_REQUEST['pUsuario']:0;
    $pIdCliente = isset($_REQUEST['pIdCliente'])?$_REQUEST['pIdCliente']:0;
    $pIdPlan = isset($_REQUEST['pIdPlan'])?$_REQUEST['pIdPlan']:0;
    $pIdSubPlan = isset($_REQUEST['pIdSubPlan'])?$_REQUEST['pIdSubPlan']:0;
    $pIdContrato = isset($_REQUEST['pIdContrato'])?$_REQUEST['pIdContrato']:0;
    $pAutorizacion = isset($_REQUEST['pAutorizacion'])?$_REQUEST['pAutorizacion']:null;
    if($pAutorizacion == null || $pAutorizacion == ""){
        $pAutorizacion = "NA";
    }
    $pCambiaCliente = isset($_REQUEST['pCambiaCliente'])?$_REQUEST['pCambiaCliente']:"NA";
    $pGuardarSignos = isset($_REQUEST['pGuardarSignos'])?$_REQUEST['pGuardarSignos']:"NO";
    $pTalla = isset($_REQUEST['pTalla'])?$_REQUEST['pTalla']:null;
    $pPeso = isset($_REQUEST['pPeso'])?$_REQUEST['pPeso']:null;
    $pIMC = isset($_REQUEST['pIMC'])?$_REQUEST['pIMC']:null;
    $pIMCClasifica = isset($_REQUEST['pIMCClasifica'])?$_REQUEST['pIMCClasifica']:null;
    $pTE = isset($_REQUEST['pTE'])?$_REQUEST['pTE']:null;
    $pPerimetroCefalico = isset($_REQUEST['pPerimetroCefalico'])?$_REQUEST['pPerimetroCefalico']:null;
    $pPerimetroToraxico = isset($_REQUEST['pPerimetroToraxico'])?$_REQUEST['pPerimetroToraxico']:null;
    $pTASIS = isset($_REQUEST['pTASIS'])?$_REQUEST['pTASIS']:null;
    $pTADIAS = isset($_REQUEST['pTADIAS'])?$_REQUEST['pTADIAS']:null;
    $pAnios = isset($_REQUEST['pAnios'])?$_REQUEST['pAnios']:null;
    $pMeses = isset($_REQUEST['pMeses'])?$_REQUEST['pMeses']:null;
    
    $gBaseDatos = new ofiMySQLi();
    $gBaseDatos->conectar();
    $qry = "CALL sp_asistencial_add_evolucion('" . $pEmpresa . "','" . $pIPS . "','" . $pPaciente . "','" . $pProfesional . "','" . $pCAS . "','" . $pConsecutivoDetalle . "','" . $pidPlantillaHC . "',\"" . $pFechaAtencion . "\",\"" . $pHoraApertura . "\",\"" . $pActividad . "\",\"" . $pPlantilla . "\",\"" . $pRutaRptHC . "\",\"" . $pRutaRptMx . "\",\"" . $pRutaRptExa . "\",\"" . $pRutaRptRem . "\",\"" . $pEvolucion . "\",\"" . $pDiagppal . "\",\"" . $pDiagrel1 . "\",\"" . $pDiagrel2 . "\",\"" . $pDiagrel3 . "\",\"" . $pTipodiag . "\",\"" . $pFinalidad . "\",\"" . $pCausa . "\",\"" . $pAmbito . "\",\"" . $pFinalidadProced . "\",\"" . $pPersonalAtiende . "\",\"" . $pFormaActo . "\",'" . $pUsuario . "','" . $pIdCliente . "','" . $pIdPlan . "','" . $pIdSubPlan . "','" . $pIdContrato . "',\"" . $pAutorizacion . "\",\"" . $pCambiaCliente . "\")";
    //echo $qry;
    if(@mysqli_query($gBaseDatos->ConexionID, $qry)){
        $gBaseDatos->cerrar();
        if($pGuardarSignos == "SI"){
            $gBaseDatos = new ofiMySQLi();
            $gBaseDatos->conectar();
            $qry = "CALL sp_asistencial_add_tomasignos('" . $pEmpresa . "','" . $pIPS . "','" . $pPaciente . "','" . $pProfesional . "',\"" . $pFechaAtencion . "\",'" . $pCAS . "','" . $pAnios . "','" . $pMeses . "','" . $pTalla . "','" . $pPeso . "','" . $pIMC . "',\"" . $pIMCClasifica . "\",'" . $pTE . "','" . $pPerimetroCefalico . "','" . $pPerimetroToraxico . "','" . $pTASIS . "','" . $pTADIAS . "')";
            @mysqli_query($gBaseDatos->ConexionID, $qry);
            $gBaseDatos->cerrar();
        }
        echo "{success: true, requestedId:'1'}";
    }else{
       echo "{success: true, requestedId:'0'}";
       $gBaseDatos->cerrar();   
    }
    
}

function ModificarHC()
{
    $pEmpresa = isset($_REQUEST['pEmpresa'])?$_REQUEST['pEmpresa']:0;
    $pIPS = isset($_REQUEST['pIPS'])?$_REQUEST['pIPS']:0;
    $pPaciente = isset($_REQUEST['pPaciente'])?$_REQUEST['pPaciente']:0;
    //$pProfesional = isset($_REQUEST['pProfesional'])?$_REQUEST['pProfesional']:0;
    $pProfesional = $_SESSION['ID_PROFESIONAL_HC'];
    $pCAS = isset($_REQUEST['pCAS'])?$_REQUEST['pCAS']:0;
    $pConsecutivoDetalle = isset($_REQUEST['pConsecutivoDetalle'])?$_REQUEST['pConsecutivoDetalle']:0;
    $pFechaAtencion = isset($_REQUEST['pFechaAtencion'])?$_REQUEST['pFechaAtencion']:null;
    $pHoraApertura = isset($_REQUEST['pHoraApertura'])?$_REQUEST['pHoraApertura']:null;
    $pActividad = isset($_REQUEST['pActividad'])?$_REQUEST['pActividad']:null;
    $pPlantilla = isset($_REQUEST['pPlantilla'])?$_REQUEST['pPlantilla']:null;
    $pRutaRptHC = isset($_REQUEST['pRutaRptHC'])?$_REQUEST['pRutaRptHC']:null;
    $pRutaRptMx = isset($_REQUEST['pRutaRptMx'])?$_REQUEST['pRutaRptMx']:null;
    $pRutaRptExa = isset($_REQUEST['pRutaRptExa'])?$_REQUEST['pRutaRptExa']:null;
    $pRutaRptRem = isset($_REQUEST['pRutaRptRem'])?$_REQUEST['pRutaRptRem']:null;
    $contenido = isset($_REQUEST['CAMPOS'])?$_REQUEST['CAMPOS']:null;
    $pEvolucion = stripslashes(utf8_encode(str_replace('"', '""',nl2br($contenido))));
    $pDiagppal = isset($_REQUEST['pDiagppal'])?$_REQUEST['pDiagppal']:null;
    $pDiagrel1 = isset($_REQUEST['pDiagrel1'])?$_REQUEST['pDiagrel1']:null;
    $pDiagrel2 = isset($_REQUEST['pDiagrel2'])?$_REQUEST['pDiagrel2']:null;
    $pDiagrel3 = isset($_REQUEST['pDiagrel3'])?$_REQUEST['pDiagrel3']:null;
    $pTipodiag = isset($_REQUEST['pTipodiag'])?$_REQUEST['pTipodiag']:null;
    $pFinalidad = isset($_REQUEST['pFinalidad'])?$_REQUEST['pFinalidad']:null;
    $pCausa = isset($_REQUEST['pCausa'])?$_REQUEST['pCausa']:null;
    $pAmbito = isset($_REQUEST['pAmbito'])?$_REQUEST['pAmbito']:null;
    $pFinalidadProced = isset($_REQUEST['pFinalidadProced'])?$_REQUEST['pFinalidadProced']:null;
    $pPersonalAtiende = isset($_REQUEST['pPersonalAtiende'])?$_REQUEST['pPersonalAtiende']:null;
    $pFormaActo = isset($_REQUEST['pFormaActo'])?$_REQUEST['pFormaActo']:null;
    $pUsuario = isset($_REQUEST['pUsuario'])?$_REQUEST['pUsuario']:0;
    $pIdCliente = isset($_REQUEST['pIdCliente'])?$_REQUEST['pIdCliente']:0;
    $pIdPlan = isset($_REQUEST['pIdPlan'])?$_REQUEST['pIdPlan']:0;
    $pIdSubPlan = isset($_REQUEST['pIdSubPlan'])?$_REQUEST['pIdSubPlan']:0;
    $pIdContrato = isset($_REQUEST['pIdContrato'])?$_REQUEST['pIdContrato']:0;
    $pAutorizacion = isset($_REQUEST['pAutorizacion'])?$_REQUEST['pAutorizacion']:null;
    if($pAutorizacion == null || $pAutorizacion == ""){
        $pAutorizacion = "NA";
    }
    $pCambiaCliente = isset($_REQUEST['pCambiaCliente'])?$_REQUEST['pCambiaCliente']:"NA";
    $pGuardarSignos = isset($_REQUEST['pGuardarSignos'])?$_REQUEST['pGuardarSignos']:"NO";
    $pTalla = isset($_REQUEST['pTalla'])?$_REQUEST['pTalla']:null;
    $pPeso = isset($_REQUEST['pPeso'])?$_REQUEST['pPeso']:null;
    $pIMC = isset($_REQUEST['pIMC'])?$_REQUEST['pIMC']:null;
    $pIMCClasifica = isset($_REQUEST['pIMCClasifica'])?$_REQUEST['pIMCClasifica']:null;
    $pTE = isset($_REQUEST['pTE'])?$_REQUEST['pTE']:null;
    $pPerimetroCefalico = isset($_REQUEST['pPerimetroCefalico'])?$_REQUEST['pPerimetroCefalico']:null;
    $pPerimetroToraxico = isset($_REQUEST['pPerimetroToraxico'])?$_REQUEST['pPerimetroToraxico']:null;
    $pTASIS = isset($_REQUEST['pTASIS'])?$_REQUEST['pTASIS']:null;
    $pTADIAS = isset($_REQUEST['pTADIAS'])?$_REQUEST['pTADIAS']:null;
    $pAnios = isset($_REQUEST['pAnios'])?$_REQUEST['pAnios']:null;
    $pMeses = isset($_REQUEST['pMeses'])?$_REQUEST['pMeses']:null;
    $gBaseDatos = new ofiMySQLi();
    $gBaseDatos->conectar();
    $qry = "CALL sp_asistencial_edit_evolucion('" . $pEmpresa . "','" . $pIPS . "','" . $pPaciente . "','" . $pProfesional . "','" . $pCAS . "','" . $pConsecutivoDetalle . "',\"" . $pFechaAtencion . "\",\"" . $pHoraApertura . "\",\"" . $pActividad . "\",\"" . $pPlantilla . "\",\"" . $pEvolucion . "\",\"" . $pDiagppal . "\",\"" . $pDiagrel1 . "\",\"" . $pDiagrel2 . "\",\"" . $pDiagrel3 . "\",\"" . $pTipodiag . "\",\"" . $pFinalidad . "\",\"" . $pCausa . "\",\"" . $pAmbito . "\",\"" . $pFinalidadProced . "\",\"" . $pPersonalAtiende . "\",\"" . $pFormaActo . "\",'" . $pUsuario . "','" . $pIdCliente . "','" . $pIdPlan . "','" . $pIdSubPlan . "','" . $pIdContrato . "',\"" . $pAutorizacion . "\",\"" . $pCambiaCliente . "\")";
    //echo $qry;
    if(@mysqli_query($gBaseDatos->ConexionID, $qry)){
        $gBaseDatos->cerrar();
        if($pGuardarSignos == "SI"){
            $gBaseDatos = new ofiMySQLi();
            $gBaseDatos->conectar();
            $qry = "CALL sp_asistencial_edit_tomasignos('" . $pEmpresa . "','" . $pIPS . "','" . $pPaciente . "','" . $pProfesional . "',\"" . $pFechaAtencion . "\",'" . $pCAS . "','" . $pAnios . "','" . $pMeses . "','" . $pTalla . "','" . $pPeso . "','" . $pIMC . "',\"" . $pIMCClasifica . "\",'" . $pTE . "','" . $pPerimetroCefalico . "','" . $pPerimetroToraxico . "','" . $pTASIS . "','" . $pTADIAS . "')";
            @mysqli_query($gBaseDatos->ConexionID, $qry);
            $gBaseDatos->cerrar();
        }
        echo "{success: true, requestedId:'1'}";
    }else{
       echo "{success: true, requestedId:'0'}";
        $gBaseDatos->cerrar();
    }
}

function GuardarBarthelHC()
{
    $pEmpresa = isset($_REQUEST['pEmpresa'])?$_REQUEST['pEmpresa']:0;
    $pIPS = isset($_REQUEST['pIPS'])?$_REQUEST['pIPS']:0;
    $pCAS = isset($_REQUEST['pCAS'])?$_REQUEST['pCAS']:0;
    $pConsecutivoDetalle = isset($_REQUEST['pConsecutivoDetalle'])?$_REQUEST['pConsecutivoDetalle']:0;
    $pResultadoBarthel = isset($_REQUEST['pResultadoBarthel'])?$_REQUEST['pResultadoBarthel']:null;
    $contenido = isset($_REQUEST['CAMPOS'])?$_REQUEST['CAMPOS']:null;
    $pEvolucion = stripslashes(utf8_encode(str_replace('"', '""',nl2br($contenido))));
    $gBaseDatos = new ofiMySQLi();
    $gBaseDatos->conectar();
    $qry = "CALL sp_asistencial_edit_evolucion_barthel('" . $pEmpresa . "','" . $pIPS . "','" . $pCAS . "','" . $pConsecutivoDetalle . "',\"" . $pResultadoBarthel . "\",\"" . $pEvolucion . "\")";
    //echo $qry;
    if(@mysqli_query($gBaseDatos->ConexionID, $qry))
        echo "{success: true, requestedId:'1'}";
    else
       echo "{success: true, requestedId:'0'}";
    $gBaseDatos->cerrar();
}

function GuardarHachinskiHC()
{
    $pEmpresa = isset($_REQUEST['pEmpresa'])?$_REQUEST['pEmpresa']:0;
    $pIPS = isset($_REQUEST['pIPS'])?$_REQUEST['pIPS']:0;
    $pCAS = isset($_REQUEST['pCAS'])?$_REQUEST['pCAS']:0;
    $pConsecutivoDetalle = isset($_REQUEST['pConsecutivoDetalle'])?$_REQUEST['pConsecutivoDetalle']:0;
    $pResultadoClasifica = isset($_REQUEST['pResultadoClasifica'])?$_REQUEST['pResultadoClasifica']:null;
    $contenido = isset($_REQUEST['CAMPOS'])?$_REQUEST['CAMPOS']:null;
    $pEvolucion = stripslashes(utf8_encode(str_replace('"', '""',nl2br($contenido))));
    $gBaseDatos = new ofiMySQLi();
    $gBaseDatos->conectar();
    $qry = "CALL sp_asistencial_edit_evolucion_hachinski('" . $pEmpresa . "','" . $pIPS . "','" . $pCAS . "','" . $pConsecutivoDetalle . "',\"" . $pResultadoClasifica . "\",\"" . $pEvolucion . "\")";
    //echo $qry;
    if(@mysqli_query($gBaseDatos->ConexionID, $qry))
        echo "{success: true, requestedId:'1'}";
    else
       echo "{success: true, requestedId:'0'}";
    $gBaseDatos->cerrar();
}

function GuardarFolsteinHC(){
    $pEmpresa = isset($_REQUEST['pEmpresa'])?$_REQUEST['pEmpresa']:0;
    $pIPS = isset($_REQUEST['pIPS'])?$_REQUEST['pIPS']:0;
    $pCAS = isset($_REQUEST['pCAS'])?$_REQUEST['pCAS']:0;
    $pConsecutivoDetalle = isset($_REQUEST['pConsecutivoDetalle'])?$_REQUEST['pConsecutivoDetalle']:0;
    $pResultadoClasifica = isset($_REQUEST['pResultadoClasifica'])?$_REQUEST['pResultadoClasifica']:null;
    $contenido = isset($_REQUEST['CAMPOS'])?$_REQUEST['CAMPOS']:null;
    $pEvolucion = stripslashes(utf8_encode(str_replace('"', '""',nl2br($contenido))));
    $gBaseDatos = new ofiMySQLi();
    $gBaseDatos->conectar();
    $qry = "CALL sp_asistencial_edit_evolucion_folstein('" . $pEmpresa . "','" . $pIPS . "','" . $pCAS . "','" . $pConsecutivoDetalle . "',\"" . $pResultadoClasifica . "\",\"" . $pEvolucion . "\")";
    //echo $qry;
    if(@mysqli_query($gBaseDatos->ConexionID, $qry))
        echo "{success: true, requestedId:'1'}";
    else
       echo "{success: true, requestedId:'0'}";
    $gBaseDatos->cerrar();
}

function GuardarLawtonHC(){
    $pEmpresa = isset($_REQUEST['pEmpresa'])?$_REQUEST['pEmpresa']:0;
    $pIPS = isset($_REQUEST['pIPS'])?$_REQUEST['pIPS']:0;
    $pCAS = isset($_REQUEST['pCAS'])?$_REQUEST['pCAS']:0;
    $pConsecutivoDetalle = isset($_REQUEST['pConsecutivoDetalle'])?$_REQUEST['pConsecutivoDetalle']:0;
    $pResultadoClasifica = isset($_REQUEST['pResultadoClasifica'])?$_REQUEST['pResultadoClasifica']:null;
    $contenido = isset($_REQUEST['CAMPOS'])?$_REQUEST['CAMPOS']:null;
    $pEvolucion = stripslashes(utf8_encode(str_replace('"', '""',nl2br($contenido))));
    $gBaseDatos = new ofiMySQLi();
    $gBaseDatos->conectar();
    $qry = "CALL sp_asistencial_edit_evolucion_lawton('" . $pEmpresa . "','" . $pIPS . "','" . $pCAS . "','" . $pConsecutivoDetalle . "',\"" . $pResultadoClasifica . "\",\"" . $pEvolucion . "\")";
    //echo $qry;
    if(@mysqli_query($gBaseDatos->ConexionID, $qry))
        echo "{success: true, requestedId:'1'}";
    else
       echo "{success: true, requestedId:'0'}";
    $gBaseDatos->cerrar();
}

function GuardarYesavageHC(){
    $pEmpresa = isset($_REQUEST['pEmpresa'])?$_REQUEST['pEmpresa']:0;
    $pIPS = isset($_REQUEST['pIPS'])?$_REQUEST['pIPS']:0;
    $pCAS = isset($_REQUEST['pCAS'])?$_REQUEST['pCAS']:0;
    $pConsecutivoDetalle = isset($_REQUEST['pConsecutivoDetalle'])?$_REQUEST['pConsecutivoDetalle']:0;
    $pResultadoClasifica = isset($_REQUEST['pResultadoClasifica'])?$_REQUEST['pResultadoClasifica']:null;
    $contenido = isset($_REQUEST['CAMPOS'])?$_REQUEST['CAMPOS']:null;
    $pEvolucion = stripslashes(utf8_encode(str_replace('"', '""',nl2br($contenido))));
    $gBaseDatos = new ofiMySQLi();
    $gBaseDatos->conectar();
    $qry = "CALL sp_asistencial_edit_evolucion_yesavage('" . $pEmpresa . "','" . $pIPS . "','" . $pCAS . "','" . $pConsecutivoDetalle . "',\"" . $pResultadoClasifica . "\",\"" . $pEvolucion . "\")";
    //echo $qry;
    if(@mysqli_query($gBaseDatos->ConexionID, $qry))
        echo "{success: true, requestedId:'1'}";
    else
       echo "{success: true, requestedId:'0'}";
    $gBaseDatos->cerrar();
}


function GuardarProc()
{
    $pEmpresa = isset($_REQUEST['pEmpresa'])?$_REQUEST['pEmpresa']:0;
    $pIPS = isset($_REQUEST['pIPS'])?$_REQUEST['pIPS']:0;
    $pPaciente = isset($_REQUEST['pPaciente'])?$_REQUEST['pPaciente']:0;
    $pProfesional = $_SESSION['ID_PROFESIONAL_HC'];
    $pCAS = isset($_REQUEST['pCAS'])?$_REQUEST['pCAS']:0;
    $pConsecutivoDetalle = isset($_REQUEST['pConsecutivoDetalle'])?$_REQUEST['pConsecutivoDetalle']:0;
    $pidPlantillaHC = isset($_REQUEST['pidPlantillaHC'])?$_REQUEST['pidPlantillaHC']:0;
    $pFechaAtencion = isset($_REQUEST['pFechaAtencion'])?$_REQUEST['pFechaAtencion']:null;
    $pHoraApertura = isset($_REQUEST['pHoraApertura'])?$_REQUEST['pHoraApertura']:null;
    $pActividad = isset($_REQUEST['pActividad'])?$_REQUEST['pActividad']:null;
    $pPlantilla = isset($_REQUEST['pPlantilla'])?$_REQUEST['pPlantilla']:null;
    $pRutaRptHC = isset($_REQUEST['pRutaRptHC'])?$_REQUEST['pRutaRptHC']:null;
    $pRutaRptMx = isset($_REQUEST['pRutaRptMx'])?$_REQUEST['pRutaRptMx']:null;
    $pRutaRptExa = isset($_REQUEST['pRutaRptExa'])?$_REQUEST['pRutaRptExa']:null;
    $pRutaRptRem = isset($_REQUEST['pRutaRptRem'])?$_REQUEST['pRutaRptRem']:null;
    $contenido = isset($_REQUEST['CAMPOS'])?$_REQUEST['CAMPOS']:null;
    $pEvolucion = stripslashes(utf8_encode(str_replace('"', '""',nl2br($contenido))));
    $pDiagppal = isset($_REQUEST['pDiagppal'])?$_REQUEST['pDiagppal']:null;
    $pDiagrel1 = isset($_REQUEST['pDiagrel1'])?$_REQUEST['pDiagrel1']:null;
    $pDiagrel2 = isset($_REQUEST['pDiagrel2'])?$_REQUEST['pDiagrel2']:null;
    $pDiagrel3 = isset($_REQUEST['pDiagrel3'])?$_REQUEST['pDiagrel3']:null;
    $pAmbito = isset($_REQUEST['pAmbito'])?$_REQUEST['pAmbito']:1;
    $pFinalidad = isset($_REQUEST['pFinalidad'])?$_REQUEST['pFinalidad']:1;
    $pPersona = isset($_REQUEST['pPersona'])?$_REQUEST['pPersona']:5;
    $pForma = isset($_REQUEST['pForma'])?$_REQUEST['pForma']:1;
    $pUsuario = isset($_REQUEST['pUsuario'])?$_REQUEST['pUsuario']:0;
    $pIdCliente = isset($_REQUEST['pIdCliente'])?$_REQUEST['pIdCliente']:0;
    $pIdPlan = isset($_REQUEST['pIdPlan'])?$_REQUEST['pIdPlan']:0;
    $pIdSubPlan = isset($_REQUEST['pIdSubPlan'])?$_REQUEST['pIdSubPlan']:0;
    $pIdContrato = isset($_REQUEST['pIdContrato'])?$_REQUEST['pIdContrato']:0;
    
    $gBaseDatos = new ofiMySQLi();
    $gBaseDatos->conectar();
    $qry = "CALL sp_asistencial_add_proced('" . $pEmpresa . "','" . $pIPS . "','" . $pPaciente . "','" . $pProfesional . "','" . $pCAS . "','" . $pConsecutivoDetalle . "','" . $pidPlantillaHC . "',\"" . $pFechaAtencion . "\",\"" . $pHoraApertura . "\",\"" . $pActividad . "\",\"" . $pPlantilla . "\",\"" . $pRutaRptHC . "\",\"" . $pRutaRptMx . "\",\"" . $pRutaRptExa . "\",\"" . $pRutaRptRem . "\",\"" . $pEvolucion . "\",\"" . $pDiagppal . "\",\"" . $pDiagrel1 . "\",\"" . $pDiagrel2 . "\",\"" . $pAmbito . "\",\"" . $pFinalidad . "\",\"" . $pPersona . "\",\"" . $pForma . "\",'" . $pUsuario . "','" . $pIdCliente . "','" . $pIdPlan . "','" . $pIdSubPlan . "','" . $pIdContrato . "')";
    //echo $qry;
    if(@mysqli_query($gBaseDatos->ConexionID, $qry))
        echo "{success: true, requestedId:'1'}";
    else
       echo "{success: true, requestedId:'0'}";
    $gBaseDatos->cerrar();   
}

function ModificarProc()
{
    $pEmpresa = isset($_REQUEST['pEmpresa'])?$_REQUEST['pEmpresa']:0;
    $pIPS = isset($_REQUEST['pIPS'])?$_REQUEST['pIPS']:0;
    $pPaciente = isset($_REQUEST['pPaciente'])?$_REQUEST['pPaciente']:0;
    $pProfesional = $_SESSION['ID_PROFESIONAL_HC'];
    $pCAS = isset($_REQUEST['pCAS'])?$_REQUEST['pCAS']:0;
    $pConsecutivoDetalle = isset($_REQUEST['pConsecutivoDetalle'])?$_REQUEST['pConsecutivoDetalle']:0;
    $pFechaAtencion = isset($_REQUEST['pFechaAtencion'])?$_REQUEST['pFechaAtencion']:null;
    $pHoraApertura = isset($_REQUEST['pHoraApertura'])?$_REQUEST['pHoraApertura']:null;
    $pActividad = isset($_REQUEST['pActividad'])?$_REQUEST['pActividad']:null;
    $pPlantilla = isset($_REQUEST['pPlantilla'])?$_REQUEST['pPlantilla']:null;
    $pRutaRptHC = isset($_REQUEST['pRutaRptHC'])?$_REQUEST['pRutaRptHC']:null;
    $pRutaRptMx = isset($_REQUEST['pRutaRptMx'])?$_REQUEST['pRutaRptMx']:null;
    $pRutaRptExa = isset($_REQUEST['pRutaRptExa'])?$_REQUEST['pRutaRptExa']:null;
    $pRutaRptRem = isset($_REQUEST['pRutaRptRem'])?$_REQUEST['pRutaRptRem']:null;
    $contenido = isset($_REQUEST['CAMPOS'])?$_REQUEST['CAMPOS']:null;
    $pEvolucion = stripslashes(utf8_encode(str_replace('"', '""',nl2br($contenido))));
    $pDiagppal = isset($_REQUEST['pDiagppal'])?$_REQUEST['pDiagppal']:null;
    $pDiagrel1 = isset($_REQUEST['pDiagrel1'])?$_REQUEST['pDiagrel1']:null;
    $pDiagrel2 = isset($_REQUEST['pDiagrel2'])?$_REQUEST['pDiagrel2']:null;
    $pDiagrel3 = isset($_REQUEST['pDiagrel3'])?$_REQUEST['pDiagrel3']:null;
    $pAmbito = isset($_REQUEST['pAmbito'])?$_REQUEST['pAmbito']:1;
    $pFinalidad = isset($_REQUEST['pFinalidad'])?$_REQUEST['pFinalidad']:1;
    $pPersona = isset($_REQUEST['pPersona'])?$_REQUEST['pPersona']:5;
    $pForma = isset($_REQUEST['pForma'])?$_REQUEST['pForma']:1;
    $pUsuario = isset($_REQUEST['pUsuario'])?$_REQUEST['pUsuario']:0;
    $pIdCliente = isset($_REQUEST['pIdCliente'])?$_REQUEST['pIdCliente']:0;
    $pIdPlan = isset($_REQUEST['pIdPlan'])?$_REQUEST['pIdPlan']:0;
    $pIdSubPlan = isset($_REQUEST['pIdSubPlan'])?$_REQUEST['pIdSubPlan']:0;
    $pIdContrato = isset($_REQUEST['pIdContrato'])?$_REQUEST['pIdContrato']:0;
    
    $gBaseDatos = new ofiMySQLi();
    $gBaseDatos->conectar();
    $qry = "CALL sp_asistencial_edit_proced('" . $pEmpresa . "','" . $pIPS . "','" . $pPaciente . "','" . $pProfesional . "','" . $pCAS . "','" . $pConsecutivoDetalle . "','" . $pidPlantillaHC . "',\"" . $pFechaAtencion . "\",\"" . $pHoraApertura . "\",\"" . $pActividad . "\",\"" . $pPlantilla . "\",\"" . $pRutaRptHC . "\",\"" . $pRutaRptMx . "\",\"" . $pRutaRptExa . "\",\"" . $pRutaRptRem . "\",\"" . $pEvolucion . "\",\"" . $pDiagppal . "\",\"" . $pDiagrel1 . "\",\"" . $pDiagrel2 . "\",\"" . $pAmbito . "\",\"" . $pFinalidad . "\",\"" . $pPersona . "\",\"" . $pForma . "\",'" . $pUsuario . "','" . $pIdCliente . "','" . $pIdPlan . "','" . $pIdSubPlan . "','" . $pIdContrato . "')";
    //echo $qry;
    if(@mysqli_query($gBaseDatos->ConexionID, $qry))
        echo "{success: true, requestedId:'1'}";
    else
       echo "{success: true, requestedId:'0'}";
    $gBaseDatos->cerrar();
}

/*function GuardarTomaCitologia()
{
    
    $pEmpresa = isset($_REQUEST['pEmpresa'])?$_REQUEST['pEmpresa']:0;
    $pIPS = isset($_REQUEST['pIPS'])?$_REQUEST['pIPS']:0;
    $pPaciente = isset($_REQUEST['pPaciente'])?$_REQUEST['pPaciente']:0;
    $pProfesional = $_SESSION['ID_PROFESIONAL_HC'];
    $pCAS = isset($_REQUEST['pCAS'])?$_REQUEST['pCAS']:0;
    $pConsecutivoDetalle = isset($_REQUEST['pConsecutivoDetalle'])?$_REQUEST['pConsecutivoDetalle']:0;
    $pidPlantillaHC = isset($_REQUEST['pidPlantillaHC'])?$_REQUEST['pidPlantillaHC']:0;
    $pFechaAtencion = isset($_REQUEST['pFechaAtencion'])?$_REQUEST['pFechaAtencion']:null;
    $pHoraApertura = isset($_REQUEST['pHoraApertura'])?$_REQUEST['pHoraApertura']:null;
    $pActividad = isset($_REQUEST['pActividad'])?$_REQUEST['pActividad']:null;
    $pPlantilla = isset($_REQUEST['pPlantilla'])?$_REQUEST['pPlantilla']:null;
    $pRutaRptHC = isset($_REQUEST['pRutaRptHC'])?$_REQUEST['pRutaRptHC']:null;
    $pRutaRptMx = isset($_REQUEST['pRutaRptMx'])?$_REQUEST['pRutaRptMx']:null;
    $pRutaRptExa = isset($_REQUEST['pRutaRptExa'])?$_REQUEST['pRutaRptExa']:null;
    $pRutaRptRem = isset($_REQUEST['pRutaRptRem'])?$_REQUEST['pRutaRptRem']:null;
    $contenido = isset($_REQUEST['CAMPOS'])?$_REQUEST['CAMPOS']:null;
    $pEvolucion = utf8_encode(str_replace('"', '""',nl2br($contenido)));
    $pDiagppal = isset($_REQUEST['pDiagppal'])?$_REQUEST['pDiagppal']:null;
    $pDiagrel1 = isset($_REQUEST['pDiagrel1'])?$_REQUEST['pDiagrel1']:null;
    $pDiagrel2 = isset($_REQUEST['pDiagrel2'])?$_REQUEST['pDiagrel2']:null;
    $pDiagrel3 = isset($_REQUEST['pDiagrel3'])?$_REQUEST['pDiagrel3']:null;
    $pTipodiag = isset($_REQUEST['pTipodiag'])?$_REQUEST['pTipodiag']:null;
    $pFinalidad = isset($_REQUEST['pFinalidad'])?$_REQUEST['pFinalidad']:null;
    $pCausa = isset($_REQUEST['pCausa'])?$_REQUEST['pCausa']:null;
    $pAmbito = isset($_REQUEST['pAmbito'])?$_REQUEST['pAmbito']:null;
    $pFinalidadProced = isset($_REQUEST['pFinalidadProced'])?$_REQUEST['pFinalidadProced']:null;
    $pPersonalAtiende = isset($_REQUEST['pPersonalAtiende'])?$_REQUEST['pPersonalAtiende']:null;
    $pFormaActo = isset($_REQUEST['pFormaActo'])?$_REQUEST['pFormaActo']:null;
    $pUsuario = isset($_REQUEST['pUsuario'])?$_REQUEST['pUsuario']:0;
    $pIdCliente = isset($_REQUEST['pIdCliente'])?$_REQUEST['pIdCliente']:0;
    $pIdPlan = isset($_REQUEST['pIdPlan'])?$_REQUEST['pIdPlan']:0;
    $pIdSubPlan = isset($_REQUEST['pIdSubPlan'])?$_REQUEST['pIdSubPlan']:0;
    $pIdContrato = isset($_REQUEST['pIdContrato'])?$_REQUEST['pIdContrato']:0;
    $pAutorizacion = isset($_REQUEST['pAutorizacion'])?$_REQUEST['pAutorizacion']:null;
    $pCITFecCitologia = isset($_REQUEST['pCITFecCitologia'])?$_REQUEST['pCITFecCitologia']:null;
    $pCITLactancia = isset($_REQUEST['pCITLactancia'])?$_REQUEST['pCITLactancia']:null;
    $pCITFecUltMestruacion = isset($_REQUEST['pCITFecUltMestruacion'])?$_REQUEST['pCITFecUltMestruacion']:null;
    $pCITGestaciones = isset($_REQUEST['pCITGestaciones'])?$_REQUEST['pCITGestaciones']:null;
    $pCITPartos = isset($_REQUEST['pCITPartos'])?$_REQUEST['pCITPartos']:null;
    $pCITAbortos = isset($_REQUEST['pCITAbortos'])?$_REQUEST['pCITAbortos']:null;
    $pCITEmbarazoActual = isset($_REQUEST['pCITEmbarazoActual'])?$_REQUEST['pCITEmbarazoActual']:null;
    $pCITMetodoPlanifica = isset($_REQUEST['pCITMetodoPlanifica'])?$_REQUEST['pCITMetodoPlanifica']:null;
    $pCITTiempoUso = isset($_REQUEST['pCITTiempoUso'])?$_REQUEST['pCITTiempoUso']:null;
    $pCITFecUltCitologia = isset($_REQUEST['pCITFecUltCitologia'])?$_REQUEST['pCITFecUltCitologia']:null;
    $pCITResultadoCitologia = isset($_REQUEST['pCITResultadoCitologia'])?$_REQUEST['pCITResultadoCitologia']:null;
    $pCITCauterizacion = isset($_REQUEST['pCITCauterizacion'])?$_REQUEST['pCITCauterizacion']:null;
    $pCITCauterizacionFec = isset($_REQUEST['pCITCauterizacionFec'])?$_REQUEST['pCITCauterizacionFec']:null;
    $pCITHisterectomia = isset($_REQUEST['pCITHisterectomia'])?$_REQUEST['pCITHisterectomia']:null;
    $pCITHisterectomiaFec = isset($_REQUEST['pCITHisterectomiaFec'])?$_REQUEST['pCITHisterectomiaFec']:null;
    $pCITVaporizacion = isset($_REQUEST['pCITVaporizacion'])?$_REQUEST['pCITVaporizacion']:null;
    $pCITVaporizacionFec = isset($_REQUEST['pCITVaporizacionFec'])?$_REQUEST['pCITVaporizacionFec']:null;
    $pCITConizacion = isset($_REQUEST['pCITConizacion'])?$_REQUEST['pCITConizacion']:null;
    $pCITConizacionFec = isset($_REQUEST['pCITConizacionFec'])?$_REQUEST['pCITConizacionFec']:null;
    $pCITCrioterapia = isset($_REQUEST['pCITCrioterapia'])?$_REQUEST['pCITCrioterapia']:null;
    $pCITCrioterapiaFec = isset($_REQUEST['pCITCrioterapiaFec'])?$_REQUEST['pCITCrioterapiaFec']:null;
    $pCITRadioterapia = isset($_REQUEST['pCITRadioterapia'])?$_REQUEST['pCITRadioterapia']:null;
    $pCITRadioterapiaFec = isset($_REQUEST['pCITRadioterapiaFec'])?$_REQUEST['pCITRadioterapiaFec']:null;
    $pCITTtoHormonal = isset($_REQUEST['pCITTtoHormonal'])?$_REQUEST['pCITTtoHormonal']:null;
    $pCITTtoHormonalFec = isset($_REQUEST['pCITTtoHormonalFec'])?$_REQUEST['pCITTtoHormonalFec']:null;
    $pCITBiopsia = isset($_REQUEST['pCITBiopsia'])?$_REQUEST['pCITBiopsia']:null;
    $pCITBiopsiaFec = isset($_REQUEST['pCITBiopsiaFec'])?$_REQUEST['pCITBiopsiaFec']:null;
    $pCITColposcopia = isset($_REQUEST['pCITColposcopia'])?$_REQUEST['pCITColposcopia']:null;
    $pCITColposcopiaFec = isset($_REQUEST['pCITColposcopiaFec'])?$_REQUEST['pCITColposcopiaFec']:null;
    $pCITAusente = isset($_REQUEST['pCITAusente'])?$_REQUEST['pCITAusente']:null;
    $pCITSano = isset($_REQUEST['pCITSano'])?$_REQUEST['pCITSano']:null;
    $pCITAtrofico = isset($_REQUEST['pCITAtrofico'])?$_REQUEST['pCITAtrofico']:null;
    $pCITCongestivo = isset($_REQUEST['pCITCongestivo'])?$_REQUEST['pCITCongestivo']:null;
    $pCITUlcerado = isset($_REQUEST['pCITUlcerado'])?$_REQUEST['pCITUlcerado']:null;
    $pCITPolipo = isset($_REQUEST['pCITPolipo'])?$_REQUEST['pCITPolipo']:null;
    $pCITMasa = isset($_REQUEST['pCITMasa'])?$_REQUEST['pCITMasa']:null;
    $pCITObservacionesToma = isset($_REQUEST['pCITObservacionesToma'])?$_REQUEST['pCITObservacionesToma']:null;
    $pCITCalidad1 = isset($_REQUEST['pCITCalidad1'])?$_REQUEST['pCITCalidad1']:null;
    $pCITCalidad2 = isset($_REQUEST['pCITCalidad2'])?$_REQUEST['pCITCalidad2']:null;
    $pCITCalidad3 = isset($_REQUEST['pCITCalidad3'])?$_REQUEST['pCITCalidad3']:null;
    $pCITCalidad4 = isset($_REQUEST['pCITCalidad4'])?$_REQUEST['pCITCalidad4']:null;
    $pCITCausa = isset($_REQUEST['pCITCausa'])?$_REQUEST['pCITCausa']:null;
    $pCITCategorizacion1 = isset($_REQUEST['pCITCategorizacion1'])?$_REQUEST['pCITCategorizacion1']:null;
    $pCITCategorizacion2 = isset($_REQUEST['pCITCategorizacion2'])?$_REQUEST['pCITCategorizacion2']:null;
    $pCITMicroorganismos1 = isset($_REQUEST['pCITMicroorganismos1'])?$_REQUEST['pCITMicroorganismos1']:null;
    $pCITMicroorganismos2 = isset($_REQUEST['pCITMicroorganismos2'])?$_REQUEST['pCITMicroorganismos2']:null;
    $pCITMicroorganismos3 = isset($_REQUEST['pCITMicroorganismos3'])?$_REQUEST['pCITMicroorganismos3']:null;
    $pCITMicroorganismos4 = isset($_REQUEST['pCITMicroorganismos4'])?$_REQUEST['pCITMicroorganismos4']:null;
    $pCITMicroorganismos5 = isset($_REQUEST['pCITMicroorganismos5'])?$_REQUEST['pCITMicroorganismos5']:null;
    $pCITMicroorganismos6 = isset($_REQUEST['pCITMicroorganismos6'])?$_REQUEST['pCITMicroorganismos6']:null;
    $pCITOtrosHallazgos1 = isset($_REQUEST['pCITOtrosHallazgos1'])?$_REQUEST['pCITOtrosHallazgos1']:null;
    $pCITOtrosHallazgos2 = isset($_REQUEST['pCITOtrosHallazgos2'])?$_REQUEST['pCITOtrosHallazgos2']:null;
    $pCITOtrosHallazgos3 = isset($_REQUEST['pCITOtrosHallazgos3'])?$_REQUEST['pCITOtrosHallazgos3']:null;
    $pCITOtrosHallazgos4 = isset($_REQUEST['pCITOtrosHallazgos4'])?$_REQUEST['pCITOtrosHallazgos4']:null;
    $pCITOtrosHallazgos5 = isset($_REQUEST['pCITOtrosHallazgos5'])?$_REQUEST['pCITOtrosHallazgos5']:null;
    $pCITOtrosHallazgos6 = isset($_REQUEST['pCITOtrosHallazgos6'])?$_REQUEST['pCITOtrosHallazgos6']:null;
    $pCITAnormalidades1 = isset($_REQUEST['pCITAnormalidades1'])?$_REQUEST['pCITAnormalidades1']:null;
    $pCITAnormalidades2 = isset($_REQUEST['pCITAnormalidades2'])?$_REQUEST['pCITAnormalidades2']:null;
    $pCITAnormalidades3 = isset($_REQUEST['pCITAnormalidades3'])?$_REQUEST['pCITAnormalidades3']:null;
    $pCITAnormalidades4 = isset($_REQUEST['pCITAnormalidades4'])?$_REQUEST['pCITAnormalidades4']:null;
    $pCITAnormalidades5 = isset($_REQUEST['pCITAnormalidades5'])?$_REQUEST['pCITAnormalidades5']:null;
    $pCITAnormalidades6 = isset($_REQUEST['pCITAnormalidades6'])?$_REQUEST['pCITAnormalidades6']:null;
    $pCITAnormalidadesGlandulares1 = isset($_REQUEST['pCITAnormalidadesGlandulares1'])?$_REQUEST['pCITAnormalidadesGlandulares1']:null;
    $pCITAnormalidadesGlandulares2 = isset($_REQUEST['pCITAnormalidadesGlandulares2'])?$_REQUEST['pCITAnormalidadesGlandulares2']:null;
    $pCITAnormalidadesGlandulares3 = isset($_REQUEST['pCITAnormalidadesGlandulares3'])?$_REQUEST['pCITAnormalidadesGlandulares3']:null;
    $pCITAnormalidadesGlandulares4 = isset($_REQUEST['pCITAnormalidadesGlandulares4'])?$_REQUEST['pCITAnormalidadesGlandulares4']:null;
    $pCITAnormalidadesGlandulares5 = isset($_REQUEST['pCITAnormalidadesGlandulares5'])?$_REQUEST['pCITAnormalidadesGlandulares5']:null;
    $pCITAnormalidadesGlandulares6 = isset($_REQUEST['pCITAnormalidadesGlandulares6'])?$_REQUEST['pCITAnormalidadesGlandulares6']:null;
    $pCITAnormalidadesGlandulares7 = isset($_REQUEST['pCITAnormalidadesGlandulares7'])?$_REQUEST['pCITAnormalidadesGlandulares7']:null;
    $pCITAnormalidadesGlandulares8 = isset($_REQUEST['pCITAnormalidadesGlandulares8'])?$_REQUEST['pCITAnormalidadesGlandulares8']:null;
    $pCITAnormalidadesGlandulares9 = isset($_REQUEST['pCITAnormalidadesGlandulares9'])?$_REQUEST['pCITAnormalidadesGlandulares9']:null;
    $pCITAnormalidadesGlandulares10 = isset($_REQUEST['pCITAnormalidadesGlandulares10'])?$_REQUEST['pCITAnormalidadesGlandulares10']:null;
    $pCITAnormalidadesGlandulares11 = isset($_REQUEST['pCITAnormalidadesGlandulares11'])?$_REQUEST['pCITAnormalidadesGlandulares11']:null;
    $pCITObservacionesRes = isset($_REQUEST['pCITObservacionesRes'])?$_REQUEST['pCITObservacionesRes']:null;
    $pCITProflectura = isset($_REQUEST['pCITProflectura'])?$_REQUEST['pCITProflectura']:null;
    $pCITNombreLectura = isset($_REQUEST['pCITNombreLectura'])?$_REQUEST['pCITNombreLectura']:null;
    $pCITRegistroLectura = isset($_REQUEST['pCITRegistroLectura'])?$_REQUEST['pCITRegistroLectura']:null;
    $pCITFechaLectura = isset($_REQUEST['pCITFechaLectura'])?$_REQUEST['pCITFechaLectura']:null;
    $pCITProflectura2 = isset($_REQUEST['pCITProflectura2'])?$_REQUEST['pCITProflectura2']:null;
    $pCITNombreLectura2 = isset($_REQUEST['pCITNombreLectura2'])?$_REQUEST['pCITNombreLectura2']:null;
    $pCITRegistroLectura2 = isset($_REQUEST['pCITRegistroLectura2'])?$_REQUEST['pCITRegistroLectura2']:null;
    $pCITFechaLectura2 = isset($_REQUEST['pCITFechaLectura2'])?$_REQUEST['pCITFechaLectura2']:null;
    $pCITFechaEntregaRes = isset($_REQUEST['pCITFechaEntregaRes'])?$_REQUEST['pCITFechaEntregaRes']:null;
    $pUsuario = isset($_REQUEST['pUsuario'])?$_REQUEST['pUsuario']:null;
    if($pAutorizacion == null || $pAutorizacion == ""){
        $pAutorizacion = "NA";
    }
    $pCambiaCliente = isset($_REQUEST['pCambiaCliente'])?$_REQUEST['pCambiaCliente']:"NA";
    $gBaseDatos = new ofiMySQLi();
    $gBaseDatos->conectar();
    $qry = "CALL sp_asistencial_add_evolucion('" . $pEmpresa . "','" . $pIPS . "','" . $pPaciente . "','" . $pProfesional . "','" . $pCAS . "','" . $pConsecutivoDetalle . "','" . $pidPlantillaHC . "',\"" . $pFechaAtencion . "\",\"" . $pHoraApertura . "\",\"" . $pActividad . "\",\"" . $pPlantilla . "\",\"" . $pRutaRptHC . "\",\"" . $pRutaRptMx . "\",\"" . $pRutaRptExa . "\",\"" . $pRutaRptRem . "\",\"" . $pEvolucion . "\",\"" . $pDiagppal . "\",\"" . $pDiagrel1 . "\",\"" . $pDiagrel2 . "\",\"" . $pDiagrel3 . "\",\"" . $pTipodiag . "\",\"" . $pFinalidad . "\",\"" . $pCausa . "\",\"" . $pAmbito . "\",\"" . $pFinalidadProced . "\",\"" . $pPersonalAtiende . "\",\"" . $pFormaActo . "\",'" . $pUsuario . "','" . $pIdCliente . "','" . $pIdPlan . "','" . $pIdSubPlan . "','" . $pIdContrato . "',\"" . $pAutorizacion . "\",\"" . $pCambiaCliente . "\")";
    //echo $qry;
    if(@mysqli_query($gBaseDatos->ConexionID, $qry)){
        $gBaseDatos->cerrar();
        $gBaseDatos = new ofiMySQLi();
        $gBaseDatos->conectar();
        $qry = "CALL sp_asistencial_add_evolucion_citologia('" . $pPaciente . "','" . $pCAS . "','" . $pConsecutivoDetalle . "',\"" . $pCITFecCitologia . "\",\"" . $pCITLactancia . "\",\"" . $pCITFecUltMestruacion . "\",'" . $pCITGestaciones . "','" . $pCITPartos . "','" . $pCITAbortos . "',\"" . $pCITEmbarazoActual . "\",\"" . $pCITMetodoPlanifica . "\",\"" . $pCITTiempoUso . "\",\"" . $pCITFecUltCitologia . "\",\"" . $pCITResultadoCitologia . "\",\"" . $pCITCauterizacion . "\",\"" . $pCITCauterizacionFec . "\",\"" . $pCITHisterectomia . "\",\"" . $pCITHisterectomiaFec . "\",\"" . $pCITVaporizacion . "\",\"" . $pCITVaporizacionFec . "\",\"" . $pCITConizacion . "\",\"" . $pCITConizacionFec . "\",\"" . $pCITCrioterapia . "\",\"" . $pCITCrioterapiaFec . "\",\"" . $pCITRadioterapia . "\",\"" . $pCITRadioterapiaFec . "\",\"" . $pCITTtoHormonal . "\",\"" . $pCITTtoHormonalFec . "\",\"" . $pCITBiopsia . "\",\"" . $pCITBiopsiaFec . "\",\"" . $pCITColposcopia . "\",\"" . $pCITColposcopiaFec . "\",\"" . $pCITAusente . "\",\"" . $pCITSano . "\",\"" . $pCITAtrofico . "\",\"" . $pCITCongestivo . "\",\"" . $pCITUlcerado . "\",\"" . $pCITPolipo . "\",\"" . $pCITMasa . "\",\"" . $pCITObservacionesToma . "\",\"" . $pCITCalidad1 . "\",\"" . $pCITCalidad2 . "\",\"" . $pCITCalidad3 . "\",\"" . $pCITCalidad4 . "\",\"" . $pCITCausa . "\",\"" . $pCITCategorizacion1 . "\",\"" . $pCITCategorizacion2 . "\",\"" . $pCITMicroorganismos1 . "\",\"" . $pCITMicroorganismos2 . "\",\"" . $pCITMicroorganismos3 . "\",\"" . $pCITMicroorganismos4 . "\",\"" . $pCITMicroorganismos5 . "\",\"" . $pCITMicroorganismos6 . "\",\"" . $pCITOtrosHallazgos1 . "\",\"" . $pCITOtrosHallazgos2 . "\",\"" . $pCITOtrosHallazgos3 . "\",\"" . $pCITOtrosHallazgos4 . "\",\"" . $pCITOtrosHallazgos5 . "\",\"" . $pCITOtrosHallazgos6 . "\",\"" . $pCITAnormalidades1 . "\",\"" . $pCITAnormalidades2 . "\",\"" . $pCITAnormalidades3 . "\",\"" . $pCITAnormalidades4 . "\",\"" . $pCITAnormalidades5 . "\",\"" . $pCITAnormalidades6 . "\",\"" . $pCITAnormalidadesGlandulares1 . "\",\"" . $pCITAnormalidadesGlandulares2 . "\",\"" . $pCITAnormalidadesGlandulares3 . "\",\"" . $pCITAnormalidadesGlandulares4 . "\",\"" . $pCITAnormalidadesGlandulares5 . "\",\"" . $pCITAnormalidadesGlandulares6 . "\",\"" . $pCITAnormalidadesGlandulares7 . "\",\"" . $pCITAnormalidadesGlandulares8 . "\",\"" . $pCITAnormalidadesGlandulares9 . "\",\"" . $pCITAnormalidadesGlandulares10 . "\",\"" . $pCITAnormalidadesGlandulares11 . "\",\"" . $pCITObservacionesRes . "\",\"" . $pCITProflectura . "\",\"" . $pCITNombreLectura . "\",\"" . $pCITRegistroLectura . "\",\"" . $pCITFechaLectura . "\",\"" . $pCITProflectura2 . "\",\"" . $pCITNombreLectura2 . "\",\"" . $pCITRegistroLectura2 . "\",\"" . $pCITFechaLectura2 . "\",\"" . $pCITFechaEntregaRes . "\",'" . $pUsuario . "')";
        //echo $qry;
        if(@mysqli_query($gBaseDatos->ConexionID, $qry)){
            echo "{success: true, requestedId:'1'}";
            $gBaseDatos->cerrar();
        }else{
            echo "{success: true, requestedId:'0'}";
            $gBaseDatos->cerrar();
        }
    }else{
       echo "{success: true, requestedId:'0'}";
       $gBaseDatos->cerrar();
    }
}

function ModificarTomaCitologia()
{

    $pEmpresa = isset($_REQUEST['pEmpresa'])?$_REQUEST['pEmpresa']:0;
    $pIPS = isset($_REQUEST['pIPS'])?$_REQUEST['pIPS']:0;
    $pPaciente = isset($_REQUEST['pPaciente'])?$_REQUEST['pPaciente']:0;
    //$pProfesional = isset($_REQUEST['pProfesional'])?$_REQUEST['pProfesional']:0;
    $pProfesional = $_SESSION['ID_PROFESIONAL_HC'];
    $pCAS = isset($_REQUEST['pCAS'])?$_REQUEST['pCAS']:0;
    $pConsecutivoDetalle = isset($_REQUEST['pConsecutivoDetalle'])?$_REQUEST['pConsecutivoDetalle']:0;
    $pFechaAtencion = isset($_REQUEST['pFechaAtencion'])?$_REQUEST['pFechaAtencion']:null;
    $pHoraApertura = isset($_REQUEST['pHoraApertura'])?$_REQUEST['pHoraApertura']:null;
    $pActividad = isset($_REQUEST['pActividad'])?$_REQUEST['pActividad']:null;
    $pPlantilla = isset($_REQUEST['pPlantilla'])?$_REQUEST['pPlantilla']:null;
    $pRutaRptHC = isset($_REQUEST['pRutaRptHC'])?$_REQUEST['pRutaRptHC']:null;
    $pRutaRptMx = isset($_REQUEST['pRutaRptMx'])?$_REQUEST['pRutaRptMx']:null;
    $pRutaRptExa = isset($_REQUEST['pRutaRptExa'])?$_REQUEST['pRutaRptExa']:null;
    $pRutaRptRem = isset($_REQUEST['pRutaRptRem'])?$_REQUEST['pRutaRptRem']:null;
    $contenido = isset($_REQUEST['CAMPOS'])?$_REQUEST['CAMPOS']:null;
    $pEvolucion = utf8_encode(str_replace('"', '""',nl2br($contenido)));
    $pDiagppal = isset($_REQUEST['pDiagppal'])?$_REQUEST['pDiagppal']:null;
    $pDiagrel1 = isset($_REQUEST['pDiagrel1'])?$_REQUEST['pDiagrel1']:null;
    $pDiagrel2 = isset($_REQUEST['pDiagrel2'])?$_REQUEST['pDiagrel2']:null;
    $pDiagrel3 = isset($_REQUEST['pDiagrel3'])?$_REQUEST['pDiagrel3']:null;
    $pTipodiag = isset($_REQUEST['pTipodiag'])?$_REQUEST['pTipodiag']:null;
    $pFinalidad = isset($_REQUEST['pFinalidad'])?$_REQUEST['pFinalidad']:null;
    $pCausa = isset($_REQUEST['pCausa'])?$_REQUEST['pCausa']:null;
    $pAmbito = isset($_REQUEST['pAmbito'])?$_REQUEST['pAmbito']:null;
    $pFinalidadProced = isset($_REQUEST['pFinalidadProced'])?$_REQUEST['pFinalidadProced']:null;
    $pPersonalAtiende = isset($_REQUEST['pPersonalAtiende'])?$_REQUEST['pPersonalAtiende']:null;
    $pFormaActo = isset($_REQUEST['pFormaActo'])?$_REQUEST['pFormaActo']:null;
    $pUsuario = isset($_REQUEST['pUsuario'])?$_REQUEST['pUsuario']:0;
    $pIdCliente = isset($_REQUEST['pIdCliente'])?$_REQUEST['pIdCliente']:0;
    $pIdPlan = isset($_REQUEST['pIdPlan'])?$_REQUEST['pIdPlan']:0;
    $pIdSubPlan = isset($_REQUEST['pIdSubPlan'])?$_REQUEST['pIdSubPlan']:0;
    $pIdContrato = isset($_REQUEST['pIdContrato'])?$_REQUEST['pIdContrato']:0;
    $pAutorizacion = isset($_REQUEST['pAutorizacion'])?$_REQUEST['pAutorizacion']:null;
    $pCITFecCitologia = isset($_REQUEST['pCITFecCitologia'])?$_REQUEST['pCITFecCitologia']:null;
    $pCITLactancia = isset($_REQUEST['pCITLactancia'])?$_REQUEST['pCITLactancia']:null;
    $pCITFecUltMestruacion = isset($_REQUEST['pCITFecUltMestruacion'])?$_REQUEST['pCITFecUltMestruacion']:null;
    $pCITGestaciones = isset($_REQUEST['pCITGestaciones'])?$_REQUEST['pCITGestaciones']:null;
    $pCITPartos = isset($_REQUEST['pCITPartos'])?$_REQUEST['pCITPartos']:null;
    $pCITAbortos = isset($_REQUEST['pCITAbortos'])?$_REQUEST['pCITAbortos']:null;
    $pCITEmbarazoActual = isset($_REQUEST['pCITEmbarazoActual'])?$_REQUEST['pCITEmbarazoActual']:null;
    $pCITMetodoPlanifica = isset($_REQUEST['pCITMetodoPlanifica'])?$_REQUEST['pCITMetodoPlanifica']:null;
    $pCITTiempoUso = isset($_REQUEST['pCITTiempoUso'])?$_REQUEST['pCITTiempoUso']:null;
    $pCITFecUltCitologia = isset($_REQUEST['pCITFecUltCitologia'])?$_REQUEST['pCITFecUltCitologia']:null;
    $pCITResultadoCitologia = isset($_REQUEST['pCITResultadoCitologia'])?$_REQUEST['pCITResultadoCitologia']:null;
    $pCITCauterizacion = isset($_REQUEST['pCITCauterizacion'])?$_REQUEST['pCITCauterizacion']:null;
    $pCITCauterizacionFec = isset($_REQUEST['pCITCauterizacionFec'])?$_REQUEST['pCITCauterizacionFec']:null;
    $pCITHisterectomia = isset($_REQUEST['pCITHisterectomia'])?$_REQUEST['pCITHisterectomia']:null;
    $pCITHisterectomiaFec = isset($_REQUEST['pCITHisterectomiaFec'])?$_REQUEST['pCITHisterectomiaFec']:null;
    $pCITVaporizacion = isset($_REQUEST['pCITVaporizacion'])?$_REQUEST['pCITVaporizacion']:null;
    $pCITVaporizacionFec = isset($_REQUEST['pCITVaporizacionFec'])?$_REQUEST['pCITVaporizacionFec']:null;
    $pCITConizacion = isset($_REQUEST['pCITConizacion'])?$_REQUEST['pCITConizacion']:null;
    $pCITConizacionFec = isset($_REQUEST['pCITConizacionFec'])?$_REQUEST['pCITConizacionFec']:null;
    $pCITCrioterapia = isset($_REQUEST['pCITCrioterapia'])?$_REQUEST['pCITCrioterapia']:null;
    $pCITCrioterapiaFec = isset($_REQUEST['pCITCrioterapiaFec'])?$_REQUEST['pCITCrioterapiaFec']:null;
    $pCITRadioterapia = isset($_REQUEST['pCITRadioterapia'])?$_REQUEST['pCITRadioterapia']:null;
    $pCITRadioterapiaFec = isset($_REQUEST['pCITRadioterapiaFec'])?$_REQUEST['pCITRadioterapiaFec']:null;
    $pCITTtoHormonal = isset($_REQUEST['pCITTtoHormonal'])?$_REQUEST['pCITTtoHormonal']:null;
    $pCITTtoHormonalFec = isset($_REQUEST['pCITTtoHormonalFec'])?$_REQUEST['pCITTtoHormonalFec']:null;
    $pCITBiopsia = isset($_REQUEST['pCITBiopsia'])?$_REQUEST['pCITBiopsia']:null;
    $pCITBiopsiaFec = isset($_REQUEST['pCITBiopsiaFec'])?$_REQUEST['pCITBiopsiaFec']:null;
    $pCITColposcopia = isset($_REQUEST['pCITColposcopia'])?$_REQUEST['pCITColposcopia']:null;
    $pCITColposcopiaFec = isset($_REQUEST['pCITColposcopiaFec'])?$_REQUEST['pCITColposcopiaFec']:null;
    $pCITAusente = isset($_REQUEST['pCITAusente'])?$_REQUEST['pCITAusente']:null;
    $pCITSano = isset($_REQUEST['pCITSano'])?$_REQUEST['pCITSano']:null;
    $pCITAtrofico = isset($_REQUEST['pCITAtrofico'])?$_REQUEST['pCITAtrofico']:null;
    $pCITCongestivo = isset($_REQUEST['pCITCongestivo'])?$_REQUEST['pCITCongestivo']:null;
    $pCITUlcerado = isset($_REQUEST['pCITUlcerado'])?$_REQUEST['pCITUlcerado']:null;
    $pCITPolipo = isset($_REQUEST['pCITPolipo'])?$_REQUEST['pCITPolipo']:null;
    $pCITMasa = isset($_REQUEST['pCITMasa'])?$_REQUEST['pCITMasa']:null;
    $pCITObservacionesToma = isset($_REQUEST['pCITObservacionesToma'])?$_REQUEST['pCITObservacionesToma']:null;
    $pCITCalidad1 = isset($_REQUEST['pCITCalidad1'])?$_REQUEST['pCITCalidad1']:null;
    $pCITCalidad2 = isset($_REQUEST['pCITCalidad2'])?$_REQUEST['pCITCalidad2']:null;
    $pCITCalidad3 = isset($_REQUEST['pCITCalidad3'])?$_REQUEST['pCITCalidad3']:null;
    $pCITCalidad4 = isset($_REQUEST['pCITCalidad4'])?$_REQUEST['pCITCalidad4']:null;
    $pCITCausa = isset($_REQUEST['pCITCausa'])?$_REQUEST['pCITCausa']:null;
    $pCITCategorizacion1 = isset($_REQUEST['pCITCategorizacion1'])?$_REQUEST['pCITCategorizacion1']:null;
    $pCITCategorizacion2 = isset($_REQUEST['pCITCategorizacion2'])?$_REQUEST['pCITCategorizacion2']:null;
    $pCITMicroorganismos1 = isset($_REQUEST['pCITMicroorganismos1'])?$_REQUEST['pCITMicroorganismos1']:null;
    $pCITMicroorganismos2 = isset($_REQUEST['pCITMicroorganismos2'])?$_REQUEST['pCITMicroorganismos2']:null;
    $pCITMicroorganismos3 = isset($_REQUEST['pCITMicroorganismos3'])?$_REQUEST['pCITMicroorganismos3']:null;
    $pCITMicroorganismos4 = isset($_REQUEST['pCITMicroorganismos4'])?$_REQUEST['pCITMicroorganismos4']:null;
    $pCITMicroorganismos5 = isset($_REQUEST['pCITMicroorganismos5'])?$_REQUEST['pCITMicroorganismos5']:null;
    $pCITMicroorganismos6 = isset($_REQUEST['pCITMicroorganismos6'])?$_REQUEST['pCITMicroorganismos6']:null;
    $pCITOtrosHallazgos1 = isset($_REQUEST['pCITOtrosHallazgos1'])?$_REQUEST['pCITOtrosHallazgos1']:null;
    $pCITOtrosHallazgos2 = isset($_REQUEST['pCITOtrosHallazgos2'])?$_REQUEST['pCITOtrosHallazgos2']:null;
    $pCITOtrosHallazgos3 = isset($_REQUEST['pCITOtrosHallazgos3'])?$_REQUEST['pCITOtrosHallazgos3']:null;
    $pCITOtrosHallazgos4 = isset($_REQUEST['pCITOtrosHallazgos4'])?$_REQUEST['pCITOtrosHallazgos4']:null;
    $pCITOtrosHallazgos5 = isset($_REQUEST['pCITOtrosHallazgos5'])?$_REQUEST['pCITOtrosHallazgos5']:null;
    $pCITOtrosHallazgos6 = isset($_REQUEST['pCITOtrosHallazgos6'])?$_REQUEST['pCITOtrosHallazgos6']:null;
    $pCITAnormalidades1 = isset($_REQUEST['pCITAnormalidades1'])?$_REQUEST['pCITAnormalidades1']:null;
    $pCITAnormalidades2 = isset($_REQUEST['pCITAnormalidades2'])?$_REQUEST['pCITAnormalidades2']:null;
    $pCITAnormalidades3 = isset($_REQUEST['pCITAnormalidades3'])?$_REQUEST['pCITAnormalidades3']:null;
    $pCITAnormalidades4 = isset($_REQUEST['pCITAnormalidades4'])?$_REQUEST['pCITAnormalidades4']:null;
    $pCITAnormalidades5 = isset($_REQUEST['pCITAnormalidades5'])?$_REQUEST['pCITAnormalidades5']:null;
    $pCITAnormalidades6 = isset($_REQUEST['pCITAnormalidades6'])?$_REQUEST['pCITAnormalidades6']:null;
    $pCITAnormalidadesGlandulares1 = isset($_REQUEST['pCITAnormalidadesGlandulares1'])?$_REQUEST['pCITAnormalidadesGlandulares1']:null;
    $pCITAnormalidadesGlandulares2 = isset($_REQUEST['pCITAnormalidadesGlandulares2'])?$_REQUEST['pCITAnormalidadesGlandulares2']:null;
    $pCITAnormalidadesGlandulares3 = isset($_REQUEST['pCITAnormalidadesGlandulares3'])?$_REQUEST['pCITAnormalidadesGlandulares3']:null;
    $pCITAnormalidadesGlandulares4 = isset($_REQUEST['pCITAnormalidadesGlandulares4'])?$_REQUEST['pCITAnormalidadesGlandulares4']:null;
    $pCITAnormalidadesGlandulares5 = isset($_REQUEST['pCITAnormalidadesGlandulares5'])?$_REQUEST['pCITAnormalidadesGlandulares5']:null;
    $pCITAnormalidadesGlandulares6 = isset($_REQUEST['pCITAnormalidadesGlandulares6'])?$_REQUEST['pCITAnormalidadesGlandulares6']:null;
    $pCITAnormalidadesGlandulares7 = isset($_REQUEST['pCITAnormalidadesGlandulares7'])?$_REQUEST['pCITAnormalidadesGlandulares7']:null;
    $pCITAnormalidadesGlandulares8 = isset($_REQUEST['pCITAnormalidadesGlandulares8'])?$_REQUEST['pCITAnormalidadesGlandulares8']:null;
    $pCITAnormalidadesGlandulares9 = isset($_REQUEST['pCITAnormalidadesGlandulares9'])?$_REQUEST['pCITAnormalidadesGlandulares9']:null;
    $pCITAnormalidadesGlandulares10 = isset($_REQUEST['pCITAnormalidadesGlandulares10'])?$_REQUEST['pCITAnormalidadesGlandulares10']:null;
    $pCITAnormalidadesGlandulares11 = isset($_REQUEST['pCITAnormalidadesGlandulares11'])?$_REQUEST['pCITAnormalidadesGlandulares11']:null;
    $pCITObservacionesRes = isset($_REQUEST['pCITObservacionesRes'])?$_REQUEST['pCITObservacionesRes']:null;
    $pCITProflectura = isset($_REQUEST['pCITProflectura'])?$_REQUEST['pCITProflectura']:null;
    $pCITNombreLectura = isset($_REQUEST['pCITNombreLectura'])?$_REQUEST['pCITNombreLectura']:null;
    $pCITRegistroLectura = isset($_REQUEST['pCITRegistroLectura'])?$_REQUEST['pCITRegistroLectura']:null;
    $pCITFechaLectura = isset($_REQUEST['pCITFechaLectura'])?$_REQUEST['pCITFechaLectura']:null;
    $pCITProflectura2 = isset($_REQUEST['pCITProflectura2'])?$_REQUEST['pCITProflectura2']:null;
    $pCITNombreLectura2 = isset($_REQUEST['pCITNombreLectura2'])?$_REQUEST['pCITNombreLectura2']:null;
    $pCITRegistroLectura2 = isset($_REQUEST['pCITRegistroLectura2'])?$_REQUEST['pCITRegistroLectura2']:null;
    $pCITFechaLectura2 = isset($_REQUEST['pCITFechaLectura2'])?$_REQUEST['pCITFechaLectura2']:null;
    $pCITFechaEntregaRes = isset($_REQUEST['pCITFechaEntregaRes'])?$_REQUEST['pCITFechaEntregaRes']:null;
    $pUsuario = isset($_REQUEST['pUsuario'])?$_REQUEST['pUsuario']:null;
    if($pAutorizacion == null || $pAutorizacion == ""){
        $pAutorizacion = "NA";
    }
    $pCambiaCliente = isset($_REQUEST['pCambiaCliente'])?$_REQUEST['pCambiaCliente']:"NA";
    $gBaseDatos = new ofiMySQLi();
    $gBaseDatos->conectar();
    $qry = "CALL sp_asistencial_edit_evolucion('" . $pEmpresa . "','" . $pIPS . "','" . $pPaciente . "','" . $pProfesional . "','" . $pCAS . "','" . $pConsecutivoDetalle . "',\"" . $pFechaAtencion . "\",\"" . $pHoraApertura . "\",\"" . $pActividad . "\",\"" . $pPlantilla . "\",\"" . $pEvolucion . "\",\"" . $pDiagppal . "\",\"" . $pDiagrel1 . "\",\"" . $pDiagrel2 . "\",\"" . $pDiagrel3 . "\",\"" . $pTipodiag . "\",\"" . $pFinalidad . "\",\"" . $pCausa . "\",\"" . $pAmbito . "\",\"" . $pFinalidadProced . "\",\"" . $pPersonalAtiende . "\",\"" . $pFormaActo . "\",'" . $pUsuario . "','" . $pIdCliente . "','" . $pIdPlan . "','" . $pIdSubPlan . "','" . $pIdContrato . "',\"" . $pAutorizacion . "\",\"" . $pCambiaCliente . "\")";
    //echo $qry;
    if(@mysqli_query($gBaseDatos->ConexionID, $qry)){
        $gBaseDatos->cerrar();
        $gBaseDatos = new ofiMySQLi();
        $gBaseDatos->conectar();
        $qry = "CALL sp_asistencial_edit_evolucion_citologia('" . $pPaciente . "','" . $pCAS . "','" . $pConsecutivoDetalle . "',\"" . $pCITFecCitologia . "\",\"" . $pCITLactancia . "\",\"" . $pCITFecUltMestruacion . "\",'" . $pCITGestaciones . "','" . $pCITPartos . "','" . $pCITAbortos . "',\"" . $pCITEmbarazoActual . "\",\"" . $pCITMetodoPlanifica . "\",\"" . $pCITTiempoUso . "\",\"" . $pCITFecUltCitologia . "\",\"" . $pCITResultadoCitologia . "\",\"" . $pCITCauterizacion . "\",\"" . $pCITCauterizacionFec . "\",\"" . $pCITHisterectomia . "\",\"" . $pCITHisterectomiaFec . "\",\"" . $pCITVaporizacion . "\",\"" . $pCITVaporizacionFec . "\",\"" . $pCITConizacion . "\",\"" . $pCITConizacionFec . "\",\"" . $pCITCrioterapia . "\",\"" . $pCITCrioterapiaFec . "\",\"" . $pCITRadioterapia . "\",\"" . $pCITRadioterapiaFec . "\",\"" . $pCITTtoHormonal . "\",\"" . $pCITTtoHormonalFec . "\",\"" . $pCITBiopsia . "\",\"" . $pCITBiopsiaFec . "\",\"" . $pCITColposcopia . "\",\"" . $pCITColposcopiaFec . "\",\"" . $pCITAusente . "\",\"" . $pCITSano . "\",\"" . $pCITAtrofico . "\",\"" . $pCITCongestivo . "\",\"" . $pCITUlcerado . "\",\"" . $pCITPolipo . "\",\"" . $pCITMasa . "\",\"" . $pCITObservacionesToma . "\",\"" . $pCITCalidad1 . "\",\"" . $pCITCalidad2 . "\",\"" . $pCITCalidad3 . "\",\"" . $pCITCalidad4 . "\",\"" . $pCITCausa . "\",\"" . $pCITCategorizacion1 . "\",\"" . $pCITCategorizacion2 . "\",\"" . $pCITMicroorganismos1 . "\",\"" . $pCITMicroorganismos2 . "\",\"" . $pCITMicroorganismos3 . "\",\"" . $pCITMicroorganismos4 . "\",\"" . $pCITMicroorganismos5 . "\",\"" . $pCITMicroorganismos6 . "\",\"" . $pCITOtrosHallazgos1 . "\",\"" . $pCITOtrosHallazgos2 . "\",\"" . $pCITOtrosHallazgos3 . "\",\"" . $pCITOtrosHallazgos4 . "\",\"" . $pCITOtrosHallazgos5 . "\",\"" . $pCITOtrosHallazgos6 . "\",\"" . $pCITAnormalidades1 . "\",\"" . $pCITAnormalidades2 . "\",\"" . $pCITAnormalidades3 . "\",\"" . $pCITAnormalidades4 . "\",\"" . $pCITAnormalidades5 . "\",\"" . $pCITAnormalidades6 . "\",\"" . $pCITAnormalidadesGlandulares1 . "\",\"" . $pCITAnormalidadesGlandulares2 . "\",\"" . $pCITAnormalidadesGlandulares3 . "\",\"" . $pCITAnormalidadesGlandulares4 . "\",\"" . $pCITAnormalidadesGlandulares5 . "\",\"" . $pCITAnormalidadesGlandulares6 . "\",\"" . $pCITAnormalidadesGlandulares7 . "\",\"" . $pCITAnormalidadesGlandulares8 . "\",\"" . $pCITAnormalidadesGlandulares9 . "\",\"" . $pCITAnormalidadesGlandulares10 . "\",\"" . $pCITAnormalidadesGlandulares11 . "\",\"" . $pCITObservacionesRes . "\",\"" . $pCITProflectura . "\",\"" . $pCITNombreLectura . "\",\"" . $pCITRegistroLectura . "\",\"" . $pCITFechaLectura . "\",\"" . $pCITProflectura2 . "\",\"" . $pCITNombreLectura2 . "\",\"" . $pCITRegistroLectura2 . "\",\"" . $pCITFechaLectura2 . "\",\"" . $pCITFechaEntregaRes . "\",'" . $pUsuario . "')";
        if(@mysqli_query($gBaseDatos->ConexionID, $qry)){
            echo "{success: true, requestedId:'1'}";
            $gBaseDatos->cerrar();
        }
    }else{
       echo "{success: true, requestedId:'0'}";
        $gBaseDatos->cerrar();
    }
}*/ //Funciones Hasta Dic2013

function GuardarTomaCitologia()
{
    
    $pEmpresa = isset($_REQUEST['pEmpresa'])?$_REQUEST['pEmpresa']:0;
    $pIPS = isset($_REQUEST['pIPS'])?$_REQUEST['pIPS']:0;
    $pPaciente = isset($_REQUEST['pPaciente'])?$_REQUEST['pPaciente']:0;
    $pProfesional = $_SESSION['ID_PROFESIONAL_HC'];
    $pCAS = isset($_REQUEST['pCAS'])?$_REQUEST['pCAS']:0;
    $pConsecutivoDetalle = isset($_REQUEST['pConsecutivoDetalle'])?$_REQUEST['pConsecutivoDetalle']:0;
    $pidPlantillaHC = isset($_REQUEST['pidPlantillaHC'])?$_REQUEST['pidPlantillaHC']:0;
    $pFechaAtencion = isset($_REQUEST['pFechaAtencion'])?$_REQUEST['pFechaAtencion']:null;
    $pHoraApertura = isset($_REQUEST['pHoraApertura'])?$_REQUEST['pHoraApertura']:null;
    $pActividad = isset($_REQUEST['pActividad'])?$_REQUEST['pActividad']:null;
    $pPlantilla = isset($_REQUEST['pPlantilla'])?$_REQUEST['pPlantilla']:null;
    $pRutaRptHC = isset($_REQUEST['pRutaRptHC'])?$_REQUEST['pRutaRptHC']:null;
    $pRutaRptMx = isset($_REQUEST['pRutaRptMx'])?$_REQUEST['pRutaRptMx']:null;
    $pRutaRptExa = isset($_REQUEST['pRutaRptExa'])?$_REQUEST['pRutaRptExa']:null;
    $pRutaRptRem = isset($_REQUEST['pRutaRptRem'])?$_REQUEST['pRutaRptRem']:null;
    $contenido = isset($_REQUEST['CAMPOS'])?$_REQUEST['CAMPOS']:null;
    $pEvolucion = utf8_encode(str_replace('"', '""',nl2br($contenido)));
    $pDiagppal = isset($_REQUEST['pDiagppal'])?$_REQUEST['pDiagppal']:null;
    $pDiagrel1 = isset($_REQUEST['pDiagrel1'])?$_REQUEST['pDiagrel1']:null;
    $pDiagrel2 = isset($_REQUEST['pDiagrel2'])?$_REQUEST['pDiagrel2']:null;
    $pDiagrel3 = isset($_REQUEST['pDiagrel3'])?$_REQUEST['pDiagrel3']:null;
    $pTipodiag = isset($_REQUEST['pTipodiag'])?$_REQUEST['pTipodiag']:null;
    $pFinalidad = isset($_REQUEST['pFinalidad'])?$_REQUEST['pFinalidad']:null;
    $pCausa = isset($_REQUEST['pCausa'])?$_REQUEST['pCausa']:null;
    $pAmbito = isset($_REQUEST['pAmbito'])?$_REQUEST['pAmbito']:null;
    $pFinalidadProced = isset($_REQUEST['pFinalidadProced'])?$_REQUEST['pFinalidadProced']:null;
    $pPersonalAtiende = isset($_REQUEST['pPersonalAtiende'])?$_REQUEST['pPersonalAtiende']:null;
    $pFormaActo = isset($_REQUEST['pFormaActo'])?$_REQUEST['pFormaActo']:null;
    $pUsuario = isset($_REQUEST['pUsuario'])?$_REQUEST['pUsuario']:0;
    $pIdCliente = isset($_REQUEST['pIdCliente'])?$_REQUEST['pIdCliente']:0;
    $pIdPlan = isset($_REQUEST['pIdPlan'])?$_REQUEST['pIdPlan']:0;
    $pIdSubPlan = isset($_REQUEST['pIdSubPlan'])?$_REQUEST['pIdSubPlan']:0;
    $pIdContrato = isset($_REQUEST['pIdContrato'])?$_REQUEST['pIdContrato']:0;
    $pAutorizacion = isset($_REQUEST['pAutorizacion'])?$_REQUEST['pAutorizacion']:null;
    $pCITFecCitologia = isset($_REQUEST['pCITFecCitologia'])?$_REQUEST['pCITFecCitologia']:null;
    $pCITLactancia = isset($_REQUEST['pCITLactancia'])?$_REQUEST['pCITLactancia']:null;
    $pCITFecUltMestruacion = isset($_REQUEST['pCITFecUltMestruacion'])?$_REQUEST['pCITFecUltMestruacion']:null;
    $pCITGestaciones = isset($_REQUEST['pCITGestaciones'])?$_REQUEST['pCITGestaciones']:null;
    $pCITPartos = isset($_REQUEST['pCITPartos'])?$_REQUEST['pCITPartos']:null;
    $pCITAbortos = isset($_REQUEST['pCITAbortos'])?$_REQUEST['pCITAbortos']:null;
    $pCITEmbarazoActual = isset($_REQUEST['pCITEmbarazoActual'])?$_REQUEST['pCITEmbarazoActual']:null;
    $pCITMetodoPlanifica = isset($_REQUEST['pCITMetodoPlanifica'])?$_REQUEST['pCITMetodoPlanifica']:null;
    $pCITTiempoUso = isset($_REQUEST['pCITTiempoUso'])?$_REQUEST['pCITTiempoUso']:null;
    $pCITFecUltCitologia = isset($_REQUEST['pCITFecUltCitologia'])?$_REQUEST['pCITFecUltCitologia']:null;
    $pCITResultadoCitologia = isset($_REQUEST['pCITResultadoCitologia'])?$_REQUEST['pCITResultadoCitologia']:null;
    $pCITCauterizacion = isset($_REQUEST['pCITCauterizacion'])?$_REQUEST['pCITCauterizacion']:null;
    $pCITCauterizacionFec = isset($_REQUEST['pCITCauterizacionFec'])?$_REQUEST['pCITCauterizacionFec']:null;
    $pCITHisterectomia = isset($_REQUEST['pCITHisterectomia'])?$_REQUEST['pCITHisterectomia']:null;
    $pCITHisterectomiaFec = isset($_REQUEST['pCITHisterectomiaFec'])?$_REQUEST['pCITHisterectomiaFec']:null;
    $pCITVaporizacion = isset($_REQUEST['pCITVaporizacion'])?$_REQUEST['pCITVaporizacion']:null;
    $pCITVaporizacionFec = isset($_REQUEST['pCITVaporizacionFec'])?$_REQUEST['pCITVaporizacionFec']:null;
    $pCITConizacion = isset($_REQUEST['pCITConizacion'])?$_REQUEST['pCITConizacion']:null;
    $pCITConizacionFec = isset($_REQUEST['pCITConizacionFec'])?$_REQUEST['pCITConizacionFec']:null;
    $pCITCrioterapia = isset($_REQUEST['pCITCrioterapia'])?$_REQUEST['pCITCrioterapia']:null;
    $pCITCrioterapiaFec = isset($_REQUEST['pCITCrioterapiaFec'])?$_REQUEST['pCITCrioterapiaFec']:null;
    $pCITRadioterapia = isset($_REQUEST['pCITRadioterapia'])?$_REQUEST['pCITRadioterapia']:null;
    $pCITRadioterapiaFec = isset($_REQUEST['pCITRadioterapiaFec'])?$_REQUEST['pCITRadioterapiaFec']:null;
    $pCITTtoHormonal = isset($_REQUEST['pCITTtoHormonal'])?$_REQUEST['pCITTtoHormonal']:null;
    $pCITTtoHormonalFec = isset($_REQUEST['pCITTtoHormonalFec'])?$_REQUEST['pCITTtoHormonalFec']:null;
    $pCITBiopsia = isset($_REQUEST['pCITBiopsia'])?$_REQUEST['pCITBiopsia']:null;
    $pCITBiopsiaFec = isset($_REQUEST['pCITBiopsiaFec'])?$_REQUEST['pCITBiopsiaFec']:null;
    $pCITColposcopia = isset($_REQUEST['pCITColposcopia'])?$_REQUEST['pCITColposcopia']:null;
    $pCITColposcopiaFec = isset($_REQUEST['pCITColposcopiaFec'])?$_REQUEST['pCITColposcopiaFec']:null;
    $pCITAusente = isset($_REQUEST['pCITAusente'])?$_REQUEST['pCITAusente']:null;
    $pCITSano = isset($_REQUEST['pCITSano'])?$_REQUEST['pCITSano']:null;
    $pCITAtrofico = isset($_REQUEST['pCITAtrofico'])?$_REQUEST['pCITAtrofico']:null;
    $pCITCongestivo = isset($_REQUEST['pCITCongestivo'])?$_REQUEST['pCITCongestivo']:null;
    $pCITUlcerado = isset($_REQUEST['pCITUlcerado'])?$_REQUEST['pCITUlcerado']:null;
    $pCITPolipo = isset($_REQUEST['pCITPolipo'])?$_REQUEST['pCITPolipo']:null;
    $pCITMasa = isset($_REQUEST['pCITMasa'])?$_REQUEST['pCITMasa']:null;
    $pCITObservacionesToma = isset($_REQUEST['pCITObservacionesToma'])?$_REQUEST['pCITObservacionesToma']:null;
    $pCITCalidad1 = isset($_REQUEST['pCITCalidad1'])?$_REQUEST['pCITCalidad1']:null;
    $pCITCalidad2 = isset($_REQUEST['pCITCalidad2'])?$_REQUEST['pCITCalidad2']:null;
    $pCITCalidad3 = isset($_REQUEST['pCITCalidad3'])?$_REQUEST['pCITCalidad3']:null;
    $pCITCalidad4 = isset($_REQUEST['pCITCalidad4'])?$_REQUEST['pCITCalidad4']:null;
    $pCITCausa = isset($_REQUEST['pCITCausa'])?$_REQUEST['pCITCausa']:null;
    $pCITCategorizacion1 = isset($_REQUEST['pCITCategorizacion1'])?$_REQUEST['pCITCategorizacion1']:null;
    $pCITCategorizacion2 = isset($_REQUEST['pCITCategorizacion2'])?$_REQUEST['pCITCategorizacion2']:null;
    $pCITMicroorganismos1 = isset($_REQUEST['pCITMicroorganismos1'])?$_REQUEST['pCITMicroorganismos1']:null;
    $pCITMicroorganismos2 = isset($_REQUEST['pCITMicroorganismos2'])?$_REQUEST['pCITMicroorganismos2']:null;
    $pCITMicroorganismos3 = isset($_REQUEST['pCITMicroorganismos3'])?$_REQUEST['pCITMicroorganismos3']:null;
    $pCITMicroorganismos4 = isset($_REQUEST['pCITMicroorganismos4'])?$_REQUEST['pCITMicroorganismos4']:null;
    $pCITMicroorganismos5 = isset($_REQUEST['pCITMicroorganismos5'])?$_REQUEST['pCITMicroorganismos5']:null;
    $pCITMicroorganismos6 = isset($_REQUEST['pCITMicroorganismos6'])?$_REQUEST['pCITMicroorganismos6']:null;
    $pCITOtrosHallazgos1 = isset($_REQUEST['pCITOtrosHallazgos1'])?$_REQUEST['pCITOtrosHallazgos1']:null;
    $pCITOtrosHallazgos2 = isset($_REQUEST['pCITOtrosHallazgos2'])?$_REQUEST['pCITOtrosHallazgos2']:null;
    $pCITOtrosHallazgos3 = isset($_REQUEST['pCITOtrosHallazgos3'])?$_REQUEST['pCITOtrosHallazgos3']:null;
    $pCITOtrosHallazgos4 = isset($_REQUEST['pCITOtrosHallazgos4'])?$_REQUEST['pCITOtrosHallazgos4']:null;
    $pCITOtrosHallazgos5 = isset($_REQUEST['pCITOtrosHallazgos5'])?$_REQUEST['pCITOtrosHallazgos5']:null;
    $pCITOtrosHallazgos6 = isset($_REQUEST['pCITOtrosHallazgos6'])?$_REQUEST['pCITOtrosHallazgos6']:null;
    $pCITAnormalidades1 = isset($_REQUEST['pCITAnormalidades1'])?$_REQUEST['pCITAnormalidades1']:null;
    $pCITAnormalidades2 = isset($_REQUEST['pCITAnormalidades2'])?$_REQUEST['pCITAnormalidades2']:null;
    $pCITAnormalidades3 = isset($_REQUEST['pCITAnormalidades3'])?$_REQUEST['pCITAnormalidades3']:null;
    $pCITAnormalidades4 = isset($_REQUEST['pCITAnormalidades4'])?$_REQUEST['pCITAnormalidades4']:null;
    $pCITAnormalidades5 = isset($_REQUEST['pCITAnormalidades5'])?$_REQUEST['pCITAnormalidades5']:null;
    $pCITAnormalidades6 = isset($_REQUEST['pCITAnormalidades6'])?$_REQUEST['pCITAnormalidades6']:null;
    $pCITAnormalidadesGlandulares1 = isset($_REQUEST['pCITAnormalidadesGlandulares1'])?$_REQUEST['pCITAnormalidadesGlandulares1']:null;
    $pCITAnormalidadesGlandulares2 = isset($_REQUEST['pCITAnormalidadesGlandulares2'])?$_REQUEST['pCITAnormalidadesGlandulares2']:null;
    $pCITAnormalidadesGlandulares3 = isset($_REQUEST['pCITAnormalidadesGlandulares3'])?$_REQUEST['pCITAnormalidadesGlandulares3']:null;
    $pCITAnormalidadesGlandulares4 = isset($_REQUEST['pCITAnormalidadesGlandulares4'])?$_REQUEST['pCITAnormalidadesGlandulares4']:null;
    $pCITAnormalidadesGlandulares5 = isset($_REQUEST['pCITAnormalidadesGlandulares5'])?$_REQUEST['pCITAnormalidadesGlandulares5']:null;
    $pCITAnormalidadesGlandulares6 = isset($_REQUEST['pCITAnormalidadesGlandulares6'])?$_REQUEST['pCITAnormalidadesGlandulares6']:null;
    $pCITAnormalidadesGlandulares7 = isset($_REQUEST['pCITAnormalidadesGlandulares7'])?$_REQUEST['pCITAnormalidadesGlandulares7']:null;
    $pCITAnormalidadesGlandulares8 = isset($_REQUEST['pCITAnormalidadesGlandulares8'])?$_REQUEST['pCITAnormalidadesGlandulares8']:null;
    $pCITAnormalidadesGlandulares9 = isset($_REQUEST['pCITAnormalidadesGlandulares9'])?$_REQUEST['pCITAnormalidadesGlandulares9']:null;
    $pCITAnormalidadesGlandulares10 = isset($_REQUEST['pCITAnormalidadesGlandulares10'])?$_REQUEST['pCITAnormalidadesGlandulares10']:null;
    $pCITAnormalidadesGlandulares11 = isset($_REQUEST['pCITAnormalidadesGlandulares11'])?$_REQUEST['pCITAnormalidadesGlandulares11']:null;
    $pCITObservacionesRes = isset($_REQUEST['pCITObservacionesRes'])?$_REQUEST['pCITObservacionesRes']:null;
    $pCITProflectura = isset($_REQUEST['pCITProflectura'])?$_REQUEST['pCITProflectura']:null;
    $pCITNombreLectura = isset($_REQUEST['pCITNombreLectura'])?$_REQUEST['pCITNombreLectura']:null;
    $pCITRegistroLectura = isset($_REQUEST['pCITRegistroLectura'])?$_REQUEST['pCITRegistroLectura']:null;
    $pCITFechaLectura = isset($_REQUEST['pCITFechaLectura'])?$_REQUEST['pCITFechaLectura']:null;
    $pCITProflectura2 = isset($_REQUEST['pCITProflectura2'])?$_REQUEST['pCITProflectura2']:null;
    $pCITNombreLectura2 = isset($_REQUEST['pCITNombreLectura2'])?$_REQUEST['pCITNombreLectura2']:null;
    $pCITRegistroLectura2 = isset($_REQUEST['pCITRegistroLectura2'])?$_REQUEST['pCITRegistroLectura2']:null;
    $pCITFechaLectura2 = isset($_REQUEST['pCITFechaLectura2'])?$_REQUEST['pCITFechaLectura2']:null;
    $pCITFechaEntregaRes = isset($_REQUEST['pCITFechaEntregaRes'])?$_REQUEST['pCITFechaEntregaRes']:null;
    $pUsuario = isset($_REQUEST['pUsuario'])?$_REQUEST['pUsuario']:null;
    if($pAutorizacion == null || $pAutorizacion == ""){
        $pAutorizacion = "NA";
    }
    $pCambiaCliente = isset($_REQUEST['pCambiaCliente'])?$_REQUEST['pCambiaCliente']:"NA";
    $pResultadoCitologia4505 = isset($_REQUEST['pResultadoCitologia4505'])?$_REQUEST['pResultadoCitologia4505']:null;
    $pCalidadMuestraCitologia4505 = isset($_REQUEST['pCalidadMuestraCitologia4505'])?$_REQUEST['pCalidadMuestraCitologia4505']:null;
    $pCodIPSTomaCitologia4505 = isset($_REQUEST['pCodIPSTomaCitologia4505'])?$_REQUEST['pCodIPSTomaCitologia4505']:null;
    $gBaseDatos = new ofiMySQLi();
    $gBaseDatos->conectar();
    $qry = "CALL sp_asistencial_add_evolucion('" . $pEmpresa . "','" . $pIPS . "','" . $pPaciente . "','" . $pProfesional . "','" . $pCAS . "','" . $pConsecutivoDetalle . "','" . $pidPlantillaHC . "',\"" . $pFechaAtencion . "\",\"" . $pHoraApertura . "\",\"" . $pActividad . "\",\"" . $pPlantilla . "\",\"" . $pRutaRptHC . "\",\"" . $pRutaRptMx . "\",\"" . $pRutaRptExa . "\",\"" . $pRutaRptRem . "\",\"" . $pEvolucion . "\",\"" . $pDiagppal . "\",\"" . $pDiagrel1 . "\",\"" . $pDiagrel2 . "\",\"" . $pDiagrel3 . "\",\"" . $pTipodiag . "\",\"" . $pFinalidad . "\",\"" . $pCausa . "\",\"" . $pAmbito . "\",\"" . $pFinalidadProced . "\",\"" . $pPersonalAtiende . "\",\"" . $pFormaActo . "\",'" . $pUsuario . "','" . $pIdCliente . "','" . $pIdPlan . "','" . $pIdSubPlan . "','" . $pIdContrato . "',\"" . $pAutorizacion . "\",\"" . $pCambiaCliente . "\")";
    //echo $qry;
    if(@mysqli_query($gBaseDatos->ConexionID, $qry)){
        $gBaseDatos->cerrar();
        $gBaseDatos = new ofiMySQLi();
        $gBaseDatos->conectar();
        $qry = "CALL sp_asistencial_add_evolucion_citologia('" . $pPaciente . "','" . $pCAS . "','" . $pConsecutivoDetalle . "',\"" . $pCITFecCitologia . "\",\"" . $pCITLactancia . "\",\"" . $pCITFecUltMestruacion . "\",'" . $pCITGestaciones . "','" . $pCITPartos . "','" . $pCITAbortos . "',\"" . $pCITEmbarazoActual . "\",\"" . $pCITMetodoPlanifica . "\",\"" . $pCITTiempoUso . "\",\"" . $pCITFecUltCitologia . "\",\"" . $pCITResultadoCitologia . "\",\"" . $pCITCauterizacion . "\",\"" . $pCITCauterizacionFec . "\",\"" . $pCITHisterectomia . "\",\"" . $pCITHisterectomiaFec . "\",\"" . $pCITVaporizacion . "\",\"" . $pCITVaporizacionFec . "\",\"" . $pCITConizacion . "\",\"" . $pCITConizacionFec . "\",\"" . $pCITCrioterapia . "\",\"" . $pCITCrioterapiaFec . "\",\"" . $pCITRadioterapia . "\",\"" . $pCITRadioterapiaFec . "\",\"" . $pCITTtoHormonal . "\",\"" . $pCITTtoHormonalFec . "\",\"" . $pCITBiopsia . "\",\"" . $pCITBiopsiaFec . "\",\"" . $pCITColposcopia . "\",\"" . $pCITColposcopiaFec . "\",\"" . $pCITAusente . "\",\"" . $pCITSano . "\",\"" . $pCITAtrofico . "\",\"" . $pCITCongestivo . "\",\"" . $pCITUlcerado . "\",\"" . $pCITPolipo . "\",\"" . $pCITMasa . "\",\"" . $pCITObservacionesToma . "\",\"" . $pCITCalidad1 . "\",\"" . $pCITCalidad2 . "\",\"" . $pCITCalidad3 . "\",\"" . $pCITCalidad4 . "\",\"" . $pCITCausa . "\",\"" . $pCITCategorizacion1 . "\",\"" . $pCITCategorizacion2 . "\",\"" . $pCITMicroorganismos1 . "\",\"" . $pCITMicroorganismos2 . "\",\"" . $pCITMicroorganismos3 . "\",\"" . $pCITMicroorganismos4 . "\",\"" . $pCITMicroorganismos5 . "\",\"" . $pCITMicroorganismos6 . "\",\"" . $pCITOtrosHallazgos1 . "\",\"" . $pCITOtrosHallazgos2 . "\",\"" . $pCITOtrosHallazgos3 . "\",\"" . $pCITOtrosHallazgos4 . "\",\"" . $pCITOtrosHallazgos5 . "\",\"" . $pCITOtrosHallazgos6 . "\",\"" . $pCITAnormalidades1 . "\",\"" . $pCITAnormalidades2 . "\",\"" . $pCITAnormalidades3 . "\",\"" . $pCITAnormalidades4 . "\",\"" . $pCITAnormalidades5 . "\",\"" . $pCITAnormalidades6 . "\",\"" . $pCITAnormalidadesGlandulares1 . "\",\"" . $pCITAnormalidadesGlandulares2 . "\",\"" . $pCITAnormalidadesGlandulares3 . "\",\"" . $pCITAnormalidadesGlandulares4 . "\",\"" . $pCITAnormalidadesGlandulares5 . "\",\"" . $pCITAnormalidadesGlandulares6 . "\",\"" . $pCITAnormalidadesGlandulares7 . "\",\"" . $pCITAnormalidadesGlandulares8 . "\",\"" . $pCITAnormalidadesGlandulares9 . "\",\"" . $pCITAnormalidadesGlandulares10 . "\",\"" . $pCITAnormalidadesGlandulares11 . "\",\"" . $pCITObservacionesRes . "\",\"" . $pCITProflectura . "\",\"" . $pCITNombreLectura . "\",\"" . $pCITRegistroLectura . "\",\"" . $pCITFechaLectura . "\",\"" . $pCITProflectura2 . "\",\"" . $pCITNombreLectura2 . "\",\"" . $pCITRegistroLectura2 . "\",\"" . $pCITFechaLectura2 . "\",\"" . $pCITFechaEntregaRes . "\",'" . $pUsuario . "')";
        //echo $qry;
        if(@mysqli_query($gBaseDatos->ConexionID, $qry)){
            $gBaseDatos->cerrar();
            echo "{success: true, requestedId:'1'}"; //Temporal
            /*$qry = "CALL sp_asistencial_citologia_4505_update('" . $pPaciente . "',\"" . $pCITFecCitologia . "\",'" . $pResultadoCitologia4505 . "','" . $pCalidadMuestraCitologia4505 . "','" . $pCodIPSTomaCitologia4505 . "')";
            //echo $qry;
            $gBaseDatos = new ofiMySQLi();
            $gBaseDatos->conectar();
            if(@mysqli_query($gBaseDatos->ConexionID, $qry)){
                echo "{success: true, requestedId:'1'}";
                $gBaseDatos->cerrar();
            }else{
                echo "{success: true, requestedId:'0'}";
                $gBaseDatos->cerrar();
            }*/
        }else{
           echo "{success: true, requestedId:'0'}";
           $gBaseDatos->cerrar();
        }
    }else{
       echo "{success: true, requestedId:'0'}";
       $gBaseDatos->cerrar();
    }
}

function ModificarTomaCitologia()
{

    $pEmpresa = isset($_REQUEST['pEmpresa'])?$_REQUEST['pEmpresa']:0;
    $pIPS = isset($_REQUEST['pIPS'])?$_REQUEST['pIPS']:0;
    $pPaciente = isset($_REQUEST['pPaciente'])?$_REQUEST['pPaciente']:0;
    //$pProfesional = isset($_REQUEST['pProfesional'])?$_REQUEST['pProfesional']:0;
    $pProfesional = $_SESSION['ID_PROFESIONAL_HC'];
    $pCAS = isset($_REQUEST['pCAS'])?$_REQUEST['pCAS']:0;
    $pConsecutivoDetalle = isset($_REQUEST['pConsecutivoDetalle'])?$_REQUEST['pConsecutivoDetalle']:0;
    $pFechaAtencion = isset($_REQUEST['pFechaAtencion'])?$_REQUEST['pFechaAtencion']:null;
    $pHoraApertura = isset($_REQUEST['pHoraApertura'])?$_REQUEST['pHoraApertura']:null;
    $pActividad = isset($_REQUEST['pActividad'])?$_REQUEST['pActividad']:null;
    $pPlantilla = isset($_REQUEST['pPlantilla'])?$_REQUEST['pPlantilla']:null;
    $pRutaRptHC = isset($_REQUEST['pRutaRptHC'])?$_REQUEST['pRutaRptHC']:null;
    $pRutaRptMx = isset($_REQUEST['pRutaRptMx'])?$_REQUEST['pRutaRptMx']:null;
    $pRutaRptExa = isset($_REQUEST['pRutaRptExa'])?$_REQUEST['pRutaRptExa']:null;
    $pRutaRptRem = isset($_REQUEST['pRutaRptRem'])?$_REQUEST['pRutaRptRem']:null;
    $contenido = isset($_REQUEST['CAMPOS'])?$_REQUEST['CAMPOS']:null;
    $pEvolucion = utf8_encode(str_replace('"', '""',nl2br($contenido)));
    $pDiagppal = isset($_REQUEST['pDiagppal'])?$_REQUEST['pDiagppal']:null;
    $pDiagrel1 = isset($_REQUEST['pDiagrel1'])?$_REQUEST['pDiagrel1']:null;
    $pDiagrel2 = isset($_REQUEST['pDiagrel2'])?$_REQUEST['pDiagrel2']:null;
    $pDiagrel3 = isset($_REQUEST['pDiagrel3'])?$_REQUEST['pDiagrel3']:null;
    $pTipodiag = isset($_REQUEST['pTipodiag'])?$_REQUEST['pTipodiag']:null;
    $pFinalidad = isset($_REQUEST['pFinalidad'])?$_REQUEST['pFinalidad']:null;
    $pCausa = isset($_REQUEST['pCausa'])?$_REQUEST['pCausa']:null;
    $pAmbito = isset($_REQUEST['pAmbito'])?$_REQUEST['pAmbito']:null;
    $pFinalidadProced = isset($_REQUEST['pFinalidadProced'])?$_REQUEST['pFinalidadProced']:null;
    $pPersonalAtiende = isset($_REQUEST['pPersonalAtiende'])?$_REQUEST['pPersonalAtiende']:null;
    $pFormaActo = isset($_REQUEST['pFormaActo'])?$_REQUEST['pFormaActo']:null;
    $pUsuario = isset($_REQUEST['pUsuario'])?$_REQUEST['pUsuario']:0;
    $pIdCliente = isset($_REQUEST['pIdCliente'])?$_REQUEST['pIdCliente']:0;
    $pIdPlan = isset($_REQUEST['pIdPlan'])?$_REQUEST['pIdPlan']:0;
    $pIdSubPlan = isset($_REQUEST['pIdSubPlan'])?$_REQUEST['pIdSubPlan']:0;
    $pIdContrato = isset($_REQUEST['pIdContrato'])?$_REQUEST['pIdContrato']:0;
    $pAutorizacion = isset($_REQUEST['pAutorizacion'])?$_REQUEST['pAutorizacion']:null;
    $pCITFecCitologia = isset($_REQUEST['pCITFecCitologia'])?$_REQUEST['pCITFecCitologia']:null;
    $pCITLactancia = isset($_REQUEST['pCITLactancia'])?$_REQUEST['pCITLactancia']:null;
    $pCITFecUltMestruacion = isset($_REQUEST['pCITFecUltMestruacion'])?$_REQUEST['pCITFecUltMestruacion']:null;
    $pCITGestaciones = isset($_REQUEST['pCITGestaciones'])?$_REQUEST['pCITGestaciones']:null;
    $pCITPartos = isset($_REQUEST['pCITPartos'])?$_REQUEST['pCITPartos']:null;
    $pCITAbortos = isset($_REQUEST['pCITAbortos'])?$_REQUEST['pCITAbortos']:null;
    $pCITEmbarazoActual = isset($_REQUEST['pCITEmbarazoActual'])?$_REQUEST['pCITEmbarazoActual']:null;
    $pCITMetodoPlanifica = isset($_REQUEST['pCITMetodoPlanifica'])?$_REQUEST['pCITMetodoPlanifica']:null;
    $pCITTiempoUso = isset($_REQUEST['pCITTiempoUso'])?$_REQUEST['pCITTiempoUso']:null;
    $pCITFecUltCitologia = isset($_REQUEST['pCITFecUltCitologia'])?$_REQUEST['pCITFecUltCitologia']:null;
    $pCITResultadoCitologia = isset($_REQUEST['pCITResultadoCitologia'])?$_REQUEST['pCITResultadoCitologia']:null;
    $pCITCauterizacion = isset($_REQUEST['pCITCauterizacion'])?$_REQUEST['pCITCauterizacion']:null;
    $pCITCauterizacionFec = isset($_REQUEST['pCITCauterizacionFec'])?$_REQUEST['pCITCauterizacionFec']:null;
    $pCITHisterectomia = isset($_REQUEST['pCITHisterectomia'])?$_REQUEST['pCITHisterectomia']:null;
    $pCITHisterectomiaFec = isset($_REQUEST['pCITHisterectomiaFec'])?$_REQUEST['pCITHisterectomiaFec']:null;
    $pCITVaporizacion = isset($_REQUEST['pCITVaporizacion'])?$_REQUEST['pCITVaporizacion']:null;
    $pCITVaporizacionFec = isset($_REQUEST['pCITVaporizacionFec'])?$_REQUEST['pCITVaporizacionFec']:null;
    $pCITConizacion = isset($_REQUEST['pCITConizacion'])?$_REQUEST['pCITConizacion']:null;
    $pCITConizacionFec = isset($_REQUEST['pCITConizacionFec'])?$_REQUEST['pCITConizacionFec']:null;
    $pCITCrioterapia = isset($_REQUEST['pCITCrioterapia'])?$_REQUEST['pCITCrioterapia']:null;
    $pCITCrioterapiaFec = isset($_REQUEST['pCITCrioterapiaFec'])?$_REQUEST['pCITCrioterapiaFec']:null;
    $pCITRadioterapia = isset($_REQUEST['pCITRadioterapia'])?$_REQUEST['pCITRadioterapia']:null;
    $pCITRadioterapiaFec = isset($_REQUEST['pCITRadioterapiaFec'])?$_REQUEST['pCITRadioterapiaFec']:null;
    $pCITTtoHormonal = isset($_REQUEST['pCITTtoHormonal'])?$_REQUEST['pCITTtoHormonal']:null;
    $pCITTtoHormonalFec = isset($_REQUEST['pCITTtoHormonalFec'])?$_REQUEST['pCITTtoHormonalFec']:null;
    $pCITBiopsia = isset($_REQUEST['pCITBiopsia'])?$_REQUEST['pCITBiopsia']:null;
    $pCITBiopsiaFec = isset($_REQUEST['pCITBiopsiaFec'])?$_REQUEST['pCITBiopsiaFec']:null;
    $pCITColposcopia = isset($_REQUEST['pCITColposcopia'])?$_REQUEST['pCITColposcopia']:null;
    $pCITColposcopiaFec = isset($_REQUEST['pCITColposcopiaFec'])?$_REQUEST['pCITColposcopiaFec']:null;
    $pCITAusente = isset($_REQUEST['pCITAusente'])?$_REQUEST['pCITAusente']:null;
    $pCITSano = isset($_REQUEST['pCITSano'])?$_REQUEST['pCITSano']:null;
    $pCITAtrofico = isset($_REQUEST['pCITAtrofico'])?$_REQUEST['pCITAtrofico']:null;
    $pCITCongestivo = isset($_REQUEST['pCITCongestivo'])?$_REQUEST['pCITCongestivo']:null;
    $pCITUlcerado = isset($_REQUEST['pCITUlcerado'])?$_REQUEST['pCITUlcerado']:null;
    $pCITPolipo = isset($_REQUEST['pCITPolipo'])?$_REQUEST['pCITPolipo']:null;
    $pCITMasa = isset($_REQUEST['pCITMasa'])?$_REQUEST['pCITMasa']:null;
    $pCITObservacionesToma = isset($_REQUEST['pCITObservacionesToma'])?$_REQUEST['pCITObservacionesToma']:null;
    $pCITCalidad1 = isset($_REQUEST['pCITCalidad1'])?$_REQUEST['pCITCalidad1']:null;
    $pCITCalidad2 = isset($_REQUEST['pCITCalidad2'])?$_REQUEST['pCITCalidad2']:null;
    $pCITCalidad3 = isset($_REQUEST['pCITCalidad3'])?$_REQUEST['pCITCalidad3']:null;
    $pCITCalidad4 = isset($_REQUEST['pCITCalidad4'])?$_REQUEST['pCITCalidad4']:null;
    $pCITCausa = isset($_REQUEST['pCITCausa'])?$_REQUEST['pCITCausa']:null;
    $pCITCategorizacion1 = isset($_REQUEST['pCITCategorizacion1'])?$_REQUEST['pCITCategorizacion1']:null;
    $pCITCategorizacion2 = isset($_REQUEST['pCITCategorizacion2'])?$_REQUEST['pCITCategorizacion2']:null;
    $pCITMicroorganismos1 = isset($_REQUEST['pCITMicroorganismos1'])?$_REQUEST['pCITMicroorganismos1']:null;
    $pCITMicroorganismos2 = isset($_REQUEST['pCITMicroorganismos2'])?$_REQUEST['pCITMicroorganismos2']:null;
    $pCITMicroorganismos3 = isset($_REQUEST['pCITMicroorganismos3'])?$_REQUEST['pCITMicroorganismos3']:null;
    $pCITMicroorganismos4 = isset($_REQUEST['pCITMicroorganismos4'])?$_REQUEST['pCITMicroorganismos4']:null;
    $pCITMicroorganismos5 = isset($_REQUEST['pCITMicroorganismos5'])?$_REQUEST['pCITMicroorganismos5']:null;
    $pCITMicroorganismos6 = isset($_REQUEST['pCITMicroorganismos6'])?$_REQUEST['pCITMicroorganismos6']:null;
    $pCITOtrosHallazgos1 = isset($_REQUEST['pCITOtrosHallazgos1'])?$_REQUEST['pCITOtrosHallazgos1']:null;
    $pCITOtrosHallazgos2 = isset($_REQUEST['pCITOtrosHallazgos2'])?$_REQUEST['pCITOtrosHallazgos2']:null;
    $pCITOtrosHallazgos3 = isset($_REQUEST['pCITOtrosHallazgos3'])?$_REQUEST['pCITOtrosHallazgos3']:null;
    $pCITOtrosHallazgos4 = isset($_REQUEST['pCITOtrosHallazgos4'])?$_REQUEST['pCITOtrosHallazgos4']:null;
    $pCITOtrosHallazgos5 = isset($_REQUEST['pCITOtrosHallazgos5'])?$_REQUEST['pCITOtrosHallazgos5']:null;
    $pCITOtrosHallazgos6 = isset($_REQUEST['pCITOtrosHallazgos6'])?$_REQUEST['pCITOtrosHallazgos6']:null;
    $pCITAnormalidades1 = isset($_REQUEST['pCITAnormalidades1'])?$_REQUEST['pCITAnormalidades1']:null;
    $pCITAnormalidades2 = isset($_REQUEST['pCITAnormalidades2'])?$_REQUEST['pCITAnormalidades2']:null;
    $pCITAnormalidades3 = isset($_REQUEST['pCITAnormalidades3'])?$_REQUEST['pCITAnormalidades3']:null;
    $pCITAnormalidades4 = isset($_REQUEST['pCITAnormalidades4'])?$_REQUEST['pCITAnormalidades4']:null;
    $pCITAnormalidades5 = isset($_REQUEST['pCITAnormalidades5'])?$_REQUEST['pCITAnormalidades5']:null;
    $pCITAnormalidades6 = isset($_REQUEST['pCITAnormalidades6'])?$_REQUEST['pCITAnormalidades6']:null;
    $pCITAnormalidadesGlandulares1 = isset($_REQUEST['pCITAnormalidadesGlandulares1'])?$_REQUEST['pCITAnormalidadesGlandulares1']:null;
    $pCITAnormalidadesGlandulares2 = isset($_REQUEST['pCITAnormalidadesGlandulares2'])?$_REQUEST['pCITAnormalidadesGlandulares2']:null;
    $pCITAnormalidadesGlandulares3 = isset($_REQUEST['pCITAnormalidadesGlandulares3'])?$_REQUEST['pCITAnormalidadesGlandulares3']:null;
    $pCITAnormalidadesGlandulares4 = isset($_REQUEST['pCITAnormalidadesGlandulares4'])?$_REQUEST['pCITAnormalidadesGlandulares4']:null;
    $pCITAnormalidadesGlandulares5 = isset($_REQUEST['pCITAnormalidadesGlandulares5'])?$_REQUEST['pCITAnormalidadesGlandulares5']:null;
    $pCITAnormalidadesGlandulares6 = isset($_REQUEST['pCITAnormalidadesGlandulares6'])?$_REQUEST['pCITAnormalidadesGlandulares6']:null;
    $pCITAnormalidadesGlandulares7 = isset($_REQUEST['pCITAnormalidadesGlandulares7'])?$_REQUEST['pCITAnormalidadesGlandulares7']:null;
    $pCITAnormalidadesGlandulares8 = isset($_REQUEST['pCITAnormalidadesGlandulares8'])?$_REQUEST['pCITAnormalidadesGlandulares8']:null;
    $pCITAnormalidadesGlandulares9 = isset($_REQUEST['pCITAnormalidadesGlandulares9'])?$_REQUEST['pCITAnormalidadesGlandulares9']:null;
    $pCITAnormalidadesGlandulares10 = isset($_REQUEST['pCITAnormalidadesGlandulares10'])?$_REQUEST['pCITAnormalidadesGlandulares10']:null;
    $pCITAnormalidadesGlandulares11 = isset($_REQUEST['pCITAnormalidadesGlandulares11'])?$_REQUEST['pCITAnormalidadesGlandulares11']:null;
    $pCITObservacionesRes = isset($_REQUEST['pCITObservacionesRes'])?$_REQUEST['pCITObservacionesRes']:null;
    $pCITProflectura = isset($_REQUEST['pCITProflectura'])?$_REQUEST['pCITProflectura']:null;
    $pCITNombreLectura = isset($_REQUEST['pCITNombreLectura'])?$_REQUEST['pCITNombreLectura']:null;
    $pCITRegistroLectura = isset($_REQUEST['pCITRegistroLectura'])?$_REQUEST['pCITRegistroLectura']:null;
    $pCITFechaLectura = isset($_REQUEST['pCITFechaLectura'])?$_REQUEST['pCITFechaLectura']:null;
    $pCITProflectura2 = isset($_REQUEST['pCITProflectura2'])?$_REQUEST['pCITProflectura2']:null;
    $pCITNombreLectura2 = isset($_REQUEST['pCITNombreLectura2'])?$_REQUEST['pCITNombreLectura2']:null;
    $pCITRegistroLectura2 = isset($_REQUEST['pCITRegistroLectura2'])?$_REQUEST['pCITRegistroLectura2']:null;
    $pCITFechaLectura2 = isset($_REQUEST['pCITFechaLectura2'])?$_REQUEST['pCITFechaLectura2']:null;
    $pCITFechaEntregaRes = isset($_REQUEST['pCITFechaEntregaRes'])?$_REQUEST['pCITFechaEntregaRes']:null;
    $pResultadoCitologia4505 = isset($_REQUEST['pResultadoCitologia4505'])?$_REQUEST['pResultadoCitologia4505']:null;
    $pCalidadMuestraCitologia4505 = isset($_REQUEST['pCalidadMuestraCitologia4505'])?$_REQUEST['pCalidadMuestraCitologia4505']:null;
    $pCodIPSTomaCitologia4505 = isset($_REQUEST['pCodIPSTomaCitologia4505'])?$_REQUEST['pCodIPSTomaCitologia4505']:null;
    $pUsuario = isset($_REQUEST['pUsuario'])?$_REQUEST['pUsuario']:null;
    if($pAutorizacion == null || $pAutorizacion == ""){
        $pAutorizacion = "NA";
    }
    $pCambiaCliente = isset($_REQUEST['pCambiaCliente'])?$_REQUEST['pCambiaCliente']:"NA";
    $gBaseDatos = new ofiMySQLi();
    $gBaseDatos->conectar();
    $qry = "CALL sp_asistencial_edit_evolucion('" . $pEmpresa . "','" . $pIPS . "','" . $pPaciente . "','" . $pProfesional . "','" . $pCAS . "','" . $pConsecutivoDetalle . "',\"" . $pFechaAtencion . "\",\"" . $pHoraApertura . "\",\"" . $pActividad . "\",\"" . $pPlantilla . "\",\"" . $pEvolucion . "\",\"" . $pDiagppal . "\",\"" . $pDiagrel1 . "\",\"" . $pDiagrel2 . "\",\"" . $pDiagrel3 . "\",\"" . $pTipodiag . "\",\"" . $pFinalidad . "\",\"" . $pCausa . "\",\"" . $pAmbito . "\",\"" . $pFinalidadProced . "\",\"" . $pPersonalAtiende . "\",\"" . $pFormaActo . "\",'" . $pUsuario . "','" . $pIdCliente . "','" . $pIdPlan . "','" . $pIdSubPlan . "','" . $pIdContrato . "',\"" . $pAutorizacion . "\",\"" . $pCambiaCliente . "\")";
    //echo $qry;
    if(@mysqli_query($gBaseDatos->ConexionID, $qry)){
        $gBaseDatos->cerrar();
        $gBaseDatos = new ofiMySQLi();
        $gBaseDatos->conectar();
        $qry = "CALL sp_asistencial_edit_evolucion_citologia('" . $pPaciente . "','" . $pCAS . "','" . $pConsecutivoDetalle . "',\"" . $pCITFecCitologia . "\",\"" . $pCITLactancia . "\",\"" . $pCITFecUltMestruacion . "\",'" . $pCITGestaciones . "','" . $pCITPartos . "','" . $pCITAbortos . "',\"" . $pCITEmbarazoActual . "\",\"" . $pCITMetodoPlanifica . "\",\"" . $pCITTiempoUso . "\",\"" . $pCITFecUltCitologia . "\",\"" . $pCITResultadoCitologia . "\",\"" . $pCITCauterizacion . "\",\"" . $pCITCauterizacionFec . "\",\"" . $pCITHisterectomia . "\",\"" . $pCITHisterectomiaFec . "\",\"" . $pCITVaporizacion . "\",\"" . $pCITVaporizacionFec . "\",\"" . $pCITConizacion . "\",\"" . $pCITConizacionFec . "\",\"" . $pCITCrioterapia . "\",\"" . $pCITCrioterapiaFec . "\",\"" . $pCITRadioterapia . "\",\"" . $pCITRadioterapiaFec . "\",\"" . $pCITTtoHormonal . "\",\"" . $pCITTtoHormonalFec . "\",\"" . $pCITBiopsia . "\",\"" . $pCITBiopsiaFec . "\",\"" . $pCITColposcopia . "\",\"" . $pCITColposcopiaFec . "\",\"" . $pCITAusente . "\",\"" . $pCITSano . "\",\"" . $pCITAtrofico . "\",\"" . $pCITCongestivo . "\",\"" . $pCITUlcerado . "\",\"" . $pCITPolipo . "\",\"" . $pCITMasa . "\",\"" . $pCITObservacionesToma . "\",\"" . $pCITCalidad1 . "\",\"" . $pCITCalidad2 . "\",\"" . $pCITCalidad3 . "\",\"" . $pCITCalidad4 . "\",\"" . $pCITCausa . "\",\"" . $pCITCategorizacion1 . "\",\"" . $pCITCategorizacion2 . "\",\"" . $pCITMicroorganismos1 . "\",\"" . $pCITMicroorganismos2 . "\",\"" . $pCITMicroorganismos3 . "\",\"" . $pCITMicroorganismos4 . "\",\"" . $pCITMicroorganismos5 . "\",\"" . $pCITMicroorganismos6 . "\",\"" . $pCITOtrosHallazgos1 . "\",\"" . $pCITOtrosHallazgos2 . "\",\"" . $pCITOtrosHallazgos3 . "\",\"" . $pCITOtrosHallazgos4 . "\",\"" . $pCITOtrosHallazgos5 . "\",\"" . $pCITOtrosHallazgos6 . "\",\"" . $pCITAnormalidades1 . "\",\"" . $pCITAnormalidades2 . "\",\"" . $pCITAnormalidades3 . "\",\"" . $pCITAnormalidades4 . "\",\"" . $pCITAnormalidades5 . "\",\"" . $pCITAnormalidades6 . "\",\"" . $pCITAnormalidadesGlandulares1 . "\",\"" . $pCITAnormalidadesGlandulares2 . "\",\"" . $pCITAnormalidadesGlandulares3 . "\",\"" . $pCITAnormalidadesGlandulares4 . "\",\"" . $pCITAnormalidadesGlandulares5 . "\",\"" . $pCITAnormalidadesGlandulares6 . "\",\"" . $pCITAnormalidadesGlandulares7 . "\",\"" . $pCITAnormalidadesGlandulares8 . "\",\"" . $pCITAnormalidadesGlandulares9 . "\",\"" . $pCITAnormalidadesGlandulares10 . "\",\"" . $pCITAnormalidadesGlandulares11 . "\",\"" . $pCITObservacionesRes . "\",\"" . $pCITProflectura . "\",\"" . $pCITNombreLectura . "\",\"" . $pCITRegistroLectura . "\",\"" . $pCITFechaLectura . "\",\"" . $pCITProflectura2 . "\",\"" . $pCITNombreLectura2 . "\",\"" . $pCITRegistroLectura2 . "\",\"" . $pCITFechaLectura2 . "\",\"" . $pCITFechaEntregaRes . "\",'" . $pUsuario . "')";
        //echo $qry;
        if(@mysqli_query($gBaseDatos->ConexionID, $qry)){
            $gBaseDatos->cerrar();
            $gBaseDatos = new ofiMySQLi();
            $gBaseDatos->conectar();
            $qry = "CALL sp_asistencial_citologia_4505_update('" . $pPaciente . "',\"" . $pCITFecCitologia . "\",'" . $pResultadoCitologia4505 . "','" . $pCalidadMuestraCitologia4505 . "','" . $pCodIPSTomaCitologia4505 . "')";
            //echo $qry;
            if(@mysqli_query($gBaseDatos->ConexionID, $qry)){
                echo "{success: true, requestedId:'1'}";
                $gBaseDatos->cerrar();
            }else{
                echo "{success: true, requestedId:'1'}";
                $gBaseDatos->cerrar();
            }
        }else{
           echo "{success: true, requestedId:'0'}";
           $gBaseDatos->cerrar();
        }
        if(@mysqli_query($gBaseDatos->ConexionID, $qry)){
            echo "{success: true, requestedId:'1'}";
            $gBaseDatos->cerrar();
        }
    }else{
       echo "{success: true, requestedId:'0'}";
        $gBaseDatos->cerrar();
    }
}


function VerHistorialMedicamentosxPaciente(){
    $pPaciente = isset($_REQUEST['pPaciente'])?$_REQUEST['pPaciente']:0;
    $gBaseDatos = new ofiMySQLi();
    $gBaseDatos->conectar();
    $qry = "CALL sp_grid_medicamentoshc_paciente('" . $pPaciente . "')";
    //echo $qry;
    $gBaseDatos->QryID = @mysqli_query($gBaseDatos->ConexionID, $qry);
    $arr = array();
    while($row = @mysqli_fetch_assoc($gBaseDatos->QryID))
    {
        $nRow = $row;
        foreach($row as $key => $val)
        {
            $nRow[$key] = PonerAcentosHTML($val);
        }
        $arr[] = $nRow;
    }
    $gBaseDatos->liberar();
    $gBaseDatos->cerrar();
    $jsonresult = JEncode($arr);
    if (!is_null($jsonresult))
        echo '({"total":"0","results":'. $jsonresult .'})';
}
