<?php

/*
* @category    Controlador Ecopetrol
* @package     OfiClinic Web
* @author      Jorge Ancizar Galeano Ruiz<desarrollo@ofisalud.com>
* @copyright   2010 Jorge Ancizar Galeano Ruiz
* @version     OfiClinic Web 1.0
* @license     COMERCIAL
* @link        http://www.ofisalud.com
* @country     Colombia
* @telephone   3016398114
*/
header("Content-Type: text/plain; charset=UTF-8");
require("../../../core/php/_database.php");
require("../../../core/php/php_functions.php");
session_start();

$task = isset($_REQUEST['task'])?$_REQUEST['task']:null;

switch($task){
    case "SEARCH_MX":
        BuscarMedicamentosEcopetrol();
        break;
    case "GUARDAR_MX":
        GuardarMx();
        break;
    case "GUARDAR_MXECO":
        GuardarEcoMx();
        break;
    case "GUARDAR_SOLEXA_OFICLINIC001":
        GuardarExa();
        break;
    case "ELIMINAR_OFICLINIC_001":
        EliminarExa();
        break;
    case "MODIFICAR_MX":
        ModificarMx();
        break;
    case "MODIFICAR_MXECO":
        ModificarEcoMx();
        break;
    default:
        echo "{failure:true}";
        break;
}

function EliminarExa(){
    $pIdMx = isset($_REQUEST['pIdMx'])?$_REQUEST['pIdMx']:0;
    $gBaseDatos = new ofiMySQLi();
    $gBaseDatos->conectar();
    $qry = "CALL sp_ecopetrol_ofimedical_delsolicitudes('" . $pIdMx . "')";
    if(@mysqli_query($gBaseDatos->ConexionID, $qry))
        echo '1';
    else
        echo '0';
    $gBaseDatos->cerrar();
}

function GuardarExa(){
    $estructura = explode("¬", $_REQUEST['CAMPOS']);
    $gBaseDatos = new ofiMySQLi();
    $gBaseDatos->conectar();
    $qry = "CALL sp_ecopetrol_exa_add(" . spParametros($estructura,"SI") . ")";
    //echo $qry;
    if(@mysqli_query($gBaseDatos->ConexionID, $qry))
        echo "{success: true, requestedId:'1'}";
    else
       echo "{success: true, requestedId:'0'}";
    $gBaseDatos->cerrar();
     
}

function ModificarEcoMx(){
    $estructura = explode("¬", $_REQUEST['CAMPOS']);
    $pIdConsecutivoSolicitud = isset($_REQUEST['pIdConsecutivoSolicitud'])?$_REQUEST['pIdConsecutivoSolicitud']:10;
    $gBaseDatos = new ofiMySQLi();
    $gBaseDatos->conectar();
    $qry = "CALL sp_oficlinic_mxeco_edit(" . spParametros($estructura,"SI") . ",'" . $pIdConsecutivoSolicitud . "')";
    //echo $qry;
    if(@mysqli_query($gBaseDatos->ConexionID, $qry))
        echo "{success: true, requestedId:'1'}";
    else
       echo "{success: true, requestedId:'0'}";
    $gBaseDatos->cerrar();
}

function GuardarEcoMx(){
    $estructura = explode("¬", $_REQUEST['CAMPOS']);
    $gBaseDatos = new ofiMySQLi();
    $gBaseDatos->conectar();
    $qry = "CALL sp_oficlinic_mxeco_add(" . spParametros($estructura,"SI") . ",null)";
    //echo $qry;
    if(@mysqli_query($gBaseDatos->ConexionID, $qry))
        echo "{success: true, requestedId:'1'}";
    else
       echo "{success: true, requestedId:'0'}";
    $gBaseDatos->cerrar();
}

function ModificarMx(){
    $estructura = explode("¬", $_REQUEST['CAMPOS']);
    $pIdConsecutivoSolicitud = isset($_REQUEST['pIdConsecutivoSolicitud'])?$_REQUEST['pIdConsecutivoSolicitud']:10;
    $gBaseDatos = new ofiMySQLi();
    $gBaseDatos->conectar();
    $qry = "CALL sp_oficlinic_mx_edit(" . spParametros($estructura,"SI") . ",'" . $pIdConsecutivoSolicitud . "')";
    //echo $qry;
    if(@mysqli_query($gBaseDatos->ConexionID, $qry))
        echo "{success: true, requestedId:'1'}";
    else
       echo "{success: true, requestedId:'0'}";
    $gBaseDatos->cerrar();
}

function GuardarMx(){
    $estructura = explode("¬", $_REQUEST['CAMPOS']);
    $gBaseDatos = new ofiMySQLi();
    $gBaseDatos->conectar();
    $qry = "CALL sp_oficlinic_mx_add(" . spNomParametros($estructura,"SI") . ",null)";
    echo $qry;
    if(@mysqli_query($gBaseDatos->ConexionID, $qry))
        echo "{success: true, requestedId:'1'}";
    else
       echo "{success: true, requestedId:'0'}";
    $gBaseDatos->cerrar();
}

function BuscarMedicamentosEcopetrol(){
    $pCallBack = isset($_REQUEST['callback'])?$_REQUEST['callback']:"NA";
    $pLimit = isset($_REQUEST['limit'])?$_REQUEST['limit']:10;
    $pStart = isset($_REQUEST['start'])?$_REQUEST['start']:0;
    $pSearch = isset($_REQUEST['query'])?$_REQUEST['query']:null;
    $pAllMx = isset($_REQUEST['pAllMx'])?$_REQUEST['pAllMx']:"0";
    if($pAllMx == "true"){
       $pAllMx = "1"; 
    }else{
        $pAllMx = "0"; 
    }
    $gBaseDatos = new ofiMySQLi();
    $gBaseDatos->conectar();
    $qry = 'CALL sp_oficlinic_mx_listarecopetrol("' . $pSearch . '","' . $pAllMx . '")';
    //echo $qry;
    $gBaseDatos->QryID = @mysqli_query($gBaseDatos->ConexionID, $qry);
    $nbrows = $gBaseDatos->nroRegistros();
    $arr = array();
    while($row = @mysqli_fetch_assoc($gBaseDatos->QryID)){
        $nRow = $row;
        foreach($row as $key => $val)
        {
            $nRow[$key] = utf8_decode(str_replace("\n\n", "\n",preg_replace('/\<br(\s*)?\/?\>/i', "\n",$val)));
        }
        $arr[] = $nRow;
    }
    $gBaseDatos->liberar();
    $gBaseDatos->cerrar();
    $jsonresult = JEncode($arr);
    if (!is_null($jsonresult))
        echo $pCallBack . '({"totalCount":"' . $nbrows . '","data":'. $jsonresult .'})';
    //echo $pCallBack . " - " . $pSearch;
}
?>